<?php
session_start(); // Start the session
require 'db.php'; // Database connection

// Include the Google API client
require 'google-api-php-client/vendor/autoload.php';

// Enable error reporting for debugging
// ini_set('display_errors', 1);
// error_reporting(E_ALL);

// Initialize variables
$error_message = '';
$success_message = '';
$show_modal = false;

// Initialize Google Client
$client = new Google\Client();
$client->setClientId('591255606353-clghmvv0os7s49unhulge7rbel65jpf1.apps.googleusercontent.com');
$client->setClientSecret('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');
$client->setRedirectUri('https://bitvros.com/session/auth/callback.php');
$client->addScope('email');
$client->addScope('profile');

// Handle the OAuth callback
if (isset($_GET['code'])) {
    try {
        // Get the Google access token
        $accessToken = $client->fetchAccessTokenWithAuthCode($_GET['code']);

        if (isset($accessToken['error'])) {
            throw new Exception("Error fetching access token: " . $accessToken['error']);
        }

        // Set the access token to the client
        $client->setAccessToken($accessToken['access_token']);

        // Get the Google user info
        $oauth2Service = new Google\Service\Oauth2($client);
        $userInfo = $oauth2Service->userinfo->get();

        // Get user details
        $google_id = $userInfo->getId();
        $email = $userInfo->getEmail();
        $name = $userInfo->getName();
        $picture = $userInfo->getPicture();

        // Log user details for debugging
        error_log("Google ID: $google_id, Email: $email, Name: $name, Picture: $picture");

        // Check if the user already exists in the database
        $query = "SELECT id, email, google_id, pin FROM users WHERE email = :email";
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':email', $email, PDO::PARAM_STR);
        $stmt->execute();

        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        // Log successful login
        file_put_contents('logs/user_login.log', "User Logged In: " . print_r($user, true) . "\n", FILE_APPEND);

        // If user doesn't exist, register them
        if (!$user) {
            // Set default status as 'hold'
            $status = 'hold';

            // Insert new user into the database
            $query = "INSERT INTO users (email, google_id, name, status, picture) 
                      VALUES (:email, :google_id, :name, :status, :picture)";
            $stmt = $conn->prepare($query);
            $stmt->bindParam(':email', $email, PDO::PARAM_STR);
            $stmt->bindParam(':google_id', $google_id, PDO::PARAM_STR);
            $stmt->bindParam(':name', $name, PDO::PARAM_STR);
            $stmt->bindParam(':status', $status, PDO::PARAM_STR);
            $stmt->bindParam(':picture', $picture, PDO::PARAM_STR);
            $stmt->execute();

            // Get the newly inserted user ID
            $user_id = $conn->lastInsertId();

            // Store user info in session
            $_SESSION['user_id'] = $user_id;
            $_SESSION['user_email'] = $email;
            $_SESSION['user_name'] = $name;
            $_SESSION['user_picture'] = $picture;

            // Set success message and redirect after delay
            $success_message = "Account created successfully! Redirecting to setup your PIN...";
            echo "<script>
                setTimeout(function() {
                    window.location.href = 'pin.php';
                }, 2000);
            </script>";
        } else {
            // Existing user, use the stored ID
            $user_id = $user['id'];

            // Store user info in session
            $_SESSION['user_id'] = $user_id;
            $_SESSION['user_email'] = $email;
            $_SESSION['user_name'] = $name;
            $_SESSION['user_picture'] = $picture;

            // Set success message and redirect based on PIN status
            $success_message = "Welcome back! Redirecting...";
            if (empty($user['pin'])) {
                echo "<script>
                    setTimeout(function() {
                        window.location.href = 'pin.php';
                    }, 2000);
                </script>";
            } else {
                echo "<script>
                    setTimeout(function() {
                        window.location.href = 'verify_pin.php';
                    }, 2000);
                </script>";
            }
        }

    } catch (Exception $e) {
        // Set error message and show modal
        $error_message = 'Authentication failed. Please try again.';
        $show_modal = true;
        // Log the error message
        error_log("Error during OAuth: " . $e->getMessage());
    }
} else {
    $error_message = 'No authorization code received. Please try logging in again.';
    $show_modal = true;
    error_log("No code received from Google OAuth.");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bitvros - Authentication</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #333;
        }

        .container {
            background: white;
            border-radius: 20px;
            padding: 3rem 2rem;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            text-align: center;
            max-width: 400px;
            width: 90%;
            position: relative;
            overflow: hidden;
        }

        .container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #667eea, #764ba2);
        }

        .logo {
            font-size: 2rem;
            font-weight: bold;
            color: #667eea;
            margin-bottom: 1rem;
        }

        .spinner {
            width: 60px;
            height: 60px;
            border: 4px solid #f3f3f3;
            border-top: 4px solid #667eea;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 2rem auto;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .success-icon {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: #4CAF50;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 2rem auto;
            font-size: 1.5rem;
        }

        .error-icon {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: #f44336;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 2rem auto;
            font-size: 1.5rem;
        }

        .message {
            font-size: 1.1rem;
            line-height: 1.6;
            margin-bottom: 2rem;
        }

        .success-message {
            color: #4CAF50;
        }

        .error-message {
            color: #f44336;
        }

        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(5px);
        }

        .modal.show {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background: white;
            margin: auto;
            padding: 2rem;
            border-radius: 15px;
            max-width: 400px;
            width: 90%;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
            text-align: center;
            animation: modalSlideIn 0.3s ease;
        }

        @keyframes modalSlideIn {
            from {
                transform: translateY(-50px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        .btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 25px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 500;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s ease;
            margin: 0.5rem;
        }

        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }

        .btn-secondary {
            background: #6c757d;
        }

        .btn-secondary:hover {
            background: #5a6268;
            box-shadow: 0 5px 15px rgba(108, 117, 125, 0.4);
        }

        .progress-bar {
            width: 100%;
            height: 4px;
            background: #f0f0f0;
            border-radius: 2px;
            overflow: hidden;
            margin: 1rem 0;
        }

        .progress-bar-fill {
            height: 100%;
            background: linear-gradient(90deg, #667eea, #764ba2);
            border-radius: 2px;
            animation: progress 2s ease-in-out;
        }

        @keyframes progress {
            from { width: 0%; }
            to { width: 100%; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="logo">
            <i class="fas fa-shield-alt"></i> Bitvros
        </div>

        <?php if ($success_message): ?>
            <div class="success-icon">
                <i class="fas fa-check"></i>
            </div>
            <div class="message success-message">
                <?php echo htmlspecialchars($success_message); ?>
            </div>
            <div class="progress-bar">
                <div class="progress-bar-fill"></div>
            </div>
        <?php elseif (!$show_modal): ?>
            <div class="spinner"></div>
            <div class="message">
                Processing your authentication...
            </div>
        <?php endif; ?>
    </div>

    <!-- Error Modal -->
    <div id="errorModal" class="modal <?php echo $show_modal ? 'show' : ''; ?>">
        <div class="modal-content">
            <div class="error-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <h2 style="margin-bottom: 1rem; color: #333;">Authentication Error</h2>
            <p class="message error-message">
                <?php echo htmlspecialchars($error_message); ?>
            </p>
            <div style="margin-top: 2rem;">
                <a href="login.php" class="btn">
                    <i class="fas fa-sign-in-alt"></i> Try Login Again
                </a>
                <a href="signup.php" class="btn btn-secondary">
                    <i class="fas fa-user-plus"></i> Sign Up Instead
                </a>
            </div>
            <p style="margin-top: 1rem; font-size: 0.9rem; color: #666;">
                If the problem persists, please contact support.
            </p>
        </div>
    </div>

    <script>
        // Auto-hide success message after 3 seconds if no redirect
        <?php if ($success_message): ?>
        setTimeout(function() {
            const container = document.querySelector('.container');
            if (container) {
                container.style.opacity = '0.8';
            }
        }, 3000);
        <?php endif; ?>

        // Close modal when clicking outside
        document.addEventListener('click', function(event) {
            const modal = document.getElementById('errorModal');
            if (event.target === modal) {
                modal.classList.remove('show');
            }
        });

        // Handle escape key to close modal
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Escape') {
                const modal = document.getElementById('errorModal');
                modal.classList.remove('show');
            }
        });
    </script>
</body>
</html>