<?php
session_start();
require '../vendor/autoload.php'; // Include PHPMailer using Composer's autoload

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require '../db.php'; // Database connection

// Enable error reporting for debugging purposes
ini_set('display_errors', 1);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];

    // Log the received email to track input
    error_log("Received email: " . $email);

    // Check if email exists in the database
    $stmt = $conn->prepare("SELECT id FROM users WHERE email = :email");
    if ($stmt === false) {
        error_log("Error preparing the SQL statement: " . $conn->errorInfo()[2]);
        $_SESSION['message'] = 'Database error. Please try again later.';
        header('Location: forgot_password.php');
        exit();
    }

    // Bind the email parameter using PDO
    $stmt->bindValue(':email', $email, PDO::PARAM_STR);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        // Generate password reset token
        $token = bin2hex(random_bytes(50));
        $user_id = $stmt->fetchColumn();
        $stmt->closeCursor();

        // Log the user ID and token for debugging purposes
        error_log("User ID: " . $user_id . " Token: " . $token);

        // Update the reset_token column in the users table
        $stmt = $conn->prepare("UPDATE users SET reset_token = :token WHERE id = :user_id");
        if ($stmt === false) {
            error_log("Error preparing the SQL update statement: " . $conn->errorInfo()[2]);
            $_SESSION['message'] = 'Database error. Please try again later.';
            header('Location: forgot_password.php');
            exit();
        }

        // Bind the parameters and execute the query
        $stmt->bindValue(':user_id', $user_id, PDO::PARAM_INT);
        $stmt->bindValue(':token', $token, PDO::PARAM_STR);
        $stmt->execute();
        $stmt->closeCursor();

        // Log the email address being sent to
        error_log("Password reset email sent to: " . $email);

        // Send reset email using PHPMailer
        $mail = new PHPMailer(true);
        try {
            // Server settings
            $mail->isSMTP();
            $mail->Host = 'bitvros.com'; // SMTP server (change as needed)
            $mail->SMTPAuth = true;
            $mail->Username = 'noreply@bitvros.com'; // SMTP username (replace with actual)
            $mail->Password = 'Bitv@9034'; // SMTP password (replace with actual)
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port = 587;

            // Recipients
            $mail->setFrom('noreply@bitvros.com', 'Bitvros Wallet');
            $mail->addAddress($email);

            // Content settings: set email format to HTML
            $mail->isHTML(true);
            $mail->Subject = 'Password Reset Request';

            // Create the password reset link
            $resetLink = "http://bitvros.com/session/auth/recover/reset_password.php?token=$token";

            // Build the HTML email body with the logo
            $htmlBody = '
            <html>
            <head>
                <meta charset="UTF-8">
                <title>Password Reset Request</title>
            </head>
            <body>
                <div style="text-align: center; font-family: Arial, sans-serif;">
                    <img src="https://bitvros.com/session/logob.png" alt="Bitvros Logo" style="max-width: 200px; margin-bottom: 20px;">
                    <h2>Password Reset Request</h2>
                    <p>You have requested to reset your password. Click the button below to proceed:</p>
                    <p>
                        <a href="' . $resetLink . '" style="background-color: #513A8F; color: #ffffff; padding: 10px 20px; text-decoration: none; border-radius: 5px;">Reset Password</a>
                    </p>
                    <p>If you did not request a password reset, please ignore this email.</p>
                    <hr>
                    <p style="font-size: small; color: #888;">This email was sent from Bitvros. If you have any questions, please contact our support.</p>
                </div>
            </body>
            </html>
            ';

            // Set the HTML body and a plain text alternative
            $mail->Body = $htmlBody;
            $mail->AltBody = "Password Reset Request\n\nYou have requested to reset your password. Please copy and paste the link below into your browser:\n\n" . $resetLink . "\n\nIf you did not request this, please ignore this email.";

            // Additional headers to help avoid spam filters
            $mail->addCustomHeader('X-Mailer', 'PHP/' . phpversion());
            // Removed custom MessageID to let PHPMailer generate a compliant one automatically

            // Adding a List-Unsubscribe header
            $mail->addCustomHeader('List-Unsubscribe', '<mailto:unsubscribe@bitvros.com>, <' . $resetLink . '>');

            // Optional: If you have DKIM settings, uncomment and fill these in
            // $mail->DKIM_domain = 'bitvros.com';
            // $mail->DKIM_private = '/path/to/private.key';
            // $mail->DKIM_selector = 'default';
            // $mail->DKIM_passphrase = '';
            // $mail->DKIM_identity = $mail->From;

            // Send the email
            $mail->send();

            $_SESSION['message'] = 'A password reset link has been sent to your email.';
            header('Location: forgot_password.php');
            exit();
        } catch (Exception $e) {
            // Log PHPMailer exception error
            error_log('PHPMailer error: ' . $mail->ErrorInfo);
            $_SESSION['message'] = 'Failed to send email. Error: ' . $mail->ErrorInfo;
            header('Location: forgot_password.php');
            exit();
        }
    } else {
        // Log the case when no user is found
        error_log("No user found with the email: " . $email);
        $_SESSION['message'] = 'No user found with that email address.';
        header('Location: forgot_password.php');
        exit();
    }
}
?>