<?php
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

session_start();

// Database connection using PDO
$host = 'localhost';
$db = 'lrbpxbxy_dbv';
$user = 'lrbpxbxy_userv';
$pass = 'WHEagP2O9sOzG9gk';

$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $conn = new PDO($dsn, $user, $pass, $options);
    error_log('Database connection established');
} catch (\PDOException $e) {
    die("Database connection error: " . $e->getMessage());
}

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require '../vendor/autoload.php';

// Get the token from the URL
$token = $_GET['token'] ?? '';

if (!empty($token)) {
    // Check if the token exists and is valid
    $stmt = $conn->prepare("SELECT id, email FROM users WHERE reset_token = :token AND (reset_token_expiry IS NULL OR reset_token_expiry > NOW())");
    $stmt->execute(['token' => $token]);

    if ($stmt->rowCount() == 0) {
        $_SESSION['message'] = "Invalid or expired token.";
        header("Location: ../login.php");
        exit();
    }

    // Fetch user details
    $user = $stmt->fetch();
    $id = $user['id'];
    $email = $user['email'];
    error_log("User details fetched for ID: $id, Email: $email");
} else {
    $_SESSION['message'] = "Token is missing.";
    header("Location: ../login.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_password = $_POST['new_password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';

    if ($new_password !== $confirm_password) {
        $_SESSION['message'] = 'New password and confirm password do not match.';
        header("Location: reset_password.php?token=$token");
        exit();
    }

    // Hash the password
    $new_hashed_password = password_hash($new_password, PASSWORD_BCRYPT);

    if (!$new_hashed_password) {
        $_SESSION['message'] = 'Password hashing failed.';
        header("Location: reset_password.php?token=$token");
        exit();
    }

    // Debugging: Output the hashed password
    error_log("New Hashed Password: $new_hashed_password");

    // Update the password and reset the token
    $stmt = $conn->prepare("UPDATE users SET password = :password, reset_token = NULL, reset_token_expiry = NULL WHERE id = :id AND reset_token = :token");
    if ($stmt->execute([
        'password' => $new_hashed_password,
        'id' => $id,
        'token' => $token
    ])) {
        $_SESSION['message'] = 'Your password has been successfully updated. Please log in again.';

        // Send a confirmation email
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = 'bitvros.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'noreply@bitvros.com';
            $mail->Password = 'Bitv@9034';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port = 587;

            $mail->setFrom('noreply@bitvros.com', 'Bitvros');
            $mail->addAddress($email);

            $mail->isHTML(true);
            $mail->Subject = 'Password Changed Successfully';
            $mail->Body = '<h1>Your password has been successfully updated!</h1><p>If you did not request this change, please contact support immediately.</p>';

            $mail->send();
            error_log("Confirmation email sent to: $email");
        } catch (Exception $e) {
            $_SESSION['message'] = 'Password updated, but email sending failed. Error: ' . $mail->ErrorInfo;
            error_log("Email sending failed: " . $mail->ErrorInfo);
        }

        header("Location: ../login.php");
        exit();
    } else {
        $_SESSION['message'] = 'Failed to update the password. Please try again later.';
        error_log("Failed to update password for user ID: $id");
        header("Location: reset_password.php?token=$token");
        exit();
    }
}
?>
