<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'config.php';

// -------------------------------
// Retrieve dynamic counts from the database
// -------------------------------

// Count total copy traders from the "copy_traders" table
$query_copy_traders = $conn->prepare("SELECT COUNT(*) as total FROM copy_traders");
$query_copy_traders->execute();
$row_copy_traders = $query_copy_traders->fetch(PDO::FETCH_ASSOC);
$total_copy_traders = $row_copy_traders['total'];

// Count total users from the "users" table (unchanged)
$query_users = $conn->prepare("SELECT COUNT(*) as total FROM users");
$query_users->execute();
$row_users = $query_users->fetch(PDO::FETCH_ASSOC);
$total_users = $row_users['total'];

// Count total deposits from the "crypto_withdrawal" table (successful transactions)
$query_deposits = $conn->prepare("SELECT COUNT(*) as total FROM crypto_withdrawal");
$query_deposits->execute();
$row_deposits = $query_deposits->fetch(PDO::FETCH_ASSOC);
$total_deposits = $row_deposits['total'];

// Count total payments from the "payments" table (payments received)
$query_payments = $conn->prepare("SELECT COUNT(*) as total FROM payments");
$query_payments->execute();
$row_payments = $query_payments->fetch(PDO::FETCH_ASSOC);
$total_payments = $row_payments['total'];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Admin Panel - Copy Trader Management</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        /* Global Styling */
        body {
            font-family: 'Arial', sans-serif;
        }

        /* HEADER & NAVIGATION STYLING */
        header {
            background: linear-gradient(to right, #4f46e5, #9333ea);
        }

        .header-container {
            max-width: 1200px;
            margin: 0 auto;
        }

        .header-logo {
            font-size: 2rem;
            font-weight: bold;
            color: #fff;
        }

        .header-links a {
            color: #fff;
            margin-right: 1rem;
            transition: color 0.3s;
        }

        .header-links a:hover {
            color: #d1d5db;
        }

        /* Mobile Menu Styling */
        #mobile-menu a {
            display: block;
            padding: 0.75rem 1rem;
            color: #fff;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            transition: background 0.3s;
        }

        #mobile-menu a:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        /* SIDEBAR STYLING */
        .sidebar {
            background-color: #1f2937;
            color: #9ca3af;
            min-height: 100vh;
            width: 250px;
            padding: 1rem;
            transition: transform 0.3s ease;
        }

        .sidebar a {
            display: block;
            padding: 0.75rem 1rem;
            margin-bottom: 0.5rem;
            border-radius: 0.375rem;
            transition: background 0.3s, color 0.3s;
        }

        .sidebar a:hover {
            background-color: #374151;
            color: #fff;
        }

        /* Hide sidebar on toggle (by default shown on desktop) */
        .sidebar.hidden {
            transform: translateX(-100%);
        }

        /* MAIN CONTENT STYLING */
        .main-content {
            padding: 1rem;
            flex: 1;
        }

        /* DASHBOARD CARDS STYLING */
        .dashboard-card {
            background-color: #fff;
            padding: 1.5rem;
            border-radius: 0.5rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        /* FORM STYLING */
        .form-container {
            background-color: #fff;
            padding: 2rem;
            border-radius: 0.75rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            margin-bottom: 2rem;
        }

        .form-container label {
            display: block;
            margin-bottom: 0.5rem;
            color: #4b5563;
            font-weight: 500;
        }

        .form-container input,
        .form-container textarea,
        .form-container select {
            width: 100%;
            padding: 0.75rem;
            margin-bottom: 1rem;
            border: 1px solid #d1d5db;
            border-radius: 0.375rem;
            transition: border-color 0.3s;
        }

        .form-container input:focus,
        .form-container textarea:focus,
        .form-container select:focus {
            border-color: #4f46e5;
            outline: none;
        }

        .form-container button {
            background-color: #4f46e5;
            color: #fff;
            padding: 0.75rem 1.5rem;
            border-radius: 0.375rem;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .form-container button:hover {
            background-color: #4338ca;
        }

        /* COPY TRADER SLIDER STYLING */
        .slider-container {
            position: relative;
            overflow: hidden;
        }

        .slider-track {
            display: flex;
            gap: 1.25rem;
            overflow-x: auto;
            scroll-snap-type: x mandatory;
            scroll-behavior: smooth;
            padding-bottom: 1rem;
        }

        .slider-track::-webkit-scrollbar {
            height: 8px;
        }

        .slider-track::-webkit-scrollbar-thumb {
            background-color: #ccc;
            border-radius: 10px;
        }

        .slider-track::-webkit-scrollbar-track {
            background-color: #f1f1f1;
        }

        /* COPY TRADER CARD STYLING */
        .slider-card {
            background-color: #fff;
            border-radius: 0.75rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            max-width: 14rem;
            overflow: hidden;
            position: relative;
            display: flex;
            flex-direction: column;
            padding: 1rem;
            scroll-snap-align: start;
        }

        .slider-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 8px rgba(0, 0, 0, 0.2);
        }

        .card-image {
            background-size: cover;
            background-position: center;
            width: 100%;
            height: 100px;
            border-radius: 0.375rem;
        }

        .card-content {
            padding: 0.5rem 0;
            flex: 1;
        }

        .card-name {
            font-size: 1rem;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 0.25rem;
        }

        .card-percentage {
            font-size: 0.875rem;
            color: #4b5563;
            margin-bottom: 0.25rem;
        }

        .card-type {
            font-size: 0.875rem;
            color: #6b7280;
        }

        /* EDIT/DELETE BUTTONS */
        .edit-delete-btns {
            position: absolute;
            top: 0.5rem;
            right: 0.5rem;
            display: flex;
            gap: 0.5rem;
            z-index: 10;
        }

        .edit-delete-btns a {
            font-size: 0.875rem;
            transition: color 0.3s;
        }

        .edit-delete-btns a:hover {
            opacity: 0.8;
        }

        /* SLIDER NAVIGATION BUTTONS */
        .slider-btn {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            background-color: rgba(79, 70, 229, 0.8);
            color: #fff;
            border-radius: 50%;
            padding: 0.5rem;
            z-index: 20;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .slider-container:hover .slider-btn {
            opacity: 1;
        }

        .slider-btn.left-4 {
            left: 0.5rem;
        }

        .slider-btn.right-4 {
            right: 0.5rem;
        }

        /* RESPONSIVE LAYOUT */
        .layout {
            display: flex;
            flex-direction: row;
        }

        @media (max-width: 768px) {
            .layout {
                flex-direction: column;
            }

            .sidebar {
                display: none;
            }

            .header-links {
                display: none;
            }

            #mobile-menu {
                display: block;
            }
        }
    </style>
</head>

<body class="bg-gray-100">
    <!-- HEADER WITH NAVIGATION -->
    <header>
        <div class="header-container mx-auto px-4 py-4 flex justify-between items-center">
            <div class="header-logo">Copy Trade Panel</div>
            <!-- Desktop Navigation Links -->
           
            <!-- Mobile Menu Toggle (Hamburger) -->
            <button id="menu-toggle" class="md:hidden text-white focus:outline-none">
              
            </button>
            <!-- Sidebar Toggle Button (visible on desktop) -->
            <button id="sidebar-toggle" class="hidden md:block text-white ml-4 focus:outline-none">
                Toggle Sidebar
            </button>
        </div>
        <!-- Mobile Navigation Menu -->
        <div id="mobile-menu" class="hidden md:hidden">

]            <a href="manage_copy_traders.php">Manage Copy Traders</a>
            <a href="logout.php">Logout</a>
            <a href="index.php">Admin</a>
        </div>
    </header>

    <!-- LAYOUT: SIDEBAR + MAIN CONTENT -->
    <div class="layout">
        <!-- SIDEBAR (Desktop) -->
        <aside id="sidebar" class="sidebar">
            <nav>
                <a href="index.php">Dashboard</a>
                <a href="kyc.php">KYC</a>
               
                <a href="manage_copy_traders.php">Manage Copy Traders</a>
                <a href="logout.php">Logout</a>
            </nav>
        </aside>

        <!-- MAIN CONTENT AREA -->
        <main class="main-content flex-1">
            <!-- DASHBOARD STATISTICS -->
            <section class="mb-8">
                <h2 class="text-2xl font-bold mb-4">Dashboard Overview</h2>
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div class="dashboard-card">
                        <h3 class="text-xl font-semibold">Copy Traders</h3>
                        <p class="text-gray-600"><?php echo $total_copy_traders; ?></p>
                    </div>
                    <div class="dashboard-card">
                        <h3 class="text-xl font-semibold">Users</h3>
                        <p class="text-gray-600"><?php echo $total_users; ?></p>
                    </div>
                    <div class="dashboard-card">
                        <h3 class="text-xl font-semibold">Deposits</h3>
                        <p class="text-gray-600"><?php echo $total_deposits; ?></p>
                    </div>
                    <div class="dashboard-card">
                        <h3 class="text-xl font-semibold">Payments</h3>
                        <p class="text-gray-600"><?php echo $total_payments; ?></p>
                    </div>
                </div>
            </section>

            <!-- ADD COPY TRADER FORM -->
            <section class="mb-8">
                <h2 class="text-2xl font-bold mb-4">Add a New Copy Trader</h2>
                <div class="form-container">
                    <form action="process_copy_trader.php" method="POST" enctype="multipart/form-data">
                        <div class="mb-4">
                            <label for="trader-name">Trader Name</label>
                            <input type="text" id="trader-name" name="name" placeholder="Enter Trader Name" required>
                        </div>
                        <div class="mb-4">
                            <label for="trader-image">Upload Image</label>
                            <input type="file" id="trader-image" name="image" accept="image/*" required>
                        </div>
                        <div class="mb-4">
                            <label for="trader-percentage">Percentage (%)</label>
                            <input type="number" step="0.01" id="trader-percentage" name="percentage"
                                placeholder="Enter Performance Percentage" required>
                        </div>
                        <div class="mb-4">
                            <label for="trader-type">Type</label>
                          <select id="trader-type" name="type" required>
    <option value="">Select Type</option>
    <option value="Forex">Forex</option>
    <option value="Stocks">Stocks</option>
    <option value="Crypto">Crypto</option>
    <option value="Commodities">Commodities</option>
    <option value="Indices">Indices</option>
    <option value="ETFs">ETFs</option>
    <option value="Futures">Futures</option>
    <option value="Options">Options</option>
    <option value="Bonds">Bonds</option>
    <option value="Precious Metals">Precious Metals</option>
    <option value="Energy">Energy</option>
    <option value="Agriculture">Agriculture</option>
    <option value="Real Estate">Real Estate</option>
    <option value="CFDs">CFDs</option>
    <option value="Derivatives">Derivatives</option>
    <option value="Mutual Funds">Mutual Funds</option>
    <option value="Currencies">Currencies</option>
    <option value="Hedge Funds">Hedge Funds</option>
    <option value="High Frequency Trading">High Frequency Trading</option>
    <option value="Swing Trading">Swing Trading</option>
</select>

                        </div>
                        <button type="submit" name="submit">Add Copy Trader</button>
                    </form>
                </div>
            </section>

            <!-- COPY TRADER SLIDER -->
            <section>
                <h2 class="text-2xl font-bold mb-4">Copy Traders</h2>
                <div id="copyTraderSlider" class="slider-container relative group">
                    <div class="slider-track">
                        <?php
                        // Fetch copy trader entries from the "copy_traders" table
                        $result = $conn->prepare("SELECT * FROM copy_traders ORDER BY created_at DESC");
                        $result->execute();
                        while ($row = $result->fetch(PDO::FETCH_ASSOC)):
                            // Build the image path (assuming the file name is stored in 'image_url')
                            $image_path = 'copy_trader_images/' . basename($row['image_url']);
                        ?>
                        <div class="slider-card">
                            <!-- Cover the entire card with an invisible link for editing -->
                            <a href="edit_copy_trader.php?id=<?= $row['id'] ?>" class="absolute inset-0 z-10"></a>
                            <div class="card-image" style="background-image: url('<?= $image_path ?>');"></div>
                            <div class="card-content">
                                <h3 class="card-name"><?= htmlspecialchars($row['name']) ?></h3>
                                <p class="card-percentage">Performance: <?= htmlspecialchars($row['percentage']) ?>%</p>
                                <p class="card-type">Type: <?= htmlspecialchars($row['type']) ?></p>
                            </div>
                            <div class="edit-delete-btns">
                                <a href="edit_copy_trader.php?id=<?= $row['id'] ?>"
                                    class="text-blue-500 hover:text-blue-700">✏️ Edit</a>
                                <a href="process_copy_trader.php?delete=<?= $row['id'] ?>"
                                    class="text-red-500 hover:text-red-700">🗑️ Delete</a>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>

                    <!-- SLIDER NAVIGATION BUTTONS -->
                    <button class="slider-btn left-4">
                        &larr;
                    </button>
                    <button class="slider-btn right-4">
                        &rarr;
                    </button>
                </div>
            </section>
        </main>
    </div>

    <!-- JAVASCRIPT FOR INTERACTIVITY -->
    <script>
        // Mobile Menu Toggle Script
        const menuToggle = document.getElementById('menu-toggle');
        const mobileMenu = document.getElementById('mobile-menu');
        menuToggle.addEventListener('click', () => {
            mobileMenu.classList.toggle('hidden');
        });

        // Sidebar Toggle Script (for desktop)
        const sidebarToggle = document.getElementById('sidebar-toggle');
        const sidebar = document.getElementById('sidebar');
        sidebarToggle.addEventListener('click', () => {
            sidebar.classList.toggle('hidden');
        });

        // Slider Navigation Script
        const prevButton = document.querySelector('.slider-btn.left-4');
        const nextButton = document.querySelector('.slider-btn.right-4');
        const slider = document.querySelector('.slider-track');

        prevButton.addEventListener('click', () => {
            slider.scrollBy({ left: -300, behavior: 'smooth' });
        });

        nextButton.addEventListener('click', () => {
            slider.scrollBy({ left: 300, behavior: 'smooth' });
        });
    </script>
</body>

</html>