<?php
$pageTitle = "Manage Table";
include 'header.php';
require 'config.php';
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header("Location: login.php");
    exit();
}

if (!isset($_GET['table'])) {
    die("Table not specified.");
}

$table = $_GET['table'];
try {
    $stmt = $conn->prepare("SHOW COLUMNS FROM `$table`");
    $stmt->execute();
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $columnNames = array_map(function($col) { return $col['Field']; }, $columns);
    
    // Reorder columns: prioritize name, email, crypto columns, and balance columns
    $priority = [];
    $others = [];
    foreach ($columnNames as $col) {
        $lowerCol = strtolower($col);
        if (in_array($lowerCol, ['name', 'email']) ||
            strpos($lowerCol, 'crypto') !== false ||
            strpos($lowerCol, 'balance') !== false) {
            $priority[] = $col;
        } else {
            $others[] = $col;
        }
    }
    $orderedColumns = array_merge($priority, $others);
    
    $stmtData = $conn->prepare("SELECT * FROM `$table`");
    $stmtData->execute();
    $data = $stmtData->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}
?>
<main class="p-6 bg-gray-100 min-h-screen">
  <div class="mb-6">
    <h2 class="text-3xl font-semibold text-gray-800">Manage <?= ucfirst($table) ?></h2>
    <p class="text-gray-600">Displaying records from the <span class="font-medium"><?= htmlspecialchars($table) ?></span> table.</p>
  </div>
  <div class="overflow-x-auto bg-white rounded-lg shadow-sm border border-gray-200">
    <table class="min-w-full">
      <thead class="bg-gray-50">
        <tr>
          <!-- Actions column placed at the start -->
          <th class="px-6 py-3 text-left text-xs font-medium text-gray-600 uppercase">Actions</th>
          <?php foreach ($orderedColumns as $col): ?>
            <th class="px-6 py-3 text-left text-xs font-medium text-gray-600 uppercase"><?= htmlspecialchars($col) ?></th>
          <?php endforeach; ?>
        </tr>
      </thead>
      <tbody class="bg-white divide-y divide-gray-100">
        <?php foreach ($data as $row): ?>
          <tr class="hover:bg-gray-50">
            <!-- Actions column at the beginning of each row -->
            <td class="px-6 py-3">
              <div class="flex space-x-2">
                <a href="edit.php?table=<?= urlencode($table) ?>&id=<?= urlencode($row['id']) ?>" class="text-blue-500 hover:text-blue-700 text-sm">
                  <i class="fas fa-edit"></i> Edit
                </a>
                <a href="javascript:void(0);" onclick="confirmDelete('<?= htmlspecialchars($table) ?>', <?= htmlspecialchars($row['id']) ?>)" class="text-red-500 hover:text-red-700 text-sm">
                  <i class="fas fa-trash-alt"></i> Delete
                </a>
              </div>
            </td>
            <?php foreach ($orderedColumns as $col): ?>
              <td class="px-6 py-3 text-sm text-gray-700"><?= htmlspecialchars($row[$col]) ?></td>
            <?php endforeach; ?>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
  <div class="mt-6">
    <a href="insert.php?table=<?= urlencode($table) ?>" class="inline-block bg-green-500 hover:bg-green-600 text-white font-medium px-4 py-2 rounded shadow-sm">
      <i class="fas fa-plus mr-2"></i> Add New Record
    </a>
  </div>
</main>
<script>
  function confirmDelete(table, id) {
    Swal.fire({
      title: 'Are you sure?',
      text: "This record will be permanently deleted.",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#e3342f',
      cancelButtonColor: '#6cb2eb',
      confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
      if (result.isConfirmed) {
        window.location.href = 'delete.php?table=' + table + '&id=' + id;
      }
    });
  }
</script>
<?php include 'footer.php'; ?>
