<?php
session_start();
require 'config.php';
include 'header.php';

// Optional: Check if admin is logged in (customize as needed)
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header("Location: login.php");
    exit();
}

// Retrieve all tables from the database
$tables = [];
try {
    $stmt = $conn->query("SHOW TABLES");
    while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
        $tables[] = $row[0];
    }
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}

// Get record counts for all tables
$tableCounts = [];
$icons = [
    'admins'         => 'fa-user-shield',
    'blogs'          => 'fa-blog',
    'kyc_submissions'=> 'fa-id-card',
    'password_resets'=> 'fa-key',
    'payments'       => 'fa-credit-card',
    'trade'          => 'fa-chart-line',
    'crypto_stakes'   => 'fa-terminal',
    'transactions'   => 'fa-exchange-alt',
    'crypto_withdrawal'    => 'fa-check-double',
    'users'          => 'fa-users',
    'wallets'        => 'fa-wallet'
];

foreach ($tables as $table) {
    try {
        $stmt = $conn->query("SELECT COUNT(*) as count FROM $table");
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $tableCounts[$table] = $result['count'];
    } catch (PDOException $e) {
        $tableCounts[$table] = 'N/A';
    }
}

// Get important statistics
$totalUsers = $tableCounts['users'] ?? 0;
$totalPayments = $tableCounts['payments'] ?? 0;
$totalTransactions = $tableCounts['transactions'] ?? 0;
?>




    <div class="flex flex-1">
      <!-- Sidebar -->
      <nav class="bg-white w-64 shadow-lg hidden md:block">
        <div class="p-4">
          <div class="mb-8">
            <h3 class="text-xs font-semibold text-gray-500 uppercase mb-4">Quick Stats</h3>
            <ul class="space-y-3">
              <li class="flex items-center justify-between text-sm p-2 hover:bg-gray-50 rounded">
                <span><i class="fas fa-users mr-2 text-blue-500"></i> Total Users</span>
                <span class="bg-blue-100 text-blue-800 px-2 py-1 rounded-full"><?= $totalUsers ?></span>
              </li>
              <li class="flex items-center justify-between text-sm p-2 hover:bg-gray-50 rounded">
                <span><i class="fas fa-credit-card mr-2 text-green-500"></i> Payments</span>
                <span class="bg-green-100 text-green-800 px-2 py-1 rounded-full"><?= $totalPayments ?></span>
              </li>
              <li class="flex items-center justify-between text-sm p-2 hover:bg-gray-50 rounded">
                <span><i class="fas fa-exchange-alt mr-2 text-purple-500"></i> Transactions</span>
                <span class="bg-purple-100 text-purple-800 px-2 py-1 rounded-full"><?= $totalTransactions ?></span>
              </li>
            </ul>
          </div>
        </div>
      </nav>

      <!-- Main Content -->
      <main class="flex-1 p-8">
        <div class="max-w-7xl mx-auto">
          <!-- Stats Grid -->
          <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
            <div class="bg-white p-6 rounded-lg shadow-sm">
              <div class="flex items-center justify-between">
                <div>
                  <p class="text-gray-500">Total Users</p>
                  <p class="text-3xl font-bold"><?= $totalUsers ?></p>
                </div>
                <i class="fas fa-users text-4xl text-blue-500"></i>
              </div>
            </div>
            <div class="bg-white p-6 rounded-lg shadow-sm">
              <div class="flex items-center justify-between">
                <div>
                  <p class="text-gray-500">Total Payments</p>
                  <p class="text-3xl font-bold"><?= $totalPayments ?></p>
                </div>
                <i class="fas fa-credit-card text-4xl text-green-500"></i>
              </div>
            </div>
            <div class="bg-white p-6 rounded-lg shadow-sm">
              <div class="flex items-center justify-between">
                <div>
                  <p class="text-gray-500">Active Transactions</p>
                  <p class="text-3xl font-bold"><?= $totalTransactions ?></p>
                </div>
                <i class="fas fa-exchange-alt text-4xl text-purple-500"></i>
              </div>
            </div>
          </div>

          <!-- Tables Grid -->
          <h2 class="text-xl font-bold mb-6">Database Management</h2>
          <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php foreach ($tables as $table): ?>
              <div class="bg-white rounded-lg shadow-sm hover:shadow-md transition-shadow">
                <div class="p-6">
                  <div class="flex items-center justify-between mb-4">
                    <div>
                      <h3 class="text-lg font-semibold text-gray-800">
                        <i class="<?= $icons[$table] ?? 'fa-table' ?> mr-2 text-indigo-500"></i>
                        <?= ucwords(str_replace('_', ' ', $table)) ?>
                      </h3>
                      <p class="text-sm text-gray-500 mt-1">Last updated: <?= date('H:i') ?></p>
                    </div>
                    <span class="bg-indigo-100 text-indigo-800 px-3 py-1 rounded-full text-sm">
                      <?= $tableCounts[$table] ?> records
                    </span>
                  </div>
                  <div class="flex justify-between items-center">
                    <a href="manage.php?table=<?= $table ?>" class="text-indigo-600 hover:text-indigo-900 text-sm">
                      <i class="fas fa-external-link-alt mr-2"></i>Manage Table
                    </a>
                    <div class="flex space-x-2">
                      <button class="p-2 hover:bg-gray-100 rounded">
                        <i class="fas fa-chart-bar text-gray-400"></i>
                      </button>
                      <button class="p-2 hover:bg-gray-100 rounded">
                        <i class="fas fa-download text-gray-400"></i>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        </div>
      </main>
    </div>

    <footer class="bg-white border-t mt-auto">
      <div class="px-6 py-4">
        <div class="flex items-center justify-between text-sm text-gray-600">
          <p>Developed by Prince</p>
          <div class="flex space-x-4">
            <a href="#" class="hover:text-indigo-600"><i class="fab fa-github"></i></a>
            <a href="#" class="hover:text-indigo-600"><i class="fab fa-twitter"></i></a>
            <a href="#" class="hover:text-indigo-600"><i class="fab fa-linkedin"></i></a>
          </div>
        </div>
      </div>
    </footer>
  </div>
</body>
</html>
