<?php
$pageTitle = "Manage Table";
include 'header.php';
require 'config.php';

// Define the base URL for images
$baseImageUrl = "https://bitvros.com/session/auth/user/uploads/";

// Helper function to check if a filename ends with an image extension
function isImageFile($filename) {
    return preg_match('/\.(jpg|jpeg|png|gif|webp|svg)$/i', $filename);
}

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header("Location: login.php");
    exit();
}

if (!isset($_GET['table'])) {
    die("Table not specified.");
}

$table = $_GET['table'];

try {
    $stmt = $conn->prepare("SHOW COLUMNS FROM `$table`");
    $stmt->execute();
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $columnNames = array_map(function($col) { return $col['Field']; }, $columns);
    
    $stmtData = $conn->prepare("SELECT * FROM `$table`");
    $stmtData->execute();
    $data = $stmtData->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}
?>
<main class="container mx-auto p-8">
  <div class="mb-6">
    <h2 class="text-2xl font-bold">Manage <?= ucfirst(htmlspecialchars($table)) ?></h2>
    <p class="text-gray-500">Displaying records from the <span class="font-semibold"><?= htmlspecialchars($table) ?></span> table.</p>
  </div>
  <div class="overflow-x-auto bg-white rounded-lg shadow-md">
    <table class="min-w-full divide-y divide-gray-200">
      <thead class="bg-gray-50">
        <tr>
          <?php foreach ($columnNames as $col): ?>
            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase"><?= htmlspecialchars($col) ?></th>
          <?php endforeach; ?>
          <th class="px-4 py-2">Actions</th>
        </tr>
      </thead>
      <tbody class="bg-white divide-y divide-gray-200">
        <?php foreach ($data as $row): ?>
          <tr>
            <?php foreach ($columnNames as $col): ?>
              <td class="px-4 py-2 text-sm text-gray-700">
                <?php 
                  $value = $row[$col];
                  // Check if the value is non-empty and is an image file
                  if (!empty($value) && isImageFile($value)) {
                      // Construct full image URL - ensure proper path construction
                      $imageUrl = $baseImageUrl . ltrim($value, '/');
                      echo '<a href="' . htmlspecialchars($imageUrl) . '" target="_blank">';
                      echo '<img src="' . htmlspecialchars($imageUrl) . '" alt="Image" class="max-h-16 inline-block rounded" onerror="this.onerror=null; this.src=\'placeholder.png\'; this.title=\'Image not found\';">';
                      echo '</a>';
                  } else {
                      echo htmlspecialchars($value);
                  }
                ?>
              </td>
            <?php endforeach; ?>
            <td class="px-4 py-2">
              <a href="edit.php?table=<?= urlencode($table) ?>&id=<?= $row['id'] ?>" class="text-indigo-600 hover:text-indigo-900 text-sm mr-2">
                <i class="fas fa-edit"></i> Edit
              </a>
              <a href="javascript:void(0);" onclick="confirmDelete('<?= htmlspecialchars($table) ?>', <?= $row['id'] ?>)" class="text-red-600 hover:text-red-800 text-sm">
                <i class="fas fa-trash-alt"></i> Delete
              </a>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
  <div class="mt-4">
    <a href="insert.php?table=<?= urlencode($table) ?>" class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700">
      <i class="fas fa-plus mr-2"></i>Add New Record
    </a>
  </div>
</main>
<script>
  function confirmDelete(table, id) {
    Swal.fire({
      title: 'Are you sure?',
      text: "This record will be permanently deleted.",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      cancelButtonColor: '#3085d6',
      confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
      if (result.isConfirmed) {
        window.location.href = 'delete.php?table=' + table + '&id=' + id;
      }
    });
  }
  
  // Add this to check all images after page load (optional)
  document.addEventListener('DOMContentLoaded', function() {
    console.log('Checking image paths...');
    const images = document.querySelectorAll('img');
    images.forEach(img => {
      console.log('Image URL:', img.src);
    });
  });
</script>
<?php include 'footer.php'; ?>