<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'config.php';
// Retrieve dynamic counts from the database

// Count total blogs from the "blogs" table
$query_blogs = $conn->query("SELECT COUNT(*) as total FROM blogs");
$row_blogs = $query_blogs->fetch_assoc();
$total_blogs = $row_blogs['total'];

// Count total users from the "users" table
$query_users = $conn->query("SELECT COUNT(*) as total FROM users");
$row_users = $query_users->fetch_assoc();
$total_users = $row_users['total'];

// Count total deposits from the "crypto_withdrawal" table (successful transactions)
$query_deposits = $conn->query("SELECT COUNT(*) as total FROM crypto_withdrawal");
$row_deposits = $query_deposits->fetch_assoc();
$total_deposits = $row_deposits['total'];

// Count total payments from the "payments" table (payments received)
$query_payments = $conn->query("SELECT COUNT(*) as total FROM payments");
$row_payments = $query_payments->fetch_assoc();
$total_payments = $row_payments['total'];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Blog Platform</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        /* Global Styling */
        body {
            font-family: 'Arial', sans-serif;
        }

        /* HEADER & NAVIGATION STYLING */
        header {
            background: linear-gradient(to right, #4f46e5, #9333ea);
        }

        .header-container {
            max-width: 1200px;
            margin: 0 auto;
        }

        .header-logo {
            font-size: 2rem;
            font-weight: bold;
            color: #fff;
        }

        .header-links a {
            color: #fff;
            margin-right: 1rem;
            transition: color 0.3s;
        }

        .header-links a:hover {
            color: #d1d5db;
        }

        /* Mobile Menu Styling */
        #mobile-menu a {
            display: block;
            padding: 0.75rem 1rem;
            color: #fff;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            transition: background 0.3s;
        }

        #mobile-menu a:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        /* SIDEBAR STYLING */
        .sidebar {
            background-color: #1f2937;
            color: #9ca3af;
            min-height: 100vh;
            width: 250px;
            padding: 1rem;
            transition: transform 0.3s ease;
        }

        .sidebar a {
            display: block;
            padding: 0.75rem 1rem;
            margin-bottom: 0.5rem;
            border-radius: 0.375rem;
            transition: background 0.3s, color 0.3s;
        }

        .sidebar a:hover {
            background-color: #374151;
            color: #fff;
        }

        /* Hide sidebar on toggle (by default shown on desktop) */
        .sidebar.hidden {
            transform: translateX(-100%);
        }

        /* MAIN CONTENT STYLING */
        .main-content {
            padding: 1rem;
            flex: 1;
        }

        /* DASHBOARD CARDS STYLING */
        .dashboard-card {
            background-color: #fff;
            padding: 1.5rem;
            border-radius: 0.5rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        /* FORM STYLING */
        .form-container {
            background-color: #fff;
            padding: 2rem;
            border-radius: 0.75rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            margin-bottom: 2rem;
        }

        .form-container label {
            display: block;
            margin-bottom: 0.5rem;
            color: #4b5563;
            font-weight: 500;
        }

        .form-container input,
        .form-container textarea {
            width: 100%;
            padding: 0.75rem;
            margin-bottom: 1rem;
            border: 1px solid #d1d5db;
            border-radius: 0.375rem;
            transition: border-color 0.3s;
        }

        .form-container input:focus,
        .form-container textarea:focus {
            border-color: #4f46e5;
            outline: none;
        }

        .form-container button {
            background-color: #4f46e5;
            color: #fff;
            padding: 0.75rem 1.5rem;
            border-radius: 0.375rem;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .form-container button:hover {
            background-color: #4338ca;
        }

        /* BLOG SLIDER STYLING */
        .slider-container {
            position: relative;
            overflow: hidden;
        }

        .slider-track {
            display: flex;
            gap: 1.25rem;
            overflow-x: auto;
            scroll-snap-type: x mandatory;
            scroll-behavior: smooth;
            padding-bottom: 1rem;
        }

        .slider-track::-webkit-scrollbar {
            height: 8px;
        }

        .slider-track::-webkit-scrollbar-thumb {
            background-color: #ccc;
            border-radius: 10px;
        }

        .slider-track::-webkit-scrollbar-track {
            background-color: #f1f1f1;
        }

        /* BLOG CARD STYLING */
        .slider-card {
            background-color: #fff;
            border-radius: 0.75rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            max-width: 16rem;
            overflow: hidden;
            position: relative;
            display: flex;
            flex-direction: column;
            padding: 1rem;
            scroll-snap-align: start;
        }

        .slider-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 8px rgba(0, 0, 0, 0.2);
        }

        .card-image {
            background-size: cover;
            background-position: center;
            width: 50px;
            height: 50px;
            border-radius: 0.375rem;
        }

        .card-content {
            padding: 0.5rem 0;
        }

        .card-title {
            font-size: 1.125rem;
            font-weight: bold;
            color: #1f2937;
        }

        .card-description {
            font-size: 0.875rem;
            color: #4b5563;
        }

        /* EDIT/DELETE BUTTONS */
        .edit-delete-btns {
            position: absolute;
            top: 0.5rem;
            right: 0.5rem;
            display: flex;
            gap: 0.5rem;
            z-index: 10;
        }

        .edit-delete-btns a {
            font-size: 0.875rem;
            transition: color 0.3s;
        }

        .edit-delete-btns a:hover {
            opacity: 0.8;
        }

        /* SLIDER NAVIGATION BUTTONS */
        .slider-btn {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            background-color: rgba(79, 70, 229, 0.8);
            color: #fff;
            border-radius: 50%;
            padding: 0.5rem;
            z-index: 20;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .slider-container:hover .slider-btn {
            opacity: 1;
        }

        .slider-btn.left-4 {
            left: 0.5rem;
        }

        .slider-btn.right-4 {
            right: 0.5rem;
        }

        /* RESPONSIVE LAYOUT */
        .layout {
            display: flex;
            flex-direction: row;
        }

        @media (max-width: 768px) {
            .layout {
                flex-direction: column;
            }

            .sidebar {
                display: none;
            }

            .header-links {
                display: none;
            }

            #mobile-menu {
                display: block;
            }
        }
    </style>
</head>

<body class="bg-gray-100">
    <!-- HEADER WITH NAVIGATION -->
    <header>
        <div class="header-container mx-auto px-4 py-4 flex justify-between items-center">
            <div class="header-logo">Admin Panel</div>
            <!-- Desktop Navigation Links -->
            <nav class="header-links hidden md:flex">
                <a href="kyc.php">KYC</a>
                <a href="change_password.php">Change Password/Settings</a>
                <a href="users_deposit.php">All Users Deposit</a>
                <a href="notifications.php">Notifications</a>
                <a href="view_sending.php">View Sending</a>
                <a href="view_deposit.php">View Deposit</a>
                <a href="manage_blogs.php">Manage Blogs</a>
                <a href="logout.php">Logout</a>
            </nav>
            <!-- Mobile Menu Toggle (Hamburger) -->
            <button id="menu-toggle" class="md:hidden text-white focus:outline-none">
                <svg class="w-6 h-6 fill-current" viewBox="0 0 24 24">
                    <path d="M4 6h16M4 12h16M4 18h16"></path>
                </svg>
            </button>
            <!-- Sidebar Toggle Button (visible on desktop) -->
            <button id="sidebar-toggle" class="hidden md:block text-white ml-4 focus:outline-none">
                Toggle Sidebar
            </button>
        </div>
        <!-- Mobile Navigation Menu -->
        <div id="mobile-menu" class="hidden md:hidden">
            <a href="kyc.php">KYC</a>
            <a href="change_password.php">Change Password/Settings</a>
            <a href="users_deposit.php">All Users Deposit</a>
            <a href="notifications.php">Notifications</a>
            <a href="view_sending.php">View Sending</a>
            <a href="view_deposit.php">View Deposit</a>
            <a href="manage_blogs.php">Manage Blogs</a>
            <a href="logout.php">Logout</a>
        </div>
    </header>

    <!-- LAYOUT: SIDEBAR + MAIN CONTENT -->
    <div class="layout">
        <!-- SIDEBAR (Desktop) -->
        <aside id="sidebar" class="sidebar">
            <nav>
                <a href="dashboard.php">Dashboard</a>
                <a href="kyc.php">KYC</a>
                <a href="change_password.php">Change Password/Settings</a>
                <a href="users_deposit.php">All Users Deposit</a>
                <a href="notifications.php">Notifications</a>
                <a href="view_sending.php">View Sending</a>
                <a href="view_deposit.php">View Deposit</a>
                <a href="manage_blogs.php">Manage Blogs</a>
                <a href="logout.php">Logout</a>
            </nav>
        </aside>

        <!-- MAIN CONTENT AREA -->
        <main class="main-content flex-1">
            <!-- DASHBOARD STATISTICS -->
            <section class="mb-8">
                <h2 class="text-2xl font-bold mb-4">Dashboard Overview</h2>
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div class="dashboard-card">
                        <h3 class="text-xl font-semibold">Blogs</h3>
                        <p class="text-gray-600"><?php echo $total_blogs; ?></p>
                    </div>
                    <div class="dashboard-card">
                        <h3 class="text-xl font-semibold">Users</h3>
                        <p class="text-gray-600"><?php echo $total_users; ?></p>
                    </div>
                    <div class="dashboard-card">
                        <h3 class="text-xl font-semibold">Deposits</h3>
                        <p class="text-gray-600"><?php echo $total_deposits; ?></p>
                    </div>
                    <div class="dashboard-card">
                        <h3 class="text-xl font-semibold">Payments</h3>
                        <p class="text-gray-600"><?php echo $total_payments; ?></p>
                    </div>
                </div>
            </section>

            <!-- ADD BLOG FORM -->
            <section class="mb-8">
                <h2 class="text-2xl font-bold mb-4">Create a New Blog</h2>
                <div class="form-container">
                    <form action="process_blog.php" method="POST" enctype="multipart/form-data">
                        <div class="mb-4">
                            <label for="blog-title">Blog Title</label>
                            <input type="text" id="blog-title" name="title" placeholder="Enter Blog Title" required>
                        </div>
                        <div class="mb-4">
                            <label for="blog-content">Content</label>
                            <textarea id="blog-content" name="content" placeholder="Write your blog content here" rows="5" required></textarea>
                        </div>
                        <div class="mb-4">
                            <label for="blog-image">Upload Image</label>
                            <input type="file" id="blog-image" name="image" accept="image/*" required>
                        </div>
                        <button type="submit" name="submit">Add Blog</button>
                    </form>
                </div>
            </section>

            <!-- BLOG SLIDER -->
            <section>
                <h2 class="text-2xl font-bold mb-4">Blog Posts</h2>
                <div id="imageSlider" class="slider-container relative group">
                    <div class="slider-track">
                        <?php
                        // Fetch blog entries from the "blogs" table
                        $result = $conn->query("SELECT * FROM blogs ORDER BY created_at DESC");
                        while ($row = $result->fetch_assoc()):
                            // Build the image path (assuming the file name is stored in 'image_url')
                            $image_path = 'all_blogs/' . basename($row['image_url']);
                        ?>
                        <div class="slider-card">
                            <!-- Cover the entire card with an invisible link for editing -->
                            <a href="edit_blog.php?id=<?= $row['id'] ?>" class="absolute inset-0 z-10"></a>
                            <div class="card-image" style="background-image: url('<?= $image_path ?>');"></div>
                            <div class="card-content">
                                <h3 class="card-title"><?= $row['title'] ?></h3>
                                <p class="card-description"><?= substr($row['content'], 0, 100) ?>...</p>
                            </div>
                            <div class="edit-delete-btns">
                                <a href="edit_blog.php?id=<?= $row['id'] ?>" class="text-blue-500 hover:text-blue-700">✏️ Edit</a>
                                <a href="process_blog.php?delete=<?= $row['id'] ?>" class="text-red-500 hover:text-red-700">🗑️ Delete</a>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>

                    <!-- SLIDER NAVIGATION BUTTONS -->
                    <button class="slider-btn left-4">
                        &larr;
                    </button>
                    <button class="slider-btn right-4">
                        &rarr;
                    </button>
                </div>
            </section>
        </main>
    </div>

    <!-- JAVASCRIPT FOR INTERACTIVITY -->
    <script>
        // Mobile Menu Toggle Script
        const menuToggle = document.getElementById('menu-toggle');
        const mobileMenu = document.getElementById('mobile-menu');
        menuToggle.addEventListener('click', () => {
            mobileMenu.classList.toggle('hidden');
        });

        // Sidebar Toggle Script (for desktop)
        const sidebarToggle = document.getElementById('sidebar-toggle');
        const sidebar = document.getElementById('sidebar');
        sidebarToggle.addEventListener('click', () => {
            sidebar.classList.toggle('hidden');
        });

        // Slider Navigation Script
        const prevButton = document.querySelector('.slider-btn.left-4');
        const nextButton = document.querySelector('.slider-btn.right-4');
        const slider = document.querySelector('.slider-track');

        prevButton.addEventListener('click', () => {
            slider.scrollBy({ left: -300, behavior: 'smooth' });
        });

        nextButton.addEventListener('click', () => {
            slider.scrollBy({ left: 300, behavior: 'smooth' });
        });
    </script>
</body>

</html>