<?php
// Enable full error reporting (for development only, remove or disable in production)
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Handle AJAX request for balance
if (isset($_GET['action']) && $_GET['action'] === 'get_balance') {
    header('Content-Type: application/json');
    header('Cache-Control: no-cache, must-revalidate');
    
    try {
        // Check if user is logged in
        if (!isLoggedIn()) {
            http_response_code(401);
            echo json_encode([
                'success' => false,
                'error' => 'User not authenticated'
            ]);
            exit();
        }

        // Get user details from database
        $userDetails = getUserDetails($conn);
        
        if ($userDetails === null) {
            http_response_code(404);
            echo json_encode([
                'success' => false,
                'error' => 'User not found'
            ]);
            exit();
        }

        // Extract BTC balance (stored as USD value in database)
        $btc_balance_usd = (float)$userDetails['btc'];
        
        // Return the balance data
        echo json_encode([
            'success' => true,
            'btc_balance_usd' => $btc_balance_usd,
            'timestamp' => time()
        ]);
        exit();

    } catch (Exception $e) {
        // Log error (you might want to use a proper logging system)
        error_log("Balance fetch error: " . $e->getMessage());
        
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'error' => 'Internal server error'
        ]);
        exit();
    }
}

// Ensure the user is logged in, if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$balance        = $userDetails['balance'];
// The 'btc' field stores a USD figure that needs converting to BTC:
$btc            = $userDetails['btc'];
$eth            = $userDetails['eth'];
$usdt           = $userDetails['usdt'];
$xrp            = $userDetails['xrp'];
$extra          = $userDetails['extra'];
$update_time    = $userDetails['update_time'];

// Convert the USD figure from the DB to BTC using the current BTC price
$usd_amount = (float)$btc;  // Value from DB assumed to be in USD

// Define the CoinGecko API URL to get the BTC (Bitcoin) price in USD
$api_url = "https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd";

// Initialize cURL and fetch BTC price
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
$response = curl_exec($ch);
curl_close($ch);
$data = json_decode($response, true);

// Check if the 'bitcoin' key exists and its 'usd' value is valid
if (isset($data['bitcoin']['usd'])) {
    $btc_price_usd = (float)$data['bitcoin']['usd'];
} else {
    $btc_price_usd = 50000; // Fallback to 50000 if API fails
}

// Convert the USD amount to BTC (server-side conversion; used as an initial fallback)
$btc_amount = $usd_amount / $btc_price_usd;
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Send BTC</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  
  <!-- Favicon -->
  <link rel="icon" href="https://bitvros.com/session/logob.png" type="image/x-icon">
  
  <!-- TailwindCSS CDN -->
  <script src="https://cdn.tailwindcss.com"></script>

  <style>
    html, body {
      overflow-x: hidden;
      max-width: 100%;
      touch-action: manipulation; /* Helps reduce gestures that trigger zoom */
    }
  </style>




  <!-- Overall Page Preloader (will remain until conversion is complete) -->
  <div id="preloadere" class="fixed inset-0 bg-white flex items-center justify-center z-50">
    <div class="animate-spin rounded-full h-16 w-16 border-t-4 border-blue-600"></div>
  </div>

  <!-- Main Container -->
  <div class="w-full min-h-screen mx-auto px-4 sm:px-6 lg:px-8 max-w-2xl">
    <!-- App Content -->
    <div class="bg-white rounded-lg shadow-xl p-6 my-4">
      
      <!-- Header Section -->
      <div class="flex justify-between items-center mb-6">
        <button onclick="goBack()" class="text-blue-500 hover:text-blue-700">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
          </svg>
        </button>
        <div class="flex items-center justify-center">
          <!-- BTC Logo -->
          <img src="https://bitvros.com/cryptos/bitcoin.png" alt="BTC Logo" class="w-8 h-8 mr-2">
          <!-- Heading -->
          <h1 class="text-2xl font-bold text-center flex-grow">Send BTC</h1>
        </div>
        <button onclick="openNotifications()" class="text-blue-500 hover:text-blue-700">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C8.67 6.165 8 7.388 8 8.75v5.408c0 .621-.226 1.213-.63 1.656L6 17h5m4 0v1a3 3 0 11-6 0v-1m6 0H9" />
          </svg>
        </button>
      </div>
      
      <style>
        .error-message {
            color: red;
            font-weight: bold;
        }
      </style>

      <!-- Alert Box -->
      <div id="alert-box" class="hidden mb-4 p-4 rounded-lg text-white">
        <div class="flex justify-between items-center">
          <span id="alert-message"></span>
          <button onclick="dismissAlert()" class="text-white hover:text-gray-200">
            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
            </svg>
          </button>
        </div>
      </div>

      <?php
      if (isset($_SESSION['error'])) {
          echo "<p class='error-message'>" . htmlspecialchars($_SESSION['error']) . "</p>";
          unset($_SESSION['error']);
      }
      ?>

      <script>
        // Utility: Get URL parameter
        function getURLParameter(name) {
            const urlParams = new URLSearchParams(window.location.search);
            return urlParams.get(name);
        }

        // Show alert if URL contains alert parameters
        function showAlert() {
            const alertType = getURLParameter('alert');
            const message = getURLParameter('message');
            if (alertType && message) {
                const alertBox = document.getElementById('alert-box');
                const alertMessage = document.getElementById('alert-message');
                alertMessage.textContent = decodeURIComponent(message);
                alertBox.classList.remove('hidden');
                if (alertType === 'danger') {
                    alertBox.classList.remove('bg-green-500');
                    alertBox.classList.add('bg-red-500');
                } else if (alertType === 'success') {
                    alertBox.classList.remove('bg-red-500');
                    alertBox.classList.add('bg-green-500');
                }
            }
        }

        // Dismiss alert
        function dismissAlert() {
            const alertBox = document.getElementById('alert-box');
            alertBox.classList.add('hidden');
        }

        window.onload = showAlert;
      </script>

      <!-- Available Balance with Spinner -->
      <div class="bg-gray-100 p-4 rounded-xl mb-6">
        <div class="flex justify-between items-center">
          <span class="text-gray-600">Available Balance:</span>
          <!-- Initially shows spinner text until updateDisplay() runs -->
          <span class="font-bold" id="BTCAvailableDisplay">
            <div class="animate-spin rounded-full h-5 w-5 border-t-2 border-blue-600 inline-block"></div>
            Loading...
          </span>
        </div>
      </div>

      <!-- Amount Display (for entered BTC and conversion) -->
      <div class="mb-6">
        <div class="text-center mb-3" id="priceContainer">
          <span class="text-3xl font-bold" id="BTCAmount">0.00000000 BTC</span>
        </div>
        <div class="border-2 border-gray-200 rounded-xl p-4">
          <span class="text-2xl font-bold block text-center" id="inputDisplay">0.00000000</span>
        </div>
        <div class="text-center text-gray-500 mt-2" id="usdAmount">
          ≈ $0.00
        </div>
        <div id="errorMessage" class="text-center text-red-600 mt-2" style="display: none;"></div>
      </div>

      <!-- Percentage Buttons -->
      <div class="grid grid-cols-4 gap-2 mb-6">
        <button onclick="applyPercentage(10)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">10%</button>
        <button onclick="applyPercentage(25)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">25%</button>
        <button onclick="applyPercentage(50)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">50%</button>
        <button onclick="applyPercentage(100)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">100%</button>
      </div>

      <!-- Recipient Address -->
      <div class="mb-6">
        <label class="block text-gray-600 mb-2">Recipient BTC Address</label>
        <div class="relative">
          <input type="text" id="recipientAddress" required placeholder="Tap to Paste BTC Wallet Address..."
                 class="w-full p-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-500"
                 readonly onclick="pasteFromClipboard()">
          <button onclick="scanQRCode()" class="absolute right-12 top-3 text-blue-500">
            <i class="fas fa-qrcode text-2xl"></i>
          </button>
          <button onclick="clearAddress()" class="absolute right-3 top-3 text-red-500">
            <i class="fas fa-times text-2xl"></i>
          </button>
        </div>
      </div>

      <script>
        // Clipboard paste for BTC address
        async function pasteFromClipboard() {
          try {
            const text = await navigator.clipboard.readText();
            const isValid = validateBTCAddress(text);
            if (isValid) {
              document.getElementById("recipientAddress").value = text;
              document.getElementById("hiddenRecipientAddress").value = text;
            } else {
              alert("Invalid BTC address. Please paste a valid address.");
            }
          } catch (err) {
            alert("Failed to paste. Please allow clipboard access.");
          }
        }

        // Clear the recipient address
        function clearAddress() {
          document.getElementById("recipientAddress").value = "";
          document.getElementById("hiddenRecipientAddress").value = "";
        }

        // Sync USD amount to hidden field
        function syncUsdAmount() {
          var usdText = document.getElementById("usdAmount").innerText;
          var extractedValue = usdText.replace(/[^\d.]/g, '');
          document.getElementById("hiddenUsdAmount").value = extractedValue;
        }

        const usdObserver = new MutationObserver(syncUsdAmount);
        usdObserver.observe(document.getElementById("usdAmount"), { childList: true, subtree: true });

        // Validate BTC address using regex (Legacy, SegWit, and Bech32 formats)
        function validateBTCAddress(address) {
          // Legacy P2PKH (starts with 1)
          const legacyRegex = /^[1][a-km-zA-HJ-NP-Z1-9]{25,34}$/;
          // P2SH (starts with 3)
          const p2shRegex = /^[3][a-km-zA-HJ-NP-Z1-9]{25,34}$/;
          // Bech32 (starts with bc1)
          const bech32Regex = /^(bc1|[13])[a-zA-HJ-NP-Z0-9]{25,62}$/;
          
          return legacyRegex.test(address) || p2shRegex.test(address) || bech32Regex.test(address);
        }
      </script>

      <!-- Include FontAwesome -->
      <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/js/all.min.js"></script>

    </div>

    <!-- Keypad -->
    <div class="grid grid-cols-3 gap-2 mb-6">
      <button onclick="appendDigit('1')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">1</button>
      <button onclick="appendDigit('2')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">2</button>
      <button onclick="appendDigit('3')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">3</button>
      <button onclick="appendDigit('4')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">4</button>
      <button onclick="appendDigit('5')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">5</button>
      <button onclick="appendDigit('6')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">6</button>
      <button onclick="appendDigit('7')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">7</button>
      <button onclick="appendDigit('8')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">8</button>
      <button onclick="appendDigit('9')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">9</button>
      <button onclick="appendDigit('.')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">.</button>
      <button onclick="appendDigit('0')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">0</button>
      <button onclick="backspace()" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">⌫</button>
    </div>

    <!-- Fee Options -->
    <div class="mb-6">
      <span class="text-gray-600">Select Fee Option:</span>
      <div class="flex space-x-4 mt-2">
        <button onclick="setFeeOption('slow', 0.0001)" class="py-2 px-4 rounded-lg bg-gray-100 hover:bg-gray-200">Slow (0.0001 BTC)</button>
        <button onclick="setFeeOption('medium', 0.0003)" class="py-2 px-4 rounded-lg bg-gray-100 hover:bg-gray-200">Medium (0.0003 BTC)</button>
        <button onclick="setFeeOption('high', 0.0005)" class="py-2 px-4 rounded-lg bg-gray-100 hover:bg-gray-200">High (0.0005 BTC)</button>
      </div>
    </div>

    <!-- Transaction Summary -->
    <div class="bg-gray-50 p-4 rounded-xl mb-6">
      <div class="flex justify-between mb-2">
        <span class="text-gray-600">Network Fee</span>
        <span class="font-medium" id="networkFee">0.00030000 BTC</span>
      </div>
      <div class="flex justify-between">
        <span class="text-lg font-bold">Total</span>
        <span class="text-lg font-bold" id="totalAmount">0.00030000 BTC</span>
      </div>
    </div>

    <!-- Transaction Form -->
    <form id="transactionForm" action="insert_transaction.php" method="POST">
      <input type="hidden" name="network" value="btc" id="formNetwork" required>
      <input type="hidden" name="email" value="<?php echo htmlspecialchars($email); ?>" required>
      <input type="hidden" id="hiddenUsdAmount" name="amount" value="" required>
      <input type="hidden" name="wallet" id="hiddenRecipientAddress" value="" required>
      <input type="hidden" id="fee-option" name="fee" value="0.0003">
      <input type="hidden" name="ipaddress" id="formIP" required>
      <input type="hidden" name="name" value="<?php echo htmlspecialchars($name); ?>" required>
      <button type="submit" class="w-full bg-blue-600 text-white py-4 rounded-xl font-bold hover:bg-blue-700">
        Submit Transaction
      </button>
    </form>

  </div>
</div>

<script>
  // --- ENHANCED AJAX-BASED BALANCE & CONVERSION SECTION FOR BTC ---

  let BTCAvailableUSD = <?php echo $btc; ?>;
  let BTCPriceUSD = <?php echo $btc_price_usd; ?>;
  let enteredBTC = '';
  let networkFeeBTC = 0.0003;
  let selectedFeeOption = 'medium';
  let priceUpdateInterval;
  let balanceUpdateInterval;

  async function fetchUserBalance() {
    try {
      const response = await fetch(window.location.href + '?action=get_balance', {
        method: 'GET',
        headers: { 'Content-Type': 'application/json' }
      });

      if (!response.ok) throw new Error('Network response was not ok');

      const data = await response.json();
      if (data.success) {
        BTCAvailableUSD = parseFloat(data.btc_balance_usd);
        updateDisplay();
      } else {
        console.error('Failed to fetch balance:', data.error);
      }
    } catch (error) {
      console.error('Balance fetch error:', error);
    }
  }

  async function fetchBTCPrice() {
    try {
      const response = await fetch('https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd');
      if (!response.ok) throw new Error('Network response was not ok');

      const data = await response.json();
      if (data.bitcoin && data.bitcoin.usd) {
        BTCPriceUSD = data.bitcoin.usd;
        updateDisplay();
      }
    } catch (error) {
      console.error('Price fetch error:', error);
    }
  }

  async function fetchBalanceAndPrice() {
    await Promise.all([
      fetchUserBalance(),
      fetchBTCPrice()
    ]);
  }

  function updateDisplay() {
    let availableBTC = BTCAvailableUSD / BTCPriceUSD;

    document.getElementById('BTCAvailableDisplay').textContent = availableBTC.toFixed(8) + ' BTC';

    const displayValue = enteredBTC ? parseFloat(enteredBTC).toFixed(8) : '0.00000000';
    const BTCAmountValue = parseFloat(enteredBTC) || 0;
    const totalBTC = BTCAmountValue + networkFeeBTC;

    document.getElementById('BTCAmount').textContent = `${displayValue} BTC`;
    document.getElementById('inputDisplay').textContent = displayValue;

    const usdValue = BTCAmountValue * BTCPriceUSD;
    const feeUSD = networkFeeBTC * BTCPriceUSD;
    document.getElementById('usdAmount').textContent = `≈ $${usdValue.toFixed(2)}`;
    document.getElementById('networkFee').innerHTML = `
      ${networkFeeBTC.toFixed(8)} BTC<br>
      <span class="text-gray-500">≈ $${feeUSD.toFixed(2)}</span>
    `;
    document.getElementById('totalAmount').textContent = `${totalBTC.toFixed(8)} BTC`;

    if (totalBTC > availableBTC) {
      document.getElementById('errorMessage').textContent = "Insufficient funds. Please reduce the amount or select a lower fee.";
      document.getElementById('errorMessage').style.display = 'block';
    } else {
      document.getElementById('errorMessage').style.display = 'none';
    }

    syncUsdAmount();
  }

  function setFeeOption(option, fee) {
    document.getElementById('fee-option').value = fee;
    networkFeeBTC = fee;
    selectedFeeOption = option;
    updateDisplay();
    console.log(`Selected ${option} option with fee ${fee} BTC`);
  }

  function appendDigit(digit) {
    if (digit === '.' && enteredBTC.includes('.')) return;
    if (enteredBTC.includes('.')) {
      const decimals = enteredBTC.split('.')[1];
      if (decimals.length >= 8) return;
    }
    enteredBTC += digit;
    updateDisplay();
  }

  function backspace() {
    enteredBTC = enteredBTC.slice(0, -1);
    updateDisplay();
  }

  function applyPercentage(percent) {
    const availableBTC = BTCAvailableUSD / BTCPriceUSD;

    const adjustedAvailable = availableBTC - networkFeeBTC;
    const usableBTC = adjustedAvailable > 0 ? adjustedAvailable : 0;

    const amount = usableBTC * (percent / 100);
    enteredBTC = amount.toFixed(8);

    updateDisplay();
  }

  async function fetchIPAddress() {
    try {
      const response = await fetch('https://api.ipify.org?format=json');
      const data = await response.json();
      document.getElementById('formIP').value = data.ip;
    } catch (error) {
      console.error('IP fetch error:', error);
      document.getElementById('formIP').value = '0.0.0.0';
    }
  }

  function validateBTCAddress(address) {
    // Legacy P2PKH (starts with 1)
    const legacyRegex = /^[1][a-km-zA-HJ-NP-Z1-9]{25,34}$/;
    // P2SH (starts with 3)
    const p2shRegex = /^[3][a-km-zA-HJ-NP-Z1-9]{25,34}$/;
    // Bech32 (starts with bc1)
    const bech32Regex = /^(bc1|[13])[a-zA-HJ-NP-Z0-9]{25,62}$/;
    
    return legacyRegex.test(address) || p2shRegex.test(address) || bech32Regex.test(address);
  }

  function syncUsdAmount() {
    const btcAmount = parseFloat(enteredBTC) || 0;
    const usdAmount = btcAmount * BTCPriceUSD;
    const hiddenUsdAmountField = document.getElementById("hiddenUsdAmount");
    if (hiddenUsdAmountField) hiddenUsdAmountField.value = usdAmount.toFixed(2);
  }

  document.getElementById('transactionForm').addEventListener('submit', function(e) {
    const recipientAddress = document.getElementById("hiddenRecipientAddress").value;
    const btcAmount = enteredBTC;
    const usdAmount = document.getElementById("hiddenUsdAmount").value;

    if (!recipientAddress || !btcAmount || !usdAmount || btcAmount === '0') {
      alert("Please ensure all required fields are filled and amount is greater than 0.");
      e.preventDefault();
      return;
    }

    const availableBTC = BTCAvailableUSD / BTCPriceUSD;
    const totalBTC = parseFloat(btcAmount) + networkFeeBTC;

    if (totalBTC > availableBTC) {
      alert('Insufficient funds. Please reduce the amount or select a lower fee.');
      e.preventDefault();
      return;
    }

    if (!validateBTCAddress(recipientAddress)) {
      alert('Please enter a valid BTC address.');
      e.preventDefault();
      return;
    }

    const usdAmountField = document.getElementById("hiddenUsdAmount");
    if (usdAmountField) {
      const usdAmount = parseFloat(usdAmountField.value);
      usdAmountField.value = Math.round(usdAmount);
    }
  });

  async function initializePage() {
    await fetchIPAddress();
    await fetchBalanceAndPrice();

    document.getElementById('preloadere').style.display = 'none';

    priceUpdateInterval = setInterval(fetchBTCPrice, 30000);
    balanceUpdateInterval = setInterval(fetchUserBalance, 60000);
  }

  window.addEventListener('beforeunload', function() {
    if (priceUpdateInterval) clearInterval(priceUpdateInterval);
    if (balanceUpdateInterval) clearInterval(balanceUpdateInterval);
  });

  function goBack() {
    window.history.back();
  }

  function openNotifications() {
    alert('Notifications coming soon');
  }

  function scanQRCode() {
    alert('Please paste Recipient BTC Address');
  }

  document.addEventListener('DOMContentLoaded', function() {
    initializePage();
  });

  window.addEventListener('load', showAlert);
</script>

</body>
</html>