<?php
// Database connection details
$servername = "localhost";  // Replace with your server address
$username = "lrbpxbxy_userv";         // Replace with your database username
$password = "WHEagP2O9sOzG9gk";             // Replace with your database password
$dbname = "lrbpxbxy_dbv";  // Replace with your database name

// Create connection to the database
$conn = new mysqli($servername, $username, $password, $dbname);

// Check the database connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the blog ID from the URL parameter
$blog_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Validate the blog ID
if ($blog_id <= 0) {
    echo "Invalid blog ID.";
    exit;
}

// Prepare the SQL statement to fetch blog details
$sql = "SELECT id, title, content, image_url FROM blogs WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $blog_id);
$stmt->execute();
$result = $stmt->get_result();

// Check if the blog exists and fetch data
if ($result->num_rows > 0) {
    $row       = $result->fetch_assoc();
    $title     = $row['title'];
    $content   = $row['content'];
    $image_url = $row['image_url'];
} else {
    echo "Blog post not found.";
    exit;
}

// Close the database connections
$stmt->close();
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Meta tags and Title -->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($title); ?> | Bitvros</title>
    
    <!-- Favicon -->
    <link rel="icon" href="https://bitvros.com/session/favicon.png" type="image/x-icon">
    
    <!-- Tailwind CSS -->
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <style>
        /* Custom styles for a modern blog design */
        body {
            background-color: #ffffff; /* White background */
            font-family: 'Inter', sans-serif;
        }
        /* Header styles */
        .header {
            background-color: #e5f0ff; /* Light blue background */
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .logo {
            max-width: 80px; /* Reduced logo size */
        }
        /* Bitvros name styling */
        .site-name {
            font-size: 1.75rem;
            font-weight: 700; /* Bold text */
            color: #5d0fd8; /* Blue color */
        }
        /* Blog container */
        .blog-container {
            max-width: 800px;
            margin: 2rem auto;
            padding: 1.5rem;
            background-color: #f9fafb; /* Light gray background */
            border-radius: 8px;
        }
        /* Blog title */
        .blog-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #5d0fd8; /* Blue color */
            margin-bottom: 1rem;
            text-align: center;
        }
        /* Blog image */
        .blog-image {
            width: 100%;
            max-height: 250px; /* Smaller image height */
            object-fit: cover;
            border-radius: 8px;
            margin-bottom: 1.5rem;
        }
        /* Blog content */
        .blog-content {
            font-size: 1.125rem;
            color: #1f2937; /* Dark gray text */
            line-height: 1.75;
        }
        /* Back button */
        .back-button {
            display: inline-block;
            margin-top: 2rem;
            background-color: #5d0fd8; /* Blue background */
            color: #ffffff;
            padding: 0.75rem 1.5rem;
            border-radius: 4px;
            text-decoration: none;
            font-weight: 500;
            transition: background-color 0.3s ease;
        }
        .back-button:hover {
            background-color: #153e75; /* Darker blue on hover */
        }
        /* Footer styles */
        .footer {
            background-color: #e5f0ff; /* Light blue background */
            color: #1f2937; /* Dark gray text */
            padding: 1rem 0;
            text-align: center;
            margin-top: 4rem;
        }
    </style>
</head>
<body>
<!-- Header with Logo -->
<header class="header">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex items-center justify-between py-4">
        <!-- Logo and Site Name -->
        <a href="dashboard.php" class="flex items-center">
            <img src="https://bitvros.com/session/favicon.png" alt="Bitvros Logo" class="logo">
            <span class="ml-3 site-name">Bitvros</span>
        </a>
        <!-- Navigation (optional) -->
        <nav>
            <a href="dashboard.php" class="text-gray-700 hover:text-gray-900 font-medium">Back</a>
            <!-- You can add more navigation links here -->
        </nav>
    </div>
</header>

<!-- Blog Content -->
<main class="blog-container">
    <!-- Blog Title -->
    <h1 class="blog-title"><?php echo htmlspecialchars($title); ?></h1>
    
    <!-- Blog Image -->
    <?php if ($image_url): ?>
        <img src="./admin/uploads/<?php echo htmlspecialchars($image_url); ?>" alt="Blog Image" class="blog-image">
    <?php endif; ?>
    
    <!-- Blog Content -->
    <div class="blog-content">
        <?php echo nl2br(htmlspecialchars($content)); ?>
    </div>
    
    <!-- Back to Blog List Button -->
    <div class="text-center">
        <a href="dashboard.php" class="back-button">Back to Blog List</a>
    </div>
</main>

<!-- Footer -->
<footer class="footer">
    <div class="container mx-auto">
        &copy; <?php echo date('Y'); ?> <span class="font-bold text-blue-600">Bitvros</span>. All rights reserved.
    </div>
</footer>

</body>
</html>
