<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if all required query parameters are present
$required_params = ['user_id', 'email', 'network', 'wallet', 'btc_amount', 'total_amount', 'fee', 'transhash'];
$missing_params = [];

foreach ($required_params as $param) {
    if (!isset($_GET[$param]) || trim($_GET[$param]) === '') {
        $missing_params[] = $param;
    }
}

if (!empty($missing_params)) {
    die("Missing required parameters: " . implode(', ', $missing_params));
}

// Sanitize query parameters
$user_id = htmlspecialchars($_GET['user_id']);
$email = htmlspecialchars($_GET['email']);
$network = htmlspecialchars($_GET['network']);
$wallet = htmlspecialchars($_GET['wallet']);
$btc_amount = htmlspecialchars($_GET['btc_amount']);
$total_amount = htmlspecialchars($_GET['total_amount']);
$fee = htmlspecialchars($_GET['fee']);
$transhash = htmlspecialchars($_GET['transhash']);

// Format amounts to 2 decimal places
$btc_amount = number_format((float)$btc_amount, 2, '.', '');
$total_amount = number_format((float)$total_amount, 2, '.', '');
$fee = number_format((float)$fee, 2, '.', '');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transaction Details</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        table { border-collapse: collapse; width: 50%; }
        table, th, td { border: 1px solid black; }
        th, td { padding: 10px; text-align: left; }
    </style>
</head>
<body>
    <h2>Transaction Details</h2>
    <table>
        <tr><th>User ID</th><td><?php echo $user_id; ?></td></tr>
        <tr><th>Email</th><td><?php echo $email; ?></td></tr>
        <tr><th>Network</th><td><?php echo $network; ?></td></tr>
        <tr><th>Wallet</th><td><?php echo $wallet; ?></td></tr>
        <tr><th>BTC Amount</th><td><?php echo $btc_amount; ?></td></tr>
        <tr><th>Total Amount</th><td><?php echo $total_amount; ?></td></tr>
        <tr><th>Fee</th><td><?php echo $fee; ?></td></tr>
        <tr><th>Transaction Hash</th><td><?php echo $transhash; ?></td></tr>
    </table>
</body>
</html>
