<?php
// btcc.php

// Start the session to access session variables (if the user is logged in)
session_start();

// Determine the recipient email:
// Prefer the session email if available; otherwise, fallback to the GET email parameter.
if (isset($_SESSION['email']) && !empty($_SESSION['email'])) {
    $email = $_SESSION['email'];
} else {
    // Decode the email from the URL if it's URL-encoded
    if (isset($_GET['email']) && !empty($_GET['email'])) {
        $email = urldecode($_GET['email']);  // URL decode the email
    } else {
        die("Email not provided.");  // If email is not provided, exit with a message
    }
}

// Retrieve the required GET parameters
$wallet    = isset($_GET['wallet']) ? $_GET['wallet'] : '';
$transhash = isset($_GET['transhash']) ? $_GET['transhash'] : '';
$btc_amount = isset($_GET['btc_amount']) ? $_GET['btc_amount'] : '';

// Load PHPMailer classes using Composer's autoload.
// Ensure PHPMailer is installed via Composer: `composer require phpmailer/phpmailer`
require '../vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Check that the request method is GET (since we're using query parameters)
if ($_SERVER['REQUEST_METHOD'] === 'GET') {

    // Initialize PHPMailer
    $mail = new PHPMailer(true);

    try {
        // Configure SMTP settings (update these with your actual SMTP details)
        $mail->isSMTP();
        $mail->Host       = 'bitvros.com';         // Your SMTP server
        $mail->SMTPAuth   = true;
        $mail->Username   = 'noreply@bitvros.com';        // Your SMTP username/email
        $mail->Password   = 'Bitv@9034';                       // Your SMTP password
        $mail->SMTPSecure = 'tls';                           // Encryption (or 'ssl' if required)
        $mail->Port       = 587;                             // SMTP port

        // Set sender and recipient details
        $mail->setFrom('noreply@bitvros.com', 'bitvros.com');
        $mail->addAddress($email);  // Recipient is the logged-in user's email (or the email from GET)

        // Compose the HTML email
        $mail->isHTML(true);
        $mail->Subject = 'Transaction Confirmation';
        $mail->Body    = "
            <html>
            <head>
                <style>
                    body { font-family: Arial, sans-serif; }
                    .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                    .header { background-color: #f7931a; color: white; padding: 10px; text-align: center; }
                    .content { margin-top: 20px; }
                    .footer { margin-top: 30px; font-size: 12px; text-align: center; color: #777; }
                    .details { list-style: none; padding: 0; }
                    .details li { margin: 10px 0; }
                </style>
            </head>
            <body>
                <div class='container'>
                    <div class='header'>
                        <h1>Transaction Confirmation</h1>
                    </div>
                    <div class='content'>
                        <p>Your transaction has been processed successfully. Here are the details:</p>
                        <ul class='details'>
                            <li><strong>Transaction Hash:</strong> {$transhash}</li>
                            <li><strong>Amount Sent:</strong> {$btc_amount} BTC</li>
                            <li><strong>Wallet Address:</strong> {$wallet}</li>
                        </ul>
                    </div>
                    <div class='footer'>
                        <p>Thank you for using our service.</p>
                    </div>
                </div>
            </body>
            </html>
        ";

        // Provide a plain-text alternative for email clients that do not support HTML
        $mail->AltBody = "Transaction Confirmation\nTransaction Hash: {$transhash}\nAmount Sent: {$btc_amount} BTC\nWallet Address: {$wallet}";

        // Send the email
        $mail->send();

        // Optionally, you can echo a success message or redirect to a success page
        echo "Email sent successfully.";
        // header("Location: success.php");
        // exit();

    } catch (Exception $e) {
        // If email sending fails, output the error message
        echo "Email could not be sent. Mailer Error: " . $mail->ErrorInfo;
    }

} else {
    echo "Invalid request method.";
}
?>