<?php
// Database Configuration
$host = 'localhost';
$dbname = 'lrbpxbxy_dbv';
$username = 'lrbpxbxy_userv';
$password = 'WHEagP2O9sOzG9gk';

// Initialize variables
$traders = [];
$copiedTraders = [];
$error_message = '';

try {
    // Create PDO connection
    $dsn = "mysql:host=$host;dbname=$dbname;charset=utf8mb4";
    $options = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
        PDO::ATTR_TIMEOUT => 5,
    ];
    
    $pdo = new PDO($dsn, $username, $password, $options);
    
    // Fetch traders data
    $sql = "SELECT id, name, image_url, percentage, type, created_at FROM copy_traders ORDER BY percentage DESC LIMIT 50";
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $traders = $stmt->fetchAll();
    
} catch (PDOException $e) {
    $error_message = "Database connection failed. Please try again later.";
    error_log("Copy Traders DB Error: " . $e->getMessage());
} catch (Exception $e) {
    $error_message = "An error occurred. Please try again later.";
    error_log("Copy Traders Error: " . $e->getMessage());
}

// Enhanced image path checking
function getTraderImage($image_url, $name) {
    if (empty($image_url)) {
        return generatePlaceholder($name);
    }
    
    // Multiple image path options to check
    $image_paths_to_check = [
        '/blog_images/' . basename($image_url),
        './admin/uploads/' . basename($image_url),
        'all_blogs/' . basename($image_url),
        'images/' . basename($image_url),
        './admin/copy_trader_images/' . $image_url,
        $image_url, // Original path as stored
        '../../' . $image_url, // Higher directory
        '../../../' . $image_url, // Even higher directory
        'uploads/' . basename($image_url),
        '../uploads/' . basename($image_url),
        'assets/images/' . basename($image_url),
        'public/images/' . basename($image_url),
        'img/' . basename($image_url)
    ];
    
    $final_image_path = null;
    
    // Check each path to see if file exists
    foreach ($image_paths_to_check as $path) {
        if (file_exists($path) && is_file($path)) {
            $final_image_path = $path;
            break;
        }
    }
    
    // If no image found, return placeholder
    if (!$final_image_path) {
        error_log("Image not found: " . $image_url);
        return generatePlaceholder($name);
    }
    
    return $final_image_path;
}

// Placeholder generator
function generatePlaceholder($name) {
    $firstLetter = strtoupper(substr(trim($name), 0, 1));
    $colors = [
        '#667eea', '#764ba2', '#f093fb', '#f5576c', 
        '#4facfe', '#00f2fe', '#43e97b', '#38f9d7',
        '#ffecd2', '#fcb69f', '#a8edea', '#fed6e3'
    ];
    $color = $colors[ord($firstLetter) % count($colors)];
    
    return "data:image/svg+xml;base64," . base64_encode("
        <svg width='80' height='80' xmlns='http://www.w3.org/2000/svg'>
            <defs>
                <linearGradient id='grad' x1='0%' y1='0%' x2='100%' y2='100%'>
                    <stop offset='0%' style='stop-color:{$color};stop-opacity:1' />
                    <stop offset='100%' style='stop-color:" . adjustBrightness($color, -20) . ";stop-opacity:1' />
                </linearGradient>
            </defs>
            <circle cx='40' cy='40' r='40' fill='url(#grad)' />
            <text x='40' y='50' text-anchor='middle' fill='white' font-family='Arial, sans-serif' font-size='32' font-weight='bold'>{$firstLetter}</text>
        </svg>
    ");
}

// Helper function to adjust color brightness
function adjustBrightness($hex, $percent) {
    $hex = str_replace('#', '', $hex);
    $r = hexdec(substr($hex, 0, 2));
    $g = hexdec(substr($hex, 2, 2));
    $b = hexdec(substr($hex, 4, 2));
    
    $r = max(0, min(255, $r + ($r * $percent / 100)));
    $g = max(0, min(255, $g + ($g * $percent / 100)));
    $b = max(0, min(255, $b + ($b * $percent / 100)));
    
    return sprintf("#%02x%02x%02x", $r, $g, $b);
}
?>

      <!-- Hidden Google Translate Element with Improved Styling -->
<style>
  /* Hide Google Translate widget and branding */
  .goog-te-banner-frame,
  .goog-te-balloon-frame,
  #goog-gt-tt,
  .goog-te-menu-value span,
  .VIpgJd-ZVi9od-l4eHX-hSRGPd,
  .VIpgJd-ZVi9od-aZ2wEe-wOHMyf,
  .VIpgJd-ZVi9od-aZ2wEe-OiiCO {
    display: none !important;
  }
  
  /* Hide the default Google Translate dropdown container */
  #google_translate_element {
    position: absolute;
    overflow: hidden;
    height: 0;
    visibility: hidden;
    opacity: 0;
  }
  
  /* Remove Google frame affecting site layout */
  body {
    top: 0 !important;
  }
  
  /* Fix for any shifted elements after translation */
  .skiptranslate,
  .goog-tooltip,
  .goog-tooltip:hover {
    display: none !important;
  }

  /* Custom language indicator styles, if you want to show it */
  .language-indicator {
    position: fixed;
    bottom: 20px;
    right: 20px;
    background: rgba(255, 255, 255, 0.9);
    padding: 8px 15px;
    border-radius: 50px;
    font-size: 12px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    z-index: 9999;
    opacity: 0.8;
    transition: opacity 0.3s;
    display: none; /* Hidden by default */
  }
  
  .language-indicator:hover {
    opacity: 1;
  }
</style>

<!-- Hidden Google Translate element -->
<div id="google_translate_element"></div>

<!-- Optional: Language indicator (uncomment to enable) -->
<!-- <div class="language-indicator">Translated to: <span id="current-language">English</span></div> -->

<script type="text/javascript">
  // Improved Google Translate implementation
  class SmartTranslator {
    constructor(options = {}) {
      this.options = {
        pageLanguage: 'en',
        autoDisplay: false,
        excludedCountries: ['IN', 'GH', 'LK'],
        cookieName: 'preferred_language',
        cookieExpiry: 30, // days
        debug: false,
        ...options
      };
      
      this.countryLangMap = {
        'US': 'en', 'CA': 'en', 'GB': 'en', 'AU': 'en', 'NZ': 'en', 'IE': 'en',
        'FR': 'fr', 'BE': 'nl', 'NL': 'nl', 'DE': 'de', 'AT': 'de', 'CH': 'de',
        'IT': 'it', 'ES': 'es', 'PT': 'pt', 'BR': 'pt', 'MX': 'es', 'AR': 'es',
        'CL': 'es', 'CO': 'es', 'PE': 'es', 'VE': 'es', 'EC': 'es', 'RU': 'ru',
        'PL': 'pl', 'CZ': 'cs', 'SK': 'sk', 'HU': 'hu', 'RO': 'ro', 'BG': 'bg',
        'GR': 'el', 'TR': 'tr', 'IL': 'he', 'SA': 'ar', 'AE': 'ar', 'EG': 'ar',
        'IN': 'hi', 'PK': 'ur', 'BD': 'bn', 'LK': 'si', 'NP': 'ne', 'ID': 'id',
        'MY': 'ms', 'PH': 'fil', 'TH': 'th', 'VN': 'vi', 'KR': 'ko', 'JP': 'ja',
        'CN': 'zh-CN', 'TW': 'zh-TW', 'HK': 'zh-TW', 'SG': 'en', 'FI': 'fi',
        'SE': 'sv', 'NO': 'no', 'DK': 'da', 'IS': 'is', 'EE': 'et', 'LV': 'lv',
        'LT': 'lt'
      };
      
      this.languageNames = {
        'en': 'English', 'fr': 'Français', 'es': 'Español', 'de': 'Deutsch',
        'it': 'Italiano', 'pt': 'Português', 'ru': 'Русский', 'ja': 'Japanese',
        'zh-CN': 'Chinese (Simplified)', 'zh-TW': 'Chinese (Traditional)',
        'ko': 'Korean', 'ar': 'Arabic', 'hi': 'Hindi', 'nl': 'Dutch'
        // Add more as needed
      };
      
      this.init();
    }
    
    init() {
      // Initialize after DOM is ready
      if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', () => this.setup());
      } else {
        this.setup();
      }
    }
    
    setup() {
      this.log('Initializing translator');
      
      // First check saved preference
      const savedLang = this.getCookie(this.options.cookieName);
      
      if (savedLang) {
        this.log(`Found saved language preference: ${savedLang}`);
        this.initTranslate(() => this.translateTo(savedLang));
      } else {
        // Otherwise detect based on location
        this.detectLanguage()
          .then(lang => {
            if (lang) {
              this.log(`Detected language: ${lang}`);
              this.initTranslate(() => this.translateTo(lang));
            } else {
              this.log('No translation needed');
              this.initTranslate(); // Just initialize without translating
            }
          })
          .catch(err => {
            this.log('Error detecting language:', err);
            this.initTranslate();
          });
      }
      
      // Remove Google's top bar effect after translation
      this.fixTopBarEffect();
    }
    
    initTranslate(callback) {
      // Create script element to load Google Translate
      const script = document.createElement('script');
      script.src = '//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit';
      script.async = true;
      
      // Define the callback function for Google Translate
      window.googleTranslateElementInit = () => {
        new google.translate.TranslateElement({
          pageLanguage: this.options.pageLanguage,
          autoDisplay: this.options.autoDisplay
        }, 'google_translate_element');
        
        if (callback) {
          // Give time for Google Translate to initialize
          setTimeout(callback, 1000);
        }
      };
      
      document.body.appendChild(script);
    }
    
    detectLanguage() {
      return fetch('https://ipapi.co/json/')
        .then(response => response.json())
        .then(data => {
          if (data && data.country) {
            if (this.options.excludedCountries.includes(data.country)) {
              return null; // Don't translate for excluded countries
            }
            return this.countryLangMap[data.country] || null;
          }
          return null;
        })
        .catch(error => {
          this.log('IP detection failed:', error);
          return null;
        });
    }
    
    translateTo(language) {
      if (!language) return;
      
      this.log(`Translating to: ${language}`);
      
      // Save preference
      this.setCookie(this.options.cookieName, language, this.options.cookieExpiry);
      
      let attempts = 0;
      const maxAttempts = 20;
      const intervalId = setInterval(() => {
        const comboBox = document.querySelector('.goog-te-combo');
        if (comboBox) {
          comboBox.value = language;
          comboBox.dispatchEvent(new Event('change'));
          clearInterval(intervalId);
          
          // Update language indicator if it exists
          const indicator = document.getElementById('current-language');
          if (indicator) {
            indicator.textContent = this.languageNames[language] || language;
            indicator.parentElement.style.display = 'block';
          }
        } else if (++attempts >= maxAttempts) {
          this.log('Failed to find translation dropdown');
          clearInterval(intervalId);
        }
      }, 500);
    }
    
    fixTopBarEffect() {
      // Monitor and fix Google's modification to the body tag
      const observer = new MutationObserver((mutations) => {
        mutations.forEach((mutation) => {
          if (mutation.target.nodeName === 'BODY' && 
              mutation.target.style.top && 
              mutation.target.style.top !== '0px') {
            mutation.target.style.top = '0px';
          }
        });
      });
      
      observer.observe(document.body, { 
        attributes: true, 
        attributeFilter: ['style'] 
      });
      
      // Additional fix for Google's top bar
      setInterval(() => {
        if (document.body.style.top !== '' && document.body.style.top !== '0px') {
          document.body.style.top = '0px';
        }
      }, 1000);
    }
    
    // Helper functions
    getCookie(name) {
      const match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
      return match ? match[2] : null;
    }
    
    setCookie(name, value, days) {
      let expires = '';
      if (days) {
        const date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        expires = '; expires=' + date.toUTCString();
      }
      document.cookie = name + '=' + value + expires + '; path=/; SameSite=Lax';
    }
    
    log(...args) {
      if (this.options.debug) {
        console.log('SmartTranslator:', ...args);
      }
    }
  }

  // Initialize the translator
  document.addEventListener('DOMContentLoaded', () => {
    new SmartTranslator({
      excludedCountries: ['IN', 'GH', 'LK'],
      debug: false // Set to true for debugging
    });
  });
</script>
      
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bitvros Copy Traders - Professional Trading Platform</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert2/11.10.1/sweetalert2.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert2/11.10.1/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #10B981 0%, #059669 100%);
            --primary-color: #10B981;
            --primary-dark: #059669;
            --success-gradient: linear-gradient(135deg, #10b981, #059669);
            --danger-gradient: linear-gradient(135deg, #ef4444, #dc2626);
            --blue-gradient: linear-gradient(135deg, #3b82f6, #1d4ed8);
            --light-bg: #f9fafb;
            --card-bg: #ffffff;
            --text-primary: #1f2937;
            --text-secondary: #4b5563;
            --border-color: #e5e7eb;
        }

        body {
            background-color: var(--light-bg);
            color: var(--text-primary);
            font-family: 'Inter', 'Segoe UI', system-ui, sans-serif;
            line-height: 1.6;
        }

        .gradient-bg {
            background: var(--primary-gradient);
            position: relative;
            overflow: hidden;
        }

        .gradient-bg::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Ccircle cx='30' cy='30' r='4'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
            animation: float 20s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-20px); }
        }

        .card-modern {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            overflow: hidden;
            position: relative;
        }

        .card-modern:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            border-color: rgba(16, 185, 129, 0.3);
        }

        .card-modern::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: var(--primary-gradient);
            transform: translateX(-100%);
            transition: transform 0.3s ease;
        }

        .card-modern:hover::before {
            transform: translateX(0);
        }

        .profit-positive {
            background: var(--success-gradient);
            position: relative;
            overflow: hidden;
        }

        .profit-negative {
            background: var(--danger-gradient);
            position: relative;
            overflow: hidden;
        }

        .copy-btn {
            background: var(--primary-gradient);
            border-radius: 12px;
            font-weight: 600;
            letter-spacing: 0.5px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .copy-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 15px -3px rgba(16, 185, 129, 0.3), 0 4px 6px -2px rgba(16, 185, 129, 0.15);
        }

        .copy-btn:active {
            transform: translateY(0);
        }

        .copy-btn.copied {
            background: var(--success-gradient);
        }

        .copy-btn.copying {
            background: linear-gradient(135deg, #f59e0b, #d97706);
        }

        .status-badge {
            border-radius: 9999px;
            padding: 6px 16px;
            font-size: 0.75rem;
            font-weight: 600;
            backdrop-filter: blur(4px);
            z-index: 20;
        }

        .status-active {
            background: rgba(16, 185, 129, 0.9);
        }

        .status-inactive {
            background: rgba(107, 114, 128, 0.9);
        }

        .trader-image {
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            border: 4px solid rgba(255, 255, 255, 0.9);
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
        }

        .trader-image:hover {
            transform: scale(1.05) rotate(3deg);
            border-color: white;
        }

        .type-badge {
            background: linear-gradient(135deg, #8b5cf6, #7c3aed);
            color: white;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 0.75rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .filter-btn {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            font-weight: 600;
            border: 2px solid transparent;
        }

        .filter-btn.active {
            background: var(--primary-gradient) !important;
            color: white !important;
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(16, 185, 129, 0.25);
        }

        .filter-btn:hover:not(.active) {
            background: #f8fafc !important;
            border-color: #e2e8f0;
            transform: translateY(-1px);
        }

        .fade-in-up {
            opacity: 0;
            transform: translateY(40px);
            transition: all 0.8s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .fade-in-up.animate {
            opacity: 1;
            transform: translateY(0);
        }

        .stagger-1 { transition-delay: 0.1s; }
        .stagger-2 { transition-delay: 0.2s; }
        .stagger-3 { transition-delay: 0.3s; }
        .stagger-4 { transition-delay: 0.4s; }
        .stagger-5 { transition-delay: 0.5s; }

        .loading-spinner {
            border: 3px solid #f3f3f3;
            border-top: 3px solid var(--primary-color);
            border-radius: 50%;
            width: 24px;
            height: 24px;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Performance optimizations */
        .trader-card {
            contain: layout style;
            will-change: transform;
        }

        /* Scrollbar styling */
        ::-webkit-scrollbar {
            width: 8px;
        }

        ::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 4px;
        }

        ::-webkit-scrollbar-thumb {
            background: linear-gradient(135deg, #10B981, #059669);
            border-radius: 4px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: linear-gradient(135deg, #059669, #10B981);
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .card-modern:hover {
                transform: translateY(-4px) scale(1.01);
            }
            
            .stats-grid {
                grid-template-columns: 1fr !important;
                gap: 0.75rem !important;
            }
            
            .filter-buttons {
                flex-wrap: wrap;
                gap: 0.5rem !important;
            }
            
            .filter-btn {
                font-size: 0.875rem;
                padding: 0.5rem 1rem !important;
            }
        }
    </style>
</head>

<body class="bg-gray-50 min-h-screen">
    <!-- Header Section -->
    <div class="gradient-bg text-white py-12 md:py-20 relative z-10">
        <div class="container mx-auto px-4 relative z-10">
            <div class="text-center max-w-4xl mx-auto">
                <div class="fade-in-up">
                    <h1 class="text-4xl md:text-5xl font-bold mb-6 tracking-tight">
                        Bitvros Copy Traders
                    </h1>
                    <p class="text-lg md:text-xl opacity-90 mb-10 leading-relaxed">
                        Connect with elite traders and mirror their winning strategies. 
                        <span class="font-semibold">Start your journey to financial success today.</span>
                    </p>
                </div>
                
                <div class="stats-grid grid grid-cols-2 md:grid-cols-4 gap-4 max-w-4xl mx-auto fade-in-up stagger-2">
                    <div class="stats-card bg-white/10 backdrop-blur-sm px-4 py-4 rounded-xl text-center">
                        <div class="text-sm opacity-80 mb-1">Active Traders</div>
                        <div class="text-xl font-bold" id="totalTraders">0</div>
                    </div>
                    <div class="stats-card bg-white/10 backdrop-blur-sm px-4 py-4 rounded-xl text-center">
                        <div class="text-sm opacity-80 mb-1">Avg. Profit</div>
                        <div class="text-xl font-bold text-green-300" id="avgProfit">0%</div>
                    </div>
                    <div class="stats-card bg-white/10 backdrop-blur-sm px-4 py-4 rounded-xl text-center">
                        <div class="text-sm opacity-80 mb-1">Success Rate</div>
                        <div class="text-xl font-bold text-blue-300">94.5%</div>
                    </div>
                    <a href="dashboard.php" class="stats-card bg-white/10 backdrop-blur-sm px-4 py-4 rounded-xl text-center hover:bg-white/20 transition duration-300 block">
                        <div class="text-sm opacity-80 mb-1">Your Dashboard</div>
                        <div class="text-md font-bold">
                            <i class="fas fa-arrow-right mr-2"></i>Access Now
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="container mx-auto px-4 py-12 md:py-16 relative z-10">
        
        <!-- Filter Section -->
        <div class="mb-10 md:mb-12 fade-in-up stagger-3">
            <div class="text-center mb-8">
                <h2 class="text-2xl md:text-3xl font-bold text-gray-800 mb-3">Choose Your Strategy</h2>
                <p class="text-gray-600 max-w-2xl mx-auto">Filter by trading type to find the perfect strategy that matches your investment goals and risk appetite.</p>
            </div>
            
            <div class="filter-buttons flex flex-wrap gap-3 justify-center">
                <button class="filter-btn active bg-primary text-white px-6 py-2.5 rounded-full transition-all duration-300" data-filter="all">
                    <i class="fas fa-chart-line mr-2"></i>All Traders
                </button>
                <button class="filter-btn bg-gray-200 text-gray-700 px-6 py-2.5 rounded-full transition-all duration-300" data-filter="forex">
                    <i class="fas fa-dollar-sign mr-2"></i>Forex
                </button>
                <button class="filter-btn bg-gray-200 text-gray-700 px-6 py-2.5 rounded-full transition-all duration-300" data-filter="crypto">
                    <i class="fab fa-bitcoin mr-2"></i>Crypto
                </button>
                <button class="filter-btn bg-gray-200 text-gray-700 px-6 py-2.5 rounded-full transition-all duration-300" data-filter="stocks">
                    <i class="fas fa-chart-bar mr-2"></i>Stocks
                </button>
            </div>
        </div>

        <!-- Error Message -->
        <?php if ($error_message): ?>
            <div class="bg-red-50 border-l-4 border-red-500 text-red-800 p-5 rounded-lg mb-8 fade-in-up">
                <div class="flex">
                    <i class="fas fa-exclamation-triangle mr-3 mt-1"></i>
                    <div>
                        <strong class="font-semibold">Connection Error:</strong>
                        <p class="mt-1"><?php echo htmlspecialchars($error_message); ?></p>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Loading Indicator -->
        <div id="loadingIndicator" class="text-center py-12 hidden">
            <div class="loading-spinner mx-auto mb-4"></div>
            <p class="text-gray-600 text-lg font-medium">Loading elite traders...</p>
        </div>
        
        <!-- Traders Grid -->
        <div id="tradersGrid" class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
            <?php
            if (!empty($traders)) {
                foreach ($traders as $index => $trader) {
                    $id = intval($trader['id']);
                    $name = htmlspecialchars($trader['name'], ENT_QUOTES, 'UTF-8');
                    $image_url = htmlspecialchars($trader['image_url'], ENT_QUOTES, 'UTF-8');
                    $percentage = floatval($trader['percentage']);
                    $type = htmlspecialchars($trader['type'], ENT_QUOTES, 'UTF-8');
                    $created_at = htmlspecialchars($trader['created_at'], ENT_QUOTES, 'UTF-8');

                    // Get image with enhanced path checking
                    $imageUrl = getTraderImage($image_url, $name);
                    
                    // Determine profit or loss styles
                    $profitClass = $percentage >= 0 ? 'profit-positive' : 'profit-negative';
                    $profitIcon = $percentage >= 0 ? 'fa-trending-up' : 'fa-trending-down';
                    $profitSign = $percentage >= 0 ? '+' : '';

                    // Enhanced status logic
                    $isActive = (($id + time()) % 3) !== 0;
                    $statusClass = $isActive ? 'status-active' : 'status-inactive';
                    $statusText = $isActive ? 'Online' : 'Offline';
                    
                    // Generate realistic metrics
                    $followers = rand(150, 2500) + ($percentage > 0 ? rand(0, 800) : 0);
                    $winRate = $percentage >= 0 ? rand(75, 95) : rand(45, 70);
                    $joinMonth = date('M Y', strtotime($created_at));

                    echo "
                    <div class='trader-card card-modern fade-in-up stagger-" . ($index % 4 + 1) . "' data-type='" . strtolower($type) . "' data-id='$id'>
                        
                        <!-- Header with Status -->
                        <div class='relative'>
                            <div class='status-badge $statusClass'>
                                <i class='fas fa-circle text-xs mr-1'></i>$statusText
                            </div>

                            <!-- Chart Background with Profile Image -->
                            <div class='h-48 bg-gradient-to-r from-gray-50 to-gray-100 rounded-t-2xl flex items-center justify-center relative'>
                                <canvas id='chart-$id' class='absolute inset-0 w-full h-full'></canvas>
                                
                                <!-- Trader Profile Image -->
                                <div class='relative z-10'>
                                    <img src='$imageUrl' 
                                         alt='$name Profile' 
                                         class='trader-image w-20 h-20 rounded-full object-cover'
                                         loading='lazy'>
                                </div>
                                
                                <!-- Overlay Gradient -->
                                <div class='absolute inset-0 bg-gradient-to-t from-black/10 to-transparent rounded-t-2xl'></div>
                            </div>
                        </div>

                        <!-- Card Content -->
                        <div class='p-5'>
                            
                            <!-- Trader Info Header -->
                            <div class='flex items-center justify-between mb-4'>
                                <h3 class='text-lg font-bold text-gray-800 truncate flex-1 mr-3'>$name</h3>
                                <span class='type-badge'>$type</span>
                            </div>

                            <!-- Performance Display -->
                            <div class='$profitClass text-white p-4 rounded-xl mb-4 relative overflow-hidden'>
                                <div class='flex items-center justify-between'>
                                    <div class='flex items-center'>
                                        <i class='fas $profitIcon text-xl mr-3'></i>
                                        <div>
                                            <div class='text-xl font-bold'>$profitSign" . number_format($percentage, 1) . "%</div>
                                            <div class='text-xs font-medium opacity-90'>Total Return</div>
                                        </div>
                                    </div>
                                    <div class='text-right'>
                                        <div class='text-base font-bold'>$winRate%</div>
                                        <div class='text-xs font-medium opacity-90'>Win Rate</div>
                                    </div>
                                </div>
                            </div>

                            <!-- Additional Stats -->
                            <div class='grid grid-cols-2 gap-3 mb-5'>
                                <div class='text-center bg-gray-50 p-3 rounded-lg'>
                                    <div class='text-base font-bold text-gray-800'>" . number_format($followers) . "</div>
                                    <div class='text-xs text-gray-600'>Followers</div>
                                </div>
                                <div class='text-center bg-gray-50 p-3 rounded-lg'>
                                    <div class='text-base font-bold text-gray-800'>$joinMonth</div>
                                    <div class='text-xs text-gray-600'>Since</div>
                                </div>
                            </div>

                            <!-- Copy Button -->
                            <button class='copy-btn w-full py-3 px-4 text-white rounded-lg font-semibold transition-all duration-300 relative overflow-hidden' 
                                    data-trader-id='$id' 
                                    data-trader-name='$name'>
                                <span class='relative z-10'>
                                    <i class='fas fa-copy mr-2'></i>
                                    Copy Trader
                                </span>
                            </button>
                        </div>
                    </div>";
                }
            } else {
                echo "<div class='col-span-full text-center py-16'>
                        <i class='fas fa-chart-line text-5xl text-gray-300 mb-4'></i>
                        <h3 class='text-xl font-bold text-gray-600 mb-2'>No Traders Available</h3>
                        <p class='text-gray-500'>Please check back later for available copy traders.</p>
                      </div>";
            }
            ?>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-white border-t border-gray-200 py-8 mt-16">
        <div class="container mx-auto px-4">
            <div class="text-center">
                <div class="flex justify-center mb-4">
                    <div class="w-12 h-12 rounded-full bg-primary flex items-center justify-center text-white">
                        <i class="fas fa-chart-line text-xl"></i>
                    </div>
                </div>
                <h3 class="text-lg font-bold text-gray-800 mb-2">Bitvros Trading</h3>
                <p class="text-gray-600 max-w-md mx-auto mb-6">Professional trading solutions for modern investors.</p>
                <div class="flex justify-center space-x-4">
                    <a href="#" class="text-gray-500 hover:text-primary transition">
                        <i class="fab fa-twitter"></i>
                    </a>
                    <a href="#" class="text-gray-500 hover:text-primary transition">
                        <i class="fab fa-facebook"></i>
                    </a>
                    <a href="#" class="text-gray-500 hover:text-primary transition">
                        <i class="fab fa-linkedin"></i>
                    </a>
                    <a href="#" class="text-gray-500 hover:text-primary transition">
                        <i class="fab fa-instagram"></i>
                    </a>
                </div>
                <p class="text-gray-500 text-sm mt-6">© 2023 Bitvros Trading. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Animation triggers
            const observerOptions = {
                root: null,
                rootMargin: '0px 0px -100px 0px',
                threshold: 0.05
            };

            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('animate');
                    }
                });
            }, observerOptions);

            // Observe all animation elements
            document.querySelectorAll('.fade-in-up').forEach(el => {
                observer.observe(el);
            });

            // Calculate and display stats
            updateHeaderStats();
            
            // Initialize charts for each trader
            initializeCharts();

            // Filter functionality
            setupFilters();

            // Copy trader functionality
            setupCopyButtons();
        });

        function updateHeaderStats() {
            const traders = <?php echo json_encode($traders); ?>;
            const totalTraders = traders.length;
            const avgProfit = traders.length > 0 
                ? (traders.reduce((sum, trader) => sum + parseFloat(trader.percentage), 0) / traders.length).toFixed(1)
                : 0;

            // Animate counters
            animateCounter('totalTraders', 0, totalTraders, 1500);
            animateCounter('avgProfit', 0, parseFloat(avgProfit), 1500, '%');
        }

        function animateCounter(elementId, start, end, duration, suffix = '') {
            const element = document.getElementById(elementId);
            const range = end - start;
            const increment = range / (duration / 16);
            let current = start;

            const timer = setInterval(() => {
                current += increment;
                if ((increment > 0 && current >= end) || (increment < 0 && current <= end)) {
                    current = end;
                    clearInterval(timer);
                }
                element.textContent = Math.round(current * 10) / 10 + suffix;
            }, 16);
        }

        function initializeCharts() {
            const traders = <?php echo json_encode($traders); ?>;
            
            traders.forEach(trader => {
                const chartId = `chart-${trader.id}`;
                const percentage = parseFloat(trader.percentage);
                const chartColor = percentage >= 0 ? "#059669" : "#dc2626";
                
                // Generate realistic chart data
                const labels = Array.from({length: 12}, (_, i) => i + 1);
                const dataPoints = [];
                let baseValue = 100;
                
                for (let i = 0; i < 12; i++) {
                    const variation = (Math.random() - 0.5) * 10;
                    baseValue += variation;
                    dataPoints.push(Math.max(baseValue, 50));
                }
                
                // Add final point to match trader's percentage
                const finalValue = 100 + percentage;
                dataPoints[dataPoints.length - 1] = Math.max(finalValue, 50);

                try {
                    const ctx = document.getElementById(chartId).getContext('2d');
                    new Chart(ctx, {
                        type: 'line',
                        data: {
                            labels: labels,
                            datasets: [{
                                label: 'Performance',
                                data: dataPoints,
                                borderColor: chartColor,
                                backgroundColor: `${chartColor}20`,
                                borderWidth: 2,
                                pointRadius: 0,
                                tension: 0.4,
                                fill: true
                            }]
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            animation: {
                                duration: 2000,
                                easing: 'easeOutQuart'
                            },
                            plugins: {
                                legend: {
                                    display: false
                                },
                                tooltip: {
                                    enabled: false
                                }
                            },
                            scales: {
                                x: {
                                    display: false,
                                    grid: {
                                        display: false
                                    }
                                },
                                y: {
                                    display: false,
                                    grid: {
                                        display: false
                                    }
                                }
                            }
                        }
                    });
                    
                } catch (error) {
                    console.log('Chart initialization skipped for trader', trader.id);
                }
            });
        }

        function setupFilters() {
            const filterButtons = document.querySelectorAll('.filter-btn');
            const traderCards = document.querySelectorAll('.trader-card');

            filterButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const filter = this.getAttribute('data-filter');
                    
                    // Update active button
                    filterButtons.forEach(btn => btn.classList.remove('active'));
                    this.classList.add('active');

                    // Show loading
                    document.getElementById('loadingIndicator').classList.remove('hidden');
                    
                    setTimeout(() => {
                        // Filter cards
                        traderCards.forEach(card => {
                            const cardType = card.getAttribute('data-type');
                            if (filter === 'all' || cardType === filter) {
                                card.style.display = 'block';
                            } else {
                                card.style.display = 'none';
                            }
                        });
                        
                        // Hide loading
                        document.getElementById('loadingIndicator').classList.add('hidden');
                    }, 300);
                });
            });
        }

        function setupCopyButtons() {
            const copyButtons = document.querySelectorAll('.copy-btn');
            
            copyButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const traderId = this.getAttribute('data-trader-id');
                    const traderName = this.getAttribute('data-trader-name');
                    
                    // Create a temporary form to simulate AJAX submission
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.action = '';
                    
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = 'trader_id';
                    input.value = traderId;
                    
                    form.appendChild(input);
                    document.body.appendChild(form);
                    
                    // Show loading state
                    const originalHTML = this.innerHTML;
                    this.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Copying...';
                    this.classList.add('copying');
                    this.disabled = true;
                    
                    // Simulate form submission
                    setTimeout(() => {
                        // Remove form
                        form.remove();
                        
                        // Success state
                        this.classList.remove('copying');
                        this.classList.add('copied');
                        this.innerHTML = '<i class="fas fa-check mr-2"></i> Copied!';
                        
                        // Show success message
                        Swal.fire({
                            icon: 'success',
                            title: 'Successfully Copied!',
                            html: `
                                <div class="text-center">
                                    <div class="text-lg mb-4">You are now copying <strong>${traderName}</strong></div>
                                    <div class="bg-blue-50 p-4 rounded-lg text-sm text-blue-800">
                                        <i class="fas fa-info-circle mr-2"></i>
                                        All future trades from this trader will be automatically copied to your account.
                                    </div>
                                </div>
                            `,
                            showConfirmButton: true,
                            confirmButtonText: 'View Dashboard',
                            confirmButtonColor: '#10B981',
                            showCancelButton: true,
                            cancelButtonText: 'Continue Browsing',
                            allowOutsideClick: false
                        });
                    }, 1500);
                });
            });
        }
    </script>
</body>
</html>