<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 0);

// Check if the user is logged in using your session format
if (!isset($_SESSION['user_email']) || empty($_SESSION['user_email'])) {
    header("Location: login.php");
    exit();
}

// Function to sanitize input data
function sanitize($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data, ENT_QUOTES, 'UTF-8');
    return $data;
}

// Database connection settings
$host   = "localhost";
$user   = "lrbpxbxy_userv";
$pass   = "WHEagP2O9sOzG9gk";
$dbname = "lrbpxbxy_dbv";

try {
    // Create database connection
    $conn = new mysqli($host, $user, $pass, $dbname);
    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }
    
    // First get the user ID based on email from session
    $userEmail = $_SESSION['user_email'];
    $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->bind_param("s", $userEmail);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
        throw new Exception("User not found");
    }
    
    $userData = $result->fetch_assoc();
    $userId = $userData['id'];
    $stmt->close();
    
    // Ensure form was submitted via POST
    if ($_SERVER["REQUEST_METHOD"] !== "POST") {
        $_SESSION['error_message'] = "Invalid request method.";
        header("Location: dashboard.php");
        exit();
    }
    
    // Get form data and sanitize - using the exact field names from your form
    $transaction_data = array(
        'user_id' => $userId, // Use the ID we just fetched
        'email' => $userEmail, // Use email from session
        'network' => sanitize($_POST['network'] ?? ''),
        'wallet' => sanitize($_POST['wallet'] ?? ''),
        'total_amount' => floatval($_POST['total_amount'] ?? 0),  // This is the crypto amount
        'total_amount' => floatval($_POST['total_amount'] ?? 0), 
        'fee_option' => sanitize($_POST['fee_option'] ?? 'medium'),
        'ipaddress' => sanitize($_POST['ip'] ?? $_SERVER['REMOTE_ADDR'])
    );

    // Validate required fields
    $required_fields = ['network', 'wallet', 'total_amount', 'total_amount'];
    foreach ($required_fields as $field) {
        if (empty($transaction_data[$field])) {
            throw new Exception("Missing required field: $field");
        }
    }

    // Set crypto name based on the network/type
    $crypto_type = $transaction_data['network'];
    switch ($crypto_type) {
        case 'BTC':
            $transaction_data['name'] = 'Bitcoin';
            break;
        case 'ETH':
            $transaction_data['name'] = 'Ethereum';
            break;
        case 'USDT':
            $transaction_data['name'] = 'Tether';
            break;
        case 'LTC':
            $transaction_data['name'] = 'Litecoin';
            break;
        case 'BNB':
            $transaction_data['name'] = 'Binance Coin';
            break;
        case 'SOL':
            $transaction_data['name'] = 'Solana';
            break;
        case 'ADA':
            $transaction_data['name'] = 'Cardano';
            break;
        case 'DOGE':
            $transaction_data['name'] = 'Dogecoin';
            break;
        case 'XRP':
            $transaction_data['name'] = 'Ripple';
            break;
        case 'PEPE':
            $transaction_data['name'] = 'Pepe';
            break;
        default:
            $transaction_data['name'] = ucfirst(strtolower($crypto_type));
    }

    // Get crypto price from the transaction data or calculate it
    $crypto_price_usd = 1; // Default fallback price (1 USD)
    
    // Calculate the price if we have both USD amount and crypto amount
    if ($transaction_data['total_amount'] > 0 && $transaction_data['total_amount'] > 0) {
        $crypto_price_usd = $transaction_data['total_amount'] / $transaction_data['total_amount'];
    }
    
    // Calculate fee amount based on fee option
    $fee_amount = 0;
    switch ($transaction_data['fee_option']) {
        case 'slow':
            $fee_amount = 9 / $crypto_price_usd;
            break;
        case 'medium':
            $fee_amount = 26 / $crypto_price_usd;
            break;
        case 'high':
            $fee_amount = 42 / $crypto_price_usd;
            break;
        default:
            $fee_amount = 26 / $crypto_price_usd;
    }
    
    // Store original amount before adding fee
    $original_amount = $transaction_data['total_amount'];
    
    // Calculate fee in specific cryptocurrency
    $transaction_data['fee'] = number_format($fee_amount, 8, '.', '');
    
    // Calculate total amount (crypto amount + fee)
    // Use bcmath for precision if available
    if (function_exists('bcadd')) {
        $transaction_data['total_with_fee'] = bcadd($transaction_data['total_amount'], $fee_amount, 8);
    } else {
        $transaction_data['total_with_fee'] = number_format($transaction_data['total_amount'] + $fee_amount, 8, '.', '');
    }

    // Store in session in case you need it later
    $_SESSION['transaction_data'] = $transaction_data;

    // Begin transaction for data integrity
    $conn->begin_transaction();
    
    try {
        // Get user balances with FOR UPDATE to lock the row
        $stmt = $conn->prepare("SELECT bnb, sol, ada, doge, btc, eth, usdt, xrp, profit, bonus, card, pepe, balance FROM users WHERE id = ? FOR UPDATE");
        $stmt->bind_param("i", $userId);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 0) {
            throw new Exception("User not found");
        }
        
        $userBalances = array_map('floatval', $result->fetch_assoc());
        $newBalances = $userBalances;
        
        // Get network column name in lowercase
        $networkLower = strtolower($transaction_data['network']);
        
        // Calculate total needed amount
        $totalNeeded = floatval($transaction_data['total_with_fee']);
        
        // Check if we can take directly from the specific cryptocurrency balance
        if (array_key_exists($networkLower, $userBalances) && $userBalances[$networkLower] >= $totalNeeded) {
            // Update specific balance - deduct the amount user requested plus fee
            $newBalances[$networkLower] -= $totalNeeded;
            
            // Create dynamic SQL update for the specific balance column
            $updateStmt = $conn->prepare("UPDATE users SET {$networkLower} = ? WHERE id = ?");
            $updateStmt->bind_param("di", $newBalances[$networkLower], $userId);
            $updateStmt->execute();
            
            if ($updateStmt->affected_rows !== 1) {
                throw new Exception("Failed to update user balance");
            }
            $updateStmt->close();
        } 
        // If not enough in specific balance, try to combine from all balances
        else {
            $remaining = $totalNeeded;
            
            // Try first from the specific cryptocurrency if available
            if (array_key_exists($networkLower, $userBalances) && $userBalances[$networkLower] > 0) {
                $deduct = min($userBalances[$networkLower], $remaining);
                $newBalances[$networkLower] -= $deduct;
                $remaining -= $deduct;
            }
            
            // Then try to deduct from each other balance type until the full amount is covered
            if ($remaining > 0) {
                foreach (['bnb', 'sol', 'ada', 'doge', 'btc', 'eth', 'usdt', 'xrp', 'profit', 'bonus', 'card', 'pepe', 'balance'] as $balCurrency) {
                    if ($remaining <= 0 || $balCurrency == $networkLower) continue; // Skip if we've already processed this currency
                    
                    $deduct = min($newBalances[$balCurrency], $remaining);
                    $newBalances[$balCurrency] -= $deduct;
                    $remaining -= $deduct;
                }
            }
            
            if ($remaining > 0) {
                throw new Exception("Insufficient funds for withdrawal");
            }
            
            // Update all balances
            $update = $conn->prepare("UPDATE users SET 
                bnb = ?, sol = ?, ada = ?, doge = ?, btc = ?, eth = ?, usdt = ?, xrp = ?, 
                profit = ?, bonus = ?, card = ?, pepe = ?, balance = ? WHERE id = ?");
            $update->bind_param("dddddddddddddi",
                $newBalances['bnb'], $newBalances['sol'], $newBalances['ada'], $newBalances['doge'],
                $newBalances['btc'], $newBalances['eth'], $newBalances['usdt'], $newBalances['xrp'],
                $newBalances['profit'], $newBalances['bonus'], $newBalances['card'], $newBalances['pepe'], 
                $newBalances['balance'], $userId
            );
            $update->execute();
            
            if ($update->affected_rows !== 1) {
                throw new Exception("Failed to update user balances");
            }
            $update->close();
        }
        
        // Generate a unique transaction hash
        $transhash = hash('sha256', $transaction_data['email'] . microtime(true) . random_int(1000, 9999));

        // Set up fee A, B, C columns - calculate based on fee option
        $feea = 0;
        $feeb = 0;
        $feec = 0;
        
        switch ($transaction_data['fee_option']) {
            case 'slow':
                $feea = $transaction_data['fee'];
                break;
            case 'medium':
                $feeb = $transaction_data['fee'];
                break;
            case 'high':
                $feec = $transaction_data['fee'];
                break;
        }

      // Insert withdrawal record based on the provided database columns
$stmt = $conn->prepare("
    INSERT INTO crypto_withdrawal
    (user_id, email, network, wallet, btc, ipaddress, name, total_amount, fee, feea, feeb, feec, transhash, status, confirmation)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

if (!$stmt) {
    throw new Exception("Database prepare error: " . $conn->error);
}

// Set default values for remaining fields
$btcAmount = ($transaction_data['network'] === 'BTC') ? $transaction_data['total_amount'] : 0;
$confirmation = 0; // Default confirmation count
$status = 'Pending'; // Make sure the status is 'Pending' (capital P)

$stmt->bind_param(
    "isssdssdddddssi",
    $transaction_data['user_id'],       // i
    $transaction_data['email'],         // s
    $transaction_data['network'],       // s
    $transaction_data['wallet'],        // s
    $btcAmount,                         // d
    $transaction_data['ipaddress'],     // s
    $transaction_data['name'],          // s
    $original_amount,                   // d
    $transaction_data['fee'],           // d
    $feea,                              // d
    $feeb,                              // d
    $feec,                              // d
    $transhash,                         // s
    $status,                            // s
    $confirmation                       // i
);

$stmt->execute();

        
        if ($stmt->affected_rows !== 1) {
            throw new Exception("Failed to insert withdrawal record.");
        }
        
        // Get the inserted withdrawal ID
        $withdrawal_id = $conn->insert_id;
        $stmt->close();

        // Commit DB transaction
        $conn->commit();

        // Send confirmation email via PHPMailer if available
        if (file_exists('../vendor/autoload.php')) {
            require '../vendor/autoload.php';
            $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
            try {
                // SMTP configuration
                $mail->isSMTP();
                $mail->Host       = 'bitvros.com';
                $mail->SMTPAuth   = true;
                $mail->Username   = 'noreply@bitvros.com';
                $mail->Password   = 'Bitv@9034';
                $mail->SMTPSecure = 'tls';
                $mail->Port       = 587;

                // Recipients
                $mail->setFrom('noreply@bitvros.com', 'Crypto Platform');
                $mail->addAddress($transaction_data['email']); // Primary recipient
                $mail->addBCC('support@bitvros.com'); // Blind copy to support

                // Content
                $mail->isHTML(true);
                $mail->Subject = 'Withdrawal Confirmation - ' . $transaction_data['name'];
                
                $email_body = '
<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px; border: 1px solid #ddd; border-radius: 10px;">
    <h2 style="color: #2196f3; text-align: center;">Withdrawal Confirmation</h2>
    <p>Dear User,</p>
    <p>Your withdrawal request has been processed successfully.</p>
    
    <div style="background-color: #f9f9f9; padding: 15px; border-radius: 8px; margin: 20px 0;">
        <p><strong>Transaction Details:</strong></p>
        <table style="width: 100%; border-collapse: collapse;">
           <tr>
    <td style="padding: 8px 0;">Network:</td>
    <td style="text-align: right;">' . ucfirst(htmlspecialchars($transaction_data['network'])) . '</td>
</tr>

            <tr>
                <td style="padding: 8px 0;">USD Amount:</td>
                <td style="text-align: right;">$' . number_format((float)$transaction_data['total_amount'], 2) . '</td>
            </tr>
           
            <tr>
                <td style="padding: 8px 0;">Network Fee:</td>
                <td style="text-align: right;">$' . number_format((float)$transaction_data['fee'], 2) . '</td>
            </tr>
            <tr style="border-top: 1px solid #ddd;">
                <td style="padding: 8px 0;"><strong>Total:</strong></td>
                <td style="text-align: right;"><strong>$' . number_format((float)$transaction_data['total_with_fee'], 2) . '</strong></td>
            </tr>
        </table>
    </div>
    
    <p>Destination Address: ' . htmlspecialchars($transaction_data['wallet']) . '</p>
    <p>Transaction Hash: ' . htmlspecialchars($transhash) . '</p>
    <p>Date/Time: ' . date('Y-m-d H:i:s') . '</p>
    
    <p style="margin-top: 30px;">Thank you for using our platform!</p>
    <p>If you did not authorize this withdrawal, please contact our support team immediately.</p>
    
    <div style="text-align: center; margin-top: 30px; padding-top: 20px; border-top: 1px solid #ddd; color: #777; font-size: 12px;">
        This is an automated message. Please do not reply to this email.
    </div>
</div>';

                
                $mail->Body = $email_body;
                $mail->send();
                
                error_log("Withdrawal confirmation email sent to: " . $transaction_data['email'] . " with BCC to support@bitvros.com");
            } catch (Exception $e) {
                error_log("Email could not be sent. Mailer Error: {$mail->ErrorInfo}");
            }
        }

       // Redirect on success with a success message for SweetAlert
$_SESSION['success_message'] = "Your " . htmlspecialchars(ucfirst($transaction_data['network'])) . " withdrawal of $" . number_format((float)$original_amount, 2) . " has been processed successfully.";
header("Location: crypto.php");
exit();


    } catch (Exception $e) {
        throw $e; // Re-throw to be caught by the outer try-catch
    }

} catch (Exception $e) {
    // Rollback transaction if there was an error
    if (isset($conn) && $conn->connect_errno === 0) {
        $conn->rollback();
    }
    
    error_log("Withdrawal failed: " . $e->getMessage());
    $_SESSION['error_message'] = "Transaction failed: " . $e->getMessage();
    header("Location: crypto.php");
    exit();
}
?>