<?php
// Enable error reporting for debugging (keep commented out in production)
// Disable all error reporting
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(0);


/**
 * Existing function remains unchanged.
 */
function getCountryCode($countryName) {
    // Your existing logic here...
    return ''; // placeholder
}

// Full list of countries for the country map
$allCountries = [
  ["name" => "Afghanistan", "code" => "af", "dial_code" => "+93"],
    ["name" => "Albania", "code" => "al", "dial_code" => "+355"],
    ["name" => "Algeria", "code" => "dz", "dial_code" => "+213"],
    ["name" => "Andorra", "code" => "ad", "dial_code" => "+376"],
    ["name" => "Angola", "code" => "ao", "dial_code" => "+244"],
    ["name" => "Antigua and Barbuda", "code" => "ag", "dial_code" => "+1-268"],
    ["name" => "Argentina", "code" => "ar", "dial_code" => "+54"],
    ["name" => "Armenia", "code" => "am", "dial_code" => "+374"],
    ["name" => "Australia", "code" => "au", "dial_code" => "+61"],
    ["name" => "Austria", "code" => "at", "dial_code" => "+43"],
    ["name" => "Azerbaijan", "code" => "az", "dial_code" => "+994"],
    ["name" => "Bahamas", "code" => "bs", "dial_code" => "+1-242"],
    ["name" => "Bahrain", "code" => "bh", "dial_code" => "+973"],
    ["name" => "Bangladesh", "code" => "bd", "dial_code" => "+880"],
    ["name" => "Barbados", "code" => "bb", "dial_code" => "+1-246"],
    ["name" => "Belarus", "code" => "by", "dial_code" => "+375"],
    ["name" => "Belgium", "code" => "be", "dial_code" => "+32"],
    ["name" => "Belize", "code" => "bz", "dial_code" => "+501"],
    ["name" => "Benin", "code" => "bj", "dial_code" => "+229"],
    ["name" => "Bhutan", "code" => "bt", "dial_code" => "+975"],
    ["name" => "Bolivia", "code" => "bo", "dial_code" => "+591"],
    ["name" => "Bosnia and Herzegovina", "code" => "ba", "dial_code" => "+387"],
    ["name" => "Botswana", "code" => "bw", "dial_code" => "+267"],
    ["name" => "Brazil", "code" => "br", "dial_code" => "+55"],
    ["name" => "Brunei", "code" => "bn", "dial_code" => "+673"],
    ["name" => "Bulgaria", "code" => "bg", "dial_code" => "+359"],
    ["name" => "Burkina Faso", "code" => "bf", "dial_code" => "+226"],
    ["name" => "Burundi", "code" => "bi", "dial_code" => "+257"],
    ["name" => "Cabo Verde", "code" => "cv", "dial_code" => "+238"],
    ["name" => "Cambodia", "code" => "kh", "dial_code" => "+855"],
    ["name" => "Cameroon", "code" => "cm", "dial_code" => "+237"],
    ["name" => "Canada", "code" => "ca", "dial_code" => "+1"],
    ["name" => "Central African Republic", "code" => "cf", "dial_code" => "+236"],
    ["name" => "Chad", "code" => "td", "dial_code" => "+235"],
    ["name" => "Chile", "code" => "cl", "dial_code" => "+56"],
    ["name" => "China", "code" => "cn", "dial_code" => "+86"],
    ["name" => "Colombia", "code" => "co", "dial_code" => "+57"],
    ["name" => "Comoros", "code" => "km", "dial_code" => "+269"],
    ["name" => "Congo (Congo-Brazzaville)", "code" => "cg", "dial_code" => "+242"],
    ["name" => "Costa Rica", "code" => "cr", "dial_code" => "+506"],
    ["name" => "Croatia", "code" => "hr", "dial_code" => "+385"],
    ["name" => "Cuba", "code" => "cu", "dial_code" => "+53"],
    ["name" => "Cyprus", "code" => "cy", "dial_code" => "+357"],
    ["name" => "Czechia (Czech Republic)", "code" => "cz", "dial_code" => "+420"],
    ["name" => "Democratic Republic of the Congo", "code" => "cd", "dial_code" => "+243"],
    ["name" => "Denmark", "code" => "dk", "dial_code" => "+45"],
    ["name" => "Djibouti", "code" => "dj", "dial_code" => "+253"],
    ["name" => "Dominica", "code" => "dm", "dial_code" => "+1-767"],
    ["name" => "Dominican Republic", "code" => "do", "dial_code" => "+1-809"],
    ["name" => "Ecuador", "code" => "ec", "dial_code" => "+593"],
    ["name" => "Egypt", "code" => "eg", "dial_code" => "+20"],
    ["name" => "El Salvador", "code" => "sv", "dial_code" => "+503"],
    ["name" => "Equatorial Guinea", "code" => "gq", "dial_code" => "+240"],
    ["name" => "Eritrea", "code" => "er", "dial_code" => "+291"],
    ["name" => "Estonia", "code" => "ee", "dial_code" => "+372"],
    ["name" => "Eswatini", "code" => "sz", "dial_code" => "+268"],
    ["name" => "Ethiopia", "code" => "et", "dial_code" => "+251"],
    ["name" => "Fiji", "code" => "fj", "dial_code" => "+679"],
    ["name" => "Finland", "code" => "fi", "dial_code" => "+358"],
    ["name" => "France", "code" => "fr", "dial_code" => "+33"],
    ["name" => "Gabon", "code" => "ga", "dial_code" => "+241"],
    ["name" => "Gambia", "code" => "gm", "dial_code" => "+220"],
    ["name" => "Georgia", "code" => "ge", "dial_code" => "+995"],
    ["name" => "Germany", "code" => "de", "dial_code" => "+49"],
    ["name" => "Ghana", "code" => "gh", "dial_code" => "+233"],
    ["name" => "Greece", "code" => "gr", "dial_code" => "+30"],
    ["name" => "Grenada", "code" => "gd", "dial_code" => "+1-473"],
    ["name" => "Guatemala", "code" => "gt", "dial_code" => "+502"],
    ["name" => "Guinea", "code" => "gn", "dial_code" => "+224"],
    ["name" => "Guinea-Bissau", "code" => "gw", "dial_code" => "+245"],
    ["name" => "Guyana", "code" => "gy", "dial_code" => "+592"],
    ["name" => "Haiti", "code" => "ht", "dial_code" => "+509"],
    ["name" => "Holy See", "code" => "va", "dial_code" => "+379"],
    ["name" => "Honduras", "code" => "hn", "dial_code" => "+504"],
    ["name" => "Hungary", "code" => "hu", "dial_code" => "+36"],
    ["name" => "Iceland", "code" => "is", "dial_code" => "+354"],
    ["name" => "India", "code" => "in", "dial_code" => "+91"],
    ["name" => "Indonesia", "code" => "id", "dial_code" => "+62"],
    ["name" => "Iran", "code" => "ir", "dial_code" => "+98"],
    ["name" => "Iraq", "code" => "iq", "dial_code" => "+964"],
    ["name" => "Ireland", "code" => "ie", "dial_code" => "+353"],
    ["name" => "Israel", "code" => "il", "dial_code" => "+972"],
    ["name" => "Italy", "code" => "it", "dial_code" => "+39"],
    ["name" => "Jamaica", "code" => "jm", "dial_code" => "+1-876"],
    ["name" => "Japan", "code" => "jp", "dial_code" => "+81"],
    ["name" => "Jordan", "code" => "jo", "dial_code" => "+962"],
    ["name" => "Kazakhstan", "code" => "kz", "dial_code" => "+7"],
    ["name" => "Kenya", "code" => "ke", "dial_code" => "+254"],
    ["name" => "Kiribati", "code" => "ki", "dial_code" => "+686"],
    ["name" => "Kuwait", "code" => "kw", "dial_code" => "+965"],
    ["name" => "Kyrgyzstan", "code" => "kg", "dial_code" => "+996"],
    ["name" => "Laos", "code" => "la", "dial_code" => "+856"],
    ["name" => "Latvia", "code" => "lv", "dial_code" => "+371"],
    ["name" => "Lebanon", "code" => "lb", "dial_code" => "+961"],
    ["name" => "Lesotho", "code" => "ls", "dial_code" => "+266"],
    ["name" => "Liberia", "code" => "lr", "dial_code" => "+231"],
    ["name" => "Libya", "code" => "ly", "dial_code" => "+218"],
    ["name" => "Liechtenstein", "code" => "li", "dial_code" => "+423"],
    ["name" => "Lithuania", "code" => "lt", "dial_code" => "+370"],
    ["name" => "Luxembourg", "code" => "lu", "dial_code" => "+352"],
    ["name" => "Madagascar", "code" => "mg", "dial_code" => "+261"],
    ["name" => "Malawi", "code" => "mw", "dial_code" => "+265"],
    ["name" => "Malaysia", "code" => "my", "dial_code" => "+60"],
    ["name" => "Maldives", "code" => "mv", "dial_code" => "+960"],
    ["name" => "Mali", "code" => "ml", "dial_code" => "+223"],
    ["name" => "Malta", "code" => "mt", "dial_code" => "+356"],
    ["name" => "Marshall Islands", "code" => "mh", "dial_code" => "+692"],
    ["name" => "Mauritania", "code" => "mr", "dial_code" => "+222"],
    ["name" => "Mauritius", "code" => "mu", "dial_code" => "+230"],
    ["name" => "Mexico", "code" => "mx", "dial_code" => "+52"],
    ["name" => "Micronesia", "code" => "fm", "dial_code" => "+691"],
    ["name" => "Moldova", "code" => "md", "dial_code" => "+373"],
    ["name" => "Monaco", "code" => "mc", "dial_code" => "+377"],
    ["name" => "Mongolia", "code" => "mn", "dial_code" => "+976"],
    ["name" => "Montenegro", "code" => "me", "dial_code" => "+382"],
    ["name" => "Morocco", "code" => "ma", "dial_code" => "+212"],
    ["name" => "Mozambique", "code" => "mz", "dial_code" => "+258"],
    ["name" => "Myanmar", "code" => "mm", "dial_code" => "+95"],
    ["name" => "Namibia", "code" => "na", "dial_code" => "+264"],
    ["name" => "Nauru", "code" => "nr", "dial_code" => "+674"],
    ["name" => "Nepal", "code" => "np", "dial_code" => "+977"],
    ["name" => "Netherlands", "code" => "nl", "dial_code" => "+31"],
    ["name" => "New Zealand", "code" => "nz", "dial_code" => "+64"],
    ["name" => "Nicaragua", "code" => "ni", "dial_code" => "+505"],
    ["name" => "Niger", "code" => "ne", "dial_code" => "+227"],
    ["name" => "Nigeria", "code" => "ng", "dial_code" => "+234"],
    ["name" => "North Korea", "code" => "kp", "dial_code" => "+850"],
    ["name" => "North Macedonia", "code" => "mk", "dial_code" => "+389"],
    ["name" => "Norway", "code" => "no", "dial_code" => "+47"],
    ["name" => "Oman", "code" => "om", "dial_code" => "+968"],
    ["name" => "Pakistan", "code" => "pk", "dial_code" => "+92"],
    ["name" => "Palau", "code" => "pw", "dial_code" => "+680"],
    ["name" => "Palestine", "code" => "ps", "dial_code" => "+970"],
    ["name" => "Panama", "code" => "pa", "dial_code" => "+507"],
    ["name" => "Papua New Guinea", "code" => "pg", "dial_code" => "+675"],
    ["name" => "Paraguay", "code" => "py", "dial_code" => "+595"],
    ["name" => "Peru", "code" => "pe", "dial_code" => "+51"],
    ["name" => "Philippines", "code" => "ph", "dial_code" => "+63"],
    ["name" => "Poland", "code" => "pl", "dial_code" => "+48"],
    ["name" => "Portugal", "code" => "pt", "dial_code" => "+351"],
    ["name" => "Qatar", "code" => "qa", "dial_code" => "+974"],
    ["name" => "Romania", "code" => "ro", "dial_code" => "+40"],
    ["name" => "Russia", "code" => "ru", "dial_code" => "+7"],
    ["name" => "Rwanda", "code" => "rw", "dial_code" => "+250"],
    ["name" => "Saint Kitts and Nevis", "code" => "kn", "dial_code" => "+1-869"],
    ["name" => "Saint Lucia", "code" => "lc", "dial_code" => "+1-758"],
    ["name" => "Saint Vincent and the Grenadines", "code" => "vc", "dial_code" => "+1-784"],
    ["name" => "Samoa", "code" => "ws", "dial_code" => "+685"],
    ["name" => "San Marino", "code" => "sm", "dial_code" => "+378"],
    ["name" => "Sao Tome and Principe", "code" => "st", "dial_code" => "+239"],
    ["name" => "Saudi Arabia", "code" => "sa", "dial_code" => "+966"],
    ["name" => "Senegal", "code" => "sn", "dial_code" => "+221"],
    ["name" => "Serbia", "code" => "rs", "dial_code" => "+381"],
    ["name" => "Seychelles", "code" => "sc", "dial_code" => "+248"],
    ["name" => "Sierra Leone", "code" => "sl", "dial_code" => "+232"],
    ["name" => "Singapore", "code" => "sg", "dial_code" => "+65"],
    ["name" => "Slovakia", "code" => "sk", "dial_code" => "+421"],
    ["name" => "Slovenia", "code" => "si", "dial_code" => "+386"],
    ["name" => "Solomon Islands", "code" => "sb", "dial_code" => "+677"],
    ["name" => "Somalia", "code" => "so", "dial_code" => "+252"],
    ["name" => "South Africa", "code" => "za", "dial_code" => "+27"],
    ["name" => "South Korea", "code" => "kr", "dial_code" => "+82"],
    ["name" => "South Sudan", "code" => "ss", "dial_code" => "+211"],
    ["name" => "Spain", "code" => "es", "dial_code" => "+34"],
    ["name" => "Sri Lanka", "code" => "lk", "dial_code" => "+94"],
    ["name" => "Sudan", "code" => "sd", "dial_code" => "+249"],
    ["name" => "Suriname", "code" => "sr", "dial_code" => "+597"],
    ["name" => "Sweden", "code" => "se", "dial_code" => "+46"],
    ["name" => "Switzerland", "code" => "ch", "dial_code" => "+41"],
    ["name" => "Syria", "code" => "sy", "dial_code" => "+963"],
    ["name" => "Taiwan", "code" => "tw", "dial_code" => "+886"],
    ["name" => "Tajikistan", "code" => "tj", "dial_code" => "+992"],
    ["name" => "Tanzania", "code" => "tz", "dial_code" => "+255"],
    ["name" => "Thailand", "code" => "th", "dial_code" => "+66"],
    ["name" => "Timor-Leste", "code" => "tl", "dial_code" => "+670"],
    ["name" => "Togo", "code" => "tg", "dial_code" => "+228"],
    ["name" => "Tonga", "code" => "to", "dial_code" => "+676"],
    ["name" => "Trinidad and Tobago", "code" => "tt", "dial_code" => "+1-868"],
    ["name" => "Tunisia", "code" => "tn", "dial_code" => "+216"],
    ["name" => "Turkey", "code" => "tr", "dial_code" => "+90"],
    ["name" => "Turkmenistan", "code" => "tm", "dial_code" => "+993"],
    ["name" => "Tuvalu", "code" => "tv", "dial_code" => "+688"],
    ["name" => "Uganda", "code" => "ug", "dial_code" => "+256"],
    ["name" => "Ukraine", "code" => "ua", "dial_code" => "+380"],
    ["name" => "United Arab Emirates", "code" => "ae", "dial_code" => "+971"],
    ["name" => "United Kingdom", "code" => "gb", "dial_code" => "+44"],
    ["name" => "United States of America", "code" => "us", "dial_code" => "+1"],
    ["name" => "Uruguay", "code" => "uy", "dial_code" => "+598"],
    ["name" => "Uzbekistan", "code" => "uz", "dial_code" => "+998"],
    ["name" => "Vanuatu", "code" => "vu", "dial_code" => "+678"],
    ["name" => "Venezuela", "code" => "ve", "dial_code" => "+58"],
    ["name" => "Vietnam", "code" => "vn", "dial_code" => "+84"],
    ["name" => "Yemen", "code" => "ye", "dial_code" => "+967"],
    ["name" => "Zambia", "code" => "zm", "dial_code" => "+260"],
    ["name" => "Zimbabwe", "code" => "zw", "dial_code" => "+263"]
];

require 'db.php';
include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in, if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('Pending or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$balance        = $userDetails['balance'];
$btc            = $userDetails['btc'];
$eth            = $userDetails['eth'];
$usdt           = $userDetails['usdt'];
$xrp            = $userDetails['xrp'];
$doge           = $userDetails['doge'];
$ada            = $userDetails['ada'];
$pepe           = $userDetails['pepe'];
$sol            = $userDetails['sol'];
$bnb            = $userDetails['bnb'];
$message        = $userDetails['message'];
$extra          = $userDetails['extra'];
$msgstatus      = $userDetails['msgstatus'];
$bonus          = $userDetails['bonus'];
$profit         = $userDetails['profit'];
$update_time    = $userDetails['update_time'];

// Check if country or phone is empty/null
$showProfileAlert = empty($country) || $country === null || empty($phone) || $phone === null;

// Fetch country statistics from the database
try {
    $query = "SELECT country, COUNT(*) AS customers
              FROM users 
              GROUP BY country
              ORDER BY customers DESC";
              
    $result = mysqli_query($conn, $query);
    
    if (!$result) {
        throw new Exception("Query failed: " . mysqli_error($conn));
    }
    
    $dbCountries = [];
    $total_customers = 0;
    
    // Build associative array of country counts using country name as key
    while ($row = mysqli_fetch_assoc($result)) {
        $dbCountries[$row['country']] = $row['customers'];
        $total_customers += $row['customers'];
    }
    
    // Merge full list of countries with DB data
    $countriesMap = [];
    foreach ($allCountries as $item) {
        $custCount = isset($dbCountries[$item['name']]) ? $dbCountries[$item['name']] : 0;
        $percentage = ($total_customers > 0) ? round(($custCount / $total_customers) * 100, 2) : 0;
        $item['customers'] = $custCount;
        $item['percentage'] = $percentage;
        $countriesMap[] = $item;
    }
    
    // Prepare JSON for client-side use if needed
    $jsonCountries = json_encode($countriesMap);
    
} catch (Exception $e) {
    die("Database error: " . $e->getMessage());
}

// Process form submission for profile update inline
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update_profile'])) {
    $newDialCode = $_POST['country'];
    $newPhone = $_POST['full_phone']; // Full phone with dial code
    
    // Validate inputs
    if (empty($newDialCode) || empty($newPhone)) {
        $updateError = "Both country and phone number are required.";
    } else {
        // Map the dial code to the country name using the full countries list
        $newCountry = $newDialCode; // default fallback
        foreach ($allCountries as $c) {
            if ($c['dial_code'] === $newDialCode) {
                $newCountry = $c['name'];
                break;
            }
        }
        
        // Update user profile in the database using mysqli
        $updateQuery = "UPDATE users 
                        SET country = ?, phone = ? 
                        WHERE google_id = ?";
        $stmt = mysqli_prepare($conn, $updateQuery);
        
        if ($stmt) {
            mysqli_stmt_bind_param($stmt, "sss", $newCountry, $newPhone, $google_id);
            
            if (mysqli_stmt_execute($stmt)) {
                // Instead of redirecting, update inline variables and set a success message
                $updateMessage = "Profile updated successfully.";
                $country = $newCountry;
                $phone = $newPhone;
            } else {
                $updateError = "Failed to update profile: " . mysqli_stmt_error($stmt);
            }
            
            mysqli_stmt_close($stmt);
        } else {
            $updateError = "Failed to prepare statement: " . mysqli_error($conn);
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Copy Traders - Bitvros Trading Platform</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        
        * {
            font-family: 'Inter', sans-serif;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .card-glow {
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }
        
        .card-glow:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
        }
        
        .profit-positive {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
        }
        
        .profit-negative {
            background: linear-gradient(135deg, #f87171 0%, #ef4444 100%);
        }
        
        .copy-btn {
            background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
            transition: all 0.3s ease;
        }
        
        .copy-btn:hover {
            background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
            transform: scale(1.05);
        }
        
        .copy-btn.copying {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
            animation: pulse 1s infinite;
        }
        
        .copy-btn.copied {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        }
        
        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .fade-in-up {
            animation: fadeInUp 0.6s ease-out;
        }
        
        .stagger-1 { animation-delay: 0.1s; }
        .stagger-2 { animation-delay: 0.2s; }
        .stagger-3 { animation-delay: 0.3s; }
        .stagger-4 { animation-delay: 0.4s; }
        
        .slider-track {
            scrollbar-width: none;
            -ms-overflow-style: none;
        }
        
        .slider-track::-webkit-scrollbar {
            display: none;
        }
        
        .status-badge {
            position: absolute;
            top: 10px;
            right: 10px;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 10px;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .status-active {
            background: rgba(34, 197, 94, 0.2);
            color: #16a34a;
        }
        
        .status-inactive {
            background: rgba(239, 68, 68, 0.2);
            color: #dc2626;
        }
    </style>
        
 <?php include './includes/nav.php'; ?>

</head>
<body class="bg-gray-50">
    <!-- Header Section -->
    <div class="gradient-bg text-white py-16">
        <div class="container mx-auto px-4">
            <div class="text-center">
                <h1 class="text-4xl md:text-6xl font-bold mb-4 fade-in-up">
                    Bitvros Copy Traders
                </h1>
                <p class="text-xl md:text-2xl opacity-90 mb-8 fade-in-up stagger-1">
                    Follow the best performers and copy their strategies
                </p>
                <div class="flex justify-center items-center space-x-4 fade-in-up stagger-2">
                    <div class="bg-white/20 backdrop-blur-sm rounded-lg px-6 py-3">
                        <span class="text-sm opacity-80">Total Traders:</span>
                        <span class="text-xl font-bold ml-2" id="totalTraders">0</span>
                    </div>
                    <div class="bg-white/20 backdrop-blur-sm rounded-lg px-6 py-3">
                        <span class="text-sm opacity-80">Avg. Profit:</span>
                        <span class="text-xl font-bold ml-2" id="avgProfit">0%</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

<!-- Main Content -->
<div class="container mx-auto px-4 py-12">
    <!-- Filter Section -->
    <div class="mb-8 fade-in-up stagger-3">
        <div class="flex flex-wrap gap-4 justify-center">
            <button class="filter-btn bg-blue-500 text-white px-6 py-2 rounded-full hover:bg-blue-600 transition-all" data-filter="all">
                All Traders
            </button>
            <button class="filter-btn bg-gray-200 text-gray-700 px-6 py-2 rounded-full hover:bg-gray-300 transition-all" data-filter="forex">
                Forex
            </button>
            <button class="filter-btn bg-gray-200 text-gray-700 px-6 py-2 rounded-full hover:bg-gray-300 transition-all" data-filter="crypto">
                Crypto
            </button>
            <button class="filter-btn bg-gray-200 text-gray-700 px-6 py-2 rounded-full hover:bg-gray-300 transition-all" data-filter="stocks">
                Stocks
            </button>
        </div>
    </div>

    <!-- Traders Grid -->
    <div id="tradersGrid" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
        <!-- PHP Generated Cards Will Be Here -->
        <?php
        // Database connection and caching
        try {
            $pdo = new PDO("mysql:host=localhost;dbname=lrbpxbxy_dbv", "lrbpxbxy_userv", "WHEagP2O9sOzG9gk");
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

            // Cache configuration - 30 days cache
            $cacheFile = 'cache/copy_traders_cache.json';
            $copiedTradersCache = 'cache/copied_traders_cache.json';
            $cacheTime = 30 * 24 * 60 * 60; // 30 days in seconds

            // Load copied traders from cache
            $copiedTraders = [];
            if (file_exists($copiedTradersCache)) {
                $copiedData = json_decode(file_get_contents($copiedTradersCache), true);
                // Clean expired entries
                $currentTime = time();
                foreach ($copiedData as $traderId => $timestamp) {
                    if (($currentTime - $timestamp) < $cacheTime) {
                        $copiedTraders[$traderId] = $timestamp;
                    }
                }
                // Update cache with cleaned data
                file_put_contents($copiedTradersCache, json_encode($copiedTraders));
            }

            // Load traders from cache if valid
            if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheTime) {
                $traders = json_decode(file_get_contents($cacheFile), true);
            } else {
                // Fetch from database
                $sql = "SELECT id, name, image_url, percentage, type, created_at FROM copy_traders ORDER BY percentage DESC";
                $stmt = $pdo->query($sql);
                $traders = $stmt->fetchAll(PDO::FETCH_ASSOC);

                // Save to cache
                if (!file_exists('cache')) {
                    mkdir('cache', 0777, true);
                }
                file_put_contents($cacheFile, json_encode($traders));
            }

            if (count($traders) > 0) {
                foreach ($traders as $index => $trader) {
                    $id = htmlspecialchars($trader['id']);
                    $name = htmlspecialchars($trader['name']);
                    $image_url = htmlspecialchars($trader['image_url']);
                    $percentage = floatval($trader['percentage']);
                    $type = htmlspecialchars($trader['type']);
                    $created_at = htmlspecialchars($trader['created_at']);

                    // Check if trader is already copied
                    $isCopied = isset($copiedTraders[$id]);

                    // Determine profit or loss styles
                    $profitClass = $percentage >= 0 ? 'profit-positive' : 'profit-negative';
                    $profitIcon = $percentage >= 0 ? 'fa-arrow-up' : 'fa-arrow-down';
                    $profitSign = $percentage >= 0 ? '+' : '';

                    // Chart values (clamped to [0, 100])
                    $chartValue = min(max(abs($percentage), 0), 100);
                    $chartColor = $percentage >= 0 ? "#059669" : "#dc2626";

                    // Demo status logic
                    $isActive = rand(0, 1);
                    $statusClass = $isActive ? 'status-active' : 'status-inactive';
                    $statusText = $isActive ? 'Active' : 'Offline';

                    echo "
                    <div class='trader-card bg-white rounded-xl card-glow overflow-hidden fade-in-up stagger-" . ($index % 4 + 1) . "' data-type='" . strtolower($type) . "'>
                        <div class='relative'>
                            <div class='status-badge $statusClass'>$statusText</div>

                            <!-- Profile‐Image Container with Chart‐Background -->
                            <div class='h-48 relative overflow-hidden flex items-center justify-center' style='
                                position: relative;
                                height: 12rem;
                                overflow: hidden;
                                display: flex;
                                align-items: center;
                                justify-content: center;
                            '>
                                <!-- CanvasJS Chart as Background -->
                                <div id='chartContainer-$id' style='position: absolute; inset: 0;'></div>

                                <!-- Trader Image on Top -->
                                <img src='./beast/copy_trader_images/$image_url' alt='$name' 
                                     class='w-20 h-20 rounded-full object-cover border-4 border-white shadow-lg' 
                                     style='
                                         position: relative;
                                         z-index: 10;
                                         width: 5rem;
                                         height: 5rem;
                                         border-radius: 9999px;
                                         object-fit: cover;
                                         border: 4px solid white;
                                         box-shadow: 0 10px 15px rgba(0,0,0,0.1);
                                     '
                                     onerror=\"this.src='https://via.placeholder.com/80x80/4F46E5/FFFFFF?text=" . strtoupper(substr($name, 0, 1)) . "'\">
                            </div>
                        </div>

                        <div class='p-6'>
                            <div class='flex items-center justify-between mb-3'>
                                <h3 class='text-lg font-bold text-gray-800'>$name</h3>
                                <span class='text-xs bg-blue-100 text-blue-800 px-2 py-1 rounded-full font-medium uppercase'>$type</span>
                            </div>

                            <div class='flex items-center justify-between mb-4'>
                                <div class='flex items-center'>
                                    <i class='fas $profitIcon text-white mr-2'></i>
                                    <span class='text-2xl font-bold text-white'>$profitSign" . number_format($percentage, 1) . "%</span>
                                </div>
                                <div class='$profitClass text-white px-3 py-1 rounded-full text-sm font-medium'>
                                    <i class='fas fa-chart-line mr-1'></i>
                                    " . ($percentage >= 0 ? 'Profit' : 'Loss') . "
                                </div>
                            </div>

                            <div class='mb-4'>
                                <div class='flex justify-between text-sm text-gray-600 mb-2'>
                                    <span>Performance</span>
                                    <span>" . abs($percentage) . "%</span>
                                </div>
                                <div class='w-full bg-gray-200 rounded-full h-2'>
                                    <div class='$profitClass h-2 rounded-full' style='width: " . min(abs($percentage), 100) . "%;'></div>
                                </div>
                            </div>

                            <div class='flex items-center justify-between text-sm text-gray-500 mb-4'>
                                <span><i class='fas fa-calendar-alt mr-1'></i> Joined " . date('M Y', strtotime($created_at)) . "</span>
                                <span><i class='fas fa-users mr-1'></i> " . rand(50, 500) . " followers</span>
                            </div>

                            <button class='copy-btn w-full font-bold py-3 px-6 rounded-lg transition-all duration-300 " . ($isCopied ? 'copied bg-green-500 text-white' : 'text-white') . "' 
                                    onclick='handleCopyTrader(this, $id, \"$name\")' 
                                    data-copied='" . ($isCopied ? 'true' : 'false') . "'>
                                <i class='fas " . ($isCopied ? 'fa-check' : 'fa-copy') . " mr-2'></i>
                                <span class='btn-text'>" . ($isCopied ? 'Copied!' : 'Copy Trader') . "</span>
                            </button>
                        </div>
                    </div>

                    <!-- Inline Script to Render CanvasJS Chart for This Card -->
                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            var chart$id = new CanvasJS.Chart('chartContainer-$id', {
                                animationEnabled: true,
                                backgroundColor: 'transparent',
                                data: [{
                                    type: 'doughnut',
                                    startAngle: 0,
                                    innerRadius: '70%',
                                    indexLabelFontColor: 'white',
                                    dataPoints: [
                                        { y: $chartValue, color: '$chartColor' },
                                        { y: " . (100 - $chartValue) . ", color: '#e5e5e5' }
                                    ]
                                }]
                            });
                            chart$id.render();
                        });
                    </script>
                    ";
                }
            } else {
                echo "<div class='col-span-full text-center py-12'>
                        <i class='fas fa-chart-line text-6xl text-gray-300 mb-4'></i>
                        <p class='text-xl text-gray-500'>No copy traders found.</p>
                      </div>";
            }

            $pdo = null;

        } catch (PDOException $e) {
            echo "<div class='text-red-500 text-center py-4'>Database error: " . htmlspecialchars($e->getMessage()) . "</div>";
        }
        ?>
    </div>
</div>

<!-- Success Modal -->
<div id="successModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
    <div class="bg-white rounded-xl p-8 max-w-md mx-4">
        <div class="text-center">
            <i class="fas fa-check-circle text-green-500 text-5xl mb-4"></i>
            <h3 class="text-xl font-bold mb-2">Successfully Copied!</h3>
            <p class="text-gray-600 mb-4">You are now copying <span id="copiedTraderName" class="font-semibold"></span>'s strategy.</p>
            <button onclick="closeModal()" class="bg-blue-500 text-white px-6 py-2 rounded-lg hover:bg-blue-600 transition-all">
                Continue Trading
            </button>
        </div>
    </div>
</div>

<!-- Include SweetAlert2 -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert2/11.10.1/sweetalert2.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert2/11.10.1/sweetalert2.min.css">

<!-- CanvasJS Library for Doughnut Charts -->
<script src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>

<!-- Enhanced Styles -->
<style>
    @keyframes scrollCandles {
        0% { background-position: 0% 50%; }
        100% { background-position: 200% 50%; }
    }

    .fade-in-up {
        opacity: 0;
        transform: translateY(30px);
        transition: all 0.6s ease;
    }

    .fade-in-up.animate {
        opacity: 1;
        transform: translateY(0);
    }

    .stagger-1 { transition-delay: 0.1s; }
    .stagger-2 { transition-delay: 0.2s; }
    .stagger-3 { transition-delay: 0.3s; }
    .stagger-4 { transition-delay: 0.4s; }

    .card-glow {
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
    }

    .card-glow:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
    }

    .status-badge {
        position: absolute;
        top: 12px;
        right: 12px;
        z-index: 20;
        padding: 4px 8px;
        border-radius: 12px;
        font-size: 0.75rem;
        font-weight: 600;
    }

    .status-active {
        background-color: #10b981;
        color: white;
    }

    .status-inactive {
        background-color: #6b7280;
        color: white;
    }

    .profit-positive {
        background: linear-gradient(135deg, #10b981, #059669);
    }

    .profit-negative {
        background: linear-gradient(135deg, #ef4444, #dc2626);
    }

    .copy-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        position: relative;
        overflow: hidden;
    }

    .copy-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(59, 130, 246, 0.3);
    }

    .copy-btn.copying {
        background: linear-gradient(135deg, #f59e0b, #d97706);
    }

    .copy-btn.copied {
        background: linear-gradient(135deg, #10b981, #059669);
    }

    .copy-btn::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.5s;
    }

    .copy-btn:hover::before {
        left: 100%;
    }

    .trader-card[style*="display: none"] {
        display: none !important;
    }

    /* Force one card per row on mobile (≤768px) */
    @media (max-width: 768px) {
        #tradersGrid {
            grid-template-columns: repeat(1, minmax(0,1fr)) !important;
        }
    }

    /* SweetAlert2 custom styles */
    .swal2-popup {
        border-radius: 12px;
    }

    .swal2-confirm {
        background: linear-gradient(135deg, #10b981, #059669) !important;
        border-radius: 8px;
    }

    .swal2-cancel {
        background: linear-gradient(135deg, #ef4444, #dc2626) !important;
        border-radius: 8px;
    }
</style>

<script>
    // Store copied traders in memory
    let copiedTraders = new Set();

    // Initialize page
    document.addEventListener('DOMContentLoaded', function() {
        updateStats();
        initializeFilters();
        animateCards();
        loadCopiedTraders();
    });

    // Load copied traders from server-side cache
    function loadCopiedTraders() {
        document.querySelectorAll('.copy-btn[data-copied="true"]').forEach(btn => {
            const traderId = btn.getAttribute('onclick').match(/\d+/)[0];
            copiedTraders.add(traderId);
        });
    }

    // Handle copy trader with confirmation
    function handleCopyTrader(button, traderId, traderName) {
        const isCopied = button.dataset.copied === 'true';

        if (isCopied) {
            // Show uncopy confirmation
            Swal.fire({
                title: 'Uncopy Trader?',
                text: `Are you sure you want to stop copying ${traderName}?`,
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'Yes, Uncopy',
                cancelButtonText: 'Cancel',
                customClass: {
                    confirmButton: 'swal2-confirm',
                    cancelButton: 'swal2-cancel'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    uncopyTrader(button, traderId, traderName);
                }
            });
        } else {
            // Show copy confirmation
            Swal.fire({
                title: 'Copy Trader?',
                text: `Do you want to start copying ${traderName}'s trading strategy?`,
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'Yes, Copy',
                cancelButtonText: 'Cancel',
                customClass: {
                    confirmButton: 'swal2-confirm',
                    cancelButton: 'swal2-cancel'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    copyTrader(button, traderId, traderName);
                }
            });
        }
    }

    // Copy trader function
    function copyTrader(button, traderId, traderName) {
        const btnText = button.querySelector('.btn-text');
        const btnIcon = button.querySelector('i');

        // Show copying state
        button.classList.add('copying');
        btnText.textContent = 'Copying...';
        button.disabled = true;

        // Simulate API call to save copied trader
        setTimeout(() => {
            fetch('copycache.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    trader_id: traderId,
                    action: 'copy'
                })
            }).then(() => {
                // Update UI
                button.classList.remove('copying');
                button.classList.add('copied');
                button.dataset.copied = 'true';
                btnIcon.className = 'fas fa-check mr-2';
                btnText.textContent = 'Copied!';
                button.disabled = false;

                // Add to local set
                copiedTraders.add(traderId.toString());

                // Show success message
                Swal.fire({
                    title: 'Success!',
                    text: `You are now copying ${traderName}'s strategy.`,
                    icon: 'success',
                    timer: 2000,
                    showConfirmButton: false
                });
            }).catch(() => {
                // Fallback for demo - just update UI
                button.classList.remove('copying');
                button.classList.add('copied');
                button.dataset.copied = 'true';
                btnIcon.className = 'fas fa-check mr-2';
                btnText.textContent = 'Copied!';
                button.disabled = false;

                copiedTraders.add(traderId.toString());

                Swal.fire({
                    title: 'Success!',
                    text: `You are now copying ${traderName}'s strategy.`,
                    icon: 'success',
                    timer: 2000,
                    showConfirmButton: false
                });
            });

        }, 1500);
    }

    // Uncopy trader function
    function uncopyTrader(button, traderId, traderName) {
        const btnText = button.querySelector('.btn-text');
        const btnIcon = button.querySelector('i');

        // Show uncopying state
        btnText.textContent = 'Uncopying...';
        button.disabled = true;

        // Simulate API call to remove copied trader
        setTimeout(() => {
            fetch('copycache.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    trader_id: traderId,
                    action: 'uncopy'
                })
            }).then(() => {
                // Update UI
                button.classList.remove('copied');
                button.dataset.copied = 'false';
                btnIcon.className = 'fas fa-copy mr-2';
                btnText.textContent = 'Copy Trader';
                button.disabled = false;

                // Remove from local set
                copiedTraders.delete(traderId.toString());

                // Show success message
                Swal.fire({
                    title: 'Uncopied!',
                    text: `You have stopped copying ${traderName}.`,
                    icon: 'info',
                    timer: 2000,
                    showConfirmButton: false
                });
            }).catch(() => {
                // Fallback for demo - just update UI
                button.classList.remove('copied');
                button.dataset.copied = 'false';
                btnIcon.className = 'fas fa-copy mr-2';
                btnText.textContent = 'Copy Trader';
                button.disabled = false;

                copiedTraders.delete(traderId.toString());

                Swal.fire({
                    title: 'Uncopied!',
                    text: `You have stopped copying ${traderName}.`,
                    icon: 'info',
                    timer: 2000,
                    showConfirmButton: false
                });
            });

        }, 1000);
    }

    // Close modal
    function closeModal() {
        document.getElementById('successModal').classList.add('hidden');
    }

    // Filter functionality
    function initializeFilters() {
        const filterBtns = document.querySelectorAll('.filter-btn');
        const traderCards = document.querySelectorAll('.trader-card');

        filterBtns.forEach(btn => {
            btn.addEventListener('click', function() {
                const filter = this.dataset.filter;

                // Update active button
                filterBtns.forEach(b => {
                    b.classList.remove('bg-blue-500', 'text-white');
                    b.classList.add('bg-gray-200', 'text-gray-700');
                });
                this.classList.remove('bg-gray-200', 'text-gray-700');
                this.classList.add('bg-blue-500', 'text-white');

                // Filter cards
                traderCards.forEach(card => {
                    if (filter === 'all' || card.dataset.type === filter) {
                        card.style.display = 'block';
                        card.classList.add('fade-in-up');
                    } else {
                        card.style.display = 'none';
                    }
                });

                updateStats();
            });
        });
    }

    // Update statistics
    function updateStats() {
        const visibleCards = document.querySelectorAll('.trader-card[style*="display: block"], .trader-card:not([style*="display: none"])');
        const totalTraders = visibleCards.length;

        let totalPercentage = 0;
        visibleCards.forEach(card => {
            const percentageText = card.querySelector('.text-2xl.font-bold').textContent;
            const percentage = parseFloat(percentageText.replace(/[+%]/g, ''));
            totalPercentage += percentage;
        });

        const avgProfit = totalTraders > 0 ? (totalPercentage / totalTraders).toFixed(1) : 0;

        // Animate numbers if elements exist
        if (document.getElementById('totalTraders')) {
            animateNumber('totalTraders', totalTraders);
        }
        if (document.getElementById('avgProfit')) {
            animateNumber('avgProfit', avgProfit + '%');
        }
    }

    // Animate numbers
    function animateNumber(elementId, targetValue) {
        const element = document.getElementById(elementId);
        if (!element) return;

        const isPercentage = targetValue.toString().includes('%');
        const numericValue = parseFloat(targetValue.toString().replace('%', ''));
        const startValue = 0;
        const duration = 1000;
        const startTime = performance.now();

        function update(currentTime) {
            const elapsed = currentTime - startTime;
            const progress = Math.min(elapsed / duration, 1);
            const current = startValue + (numericValue - startValue) * progress;

            element.textContent = Math.round(current) + (isPercentage ? '%' : '');

            if (progress < 1) {
                requestAnimationFrame(update);
            }
        }

        requestAnimationFrame(update);
    }

    // Animate cards on scroll
    function animateCards() {
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('animate');
                }
            });
        }, { threshold: 0.1 });

        document.querySelectorAll('.fade-in-up').forEach(card => {
            observer.observe(card);
        });
    }

    // Close modal when clicking outside
    document.getElementById('successModal').addEventListener('click', function(e) {
        if (e.target === this) {
            closeModal();
        }
    });
</script>

<!-- CanvasJS Library for Doughnut Charts -->
<script src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>

</body>
</html>
