<?php
// Enable error reporting (for development only)
// Remove or disable in production
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in; if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$usd_balance    = isset($userDetails['balance']) ? (float)$userDetails['balance'] : 0.00;
$btc            = isset($userDetails['btc']) ? (float)$userDetails['btc'] : 0.000000;
$eth            = isset($userDetails['eth']) ? (float)$userDetails['eth'] : 0.000000;
$usdt           = isset($userDetails['usdt']) ? (float)$userDetails['usdt'] : 0.000000;
$xrp            = isset($userDetails['xrp']) ? (float)$userDetails['xrp'] : 0.000000;
$doge           = isset($userDetails['doge']) ? (float)$userDetails['doge'] : 0.000000;
// FIX: The 'bnb' column contains USD value, not BNB amount
$bnb_usd_value  = isset($userDetails['bnb']) ? (float)$userDetails['bnb'] : 0.000000;
$extra          = $userDetails['extra'];
$update_time    = $userDetails['update_time'];

// Define cache file and cache duration (2 hours)
$cache_file = "bnb_price_cache.json";
$cache_duration = 7200; // 2 hours

// Function to fetch BNB price from CoinGecko API using cURL
function fetch_bnb_price() {
    $api_url = "https://api.coingecko.com/api/v3/simple/price?ids=binancecoin&vs_currencies=usd";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Ignore SSL verification issues
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Timeout after 10 seconds
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Ensure response is valid and HTTP status code is 200 (OK)
    if ($http_code == 200 && $response) {
        return json_decode($response, true);
    }
    return false;
}

// Use cache if valid
if (file_exists($cache_file) && (time() - filemtime($cache_file)) < $cache_duration) {
    $data = json_decode(file_get_contents($cache_file), true);
} else {
    // Fetch fresh BNB price
    $data = fetch_bnb_price();

    // Store new price in cache if valid
    if ($data && isset($data['binancecoin']['usd'])) {
        file_put_contents($cache_file, json_encode($data));
    }
}

// Ensure BNB price is available
$bnb_price = $data['binancecoin']['usd'] ?? 650.00; // Default fallback price

// FIX: Calculate actual BNB amount from USD value
$bnb_amount = $bnb_price > 0 ? ($bnb_usd_value / $bnb_price) : 0;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BNB (Binance Coin) | bitvros.com</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet">
    <link rel="icon" href="https://bitvros.com/session/favicon.png" type="image/x-icon">
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <style>
        .bnb-bg { background-color: #F3BA2F; }
        .bnb-text { color: #F3BA2F; }
        .btn-bnb {
            background: linear-gradient(135deg, #F3BA2F 0%, #FFD700 100%);
            color: white;
            transition: all 0.3s;
            border: none;
        }
        .btn-bnb:hover {
            background: linear-gradient(135deg, #E6AB1F 0%, #F3BA2F 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(243, 186, 47, 0.3);
        }
        .tradingview-widget-container {
            width: 100%;
            min-height: 450px;
        }
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        .progress-bar {
            height: 4px;
            background-color: #e2e8f0;
            border-radius: 2px;
            overflow: hidden;
        }
        .progress-value {
            height: 100%;
            background: linear-gradient(90deg, #F3BA2F 0%, #FFD700 100%);
            transition: width 0.5s ease;
        }
        .description-collapse {
            max-height: 100px;
            overflow: hidden;
            position: relative;
        }
        .description-collapse::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 40px;
            background: linear-gradient(to top, rgba(255,255,255,1), rgba(255,255,255,0));
        }
        .description-expanded {
            max-height: none;
        }
        .exchange-indicator {
            background: linear-gradient(135deg, #F3BA2F 0%, #FFD700 100%);
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            display: inline-block;
            margin-top: 4px;
        }
        .bnb-card {
            background: linear-gradient(135deg, #FFFBF0 0%, #FFF9E6 100%);
            border: 2px solid #FFD700;
        }
        .price-bounce {
            animation: bounce 2s infinite;
        }
        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
            40% { transform: translateY(-10px); }
            60% { transform: translateY(-5px); }
        }
        .ecosystem-tag {
            background: linear-gradient(135deg, #F3BA2F 0%, #FFD700 100%);
            color: white;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 10px;
            font-weight: 600;
            display: inline-block;
            margin: 2px;
        }
        .burn-indicator {
            background: linear-gradient(135deg, #FF6B6B 0%, #FF5252 100%);
            color: white;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 10px;
            font-weight: 600;
            display: inline-block;
            margin: 2px;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen p-4">
    <div class="max-w-4xl mx-auto bg-white p-4 md:p-6 rounded-2xl shadow-sm">
        <!-- Header -->
        <header class="flex items-center justify-between mb-8">
            <button onclick="history.back()" class="bnb-text p-2 rounded-full hover:bg-gray-100 transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                </svg>
            </button>
            <h1 class="text-xl font-semibold text-gray-800 flex items-center">
                <img src="https://bitvros.com/cryptos/bnb.png" class="w-8 h-8 mr-2" alt="BNB">
                BNB (Binance Coin)
            </h1>
            <div class="p-2 rounded-full hover:bg-gray-100 transition-colors">
                <div id="connection-status" class="w-3 h-3 rounded-full bg-green-500"></div>
            </div>
        </header>

        <!-- Price Section -->
        <section class="text-center mb-8 fade-in">
            <div class="price-text text-4xl font-bold mb-2 flex items-center justify-center">
                <span id="bnb-price" class="text-gray-800">$0.00</span>
                <span id="bnb-arrow" class="ml-2"></span>
            </div>
            <div id="bnb-change" class="text-lg font-medium text-gray-600">0.00% (24h)</div>
            <div class="exchange-indicator">
                ⚡ World's Leading Crypto Exchange Token
            </div>
            <div class="text-sm font-medium text-blue-500 mt-2">
                1 USD ≈ <span id="bnb-equivalent" class="text-gray-700">0.00 BNB</span>
            </div>
            <div class="flex justify-center mt-2 space-x-1">
                <span class="ecosystem-tag">BSC</span>
                <span class="ecosystem-tag">DEX</span>
                <span class="burn-indicator">🔥 Deflationary</span>
            </div>
        </section>

       
      <!-- TradingView Widget Section -->
<section class="mb-6" style="width: 100%;">
    <div class="tradingview-widget-container" style="width: 100%; height: 420px;">
        <div class="tradingview-widget-container__widget" style="width: 100%; height: 100%;"></div>
        <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-mini-symbol-overview.js" async>
        {
            "symbol": "BINANCE:BNBUSDT",
            "width": "100%",
            "height": "250",
            "locale": "en",
            "dateRange": "12M",
            "colorTheme": "light",
            "isTransparent": true,
            "autosize": false,
            "largeChartUrl": ""
        }
        </script>
    </div>
</section>


        <!-- Wallet Card -->
        <section class="wallet-card bnb-card rounded-xl p-6 mb-8 fade-in">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm">Your BNB Balance</p>
                    <h2 class="text-2xl font-bold text-gray-800 mt-1">
                        <?php echo number_format($bnb_amount, 6); ?> BNB
                    </h2>
                    <p class="text-gray-600 mt-1">
                        ≈ $<span id="bnb-balance-usd"><?php echo number_format($bnb_usd_value, 2); ?></span> USD
                    </p>
                    <p class="text-xs text-gray-500 mt-1">Power your transactions on BSC</p>
                </div>
                <img src="https://bitvros.com/cryptos/bnb.png" class="w-12 h-12" alt="BNB">
            </div>
            <div class="mt-4 flex space-x-2">
                <a href="bnbs.php" class="btn-bnb py-3 px-6 rounded-xl text-center font-medium flex-1">
                    <i class="fas fa-arrow-up mr-2"></i>Send
                </a>
                <a href="bnbr.php" class="btn-bnb py-3 px-6 rounded-xl text-center font-medium flex-1">
                    <i class="fas fa-arrow-down mr-2"></i>Receive
                </a>
            </div>
        </section>

        <!-- Market Data -->
        <section class="bg-gray-50 rounded-xl p-6 mb-8 fade-in">
            <h3 class="font-semibold text-gray-800 mb-4">Market Overview</h3>
            <div class="space-y-4 text-sm">
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Market Cap Rank</span>
                        <span id="market-cap-rank">#4</span>
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Market Cap</span>
                        <span id="market-cap">$0</span>
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>24h Volume</span>
                        <span id="volume">$0</span>
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Circulating Supply</span>
                        <span id="supply">0 BNB</span>
                    </div>
                    <div class="progress-bar mt-1">
                        <div id="supply-progress" class="progress-value" style="width: 0%"></div>
                    </div>
                    <div class="text-xs text-gray-500 mt-1">
                        <span id="circulating-supply">0</span> / <span id="total-supply">0</span> BNB
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Token Burns</span>
                        <span id="burn-status" class="text-red-600 font-medium">🔥 Quarterly</span>
                    </div>
                    <div class="text-xs text-gray-500 mt-1">
                        Regular token burns reduce supply
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>BSC Block Time</span>
                        <span id="block-time" class="text-green-600 font-medium">~3 seconds</span>
                    </div>
                    <div class="text-xs text-gray-500 mt-1">
                        Average block time on Binance Smart Chain
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Exchange Volume</span>
                        <span id="exchange-volume" class="text-blue-600 font-medium">$0</span>
                    </div>
                    <div class="text-xs text-gray-500 mt-1">
                        Trading volume on Binance exchange
                    </div>
                </div>
            </div>
        </section>

        <!-- Utility Info -->
        <section class="bg-yellow-50 border border-yellow-200 rounded-xl p-6 mb-8 fade-in">
            <div class="flex items-start space-x-3">
                <div class="w-8 h-8 bg-yellow-100 rounded-full flex items-center justify-center flex-shrink-0">
                    <span class="text-yellow-600 text-lg">⚡</span>
                </div>
                <div>
                    <h4 class="font-semibold text-yellow-800 mb-1">Multi-Utility Exchange Token</h4>
                    <p class="text-sm text-yellow-700">
                        BNB powers the Binance ecosystem - from trading fee discounts to BSC gas fees, launchpad participation, and DeFi applications. A deflationary token with quarterly burns.
                    </p>
                    <div class="mt-2 space-y-1">
                        <div class="text-xs text-yellow-600">✓ Trading fee discounts up to 25%</div>
                        <div class="text-xs text-yellow-600">✓ BSC network gas fees</div>
                        <div class="text-xs text-yellow-600">✓ Launchpad token sales</div>
                        <div class="text-xs text-yellow-600">✓ DeFi yield farming</div>
                    </div>
                </div>
            </div>
        </section>

        <!-- About Section -->
        <section class="mb-8 fade-in">
            <div class="flex justify-between items-center mb-4">
                <h3 class="font-semibold text-gray-800">About BNB</h3>
                <button id="toggle-description" class="text-blue-500 text-sm font-medium">Show More</button>
            </div>
            <div id="description-content" class="description-collapse text-gray-600 text-sm leading-relaxed">
                Loading BNB description...
            </div>
        </section>

        <!-- Official Links -->
        <section class="fade-in">
            <h3 class="font-semibold text-gray-800 mb-4">Resources</h3>
            <div class="grid grid-cols-2 gap-3">
                <a href="https://www.binance.com/en/bnb" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-blue-500 font-medium">Official Page</div>
                </a>
                <a href="https://github.com/binance-chain" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-blue-500 font-medium">Source Code</div>
                </a>
                <a href="blockchain_details.php" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-blue-500 font-medium">BSC Explorer</div>
                </a>
                <a href="https://docs.binance.org" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-blue-500 font-medium">Documentation</div>
                </a>
            </div>
        </section>
    </div>

    <script>
        // DOM Elements
        const bnbPriceEl = document.getElementById('bnb-price');
        const bnbArrowEl = document.getElementById('bnb-arrow');
        const bnbChangeEl = document.getElementById('bnb-change');
        const bnbEquivalentEl = document.getElementById('bnb-equivalent');
        const bnbBalanceUsdEl = document.getElementById('bnb-balance-usd');
        const marketCapEl = document.getElementById('market-cap');
        const volumeEl = document.getElementById('volume');
        const supplyEl = document.getElementById('supply');
        const marketCapRankEl = document.getElementById('market-cap-rank');
        const burnStatusEl = document.getElementById('burn-status');
        const blockTimeEl = document.getElementById('block-time');
        const exchangeVolumeEl = document.getElementById('exchange-volume');
        const descriptionContentEl = document.getElementById('description-content');
        const toggleDescriptionBtn = document.getElementById('toggle-description');
        const connectionStatusEl = document.getElementById('connection-status');
        const supplyProgressEl = document.getElementById('supply-progress');
        const circulatingSupplyEl = document.getElementById('circulating-supply');
        const totalSupplyEl = document.getElementById('total-supply');

        // FIX: User data from PHP - correctly identify what each value represents
        const userBNBUSDValue = <?php echo json_encode($bnb_usd_value); ?>; // This is the USD value
        const userBNBAmount = <?php echo json_encode($bnb_amount); ?>; // This is the calculated BNB amount
        let previousPrice = 0;
        let coinData = {};
        let descriptionExpanded = false;

        // Toggle description
        toggleDescriptionBtn.addEventListener('click', () => {
            descriptionExpanded = !descriptionExpanded;
            descriptionContentEl.classList.toggle('description-collapse', !descriptionExpanded);
            descriptionContentEl.classList.toggle('description-expanded', descriptionExpanded);
            toggleDescriptionBtn.textContent = descriptionExpanded ? 'Show Less' : 'Show More';
        });

        // Format numbers with commas
        function formatNumber(num, decimals = 0) {
            return new Intl.NumberFormat('en-US', {
                minimumFractionDigits: decimals,
                maximumFractionDigits: decimals
            }).format(num);
        }

        // Format currency
        function formatCurrency(amount) {
            return new Intl.NumberFormat('en-US', {
                style: 'currency',
                currency: 'USD',
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            }).format(amount);
        }

        // Update UI with price data
        function updatePriceUI(price, change) {
            // Update price
            bnbPriceEl.textContent = formatCurrency(price);
            
            // Update 24h change
            const changeFixed = change.toFixed(2);
            bnbChangeEl.textContent = `${changeFixed}% (24h)`;
            bnbChangeEl.style.color = change >= 0 ? '#10B981' : '#EF4444';
            
            // Update arrow
            bnbArrowEl.textContent = change >= 0 ? '↑' : '↓';
            bnbArrowEl.style.color = change >= 0 ? '#10B981' : '#EF4444';
            
            // Update equivalent
            const bnbEquivalent = 1 / price;
            bnbEquivalentEl.textContent = bnbEquivalent.toFixed(4) + ' BNB';
            
            // FIX: Keep the USD value static since it's already in USD
            // The user's USD value doesn't change with price fluctuations
            bnbBalanceUsdEl.textContent = formatNumber(userBNBUSDValue, 2);
            
            // Price change animation with bounce effect
            if (previousPrice && previousPrice !== price) {
                bnbPriceEl.classList.remove('text-green-500', 'text-red-500', 'price-bounce');
                void bnbPriceEl.offsetWidth; // Trigger reflow
                bnbPriceEl.classList.add(price > previousPrice ? 'text-green-500' : 'text-red-500');
                bnbPriceEl.classList.add('price-bounce');
                
                setTimeout(() => {
                    bnbPriceEl.classList.remove('text-green-500', 'text-red-500', 'price-bounce');
                    bnbPriceEl.classList.add('text-gray-800');
                }, 3000);
            }
            
            previousPrice = price;
        }

        // Update market data
        function updateMarketData(data) {
            marketCapEl.textContent = formatCurrency(data.market_data.market_cap.usd);
            volumeEl.textContent = formatCurrency(data.market_data.total_volume.usd);
            supplyEl.textContent = formatNumber(data.market_data.circulating_supply) + ' BNB';
            marketCapRankEl.textContent = '#' + data.market_cap_rank;
            
            // Update supply progress
            const circulating = data.market_data.circulating_supply;
            const total = data.market_data.total_supply;
            const supplyPercentage = (circulating / total) * 100;
            supplyProgressEl.style.width = supplyPercentage + '%';
            circulatingSupplyEl.textContent = formatNumber(circulating);
            totalSupplyEl.textContent = formatNumber(total);
            
            // Update exchange volume (use total volume as proxy)
            exchangeVolumeEl.textContent = formatCurrency(data.market_data.total_volume.usd);
            
            // Update burn status based on recent performance
            const priceChange = data.market_data.price_change_percentage_24h;
            if (priceChange > 5) {
                burnStatusEl.innerHTML = '🔥 Very Deflationary';
                burnStatusEl.className = 'text-red-600 font-medium';
            } else if (priceChange > 0) {
                burnStatusEl.innerHTML = '🔥 Deflationary';
                burnStatusEl.className = 'text-orange-600 font-medium';
            } else {
                burnStatusEl.innerHTML = '🔥 Quarterly Burns';
                burnStatusEl.className = 'text-yellow-600 font-medium';
            }
        }

        // Fetch BNB data from CoinGecko
        async function fetchBNBData() {
            try {
                const response = await axios.get('https://api.coingecko.com/api/v3/coins/binancecoin', {
                    params: {
                        localization: false,
                        tickers: false,
                        community_data: false,
                        developer_data: false,
                        sparkline: false
                    },
                    timeout: 10000
                });
                
                coinData = response.data;
                const price = coinData.market_data.current_price.usd;
                const change = coinData.market_data.price_change_percentage_24h;
                
                updatePriceUI(price, change);
                updateMarketData(coinData);
                
                // Update description
                descriptionContentEl.innerHTML = coinData.description.en.replace(/\. /g, '.<br><br>');
                
                connectionStatusEl.style.backgroundColor = '#10B981';
                return true;
            } catch (error) {
                console.error('Error fetching BNB data:', error);
                connectionStatusEl.style.backgroundColor = '#EF4444';
                return false;
            }
        }

        // Initialize the page
        document.addEventListener('DOMContentLoaded', () => {
            // Initial data fetch
            fetchBNBData();
            
            // Refresh data every 60 seconds
            setInterval(fetchBNBData, 60000);
            
            // Animate elements on load
            document.querySelectorAll('.fade-in').forEach((el, i) => {
                el.style.animationDelay = `${i * 0.1}s`;
            });
        });
    </script>
</body>
</html>