<?php
// Enable error reporting (for development only)
// Remove or disable in production
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in; if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$usd_balance    = isset($userDetails['balance']) ? (float)$userDetails['balance'] : 0.00;
$btc            = isset($userDetails['btc']) ? (float)$userDetails['btc'] : 0.000000;
$pepe           = isset($userDetails['pepe']) ? (float)$userDetails['pepe'] : 0.000000;
$usdt           = isset($userDetails['usdt']) ? (float)$userDetails['usdt'] : 0.000000;
$xrp            = isset($userDetails['xrp']) ? (float)$userDetails['xrp'] : 0.000000;
$extra          = $userDetails['extra'];
$update_time    = $userDetails['update_time'];

// We will fetch the PEPE price using JavaScript, so we remove the PHP cURL code
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PEPE Token | bitvros.com</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet">
    <link rel="icon" href="https://bitvros.com/session/favicon.png" type="image/x-icon">
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <style>
        .pepe-bg { background: linear-gradient(135deg, #00FF00 0%, #32CD32 100%); }
        .pepe-text { color: #228B22; }
        .pepe-secondary { color: #00FF00; }
        .btn-pepe {
            background: linear-gradient(135deg, #00FF00 0%, #32CD32 100%);
            color: white;
            transition: all 0.3s;
            border: none;
        }
        .btn-pepe:hover {
            background: linear-gradient(135deg, #32CD32 0%, #00FF00 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0, 255, 0, 0.4);
        }
        .tradingview-widget-container {
            width: 100%;
            min-height: 450px;
        }
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        .progress-bar {
            height: 4px;
            background-color: #e2e8f0;
            border-radius: 2px;
            overflow: hidden;
        }
        .progress-value {
            height: 100%;
            background: linear-gradient(90deg, #00FF00 0%, #32CD32 100%);
            transition: width 0.5s ease;
        }
        .description-collapse {
            max-height: 100px;
            overflow: hidden;
            position: relative;
        }
        .description-collapse::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 40px;
            background: linear-gradient(to top, rgba(255,255,255,1), rgba(255,255,255,0));
        }
        .description-expanded {
            max-height: none;
        }
        .meme-indicator {
            background: linear-gradient(135deg, #00FF00 0%, #32CD32 100%);
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            display: inline-block;
            margin-top: 4px;
        }
        .pepe-card {
            background: linear-gradient(135deg, #F0FFF0 0%, #E6FFE6 100%);
            border: 2px solid #00FF00;
        }
        .price-bounce {
            animation: bounce 2s infinite;
        }
        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
            40% { transform: translateY(-10px); }
            60% { transform: translateY(-5px); }
        }
        .feature-tag {
            background: linear-gradient(135deg, #00FF00 0%, #32CD32 100%);
            color: white;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 10px;
            font-weight: 600;
            display: inline-block;
            margin: 2px;
        }
        .meme-tag {
            background: linear-gradient(135deg, #FF6B6B 0%, #FF8E53 100%);
            color: white;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 10px;
            font-weight: 600;
            display: inline-block;
            margin: 2px;
        }
        .viral-tag {
            background: linear-gradient(135deg, #FF6B9D 0%, #C44569 100%);
            color: white;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 10px;
            font-weight: 600;
            display: inline-block;
            margin: 2px;
        }
        .performance-text {
            font-family: 'Courier New', monospace;
            color: #228B22;
            font-weight: bold;
        }
        .glow-effect {
            box-shadow: 0 0 20px rgba(0, 255, 0, 0.3);
        }
        .holder-counter {
            font-family: 'Courier New', monospace;
            font-size: 18px;
            color: #00FF00;
            font-weight: bold;
            text-shadow: 0 0 10px rgba(0, 255, 0, 0.5);
        }
        .pepe-emoji {
            font-size: 24px;
            animation: wiggle 2s infinite;
        }
        @keyframes wiggle {
            0%, 100% { transform: rotate(0deg); }
            25% { transform: rotate(5deg); }
            75% { transform: rotate(-5deg); }
        }
        .trending-badge {
            background: linear-gradient(135deg, #FF4500 0%, #FF6347 100%);
            color: white;
            padding: 2px 8px;
            border-radius: 10px;
            font-size: 10px;
            font-weight: 600;
            display: inline-block;
            margin-left: 8px;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen p-4">
    <div class="max-w-4xl mx-auto bg-white p-4 md:p-6 rounded-2xl shadow-sm">
        <!-- Header -->
        <header class="flex items-center justify-between mb-8">
            <button onclick="history.back()" class="pepe-text p-2 rounded-full hover:bg-gray-100 transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                </svg>
            </button>
            <h1 class="text-xl font-semibold text-gray-800 flex items-center">
                <span class="pepe-emoji mr-2">🐸</span>
                PEPE
                <span class="trending-badge">🔥 TRENDING</span>
            </h1>
            <div class="p-2 rounded-full hover:bg-gray-100 transition-colors">
                <div id="connection-status" class="w-3 h-3 rounded-full bg-green-500"></div>
            </div>
        </header>

        <!-- Price Section -->
        <section class="text-center mb-8 fade-in">
            <div class="price-text text-4xl font-bold mb-2 flex items-center justify-center">
                <span id="pepe-price" class="text-gray-800">$0.00000000</span>
                <span id="pepe-arrow" class="ml-2"></span>
            </div>
            <div id="pepe-change" class="text-lg font-medium text-gray-600">0.00% (24h)</div>
            <div class="meme-indicator">
                🚀 The People's Meme
            </div>
            <div class="text-sm font-medium text-green-500 mt-2">
                1 USD ≈ <span id="pepe-equivalent" class="text-gray-700">0 PEPE</span>
            </div>
            <div class="flex justify-center mt-2 space-x-1">
                <span class="meme-tag">🐸 MEME</span>
                <span class="viral-tag">📈 VIRAL</span>
                <span class="feature-tag">ERC-20</span>
                <span class="feature-tag">COMMUNITY</span>
            </div>
        </section>

        <!-- TradingView Widget Section -->
        <section class="mb-6" style="width: 100%;">
            <div class="tradingview-widget-container" style="width: 100%; height: 420px;">
                <div class="tradingview-widget-container__widget" style="width: 100%; height: 100%;"></div>
                <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-mini-symbol-overview.js" async>
                {
                    "symbol": "BINANCE:PEPEUSDT",
                    "width": "100%",
                    "height": "250",
                    "locale": "en",
                    "dateRange": "12M",
                    "colorTheme": "light",
                    "isTransparent": true,
                    "autosize": false,
                    "largeChartUrl": ""
                }
                </script>
            </div>
        </section>

        <!-- Wallet Card -->
        <section class="wallet-card pepe-card rounded-xl p-6 mb-8 fade-in glow-effect">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm">Your PEPE Balance</p>
                    <h2 class="text-2xl font-bold text-gray-800 mt-1">
                        <span id="user-pepe-balance">0</span> PEPE
                    </h2>
                    <p class="text-gray-600 mt-1">
                        ≈ $<span id="pepe-balance-usd">0.00</span> USD
                    </p>
                    <p class="performance-text text-xs mt-1">Feel good meme 🐸</p>
                </div>
                <span class="pepe-emoji">🐸</span>
            </div>
            <div class="mt-4 flex space-x-2">
               <a href="pepes.php"> <button class="btn-pepe py-3 px-6 rounded-xl text-center font-medium flex-1">
                    <span class="mr-2">📤</span>Send
                </button></a>
                <a href="peper.php"> <button class="btn-pepe py-3 px-6 rounded-xl text-center font-medium flex-1">
                    <span class="mr-2">📥</span>Receive
                </button></a>
            </div>
        </section>

        <!-- Community Stats -->
        <section class="bg-gradient-to-r from-green-50 to-lime-50 rounded-xl p-6 mb-8 fade-in">
            <h3 class="font-semibold text-gray-800 mb-4">Community Power</h3>
            <div class="grid grid-cols-2 gap-4">
                <div class="text-center">
                    <div class="holder-counter" id="holder-count">~200K</div>
                    <div class="text-xs text-gray-500">Holders</div>
                </div>
                <div class="text-center">
                    <div class="holder-counter">~100K</div>
                    <div class="text-xs text-gray-500">Daily Tweets</div>
                </div>
                <div class="text-center">
                    <div class="holder-counter">Top 10</div>
                    <div class="text-xs text-gray-500">Meme Rank</div>
                </div>
                <div class="text-center">
                    <div class="holder-counter" id="burn-rate">🔥 Deflationary</div>
                    <div class="text-xs text-gray-500">Burn Status</div>
                </div>
            </div>
        </section>

        <!-- Market Data -->
        <section class="bg-gray-50 rounded-xl p-6 mb-8 fade-in">
            <h3 class="font-semibold text-gray-800 mb-4">Market Overview</h3>
            <div class="space-y-4 text-sm">
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Market Cap Rank</span>
                        <span id="market-cap-rank">#42</span>
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Market Cap</span>
                        <span id="market-cap">$0</span>
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>24h Volume</span>
                        <span id="volume">$0</span>
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Circulating Supply</span>
                        <span id="supply">0 PEPE</span>
                    </div>
                    <div class="progress-bar mt-1">
                        <div id="supply-progress" class="progress-value" style="width: 100%"></div>
                    </div>
                    <div class="text-xs text-gray-500 mt-1">
                        <span id="circulating-supply">420.69T</span> / <span id="total-supply">420.69T</span> PEPE
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>All-Time High</span>
                        <span id="ath" class="text-green-600 font-medium">$0.00000431</span>
                    </div>
                    <div class="text-xs text-gray-500 mt-1">
                        May 2023
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Community Score</span>
                        <span id="community-score" class="text-green-600 font-medium">95/100</span>
                    </div>
                    <div class="text-xs text-gray-500 mt-1">
                        Based on social metrics
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Meme Status</span>
                        <span id="meme-status" class="text-purple-600 font-medium">🚀 LEGENDARY</span>
                    </div>
                    <div class="text-xs text-gray-500 mt-1">
                        Internet culture impact
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Exchanges</span>
                        <span id="exchanges" class="text-blue-600 font-medium">50+</span>
                    </div>
                    <div class="text-xs text-gray-500 mt-1">
                        Listed on major exchanges
                    </div>
                </div>
            </div>
        </section>

        <!-- Meme Power Info -->
        <section class="bg-gradient-to-r from-green-50 to-lime-50 border-2 border-green-200 rounded-xl p-6 mb-8 fade-in">
            <div class="flex items-start space-x-3">
                <div class="w-8 h-8 bg-green-100 rounded-full flex items-center justify-center flex-shrink-0">
                    <span class="text-green-600 text-lg">🐸</span>
                </div>
                <div>
                    <h4 class="font-semibold text-green-800 mb-1">The People's Meme</h4>
                    <p class="text-sm text-green-700">
                        PEPE is the most memeable memecoin in existence. The dogs have had their day, it's time for PEPE to take reign. PEPE is here to make memecoins great again.
                    </p>
                    <div class="mt-2 space-y-1">
                        <div class="text-xs text-green-600">✓ Zero taxes, pure meme energy</div>
                        <div class="text-xs text-green-600">✓ LP tokens burnt & contract renounced</div>
                        <div class="text-xs text-green-600">✓ Built by the people, for the people</div>
                        <div class="text-xs text-green-600">✓ Legendary meme status achieved</div>
                        <div class="text-xs text-green-600">✓ Viral community movement</div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Community Info -->
        <section class="bg-orange-50 border border-orange-200 rounded-xl p-6 mb-8 fade-in">
            <div class="flex items-start space-x-3">
                <div class="w-8 h-8 bg-orange-100 rounded-full flex items-center justify-center flex-shrink-0">
                    <span class="text-orange-600 text-lg">🔥</span>
                </div>
                <div>
                    <h4 class="font-semibold text-orange-800 mb-1">Viral Community</h4>
                    <p class="text-sm text-orange-700">
                        PEPE has built one of the strongest communities in crypto. From Twitter to Reddit, from Discord to Telegram, the PEPE army is everywhere spreading the good vibes.
                    </p>
                    <div class="mt-2 space-y-1">
                        <div class="text-xs text-orange-600">✓ 200K+ holders worldwide</div>
                        <div class="text-xs text-orange-600">✓ Trending on all major platforms</div>
                        <div class="text-xs text-orange-600">✓ Celebrity endorsements</div>
                        <div class="text-xs text-orange-600">✓ Meme culture phenomenon</div>
                        <div class="text-xs text-orange-600">✓ Global recognition</div>
                    </div>
                </div>
            </div>
        </section>

        <!-- About Section -->
        <section class="mb-8 fade-in">
            <div class="flex justify-between items-center mb-4">
                <h3 class="font-semibold text-gray-800">About PEPE</h3>
                <button id="toggle-description" class="text-green-500 text-sm font-medium">Show More</button>
            </div>
            <div id="description-content" class="description-collapse text-gray-600 text-sm leading-relaxed">
                PEPE is a deflationary memecoin launched on Ethereum. The currency was created as a tribute to the Pepe the Frog internet meme, created by Matt Furie, which became popular in the early 2000s. The project aims to capitalize on the popularity of meme coins, like Shiba Inu and Dogecoin, and strives to establish itself as one of the top meme-based cryptocurrencies.
            </div>
        </section>

        <!-- Official Links -->
        <section class="fade-in">
            <h3 class="font-semibold text-gray-800 mb-4">Resources</h3>
            <div class="grid grid-cols-2 gap-3">
                <a href="https://www.pepe.vip" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-green-500 font-medium">Official Website</div>
                </a>
                <a href="https://twitter.com/pepecoineth" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-green-500 font-medium">Twitter</div>
                </a>
                <a href="https://etherscan.io/token/0x6982508145454ce325ddbe47a25d4ec3d2311933" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-green-500 font-medium">Etherscan</div>
                </a>
                <a href="https://t.me/pepecoineth" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-green-500 font-medium">Telegram</div>
                </a>
                <a href="https://www.dextools.io/app/en/ether/pair-explorer/0xa43fe16908251ee70ef74718545e4fe6c5ccec9f" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-green-500 font-medium">DexTools</div>
                </a>
                <a href="https://www.coingecko.com/en/coins/pepe" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-green-500 font-medium">CoinGecko</div>
                </a>
            </div>
        </section>
    </div>

<script>
        // DOM Elements
        const pepePriceEl = document.getElementById('pepe-price');
        const pepeArrowEl = document.getElementById('pepe-arrow');
        const pepeChangeEl = document.getElementById('pepe-change');
        const pepeEquivalentEl = document.getElementById('pepe-equivalent');
        const pepeBalanceUsdEl = document.getElementById('pepe-balance-usd');
        const userPepeBalanceEl = document.getElementById('user-pepe-balance');
        const marketCapEl = document.getElementById('market-cap');
        const volumeEl = document.getElementById('volume');
        const supplyEl = document.getElementById('supply');
        const marketCapRankEl = document.getElementById('market-cap-rank');
        const athEl = document.getElementById('ath');
        const communityScoreEl = document.getElementById('community-score');
        const memeStatusEl = document.getElementById('meme-status');
        const exchangesEl = document.getElementById('exchanges');
        const descriptionContentEl = document.getElementById('description-content');
        const toggleDescriptionBtn = document.getElementById('toggle-description');
        const connectionStatusEl = document.getElementById('connection-status');
        const supplyProgressEl = document.getElementById('supply-progress');
        const circulatingSupplyEl = document.getElementById('circulating-supply');
        const totalSupplyEl = document.getElementById('total-supply');
        const holderCountEl = document.getElementById('holder-count');

        // User data from PHP (IMPORTANT: pepe column stores USD value, not PEPE tokens)
        const userPepeUSD = <?php echo $pepe; ?>; // This is the USD value from the pepe column
        let previousPrice = 0;
        let coinData = {};
        let descriptionExpanded = false;
        let currentPepePrice = 0; // Will store the current PEPE price

        // Toggle description
        toggleDescriptionBtn.addEventListener('click', () => {
            descriptionExpanded = !descriptionExpanded;
            descriptionContentEl.classList.toggle('description-collapse', !descriptionExpanded);
            descriptionContentEl.classList.toggle('description-expanded', descriptionExpanded);
            toggleDescriptionBtn.textContent = descriptionExpanded ? 'Show Less' : 'Show More';
        });

        // Format numbers with commas
        function formatNumber(num, decimals = 0) {
            return new Intl.NumberFormat('en-US', {
                minimumFractionDigits: decimals,
                maximumFractionDigits: decimals
            }).format(num);
        }

        // Format currency
        function formatCurrency(amount, decimals = 8) {
            return new Intl.NumberFormat('en-US', {
                style: 'currency',
                currency: 'USD',
                minimumFractionDigits: decimals,
                maximumFractionDigits: decimals
            }).format(amount);
        }

        // Format large numbers
        function formatLargeNumber(num) {
            if (num >= 1e12) {
                return (num / 1e12).toFixed(1) + 'T';
            } else if (num >= 1e9) {
                return (num / 1e9).toFixed(1) + 'B';
            } else if (num >= 1e6) {
                return (num / 1e6).toFixed(1) + 'M';
            } else if (num >= 1e3) {
                return (num / 1e3).toFixed(1) + 'K';
            }
            return num.toString();
        }

        // Update UI with price data
        function updatePriceUI(price, change) {
            currentPepePrice = price; // Store current price
            
            // Update price
            pepePriceEl.textContent = formatCurrency(price, 8);
            
            // Update 24h change
            const changeFixed = change.toFixed(2);
            pepeChangeEl.textContent = `${changeFixed}% (24h)`;
            pepeChangeEl.style.color = change >= 0 ? '#10B981' : '#EF4444';
            
            // Update arrow
            pepeArrowEl.textContent = change >= 0 ? '↑' : '↓';
            pepeArrowEl.style.color = change >= 0 ? '#10B981' : '#EF4444';
            
            // Update equivalent
            const pepeEquivalent = 1 / price;
            pepeEquivalentEl.textContent = formatLargeNumber(pepeEquivalent) + ' PEPE';
            
            // CORRECTED: Calculate PEPE tokens from USD value
            const userPepeTokens = userPepeUSD / price; // Convert USD to PEPE tokens
            userPepeBalanceEl.textContent = formatLargeNumber(userPepeTokens);
            
            // Display the USD value (this is the actual value from database)
            pepeBalanceUsdEl.textContent = formatNumber(userPepeUSD, 2);
            
            // Price change animation with bounce effect
            if (previousPrice && previousPrice !== price) {
                pepePriceEl.classList.remove('text-green-500', 'text-red-500', 'price-bounce');
                void pepePriceEl.offsetWidth; // Trigger reflow
                pepePriceEl.classList.add(price > previousPrice ? 'text-green-500' : 'text-red-500');
                pepePriceEl.classList.add('price-bounce');
                
                setTimeout(() => {
                    pepePriceEl.classList.remove('text-green-500', 'text-red-500', 'price-bounce');
                    pepePriceEl.classList.add('text-gray-800');
                }, 3000);
            }
            
            previousPrice = price;
        }

        // Update market data
        function updateMarketData(data) {
            marketCapEl.textContent = formatCurrency(data.market_data.market_cap.usd, 0);
            volumeEl.textContent = formatCurrency(data.market_data.total_volume.usd, 0);
            supplyEl.textContent = formatLargeNumber(data.market_data.circulating_supply) + ' PEPE';
            marketCapRankEl.textContent = '#' + data.market_cap_rank;
            
            // Update supply progress
            const circulating = data.market_data.circulating_supply;
            const totalSupply = data.market_data.total_supply || circulating;
            const supplyPercentage = (circulating / totalSupply) * 100;
            supplyProgressEl.style.width = supplyPercentage + '%';
            circulatingSupplyEl.textContent = formatLargeNumber(circulating);
            totalSupplyEl.textContent = formatLargeNumber(totalSupply);
            
            // Update ATH
            if (data.market_data.ath && data.market_data.ath.usd) {
                athEl.textContent = formatCurrency(data.market_data.ath.usd, 8);
            }
            
            // Store coin data for later use
            coinData = data;
        }

        // Update description
        function updateDescription(description) {
            descriptionContentEl.textContent = description || 'PEPE is a deflationary memecoin launched on Ethereum. The currency was created as a tribute to the Pepe the Frog internet meme, created by Matt Furie, which became popular in the early 2000s.';
        }

        // Simulate holder count animation
        function animateHolderCount() {
            const holderCounts = ['~180K', '~195K', '~210K', '~225K', '~240K', '~230K', '~200K', '~215K'];
            let currentIndex = 0;
            
            setInterval(() => {
                holderCountEl.textContent = holderCounts[currentIndex];
                currentIndex = (currentIndex + 1) % holderCounts.length;
            }, 5000);
        }

        // Fetch PEPE data from CoinGecko API
        async function fetchPEPEData() {
            try {
                connectionStatusEl.className = 'w-3 h-3 rounded-full bg-yellow-500';
                
                const response = await axios.get('https://api.coingecko.com/api/v3/coins/pepe');
                const data = response.data;
                
                // Update price and change
                const price = data.market_data.current_price.usd;
                const change = data.market_data.price_change_percentage_24h;
                
                updatePriceUI(price, change);
                updateMarketData(data);
                updateDescription(data.description.en);
                
                connectionStatusEl.className = 'w-3 h-3 rounded-full bg-green-500';
                
            } catch (error) {
                console.error('Error fetching PEPE data:', error);
                connectionStatusEl.className = 'w-3 h-3 rounded-full bg-red-500';
                
                // Fallback to mock data
                updatePriceUI(0.00000120, 5.67);
            }
        }

        // Initialize page
        function init() {
            // Start holder count animation
            animateHolderCount();
            
            // Fetch initial data
            fetchPEPEData();
            
            // Set up periodic updates every 30 seconds
            setInterval(fetchPEPEData, 30000);
            
            // Add some initial fade-in effects
            document.querySelectorAll('.fade-in').forEach((el, index) => {
                el.style.opacity = '0';
                setTimeout(() => {
                    el.style.opacity = '1';
                }, index * 100);
            });
        }

        // Start the application
        init();
    </script>
</body>
</html>