<?php
// Enable full error reporting (for development only, disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in; if not, redirect to the login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$balance        = $userDetails['balance'];
// NOTE: This value is in USD, not in DOGE (stored similarly to ADA)
$doge           = $userDetails['ada'];
$eth            = $userDetails['eth'];
$usdt           = $userDetails['usdt'];
$xrp            = $userDetails['xrp'];
$extra          = $userDetails['extra'];
$update_time    = $userDetails['update_time'];

// The available balance (in USD) is stored in the $doge variable.
// For server-side conversion, we calculate the DOGE equivalent using the current price.
$usd_amount = (float)$doge;  // Cast to float

// Define the CoinGecko API URL to get the Dogecoin price in USD
$api_url = "https://api.coingecko.com/api/v3/simple/price?ids=dogecoin&vs_currencies=usd";

// Initialize cURL and fetch Dogecoin price
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
$response = curl_exec($ch);
if (curl_errno($ch)) {
    error_log('cURL error: ' . curl_error($ch));
}
curl_close($ch);
$data = json_decode($response, true);

// Check if the 'dogecoin' key exists and its 'usd' value is valid
if (isset($data['dogecoin']['usd']) && $data['dogecoin']['usd'] != 0) {
    $doge_price_usd = (float)$data['dogecoin']['usd'];
} else {
    $doge_price_usd = 1;
}

// Convert the USD amount to DOGE (server-side conversion)
// This value is used as a fallback initial value for the available balance in DOGE.
$doge_amount = $usd_amount / $doge_price_usd;
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Send Dogecoin</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  
  <!-- Favicon (Dogecoin Logo) -->
  <link rel="icon" href="https://bitvros.com/session/favicon.png" type="image/x-icon">
  
  <!-- Tailwind CSS CDN -->
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- Include Font Awesome CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" 
        integrity="sha512-Fo3rlrZj/k7ujTTXRNtA3G6Rr9XICMjz10c9EaLj3Ew6/pz7A6lBEO6+KCkI0kB3Y0x5Cj2H5YxE5JPTxZ9pBw==" 
        crossorigin="anonymous" referrerpolicy="no-referrer" />
  
  <style>
    /* Custom styles */
    .error-message {
        color: red;
        font-weight: bold;
    }
  </style>
</head>
<body class="bg-gray-50">
  <!-- Overall Page Preloader -->
  <div id="preloader" class="fixed inset-0 bg-white flex items-center justify-center z-50">
    <div class="animate-spin rounded-full h-16 w-16 border-t-4 border-blue-600"></div>
  </div>

  <!-- Main Container -->
  <div class="w-full min-h-screen mx-auto px-4 sm:px-6 lg:px-8 max-w-2xl">
    <!-- App Content -->
    <div class="bg-white rounded-lg shadow-xl p-6 my-4">
      <!-- Header Section -->
      <div class="flex justify-between items-center mb-6">
        <button onclick="goBack()" class="text-blue-500 hover:text-blue-700">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
          </svg>
        </button>
        <div class="flex items-center justify-center">
          <!-- Dogecoin Logo -->
          <img src="https://bitvros.com/cryptos/doge.png" alt="Dogecoin Logo" class="w-8 h-8 mr-2">
          <!-- Heading -->
          <h1 class="text-2xl font-bold text-center flex-grow">Send Dogecoin</h1>
        </div>
        <button onclick="openNotifications()" class="text-blue-500 hover:text-blue-700">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C8.67 6.165 8 7.388 8 8.75v5.408c0 .621-.226 1.213-.63 1.656L6 17h5m4 0v1a3 3 0 11-6 0v-1m6 0H9" />
          </svg>
        </button>
      </div>
      
      <?php
      if (isset($_SESSION['error'])) {
          echo "<p class='error-message'>" . htmlspecialchars($_SESSION['error']) . "</p>";
          unset($_SESSION['error']);
      }
      ?>
      
      <script>
        // Utility: Get URL parameter
        function getURLParameter(name) {
            const urlParams = new URLSearchParams(window.location.search);
            return urlParams.get(name);
        }
        // Show alert if URL contains alert parameters
        function showAlert() {
            const alertType = getURLParameter('alert');
            const message = getURLParameter('message');
            if (alertType && message) {
                const alertBox = document.getElementById('alert-box');
                const alertMessage = document.getElementById('alert-message');
                alertMessage.textContent = decodeURIComponent(message);
                alertBox.classList.remove('hidden');
                if (alertType === 'danger') {
                    alertBox.classList.remove('bg-green-500');
                    alertBox.classList.add('bg-red-500');
                } else if (alertType === 'success') {
                    alertBox.classList.remove('bg-red-500');
                    alertBox.classList.add('bg-green-500');
                }
            }
        }
        // Dismiss alert
        function dismissAlert() {
            const alertBox = document.getElementById('alert-box');
            alertBox.classList.add('hidden');
        }
        window.onload = showAlert;
      </script>
      
      <!-- Available Balance with Spinner -->
      <div class="bg-gray-100 p-4 rounded-xl mb-6">
        <div class="flex justify-between items-center">
          <span class="text-gray-600">Available Balance:</span>
          <!-- Initially shows spinner icon until updateDisplay() runs -->
          <span class="font-bold" id="DOGEAvailableDisplay">
            <i class="fa fa-spinner fa-spin"></i>
          </span>
        </div>
      </div>
      
      <!-- Amount Display (for entered DOGE and conversion) -->
      <div class="mb-6">
        <div class="text-center mb-3" id="priceContainer">
          <span class="text-3xl font-bold" id="DOGEAmount">0.00000000 DOGE</span>
        </div>
        <div class="border-2 border-gray-200 rounded-xl p-4">
          <span class="text-2xl font-bold block text-center" id="inputDisplay">0.00000000</span>
        </div>
        <div class="text-center text-gray-500 mt-2" id="usdAmount">
          ≈ $0.00
        </div>
        <div id="errorMessage" class="text-center text-red-600 mt-2" style="display: none;"></div>
      </div>
      
      <!-- Percentage Buttons -->
      <div class="grid grid-cols-4 gap-2 mb-6">
        <button onclick="applyPercentage(10)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">10%</button>
        <button onclick="applyPercentage(25)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">25%</button>
        <button onclick="applyPercentage(50)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">50%</button>
        <button onclick="applyPercentage(100)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">100%</button>
      </div>
      
      <!-- Recipient Address -->
      <div class="mb-6">
        <label class="block text-gray-600 mb-2">Recipient Dogecoin Address</label>
        <div class="relative">
          <!-- The input field now includes an onclick attribute that triggers pasteFromClipboard(). Note: Clipboard API requires HTTPS to work. -->
          <input type="text" id="recipientAddress" placeholder="Tap to Paste Dogecoin Wallet Address..."
                 class="w-full p-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-500" 
                 autocomplete="off" onclick="pasteFromClipboard()">
          <button onclick="scanQRCode()" class="absolute right-12 top-3 text-blue-500">
            <i class="fas fa-qrcode text-2xl"></i>
          </button>
          <button onclick="clearAddress()" class="absolute right-3 top-3 text-red-500">
            <i class="fas fa-times text-2xl"></i>
          </button>
        </div>
        <script>
          // Paste from clipboard function (requires HTTPS)
          function pasteFromClipboard() {
            navigator.clipboard.readText().then(text => {
              document.getElementById('recipientAddress').value = text;
            }).catch(err => {
              console.error('Failed to read clipboard contents:', err);
            });
          }
          function scanQRCode() {
            alert('Please scan the QR code using your device camera.');
          }
          function clearAddress() {
            document.getElementById('recipientAddress').value = '';
          }
        </script>
      </div>
    </div> <!-- End of main content block -->
    
    <!-- Keypad -->
    <div class="grid grid-cols-3 gap-2 mb-6">
      <button onclick="appendDigit('1')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">1</button>
      <button onclick="appendDigit('2')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">2</button>
      <button onclick="appendDigit('3')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">3</button>
      <button onclick="appendDigit('4')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">4</button>
      <button onclick="appendDigit('5')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">5</button>
      <button onclick="appendDigit('6')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">6</button>
      <button onclick="appendDigit('7')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">7</button>
      <button onclick="appendDigit('8')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">8</button>
      <button onclick="appendDigit('9')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">9</button>
      <button onclick="appendDigit('.')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">.</button>
      <button onclick="appendDigit('0')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">0</button>
      <button onclick="backspace()" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">⌫</button>
    </div>
    
    <!-- Fee Options -->
    <div class="mb-6">
      <span class="text-gray-600">Select Fee Option:</span>
      <div class="flex space-x-4 mt-2">
        <button onclick="setFeeOption('slow')" class="py-2 px-4 rounded-lg bg-gray-100 hover:bg-gray-200">Slow (≈ $0.16)</button>
        <button onclick="setFeeOption('medium')" class="py-2 px-4 rounded-lg bg-gray-100 hover:bg-gray-200">Medium (≈ $0.17)</button>
        <button onclick="setFeeOption('high')" class="py-2 px-4 rounded-lg bg-gray-100 hover:bg-gray-200">High (≈ $0.18)</button>
      </div>
    </div>
    
    <!-- Transaction Summary -->
    <div class="bg-gray-50 p-4 rounded-xl mb-6">
      <div class="flex justify-between mb-2">
        <span class="text-gray-600">Network Fee</span>
        <span class="font-medium" id="networkFee">0.00000000 DOGE</span>
      </div>
      <div class="flex justify-between">
        <span class="text-lg font-bold">Total</span>
        <span class="text-lg font-bold" id="totalAmount">0.00000000 DOGE</span>
      </div>
    </div>
    
    <!-- Transaction Form (Submit Button at the Very Bottom) -->
    <form id="transactionForm" action="processdoge.php" method="POST">
      <input type="hidden" name="network" value="dogecoin" id="formNetwork" required>
      <input type="hidden" name="email" value="<?php echo htmlspecialchars($email); ?>" required>
      <input type="hidden" id="hiddenUsdAmount" name="amount" value="" required>
      <input type="hidden" name="wallet" id="hiddenRecipientAddress" value="" required>
      <input type="hidden" id="fee-option" name="fee" value="0.17">
      <input type="hidden" name="ipaddress" id="formIP" required>
      <input type="hidden" name="name" value="<?php echo htmlspecialchars($name); ?>" required>
      <button type="submit" class="w-full bg-blue-600 text-white py-4 rounded-xl font-bold hover:bg-blue-700">
        Submit Transaction
      </button>
    </form>
  </div> <!-- End of Main Container -->
  
  <!-- Include FontAwesome -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/js/all.min.js"></script>
  
  <!-- Transaction and Conversion Scripts -->
  <script>
    // Cache the available balance in USD (from the doge column) and convert it using the live DOGE price.
    let DOGEAvailableUSD = localStorage.getItem('dogeAvailableUSD') 
        ? parseFloat(localStorage.getItem('dogeAvailableUSD')) 
        : <?php echo $doge; ?>;
    localStorage.setItem('dogeAvailableUSD', DOGEAvailableUSD);
    
    // Fallback conversion rate; will be updated asynchronously.
    let DOGEPriceUSD = <?php echo $doge_price_usd; ?>;
    let enteredDOGE = '';
    let networkFeeDOGE = 0.17; // Default fee for 'medium'
    let selectedFeeOption = 'medium';
    
    // Price Fetcher using async/await for DOGE price
    async function fetchDOGEPrice() {
      try {
        const response = await fetch('https://api.coingecko.com/api/v3/simple/price?ids=dogecoin&vs_currencies=usd');
        const data = await response.json();
        if (data.dogecoin && data.dogecoin.usd) {
          DOGEPriceUSD = data.dogecoin.usd;
          updateDisplay();
        }
      } catch (error) {
        console.error('Price fetch error:', error);
      }
    }
    
    // Network Fee Setter (static values)
    async function fetchNetworkFee() {
      if (selectedFeeOption === 'slow') {
        networkFeeDOGE = 0.16;
      } else if (selectedFeeOption === 'medium') {
        networkFeeDOGE = 0.17;
      } else if (selectedFeeOption === 'high') {
        networkFeeDOGE = 0.18;
      } else {
        networkFeeDOGE = 0.17;
      }
      updateDisplay();
    }
    
    function setFeeOption(option) {
      selectedFeeOption = option;
      fetchNetworkFee();
    }
    window.setFeeOption = setFeeOption;
    
    // Update display with 8 decimal places and update available balance
    function updateDisplay() {
      let availableDOGE = DOGEAvailableUSD / DOGEPriceUSD;
      document.getElementById('DOGEAvailableDisplay').textContent = availableDOGE.toFixed(6) + ' DOGE';
      
      const displayValue = enteredDOGE ? parseFloat(enteredDOGE).toFixed(8) : '0.00000000';
      const DOGEAmount = parseFloat(enteredDOGE) || 0;
      const totalDOGE = DOGEAmount + networkFeeDOGE;
      
      document.getElementById('DOGEAmount').textContent = `${displayValue} DOGE`;
      document.getElementById('inputDisplay').textContent = displayValue;
      
      const usdValue = DOGEAmount * DOGEPriceUSD;
      const feeUSD = networkFeeDOGE * DOGEPriceUSD;
      document.getElementById('usdAmount').textContent = `≈ $${usdValue.toFixed(2)}`;
      document.getElementById('networkFee').innerHTML = `${networkFeeDOGE.toFixed(8)} DOGE<br><span class="text-gray-500">≈ $${feeUSD.toFixed(2)}</span>`;
      document.getElementById('totalAmount').textContent = `${totalDOGE.toFixed(8)} DOGE`;
    
      if (totalDOGE > availableDOGE) {
        document.getElementById('errorMessage').textContent = "Wallet balance exceeded";
        document.getElementById('errorMessage').style.display = 'block';
      } else {
        document.getElementById('errorMessage').style.display = 'none';
      }
    }
    
    // Append digit handler (limit to 8 decimals)
    function appendDigit(digit) {
      if (digit === '.' && enteredDOGE.includes('.')) return;
      if (enteredDOGE.includes('.')) {
        const decimals = enteredDOGE.split('.')[1];
        if (decimals.length >= 8) return;
      }
      enteredDOGE += digit;
      updateDisplay();
    }
    
    // Backspace handler
    function backspace() {
      enteredDOGE = enteredDOGE.slice(0, -1);
      updateDisplay();
    }
    
    // Percentage buttons: update enteredDOGE with 8 decimals
    function applyPercentage(percent) {
      const availableDOGE = DOGEAvailableUSD / DOGEPriceUSD;
      const amount = availableDOGE * (percent / 100);
      enteredDOGE = amount.toFixed(8);
      updateDisplay();
    }
    
    function goBack() { window.history.back(); }
    function openNotifications() { alert('Notifications coming soon'); }
    function scanQRCode() { alert('Please scan the QR code using your device camera.'); }
    
    async function fetchIPAddress() {
      try {
        const response = await fetch('https://api.ipify.org?format=json');
        const data = await response.json();
        document.getElementById('formIP').value = data.ip;
      } catch (error) {
        console.error('IP fetch error:', error);
        document.getElementById('formIP').value = '0.0.0.0';
      }
    }
    fetchIPAddress();
    
    (async function initialLoad() {
        await fetchDOGEPrice();
        await fetchNetworkFee();
        document.getElementById('preloader').style.display = 'none';
    })();
    
    setInterval(fetchDOGEPrice, 60000);
    setInterval(fetchNetworkFee, 60000);
    
    // Sync recipient address input to hidden form field on form submission
    document.getElementById("transactionForm").addEventListener("submit", function(e) {
      document.getElementById("hiddenRecipientAddress").value = document.getElementById("recipientAddress").value;
    });
  </script>
  
  <!-- Sync USD Amount MutationObserver -->
  <script>
    function syncUsdAmount() {
      var usdText = document.getElementById("usdAmount").innerText;
      var extractedValue = usdText.replace(/[^\d.]/g, '');
      document.getElementById("hiddenUsdAmount").value = extractedValue;
    }
    const usdObserver = new MutationObserver(syncUsdAmount);
    usdObserver.observe(document.getElementById("usdAmount"), { childList: true, subtree: true });
  </script>
  
</body>
</html>
