<?php
// Enable error reporting for debugging (keep commented out in production)
// Disable all error reporting
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(0);


/**
 * Existing function remains unchanged.
 */
function getCountryCode($countryName) {
    // Your existing logic here...
    return ''; // placeholder
}

// Full list of countries for the country map
$allCountries = [
  ["name" => "Afghanistan", "code" => "af", "dial_code" => "+93"],
    ["name" => "Albania", "code" => "al", "dial_code" => "+355"],
    ["name" => "Algeria", "code" => "dz", "dial_code" => "+213"],
    ["name" => "Andorra", "code" => "ad", "dial_code" => "+376"],
    ["name" => "Angola", "code" => "ao", "dial_code" => "+244"],
    ["name" => "Antigua and Barbuda", "code" => "ag", "dial_code" => "+1-268"],
    ["name" => "Argentina", "code" => "ar", "dial_code" => "+54"],
    ["name" => "Armenia", "code" => "am", "dial_code" => "+374"],
    ["name" => "Australia", "code" => "au", "dial_code" => "+61"],
    ["name" => "Austria", "code" => "at", "dial_code" => "+43"],
    ["name" => "Azerbaijan", "code" => "az", "dial_code" => "+994"],
    ["name" => "Bahamas", "code" => "bs", "dial_code" => "+1-242"],
    ["name" => "Bahrain", "code" => "bh", "dial_code" => "+973"],
    ["name" => "Bangladesh", "code" => "bd", "dial_code" => "+880"],
    ["name" => "Barbados", "code" => "bb", "dial_code" => "+1-246"],
    ["name" => "Belarus", "code" => "by", "dial_code" => "+375"],
    ["name" => "Belgium", "code" => "be", "dial_code" => "+32"],
    ["name" => "Belize", "code" => "bz", "dial_code" => "+501"],
    ["name" => "Benin", "code" => "bj", "dial_code" => "+229"],
    ["name" => "Bhutan", "code" => "bt", "dial_code" => "+975"],
    ["name" => "Bolivia", "code" => "bo", "dial_code" => "+591"],
    ["name" => "Bosnia and Herzegovina", "code" => "ba", "dial_code" => "+387"],
    ["name" => "Botswana", "code" => "bw", "dial_code" => "+267"],
    ["name" => "Brazil", "code" => "br", "dial_code" => "+55"],
    ["name" => "Brunei", "code" => "bn", "dial_code" => "+673"],
    ["name" => "Bulgaria", "code" => "bg", "dial_code" => "+359"],
    ["name" => "Burkina Faso", "code" => "bf", "dial_code" => "+226"],
    ["name" => "Burundi", "code" => "bi", "dial_code" => "+257"],
    ["name" => "Cabo Verde", "code" => "cv", "dial_code" => "+238"],
    ["name" => "Cambodia", "code" => "kh", "dial_code" => "+855"],
    ["name" => "Cameroon", "code" => "cm", "dial_code" => "+237"],
    ["name" => "Canada", "code" => "ca", "dial_code" => "+1"],
    ["name" => "Central African Republic", "code" => "cf", "dial_code" => "+236"],
    ["name" => "Chad", "code" => "td", "dial_code" => "+235"],
    ["name" => "Chile", "code" => "cl", "dial_code" => "+56"],
    ["name" => "China", "code" => "cn", "dial_code" => "+86"],
    ["name" => "Colombia", "code" => "co", "dial_code" => "+57"],
    ["name" => "Comoros", "code" => "km", "dial_code" => "+269"],
    ["name" => "Congo (Congo-Brazzaville)", "code" => "cg", "dial_code" => "+242"],
    ["name" => "Costa Rica", "code" => "cr", "dial_code" => "+506"],
    ["name" => "Croatia", "code" => "hr", "dial_code" => "+385"],
    ["name" => "Cuba", "code" => "cu", "dial_code" => "+53"],
    ["name" => "Cyprus", "code" => "cy", "dial_code" => "+357"],
    ["name" => "Czechia (Czech Republic)", "code" => "cz", "dial_code" => "+420"],
    ["name" => "Democratic Republic of the Congo", "code" => "cd", "dial_code" => "+243"],
    ["name" => "Denmark", "code" => "dk", "dial_code" => "+45"],
    ["name" => "Djibouti", "code" => "dj", "dial_code" => "+253"],
    ["name" => "Dominica", "code" => "dm", "dial_code" => "+1-767"],
    ["name" => "Dominican Republic", "code" => "do", "dial_code" => "+1-809"],
    ["name" => "Ecuador", "code" => "ec", "dial_code" => "+593"],
    ["name" => "Egypt", "code" => "eg", "dial_code" => "+20"],
    ["name" => "El Salvador", "code" => "sv", "dial_code" => "+503"],
    ["name" => "Equatorial Guinea", "code" => "gq", "dial_code" => "+240"],
    ["name" => "Eritrea", "code" => "er", "dial_code" => "+291"],
    ["name" => "Estonia", "code" => "ee", "dial_code" => "+372"],
    ["name" => "Eswatini", "code" => "sz", "dial_code" => "+268"],
    ["name" => "Ethiopia", "code" => "et", "dial_code" => "+251"],
    ["name" => "Fiji", "code" => "fj", "dial_code" => "+679"],
    ["name" => "Finland", "code" => "fi", "dial_code" => "+358"],
    ["name" => "France", "code" => "fr", "dial_code" => "+33"],
    ["name" => "Gabon", "code" => "ga", "dial_code" => "+241"],
    ["name" => "Gambia", "code" => "gm", "dial_code" => "+220"],
    ["name" => "Georgia", "code" => "ge", "dial_code" => "+995"],
    ["name" => "Germany", "code" => "de", "dial_code" => "+49"],
    ["name" => "Ghana", "code" => "gh", "dial_code" => "+233"],
    ["name" => "Greece", "code" => "gr", "dial_code" => "+30"],
    ["name" => "Grenada", "code" => "gd", "dial_code" => "+1-473"],
    ["name" => "Guatemala", "code" => "gt", "dial_code" => "+502"],
    ["name" => "Guinea", "code" => "gn", "dial_code" => "+224"],
    ["name" => "Guinea-Bissau", "code" => "gw", "dial_code" => "+245"],
    ["name" => "Guyana", "code" => "gy", "dial_code" => "+592"],
    ["name" => "Haiti", "code" => "ht", "dial_code" => "+509"],
    ["name" => "Holy See", "code" => "va", "dial_code" => "+379"],
    ["name" => "Honduras", "code" => "hn", "dial_code" => "+504"],
    ["name" => "Hungary", "code" => "hu", "dial_code" => "+36"],
    ["name" => "Iceland", "code" => "is", "dial_code" => "+354"],
    ["name" => "India", "code" => "in", "dial_code" => "+91"],
    ["name" => "Indonesia", "code" => "id", "dial_code" => "+62"],
    ["name" => "Iran", "code" => "ir", "dial_code" => "+98"],
    ["name" => "Iraq", "code" => "iq", "dial_code" => "+964"],
    ["name" => "Ireland", "code" => "ie", "dial_code" => "+353"],
    ["name" => "Israel", "code" => "il", "dial_code" => "+972"],
    ["name" => "Italy", "code" => "it", "dial_code" => "+39"],
    ["name" => "Jamaica", "code" => "jm", "dial_code" => "+1-876"],
    ["name" => "Japan", "code" => "jp", "dial_code" => "+81"],
    ["name" => "Jordan", "code" => "jo", "dial_code" => "+962"],
    ["name" => "Kazakhstan", "code" => "kz", "dial_code" => "+7"],
    ["name" => "Kenya", "code" => "ke", "dial_code" => "+254"],
    ["name" => "Kiribati", "code" => "ki", "dial_code" => "+686"],
    ["name" => "Kuwait", "code" => "kw", "dial_code" => "+965"],
    ["name" => "Kyrgyzstan", "code" => "kg", "dial_code" => "+996"],
    ["name" => "Laos", "code" => "la", "dial_code" => "+856"],
    ["name" => "Latvia", "code" => "lv", "dial_code" => "+371"],
    ["name" => "Lebanon", "code" => "lb", "dial_code" => "+961"],
    ["name" => "Lesotho", "code" => "ls", "dial_code" => "+266"],
    ["name" => "Liberia", "code" => "lr", "dial_code" => "+231"],
    ["name" => "Libya", "code" => "ly", "dial_code" => "+218"],
    ["name" => "Liechtenstein", "code" => "li", "dial_code" => "+423"],
    ["name" => "Lithuania", "code" => "lt", "dial_code" => "+370"],
    ["name" => "Luxembourg", "code" => "lu", "dial_code" => "+352"],
    ["name" => "Madagascar", "code" => "mg", "dial_code" => "+261"],
    ["name" => "Malawi", "code" => "mw", "dial_code" => "+265"],
    ["name" => "Malaysia", "code" => "my", "dial_code" => "+60"],
    ["name" => "Maldives", "code" => "mv", "dial_code" => "+960"],
    ["name" => "Mali", "code" => "ml", "dial_code" => "+223"],
    ["name" => "Malta", "code" => "mt", "dial_code" => "+356"],
    ["name" => "Marshall Islands", "code" => "mh", "dial_code" => "+692"],
    ["name" => "Mauritania", "code" => "mr", "dial_code" => "+222"],
    ["name" => "Mauritius", "code" => "mu", "dial_code" => "+230"],
    ["name" => "Mexico", "code" => "mx", "dial_code" => "+52"],
    ["name" => "Micronesia", "code" => "fm", "dial_code" => "+691"],
    ["name" => "Moldova", "code" => "md", "dial_code" => "+373"],
    ["name" => "Monaco", "code" => "mc", "dial_code" => "+377"],
    ["name" => "Mongolia", "code" => "mn", "dial_code" => "+976"],
    ["name" => "Montenegro", "code" => "me", "dial_code" => "+382"],
    ["name" => "Morocco", "code" => "ma", "dial_code" => "+212"],
    ["name" => "Mozambique", "code" => "mz", "dial_code" => "+258"],
    ["name" => "Myanmar", "code" => "mm", "dial_code" => "+95"],
    ["name" => "Namibia", "code" => "na", "dial_code" => "+264"],
    ["name" => "Nauru", "code" => "nr", "dial_code" => "+674"],
    ["name" => "Nepal", "code" => "np", "dial_code" => "+977"],
    ["name" => "Netherlands", "code" => "nl", "dial_code" => "+31"],
    ["name" => "New Zealand", "code" => "nz", "dial_code" => "+64"],
    ["name" => "Nicaragua", "code" => "ni", "dial_code" => "+505"],
    ["name" => "Niger", "code" => "ne", "dial_code" => "+227"],
    ["name" => "Nigeria", "code" => "ng", "dial_code" => "+234"],
    ["name" => "North Korea", "code" => "kp", "dial_code" => "+850"],
    ["name" => "North Macedonia", "code" => "mk", "dial_code" => "+389"],
    ["name" => "Norway", "code" => "no", "dial_code" => "+47"],
    ["name" => "Oman", "code" => "om", "dial_code" => "+968"],
    ["name" => "Pakistan", "code" => "pk", "dial_code" => "+92"],
    ["name" => "Palau", "code" => "pw", "dial_code" => "+680"],
    ["name" => "Palestine", "code" => "ps", "dial_code" => "+970"],
    ["name" => "Panama", "code" => "pa", "dial_code" => "+507"],
    ["name" => "Papua New Guinea", "code" => "pg", "dial_code" => "+675"],
    ["name" => "Paraguay", "code" => "py", "dial_code" => "+595"],
    ["name" => "Peru", "code" => "pe", "dial_code" => "+51"],
    ["name" => "Philippines", "code" => "ph", "dial_code" => "+63"],
    ["name" => "Poland", "code" => "pl", "dial_code" => "+48"],
    ["name" => "Portugal", "code" => "pt", "dial_code" => "+351"],
    ["name" => "Qatar", "code" => "qa", "dial_code" => "+974"],
    ["name" => "Romania", "code" => "ro", "dial_code" => "+40"],
    ["name" => "Russia", "code" => "ru", "dial_code" => "+7"],
    ["name" => "Rwanda", "code" => "rw", "dial_code" => "+250"],
    ["name" => "Saint Kitts and Nevis", "code" => "kn", "dial_code" => "+1-869"],
    ["name" => "Saint Lucia", "code" => "lc", "dial_code" => "+1-758"],
    ["name" => "Saint Vincent and the Grenadines", "code" => "vc", "dial_code" => "+1-784"],
    ["name" => "Samoa", "code" => "ws", "dial_code" => "+685"],
    ["name" => "San Marino", "code" => "sm", "dial_code" => "+378"],
    ["name" => "Sao Tome and Principe", "code" => "st", "dial_code" => "+239"],
    ["name" => "Saudi Arabia", "code" => "sa", "dial_code" => "+966"],
    ["name" => "Senegal", "code" => "sn", "dial_code" => "+221"],
    ["name" => "Serbia", "code" => "rs", "dial_code" => "+381"],
    ["name" => "Seychelles", "code" => "sc", "dial_code" => "+248"],
    ["name" => "Sierra Leone", "code" => "sl", "dial_code" => "+232"],
    ["name" => "Singapore", "code" => "sg", "dial_code" => "+65"],
    ["name" => "Slovakia", "code" => "sk", "dial_code" => "+421"],
    ["name" => "Slovenia", "code" => "si", "dial_code" => "+386"],
    ["name" => "Solomon Islands", "code" => "sb", "dial_code" => "+677"],
    ["name" => "Somalia", "code" => "so", "dial_code" => "+252"],
    ["name" => "South Africa", "code" => "za", "dial_code" => "+27"],
    ["name" => "South Korea", "code" => "kr", "dial_code" => "+82"],
    ["name" => "South Sudan", "code" => "ss", "dial_code" => "+211"],
    ["name" => "Spain", "code" => "es", "dial_code" => "+34"],
    ["name" => "Sri Lanka", "code" => "lk", "dial_code" => "+94"],
    ["name" => "Sudan", "code" => "sd", "dial_code" => "+249"],
    ["name" => "Suriname", "code" => "sr", "dial_code" => "+597"],
    ["name" => "Sweden", "code" => "se", "dial_code" => "+46"],
    ["name" => "Switzerland", "code" => "ch", "dial_code" => "+41"],
    ["name" => "Syria", "code" => "sy", "dial_code" => "+963"],
    ["name" => "Taiwan", "code" => "tw", "dial_code" => "+886"],
    ["name" => "Tajikistan", "code" => "tj", "dial_code" => "+992"],
    ["name" => "Tanzania", "code" => "tz", "dial_code" => "+255"],
    ["name" => "Thailand", "code" => "th", "dial_code" => "+66"],
    ["name" => "Timor-Leste", "code" => "tl", "dial_code" => "+670"],
    ["name" => "Togo", "code" => "tg", "dial_code" => "+228"],
    ["name" => "Tonga", "code" => "to", "dial_code" => "+676"],
    ["name" => "Trinidad and Tobago", "code" => "tt", "dial_code" => "+1-868"],
    ["name" => "Tunisia", "code" => "tn", "dial_code" => "+216"],
    ["name" => "Turkey", "code" => "tr", "dial_code" => "+90"],
    ["name" => "Turkmenistan", "code" => "tm", "dial_code" => "+993"],
    ["name" => "Tuvalu", "code" => "tv", "dial_code" => "+688"],
    ["name" => "Uganda", "code" => "ug", "dial_code" => "+256"],
    ["name" => "Ukraine", "code" => "ua", "dial_code" => "+380"],
    ["name" => "United Arab Emirates", "code" => "ae", "dial_code" => "+971"],
    ["name" => "United Kingdom", "code" => "gb", "dial_code" => "+44"],
    ["name" => "United States of America", "code" => "us", "dial_code" => "+1"],
    ["name" => "Uruguay", "code" => "uy", "dial_code" => "+598"],
    ["name" => "Uzbekistan", "code" => "uz", "dial_code" => "+998"],
    ["name" => "Vanuatu", "code" => "vu", "dial_code" => "+678"],
    ["name" => "Venezuela", "code" => "ve", "dial_code" => "+58"],
    ["name" => "Vietnam", "code" => "vn", "dial_code" => "+84"],
    ["name" => "Yemen", "code" => "ye", "dial_code" => "+967"],
    ["name" => "Zambia", "code" => "zm", "dial_code" => "+260"],
    ["name" => "Zimbabwe", "code" => "zw", "dial_code" => "+263"]
];

require 'db.php';
include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in, if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('Pending or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$balance        = $userDetails['balance'];
$btc            = $userDetails['btc'];
$eth            = $userDetails['eth'];
$usdt           = $userDetails['usdt'];
$xrp            = $userDetails['xrp'];
$doge           = $userDetails['doge'];
$ada            = $userDetails['ada'];
$pepe           = $userDetails['pepe'];
$sol            = $userDetails['sol'];
$bnb            = $userDetails['bnb'];
$message        = $userDetails['message'];
$extra          = $userDetails['extra'];
$msgstatus      = $userDetails['msgstatus'];
$bonus          = $userDetails['bonus'];
$profit         = $userDetails['profit'];
$update_time    = $userDetails['update_time'];

// Check if country or phone is empty/null
$showProfileAlert = empty($country) || $country === null || empty($phone) || $phone === null;

// Fetch country statistics from the database
try {
    $query = "SELECT country, COUNT(*) AS customers
              FROM users 
              GROUP BY country
              ORDER BY customers DESC";
              
    $result = mysqli_query($conn, $query);
    
    if (!$result) {
        throw new Exception("Query failed: " . mysqli_error($conn));
    }
    
    $dbCountries = [];
    $total_customers = 0;
    
    // Build associative array of country counts using country name as key
    while ($row = mysqli_fetch_assoc($result)) {
        $dbCountries[$row['country']] = $row['customers'];
        $total_customers += $row['customers'];
    }
    
    // Merge full list of countries with DB data
    $countriesMap = [];
    foreach ($allCountries as $item) {
        $custCount = isset($dbCountries[$item['name']]) ? $dbCountries[$item['name']] : 0;
        $percentage = ($total_customers > 0) ? round(($custCount / $total_customers) * 100, 2) : 0;
        $item['customers'] = $custCount;
        $item['percentage'] = $percentage;
        $countriesMap[] = $item;
    }
    
    // Prepare JSON for client-side use if needed
    $jsonCountries = json_encode($countriesMap);
    
} catch (Exception $e) {
    die("Database error: " . $e->getMessage());
}

// Process form submission for profile update inline
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update_profile'])) {
    $newDialCode = $_POST['country'];
    $newPhone = $_POST['full_phone']; // Full phone with dial code
    
    // Validate inputs
    if (empty($newDialCode) || empty($newPhone)) {
        $updateError = "Both country and phone number are required.";
    } else {
        // Map the dial code to the country name using the full countries list
        $newCountry = $newDialCode; // default fallback
        foreach ($allCountries as $c) {
            if ($c['dial_code'] === $newDialCode) {
                $newCountry = $c['name'];
                break;
            }
        }
        
        // Update user profile in the database using mysqli
        $updateQuery = "UPDATE users 
                        SET country = ?, phone = ? 
                        WHERE google_id = ?";
        $stmt = mysqli_prepare($conn, $updateQuery);
        
        if ($stmt) {
            mysqli_stmt_bind_param($stmt, "sss", $newCountry, $newPhone, $google_id);
            
            if (mysqli_stmt_execute($stmt)) {
                // Instead of redirecting, update inline variables and set a success message
                $updateMessage = "Profile updated successfully.";
                $country = $newCountry;
                $phone = $newPhone;
            } else {
                $updateError = "Failed to update profile: " . mysqli_stmt_error($stmt);
            }
            
            mysqli_stmt_close($stmt);
        } else {
            $updateError = "Failed to prepare statement: " . mysqli_error($conn);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ProTrade - Advanced Trading Platform</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap');
        
        * {
            font-family: 'Inter', sans-serif;
        }
        
        :root {
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --success-color: #10b981;
            --danger-color: #ef4444;
            --warning-color: #f59e0b;
        }
        
        .gradient-bg {
            background: var(--primary-gradient);
        }
        
        .glass-effect {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
        }
        
        .trading-card {
            background: white;
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            border: 1px solid rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
        }
        
        .trading-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 40px rgba(0, 0, 0, 0.12);
        }
        
        .price-up {
            color: var(--success-color);
            animation: pulse-green 2s infinite;
        }
        
        .price-down {
            color: var(--danger-color);
            animation: pulse-red 2s infinite;
        }
        
        @keyframes pulse-green {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.8; }
        }
        
        @keyframes pulse-red {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.8; }
        }
        
        .buy-btn {
            background: linear-gradient(135deg, var(--success-color), #059669);
            transition: all 0.3s ease;
        }
        
        .buy-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 8px 25px rgba(16, 185, 129, 0.3);
        }
        
        .sell-btn {
            background: linear-gradient(135deg, var(--danger-color), #dc2626);
            transition: all 0.3s ease;
        }
        
        .sell-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 8px 25px rgba(239, 68, 68, 0.3);
        }
        
        .lot-option {
            transition: all 0.2s ease;
            cursor: pointer;
            border: 2px solid #e5e7eb;
            border-radius: 8px;
            padding: 8px 16px;
            text-align: center;
            background: white;
        }
        
        .lot-option:hover {
            border-color: #8b5cf6;
            transform: scale(1.02);
        }
        
        .lot-option.selected {
            background: var(--primary-gradient);
            color: white;
            border-color: transparent;
        }
        
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.6);
            backdrop-filter: blur(5px);
        }
        
        .modal.show {
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .modal-content {
            background: white;
            border-radius: 16px;
            max-width: 500px;
            width: 90%;
            max-height: 90vh;
            overflow-y: auto;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
        }
        
        .trading-terminal {
            display: grid;
            grid-template-columns: 320px 1fr 320px;
            gap: 24px;
            padding: 24px;
            min-height: calc(100vh - 120px);
        }
        
        @media (max-width: 1200px) {
            .trading-terminal {
                grid-template-columns: 1fr;
                gap: 16px;
                padding: 16px;
            }
        }
        
        .chart-container {
            position: relative;
            height: 400px;
            width: 100%;
        }
        
        .mini-chart {
            height: 120px;
            width: 100%;
        }
        
        .currency-flag {
            width: 24px;
            height: 18px;
            border-radius: 2px;
            margin-right: 4px;
            background-size: cover;
            background-position: center;
        }
        
        .spread-badge {
            background: rgba(139, 92, 246, 0.1);
            color: #8b5cf6;
            padding: 2px 8px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: 600;
        }
        
        .loading-spinner {
            border: 3px solid #f3f4f6;
            border-top: 3px solid #8b5cf6;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            animation: spin 1s linear infinite;
            display: inline-block;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .notification {
            position: fixed;
            top: 100px;
            right: 20px;
            z-index: 1001;
            transform: translateX(100%);
            transition: transform 0.3s ease;
        }
        
        .notification.show {
            transform: translateX(0);
        }
        
        .timeframe-btn {
            transition: all 0.2s ease;
        }
        
        .timeframe-btn.active {
            background: var(--primary-gradient);
            color: white;
            border-color: transparent;
        }
        
        .scrollbar-thin::-webkit-scrollbar {
            width: 4px;
        }
        
        .scrollbar-thin::-webkit-scrollbar-track {
            background: #f1f5f9;
        }
        
        .scrollbar-thin::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 2px;
        }
        
        .live-indicator {
            width: 8px;
            height: 8px;
            background: #10b981;
            border-radius: 50%;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% {
                transform: scale(0.95);
                box-shadow: 0 0 0 0 rgba(16, 185, 129, 0.7);
            }
            70% {
                transform: scale(1);
                box-shadow: 0 0 0 10px rgba(16, 185, 129, 0);
            }
            100% {
                transform: scale(0.95);
                box-shadow: 0 0 0 0 rgba(16, 185, 129, 0);
            }
        }
        
        .compact-lot-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 8px;
            margin-bottom: 12px;
        }
        
        .compact-lot-option {
            padding: 6px 8px;
            font-size: 12px;
            border: 2px solid #e5e7eb;
            border-radius: 6px;
            text-align: center;
            cursor: pointer;
            transition: all 0.2s ease;
            background: white;
        }
        
        .compact-lot-option:hover {
            border-color: #8b5cf6;
        }
        
        .compact-lot-option.selected {
            background: var(--primary-gradient);
            color: white;
            border-color: transparent;
        }
        
        .flag-eur { background-image: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 480"><defs><g id="d"><g id="b"><path id="a" d="m0-1-.3.95L0 0l-.3-.95L0-1z" fill="%23fc0"/><use href="%23a" transform="rotate(72)"/><use href="%23a" transform="rotate(144)"/><use href="%23a" transform="rotate(216)"/><use href="%23a" transform="rotate(288)"/></g><use href="%23b" transform="scale(-1 1)"/></g></defs><path fill="%23039" d="M0 0h640v480H0z"/><g fill="%23fc0" transform="translate(320 240)scale(25.6)"><use href="%23d" y="-6"/><use href="%23d" y="6"/><g id="c"><use href="%23d" x="-6"/><use href="%23d" transform="rotate(-144 -2.3 -2.1)"/><use href="%23d" transform="rotate(144 -2.3 -2.1)"/><use href="%23d" transform="rotate(72 -2.3 -2.1)"/><use href="%23d" transform="rotate(-72 -2.3 -2.1)"/></g><use href="%23c" transform="scale(-1 1)"/></g></svg>'); }
        .flag-usd { background-image: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 480"><g fill-rule="evenodd"><g stroke-width="1pt"><path fill="%23b22234" d="M0 0h247v10H0zm0 20h247v10H0z" transform="scale(2.6)"/><path fill="%23fff" d="M0 10h247v10H0zm0 20h247v10H0z" transform="scale(2.6)"/></g><path fill="%233c3b6e" d="M0 0h98.8v70H0z" transform="scale(2.6)"/><g fill="%23fff" transform="scale(.5)"><g id="c"><path id="a" d="M14.4 4.2 12 8.4l-2.4-4.2h2.9L12 3zm-.4 7.8L12 9.6l-2 2.4 2-2.4 2 2.4z"/><use href="%23a" transform="translate(0 20)"/><use href="%23a" transform="translate(0 40)"/><use href="%23a" transform="translate(0 60)"/></g><use href="%23c" transform="translate(25)"/><use href="%23c" transform="translate(50)"/><use href="%23c" transform="translate(75)"/></g></g></svg>'); }
        .flag-gbp { background-image: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 480"><path fill="%23012169" d="M0 0h640v480H0z"/><path fill="%23FFF" d="m75 0 244 181L562 0h78v62L400 241l240 178v61h-80L320 301 81 480H0v-60l239-178L0 64V0z"/><path fill="%23C8102E" d="m424 281 216 159v40L369 281zm-184 20 6 35L54 480H0zM640 0v3L391 191l2-44L590 0zM0 0l239 176h-60L0 42z"/><path fill="%23FFF" d="M241 0v480h160V0zM0 160v160h640V160z"/><path fill="%23C8102E" d="M0 193v96h640v-96zM273 0v480h96V0z"/></svg>'); }
        .flag-jpy { background-image: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 480"><defs><clipPath id="a"><path fill-opacity=".7" d="M-88 32h640v480H-88z"/></clipPath></defs><g fill-rule="evenodd" stroke-width="1pt" clip-path="url(%23a)" transform="translate(88 -32)"><path fill="%23fff" d="M-128 32h720v480h-720z"/><circle cx="523.1" cy="344.1" r="194.9" fill="%23bc002d" transform="translate(-168.4 8.6)scale(.76554)"/></g></svg>'); }
        
        .stock-icon {
            width: 24px;
            height: 24px;
            border-radius: 4px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 10px;
            margin-right: 8px;
        }
        
        .icon-aapl { background: linear-gradient(135deg, #000, #333); color: white; }
        .icon-googl { background: linear-gradient(135deg, #4285f4, #34a853); color: white; }
        .icon-msft { background: linear-gradient(135deg, #00bcf2, #0078d4); color: white; }
        .icon-amzn { background: linear-gradient(135deg, #ff9900, #ff6600); color: white; }
        .icon-tsla { background: linear-gradient(135deg, #cc0000, #e82127); color: white; }
        .icon-nvda { background: linear-gradient(135deg, #76b900, #458b00); color: white; }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Header -->
 <header class="gradient-bg text-white shadow-xl sticky top-0 z-50">
    <div class="px-4 lg:px-6 py-4">
        <div class="flex items-center justify-between">
            
            <!-- Navigation -->
            <?php include './includes/nav.php'; ?>

           <!-- Desktop Account Stats -->
<div class="hidden lg:flex items-center space-x-8 text-sm mt-16">
    <div class="text-center">
        <div class="text-white/70">Balance</div>
        <div class="font-bold text-lg">$<span id="userBalance">50,000.00</span></div>
    </div>
    <div class="text-center">
        <div class="text-white/70">Equity</div>
        <div class="font-bold text-lg">$<span id="userEquity">50,000.00</span></div>
    </div>
    <div class="text-center">
        <div class="text-white/70">Margin</div>
        <div class="font-bold text-lg">$<span id="userMargin">0.00</span></div>
    </div>
    <div class="text-center">
        <div class="text-white/70">P&amp;L</div>
        <div class="font-bold text-lg text-green-300">$<span id="userPnL">+2,547.85</span></div>
    </div>
</div>

        <!-- Mobile Stats -->
        <div class="lg:hidden mt-4 grid grid-cols-2 gap-4 text-sm">
            <div class="text-center">
                <div class="text-white/70">Balance</div>
                <div class="font-bold">$<span id="mobileBalance">50,000.00</span></div>
            </div>
            <div class="text-center">
                <div class="text-white/70">P&amp;L</div>
                <div class="font-bold text-green-300">$<span id="mobilePnL">+2,547.85</span></div>
            </div>
        </div>
    </div>
</header>


    <!-- Notification System -->
    <div id="notification" class="notification bg-white border-l-4 border-green-500 p-4 shadow-lg rounded-lg">
        <div class="flex items-center">
            <i class="fas fa-check-circle text-green-500 mr-3"></i>
            <div>
                <div class="font-semibold text-gray-800" id="notificationTitle">Success</div>
                <div class="text-sm text-gray-600" id="notificationMessage">Operation completed successfully</div>
            </div>
        </div>
    </div>

    <!-- Profile Modal -->
    <div id="profileModal" class="modal">
        <div class="modal-content">
            <div class="p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-gray-800">SELECT PREFERRED TRADE TYPE</h3>
                    <button onclick="closeProfileModal()" class="text-gray-400 hover:text-gray-600">
                        <i class="fas fa-times text-xl"></i>
                    </button>
                </div>
                
                <div class="mb-4 p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-triangle text-yellow-500 mr-3"></i>
                        <p class="text-sm text-yellow-800">Please complete your profile to access all trading features.</p>
                    </div>
                </div>
                
                <form onsubmit="saveForexPreferences(event)" class="space-y-4">
    <div>
        <label for="forexCountrySelect" class="block text-sm font-medium text-gray-700 mb-2">Country</label>
        <select name="country" id="forexCountrySelect" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent" required>
            <option value="">Select your country</option>
            <option value="United States">United States</option>
            <option value="United Kingdom">United Kingdom</option>
            <option value="Canada">Canada</option>
            <option value="Australia">Australia</option>
            <option value="Germany">Germany</option>
            <option value="France">France</option>
            <option value="Japan">Japan</option>
            <option value="Singapore">Singapore</option>
        </select>
    </div>

    <div>
        <label class="block text-sm font-medium text-gray-700 mb-2">Preferred Trading Type</label>
        <div class="grid grid-cols-2 gap-4">
            <div id="forexBox" class="trade-box border-2 border-gray-200 rounded-lg p-4 cursor-pointer hover:border-purple-500 transition-colors" onclick="selectTradeType('forex')">
                <div class="flex items-center space-x-3">
                    <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center">
                        <i class="fas fa-chart-line text-blue-600"></i>
                    </div>
                    <div>
                        <h4 class="font-semibold">Forex</h4>
                        <p class="text-sm text-gray-600">Currency pairs</p>
                    </div>
                </div>
            </div>

            <div id="stocksBox" class="trade-box border-2 border-gray-200 rounded-lg p-4 cursor-pointer hover:border-purple-500 transition-colors" onclick="selectTradeType('stocks')">
                <div class="flex items-center space-x-3">
                    <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center">
                        <i class="fas fa-building text-green-600"></i>
                    </div>
                    <div>
                        <h4 class="font-semibold">Stocks</h4>
                        <p class="text-sm text-gray-600">Equity trading</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="flex justify-end space-x-3 mt-6">
        <button type="button" onclick="closeProfileModal()" class="px-4 py-2 text-gray-600 border border-gray-300 rounded-lg hover:bg-gray-50">
            Cancel
        </button>
        <button type="submit" class="px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700">
            Save Preferences
        </button>
    </div>
</form>

<script>
    // Load saved preferences on page load
    document.addEventListener('DOMContentLoaded', function () {
        const savedCountry = localStorage.getItem('forex_country');
        const savedTradeType = localStorage.getItem('forex_trade_type');

        if (savedCountry) {
            document.getElementById('forexCountrySelect').value = savedCountry;
        }

        if (savedTradeType) {
            selectTradeType(savedTradeType, true); // true means it's from cache
        }
    });

    function selectTradeType(type, fromCache = false) {
        const boxes = document.querySelectorAll('.trade-box');
        boxes.forEach(box => box.classList.remove('border-purple-500'));
        if (type === 'forex') {
            document.getElementById('forexBox').classList.add('border-purple-500');
        } else if (type === 'stocks') {
            document.getElementById('stocksBox').classList.add('border-purple-500');
        }

        if (!fromCache) {
            localStorage.setItem('forex_trade_type', type);
        }

        // Save to global variable for form submit if needed
        window.selectedTradeType = type;
    }

    function saveForexPreferences(event) {
        event.preventDefault();

        const selectedCountry = document.getElementById('forexCountrySelect').value;
        const selectedType = window.selectedTradeType || localStorage.getItem('forex_trade_type');

        if (!selectedType) {
            alert("Please select a trading type.");
            return;
        }

        // Store preferences in localStorage
        localStorage.setItem('forex_country', selectedCountry);
        localStorage.setItem('forex_trade_type', selectedType);

        // Submit or notify user
        alert(`Preferences Saved:\nCountry: ${selectedCountry}\nTrading Type: ${selectedType}`);
        // If submitting to a backend: document.querySelector('form').submit();
    }

    function closeProfileModal() {
        alert("Modal closed."); // Replace with actual modal close code
    }
</script>

            </div>
        </div>
    </div>

    <!-- Main Trading Interface -->
    <div class="trading-terminal">
        <!-- Left Sidebar - Market Watch -->
        <div class="space-y-4">
            <!-- Market Watch -->
            <div class="trading-card">
                <div class="p-4 border-b border-gray-100">
                    <div class="flex items-center justify-between">
                        <h3 class="font-semibold text-gray-800">Market Watch</h3>
                        <div class="flex space-x-2">
                            <button onclick="switchMarket('forex')" id="forexTab" class="px-3 py-1 text-sm font-medium text-purple-600 border-b-2 border-purple-600 transition-colors">
                                Forex
                            </button>
                            <button onclick="switchMarket('stocks')" id="stocksTab" class="px-3 py-1 text-sm font-medium text-gray-600 border-b-2 border-transparent hover:text-purple-600 transition-colors">
                                Stocks
                            </button>
                        </div>
                    </div>
                    <div class="mt-3">
                        <input type="text" placeholder="Search..." class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:border-purple-500 focus:outline-none text-sm" id="searchInput">
                    </div>
                </div>
                
                <div class="p-2 space-y-1 max-h-96 overflow-y-auto scrollbar-thin" id="marketData">
                    <div class="text-center py-4 text-gray-500">
                        <div class="loading-spinner mx-auto mb-2"></div>
                        Loading market data...
                    </div>
                </div>
            </div>
            
            

            <!-- Open Positions -->
            <div class="trading-card">
                <div class="p-4">
                    <h3 class="font-semibold text-gray-800 mb-3">Open Positions</h3>
                    <div class="space-y-2" id="openPositions">
                        <div class="text-center py-4 text-gray-500 text-sm">
                            No open positions
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Center - Charts Area -->
        <div class="space-y-4">
            <!-- Chart Header -->
            <div class="trading-card">
                <div class="p-4 border-b border-gray-100">
                    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between space-y-4 lg:space-y-0">
                        <div class="flex items-center space-x-2 lg:space-x-4">
                            <div class="flex items-center space-x-2">
                               
                                <div>
                                      


                                    <div class="text-sm text-gray-500" id="currentPairName">Euro / US Dollar</div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="flex items-center space-x-4">
                            <div class="text-right">
                                <div class="font-mono text-2xl font-bold" id="currentPrice">1.0950</div>
                                <div class="text-sm flex items-center" id="currentChange">
                                    <span id="changeValue" class="price-up">+0.0024</span>
                                    <span class="spread-badge ml-2" id="spreadValue">1.2</span>
                                </div>
                            </div>
                            <div class="flex space-x-2">
                                <button class="px-4 py-2 sell-btn text-white rounded-lg text-sm font-semibold" onclick="openTradeModal('SELL')">
                                    <i class="fas fa-arrow-down mr-2"></i>SELL
                                </button>
                                <button class="px-4 py-2 buy-btn text-white rounded-lg text-sm font-semibold" onclick="openTradeModal('BUY')">
                                    <i class="fas fa-arrow-up mr-2"></i>BUY
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Chart Controls -->
                    <div class="flex flex-wrap items-center gap-4 mt-4">
                        <div class="flex items-center space-x-2">
                            <span class="text-sm text-gray-600">Timeframe:</span>
                            <div class="flex space-x-1" id="timeframeButtons">
                                <button class="timeframe-btn px-3 py-1 text-sm rounded border hover:bg-purple-50 active" data-tf="H1">1H</button>
                                <button class="timeframe-btn px-3 py-1 text-sm rounded border hover:bg-purple-50" data-tf="H4">4H</button>
                                <button class="timeframe-btn px-3 py-1 text-sm rounded border hover:bg-purple-50" data-tf="D1">1D</button>
                            </div>
                        </div>
                        <div class="flex items-center space-x-2">
                            <button class="px-3 py-1 text-sm rounded border hover:bg-gray-50" onclick="resetChart()">
                                <i class="fas fa-refresh mr-1"></i>Reset
                            </button>
                            <button class="px-3 py-1 text-sm rounded border hover:bg-gray-50" onclick="toggleFullscreen()">
                                <i class="fas fa-expand mr-1"></i>Fullscreen
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="p-4">
                    <div class="chart-container">
                        <canvas id="priceChart"></canvas>
                    </div>
                </div>
            </div>
            <!-- Account Overview -->
            <div class="trading-card">
                <div class="p-4">
                    <h3 class="font-semibold text-gray-800 mb-3">Account Overview</h3>
                    <div class="space-y-3">
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Account Type</span>
                            <span class="font-semibold text-purple-600">Standard</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Leverage</span>
                            <span class="font-semibold">1:100</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Spread</span>
                            <span class="font-semibold text-green-600">Variable</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Free Margin</span>
                            <span class="font-semibold" id="freeMargin">$50,000.00</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Margin Level</span>
                            <span class="font-semibold text-green-600" id="marginLevel">∞%</span>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Economic Calendar -->
            <div class="trading-card">
                <div class="p-4 border-b border-gray-100">
                    <h3 class="font-semibold text-gray-800">Economic Calendar</h3>
                </div>
                <div class="p-4">
                    <div class="space-y-3" id="economicEvents">
                        <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-lg">
                            <div class="w-2 h-2 bg-red-500 rounded-full"></div>
                            <div class="flex-1">
                                <div class="font-medium text-sm">USD Non-Farm Payrolls</div>
                                <div class="text-xs text-gray-500">15:30 GMT | High Impact</div>
                            </div>
                            <div class="text-sm font-mono">185K</div>
                        </div>
                        <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-lg">
                            <div class="w-2 h-2 bg-yellow-500 rounded-full"></div>
                            <div class="flex-1">
                                <div class="font-medium text-sm">EUR CPI Flash Estimate</div>
                                <div class="text-xs text-gray-500">10:00 GMT | Medium Impact</div>
                            </div>
                            <div class="text-sm font-mono">2.4%</div>
                        </div>
                        <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-lg">
                            <div class="w-2 h-2 bg-green-500 rounded-full"></div>
                            <div class="flex-1">
                                <div class="font-medium text-sm">GBP GDP Monthly</div>
                                <div class="text-xs text-gray-500">07:00 GMT | Low Impact</div>
                            </div>
                            <div class="text-sm font-mono">0.1%</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Right Sidebar - Trading Panel -->
        <div class="space-y-4">
            <!-- Quick Trade -->
            <div class="trading-card">
                <div class="p-4 border-b border-gray-100">
                    <h3 class="font-semibold text-gray-800">Quick Trade</h3>
                </div>
                <div class="p-4 space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Volume (Lots)</label>
                        <div class="compact-lot-grid">
                            <div class="compact-lot-option selected" onclick="selectLot(this, 0.01)">0.01</div>
                            <div class="compact-lot-option" onclick="selectLot(this, 0.1)">0.1</div>
                            <div class="compact-lot-option" onclick="selectLot(this, 1.0)">1.0</div>
                            <div class="compact-lot-option" onclick="selectLot(this, 2.0)">2.0</div>
                            <div class="compact-lot-option" onclick="selectLot(this, 5.0)">5.0</div>
                            <div class="compact-lot-option" onclick="selectLot(this, 10.0)">10.0</div>
                        </div>
                        <input type="number" step="0.01" min="0.01" max="100" value="0.01" class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:border-purple-500 focus:outline-none text-center font-mono" id="customLotSize">
                    </div>
                    
                    <div class="grid grid-cols-2 gap-3">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Stop Loss</label>
                            <input type="number" step="0.0001" placeholder="0.0000" class="w-full px-2 py-2 border border-gray-200 rounded text-center font-mono text-sm" id="stopLoss">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Take Profit</label>
                            <input type="number" step="0.0001" placeholder="0.0000" class="w-full px-2 py-2 border border-gray-200 rounded text-center font-mono text-sm" id="takeProfit">
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-2 gap-3">
                        <button class="sell-btn text-white py-3 rounded-lg font-semibold text-sm hover:shadow-lg transition-all" onclick="executeTrade('SELL')">
                            <div class="text-lg font-bold" id="sellPrice">1.0948</div>
                            <div class="text-xs opacity-90">SELL</div>
                        </button>
                        <button class="buy-btn text-white py-3 rounded-lg font-semibold text-sm hover:shadow-lg transition-all" onclick="executeTrade('BUY')">
                            <div class="text-lg font-bold" id="buyPrice">1.0952</div>
                            <div class="text-xs opacity-90">BUY</div>
                        </button>
                    </div>
                    
                    <div class="text-xs text-gray-500 space-y-1">
                        <div class="flex justify-between">
                            <span>Spread:</span>
                            <span id="quickSpread">0.4 pips</span>
                        </div>
                        <div class="flex justify-between">
                            <span>Margin Required:</span>
                            <span id="marginRequired">$10.95</span>
                        </div>
                        <div class="flex justify-between">
                            <span>Pip Value:</span>
                            <span id="pipValue">$0.10</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Market Analysis -->
            <div class="trading-card">
                <div class="p-4 border-b border-gray-100">
                    <h3 class="font-semibold text-gray-800">Market Analysis</h3>
                </div>
                <div class="p-4 space-y-4">
                    <div class="bg-green-50 border border-green-200 rounded-lg p-3">
                        <div class="flex items-center space-x-2 mb-2">
                            <i class="fas fa-arrow-up text-green-600"></i>
                            <span class="font-semibold text-green-800">Bullish Trend</span>
                        </div>
                        <p class="text-sm text-green-700">EUR/USD showing strong upward momentum with RSI at 65.2</p>
                    </div>
                    
                    <div class="space-y-2">
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">RSI (14):</span>
                            <span class="font-mono text-sm">65.2</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">MACD:</span>
                            <span class="font-mono text-sm text-green-600">+0.0012</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">MA (20):</span>
                            <span class="font-mono text-sm">1.0935</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">Support:</span>
                            <span class="font-mono text-sm">1.0920</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">Resistance:</span>
                            <span class="font-mono text-sm">1.0980</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Trading Signals -->
            <div class="trading-card">
                <div class="p-4 border-b border-gray-100">
                    <h3 class="font-semibold text-gray-800">Trading Signals</h3>
                </div>
                <div class="p-4 space-y-3">
                    <div class="flex items-center space-x-3 p-3 bg-green-50 border border-green-200 rounded-lg">
                        <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                        <div class="flex-1">
                            <div class="font-medium text-sm text-green-800">BUY EUR/USD</div>
                            <div class="text-xs text-green-600">Entry: 1.0950 | TP: 1.0980</div>
                        </div>
                        <div class="text-xs text-green-600 font-semibold">ACTIVE</div>
                    </div>
                    
                    <div class="flex items-center space-x-3 p-3 bg-blue-50 border border-blue-200 rounded-lg">
                        <div class="w-3 h-3 bg-blue-500 rounded-full"></div>
                        <div class="flex-1">
                            <div class="font-medium text-sm text-blue-800">HOLD GBP/USD</div>
                            <div class="text-xs text-blue-600">Wait for breakout above 1.2650</div>
                        </div>
                        <div class="text-xs text-blue-600 font-semibold">PENDING</div>
                    </div>
                    
                    <div class="flex items-center space-x-3 p-3 bg-red-50 border border-red-200 rounded-lg">
                        <div class="w-3 h-3 bg-red-500 rounded-full"></div>
                        <div class="flex-1">
                            <div class="font-medium text-sm text-red-800">SELL USD/JPY</div>
                            <div class="text-xs text-red-600">Entry: 149.80 | TP: 148.50</div>
                        </div>
                        <div class="text-xs text-red-600 font-semibold">CLOSED</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    
    
    <!-- Trade Modal -->
<div id="tradeModal" class="modal">
 <div class="modal-content">
  <div class="p-6">
 
 
  <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>


<form id="tradeForm" name="tradeForm" action="forexpay.php" method="POST" class="space-y-6 bg-white p-6 rounded-lg shadow-md max-w-xl mx-auto">
  <!-- Hidden name and email fields -->
  <input type="hidden" id="name" name="name" value="<?php echo htmlspecialchars($name ?? ''); ?>" required />
  <input type="hidden" id="email" name="email" value="<?php echo htmlspecialchars($email ?? ''); ?>" required />

  <!-- Trade Modal Header -->
  <div class="flex items-center justify-between mb-4">
    <h3 class="text-xl font-bold text-gray-800" id="tradeModalTitle">Place Order</h3>
    <button type="button" onclick="closeTradeModal()" class="text-gray-400 hover:text-gray-600">
      <i class="fas fa-times text-xl"></i>
    </button>
  </div>

  <!-- Pair Selection -->
  <div>
    <label for="pair_select" class="block text-sm font-medium text-gray-700 mb-1">Select Pair</label>
    <select id="pair_select" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500">
      <!-- Populated dynamically -->
    </select>
  </div>

  <!-- Display Selected Pair -->
  <div class="flex items-center space-x-2 bg-gray-100 px-3 py-2 rounded-lg border border-gray-300 shadow-sm mt-4">
    <span id="trade_pair_icon"></span>
    <input type="text" id="trade_pair" name="pair" value="" readonly class="flex-1 bg-transparent focus:outline-none text-gray-700 font-semibold" />
  </div>

  <!-- Display Trade Info -->
  <div class="flex items-center space-x-4 p-4 bg-gray-50 rounded-lg border border-gray-200 mt-4">
    <div id="trade_display_pair" class="font-semibold text-gray-700 text-lg"></div>
    <div class="ml-auto text-right">
      <input type="text" id="trade_price" name="price" value="1.0950" class="text-xl font-bold text-right font-mono w-24 bg-transparent border-none focus:outline-none" />
      <div class="text-sm text-gray-500" id="trade_order_type_display">Market Order</div>
    </div>
  </div>

  <!-- Order Type and Lot Size -->
  <div class="grid grid-cols-2 gap-4 mt-4">
    <div>
      <label for="trade_order_type" class="block text-sm font-medium text-gray-700 mb-1">Order Type</label>
      <select id="trade_order_type" name="order_type" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500">
        <option value="market">Market Order</option>
        <option value="pending">Pending Order</option>
        <option value="stop">Stop Order</option>
        <option value="limit">Limit Order</option>
      </select>
    </div>
    <div>
      <label for="trade_lot_size" class="block text-sm font-medium text-gray-700 mb-1">Volume (Lots)</label>
      <input type="number" step="0.01" min="0.01" max="100" value="0.01" id="trade_lot_size" name="lot_size" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 text-center font-mono" />
    </div>
  </div>

  <!-- Lot Size Quick Selection -->
  <div class="grid grid-cols-6 gap-2 text-center mt-4">
    <div class="lot-option selected cursor-pointer py-2 rounded-lg bg-purple-100 text-purple-700 font-semibold" onclick="selectTradeLot(this, 0.01)" data-value="0.01">0.01</div>
    <div class="lot-option cursor-pointer py-2 rounded-lg bg-gray-100 text-gray-700" onclick="selectTradeLot(this, 0.1)" data-value="0.1">0.1</div>
    <div class="lot-option cursor-pointer py-2 rounded-lg bg-gray-100 text-gray-700" onclick="selectTradeLot(this, 0.5)" data-value="0.5">0.5</div>
    <div class="lot-option cursor-pointer py-2 rounded-lg bg-gray-100 text-gray-700" onclick="selectTradeLot(this, 1.0)" data-value="1.0">1.0</div>
    <div class="lot-option cursor-pointer py-2 rounded-lg bg-gray-100 text-gray-700" onclick="selectTradeLot(this, 5.0)" data-value="5.0">5.0</div>
    <div class="lot-option cursor-pointer py-2 rounded-lg bg-gray-100 text-gray-700" onclick="selectTradeLot(this, 10.0)" data-value="10.0">10.0</div>
  </div>

  <!-- Stop Loss & Take Profit -->
  <div class="grid grid-cols-2 gap-4 mt-4">
    <div>
      <label for="trade_stop_loss" class="block text-sm font-medium text-gray-700 mb-1">Stop Loss</label>
      <input type="number" step="0.0001" placeholder="Optional" id="trade_stop_loss" name="stop_loss" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 text-center font-mono" />
    </div>
    <div>
      <label for="trade_take_profit" class="block text-sm font-medium text-gray-700 mb-1">Take Profit</label>
      <input type="number" step="0.0001" placeholder="Optional" id="trade_take_profit" name="take_profit" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 text-center font-mono" />
    </div>
  </div>

  <!-- Trade Summary Info -->
  <div class="bg-gray-50 rounded-lg p-4 space-y-2 text-sm border border-gray-200 mt-4">
    <div class="flex justify-between">
      <span class="text-gray-600">Margin Required:</span>
      <input type="text" id="trade_margin_required" name="margin_required" value="$10.95" class="bg-transparent font-semibold text-right w-24" readonly />
    </div>
    <div class="flex justify-between">
      <span class="text-gray-600">Pip Value:</span>
      <input type="text" id="trade_pip_value" name="pip_value" value="$0.10" class="bg-transparent font-semibold text-right w-24" readonly />
    </div>
    <div class="flex justify-between">
      <span class="text-gray-600">Spread:</span>
      <input type="text" id="trade_spread" name="spread" value="0.4 pips" class="bg-transparent font-semibold text-right w-24" readonly />
    </div>
    <div class="flex justify-between">
      <span class="text-gray-600">Estimated Cost:</span>
      <input type="text" id="trade_estimated_cost" name="estimated_cost" value="$10.95" class="bg-transparent font-semibold text-right w-24" readonly />
    </div>
  </div>

  <!-- Action Buttons -->
  <div class="flex space-x-3 pt-4">
    <button type="button" onclick="closeTradeModal()" class="flex-1 px-4 py-2 text-gray-600 border border-gray-300 rounded-lg hover:bg-gray-50">Cancel</button>
    <button type="submit" class="flex-1 px-4 py-2 text-white rounded-lg font-semibold bg-blue-600 hover:bg-blue-700 transition">Place Order</button>
  </div>
</form>

<script>
// Currency pairs list
const pairs = [
  { symbol: "EUR/USD", icon: "🇪🇺/🇺🇸", spread: 0.4, pipValue: 10, marginPerLot: 1000 },
  { symbol: "GBP/USD", icon: "🇬🇧/🇺🇸", spread: 0.6, pipValue: 9.5, marginPerLot: 1000 },
  { symbol: "USD/JPY", icon: "🇺🇸/🇯🇵", spread: 0.3, pipValue: 8.7, marginPerLot: 900 },
];

// Populate pair dropdown
const pairSelect = document.getElementById("pair_select");
pairs.forEach((p, i) => {
  const opt = document.createElement("option");
  opt.value = p.symbol;
  opt.textContent = p.symbol;
  pairSelect.appendChild(opt);
});

// Set initial pair
pairSelect.selectedIndex = 0;
updatePairInfo(pairSelect.value);

// Event Listeners
pairSelect.addEventListener("change", (e) => {
  updatePairInfo(e.target.value);
});

document.getElementById("trade_lot_size").addEventListener("input", updateCalculation);

document.getElementById("trade_order_type").addEventListener("change", (e) => {
  document.getElementById("trade_order_type_display").innerText = e.target.options[e.target.selectedIndex].text;
});

// Handle lot button click
function selectTradeLot(el, value) {
  document.querySelectorAll(".lot-option").forEach(opt => {
    opt.classList.remove("bg-purple-100", "text-purple-700", "font-semibold");
    opt.classList.add("bg-gray-100", "text-gray-700");
  });
  el.classList.remove("bg-gray-100", "text-gray-700");
  el.classList.add("bg-purple-100", "text-purple-700", "font-semibold");
  document.getElementById("trade_lot_size").value = value;
  updateCalculation();
}

function updatePairInfo(symbol) {
  const selected = pairs.find(p => p.symbol === symbol);
  document.getElementById("trade_pair").value = selected.symbol;
  document.getElementById("trade_display_pair").innerText = selected.symbol;
  document.getElementById("trade_pair_icon").innerText = selected.icon;
  updateCalculation();
}

function updateCalculation() {
  const lot = parseFloat(document.getElementById("trade_lot_size").value) || 0;
  const selected = pairs.find(p => p.symbol === document.getElementById("pair_select").value);
  const margin = lot * selected.marginPerLot;
  const pipValue = (selected.pipValue * lot).toFixed(2);
  const spread = selected.spread;
  const estimatedCost = margin + spread;

  document.getElementById("trade_margin_required").value = `$${margin.toFixed(2)}`;
  document.getElementById("trade_pip_value").value = `$${pipValue}`;
  document.getElementById("trade_spread").value = `${spread} pips`;
  document.getElementById("trade_estimated_cost").value = `$${estimatedCost.toFixed(2)}`;
}

function closeTradeModal() {
  alert("Modal closed. (Implement hide modal functionality)");
}
</script>




  </div>
</div>

</div>
<script>
  const tradingPairs = [
    // 🟦 STOCKS FIRST
    { name: 'AAPL/USD', icon: 'icons/aapl.svg' },
    { name: 'TSLA/USD', icon: 'icons/tsla.svg' },
    { name: 'MSFT/USD', icon: 'icons/msft.svg' },
    { name: 'AMZN/USD', icon: 'icons/amzn.svg' },
    { name: 'GOOGL/USD', icon: 'icons/googl.svg' },
    { name: 'META/USD', icon: 'icons/meta.svg' },
    { name: 'NFLX/USD', icon: 'icons/nflx.svg' },
    { name: 'NVDA/USD', icon: 'icons/nvda.svg' },
    { name: 'BABA/USD', icon: 'icons/baba.svg' },
    { name: 'INTC/USD', icon: 'icons/intc.svg' },
    { name: 'DIS/USD', icon: 'icons/dis.svg' },
    { name: 'BA/USD', icon: 'icons/ba.svg' },
    { name: 'ORCL/USD', icon: 'icons/orcl.svg' },
    { name: 'AMD/USD', icon: 'icons/amd.svg' },
    { name: 'PYPL/USD', icon: 'icons/pypl.svg' },
    { name: 'SHOP/USD', icon: 'icons/shop.svg' },
    { name: 'UBER/USD', icon: 'icons/uber.svg' },
    { name: 'CRM/USD', icon: 'icons/crm.svg' },
    { name: 'SQ/USD', icon: 'icons/sq.svg' },
    { name: 'TWTR/USD', icon: 'icons/twtr.svg' },

    // 🟧 FOREX NEXT
    { name: 'EUR/USD', icon: 'icons/eurusd.svg' },
    { name: 'GBP/USD', icon: 'icons/gbpusd.svg' },
    { name: 'USD/JPY', icon: 'icons/usdjpy.svg' },
    { name: 'USD/CHF', icon: 'icons/usdchf.svg' },
    { name: 'AUD/USD', icon: 'icons/audusd.svg' },
    { name: 'USD/CAD', icon: 'icons/usdcad.svg' },
    { name: 'NZD/USD', icon: 'icons/nzdusd.svg' },
    { name: 'EUR/GBP', icon: 'icons/eurgbp.svg' },
    { name: 'EUR/JPY', icon: 'icons/eurjpy.svg' },
    { name: 'GBP/JPY', icon: 'icons/gbpjpy.svg' },
    { name: 'USD/HKD', icon: 'icons/usdhkd.svg' },
    { name: 'USD/SGD', icon: 'icons/usdsgd.svg' },
    { name: 'USD/ZAR', icon: 'icons/usdzar.svg' },
    { name: 'USD/SEK', icon: 'icons/usdsek.svg' },
    { name: 'USD/MXN', icon: 'icons/usdmxn.svg' },
    { name: 'USD/NOK', icon: 'icons/usdnok.svg' },
    { name: 'USD/TRY', icon: 'icons/usdtry.svg' },
    { name: 'EUR/CHF', icon: 'icons/eurchf.svg' },
    { name: 'EUR/AUD', icon: 'icons/euraud.svg' },
    { name: 'AUD/JPY', icon: 'icons/audjpy.svg' },
  ];

  function populatePairSelect() {
    const select = document.getElementById('pair_select');
    select.innerHTML = '<option disabled selected>Select a trading pair</option>';
    tradingPairs.forEach(pair => {
      const option = document.createElement('option');
      option.value = pair.name;
      option.textContent = pair.name;
      select.appendChild(option);
    });
  }

  document.addEventListener('DOMContentLoaded', function () {
    populatePairSelect();

    const select = document.getElementById('pair_select');
    select.addEventListener('change', function () {
      const selectedPair = tradingPairs.find(p => p.name === this.value);
      if (selectedPair) {
        document.getElementById('trade_pair').value = selectedPair.name;
        document.getElementById('trade_display_pair').textContent = selectedPair.name;
        document.getElementById('trade_pair_icon').innerHTML = `<img src="${selectedPair.icon}" alt="${selectedPair.name}" class="w-6 h-6">`;
      }
    });
  });

  function selectTradeLot(element, value) {
    document.getElementById('trade_lot_size').value = value;
    document.querySelectorAll('.lot-option').forEach(opt => opt.classList.remove('selected', 'bg-purple-100', 'text-purple-700'));
    element.classList.add('selected', 'bg-purple-100', 'text-purple-700');
  }
</script>

    
    
    <script>
        function selectTradeLot(element, value) {
  document.querySelectorAll(".lot-option").forEach(el => el.classList.remove("selected"));
  element.classList.add("selected");
  document.getElementById("trade_lot_size").value = value;

  updateTradeEstimates(value);
}

async function updateTradeEstimates(lotSize) {
  const pipValue = (lotSize * 1).toFixed(2); // Example multiplier
  const marginRequired = (lotSize * 1000).toFixed(2); // Example calculation
  const estimatedCost = (parseFloat(marginRequired) + parseFloat(pipValue)).toFixed(2);

  document.getElementById("trade_margin_required").value = `$${marginRequired}`;
  document.getElementById("trade_pip_value").value = `$${pipValue}`;
  document.getElementById("trade_estimated_cost").value = `$${estimatedCost}`;

  // Optional: Real-time FX rate from CoinGecko
  try {
    const response = await fetch('https://api.coingecko.com/api/v3/simple/price?ids=usd&vs_currencies=eur');
    const data = await response.json();
    console.log("Live rate EUR/USD:", data.usd.eur);
  } catch (err) {
    console.warn("Could not fetch FX rate", err);
  }
}

    </script>
    
    

    <script>
    
       // Global variables
let currentMarket = 'forex';
let selectedPair = 'EUR/USD';
let priceChart = null;
let selectedLotSize = 0.01;
let currentTradeType = null;
let openPositions = new Map(); // Using Map for better position management
let accountBalance = 50000.00;
let accountEquity = 50000.00;
let accountMargin = 0.00;
let accountPnL = 2547.85;
let selectedTradeType = null;
let priceUpdateInterval = null;
let isChartInitialized = false;
let isAppInitialized = false;

// Market data simulation with more realistic spreads
const forexPairs = [
    { pair: 'EUR/USD', name: 'Euro / US Dollar', price: 1.0950, change: 0.0024, spread: 1.2, base: 'eur', quote: 'usd' },
    { pair: 'GBP/USD', name: 'British Pound / US Dollar', price: 1.2634, change: -0.0012, spread: 1.8, base: 'gbp', quote: 'usd' },
    { pair: 'USD/JPY', name: 'US Dollar / Japanese Yen', price: 149.85, change: 0.42, spread: 1.5, base: 'usd', quote: 'jpy' },
    { pair: 'AUD/USD', name: 'Australian Dollar / US Dollar', price: 0.6521, change: -0.0008, spread: 2.1, base: 'aud', quote: 'usd' },
    { pair: 'USD/CAD', name: 'US Dollar / Canadian Dollar', price: 1.3745, change: 0.0015, spread: 1.9, base: 'usd', quote: 'cad' },
    { pair: 'EUR/GBP', name: 'Euro / British Pound', price: 0.8675, change: 0.0009, spread: 2.3, base: 'eur', quote: 'gbp' },
    { pair: 'NZD/USD', name: 'New Zealand Dollar / US Dollar', price: 0.5892, change: -0.0018, spread: 2.8, base: 'nzd', quote: 'usd' },
    { pair: 'USD/CHF', name: 'US Dollar / Swiss Franc', price: 0.9145, change: 0.0007, spread: 1.7, base: 'usd', quote: 'chf' }
];

const stockData = [
    { symbol: 'AAPL', name: 'Apple Inc.', price: 185.25, change: 2.45, spread: 0.02, icon: 'aapl' },
    { symbol: 'GOOGL', name: 'Alphabet Inc.', price: 125.68, change: -1.23, spread: 0.05, icon: 'googl' },
    { symbol: 'MSFT', name: 'Microsoft Corp.', price: 378.92, change: 4.12, spread: 0.03, icon: 'msft' },
    { symbol: 'AMZN', name: 'Amazon.com Inc.', price: 142.87, change: -0.95, spread: 0.04, icon: 'amzn' },
    { symbol: 'TSLA', name: 'Tesla Inc.', price: 248.50, change: 8.73, spread: 0.08, icon: 'tsla' },
    { symbol: 'NVDA', name: 'NVIDIA Corp.', price: 875.30, change: 15.25, spread: 0.12, icon: 'nvda' }
];

let currentMarketData = forexPairs;

// Initialize the application
function initializeApp() {
    // Prevent multiple initializations
    if (isAppInitialized) {
        console.log('App already initialized, skipping...');
        return;
    }
    
    try {
        initializeChart();
        loadMarketData();
        startPriceUpdates();
        setupEventListeners();
        updateAccountDisplay();
        
        // Show profile modal after a delay
        setTimeout(() => {
            if (typeof openProfileModal === 'function') {
                openProfileModal();
            }
        }, 1000);
        
        isAppInitialized = true;
        console.log('Trading platform initialized successfully');
    } catch (error) {
        console.error('Failed to initialize trading platform:', error);
        showNotification('Initialization Error', 'Failed to initialize application', 'error');
    }
}

// Enhanced event listener setup with error handling
function setupEventListeners() {
    try {
        // Search functionality with debouncing
        const searchInput = document.getElementById('searchInput');
        if (searchInput) {
            let searchTimeout;
            searchInput.addEventListener('input', function(e) {
                clearTimeout(searchTimeout);
                searchTimeout = setTimeout(() => {
                    filterMarketData(e.target.value);
                }, 300);
            });
        }

        // Timeframe buttons
        document.querySelectorAll('.timeframe-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                document.querySelectorAll('.timeframe-btn').forEach(b => b.classList.remove('active'));
                this.classList.add('active');
                updateChart(this.getAttribute('data-tf'));
            });
        });

        // Lot size inputs with validation
        const customLotInput = document.getElementById('customLotSize');
        if (customLotInput) {
            customLotInput.addEventListener('input', function() {
                const value = parseFloat(this.value);
                if (isNaN(value) || value <= 0) {
                    this.value = 0.01;
                    selectedLotSize = 0.01;
                } else if (value > 100) {
                    this.value = 100;
                    selectedLotSize = 100;
                } else {
                    selectedLotSize = value;
                }
                updateTradeCalculations();
            });
        }

        const modalLotInput = document.getElementById('modalLotSize');
        if (modalLotInput) {
            modalLotInput.addEventListener('input', function() {
                updateModalCalculations();
            });
        }

        // Keyboard shortcuts
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeAllModals();
            }
        });

    } catch (error) {
        console.error('Error setting up event listeners:', error);
    }
}

// Enhanced market switching with validation
function switchMarket(market) {
    if (!['forex', 'stocks'].includes(market)) {
        console.error('Invalid market type:', market);
        return;
    }

    currentMarket = market;
    
    // Update tab styles safely
    const forexTab = document.getElementById('forexTab');
    const stocksTab = document.getElementById('stocksTab');
    
    if (forexTab && stocksTab) {
        [forexTab, stocksTab].forEach(tab => {
            tab.classList.remove('text-purple-600', 'border-purple-600');
            tab.classList.add('text-gray-600', 'border-transparent');
        });
        
        if (market === 'forex') {
            forexTab.classList.add('text-purple-600', 'border-purple-600');
            forexTab.classList.remove('text-gray-600', 'border-transparent');
            currentMarketData = forexPairs;
        } else {
            stocksTab.classList.add('text-purple-600', 'border-purple-600');
            stocksTab.classList.remove('text-gray-600', 'border-transparent');
            currentMarketData = stockData;
        }
    }
    
    loadMarketData();
    // Reset to first instrument in new market
    if (currentMarketData.length > 0) {
        selectInstrument(currentMarketData[0]);
    }
}

// Enhanced market data loading with error handling
function loadMarketData() {
    const container = document.getElementById('marketData');
    if (!container) {
        console.error('Market data container not found');
        return;
    }

    try {
        container.innerHTML = '';
        currentMarketData.forEach(item => {
            const row = createMarketRow(item);
            if (row) {
                container.appendChild(row);
            }
        });
    } catch (error) {
        console.error('Error loading market data:', error);
        container.innerHTML = '<div class="text-center py-4 text-red-500 text-sm">Error loading market data</div>';
    }
}

// Enhanced market row creation with better error handling
function createMarketRow(item) {
    if (!item) return null;

    try {
        const row = document.createElement('div');
        row.className = 'flex items-center justify-between p-3 hover:bg-gray-50 rounded-lg cursor-pointer transition-colors';
        row.onclick = () => selectInstrument(item);

        const isForex = currentMarket === 'forex';
        const changeClass = item.change > 0 ? 'price-up' : 'price-down';
        const changeIcon = item.change > 0 ? 'fa-arrow-up' : 'fa-arrow-down';
        const decimals = isForex ? 4 : 2;

        row.innerHTML = `
            <div class="flex items-center space-x-3 flex-1">
                ${isForex ? `
                    <div class="flex items-center">
                        <div class="currency-flag flag-${item.base || 'unknown'}"></div>
                        <div class="currency-flag flag-${item.quote || 'unknown'}"></div>
                    </div>
                ` : `
                    <div class="stock-icon icon-${item.icon || 'default'}">${(item.symbol || 'N/A').slice(0, 2)}</div>
                `}
                <div>
                    <div class="font-medium text-sm">${isForex ? (item.pair || 'N/A') : (item.symbol || 'N/A')}</div>
                    <div class="text-xs text-gray-500 truncate">${item.name || 'Unknown'}</div>
                </div>
            </div>
            <div class="text-right">
                <div class="font-mono text-sm font-semibold">${(item.price || 0).toFixed(decimals)}</div>
                <div class="flex items-center text-xs ${changeClass}">
                    <i class="fas ${changeIcon} mr-1"></i>
                    ${Math.abs(item.change || 0).toFixed(decimals)}
                </div>
            </div>
        `;

        return row;
    } catch (error) {
        console.error('Error creating market row:', error);
        return null;
    }
}

// Enhanced filtering with better performance
function filterMarketData(query) {
    if (!query) {
        loadMarketData();
        return;
    }

    try {
        const filtered = currentMarketData.filter(item => {
            const searchText = currentMarket === 'forex' 
                ? `${item.pair || ''} ${item.name || ''}` 
                : `${item.symbol || ''} ${item.name || ''}`;
            return searchText.toLowerCase().includes(query.toLowerCase());
        });

        const container = document.getElementById('marketData');
        if (!container) return;

        container.innerHTML = '';

        if (filtered.length === 0) {
            container.innerHTML = '<div class="text-center py-4 text-gray-500 text-sm">No instruments found</div>';
            return;
        }

        filtered.forEach(item => {
            const row = createMarketRow(item);
            if (row) {
                container.appendChild(row);
            }
        });
    } catch (error) {
        console.error('Error filtering market data:', error);
    }
}

// Enhanced instrument selection with validation
function selectInstrument(item) {
    if (!item) {
        console.error('No instrument provided');
        return;
    }

    try {
        const isForex = currentMarket === 'forex';
        const identifier = isForex ? item.pair : item.symbol;
        const decimals = isForex ? 4 : 2;

        selectedPair = identifier || 'N/A';

       // Update UI elements safely
const elements = {
  currentPair:    document.getElementById('currentPair'),    // <input>
  currentPairName:document.getElementById('currentPairName'),// <div> or <span>
  currentPrice:   document.getElementById('currentPrice'),   // <div> or <span>
  changeValue:    document.getElementById('changeValue'),    // <div> or <span>
  spreadValue:    document.getElementById('spreadValue')     // <div> or <span>
};

// identifier → the symbol string, item → { name, price, change, spread }, decimals → precision

if (elements.currentPair) {
  // for an <input> you must set .value, not .textContent
  elements.currentPair.value = identifier || '';
}

if (elements.currentPairName) {
  elements.currentPairName.textContent = item.name || 'Unknown';
}

if (elements.currentPrice) {
  elements.currentPrice.textContent = (item.price ?? 0).toFixed(decimals);
}

const changeNumeric = item.change ?? 0;
const changeClass   = changeNumeric > 0 ? 'price-up' : (changeNumeric < 0 ? 'price-down' : '');
const changeText    = (changeNumeric > 0 ? '+' : '') + changeNumeric.toFixed(decimals);

if (elements.changeValue) {
  elements.changeValue.textContent = changeText;
  // clear existing classes, then add only our up/down class
  elements.changeValue.classList.remove('price-up','price-down');
  if (changeClass) elements.changeValue.classList.add(changeClass);
}

if (elements.spreadValue) {
  elements.spreadValue.textContent = (item.spread ?? 0).toString();
}


        // Update currency flags for forex
        if (isForex && item.base && item.quote) {
            const baseFlag = document.getElementById('baseCurrencyFlag');
            const quoteFlag = document.getElementById('quoteCurrencyFlag');
            if (baseFlag) baseFlag.className = `currency-flag flag-${item.base}`;
            if (quoteFlag) quoteFlag.className = `currency-flag flag-${item.quote}`;
        }

        updateTradeCalculations();
        updateChart();
    } catch (error) {
        console.error('Error selecting instrument:', error);
        showNotification('Selection Error', 'Failed to select instrument', 'error');
    }
}

// Enhanced lot selection with validation
function selectLot(element, size) {
    if (!element || isNaN(size) || size <= 0) {
        console.error('Invalid lot selection parameters');
        return;
    }

    try {
        document.querySelectorAll('.compact-lot-option').forEach(opt => opt.classList.remove('selected'));
        element.classList.add('selected');
        selectedLotSize = Math.min(Math.max(size, 0.01), 100); // Clamp between 0.01 and 100
        
        const customInput = document.getElementById('customLotSize');
        if (customInput) customInput.value = selectedLotSize;
        
        updateTradeCalculations();
    } catch (error) {
        console.error('Error selecting lot size:', error);
    }
}

function selectModalLot(element, size) {
    if (!element || isNaN(size) || size <= 0) return;

    try {
        document.querySelectorAll('.lot-option').forEach(opt => opt.classList.remove('selected'));
        element.classList.add('selected');
        
        const modalInput = document.getElementById('modalLotSize');
        if (modalInput) modalInput.value = Math.min(Math.max(size, 0.01), 100);
        
        updateModalCalculations();
    } catch (error) {
        console.error('Error selecting modal lot size:', error);
    }
}

// Enhanced trade execution with better validation
function executeTrade(type) {
    if (!['BUY', 'SELL'].includes(type)) {
        console.error('Invalid trade type:', type);
        return;
    }

    const selectedInstrument = currentMarketData.find(item => 
        currentMarket === 'forex' ? item.pair === selectedPair : item.symbol === selectedPair
    );

    if (!selectedInstrument) {
        showNotification('Error', 'No instrument selected', 'error');
        return;
    }

    if (selectedLotSize <= 0) {
        showNotification('Error', 'Invalid lot size', 'error');
        return;
    }

    try {
        currentTradeType = type;
        const price = selectedInstrument.price || 0;
        const spread = (selectedInstrument.spread || 0) / (currentMarket === 'forex' ? 10000 : 100);
        
        let executionPrice;
        if (type === 'BUY') {
            executionPrice = price + spread;
        } else {
            executionPrice = Math.max(price - spread, 0.0001); // Prevent negative prices
        }

        simulateTradeExecution(type, executionPrice);
    } catch (error) {
        console.error('Error executing trade:', error);
        showNotification('Execution Error', 'Failed to execute trade', 'error');
    }
}

// Enhanced trade simulation with better position management
function simulateTradeExecution(type, price) {
    try {
        const marginRequired = calculateMargin(selectedLotSize, price);
        
        if (marginRequired > accountBalance - accountMargin) {
            showNotification('Insufficient Margin', 'Not enough free margin to execute this trade.', 'error');
            return;
        }

        const position = {
            id: Date.now() + Math.random(), // More unique ID
            symbol: selectedPair,
            type: type,
            lots: selectedLotSize,
            openPrice: price,
            currentPrice: price,
            pnl: 0,
            margin: marginRequired,
            timestamp: new Date()
        };

        openPositions.set(position.id, position);
        addOpenPosition(position);
        
        accountMargin += marginRequired;
        updateAccountDisplay();
        
        const decimals = currentMarket === 'forex' ? 4 : 2;
        showNotification('Trade Executed', 
            `${type} ${selectedLotSize} lots of ${selectedPair} at ${price.toFixed(decimals)}`, 
            'success');
    } catch (error) {
        console.error('Error simulating trade execution:', error);
        showNotification('Execution Error', 'Failed to simulate trade execution', 'error');
    }
}

// Enhanced position management
function addOpenPosition(position) {
    if (!position) return;

    try {
        const container = document.getElementById('openPositions');
        if (!container) return;
        
        if (openPositions.size === 1) { // First position
            container.innerHTML = '';
        }
        
        const positionElement = document.createElement('div');
        positionElement.className = 'flex items-center justify-between p-3 bg-gray-50 rounded-lg';
        positionElement.id = `position-${position.id}`;
        
        positionElement.innerHTML = `
            <div>
                <div class="font-medium text-sm">${position.symbol || 'N/A'}</div>
                <div class="text-xs text-gray-500">${position.type || 'N/A'} ${position.lots || 0}</div>
            </div>
            <div class="text-right">
                <div class="font-mono text-sm" id="pnl-${position.id}">$0.00</div>
                <button onclick="closePosition('${position.id}')" class="text-xs text-red-600 hover:text-red-800">Close</button>
            </div>
        `;
        
        container.appendChild(positionElement);
    } catch (error) {
        console.error('Error adding open position:', error);
    }
}

function closePosition(positionId) {
    try {
        const position = openPositions.get(positionId);
        if (!position) return;

        const positionElement = document.getElementById(`position-${positionId}`);
        if (positionElement) {
            positionElement.remove();
        }

        accountMargin = Math.max(0, accountMargin - position.margin);
        openPositions.delete(positionId);
        
        if (openPositions.size === 0) {
            const container = document.getElementById('openPositions');
            if (container) {
                container.innerHTML = '<div class="text-center py-4 text-gray-500 text-sm">No open positions</div>';
            }
        }
        
        updateAccountDisplay();
        showNotification('Position Closed', 'Position closed successfully', 'success');
    } catch (error) {
        console.error('Error closing position:', error);
        showNotification('Close Error', 'Failed to close position', 'error');
    }
}

// Enhanced modal functions
function openTradeModal(type) {
    if (!['BUY', 'SELL'].includes(type)) return;

    try {
        currentTradeType = type;
        const modal = document.getElementById('tradeModal');
        const title = document.getElementById('tradeModalTitle');
        const orderType = document.getElementById('modalOrderType');
        const button = document.getElementById('confirmTradeButton');

        if (modal) modal.classList.add('show');
        if (title) title.textContent = `${type} Order`;
        if (orderType) orderType.textContent = `${type} Market Order`;
        
        if (button) {
            button.className = type === 'BUY' 
                ? 'flex-1 px-4 py-2 buy-btn text-white rounded-lg font-semibold'
                : 'flex-1 px-4 py-2 sell-btn text-white rounded-lg font-semibold';
            button.textContent = `${type} ${selectedPair}`;
        }
        
        updateModalCalculations();
    } catch (error) {
        console.error('Error opening trade modal:', error);
    }
}

function closeTradeModal() {
    const modal = document.getElementById('tradeModal');
    if (modal) modal.classList.remove('show');
}

function closeAllModals() {
    const modals = ['tradeModal', 'profileModal'];
    modals.forEach(modalId => {
        const modal = document.getElementById(modalId);
        if (modal) modal.classList.remove('show');
    });
}

function confirmTrade() {
    try {
        const lotSizeInput = document.getElementById('modalLotSize');
        const lotSize = lotSizeInput ? parseFloat(lotSizeInput.value) : selectedLotSize;
        
        if (isNaN(lotSize) || lotSize <= 0) {
            showNotification('Invalid Input', 'Please enter a valid lot size', 'error');
            return;
        }

        selectedLotSize = Math.min(Math.max(lotSize, 0.01), 100);
        executeTrade(currentTradeType);
        closeTradeModal();
    } catch (error) {
        console.error('Error confirming trade:', error);
        showNotification('Confirmation Error', 'Failed to confirm trade', 'error');
    }
}

function openProfileModal() {
    const modal = document.getElementById('profileModal');
    if (modal) modal.classList.add('show');
}

function closeProfileModal() {
    const modal = document.getElementById('profileModal');
    if (modal) modal.classList.remove('show');
}

function selectTradeType(type) {
    selectedTradeType = type;
    document.querySelectorAll('.trading-card .border-2').forEach(card => {
        card.classList.remove('border-purple-500');
        card.classList.add('border-gray-200');
    });
}

function saveForexPreferences(event) {
    if (event) event.preventDefault();
    
    try {
        const formData = new FormData(event.target);
        const country = formData.get('country');
        
        if (!country || !selectedTradeType) {
            showNotification('Incomplete Form', 'Please fill in all required fields', 'error');
            return;
        }
        
        showNotification('Preferences Saved', 'Your trading preferences have been saved successfully', 'success');
        closeProfileModal();
    } catch (error) {
        console.error('Error saving preferences:', error);
        showNotification('Save Error', 'Failed to save preferences', 'error');
    }
}

// Enhanced calculation functions
function calculateMargin(lotSize, price) {
    if (isNaN(lotSize) || isNaN(price) || lotSize <= 0 || price <= 0) {
        return 0;
    }

    const leverage = 100;
    const contractSize = currentMarket === 'forex' ? 100000 : 1;
    return (lotSize * contractSize * price) / leverage;
}

function updateTradeCalculations() {
    try {
        const selectedInstrument = currentMarketData.find(item => 
            currentMarket === 'forex' ? item.pair === selectedPair : item.symbol === selectedPair
        );
        
        if (!selectedInstrument) return;
        
        const margin = calculateMargin(selectedLotSize, selectedInstrument.price);
        const pipValue = currentMarket === 'forex' ? selectedLotSize * 10 : selectedLotSize * 0.01;
        const spread = selectedInstrument.spread || 0;
        const spreadUnit = currentMarket === 'forex' ? 'pips' : 'cents';
        
        // Update UI elements safely
        const elements = {
            marginRequired: document.getElementById('marginRequired'),
            pipValue: document.getElementById('pipValue'),
            quickSpread: document.getElementById('quickSpread'),
            sellPrice: document.getElementById('sellPrice'),
            buyPrice: document.getElementById('buyPrice')
        };

        if (elements.marginRequired) elements.marginRequired.textContent = `$${margin.toFixed(2)}`;
        if (elements.pipValue) elements.pipValue.textContent = `$${pipValue.toFixed(2)}`;
        if (elements.quickSpread) elements.quickSpread.textContent = `${spread} ${spreadUnit}`;
        
        // Calculate bid/ask prices
        const spreadInPrice = currentMarket === 'forex' ? spread / 10000 : spread;
        const decimals = currentMarket === 'forex' ? 4 : 2;
        
        if (elements.sellPrice) {
            elements.sellPrice.textContent = Math.max(selectedInstrument.price - spreadInPrice, 0.0001).toFixed(decimals);
        }
        if (elements.buyPrice) {
            elements.buyPrice.textContent = (selectedInstrument.price + spreadInPrice).toFixed(decimals);
        }
    } catch (error) {
        console.error('Error updating trade calculations:', error);
    }
}

function updateModalCalculations() {
    try {
        const lotSizeInput = document.getElementById('modalLotSize');
        const lotSize = lotSizeInput ? parseFloat(lotSizeInput.value) || 0.01 : 0.01;
        
        const selectedInstrument = currentMarketData.find(item => 
            currentMarket === 'forex' ? item.pair === selectedPair : item.symbol === selectedPair
        );
        
        if (!selectedInstrument) return;
        
        const margin = calculateMargin(lotSize, selectedInstrument.price);
        const pipValue = currentMarket === 'forex' ? lotSize * 10 : lotSize * 0.01;
        const spread = selectedInstrument.spread || 0;
        const spreadUnit = currentMarket === 'forex' ? 'pips' : 'cents';
        const decimals = currentMarket === 'forex' ? 4 : 2;
        
        // Update modal elements safely
        const elements = {
            modalMarginRequired: document.getElementById('modalMarginRequired'),
            modalPipValue: document.getElementById('modalPipValue'),
            modalSpread: document.getElementById('modalSpread'),
            modalEstimatedCost: document.getElementById('modalEstimatedCost'),
            modalPrice: document.getElementById('modalPrice')
        };

        if (elements.modalMarginRequired) elements.modalMarginRequired.textContent = `$${margin.toFixed(2)}`;
        if (elements.modalPipValue) elements.modalPipValue.textContent = `$${pipValue.toFixed(2)}`;
        if (elements.modalSpread) elements.modalSpread.textContent = `${spread} ${spreadUnit}`;
        if (elements.modalEstimatedCost) elements.modalEstimatedCost.textContent = `$${margin.toFixed(2)}`;
        if (elements.modalPrice) elements.modalPrice.textContent = selectedInstrument.price.toFixed(decimals);
    } catch (error) {
        console.error('Error updating modal calculations:', error);
    }
}

function updateAccountDisplay() {
    try {
        const freeMargin = Math.max(0, accountBalance - accountMargin);
        const marginLevel = accountMargin > 0 ? (accountEquity / accountMargin) * 100 : Infinity;
        
        // Update account stats safely
        const elements = {
            userBalance: document.getElementById('userBalance'),
            userEquity: document.getElementById('userEquity'),
            userMargin: document.getElementById('userMargin'),
            userPnL: document.getElementById('userPnL'),
            mobileBalance: document.getElementById('mobileBalance'),
            mobilePnL: document.getElementById('mobilePnL'),
            freeMargin: document.getElementById('freeMargin'),
            marginLevel: document.getElementById('marginLevel')
        };

        if (elements.userBalance) elements.userBalance.textContent = accountBalance.toFixed(2);
        if (elements.userEquity) elements.userEquity.textContent = accountEquity.toFixed(2);
        if (elements.userMargin) elements.userMargin.textContent = accountMargin.toFixed(2);
        if (elements.userPnL) elements.userPnL.textContent = (accountPnL >= 0 ? '+' : '') + accountPnL.toFixed(2);
        if (elements.mobileBalance) elements.mobileBalance.textContent = accountBalance.toFixed(2);
        if (elements.mobilePnL) elements.mobilePnL.textContent = (accountPnL >= 0 ? '+' : '') + accountPnL.toFixed(2);
        if (elements.freeMargin) elements.freeMargin.textContent = `$${freeMargin.toFixed(2)}`;
        if (elements.marginLevel) {
            elements.marginLevel.textContent = marginLevel === Infinity ? '∞%' : `${marginLevel.toFixed(1)}%`;
        }
    } catch (error) {
        console.error('Error updating account display:', error);
    }
}

// Enhanced chart functions with better error handling
function initializeChart() {
    try {
        const canvas = document.getElementById('priceChart');
        if (!canvas) {
            console.warn('Price chart canvas not found');
            return;
        }

        // Check if Chart.js is available
        if (typeof Chart === 'undefined') {
            console.warn('Chart.js not loaded, skipping chart initialization');
            return;
        }

       

        // Check if Chart.js is available
        if (typeof Chart === 'undefined') {
            console.warn('Chart.js not loaded, skipping chart initialization');
            return;
        }

        // Destroy existing chart if it exists
        if (priceChart) {
            priceChart.destroy();
            priceChart = null;
        }

        const ctx = canvas.getContext('2d');
        
        // Generate initial chart data
        const chartData = generateChartData();
        
        priceChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: chartData.labels,
                datasets: [{
                    label: selectedPair,
                    data: chartData.prices,
                    borderColor: '#8B5CF6',
                    backgroundColor: 'rgba(139, 92, 246, 0.1)',
                    borderWidth: 2,
                    fill: true,
                    tension: 0.4,
                    pointRadius: 0,
                    pointHoverRadius: 6
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                interaction: {
                    intersect: false,
                    mode: 'index'
                },
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        backgroundColor: 'rgba(17, 24, 39, 0.9)',
                        titleColor: '#F9FAFB',
                        bodyColor: '#F9FAFB',
                        borderColor: '#8B5CF6',
                        borderWidth: 1,
                        cornerRadius: 8,
                        displayColors: false,
                        callbacks: {
                            title: function(context) {
                                return `Time: ${context[0].label}`;
                            },
                            label: function(context) {
                                const decimals = currentMarket === 'forex' ? 4 : 2;
                                return `Price: ${context.parsed.y.toFixed(decimals)}`;
                            }
                        }
                    }
                },
                scales: {
                    x: {
                        display: false,
                        grid: {
                            display: false
                        }
                    },
                    y: {
                        display: true,
                        position: 'right',
                        grid: {
                            color: 'rgba(229, 231, 235, 0.5)',
                            drawBorder: false
                        },
                        ticks: {
                            color: '#9CA3AF',
                            font: {
                                size: 11
                            },
                            callback: function(value) {
                                const decimals = currentMarket === 'forex' ? 4 : 2;
                                return value.toFixed(decimals);
                            }
                        }
                    }
                },
                animation: {
                    duration: 750,
                    easing: 'easeOutCubic'
                }
            }
        });

        isChartInitialized = true;
        console.log('Chart initialized successfully');
    } catch (error) {
        console.error('Error initializing chart:', error);
        isChartInitialized = false;
    }
}

function generateChartData(timeframe = '1H') {
    try {
        const selectedInstrument = currentMarketData.find(item => 
            currentMarket === 'forex' ? item.pair === selectedPair : item.symbol === selectedPair
        );
        
        if (!selectedInstrument) {
            return { labels: [], prices: [] };
        }

        const basePrice = selectedInstrument.price;
        const labels = [];
        const prices = [];
        const points = 50;
        
        // Generate realistic price movement
        let currentPrice = basePrice * 0.995; // Start slightly below current price
        const volatility = currentMarket === 'forex' ? 0.002 : 0.015;
        const trend = Math.random() * 0.0005 - 0.00025; // Small trend bias
        
        for (let i = 0; i < points; i++) {
            // Generate time labels
            const time = new Date();
            time.setMinutes(time.getMinutes() - (points - i) * getTimeframeMinutes(timeframe));
            labels.push(time.toLocaleTimeString('en-US', { 
                hour: '2-digit', 
                minute: '2-digit',
                hour12: false 
            }));
            
            // Generate realistic price movement
            const randomWalk = (Math.random() - 0.5) * volatility;
            const meanReversion = (basePrice - currentPrice) * 0.01;
            currentPrice += randomWalk + trend + meanReversion;
            
            // Ensure price doesn't go negative or too far from base
            currentPrice = Math.max(currentPrice, basePrice * 0.9);
            currentPrice = Math.min(currentPrice, basePrice * 1.1);
            
            prices.push(currentPrice);
        }
        
        // Ensure last price is close to current market price
        prices[prices.length - 1] = basePrice;
        
        return { labels, prices };
    } catch (error) {
        console.error('Error generating chart data:', error);
        return { labels: [], prices: [] };
    }
}

function getTimeframeMinutes(timeframe) {
    const timeframes = {
        '1M': 1,
        '5M': 5,
        '15M': 15,
        '30M': 30,
        '1H': 60,
        '4H': 240,
        '1D': 1440
    };
    return timeframes[timeframe] || 60;
}

function updateChart(timeframe = '1H') {
    if (!priceChart || !isChartInitialized) {
        console.warn('Chart not initialized, cannot update');
        return;
    }

    try {
        const chartData = generateChartData(timeframe);
        
        priceChart.data.labels = chartData.labels;
        priceChart.data.datasets[0].data = chartData.prices;
        priceChart.data.datasets[0].label = selectedPair;
        
        priceChart.update('none'); // Update without animation for better performance
    } catch (error) {
        console.error('Error updating chart:', error);
    }
}

// Enhanced price updates with better performance
function startPriceUpdates() {
    if (priceUpdateInterval) {
        clearInterval(priceUpdateInterval);
    }

    priceUpdateInterval = setInterval(() => {
        try {
            updateMarketPrices();
            updatePositionPnL();
        } catch (error) {
            console.error('Error in price update cycle:', error);
        }
    }, 2000); // Update every 2 seconds
}

function updateMarketPrices() {
    try {
        currentMarketData.forEach(item => {
            const volatility = currentMarket === 'forex' ? 0.0005 : 0.01;
            const change = (Math.random() - 0.5) * volatility;
            
            // Update price with some momentum
            item.price = Math.max(item.price + change, 0.0001);
            item.change += change;
            
            // Apply mean reversion to prevent prices from drifting too far
            if (Math.abs(item.change) > (currentMarket === 'forex' ? 0.005 : 0.05)) {
                item.change *= 0.9;
            }
        });

        // Update UI if current instrument is selected
        const selectedInstrument = currentMarketData.find(item => 
            currentMarket === 'forex' ? item.pair === selectedPair : item.symbol === selectedPair
        );
        
        if (selectedInstrument) {
            selectInstrument(selectedInstrument);
        }

        // Update market data display with throttling
        if (Math.random() < 0.3) { // Only update 30% of the time to improve performance
            loadMarketData();
        }
    } catch (error) {
        console.error('Error updating market prices:', error);
    }
}

function updatePositionPnL() {
    if (openPositions.size === 0) return;

    try {
        let totalPnL = 0;

        openPositions.forEach((position, id) => {
            const selectedInstrument = currentMarketData.find(item => 
                currentMarket === 'forex' ? item.pair === position.symbol : item.symbol === position.symbol
            );
            
            if (!selectedInstrument) return;

            position.currentPrice = selectedInstrument.price;
            
            // Calculate P&L
            const contractSize = currentMarket === 'forex' ? 100000 : 1;
            const pipSize = currentMarket === 'forex' ? 0.0001 : 0.01;
            
            let priceDiff;
            if (position.type === 'BUY') {
                priceDiff = position.currentPrice - position.openPrice;
            } else {
                priceDiff = position.openPrice - position.currentPrice;
            }
            
            position.pnl = (priceDiff / pipSize) * (position.lots * 10);
            totalPnL += position.pnl;
            
            // Update position display
            const pnlElement = document.getElementById(`pnl-${id}`);
            if (pnlElement) {
                pnlElement.textContent = `$${position.pnl.toFixed(2)}`;
                pnlElement.className = position.pnl >= 0 ? 'font-mono text-sm price-up' : 'font-mono text-sm price-down';
            }
        });

        // Update account P&L
        accountPnL = 2547.85 + totalPnL; // Base P&L + current positions P&L
        accountEquity = accountBalance + accountPnL;
        
        updateAccountDisplay();
    } catch (error) {
        console.error('Error updating position P&L:', error);
    }
}

// Enhanced notification system
function showNotification(title, message, type = 'info') {
    try {
        // Remove existing notifications
        const existingNotifications = document.querySelectorAll('.notification');
        existingNotifications.forEach(notif => notif.remove());

        const notification = document.createElement('div');
        notification.className = `notification fixed top-4 right-4 max-w-sm bg-white rounded-lg shadow-lg border-l-4 p-4 z-50 transform transition-all duration-300 translate-x-full`;
        
        // Add type-specific styling
        const typeStyles = {
            success: 'border-green-500',
            error: 'border-red-500',
            warning: 'border-yellow-500',
            info: 'border-blue-500'
        };
        
        const typeIcons = {
            success: 'fa-check-circle text-green-500',
            error: 'fa-exclamation-circle text-red-500',
            warning: 'fa-exclamation-triangle text-yellow-500',
            info: 'fa-info-circle text-blue-500'
        };

        notification.classList.add(typeStyles[type] || typeStyles.info);
        
        notification.innerHTML = `
            <div class="flex items-start">
                <div class="flex-shrink-0">
                    <i class="fas ${typeIcons[type] || typeIcons.info} text-lg"></i>
                </div>
                <div class="ml-3 flex-1">
                    <div class="text-sm font-medium text-gray-900">${title || 'Notification'}</div>
                    <div class="text-sm text-gray-600 mt-1">${message || ''}</div>
                </div>
                <button onclick="this.parentElement.parentElement.remove()" class="ml-3 flex-shrink-0">
                    <i class="fas fa-times text-gray-400 hover:text-gray-600 cursor-pointer"></i>
                </button>
            </div>
        `;

        document.body.appendChild(notification);
        
        // Animate in
        setTimeout(() => {
            notification.classList.remove('translate-x-full');
        }, 100);
        
        // Auto remove after 5 seconds
        setTimeout(() => {
            if (notification.parentElement) {
                notification.classList.add('translate-x-full');
                setTimeout(() => {
                    if (notification.parentElement) {
                        notification.remove();
                    }
                }, 300);
            }
        }, 5000);
        
    } catch (error) {
        console.error('Error showing notification:', error);
        // Fallback to alert
        alert(`${title}: ${message}`);
    }
}

// Cleanup function
function cleanup() {
    try {
        if (priceUpdateInterval) {
            clearInterval(priceUpdateInterval);
            priceUpdateInterval = null;
        }
        
        if (priceChart) {
            priceChart.destroy();
            priceChart = null;
        }
        
        openPositions.clear();
        isAppInitialized = false;
        isChartInitialized = false;
        
        console.log('Application cleanup completed');
    } catch (error) {
        console.error('Error during cleanup:', error);
    }
}

// Enhanced window event handlers
window.addEventListener('beforeunload', cleanup);
window.addEventListener('unload', cleanup);

// Enhanced error handling for uncaught errors
window.addEventListener('error', function(event) {
    console.error('Uncaught error:', event.error);
    showNotification('Application Error', 'An unexpected error occurred. Please refresh the page.', 'error');
});

window.addEventListener('unhandledrejection', function(event) {
    console.error('Unhandled promise rejection:', event.reason);
    showNotification('System Error', 'A system error occurred. Please try again.', 'error');
});

// Initialize when DOM is ready
document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM loaded, initializing trading platform...');
    
    // Add a small delay to ensure all resources are loaded
    setTimeout(() => {
        try {
            initializeApp();
        } catch (error) {
            console.error('Failed to initialize app on DOM ready:', error);
            showNotification('Initialization Failed', 'Failed to load trading platform. Please refresh the page.', 'error');
        }
    }, 500);
});

// Expose key functions to global scope for HTML onclick handlers
window.switchMarket = switchMarket;
window.selectInstrument = selectInstrument;
window.selectLot = selectLot;
window.selectModalLot = selectModalLot;
window.executeTrade = executeTrade;
window.openTradeModal = openTradeModal;
window.closeTradeModal = closeTradeModal;
window.confirmTrade = confirmTrade;
window.closePosition = closePosition;
window.openProfileModal = openProfileModal;
window.closeProfileModal = closeProfileModal;
window.selectTradeType = selectTradeType;
window.saveForexPreferences = saveForexPreferences;
window.showNotification = showNotification;

console.log('Trading platform JavaScript loaded successfully');
    </script>
</body>
</html>