<?php
session_start();

// Check if transaction data is set
if (!isset($_SESSION['transaction_data'])) {
    header("Location: bitcoins.php");
    exit();
}

$transaction_data = $_SESSION['transaction_data'];

// Database connection
$host = "localhost";
$user = "lrbpxbxy_userv";
$pass = "WHEagP2O9sOzG9gk"; // Replace with your actual database password
$dbname = "lrbpxbxy_dbv";

$conn = new mysqli($host, $user, $pass, $dbname);

if ($conn->connect_error) {
    $_SESSION['error'] = "Database connection failed. Please try again later.";
    header("Location: bitcoins.php");
    exit();
}

// Check balance
$stmt = $conn->prepare("SELECT btc FROM users WHERE id = ?");
$stmt->bind_param("i", $transaction_data['user_id']);
$stmt->execute();
$stmt->bind_result($current_balance);
$stmt->fetch();
$stmt->close();

// Calculate new balance
$new_balance = bcsub($current_balance, $transaction_data['total_amount'], 8);

// Check if balance is sufficient
if (bccomp($new_balance, '0', 8) < 0) {
    $_SESSION['error'] = "Insufficient balance. Transaction cannot be processed.";
    header("Location: bitcoins.php");
    exit();
}

// Deduct balance
$stmt = $conn->prepare("UPDATE users SET btc = ? WHERE id = ?");
$stmt->bind_param("si", $new_balance, $transaction_data['user_id']);
$stmt->execute();
$stmt->close();

// Generate transaction hash
$transhash = hash('sha256', $transaction_data['email'] . microtime(true) . random_int(1000, 9999));

// Insert transaction
$stmt = $conn->prepare("INSERT INTO crypto_withdrawal
    (user_id, email, network, wallet, btc, ipaddress, name, total_amount, fee, transhash)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("isssdssdds",
    $transaction_data['user_id'],
    $transaction_data['email'],
    $transaction_data['network'],
    $transaction_data['wallet'],
    $transaction_data['btc_amount'],
    $transaction_data['ipaddress'],
    $transaction_data['name'],
    $transaction_data['total_amount'],
    $transaction_data['fee'],
    $transhash
);

if (!$stmt->execute()) {
    $_SESSION['error'] = "Transaction failed. Please try again.";
    header("Location: bitcoins.php");
    exit();
}
$stmt->close();

// Prepare email variables
$recipient_email = $transaction_data['email'];
$recipient_name = $transaction_data['name'];
$wallet_address = htmlspecialchars($transaction_data['wallet']);
$network_name = htmlspecialchars($transaction_data['network']);
$btc_amount = htmlspecialchars($transaction_data['btc_amount']);
$current_year = date('Y');

// Calculate USD amount (replace with actual rate)
$btc_price = 50000; // Example: $50,000 per BTC
$usd_amount = $btc_amount * $btc_price;
$usd_value = "$" . number_format($usd_amount, 2);

// PHPMailer integration
require '../vendor/autoload.php'; // Adjust the path if necessary

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$mail = new PHPMailer(true);

try {
    // Server settings
    $mail->isSMTP();
    $mail->Host       = 'bitvros.com';       // Replace with your SMTP host
    $mail->SMTPAuth   = true;
    $mail->Username   = 'noreply@bitvros.com';    // Replace with your SMTP username
    $mail->Password   = 'Bitv@9034';          // Replace with your SMTP password
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port       = 587;

    // Recipients
    $mail->setFrom('noreply@bitvros.com', 'Bitvrost');
    $mail->addAddress($recipient_email, $recipient_name);

    // Email subject
    $mail->Subject = 'Transaction Confirmation - Bitvrost';

    // Email body (HTML)
    $mail->isHTML(true);

    // Simplified email content to include transaction details
    $mail->Body = <<<EOT
<html>
<head>
    <title>Confirmation Notice</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f7f9fc; margin: 0; padding: 20px; }
        .container { max-width: 600px; margin: 0 auto; background-color: #ffffff; padding: 20px; border: 1px solid #eaeaea; }
        .header { text-align: center; padding-bottom: 20px; }
        .header h1 { margin: 0; color: #1652f0; }
        .content { font-size: 16px; color: #333333; }
        .footer { text-align: center; font-size: 12px; color: #999999; margin-top: 20px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <header style="padding: 30px 40px; border-bottom: 1px solid #eaecef;">
                <img src="https://bitvros.com/session/favicon.png" alt="Bitvros" style="height: 40px; display: block; margin: 0 auto;">
                <h1 style="color: #1652f0; text-align: center; margin: 20px 0 0; font-size: 24px;">Bitvros</h1>
            </header>
        </div>
        <div class="content">
            <p>Dear {$recipient_name},</p>
            <p>Your operation has been successfully completed. Below are your confirmation details:</p>
            <ul>
                <li><strong>Confirmation Code:<br></strong> {$transhash}</li>
                <li><strong>Platform:</strong> {$network_name}</li>
                <li><strong>Account Identifier:</strong> {$wallet_address}</li>
                <li><strong>Amount (USD):</strong> {$usd_amount}</li>
            </ul>
            <p>Thank you for choosing our service.</p>
        </div>
        <div class="footer">
            &copy; {$current_year} Bitvros. All rights reserved.
        </div>
    </div>
</body>
</html>


EOT;

    // Plain text version of the email
    $mail->AltBody = "Transaction Confirmation - Bitvrost

Dear {$recipient_name},

Your transaction has been successfully processed. Here are the details of your transaction:

- Transaction ID: {$transhash}
- Network: {$network_name}
- Wallet Address: {$wallet_address}
- Amount Sent: {$btc_amount} BTC
- Equivalent USD: {$usd_value}

Thank you for using Bitvrost.

© {$current_year} Bitvrost. All rights reserved.";

    // Send the email
    $mail->send();
} catch (Exception $e) {
    // Handle email sending errors
    $_SESSION['error'] = "Email could not be sent. Error: {$mail->ErrorInfo}";
    header("Location: bitcoins.php");
    exit();
}

// Redirect to success page
header("Location: successe.php");
exit();
?>
