<?php 
require_once '../session.php';
include '../db.php'; // Optional: include if you need a DB connection in this header
$currentPage = basename($_SERVER['PHP_SELF']); 
?>

<style>
/* Modern Navigation Variables */
:root {
  --nav-bg-light: #ffffff;
  --nav-bg-dark: #1c1c1e;
  --nav-shadow: 0 -2px 30px rgba(0, 0, 0, 0.1);
  --nav-border: rgba(0, 0, 0, 0.06);
  --primary-blue: #007AFF;
  --primary-purple: #5856D6;
  --text-primary: #1d1d1f;
  --text-secondary: #8e8e93;
  --text-light: #ffffff;
  --active-bg: rgba(88, 86, 214, 0.15);
  --hover-bg: rgba(0, 0, 0, 0.05);
  --transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
  --nav-height: 90px;
  --nav-padding: 20px;
  --border-radius: 30px;
}

/* Navigation Container */
.nav-container {
  position: relative;
  height: var(--nav-height);
  z-index: 1000;
}

/* Base Navigation Styles */
.modern-nav {
  position: fixed;
  bottom: var(--nav-padding);
  left: var(--nav-padding);
  right: var(--nav-padding);
  height: 70px;
  background: var(--nav-bg-light);
  backdrop-filter: blur(20px);
  -webkit-backdrop-filter: blur(20px);
  border: 1px solid var(--nav-border);
  box-shadow: var(--nav-shadow);
  display: flex;
  justify-content: space-around;
  align-items: center;
  padding: 0 24px;
  border-radius: var(--border-radius);
  transition: var(--transition);
}

/* Navigation Item Base */
.nav-item {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  min-width: 50px;
  height: 50px;
  border-radius: 16px;
  color: var(--text-secondary);
  transition: var(--transition);
  cursor: pointer;
  position: relative;
  padding: 8px;
}

.nav-item i {
  font-size: 20px;
  margin-bottom: 2px;
  transition: var(--transition);
}

.nav-item span {
  font-size: 10px;
  font-weight: 500;
  letter-spacing: 0.5px;
  transition: var(--transition);
}

/* Active States */
.nav-item.active {
  color: var(--primary-purple);
  background: var(--active-bg);
}

.nav-item:hover:not(.active) {
  background: var(--hover-bg);
  transform: translateY(-2px);
}

/* Default Style: Floating Pill with Elevated Home */
.home-button {
  width: 60px !important;
  height: 60px !important;
  background: linear-gradient(135deg, var(--primary-purple), #7B68EE) !important;
  color: var(--text-light) !important;
  border-radius: 20px !important;
  position: relative;
  top: -10px;
  box-shadow: 0 8px 25px rgba(88, 86, 214, 0.3) !important;
}

.home-button i {
  font-size: 24px !important;
  margin-bottom: 0 !important;
}

/* Animation Classes */
.bounce-in {
  animation: bounceIn 0.6s cubic-bezier(0.68, -0.55, 0.265, 1.55);
}

@keyframes bounceIn {
  0% { transform: scale(0.3) translateY(20px); opacity: 0; }
  50% { transform: scale(1.05) translateY(-5px); }
  70% { transform: scale(0.9) translateY(0); }
  100% { transform: scale(1) translateY(0); opacity: 1; }
}

.slide-up {
  animation: slideUp 0.4s ease-out;
}

@keyframes slideUp {
  from { transform: translateY(100px); opacity: 0; }
  to { transform: translateY(0); opacity: 1; }
}

/* Ripple Effect */
.ripple {
  position: absolute;
  border-radius: 50%;
  background: rgba(255, 255, 255, 0.4);
  transform: scale(0);
  animation: ripple 0.6s linear;
  pointer-events: none;
}

@keyframes ripple {
  to {
    transform: scale(4);
    opacity: 0;
  }
}

/* Modal Styles */
.modal-overlay {
  display: none;
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: rgba(0, 0, 0, 0.5);
  backdrop-filter: blur(8px);
  z-index: 1100;
  justify-content: center;
  align-items: center;
  opacity: 0;
  transition: opacity 0.3s ease;
}

.modal-overlay.show {
  opacity: 1;
}

.modal-content {
  background: var(--nav-bg-light);
  border-radius: 24px;
  padding: 28px;
  width: 90%;
  max-width: 420px;
  position: relative;
  transform: translateY(30px) scale(0.9);
  transition: all 0.3s cubic-bezier(0.34, 1.56, 0.64, 1);
  box-shadow: 0 25px 70px rgba(0, 0, 0, 0.2);
}

.modal-overlay.show .modal-content {
  transform: translateY(0) scale(1);
}

.close-modal {
  position: absolute;
  top: 20px;
  right: 24px;
  font-size: 24px;
  background: #f2f2f7;
  border: none;
  cursor: pointer;
  color: var(--text-secondary);
  width: 36px;
  height: 36px;
  display: flex;
  align-items: center;
  justify-content: center;
  border-radius: 50%;
  transition: var(--transition);
}

.close-modal:hover {
  background: #e5e5ea;
  transform: scale(1.1);
}

/* Responsive */
@media (max-width: 375px) {
  .modern-nav {
    left: 16px;
    right: 16px;
    bottom: 16px;
    padding: 0 16px;
  }
}
</style>

<!-- Font Awesome Icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<!-- Bottom Navigation -->
<div class="nav-container">
  <nav class="modern-nav" id="navigationBar">
    <div class="nav-item" data-page="explore">
      <i class="fas fa-compass"></i>
      <span>Explore</span>
    </div>

    <div class="nav-item" data-page="history">
      <i class="fas fa-clock-rotate-left"></i>
      <span>History</span>
    </div>
    
    <!-- Home Button -->
    <div class="nav-item home-button" data-page="dashboard">
      <i class="fas fa-home"></i>
      <span style="display: none;">Home</span>
    </div>
    
    <!-- Profile Modal Trigger -->
    <div class="nav-item" id="openModal">
      <i class="fas fa-user"></i>
      <span>Profile</span>
    </div>
    
    <div class="nav-item" data-page="settings">
      <i class="fas fa-cog"></i>
      <span>Settings</span>
    </div>
  </nav>
</div>

<!-- Modal Structure -->
<div class="modal-overlay" id="userModal">
  <div class="modal-content">
    <button class="close-modal" id="closeModal">&times;</button>
    
    <!-- User Profile Section -->
    <div style="display: flex; align-items: center; margin-bottom: 24px; padding-bottom: 20px; border-bottom: 1px solid #f2f2f7;">
      <img 
        src="<?= htmlspecialchars($picture) ?>" 
        alt="User Avatar" 
        style="width: 52px; height: 52px; border-radius: 50%; margin-right: 16px; border: 3px solid #f2f2f7;"
      >
      <div style="flex: 1;">
        <span style="color: var(--text-secondary); font-size: 13px; font-weight: 500;">Hello</span>
        <h4 style="font-size: 22px; font-weight: 600; margin: 2px 0 8px 0; color: var(--text-primary);">
          <?php echo htmlspecialchars($name); ?>
        </h4>
        
        <a href="mailto:<?php echo htmlspecialchars($email); ?>" 
           style="color: var(--primary-purple); font-size: 14px; text-decoration: none; display: flex; align-items: center;">
          <i class="fas fa-envelope" style="margin-right: 8px; font-size: 12px;"></i>
          <?php echo htmlspecialchars($email); ?>
        </a>
      </div>
    </div>

    <!-- Status Section -->
    <div style="margin-bottom: 24px;">
      <?php
      require('db.php');
      
      $user_email = getSessionEmail();
      if (!$user_email) {
          echo '<div style="background: linear-gradient(135deg, #fff3cd, #ffeaa7); color: #856404; padding: 16px; border-radius: 12px; font-size: 14px; display: flex; align-items: center;">
                  <i class="fas fa-exclamation-triangle" style="margin-right: 12px; font-size: 16px;"></i>
                  <div>
                    <strong>Not Logged In</strong><br>
                    <span style="opacity: 0.8;">Please log in to access your dashboard.</span>
                  </div>
                </div>';
          exit;
      }

      $query = "SELECT * FROM kyc_submissions WHERE email = :email";
      $stmt = $conn->prepare($query);
      $stmt->bindParam(':email', $user_email, PDO::PARAM_STR);
      $stmt->execute();
      $user = $stmt->fetch(PDO::FETCH_ASSOC);

      if ($user) {
          if ($user['status'] == 'verified') {
              $statusMessage = '<div style="background: linear-gradient(135deg, #d4edda, #a3d9a4); color: #155724; padding: 16px; border-radius: 12px; font-size: 14px; display: flex; align-items: center;">
                                  <i class="fas fa-check-circle" style="margin-right: 12px; font-size: 18px;"></i>
                                  <div>
                                    <p style="margin: 0; font-weight: 600;">Account Verified</p>
                                    <p style="margin: 0; opacity: 0.8;">Your account status is high</p>
                                  </div>
                                </div>';
          } else {
              $statusMessage = '<div style="background: linear-gradient(135deg, #f8d7da, #f1aeb5); color: #721c24; padding: 16px; border-radius: 12px; font-size: 14px; display: flex; align-items: center;">
                                  <i class="fas fa-exclamation-circle" style="margin-right: 12px; font-size: 18px;"></i>
                                  <div>
                                    <p style="margin: 0; font-weight: 600;">Account Unverified</p>
                                    <p style="margin: 0; opacity: 0.8;">Please complete verification</p>
                                  </div>
                                </div>';
          }
          echo $statusMessage;
      } else {
          echo '<div style="background: linear-gradient(135deg, #fff3cd, #ffeaa7); color: #856404; padding: 16px; border-radius: 12px; font-size: 14px; display: flex; align-items: center;">
                  <i class="fas fa-clock" style="margin-right: 12px; font-size: 16px;"></i>
                  <div>
                    <strong>Verification Pending</strong><br>
                    <span style="opacity: 0.8;">Please proceed with your KYC</span>
                  </div>
                </div>';
      }
      ?>
    </div>
    
    <!-- Profile Information -->
    <div style="background: #f8f9fa; border-radius: 16px; padding: 20px; margin-bottom: 24px;">
      <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px;">
        <span style="font-weight: 600; color: var(--text-primary); display: flex; align-items: center;">
          <i class="fas fa-globe" style="margin-right: 8px; color: var(--primary-purple);"></i>
          Country
        </span>
<span style="color: var(--text-secondary); font-weight: 500;">
  <?php echo isset($country) ? htmlspecialchars($country) : ''; ?>
</span>
      </div>
      
      <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px;">
        <span style="font-weight: 600; color: var(--text-primary); display: flex; align-items: center;">
          <i class="fas fa-chart-line" style="margin-right: 8px; color: var(--primary-purple);"></i>
          Total Logs
        </span>
        <span id="totalLogs" style="color: var(--text-secondary); font-weight: 500;">Loading...</span>
      </div>
      
      <div style="display: flex; justify-content: space-between; align-items: center;">
        <span style="font-weight: 600; color: var(--text-primary); display: flex; align-items: center;">
          <i class="fas fa-clock" style="margin-right: 8px; color: var(--primary-purple);"></i>
          Last Login
        </span>
        <span id="lastLogin" style="color: var(--text-secondary); font-weight: 500;">Loading...</span>
      </div>
    </div>
    
    <!-- Social Icons -->
    <div style="display: flex; gap: 16px; justify-content: center;">
      <a href="https://www.facebook.com/<?php echo urlencode($name); ?>" 
         style="color: #1877f2; font-size: 18px; width: 48px; height: 48px; display: flex; align-items: center; justify-content: center; border-radius: 50%; background: linear-gradient(135deg, rgba(24, 119, 242, 0.1), rgba(24, 119, 242, 0.05)); transition: var(--transition); text-decoration: none;">
        <i class="fab fa-facebook-f"></i>
      </a>
      <a href="https://twitter.com/<?php echo urlencode($name); ?>" 
         style="color: #1da1f2; font-size: 18px; width: 48px; height: 48px; display: flex; align-items: center; justify-content: center; border-radius: 50%; background: linear-gradient(135deg, rgba(29, 161, 242, 0.1), rgba(29, 161, 242, 0.05)); transition: var(--transition); text-decoration: none;">
        <i class="fab fa-twitter"></i>
      </a>
      <a href="https://www.google.com/" 
         style="color: #ea4335; font-size: 18px; width: 48px; height: 48px; display: flex; align-items: center; justify-content: center; border-radius: 50%; background: linear-gradient(135deg, rgba(234, 67, 53, 0.1), rgba(234, 67, 53, 0.05)); transition: var(--transition); text-decoration: none;">
        <i class="fab fa-google"></i>
      </a>
    </div>
  </div>
</div>

<script>
// Modern Navigation System
class ModernNavigation {
  constructor() {
    this.init();
    this.setActiveState();
  }

  init() {
    this.setupEventListeners();
    this.setupRippleEffect();
    this.addEntranceAnimation();
  }

  setupEventListeners() {
    // Modal functionality
    document.getElementById('openModal').addEventListener('click', () => {
      this.openModal();
    });

    document.getElementById('closeModal').addEventListener('click', () => {
      this.closeModal();
    });

    // Close modal on overlay click
    document.getElementById('userModal').addEventListener('click', (e) => {
      if (e.target === e.currentTarget) {
        this.closeModal();
      }
    });

    // Navigation items
    document.querySelectorAll('.nav-item[data-page]').forEach(item => {
      item.addEventListener('click', (e) => {
        const page = e.currentTarget.dataset.page;
        this.navigateToPage(page, e.currentTarget);
      });
    });
  }

  setupRippleEffect() {
    document.querySelectorAll('.nav-item').forEach(button => {
      button.addEventListener('click', (e) => {
        this.createRipple(e, button);
      });
    });
  }

  createRipple(event, element) {
    const ripple = document.createElement('span');
    const rect = element.getBoundingClientRect();
    const size = Math.max(rect.width, rect.height);
    const x = event.clientX - rect.left - size / 2;
    const y = event.clientY - rect.top - size / 2;

    ripple.style.width = ripple.style.height = size + 'px';
    ripple.style.left = x + 'px';
    ripple.style.top = y + 'px';
    ripple.classList.add('ripple');

    element.appendChild(ripple);

    setTimeout(() => {
      ripple.remove();
    }, 600);
  }

  addEntranceAnimation() {
    const nav = document.getElementById('navigationBar');
    nav.classList.add('slide-up');
    
    // Stagger animation for nav items
    document.querySelectorAll('.nav-item').forEach((item, index) => {
      setTimeout(() => {
        item.classList.add('bounce-in');
      }, index * 100);
    });
  }

  setActiveState() {
    const currentPage = '<?php echo $currentPage; ?>'.replace('.php', '');
    document.querySelectorAll('.nav-item').forEach(item => {
      item.classList.remove('active');
      if (item.dataset.page === currentPage) {
        item.classList.add('active');
      }
    });
  }

  navigateToPage(page, element) {
    // Add loading animation to clicked element
    element.style.transform = 'scale(0.9)';
    element.style.opacity = '0.7';
    
    // Add page transition effect
    document.body.style.transition = 'opacity 0.3s ease';
    document.body.style.opacity = '0.8';
    
    setTimeout(() => {
      window.location.href = `./${page}.php`;
    }, 200);
  }

  openModal() {
    const modal = document.getElementById('userModal');
    modal.style.display = 'flex';
    setTimeout(() => {
      modal.classList.add('show');
      this.loadUserData();
    }, 10);
  }

  closeModal() {
    const modal = document.getElementById('userModal');
    modal.classList.remove('show');
    setTimeout(() => {
      modal.style.display = 'none';
    }, 300);
  }

  loadUserData() {
    const currentDate = new Date();
    document.getElementById('lastLogin').textContent = this.formatDateTime(currentDate);
    
    // Use in-memory storage instead of localStorage for compatibility
    if (!window.loginHistory) {
      window.loginHistory = [];
    }
    window.loginHistory.push(currentDate.toISOString());
    
    document.getElementById('totalLogs').textContent = window.loginHistory.length;
    
    this.fetchUserDataFromAPI();
  }

  formatDateTime(date) {
    const options = { 
      year: 'numeric', 
      month: 'short', 
      day: 'numeric', 
      hour: '2-digit', 
      minute: '2-digit',
      hour12: true
    };
    return date.toLocaleDateString('en-US', options);
  }

  fetchUserDataFromAPI() {
    const userId = "<?php echo isset($_SESSION['user_id']) ? $_SESSION['user_id'] : ''; ?>";
    
    if (userId) {
      const apiUrl = `../api/user_logs.php?user_id=${userId}`;
      
      fetch(apiUrl)
        .then(response => {
          if (!response.ok) throw new Error('Network response was not ok');
          return response.json();
        })
        .then(data => {
          if (data.total_logs) {
            document.getElementById('totalLogs').textContent = data.total_logs;
          }
          
          if (data.last_login) {
            const lastLoginDate = new Date(data.last_login);
            document.getElementById('lastLogin').textContent = this.formatDateTime(lastLoginDate);
          }
        })
        .catch(error => {
          console.error('Error fetching user data:', error);
          // Fallback to in-memory data if API fails
          if (window.loginHistory) {
            document.getElementById('totalLogs').textContent = window.loginHistory.length;
          }
        });
    }
  }
}

// Initialize navigation when DOM is loaded
document.addEventListener('DOMContentLoaded', () => {
  new ModernNavigation();
  
  // Add smooth page load animation
  document.body.style.opacity = '1';
  document.body.style.transition = 'opacity 0.4s ease';
});

// Prevent flash of unstyled content
document.documentElement.style.opacity = '0';
document.addEventListener('DOMContentLoaded', () => {
  document.documentElement.style.transition = 'opacity 0.3s ease';
  document.documentElement.style.opacity = '1';
});
</script>