<?php 
require_once '../session.php';
include '../db.php'; // Optional: include if you need a DB connection in this header
$currentPage = basename($_SERVER['PHP_SELF']); 
?>
<!-- Optimized Fast Preloader -->
<div id="preloader">
  <div class="preloader-content">
    <div class="logo-pulse-container">
      <div class="pulse-animation"></div>
      <div class="logo-preloader">
        <img src="https://bitvros.com/session/faviconb.png" alt="Ultra Logo">
      </div>
    </div>
    <div class="loader-text">Bitvros</div>
  </div>
</div>

<style>
/* Modern Vibrant CSS Variables */
:root {
  --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  --secondary-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
  --accent-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
  --success-gradient: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
  --primary-purple: #667eea;
  --primary-purple-dark: #5a67d8;
  --primary-purple-light: #7c3aed;
  --vibrant-pink: #f093fb;
  --vibrant-blue: #4facfe;
  --vibrant-green: #43e97b;
  --vibrant-orange: #ff9a56;
  --white: #ffffff;
  --gray-50: #f8fafc;
  --gray-100: #f1f5f9;
  --gray-200: #e2e8f0;
  --gray-300: #cbd5e1;
  --gray-400: #94a3b8;
  --gray-500: #64748b;
  --gray-600: #475569;
  --gray-700: #334155;
  --gray-800: #1e293b;
  --gray-900: #0f172a;
  --shadow-sm: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
  --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.05);
  --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
  --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
  --shadow-vibrant: 0 20px 40px -10px rgba(102, 126, 234, 0.3);
  --transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
  --transition-bounce: all 0.2s cubic-bezier(0.68, -0.55, 0.265, 1.55);
  --border-radius: 12px;
  --border-radius-lg: 16px;
  --border-radius-xl: 20px;
}

/* Modern Body Styles */
body {
  margin: 0;
  padding: 0;
  font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
  background: var(--white);
  color: var(--gray-800);
  line-height: 1.6;
  overflow-x: hidden;
}

/* Optimized Fast Preloader */
#preloader {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: var(--white);
  display: flex;
  align-items: center;
  justify-content: center;
  z-index: 9999;
  transition: opacity 0.2s ease, visibility 0.2s ease;
}

.preloader-content {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
}

.logo-pulse-container {
  position: relative;
  display: flex;
  align-items: center;
  justify-content: center;
  width: 120px;
  height: 120px;
  margin-bottom: 1.5rem;
}

.pulse-animation {
  position: absolute;
  width: 80px;
  height: 80px;
  border-radius: 50%;
  background: var(--primary-purple);
  animation: pulseEffect 1.2s infinite cubic-bezier(0.4, 0, 0.6, 1);
}

.pulse-animation::before,
.pulse-animation::after {
  content: "";
  position: absolute;
  inset: 0;
  border-radius: inherit;
  background: var(--primary-purple);
  animation: inherit;
  animation-delay: -0.4s;
}

.pulse-animation::after {
  animation-delay: -0.8s;
}

@keyframes pulseEffect {
  0% { 
    transform: scale(0.3);
    opacity: 1;
  }
  100% { 
    transform: scale(1.8);
    opacity: 0;
  }
}

.logo-preloader {
  position: relative;
  z-index: 2;
  display: flex;
  align-items: center;
  justify-content: center;
  animation: logoGlow 2s ease-in-out infinite alternate;
}

.logo-preloader img {
  height: 48px;
  width: auto;
  filter: drop-shadow(0 8px 16px rgba(102, 126, 234, 0.4));
  transition: transform 0.3s ease;
}

@keyframes logoGlow {
  from {
    filter: drop-shadow(0 8px 16px rgba(102, 126, 234, 0.4));
    transform: scale(1);
  }
  to {
    filter: drop-shadow(0 12px 24px rgba(102, 126, 234, 0.6));
    transform: scale(1.05);
  }
}

.loader-text {
  background: var(--primary-gradient);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  background-clip: text;
  font-size: 1.1rem;
  font-weight: 700;
  letter-spacing: 0.05em;
  animation: textPulse 1.5s ease-in-out infinite;
}

@keyframes textPulse {
  0%, 100% { opacity: 0.7; transform: translateY(0); }
  50% { opacity: 1; transform: translateY(-2px); }
}
</style>

<header id="main-header">
  <div class="header-container">
    <div class="header-content">
      <!-- Logo Section -->
      <div class="logo-section">
        <a href="./dashboard.php" class="logo-container">
          <img src="https://bitvros.com/session/faviconb.png" alt="logo">
          <span class="logo-text">Bitvros</span>
        </a>

        <!-- Desktop Navigation -->
        <nav class="nav-section">
          <ul class="nav-menu">
            <li>
              <a href="./dashboard.php" class="nav-link <?php echo $currentPage == 'dashboard.php' ? 'active' : ''; ?>">
                Home
              </a>
            </li>
            <li>
              <a href="./history.php" class="nav-link <?php echo $currentPage == 'history.php' ? 'active' : ''; ?>">
                History
              </a>
            </li>
            <li>
              <a href="./explore.php" class="nav-link <?php echo $currentPage == 'explore.php' ? 'active' : ''; ?>">
                Explore
              </a>
            </li>
            <li>
              <a href="./connect.php" class="nav-link <?php echo $currentPage == 'connect.php' ? 'active' : ''; ?>">
                Connect
              </a>
            </li>
            <li>
              <a href="./verify.php" class="nav-link <?php echo $currentPage == 'verify.php' ? 'active' : ''; ?>">
                KYC
              </a>
            </li>
            <li>
              <a href="https://widget-page.smartsupp.com/widget/915fb37777580374bb01a8c41a10b4c2ab3c23ba" class="nav-link support-link" target="_blank">
                Support
              </a>
            </li>
            
            <!-- Receive Dropdown -->
            <li class="dropdown">
              <button class="nav-link dropdown-toggle <?php echo in_array($currentPage, ['bitcoinr.php', 'ethr.php', 'usdtr.php', 'xrpr.php', 'bnbr.php', 'peper.php', 'doger.php', 'adar.php', 'solr.php']) ? 'active' : ''; ?>" id="receive-dropdown">
                Receive
                <svg class="dropdown-arrow" fill="currentColor" viewBox="0 0 20 20">
                  <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
                </svg>
              </button>
              <div class="dropdown-menu">
                <a href="./bitcoinr.php" class="dropdown-item">₿ Bitcoin (BTC)</a>
                <a href="./ethr.php" class="dropdown-item">⟠ Ethereum (ETH)</a>
                <a href="./usdtr.php" class="dropdown-item">₮ Tether (USDT)</a>
                <a href="./xrpr.php" class="dropdown-item">✕ Ripple (XRP)</a>
                <a href="./bnbr.php" class="dropdown-item">🅑 Binance (BNB)</a>
                <a href="./peper.php" class="dropdown-item">🐸 Pepe (PEPE)</a>
                <a href="./doger.php" class="dropdown-item">🐕 Dogecoin (DOGE)</a>
                <a href="./adar.php" class="dropdown-item">₳ Cardano (ADA)</a>
                <a href="./solr.php" class="dropdown-item">◎ Solana (SOL)</a>
              </div>
            </li>

            <!-- Send Dropdown -->
            <li class="dropdown">
              <button class="nav-link dropdown-toggle <?php echo in_array($currentPage, ['bitcoins.php', 'eths.php', 'usdtd.php', 'xrps.php', 'bnbs.php', 'pepes.php', 'doges.php', 'adas.php', 'sols.php']) ? 'active' : ''; ?>" id="send-dropdown">
                Send
                <svg class="dropdown-arrow" fill="currentColor" viewBox="0 0 20 20">
                  <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
                </svg>
              </button>
              <div class="dropdown-menu">
                <a href="./bitcoins.php" class="dropdown-item">₿ Bitcoin (BTC)</a>
                <a href="./eths.php" class="dropdown-item">⟠ Ethereum (ETH)</a>
                <a href="./usdtd.php" class="dropdown-item">₮ Tether (USDT)</a>
                <a href="./xrps.php" class="dropdown-item">✕ Ripple (XRP)</a>
                <a href="./bnbs.php" class="dropdown-item">🅑 Binance (BNB)</a>
                <a href="./pepes.php" class="dropdown-item">🐸 Pepe (PEPE)</a>
                <a href="./doges.php" class="dropdown-item">🐕 Dogecoin (DOGE)</a>
                <a href="./adas.php" class="dropdown-item">₳ Cardano (ADA)</a>
                <a href="./sols.php" class="dropdown-item">◎ Solana (SOL)</a>
              </div>
            </li>
          </ul>
        </nav>
      </div>
      
      <!-- User Section -->
      <div class="user-section">
        <div class="user-info">
          <div class="user-name">
            <?php 
              if(isset($name) && !empty($name)) {
                echo htmlspecialchars($name);
              } else {
                echo 'User';
              }
            ?>
          </div>
          <div class="user-email">
            <?php 
              if (isset($email) && !empty($email)) {
                  $atPosition = strpos($email, '@');
                  if ($atPosition !== false) {
                      $username = substr($email, 0, $atPosition);
                      $domain = substr($email, $atPosition);
                      
                      if (strlen($username) > 2) {
                          $firstChar = substr($username, 0, 1);
                          $lastChar = substr($username, -1);
                          echo htmlspecialchars($firstChar . '***' . $lastChar . $domain);
                      } else {
                          echo htmlspecialchars($email);
                      }
                  } else {
                      echo htmlspecialchars($email);
                  }
              } else {
                  echo 'No Email Provided';
              }
            ?>
          </div>
        </div>
        
        <!-- Profile Dropdown -->
        <div class="dropdown">
          <!-- Font Awesome (for power icon) -->
          <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
          <!-- SweetAlert2 (for confirmation modal) -->
          <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

          <!-- Button only -->
          <button type="button" onclick="confirmLogout()" class="group inline-flex items-center justify-center w-6 h-6 bg-white text-red-600 border border-red-500 rounded-full transition duration-300 ease-in-out hover:bg-red-600 hover:text-white hover:rotate-90">
            <i class="fas fa-power-off text-[10px] transition-transform duration-300 ease-in-out group-hover:scale-110"></i>
          </button>
        </div>
        
        <!-- Mobile Menu Button -->
        <button onclick="openModal()"
                class="hide-on-desktop"
                style="background: none;
                       border: none;
                       cursor: pointer;
                       padding: 10px;
                       display: inline-flex;
                       flex-direction: column;
                       gap: 6px;"
                onmouseover="this.querySelectorAll('span span').forEach(dot => dot.style.transform = 'scale(1.3)')"
                onmouseout="this.querySelectorAll('span span').forEach(dot => dot.style.transform = 'scale(1)')">
          <span style="display: flex; gap: 6px;">
            <span style="width: 8px; height: 8px; background-color: #B30000; border-radius: 50%; transition: transform 0.2s;"></span>
            <span style="width: 8px; height: 8px; background-color: #0C9E5E; border-radius: 50%; transition: transform 0.2s;"></span>
          </span>
          <span style="display: flex; gap: 6px;">
            <span style="width: 8px; height: 8px; background-color: #FFD700; border-radius: 50%; transition: transform 0.2s;"></span>
            <span style="width: 8px; height: 8px; background-color: #FF6B35; border-radius: 50%; transition: transform 0.2s;"></span>
          </span>
        </button>
      </div>
    </div>

    <!-- Mobile Menu -->
    <div id="mobile-menu">
      <a href="./dashboard.php" class="mobile-nav-item <?php echo $currentPage == 'dashboard.php' ? 'active' : ''; ?>">
        Home
      </a>
      <a href="./history.php" class="mobile-nav-item <?php echo $currentPage == 'history.php' ? 'active' : ''; ?>">
        History
      </a>
      <a href="./explore.php" class="mobile-nav-item <?php echo $currentPage == 'explore.php' ? 'active' : ''; ?>">
        Explore
      </a>
      <a href="./connect.php" class="mobile-nav-item <?php echo $currentPage == 'connect.php' ? 'active' : ''; ?>">
        Connect
      </a>
      <a href="./verify.php" class="mobile-nav-item <?php echo $currentPage == 'verify.php' ? 'active' : ''; ?>">
        KYC
      </a>
      <a href="https://widget-page.smartsupp.com/widget/915fb37777580374bb01a8c41a10b4c2ab3c23ba" class="mobile-nav-item support-link" target="_blank">
        Support
      </a>
      
      <!-- Mobile Receive Dropdown -->
      <button class="mobile-dropdown-toggle" onclick="toggleMobileDropdown('receive')">
        Receive
        <svg class="dropdown-arrow" style="width: 16px; height: 16px;" fill="currentColor" viewBox="0 0 20 20">
          <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
        </svg>
      </button>
      <div id="mobile-receive-dropdown" class="mobile-dropdown-menu">
        <a href="./bitcoinr.php" class="mobile-dropdown-item">₿ Bitcoin (BTC)</a>
        <a href="./ethr.php" class="mobile-dropdown-item">⟠ Ethereum (ETH)</a>
        <a href="./usdtr.php" class="mobile-dropdown-item">₮ Tether (USDT)</a>
        <a href="./xrpr.php" class="mobile-dropdown-item">✕ Ripple (XRP)</a>
        <a href="./bnbr.php" class="mobile-dropdown-item">🅑 Binance (BNB)</a>
        <a href="./peper.php" class="mobile-dropdown-item">🐸 Pepe (PEPE)</a>
        <a href="./doger.php" class="mobile-dropdown-item">🐕 Dogecoin (DOGE)</a>
        <a href="./adar.php" class="mobile-dropdown-item">₳ Cardano (ADA)</a>
        <a href="./solr.php" class="mobile-dropdown-item">◎ Solana (SOL)</a>
      </div>

      <!-- Mobile Send Dropdown -->
      <button class="mobile-dropdown-toggle" onclick="toggleMobileDropdown('send')">
        Send
        <svg class="dropdown-arrow" style="width: 16px; height: 16px;" fill="currentColor" viewBox="0 0 20 20">
          <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
        </svg>
      </button>
      <div id="mobile-send-dropdown" class="mobile-dropdown-menu">
        <a href="./bitcoins.php" class="mobile-dropdown-item">₿ Bitcoin (BTC)</a>
        <a href="./eths.php" class="mobile-dropdown-item">⟠ Ethereum (ETH)</a>
        <a href="./usdtd.php" class="mobile-dropdown-item">₮ Tether (USDT)</a>
        <a href="./xrps.php" class="mobile-dropdown-item">✕ Ripple (XRP)</a>
        <a href="./bnbs.php" class="mobile-dropdown-item">🅑 Binance (BNB)</a>
        <a href="./pepes.php" class="mobile-dropdown-item">🐸 Pepe (PEPE)</a>
        <a href="./doges.php" class="mobile-dropdown-item">🐕 Dogecoin (DOGE)</a>
        <a href="./adas.php" class="mobile-dropdown-item">₳ Cardano (ADA)</a>
        <a href="./sols.php" class="mobile-dropdown-item">◎ Solana (SOL)</a>
      </div>
      
      <div class="divider"></div>
      <a href="../logout.php" class="mobile-nav-item danger-item">
        Logout
      </a>
    </div>
  </div>
</header>




      <!-- Hidden Google Translate Element with Improved Styling -->
<style>
  /* Hide Google Translate widget and branding */
  .goog-te-banner-frame,
  .goog-te-balloon-frame,
  #goog-gt-tt,
  .goog-te-menu-value span,
  .VIpgJd-ZVi9od-l4eHX-hSRGPd,
  .VIpgJd-ZVi9od-aZ2wEe-wOHMyf,
  .VIpgJd-ZVi9od-aZ2wEe-OiiCO {
    display: none !important;
  }
  
  /* Hide the default Google Translate dropdown container */
  #google_translate_element {
    position: absolute;
    overflow: hidden;
    height: 0;
    visibility: hidden;
    opacity: 0;
  }
  
  /* Remove Google frame affecting site layout */
  body {
    top: 0 !important;
  }
  
  /* Fix for any shifted elements after translation */
  .skiptranslate,
  .goog-tooltip,
  .goog-tooltip:hover {
    display: none !important;
  }

  /* Custom language indicator styles, if you want to show it */
  .language-indicator {
    position: fixed;
    bottom: 20px;
    right: 20px;
    background: rgba(255, 255, 255, 0.9);
    padding: 8px 15px;
    border-radius: 50px;
    font-size: 12px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    z-index: 9999;
    opacity: 0.8;
    transition: opacity 0.3s;
    display: none; /* Hidden by default */
  }
  
  .language-indicator:hover {
    opacity: 1;
  }
</style>

<!-- Hidden Google Translate element -->
<div id="google_translate_element"></div>

<!-- Optional: Language indicator (uncomment to enable) -->
<!-- <div class="language-indicator">Translated to: <span id="current-language">English</span></div> -->

<script type="text/javascript">
  // Improved Google Translate implementation
  class SmartTranslator {
    constructor(options = {}) {
      this.options = {
        pageLanguage: 'en',
        autoDisplay: false,
        excludedCountries: ['IN', 'GH', 'LK'],
        cookieName: 'preferred_language',
        cookieExpiry: 30, // days
        debug: false,
        ...options
      };
      
      this.countryLangMap = {
        'US': 'en', 'CA': 'en', 'GB': 'en', 'AU': 'en', 'NZ': 'en', 'IE': 'en',
        'FR': 'fr', 'BE': 'nl', 'NL': 'nl', 'DE': 'de', 'AT': 'de', 'CH': 'de',
        'IT': 'it', 'ES': 'es', 'PT': 'pt', 'BR': 'pt', 'MX': 'es', 'AR': 'es',
        'CL': 'es', 'CO': 'es', 'PE': 'es', 'VE': 'es', 'EC': 'es', 'RU': 'ru',
        'PL': 'pl', 'CZ': 'cs', 'SK': 'sk', 'HU': 'hu', 'RO': 'ro', 'BG': 'bg',
        'GR': 'el', 'TR': 'tr', 'IL': 'he', 'SA': 'ar', 'AE': 'ar', 'EG': 'ar',
        'IN': 'hi', 'PK': 'ur', 'BD': 'bn', 'LK': 'si', 'NP': 'ne', 'ID': 'id',
        'MY': 'ms', 'PH': 'fil', 'TH': 'th', 'VN': 'vi', 'KR': 'ko', 'JP': 'ja',
        'CN': 'zh-CN', 'TW': 'zh-TW', 'HK': 'zh-TW', 'SG': 'en', 'FI': 'fi',
        'SE': 'sv', 'NO': 'no', 'DK': 'da', 'IS': 'is', 'EE': 'et', 'LV': 'lv',
        'LT': 'lt'
      };
      
      this.languageNames = {
        'en': 'English', 'fr': 'Français', 'es': 'Español', 'de': 'Deutsch',
        'it': 'Italiano', 'pt': 'Português', 'ru': 'Русский', 'ja': 'Japanese',
        'zh-CN': 'Chinese (Simplified)', 'zh-TW': 'Chinese (Traditional)',
        'ko': 'Korean', 'ar': 'Arabic', 'hi': 'Hindi', 'nl': 'Dutch'
        // Add more as needed
      };
      
      this.init();
    }
    
    init() {
      // Initialize after DOM is ready
      if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', () => this.setup());
      } else {
        this.setup();
      }
    }
    
    setup() {
      this.log('Initializing translator');
      
      // First check saved preference
      const savedLang = this.getCookie(this.options.cookieName);
      
      if (savedLang) {
        this.log(`Found saved language preference: ${savedLang}`);
        this.initTranslate(() => this.translateTo(savedLang));
      } else {
        // Otherwise detect based on location
        this.detectLanguage()
          .then(lang => {
            if (lang) {
              this.log(`Detected language: ${lang}`);
              this.initTranslate(() => this.translateTo(lang));
            } else {
              this.log('No translation needed');
              this.initTranslate(); // Just initialize without translating
            }
          })
          .catch(err => {
            this.log('Error detecting language:', err);
            this.initTranslate();
          });
      }
      
      // Remove Google's top bar effect after translation
      this.fixTopBarEffect();
    }
    
    initTranslate(callback) {
      // Create script element to load Google Translate
      const script = document.createElement('script');
      script.src = '//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit';
      script.async = true;
      
      // Define the callback function for Google Translate
      window.googleTranslateElementInit = () => {
        new google.translate.TranslateElement({
          pageLanguage: this.options.pageLanguage,
          autoDisplay: this.options.autoDisplay
        }, 'google_translate_element');
        
        if (callback) {
          // Give time for Google Translate to initialize
          setTimeout(callback, 1000);
        }
      };
      
      document.body.appendChild(script);
    }
    
    detectLanguage() {
      return fetch('https://ipapi.co/json/')
        .then(response => response.json())
        .then(data => {
          if (data && data.country) {
            if (this.options.excludedCountries.includes(data.country)) {
              return null; // Don't translate for excluded countries
            }
            return this.countryLangMap[data.country] || null;
          }
          return null;
        })
        .catch(error => {
          this.log('IP detection failed:', error);
          return null;
        });
    }
    
    translateTo(language) {
      if (!language) return;
      
      this.log(`Translating to: ${language}`);
      
      // Save preference
      this.setCookie(this.options.cookieName, language, this.options.cookieExpiry);
      
      let attempts = 0;
      const maxAttempts = 20;
      const intervalId = setInterval(() => {
        const comboBox = document.querySelector('.goog-te-combo');
        if (comboBox) {
          comboBox.value = language;
          comboBox.dispatchEvent(new Event('change'));
          clearInterval(intervalId);
          
          // Update language indicator if it exists
          const indicator = document.getElementById('current-language');
          if (indicator) {
            indicator.textContent = this.languageNames[language] || language;
            indicator.parentElement.style.display = 'block';
          }
        } else if (++attempts >= maxAttempts) {
          this.log('Failed to find translation dropdown');
          clearInterval(intervalId);
        }
      }, 500);
    }
    
    fixTopBarEffect() {
      // Monitor and fix Google's modification to the body tag
      const observer = new MutationObserver((mutations) => {
        mutations.forEach((mutation) => {
          if (mutation.target.nodeName === 'BODY' && 
              mutation.target.style.top && 
              mutation.target.style.top !== '0px') {
            mutation.target.style.top = '0px';
          }
        });
      });
      
      observer.observe(document.body, { 
        attributes: true, 
        attributeFilter: ['style'] 
      });
      
      // Additional fix for Google's top bar
      setInterval(() => {
        if (document.body.style.top !== '' && document.body.style.top !== '0px') {
          document.body.style.top = '0px';
        }
      }, 1000);
    }
    
    // Helper functions
    getCookie(name) {
      const match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
      return match ? match[2] : null;
    }
    
    setCookie(name, value, days) {
      let expires = '';
      if (days) {
        const date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        expires = '; expires=' + date.toUTCString();
      }
      document.cookie = name + '=' + value + expires + '; path=/; SameSite=Lax';
    }
    
    log(...args) {
      if (this.options.debug) {
        console.log('SmartTranslator:', ...args);
      }
    }
  }

  // Initialize the translator
  document.addEventListener('DOMContentLoaded', () => {
    new SmartTranslator({
      excludedCountries: ['IN', 'GH', 'LK'],
      debug: false // Set to true for debugging
    });
  });
</script>
      
<!-- Modal for Mobile Menu -->
<div id="menuModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); z-index: 10000; backdrop-filter: blur(10px);">
  <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; border-radius: 20px; padding: 30px; min-width: 300px; box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
      <h3 style="margin: 0; background: var(--primary-gradient); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; font-weight: 800;">Menu</h3>
      <button onclick="closeModal()" style="background: none; border: none; font-size: 24px; cursor: pointer; color: #666;">×</button>
    </div>
    
    <div style="display: flex; flex-direction: column; gap: 15px;">
      <a href="./dashboard.php" class="modal-nav-link">🏠 Home</a>
      <a href="./history.php" class="modal-nav-link">📊 History</a>
      <a href="./explore.php" class="modal-nav-link">🔍 Explore</a>
      <a href="./connect.php" class="modal-nav-link">🔗 Connect</a>
      <a href="./verify.php" class="modal-nav-link">✅ KYC</a>
      <a href="https://widget-page.smartsupp.com/widget/915fb37777580374bb01a8c41a10b4c2ab3c23ba" class="modal-nav-link" target="_blank">💬 Support</a>
      
      <hr style="border: none; height: 1px; background: #eee; margin: 10px 0;">
      
      <div>
        <h4 style="margin: 10px 0 5px 0; color: #666; font-size: 14px;">RECEIVE</h4>
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 10px;">
          <a href="./bitcoinr.php" class="crypto-link">₿ BTC</a>
          <a href="./ethr.php" class="crypto-link">⟠ ETH</a>
          <a href="./usdtr.php" class="crypto-link">₮ USDT</a>
          <a href="./xrpr.php" class="crypto-link">✕ XRP</a>
          <a href="./bnbr.php" class="crypto-link">🅑 BNB</a>
          <a href="./peper.php" class="crypto-link">🐸 PEPE</a>
          <a href="./doger.php" class="crypto-link">🐕 DOGE</a>
          <a href="./adar.php" class="crypto-link">₳ ADA</a>
          <a href="./solr.php" class="crypto-link">◎ SOL</a>
        </div>
      </div>
      
      <div>
        <h4 style="margin: 10px 0 5px 0; color: #666; font-size: 14px;">SEND</h4>
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 10px;">
          <a href="./bitcoins.php" class="crypto-link">₿ BTC</a>
          <a href="./eths.php" class="crypto-link">⟠ ETH</a>
          <a href="./usdtd.php" class="crypto-link">₮ USDT</a>
          <a href="./xrps.php" class="crypto-link">✕ XRP</a>
          <a href="./bnbs.php" class="crypto-link">🅑 BNB</a>
          <a href="./pepes.php" class="crypto-link">🐸 PEPE</a>
          <a href="./doges.php" class="crypto-link">🐕 DOGE</a>
          <a href="./adas.php" class="crypto-link">₳ ADA</a>
          <a href="./sols.php" class="crypto-link">◎ SOL</a>
        </div>
      </div>
    </div>
  </div>
</div>

<style>
.modal-nav-link {
  display: block;
  padding: 12px 16px;
  text-decoration: none;
  color: #333;
  border-radius: 10px;
  transition: all 0.3s ease;
  font-weight: 500;
}

.modal-nav-link:hover {
  background: rgba(102, 126, 234, 0.1);
  color: var(--primary-purple);
  transform: translateX(5px);
}

.crypto-link {
  display: block;
  padding: 8px 12px;
  text-decoration: none;
  color: #666;
  border: 1px solid #e2e8f0;
  border-radius: 8px;
  font-size: 12px;
  font-weight: 600;
  text-align: center;
  transition: all 0.3s ease;
}

.crypto-link:hover {
  background: var(--primary-gradient);
  color: white;
  border-color: transparent;
  transform: translateY(-2px);
}
</style>

<script>
// Optimized Fast Preloader - loads 3x faster
document.addEventListener('DOMContentLoaded', function() {
  // Hide preloader much faster - only 300ms instead of 800ms
  setTimeout(function() {
    const preloader = document.getElementById('preloader');
    preloader.style.opacity = '0';
    preloader.style.visibility = 'hidden';
    
    // Remove from DOM after transition
    setTimeout(() => {
      preloader.remove();
    }, 200);
  }, 300);
});

// Header scroll behavior
let lastScrollY = window.scrollY;
const header = document.getElementById('main-header');

window.addEventListener('scroll', () => {
  const currentScrollY = window.scrollY;
  
  if (currentScrollY > 100) {
    header.classList.add('scrolled');
  } else {
    header.classList.remove('scrolled');
  }
  
  if (currentScrollY > lastScrollY && currentScrollY > 100) {
    header.classList.add('hidden');
  } else {
    header.classList.remove('hidden');
  }
  
  lastScrollY = currentScrollY;
});

// Desktop dropdown functionality
document.addEventListener('DOMContentLoaded', function() {
  const dropdowns = document.querySelectorAll('.dropdown');
  
  dropdowns.forEach(dropdown => {
    const toggle = dropdown.querySelector('.dropdown-toggle');
    const menu = dropdown.querySelector('.dropdown-menu');
    
    if (toggle && menu) {
      toggle.addEventListener('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        // Close other dropdowns
        dropdowns.forEach(otherDropdown => {
          if (otherDropdown !== dropdown) {
            otherDropdown.classList.remove('show');
          }
        });
        
        dropdown.classList.toggle('show');
      });
    }
  });
  
  // Close dropdowns when clicking outside
  document.addEventListener('click', function() {
    dropdowns.forEach(dropdown => {
      dropdown.classList.remove('show');
    });
  });
});


 // Mobile dropdown functionality
function toggleMobileDropdown(type) {
  const dropdown = document.getElementById(`mobile-${type}-dropdown`);
  const toggle = event.target.closest('.mobile-dropdown-toggle');
  const arrow = toggle.querySelector('.dropdown-arrow');
  
  if (dropdown.style.display === 'block') {
    dropdown.style.display = 'none';
    arrow.style.transform = 'rotate(0deg)';
  } else {
    dropdown.style.display = 'block';
    arrow.style.transform = 'rotate(180deg)';
  }
}

// Modal functions
function openModal() {
  document.getElementById('menuModal').style.display = 'block';
  document.body.style.overflow = 'hidden';
}

function closeModal() {
  document.getElementById('menuModal').style.display = 'none';
  document.body.style.overflow = 'auto';
}

// Close modal when clicking outside
document.addEventListener('click', function(event) {
  const modal = document.getElementById('menuModal');
  if (event.target === modal) {
    closeModal();
  }
});

// Logout confirmation
function confirmLogout() {
  Swal.fire({
    title: 'Confirm Logout',
    text: 'Are you sure you want to logout?',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#dc2626',
    cancelButtonColor: '#6b7280',
    confirmButtonText: 'Yes, logout',
    cancelButtonText: 'Cancel',
    background: '#ffffff',
    customClass: {
      confirmButton: 'swal-confirm-btn',
      cancelButton: 'swal-cancel-btn'
    }
  }).then((result) => {
    if (result.isConfirmed) {
      window.location.href = '../logout.php';
    }
  });
}
</script>

<style>
/* Header Styles */
#main-header {
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  background: rgba(255, 255, 255, 0.95);
  backdrop-filter: blur(20px);
  border-bottom: 1px solid var(--gray-200);
  z-index: 1000;
  transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

#main-header.scrolled {
  background: rgba(255, 255, 255, 0.98);
  border-bottom-color: var(--gray-300);
  box-shadow: var(--shadow-sm);
}

#main-header.hidden {
  transform: translateY(-100%);
}

.header-container {
  max-width: 1400px;
  margin: 0 auto;
  padding: 0 1rem;
}

.header-content {
  display: flex;
  align-items: center;
  justify-content: space-between;
  height: 70px;
}

.logo-section {
  display: flex;
  align-items: center;
  gap: 2rem;
}

.logo-container {
  display: flex;
  align-items: center;
  gap: 0.75rem;
  text-decoration: none;
  transition: var(--transition);
}

.logo-container:hover {
  transform: scale(1.05);
}

.logo-container img {
  height: 32px;
  width: auto;
}

.logo-text {
  font-size: 1.5rem;
  font-weight: 800;
  background: var(--primary-gradient);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  background-clip: text;
}

.nav-section {
  flex: 1;
  display: flex;
  justify-content: center;
}

.nav-menu {
  display: flex;
  align-items: center;
  gap: 0.5rem;
  list-style: none;
  margin: 0;
  padding: 0;
}

.nav-link {
  display: flex;
  align-items: center;
  gap: 0.5rem;
  padding: 0.75rem 1rem;
  text-decoration: none;
  color: var(--gray-600);
  font-weight: 500;
  border-radius: var(--border-radius);
  transition: var(--transition);
  position: relative;
  background: none;
  border: none;
  cursor: pointer;
  font-size: 0.875rem;
}

.nav-link:hover {
  color: var(--primary-purple);
  background: rgba(102, 126, 234, 0.1);
}

.nav-link.active {
  color: var(--primary-purple);
  background: rgba(102, 126, 234, 0.15);
  font-weight: 600;
}

.dropdown {
  position: relative;
}

.dropdown-toggle {
  display: flex;
  align-items: center;
  gap: 0.5rem;
}

.dropdown-arrow {
  width: 16px;
  height: 16px;
  transition: transform 0.2s ease;
}

.dropdown.show .dropdown-arrow {
  transform: rotate(180deg);
}

.dropdown-menu {
  position: absolute;
  top: 100%;
  left: 50%;
  transform: translateX(-50%);
  min-width: 200px;
  background: var(--white);
  border: 1px solid var(--gray-200);
  border-radius: var(--border-radius);
  box-shadow: var(--shadow-xl);
  opacity: 0;
  visibility: hidden;
  transition: all 0.2s ease;
  z-index: 1001;
  margin-top: 0.5rem;
}

.dropdown.show .dropdown-menu {
  opacity: 1;
  visibility: visible;
}

.dropdown-item {
  display: block;
  padding: 0.75rem 1rem;
  color: var(--gray-700);
  text-decoration: none;
  transition: var(--transition);
  border-bottom: 1px solid var(--gray-100);
}

.dropdown-item:last-child {
  border-bottom: none;
}

.dropdown-item:hover {
  background: var(--gray-50);
  color: var(--primary-purple);
}

.user-section {
  display: flex;
  align-items: center;
  gap: 1rem;
}

.user-info {
  text-align: right;
}

.user-name {
  font-weight: 600;
  color: var(--gray-800);
  font-size: 0.875rem;
}

.user-email {
  font-size: 0.75rem;
  color: var(--gray-500);
}

.support-link {
  background: var(--success-gradient) !important;
  color: white !important;
  font-weight: 600;
}

.support-link:hover {
  transform: translateY(-1px);
  box-shadow: var(--shadow-lg);
}

/* Mobile Styles */
.hide-on-desktop {
  display: none;
}

#mobile-menu {
  display: none;
  background: var(--white);
  border-top: 1px solid var(--gray-200);
  padding: 1rem 0;
}

.mobile-nav-item {
  display: block;
  padding: 0.75rem 1rem;
  color: var(--gray-700);
  text-decoration: none;
  transition: var(--transition);
  border-left: 3px solid transparent;
}

.mobile-nav-item:hover {
  background: var(--gray-50);
  color: var(--primary-purple);
  border-left-color: var(--primary-purple);
}

.mobile-nav-item.active {
  background: rgba(102, 126, 234, 0.1);
  color: var(--primary-purple);
  border-left-color: var(--primary-purple);
  font-weight: 600;
}

.mobile-dropdown-toggle {
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 0.75rem 1rem;
  background: none;
  border: none;
  color: var(--gray-700);
  text-align: left;
  cursor: pointer;
  transition: var(--transition);
  border-left: 3px solid transparent;
}

.mobile-dropdown-toggle:hover {
  background: var(--gray-50);
  color: var(--primary-purple);
  border-left-color: var(--primary-purple);
}

.mobile-dropdown-menu {
  display: none;
  background: var(--gray-50);
  border-top: 1px solid var(--gray-200);
}

.mobile-dropdown-item {
  display: block;
  padding: 0.5rem 2rem;
  color: var(--gray-600);
  text-decoration: none;
  font-size: 0.875rem;
  transition: var(--transition);
}

.mobile-dropdown-item:hover {
  background: var(--gray-100);
  color: var(--primary-purple);
}

.divider {
  height: 1px;
  background: var(--gray-200);
  margin: 0.5rem 0;
}

.danger-item {
  color: #dc2626 !important;
}

.danger-item:hover {
  background: rgba(220, 38, 38, 0.1) !important;
  border-left-color: #dc2626 !important;
}

/* SweetAlert Custom Styles */
.swal-confirm-btn {
  background: #dc2626 !important;
  border-radius: 8px !important;
  font-weight: 600 !important;
  padding: 10px 20px !important;
}

.swal-cancel-btn {
  background: #6b7280 !important;
  border-radius: 8px !important;
  font-weight: 600 !important;
  padding: 10px 20px !important;
}

/* Responsive Styles */
@media (max-width: 1024px) {
  .nav-section {
    display: none;
  }
  
  .hide-on-desktop {
    display: block;
  }
}

@media (max-width: 768px) {
  .header-content {
    height: 60px;
  }
  
  .logo-container img {
    height: 28px;
  }
  
  .logo-text {
    font-size: 1.25rem;
  }
  
  .user-info {
    display: none;
  }
  
  .header-container {
    padding: 0 0.75rem;
  }
}

@media (max-width: 480px) {
  .header-content {
    height: 55px;
  }
  
  .logo-container img {
    height: 24px;
  }
  
  .logo-text {
    font-size: 1.1rem;
  }
}
</style>

&nbsp;
  <?php include './includes/navmodal.php'; ?>