<?php
// Enable full error reporting (for development only, remove or disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in, if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$usd_balance    = isset($userDetails['balance']) ? (float)$userDetails['balance'] : 0; // User's USD balance
$btc            = $userDetails['btc'];
$pepe           = isset($userDetails['pepe']) ? $userDetails['pepe'] : null; // PEPE balance (if applicable)
$usdt           = $userDetails['usdt'];
$xrp            = $userDetails['xrp'];
$extra          = $userDetails['extra'];
$update_time    = $userDetails['update_time'];

// Define CoinGecko API URL to fetch PEPE price in USD
$api_url = "https://api.coingecko.com/api/v3/simple/price?ids=pepe&vs_currencies=usd";

// Initialize cURL and fetch PEPE price
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
$response = curl_exec($ch);
curl_close($ch);
$data = json_decode($response, true);

// Validate API response and extract PEPE price
$pepe_price_usd = isset($data['pepe']['usd']) ? (float)$data['pepe']['usd'] : 1;

// Convert USD balance to PEPE
$converted_pepe = ($usd_balance > 0 && $pepe_price_usd > 0) ? $usd_balance / $pepe_price_usd : 0;

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Receive PEPE</title>
  <!-- Favicon -->
  <link rel="icon" href="../faviconb.png" type="image/x-icon">
  
  <!-- Tailwind CSS via CDN -->
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- Font Awesome for icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body class="bg-gray-100 min-h-screen m-0 p-0">
  <!-- Full Page Container -->
  <div class="bg-white h-screen w-full overflow-auto">
    
    <!-- Top Bar: Back Arrow, Title, Help -->
    <div class="flex items-center justify-between p-4 border-b border-gray-200">
      <!-- Back Arrow Button -->
      <button id="backBtn" onclick="window.history.back()" class="text-blue-500 hover:text-blue-600 focus:outline-none" aria-label="Go back">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7" />
        </svg>
      </button>

      <!-- Title -->
      <h1 class="text-lg font-semibold text-gray-800">Receive PEPE</h1>
      <!-- Help / Question Mark Button -->
     <a href="./dashboard.php" target="_blank" class="text-blue-500 hover:text-blue-600 focus:outline-none">
  <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M3 12l9-9m0 0l9 9m-9-9v18" />
                </svg>
</a>
    </div>
    
    <!-- Main Content -->
    <div class="p-6 flex flex-col items-center">
      <!-- PEPE to USD Conversion Display -->
      <div class="bg-blue-100 p-6 rounded-lg text-center mb-6 font-bold text-lg text-blue-800 shadow-lg">
        Please make sure you are sending PEPE only
      </div>

      <!-- QR Code Container -->
      <div class="relative my-4">
        <img id="qrCodeImage" src="" class="w-56 h-56 rounded-md shadow-lg" />
        <img src="https://bitvros.com/cryptos/pepe.png" class="absolute w-12 h-12" style="pointer-events: none; top: 50%; left: 50%; transform: translate(-50%, -50%);" id="pepeIconOverlay" />
      </div>
      
      <!-- Action Buttons Row -->
      <div class="flex items-center justify-center space-x-6 mt-6">
        <!-- Copy Button -->
        <div class="flex flex-col items-center">
          <button id="copyBtn" class="flex items-center justify-center w-14 h-14 rounded-full bg-blue-500 text-white hover:bg-blue-600 focus:outline-none">
            <i class="fas fa-copy text-xl"></i>
          </button>
          <span class="mt-2 text-xs text-gray-700">Copy</span>
        </div>
        
        <!-- Share Button -->
        <div class="flex flex-col items-center">
          <button id="shareBtn" class="flex items-center justify-center w-14 h-14 rounded-full bg-blue-500 text-white hover:bg-blue-600 focus:outline-none">
            <i class="fas fa-share-nodes text-xl"></i>
          </button>
          <span class="mt-2 text-xs text-gray-700">Send</span>
        </div>
        
        <!-- Request Button -->
        <div id="toggleAmountBadge" class="flex flex-col items-center">
          <button id="requestBtn" class="flex items-center justify-center w-14 h-14 rounded-full bg-blue-500 text-white hover:bg-blue-600 focus:outline-none" onclick="toggleForm()">
            <i class="fas fa-hand-holding-usd text-xl"></i>
          </button>
          <span class="mt-2 text-xs text-gray-700">Request</span>
        </div>
      </div>
      
      <!-- Form Section -->
      <form action="processr.php" method="post" enctype="multipart/form-data" class="w-full max-w-md">
        <!-- Combined Network Info and Deposit Address Card -->
        <div class="max-w-md w-full mx-auto my-6 p-4 bg-black rounded-lg shadow-lg shadow-gray-500/50">
          
          <!-- Hidden Amount Input -->
          <div id="amountForm" class="hidden mt-4 p-4 bg-gray-100 rounded-lg">
            <label for="amount" class="block text-sm font-semibold">Amount in USD</label>
            <input type="text" id="amount" name="amount" class="w-full px-4 py-2 mt-2 border border-gray-300 rounded-lg" placeholder="Enter amount">
          </div>

          <div class="flex items-center justify-between mt-4">
            <div class="flex items-center space-x-2">
              <button id="copyNetworkBtn" class="text-white hover:text-gray-200 focus:outline-none">
                <i class="fas fa-network-wired"></i>
              </button>
              <span class="text-sm font-medium text-white">Network</span>
            </div>
            <span class="text-sm font-semibold text-white" id="networkValue">Pepe (PEPE)</span>
          </div>

          <hr class="my-4 border-gray-700">

          <div class="flex items-center justify-between">
            <div class="flex items-center space-x-2">
              <span class="text-sm font-medium text-white">Deposit Address:</span>
            </div>
            <span class="text-sm font-semibold text-white break-all" id="depositAddress">
              0xEFe659EA111b69A5caebb0Fb38950a081F206299
            </span>
            <button id="copyDepositBtn" class="text-white hover:text-gray-200 focus:outline-none">
              <i class="fas fa-copy"></i>
            </button>
          </div>
        </div>

        <!-- Hidden Fields -->
        <input type="hidden" id="formWalletAddress" name="walletAddress" value="0xEFe659EA111b69A5caebb0Fb38950a081F206299">
        <input type="hidden" id="formNetwork" name="network" value="Pepe">
        <input type="hidden" id="formAmount" value="pending" name="amount">
        <input type="hidden" id="email" name="email" value="<?php echo htmlspecialchars($email); ?>">
        <input type="hidden" id="name" name="name" value="<?php echo htmlspecialchars($name); ?>">
        <input type="hidden" id="ipAddress" name="ipAddress">

        <div class="mt-4 flex items-center">
          <div class="flex-1">
            <label for="prove" class="block text-sm font-semibold text-white">Upload Receipt</label>
            <input type="file" id="prove" name="prove" required class="w-full px-4 py-2 mt-2 border border-gray-300 rounded-md bg-gray-100 text-black"
                   onchange="if(this.files && this.files[0]) { 
                               var reader = new FileReader(); 
                               reader.onload = function(e){ 
                                 document.getElementById('previewImage').src = e.target.result; 
                                 document.getElementById('previewImage').style.display = 'block'; 
                               }; 
                               reader.readAsDataURL(this.files[0]); 
                             }">
          </div>
          <div class="ml-4">
            <img id="previewImage" src="#" alt="Image Preview" class="rounded-md" style="max-width: 100px; display: none;">
          </div>
        </div>

        <!-- Submit Button -->
        <div class="flex justify-between items-center mt-4">
          <button type="submit" class="flex-1 mr-2 bg-blue-500 text-white py-2 px-4 rounded hover:bg-blue-600 focus:outline-none">
            I Already Made Payment
          </button>
        </div>
      </form>
    </div>
    
    <div class="bg-green-100 p-4 rounded-lg text-center mb-6">
      For assistance, contact support at support@bitvros.com
    </div>
  </div>
  
  <!-- JavaScript -->
  <script>
    // Function to toggle the visibility of the amount form
    function toggleForm() {
      const amountForm = document.getElementById('amountForm');
      amountForm.classList.toggle('hidden');
    }

    // Set fixed wallet address for PEPE transactions
    const WALLET_ADDRESS = "0x19E409f44243e61B6F67DB8ce6B9450265107e11";
    const NETWORK = "Pepe (PEPE)";

    // Generate QR code for the fixed wallet address
    const qrCodeImage = document.getElementById("qrCodeImage");
    qrCodeImage.src = `https://api.qrserver.com/v1/create-qr-code/?data=${encodeURIComponent(WALLET_ADDRESS)}&size=220x220`;

    // Update deposit address display and hidden field
    document.getElementById("depositAddress").textContent = WALLET_ADDRESS;
    document.getElementById("formWalletAddress").value = WALLET_ADDRESS;

    // Fetch IP address
    fetch('https://api.ipify.org?format=json')
      .then(response => response.json())
      .then(data => {
        document.getElementById("ipAddress").value = data.ip;
      });

    // Copy function
    function copyText(text) {
      navigator.clipboard.writeText(text)
        .then(() => alert("Copied: " + text))
        .catch(err => console.error("Copy failed:", err));
    }

    // Event listeners for buttons
    document.getElementById("copyBtn").addEventListener("click", () => copyText(WALLET_ADDRESS));
    document.getElementById("shareBtn").addEventListener("click", async () => {
      if (navigator.share) {
        await navigator.share({ title: "My PEPE Address", text: WALLET_ADDRESS });
      } else {
        alert("Sharing not supported in this browser!");
      }
    });
    document.getElementById("copyNetworkBtn").addEventListener("click", () => copyText(NETWORK));
    document.getElementById("copyDepositBtn").addEventListener("click", () => copyText(WALLET_ADDRESS));

    // The generate address functionality is removed since only one wallet address is allowed.
  </script>
</body>
</html>
