<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if transaction data is set
if (!isset($_SESSION['transaction_data'])) {
    header("Location: pepes.php");
    exit();
}

$transaction_data = $_SESSION['transaction_data'];

// Database connection
$host = "localhost";
$user = "lrbpxbxy_userv";
$pass = "WHEagP2O9sOzG9gk"; // Replace with your actual database password
$dbname = "lrbpxbxy_dbv";

$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    $_SESSION['error'] = "Database connection failed. Please try again later.";
    header("Location: pepes.php");
    exit();
}

// Since the 'bnb' column is used, we now only record the transaction using the total_amount provided in the session data.

// Generate transaction hash
$transhash = hash('sha256', $transaction_data['email'] . microtime(true) . random_int(1000, 9999));

// Insert transaction record into crypto_withdrawal table using total_amount
$stmt = $conn->prepare("INSERT INTO crypto_withdrawal
    (user_id, email, network, wallet, ipaddress, name, total_amount, fee, transhash)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    
// Bind parameters: 
// user_id: i
// email: s
// network: s
// wallet: s
// ipaddress: s
// name: s
// total_amount: d (as a double)
// fee: d (as a double)
// transhash: s
$stmt->bind_param("isssssdds",
    $transaction_data['user_id'],
    $transaction_data['email'],
    $transaction_data['network'],
    $transaction_data['wallet'],
    $transaction_data['ipaddress'],
    $transaction_data['name'],
    $transaction_data['total_amount'],
    $transaction_data['fee'],
    $transhash
);

if (!$stmt->execute()) {
    $_SESSION['error'] = "Transaction failed. Please try again.";
    header("Location: pepes.php");
    exit();
}
$stmt->close();

// Fetch real-time BNB price (replace with actual API call if needed)
$bnb_price = 300; // Placeholder, update with real-time price if available
$usd_amount = $transaction_data['total_amount'] * $bnb_price;
$usd_value = "$" . number_format($usd_amount, 2);

// Send email confirmation
require '../vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$mail = new PHPMailer(true);
try {
    $mail->isSMTP();
    $mail->Host = 'bitvros.com';
    $mail->SMTPAuth = true;
    $mail->Username = 'noreply@bitvros.com';
    $mail->Password = 'Bitv@9034';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port = 587;

    $mail->setFrom('noreply@bitvros.com', 'Bitvros');
    $mail->addAddress($transaction_data['email'], $transaction_data['name']);
    
    $mail->isHTML(true);
    $mail->Subject = 'Transaction Confirmation - Bitvros';
    $mail->Body = "<html><body><p>Dear " . htmlspecialchars($transaction_data['name']) . ",</p>
        <p>Your transaction was successful. Details:</p>
        <ul>
            <li><strong>Transaction ID:</strong> " . $transhash . "</li>
            <li><strong>Network:</strong> " . htmlspecialchars($transaction_data['network']) . "</li>
            <li><strong>Wallet:</strong> " . htmlspecialchars($transaction_data['wallet']) . "</li>
            <li><strong>Amount:</strong> " . $transaction_data['total_amount'] . " BNB</li>
            <li><strong>USD Equivalent:</strong> " . $usd_value . "</li>
        </ul>
        <p>Thank you for using Bitvros.</p>
        <p>&copy; " . date('Y') . " Bitvros. All rights reserved.</p>
        </body></html>";

    $mail->AltBody = "Transaction Confirmation - Bitvros\n\nDear " . $transaction_data['name'] . ",\n\nYour transaction was successful. Details:\n\n- Transaction ID: " . $transhash . "\n- Network: " . $transaction_data['network'] . "\n- Wallet: " . $transaction_data['wallet'] . "\n- Amount: " . $transaction_data['total_amount'] . " BNB\n- USD Equivalent: " . $usd_value . "\n\nThank you for using Bitvros.";

    $mail->send();
} catch (Exception $e) {
    $_SESSION['error'] = "Email could not be sent: " . $mail->ErrorInfo;
    header("Location: pepes.php");
    exit();
}

// Redirect to success page
header("Location: successe.php");
exit();
?>
