<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database connection
$host = "localhost";
$user = "lrbpxbxy_userv";
$pass = "WHEagP2O9sOzG9gk";
$dbname = "lrbpxbxy_dbv";

$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    $_SESSION['error'] = "Database connection failed. Please try again later.";
    header("Location: usdtd.php");
    exit();
}

// Validate required fields
$required_fields = ['network', 'email', 'wallet', 'amount', 'name', 'fee'];
$missing_fields = [];

foreach ($required_fields as $field) {
    if (!isset($_POST[$field]) || trim($_POST[$field]) === '') {
        $missing_fields[] = $field;
    }
}

if (!empty($missing_fields)) {
    $_SESSION['error'] = "Missing required fields: " . implode(', ', $missing_fields);
    header("Location: usdtd.php");
    exit();
}

// Validate email
$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $_SESSION['error'] = "Invalid email format";
    header("Location: usdtd.php");
    exit();
}

// Get REAL IP address
$ipaddress = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
if (!filter_var($ipaddress, FILTER_VALIDATE_IP)) {
    $ipaddress = 'Invalid IP';
}

// Sanitize inputs
$network = $conn->real_escape_string($_POST['network']);
$wallet = $conn->real_escape_string($_POST['wallet']);
$name = $conn->real_escape_string($_POST['name']);

// Validate amounts
$usdt = bcadd($_POST['amount'], '0', 5);
$fee = bcadd($_POST['fee'], '0', 5);
$total_amount = bcadd($usdt, $fee, 5);

if (bccomp($usdt, '0', 5) <= 0 || bccomp($fee, '0', 5) < 0) {
    $_SESSION['error'] = "Invalid amount values";
    header("Location: usdtd.php");
    exit();
}

// Check user balance
$stmt = $conn->prepare("SELECT id, usdt FROM users WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    $_SESSION['error'] = "User not found";
    header("Location: usdtd.php");
    exit();
}

$user = $result->fetch_assoc();
$stmt->close();

// Check balance
if (bccomp($user['usdt'], $total_amount, 2) < 0) {
    $_SESSION['error'] = "Not enough USDT balance. Available: " . number_format($user['usdt'], 2) . " USD";
    header("Location: usdtd.php");
    exit();
}

// Store transaction data in session
$_SESSION['transaction_data'] = [
    'user_id' => $user['id'],
    'email' => $email,
    'network' => $network,
    'wallet' => $wallet,
    'usdt' => $usdt,
    'name' => $name,
    'fee' => $fee,
    'total_amount' => $total_amount,
    'ipaddress' => $ipaddress,
    'expires' => time() + 300 // 5-minute expiration
];

header("Location: confirmusdt.php");
exit();
?>