<?php
// INLINE DATABASE CONNECTION (PDO)
$dbHost = 'localhost';        // e.g. '127.0.0.1'  
$dbName = 'lrbpxbxy_dbv';    // your database name
$dbUser = 'lrbpxbxy_userv';  // your DB username
$dbPass = 'WHEagP2O9sOzG9gk';    // your DB password

// Function to encrypt URL parameters
function encryptUrlParam($value, $key = 'YourSecretKey123!') {
    $iv = openssl_random_pseudo_bytes(16);
    $encrypted = openssl_encrypt($value, 'AES-256-CBC', $key, 0, $iv);
    return urlencode(base64_encode($encrypted . '::' . base64_encode($iv)));
}

// Function to decrypt URL parameters
function decryptUrlParam($value, $key = 'YourSecretKey123!') {
    $value = base64_decode(urldecode($value));
    list($encrypted_data, $iv) = explode('::', $value, 2);
    return openssl_decrypt($encrypted_data, 'AES-256-CBC', $key, 0, base64_decode($iv));
}

try {
    $conn = new PDO(
        "mysql:host={$dbHost};dbname={$dbName};charset=utf8mb4",
        $dbUser,
        $dbPass,
        [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Process either raw or encrypted transaction ID
$encTransid = isset($_GET['etid']) ? $_GET['etid'] : '';
$transid = '';

if ($encTransid) {
    // Decrypt transaction ID if it's encrypted
    try {
        $transid = decryptUrlParam($encTransid);
    } catch (Exception $e) {
        // Handle decryption error
        error_log("Decryption error: " . $e->getMessage());
        $transid = '';
    }
} else {
    // Fallback to clear text transaction ID if provided
    $transid = isset($_GET['transid']) ? trim($_GET['transid']) : '';
}

// Set up a flag to determine if we should show animation or redirect
$showSuccessAnimation = false;
$redirectToPage = '';

if ($transid !== '') {
    // QUERY buysignal TABLE FOR THIS TRANSACTION
    $sql = "SELECT status FROM buysignal WHERE transaction_id = :transid";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':transid', $transid, PDO::PARAM_STR);
    $stmt->execute();
    $signal = $stmt->fetch();

    // Handle transaction status
    if ($signal && strtolower(trim($signal['status'])) === 'complete') {
        if (isset($_GET['ajax'])) {
            // If AJAX request, return JSON status
            header('Content-Type: application/json');
            echo json_encode(['status' => 'complete', 'redirect' => 'dashboard.php?etid=' . encryptUrlParam($transid)]);
            exit;
        } else {
            // Always show animation before redirect
            $showSuccessAnimation = true;
            $redirectToPage = 'dashboard.php?etid=' . encryptUrlParam($transid);
        }
    } else if (isset($_GET['ajax'])) {
        // Return JSON for AJAX polling
        header('Content-Type: application/json');
        $status = $signal ? strtolower(trim($signal['status'])) : 'pending';
        echo json_encode(['status' => $status]);
        exit;
    }
}

// Define constants instead of variables for configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'lrbpxbxy_userv');
define('DB_PASS', 'WHEagP2O9sOzG9gk');
define('DB_NAME', 'lrbpxbxy_dbv');

// Improved database connection function with error handling
function connectDB() {
    try {
        $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
        
        if ($conn->connect_error) {
            throw new Exception("Database connection failed: " . $conn->connect_error);
        }
        
        // Set character set to prevent SQL injection
        $conn->set_charset("utf8");
        
        return $conn;
    } catch (Exception $e) {
        // Log error instead of displaying it
        error_log($e->getMessage());
        header('Content-Type: application/json');
        echo json_encode(['error' => 'Database connection error. Please try again later.']);
        exit;
    }
}

// Secure input validation function
function validateInput($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

// Transaction status check endpoint with improved security
if (isset($_GET['action']) && $_GET['action'] == 'check_status') {
    header('Content-Type: application/json');
    
    // Validate transaction ID
    $transId = validateInput($_GET['transid'] ?? '');
    
    if (empty($transId) || !preg_match('/^[a-zA-Z0-9-]{10,64}$/', $transId)) {
        echo json_encode(['error' => 'Invalid transaction ID']);
        exit;
    }
    
    try {
        $conn = connectDB();
        
        // Prepare statement to prevent SQL injection
        $stmt = $conn->prepare("SELECT status, last_checked FROM transactions WHERE transaction_id = ?");
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }
        
        $stmt->bind_param("s", $transId);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            
            // Implement rate limiting for status checks
            $lastChecked = new DateTime($row['last_checked']);
            $now = new DateTime();
            $timeDiff = $now->getTimestamp() - $lastChecked->getTimestamp();
            
            if ($timeDiff < 2) { // Limit to one check every 2 seconds
                echo json_encode([
                    'status' => $row['status'],
                    'message' => 'Rate limit applied, please wait before checking again'
                ]);
                exit;
            }
            
            // Update last_checked timestamp
            $updateStmt = $conn->prepare("UPDATE transactions SET last_checked = NOW() WHERE transaction_id = ?");
            $updateStmt->bind_param("s", $transId);
            $updateStmt->execute();
            $updateStmt->close();
            
            echo json_encode(['status' => $row['status']]);
        } else {
            echo json_encode(['error' => 'Transaction not found']);
        }
        
        $stmt->close();
        $conn->close();
    } catch (Exception $e) {
        error_log($e->getMessage());
        echo json_encode(['error' => 'Error checking transaction status']);
    }
    exit;
}

// PDF generator endpoint with improved security and error handling
if (isset($_GET['action']) && $_GET['action'] == 'generate_pdf') {
    try {
        // Validate required parameters
        $transId = validateInput($_GET['transid'] ?? '');
        $name = urldecode(validateInput($_GET['name'] ?? ''));
        $email = urldecode(validateInput($_GET['email'] ?? ''));
        $amount = validateInput($_GET['amount'] ?? '');
        $crypto = validateInput($_GET['crypto'] ?? 'bitcoin');
        $cryptoAmount = validateInput($_GET['cryptoAmount'] ?? '');
        $date = urldecode(validateInput($_GET['date'] ?? ''));
        
        // Simple validation
        if (empty($transId) || empty($name) || empty($email) || empty($amount)) {
            throw new Exception("Missing required parameters for PDF generation");
        }
        
        // Verify transaction status in database before proceeding
        $conn = connectDB();
        $stmt = $conn->prepare("SELECT status FROM transactions WHERE transaction_id = ?");
        $stmt->bind_param("s", $transId);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 0) {
            throw new Exception("Transaction not found");
        }
        
        $row = $result->fetch_assoc();
        if ($row['status'] !== 'confirmed' && $row['status'] !== 'completed') {
            throw new Exception("Cannot generate receipt for unconfirmed transaction");
        }
        
        $stmt->close();
        $conn->close();
        
        // Load TCPDF library with error handling
        if (!file_exists('tcpdf/tcpdf.php')) {
            throw new Exception("PDF generation library not found");
        }
        
        require_once('tcpdf/tcpdf.php');
        
        // Create new PDF document
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        
        // Set document information
        $pdf->SetCreator('Crypto Payment System');
        $pdf->SetAuthor('Crypto Payment System');
        $pdf->SetTitle('Payment Receipt');
        $pdf->SetSubject('Payment Confirmation');
        
        // Set default header data
        $pdf->SetHeaderData('', 0, 'Payment Receipt', 'Transaction ID: ' . $transId);
        
        // Set margins
        $pdf->SetMargins(15, 15, 15);
        
        // Add a page
        $pdf->AddPage();
        
        // Set font
        $pdf->SetFont('helvetica', '', 12);
        
        // Add content with escaping to prevent XSS in PDF
        $html = '
        <h1>Payment Receipt</h1>
        <p><strong>Transaction ID:</strong> ' . htmlspecialchars($transId) . '</p>
        <p><strong>Name:</strong> ' . htmlspecialchars($name) . '</p>
        <p><strong>Email:</strong> ' . htmlspecialchars($email) . '</p>
        <p><strong>Amount:</strong> $' . htmlspecialchars($amount) . ' (' . htmlspecialchars($cryptoAmount) . ')</p>
        <p><strong>Cryptocurrency:</strong> ' . htmlspecialchars(ucfirst($crypto)) . '</p>
        <p><strong>Date:</strong> ' . htmlspecialchars($date) . '</p>
        <p><strong>Status:</strong> Confirmed</p>
        <p style="color:#10b981; font-size:16px; font-weight:bold;">Payment Successfully Processed</p>
        ';
        
        // Print HTML content
        $pdf->writeHTML($html, true, false, true, false, '');
        
        // Output PDF with a secure filename
        $safeTransId = preg_replace('/[^a-zA-Z0-9-]/', '', $transId);
        $pdf->Output('payment_receipt_' . $safeTransId . '.pdf', 'D');
    } catch (Exception $e) {
        error_log("PDF Generation Error: " . $e->getMessage());
        header('Content-Type: application/json');
        echo json_encode(['error' => 'Error generating PDF receipt. Please try again later.']);
    }
    exit;
}

// Additional security for transaction status verification
function verifyTransactionStatus($transId) {
    try {
        $conn = connectDB();
        $stmt = $conn->prepare("SELECT status FROM transactions WHERE transaction_id = ?");
        $stmt->bind_param("s", $transId);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $status = $row['status'];
        } else {
            $status = 'pending';
        }
        
        $stmt->close();
        $conn->close();
        return $status;
    } catch (Exception $e) {
        error_log($e->getMessage());
        return 'error';
    }
}

// Validate and sanitize URL parameters
$userId = validateInput($_GET['user_id'] ?? '');
$name = validateInput($_GET['name'] ?? '');
$email = validateInput($_GET['email'] ?? '');
$amount = validateInput($_GET['amount'] ?? '');
$signaPercent = validateInput($_GET['signa'] ?? '');
$status = validateInput($_GET['status'] ?? 'pending');
$transactionDate = validateInput($_GET['transactionDate'] ?? '');
$crypto = validateInput($_GET['crypto'] ?? 'bitcoin');
$walletAddress = validateInput($_GET['walletAddress'] ?? '');

// Additional validation
if (empty($transid) || empty($walletAddress)) {
    $error = 'Missing required transaction parameters';
} else {
    $error = '';
    
    // Check transaction status in database
    if (!empty($transid)) {
        $dbStatus = verifyTransactionStatus($transid);
        if ($dbStatus !== 'error') {
            $status = $dbStatus;
        }
    }
}

// Format date
$formattedDate = '';
if (!empty($transactionDate)) {
    $dateObj = DateTime::createFromFormat('Y-m-d H:i:s', urldecode($transactionDate));
    if ($dateObj) {
        $formattedDate = $dateObj->format('M j, Y g:i A');
    } else {
        $formattedDate = htmlspecialchars($transactionDate);
    }
}

// Function to get crypto amount with realistic rates
function getCryptoAmount($usdAmount, $cryptoType) {
    // In production, this would fetch real-time rates from an API
    $rates = [
        'bitcoin' => 0.000016,
        'ethereum' => 0.00025,
        'tether' => 1.0,
        'solana' => 0.011,
        'cardano' => 0.27,
        'dogecoin' => 1.55
    ];
    
    $rate = $rates[$cryptoType] ?? 0;
    $amount = floatval($usdAmount) * $rate;
    return number_format($amount, 6) . ' ' . strtoupper($cryptoType);
}

// Function to get cryptocurrency icon HTML
function getCryptoIcon($crypto) {
    $icons = [
        'bitcoin' => '<i class="fab fa-bitcoin" style="color: #f7931a;"></i>',
        'ethereum' => '<i class="fab fa-ethereum" style="color: #627eea;"></i>',
        'tether' => '<img src="https://coin-images.coingecko.com/coins/images/325/large/Tether.png?1696501661" alt="Tether" class="crypto-icon">',
        'solana' => '<img src="https://bitvros.com/cryptos/sol.png" alt="Solana" class="crypto-icon">',
        
        'cardano' => '<img src="https://bitvros.com/cryptos/ada.png" alt="Cardano" class="crypto-icon">',
        'dogecoin' => '<img src="https://bitvros.com/cryptos/doge.png" alt="Dogecoin" class="crypto-icon">'
    ];
    
    return $icons[$crypto] ?? '';
}

// Safe calculation of crypto amount
$cryptoAmount = getCryptoAmount($amount, $crypto);
$cryptoIcon = getCryptoIcon($crypto);
$statusColor = $status === 'pending' ? '#f59e0b' : '#10b981';

// Anti-CSRF Token Generation
$csrfToken = bin2hex(random_bytes(32));
$_SESSION['csrf_token'] = $csrfToken;
?>

      <!-- Hidden Google Translate Element with Improved Styling -->
<style>
  /* Hide Google Translate widget and branding */
  .goog-te-banner-frame,
  .goog-te-balloon-frame,
  #goog-gt-tt,
  .goog-te-menu-value span,
  .VIpgJd-ZVi9od-l4eHX-hSRGPd,
  .VIpgJd-ZVi9od-aZ2wEe-wOHMyf,
  .VIpgJd-ZVi9od-aZ2wEe-OiiCO {
    display: none !important;
  }
  
  /* Hide the default Google Translate dropdown container */
  #google_translate_element {
    position: absolute;
    overflow: hidden;
    height: 0;
    visibility: hidden;
    opacity: 0;
  }
  
  /* Remove Google frame affecting site layout */
  body {
    top: 0 !important;
  }
  
  /* Fix for any shifted elements after translation */
  .skiptranslate,
  .goog-tooltip,
  .goog-tooltip:hover {
    display: none !important;
  }

  /* Custom language indicator styles, if you want to show it */
  .language-indicator {
    position: fixed;
    bottom: 20px;
    right: 20px;
    background: rgba(255, 255, 255, 0.9);
    padding: 8px 15px;
    border-radius: 50px;
    font-size: 12px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    z-index: 9999;
    opacity: 0.8;
    transition: opacity 0.3s;
    display: none; /* Hidden by default */
  }
  
  .language-indicator:hover {
    opacity: 1;
  }
</style>

<!-- Hidden Google Translate element -->
<div id="google_translate_element"></div>

<!-- Optional: Language indicator (uncomment to enable) -->
<!-- <div class="language-indicator">Translated to: <span id="current-language">English</span></div> -->

<script type="text/javascript">
  // Improved Google Translate implementation
  class SmartTranslator {
    constructor(options = {}) {
      this.options = {
        pageLanguage: 'en',
        autoDisplay: false,
        excludedCountries: ['IN', 'GH', 'LK'],
        cookieName: 'preferred_language',
        cookieExpiry: 30, // days
        debug: false,
        ...options
      };
      
      this.countryLangMap = {
        'US': 'en', 'CA': 'en', 'GB': 'en', 'AU': 'en', 'NZ': 'en', 'IE': 'en',
        'FR': 'fr', 'BE': 'nl', 'NL': 'nl', 'DE': 'de', 'AT': 'de', 'CH': 'de',
        'IT': 'it', 'ES': 'es', 'PT': 'pt', 'BR': 'pt', 'MX': 'es', 'AR': 'es',
        'CL': 'es', 'CO': 'es', 'PE': 'es', 'VE': 'es', 'EC': 'es', 'RU': 'ru',
        'PL': 'pl', 'CZ': 'cs', 'SK': 'sk', 'HU': 'hu', 'RO': 'ro', 'BG': 'bg',
        'GR': 'el', 'TR': 'tr', 'IL': 'he', 'SA': 'ar', 'AE': 'ar', 'EG': 'ar',
        'IN': 'hi', 'PK': 'ur', 'BD': 'bn', 'LK': 'si', 'NP': 'ne', 'ID': 'id',
        'MY': 'ms', 'PH': 'fil', 'TH': 'th', 'VN': 'vi', 'KR': 'ko', 'JP': 'ja',
        'CN': 'zh-CN', 'TW': 'zh-TW', 'HK': 'zh-TW', 'SG': 'en', 'FI': 'fi',
        'SE': 'sv', 'NO': 'no', 'DK': 'da', 'IS': 'is', 'EE': 'et', 'LV': 'lv',
        'LT': 'lt'
      };
      
      this.languageNames = {
        'en': 'English', 'fr': 'Français', 'es': 'Español', 'de': 'Deutsch',
        'it': 'Italiano', 'pt': 'Português', 'ru': 'Русский', 'ja': 'Japanese',
        'zh-CN': 'Chinese (Simplified)', 'zh-TW': 'Chinese (Traditional)',
        'ko': 'Korean', 'ar': 'Arabic', 'hi': 'Hindi', 'nl': 'Dutch'
        // Add more as needed
      };
      
      this.init();
    }
    
    init() {
      // Initialize after DOM is ready
      if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', () => this.setup());
      } else {
        this.setup();
      }
    }
    
    setup() {
      this.log('Initializing translator');
      
      // First check saved preference
      const savedLang = this.getCookie(this.options.cookieName);
      
      if (savedLang) {
        this.log(`Found saved language preference: ${savedLang}`);
        this.initTranslate(() => this.translateTo(savedLang));
      } else {
        // Otherwise detect based on location
        this.detectLanguage()
          .then(lang => {
            if (lang) {
              this.log(`Detected language: ${lang}`);
              this.initTranslate(() => this.translateTo(lang));
            } else {
              this.log('No translation needed');
              this.initTranslate(); // Just initialize without translating
            }
          })
          .catch(err => {
            this.log('Error detecting language:', err);
            this.initTranslate();
          });
      }
      
      // Remove Google's top bar effect after translation
      this.fixTopBarEffect();
    }
    
    initTranslate(callback) {
      // Create script element to load Google Translate
      const script = document.createElement('script');
      script.src = '//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit';
      script.async = true;
      
      // Define the callback function for Google Translate
      window.googleTranslateElementInit = () => {
        new google.translate.TranslateElement({
          pageLanguage: this.options.pageLanguage,
          autoDisplay: this.options.autoDisplay
        }, 'google_translate_element');
        
        if (callback) {
          // Give time for Google Translate to initialize
          setTimeout(callback, 1000);
        }
      };
      
      document.body.appendChild(script);
    }
    
    detectLanguage() {
      return fetch('https://ipapi.co/json/')
        .then(response => response.json())
        .then(data => {
          if (data && data.country) {
            if (this.options.excludedCountries.includes(data.country)) {
              return null; // Don't translate for excluded countries
            }
            return this.countryLangMap[data.country] || null;
          }
          return null;
        })
        .catch(error => {
          this.log('IP detection failed:', error);
          return null;
        });
    }
    
    translateTo(language) {
      if (!language) return;
      
      this.log(`Translating to: ${language}`);
      
      // Save preference
      this.setCookie(this.options.cookieName, language, this.options.cookieExpiry);
      
      let attempts = 0;
      const maxAttempts = 20;
      const intervalId = setInterval(() => {
        const comboBox = document.querySelector('.goog-te-combo');
        if (comboBox) {
          comboBox.value = language;
          comboBox.dispatchEvent(new Event('change'));
          clearInterval(intervalId);
          
          // Update language indicator if it exists
          const indicator = document.getElementById('current-language');
          if (indicator) {
            indicator.textContent = this.languageNames[language] || language;
            indicator.parentElement.style.display = 'block';
          }
        } else if (++attempts >= maxAttempts) {
          this.log('Failed to find translation dropdown');
          clearInterval(intervalId);
        }
      }, 500);
    }
    
    fixTopBarEffect() {
      // Monitor and fix Google's modification to the body tag
      const observer = new MutationObserver((mutations) => {
        mutations.forEach((mutation) => {
          if (mutation.target.nodeName === 'BODY' && 
              mutation.target.style.top && 
              mutation.target.style.top !== '0px') {
            mutation.target.style.top = '0px';
          }
        });
      });
      
      observer.observe(document.body, { 
        attributes: true, 
        attributeFilter: ['style'] 
      });
      
      // Additional fix for Google's top bar
      setInterval(() => {
        if (document.body.style.top !== '' && document.body.style.top !== '0px') {
          document.body.style.top = '0px';
        }
      }, 1000);
    }
    
    // Helper functions
    getCookie(name) {
      const match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
      return match ? match[2] : null;
    }
    
    setCookie(name, value, days) {
      let expires = '';
      if (days) {
        const date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        expires = '; expires=' + date.toUTCString();
      }
      document.cookie = name + '=' + value + expires + '; path=/; SameSite=Lax';
    }
    
    log(...args) {
      if (this.options.debug) {
        console.log('SmartTranslator:', ...args);
      }
    }
  }

  // Initialize the translator
  document.addEventListener('DOMContentLoaded', () => {
    new SmartTranslator({
      excludedCountries: ['IN', 'GH', 'LK'],
      debug: false // Set to true for debugging
    });
  });
</script>
      

    <style>
        /* Success Animation Modal Styles */
        #successModal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.7);
            z-index: 9999;
            justify-content: center;
            align-items: center;
        }
        
        .success-content {
            background-color: white;
            padding: 40px;
            border-radius: 10px;
            text-align: center;
            max-width: 500px;
            width: 90%;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            animation: modalFadeIn 0.5s ease-out forwards;
        }
        
        @keyframes modalFadeIn {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .checkmark-circle {
            width: 100px;
            height: 100px;
            position: relative;
            margin: 0 auto 25px;
        }
        
        .checkmark-circle-bg {
            stroke-dasharray: 166;
            stroke-dashoffset: 166;
            stroke-width: 2;
            stroke-miterlimit: 10;
            stroke: #10b981;
            fill: none;
            animation: stroke 0.6s cubic-bezier(0.65, 0, 0.45, 1) forwards;
        }
        
        @keyframes stroke {
            100% { stroke-dashoffset: 0; }
        }
        
        .checkmark {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: block;
            stroke-width: 2;
            stroke: #fff;
            stroke-miterlimit: 10;
            margin: 10% auto;
            box-shadow: inset 0px 0px 0px #10b981;
            animation: fill 0.4s ease-in-out 0.4s forwards, scale 0.3s ease-in-out 0.9s both;
        }
        
        @keyframes fill {
            100% { box-shadow: inset 0px 0px 0px 50px #10b981; }
        }
        
        @keyframes scale {
            0%, 100% { transform: none; }
            50% { transform: scale3d(1.1, 1.1, 1); }
        }
        
        .checkmark-check {
            transform-origin: 50% 50%;
            stroke-dasharray: 48;
            stroke-dashoffset: 48;
            animation: stroke 0.3s cubic-bezier(0.65, 0, 0.45, 1) 0.8s forwards;
        }
        
        .success-message h2 {
            color: #0f172a;
            font-size: 28px;
            margin-bottom: 15px;
            font-weight: 700;
            animation: messageSlideIn 0.5s ease-out 0.5s forwards;
            opacity: 0;
            transform: translateY(10px);
        }
        
        .success-message p {
            color: #64748b;
            font-size: 18px;
            margin-bottom: 25px;
            animation: messageSlideIn 0.5s ease-out 0.7s forwards;
            opacity: 0;
            transform: translateY(10px);
        }
        
        @keyframes messageSlideIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .success-amount {
            font-size: 24px;
            font-weight: 700;
            color: #10b981;
            margin: 20px 0;
            animation: messageSlideIn 0.5s ease-out 0.9s forwards;
            opacity: 0;
        }
        
        .success-date {
            color: #64748b;
            font-size: 16px;
            margin-bottom: 30px;
            animation: messageSlideIn 0.5s ease-out 1.1s forwards;
            opacity: 0;
        }
        
        .transaction-id {
            background-color: #f1f5f9;
            padding: 10px 15px;
            border-radius: 5px;
            font-family: monospace;
            font-size: 14px;
            color: #334155;
            margin-bottom: 30px;
            animation: messageSlideIn 0.5s ease-out 1.3s forwards;
            opacity: 0;
            word-break: break-all;
        }
    </style>

    <!-- Success Modal -->
    <?php if ($showSuccessAnimation): ?>
    <div id="successModal" style="display: flex;">
        <div class="success-content">
            <div class="checkmark-circle">
                <svg class="checkmark" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 52 52">
                    <circle class="checkmark-circle-bg" cx="26" cy="26" r="25" fill="none"/>
                    <path class="checkmark-check" fill="none" d="M14.1 27.2l7.1 7.2 16.7-16.8"/>
                </svg>
            </div>
            <div class="success-message">
                <h2>Payment Verified!</h2>
                <p>Congratulations! Your payment has been successfully processed.</p>
                
                <?php if (!empty($amount)): ?>
                <div class="success-amount">$<?php echo htmlspecialchars($amount); ?> (<?php echo htmlspecialchars($cryptoAmount); ?>)</div>
                <?php endif; ?>
                
                <?php if (!empty($formattedDate)): ?>
                <div class="success-date"><?php echo htmlspecialchars($formattedDate); ?></div>
                <?php endif; ?>
                
                <?php if (!empty($transid)): ?>
                <div class="transaction-id">
                    Transaction ID: <?php echo htmlspecialchars($transid); ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <script>
        // Redirect after animation completes
        setTimeout(function() {
            window.location.href = "<?php echo htmlspecialchars($redirectToPage); ?>";
        }, 6500); // Redirect after 6 seconds
    </script>
    <?php endif; ?>

    <!-- Rest of your page content here -->
    <!-- This content will only be briefly visible before the animation takes over if status is complete -->
    
    <?php if (!$showSuccessAnimation && $status === 'pending'): ?>
    <!-- JavaScript to poll for transaction status -->
    <script>
        // Poll for transaction status every 2 seconds
        function pollTransactionStatus() {
            const transactionId = "<?php echo htmlspecialchars($transid); ?>";
            if (!transactionId) return;
            
            fetch(`?action=check_status&transid=${transactionId}&ajax=1`)
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'complete' || data.status === 'confirmed' || data.status === 'completed') {
                        // Reload the page with animation flag to show success animation
                        window.location.href = window.location.pathname + 
                            "?transid=" + transactionId + "&animate=1";
                    }
                })
                .catch(error => console.error('Error polling status:', error));
        }
        
        // Start polling when page loads
        setInterval(pollTransactionStatus, 2000);
    </script>
    <?php endif; ?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-Content-Security-Policy" content="default-src 'self'; script-src 'self' https://cdnjs.cloudflare.com; style-src 'self' 'unsafe-inline' https://cdnjs.cloudflare.com; font-src 'self' https://cdnjs.cloudflare.com; img-src 'self' data: /api/placeholder/;">
    <title>Crypto Payment Verification</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js" integrity="sha512-CNgIRecGo7nphbeZ04Sc13ka07paqdeTu0WR1IM4kNcpmBAUSHSQX0FslNhTDadL4O5SAGapGt4FodqL8My0mA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js" integrity="sha512-qZvrmS2ekKPF2mSznTQsxqPgnpkI4DNTlrdUmTzrDgektczlKLRRhRvkZpThj5rlWeCN7e6ik8F8335menFJeQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js" integrity="sha512-BNaRQnYJYiPSqHHDb58B0yaPfCu+Wgds8Gp/gU33kqBtgNS4tSPHuGibyoeqMV/TJlSKda6FXzoEyYGjTe+vXA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <!-- Added Animate.css for animations -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    <style>
        :root {
            --custom-purple: #6d28d9;
            --purple-700: #5b21b6;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
            background-color: #f3f4f6;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        
        .container {
            max-width: 600px;
            width: 100%;
            padding: 16px;
        }
        
        .step-content {
            background-color: white;
            padding: 24px;
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }
        
        .qr-container {
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            margin-bottom: 24px;
        }
        
        #qrcode {
            margin-bottom: 16px;
            width: 200px;
            height: 200px;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        
        .bg-gray-100 {
            background-color: #f3f4f6;
            border-radius: 8px;
            padding: 12px;
            display: flex;
            align-items: center;
            width: 100%;
            max-width: 400px;
        }

        input[type="text"] {
            background-color: transparent;
            flex-grow: 1;
            border: none;
            outline: none;
            font-family: monospace;
            font-size: 14px;
            color: #1f2937;
        }
        
        .copy-address {
            margin-left: 8px;
            color: #4b5563;
            background: none;
            border: none;
            cursor: pointer;
        }
        
        .copy-address:hover {
            color: var(--custom-purple);
        }
        
        .copy-success {
            margin-top: 8px;
            color: #10b981;
            font-size: 14px;
            font-weight: 500;
        }
        
        .hidden {
            display: none;
        }
        
        .countdown-timer {
            display: flex;
            justify-content: center;
            gap: 16px;
            margin: 24px 0;
        }
        
        .countdown-item {
            text-align: center;
        }
        
        .countdown-value {
            font-size: 32px;
            font-weight: bold;
            background-color: #1f2937;
            color: white;
            border-radius: 8px;
            width: 60px;
            height: 60px;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        
        .countdown-label {
            margin-top: 8px;
            color: #6b7280;
            font-size: 12px;
        }
        
        .text-custom-purple {
            color: var(--custom-purple);
        }
        
        .font-medium {
            font-weight: 500;
        }
        
        .flex {
            display: flex;
        }
        
        .space-x-4 > * + * {
            margin-left: 16px;
        }
        
        button {
            border: none;
            cursor: pointer;
            font-weight: bold;
            border-radius: 8px;
            transition: all 0.2s;
        }
        
        #btn-back-signal {
            width: 50%;
            padding: 12px 24px;
            background-color: #e5e7eb;
            color: #4b5563;
        }
        
        #btn-back-signal:hover {
            background-color: #d1d5db;
        }
        
        #btn-next-checkout {
            width: 50%;
            padding: 12px 24px;
            background-color: var(--custom-purple);
            color: white;
            box-shadow: 0 4px 6px rgba(109, 40, 217, 0.2);
        }
        
        #btn-next-checkout:hover {
            background-color: var(--purple-700);
        }
        
        /* Payment Status Steps */
        .payment-status-steps {
            margin: 30px 0;
        }
        
        .payment-status-step {
            display: flex;
            align-items: flex-start;
            margin-bottom: 16px;
            opacity: 0.5;
            transition: opacity 0.5s ease;
        }
        
        .payment-status-step.active,
        .payment-status-step.loading {
            opacity: 1;
        }
        
        .status-icon {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            background-color: #e5e7eb;
            display: flex;
            justify-content: center;
            align-items: center;
            margin-right: 12px;
            flex-shrink: 0;
            color: #9ca3af;
            transition: background-color 0.5s ease, color 0.5s ease;
        }
        
        .payment-status-step.active .status-icon {
            background-color: #10b981;
            color: white;
        }
        
        .payment-status-step.loading .status-icon {
            background-color: var(--custom-purple);
            color: white;
        }
        
        .spinner {
            animation: spin 1.5s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .payment-confirmation {
            background-color: #ecfdf5;
            border-radius: 8px;
            padding: 16px;
            text-align: center;
            margin-bottom: 24px;
        }
        
        .text-green-500 {
            color: #10b981;
        }
        
        .text-green-600 {
            color: #059669;
        }
        
        .bg-gray-50 {
            background-color: #f9fafb;
            padding: 16px;
            border-radius: 8px;
            border: 1px solid #e5e7eb;
            margin-bottom: 24px;
        }
        
        .grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 8px;
        }
        
        .text-gray-600 {
            color: #4b5563;
        }
        
        .truncate {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        
        .btn-full {
            width: 100%;
            padding: 16px 24px;
            background-color: var(--custom-purple);
            color: white;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(109, 40, 217, 0.2);
            transition: all 0.2s;
            margin-bottom: 12px;
        }
        
        .btn-full:hover {
            background-color: var(--purple-700);
        }

        .btn-secondary {
            background-color: #f3f4f6;
            color: #4b5563;
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05);
        }
        
        .btn-secondary:hover {
            background-color: #e5e7eb;
        }
        
        .animate-spin {
            animation: spin 1s linear infinite;
            height: 48px;
            width: 48px;
            border-radius: 50%;
            border: 2px solid #e5e7eb;
            border-bottom-color: var(--custom-purple);
        }

        .notification {
            padding: 16px;
            margin: 16px 0;
            border-radius: 8px;
            text-align: center;
        }

        .notification.error {
            background-color: #fef2f2;
            color: #ef4444;
            border: 1px solid #fee2e2;
        }

        .notification.success {
            background-color: #ecfdf5;
            color: #10b981;
            border: 1px solid #d1fae5;
        }

        .crypto-icon {
            width: 24px;
            height: 24px;
            margin-right: 8px;
            display: inline-block;
            vertical-align: middle;
        }
        
        /* Share menu styles */
        .share-menu {
            position: relative;
            display: inline-block;
        }
        
        .share-dropdown {
            position: absolute;
            bottom: 100%;
            right: 0;
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
            padding: 8px 0;
            min-width: 180px;
            z-index: 10;
            margin-bottom: 8px;
        }
        
        .share-option {
            padding: 8px 16px;
            display: flex;
            align-items: center;
            cursor: pointer;
            transition: background-color 0.2s;
        }
        
        .share-option:hover {
            background-color: #f3f4f6;
        }
        
        .share-option i {
            margin-right: 12px;
            width: 16px;
            text-align: center;
        }
        
        /* Receipt styling for PDF */
        #receipt-container {
            position: absolute;
            left: -9999px;
            top: -9999px;
            background-color: white;
            padding: 40px;
            width: 800px;
        }
        
        #receipt-content {
            border: 1px solid #e5e7eb;
            padding: 40px;
            border-radius: 8px;
            max-width: 600px;
            margin: 0 auto;
        }
        
        #receipt-content h1 {
            color: #1f2937;
            font-size: 24px;
            margin-bottom: 24px;
            text-align: center;
        }
        
        #receipt-content .receipt-logo {
            text-align: center;
            margin-bottom: 24px;
        }
        
        #receipt-content .receipt-details {
            margin-bottom: 24px;
        }
        
        #receipt-content .receipt-details-row {
            display: flex;
            padding: 8px 0;
            border-bottom: 1px solid #f3f4f6;
        }
        
        #receipt-content .receipt-label {
            width: 40%;
            color: #6b7280;
            font-weight: 500;
        }
        
        #receipt-content .receipt-value {
            width: 60%;
            font-weight: 500;
            color: #1f2937;
        }
        
        #receipt-content .receipt-footer {
            margin-top: 40px;
            text-align: center;
            color: #6b7280;
        }
        
        .receipt-success {
            color: #10b981;
            text-align: center;
            font-weight: bold;
            font-size: 18px;
            margin: 24px 0;
        }
        
        /* Error display */
        .error-container {
            background-color: #fef2f2;
            color: #b91c1c;
            padding: 16px;
            border-radius: 8px;
            margin-bottom: 24px;
            text-align: center;
        }
        
       
.success-modal {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.6);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 999;
    opacity: 0;
    visibility: hidden;
    transition: opacity 0.3s ease, visibility 0.3s ease;
}

.success-modal.show {
    opacity: 1;
    visibility: visible;
}

.success-modal-content {
    background-color: white;
    border-radius: 12px;
    padding: 32px;
    text-align: center;
    max-width: 480px;
    width: 90%;
    transform: translateY(20px);
    transition: transform 0.3s ease;
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
}

.success-modal.show .success-modal-content {
    transform: translateY(0);
}

.success-icon {
    width: 80px;
    height: 80px;
    background-color: #d1fae5;
    border-radius: 50%;
    display: flex;
    justify-content: center;
    align-items: center;
    margin: 0 auto 24px;
}

.success-icon i {
    font-size: 40px;
    color: #10b981;
}

.success-title {
    font-size: 24px;
    font-weight: bold;
    color: #1f2937;
    margin-bottom: 16px;
}

.success-message {
    color: #6b7280;
    margin-bottom: 24px;
}

.success-button {
    background-color: var(--custom-purple);
    color: white;
    padding: 12px 24px;
    border-radius: 8px;
    font-weight: 500;
    cursor: pointer;
    transition: background-color 0.2s;
}

.success-button:hover {
    background-color: var(--purple-700);
}

@media (max-width: 640px) {
    .countdown-timer {
        gap: 8px;
    }
    
    .countdown-value {
        font-size: 24px;
        width: 48px;
        height: 48px;
    }
    
    .grid {
        grid-template-columns: 1fr;
    }
}
    </style>
    <link rel="icon" href="https://bitvros.com/session/faviconb.png" type="image/x-icon">
</head>
<body>
    <div class="container">
        <?php if (!empty($error)): ?>
            <div class="error-container">
                <i class="fas fa-exclamation-circle"></i>
                <p><?php echo htmlspecialchars($error); ?></p>
            </div>
        <?php else: ?>
            <?php if ($status === 'pending'): ?>
                <!-- Step 1: Payment Scanner -->
                <div class="step-content" id="step-payment-scanner">
                    <h2 class="text-custom-purple font-medium" style="text-align: center; margin-bottom: 16px;">
                        Scan QR Code to Complete Payment
                    </h2>
                    
                    <div class="qr-container">
                        <div id="qrcode"></div>
                        <p style="margin-bottom: 8px; color: #4b5563;">Or copy wallet address</p>
                        <div class="bg-gray-100">
                            <input type="text" id="wallet-address" readonly value="<?php echo htmlspecialchars($walletAddress); ?>">
                            <button class="copy-address" id="btn-copy-address" aria-label="Copy address">
                                <i class="far fa-copy"></i>
                            </button>
                        </div>
                        <span class="copy-success hidden" id="copy-success">Address copied!</span>
                    </div>
                    
                    <div style="text-align: center; margin-bottom: 24px;">
                        <p class="font-medium" style="margin-bottom: 8px;">Send exactly:</p>
                        <h3 style="margin: 0; font-size: 20px; color: var(--custom-purple);">
                            <?php echo $cryptoIcon; ?> <?php echo htmlspecialchars($cryptoAmount); ?>
                        </h3>
                        <p style="color: #6b7280; margin-top: 8px;">≈ $<?php echo htmlspecialchars($amount); ?> USD</p>
                    </div>
                    
                    <div class="countdown-timer">
                        <div class="countdown-item">
                            <div class="countdown-value" id="countdown-minutes">15</div>
                            <div class="countdown-label">Minutes</div>
                        </div>
                        <div class="countdown-item">
                            <div class="countdown-value" id="countdown-seconds">00</div>
                            <div class="countdown-label">Seconds</div>
                        </div>
                    </div>
                    
                    <div class="payment-status-steps">
                        <div class="payment-status-step active">
                            <div class="status-icon">
                                <i class="fas fa-check"></i>
                            </div>
                            <div>
                                <h4 style="margin: 0; font-size: 16px;">Transaction Initialized</h4>
                                <p style="margin: 4px 0 0; color: #6b7280; font-size: 14px;">Payment session created successfully</p>
                            </div>
                        </div>
                        
                        <div class="payment-status-step loading" id="status-waiting">
                            <div class="status-icon">
                                <i class="fas fa-spinner spinner"></i>
                            </div>
                            <div>
                                <h4 style="margin: 0; font-size: 16px;">Waiting for Payment</h4>
                                <p style="margin: 4px 0 0; color: #6b7280; font-size: 14px;">Please complete the payment</p>
                            </div>
                        </div>
                        
                        <div class="payment-status-step" id="status-confirmation">
                            <div class="status-icon">
                                <i class="fas fa-shield-alt"></i>
                            </div>
                            <div>
                                <h4 style="margin: 0; font-size: 16px;">Network Confirmation</h4>
                                <p style="margin: 4px 0 0; color: #6b7280; font-size: 14px;">Verifying on blockchain</p>
                            </div>
                        </div>
                        
                        <div class="payment-status-step" id="status-complete">
                            <div class="status-icon">
                                <i class="fas fa-check-double"></i>
                            </div>
                            <div>
                                <h4 style="margin: 0; font-size: 16px;">Payment Complete</h4>
                                <p style="margin: 4px 0 0; color: #6b7280; font-size: 14px;">Transaction successfully processed</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Navigation Buttons -->
                <div class="flex space-x-4">
                    <button id="btn-back-signal">Back</button>
                    <button id="btn-next-checkout" disabled>Waiting for Payment...</button>
                </div>
            <?php else: ?>
                <!-- Step 2: Payment Confirmed -->
                <div class="step-content" id="step-payment-confirmed">
                    <div class="payment-confirmation">
                        <i class="fas fa-check-circle text-green-500" style="font-size: 48px; margin-bottom: 16px;"></i>
                        <h2 class="text-green-600" style="margin: 0 0 8px;">Payment Confirmed</h2>
                        <p style="margin: 0; color: #059669;">Your transaction has been successfully processed</p>
                    </div>
                    
                    <div class="bg-gray-50">
                        <p style="margin-top: 0; font-weight: 500; margin-bottom: 16px;">Transaction Details</p>
                        <div class="grid">
                            <div class="text-gray-600">Amount:</div>
                            <div>$<?php echo htmlspecialchars($amount); ?> USD</div>
                            
                            <div class="text-gray-600">Cryptocurrency:</div>
                            <div><?php echo $cryptoIcon; ?> <?php echo htmlspecialchars(ucfirst($crypto)); ?></div>
                            
                            <div class="text-gray-600">Crypto Amount:</div>
                            <div><?php echo htmlspecialchars($cryptoAmount); ?></div>
                            
                            <div class="text-gray-600">Date:</div>
                            <div><?php echo htmlspecialchars($formattedDate); ?></div>
                            
                            <div class="text-gray-600">Transaction ID:</div>
                            <div class="truncate"><?php echo htmlspecialchars($transid); ?></div>
                            
                            <div class="text-gray-600">Status:</div>
                            <div style="color: <?php echo $statusColor; ?>; font-weight: 500;">
                                <?php echo htmlspecialchars(ucfirst($status)); ?>
                            </div>
                        </div>
                    </div>
                    
                    <button id="btn-view-dashboard" class="btn-full">Go to Dashboard</button>
                    
                    <div style="display: flex; gap: 16px;">
                        <button id="btn-download-receipt" class="btn-full btn-secondary">
                            <i class="fas fa-download" style="margin-right: 8px;"></i> Download Receipt
                        </button>
                        
                        <div class="share-menu" style="position: relative; width: 100%;">
                            <button id="btn-share" class="btn-full btn-secondary">
                                <i class="fas fa-share-alt" style="margin-right: 8px;"></i> Share
                            </button>
                            
                            <div class="share-dropdown hidden" id="share-dropdown">
                                <div class="share-option" id="share-email">
                                    <i class="fas fa-envelope"></i> Email
                                </div>
                                <div class="share-option" id="share-whatsapp">
                                    <i class="fab fa-whatsapp"></i> WhatsApp
                                </div>
                                <div class="share-option" id="share-telegram">
                                    <i class="fab fa-telegram-plane"></i> Telegram
                                </div>
                                <div class="share-option" id="share-copy">
                                    <i class="far fa-copy"></i> Copy Link
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
    
    <!-- Success Animation Modal -->
    <div class="success-modal" id="success-modal">
        <div class="success-modal-content">
            <div class="success-icon">
                <i class="fas fa-check"></i>
            </div>
            <h2 class="success-title">Payment Successful!</h2>
            <p class="success-message">Your cryptocurrency payment has been successfully processed and confirmed.</p>
            <button class="success-button" id="success-button">Continue to Dashboard</button>
        </div>
    </div>
    
    <!-- Hidden receipt container for PDF export -->
    <div id="receipt-container" style="display: none;">
        <div id="receipt-content">
            <div class="receipt-logo">
                <h2>Crypto Payment System</h2>
            </div>
            
            <h1>Payment Receipt</h1>
            
            <div class="receipt-details">
                <div class="receipt-details-row">
                    <div class="receipt-label">Transaction ID:</div>
                    <div class="receipt-value"><?php echo htmlspecialchars($transid); ?></div>
                </div>
                
                <div class="receipt-details-row">
                    <div class="receipt-label">Amount:</div>
                    <div class="receipt-value">$<?php echo htmlspecialchars($amount); ?> USD</div>
                </div>
                
                <div class="receipt-details-row">
                    <div class="receipt-label">Cryptocurrency:</div>
                    <div class="receipt-value"><?php echo htmlspecialchars(ucfirst($crypto)); ?></div>
                </div>
                
                <div class="receipt-details-row">
                    <div class="receipt-label">Crypto Amount:</div>
                    <div class="receipt-value"><?php echo htmlspecialchars($cryptoAmount); ?></div>
                </div>
                
                <div class="receipt-details-row">
                    <div class="receipt-label">Date:</div>
                    <div class="receipt-value"><?php echo htmlspecialchars($formattedDate); ?></div>
                </div>
                
                <div class="receipt-details-row">
                    <div class="receipt-label">Status:</div>
                    <div class="receipt-value"><?php echo htmlspecialchars(ucfirst($status)); ?></div>
                </div>
                
                <?php if (!empty($name)): ?>
                <div class="receipt-details-row">
                    <div class="receipt-label">Name:</div>
                    <div class="receipt-value"><?php echo htmlspecialchars($name); ?></div>
                </div>
                <?php endif; ?>
                
                <?php if (!empty($email)): ?>
                <div class="receipt-details-row">
                    <div class="receipt-label">Email:</div>
                    <div class="receipt-value"><?php echo htmlspecialchars($email); ?></div>
                </div>
                <?php endif; ?>
            </div>
            
            <div class="receipt-success">Payment Successfully Processed</div>
            
            <div class="receipt-footer">
                <p>Thank you for your payment.</p>
            </div>
        </div>
    </div>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize QR code if wallet address exists
            const walletAddress = '<?php echo htmlspecialchars($walletAddress); ?>';
            const transactionId = '<?php echo htmlspecialchars($transid); ?>';
            const qrcodeElement = document.getElementById('qrcode');
            
            if (walletAddress && qrcodeElement) {
                new QRCode(qrcodeElement, {
                    text: walletAddress,
                    width: 200,
                    height: 200,
                    colorDark: "#1f2937",
                    colorLight: "#ffffff",
                    correctLevel: QRCode.CorrectLevel.H
                });
            }
            
            // Copy wallet address functionality
            const btnCopy = document.getElementById('btn-copy-address');
            const copySuccess = document.getElementById('copy-success');
            
            if (btnCopy) {
                btnCopy.addEventListener('click', function() {
                    const walletAddressInput = document.getElementById('wallet-address');
                    walletAddressInput.select();
                    document.execCommand('copy');
                    
                    // Show success message
                    copySuccess.classList.remove('hidden');
                    setTimeout(() => {
                        copySuccess.classList.add('hidden');
                    }, 2000);
                });
            }
            
            // Countdown timer
            let countdown;
            const countdownMinutes = document.getElementById('countdown-minutes');
            const countdownSeconds = document.getElementById('countdown-seconds');
            
            if (countdownMinutes && countdownSeconds) {
                let timeLeft = 15 * 60; // 15 minutes in seconds
                
                countdown = setInterval(function() {
                    if (timeLeft <= 0) {
                        clearInterval(countdown);
                        // Handle expired timer
                        alert('Payment session expired. Please refresh the page to start again.');
                        return;
                    }
                    
                    const minutes = Math.floor(timeLeft / 60);
                    const seconds = timeLeft % 60;
                    
                    countdownMinutes.textContent = minutes.toString().padStart(2, '0');
                    countdownSeconds.textContent = seconds.toString().padStart(2, '0');
                    
                    timeLeft--;
                }, 1000);
            }
            
            // Poll for payment status
            let statusCheckInterval;
            
            if (transactionId && document.getElementById('status-waiting')) {
                statusCheckInterval = setInterval(function() {
                    fetch(`?action=check_status&transid=${encodeURIComponent(transactionId)}&ajax=1`)
                        .then(response => response.json())
                        .then(data => {
                            if (data.status === 'confirmed' || data.status === 'processing') {
                                // Update UI for confirmation step
                                document.getElementById('status-waiting').classList.remove('loading');
                                document.getElementById('status-waiting').classList.add('active');
                                document.getElementById('status-confirmation').classList.add('loading');
                                document.getElementById('btn-next-checkout').textContent = 'Processing...';
                            } else if (data.status === 'complete' || data.status === 'completed') {
                                // Complete all steps
                                clearInterval(statusCheckInterval);
                                document.getElementById('status-waiting').classList.remove('loading');
                                document.getElementById('status-waiting').classList.add('active');
                                document.getElementById('status-confirmation').classList.remove('loading');
                                document.getElementById('status-confirmation').classList.add('active');
                                document.getElementById('status-complete').classList.add('active');
                                document.getElementById('btn-next-checkout').textContent = 'Continue';
                                document.getElementById('btn-next-checkout').disabled = false;
                                
                                // Show success modal with animation
                                const successModal = document.getElementById('success-modal');
                                if (successModal) {
                                    successModal.classList.add('show');
                                }
                                
                                // Clear countdown
                                if (countdown) {
                                    clearInterval(countdown);
                                }
                                
                                // Redirect after delay or wait for user click
                                setTimeout(() => {
                                    window.location.href = 'dashboard.php?etid=<?php echo encryptUrlParam($transid); ?>';
                                }, 5000);
                            }
                        })
                        .catch(error => {
                            console.error('Error checking payment status:', error);
                        });
                }, 5000); // Check every 5 seconds
            }
            
            // Share dropdown
            const btnShare = document.getElementById('btn-share');
            const shareDropdown = document.getElementById('share-dropdown');
            
            if (btnShare && shareDropdown) {
                btnShare.addEventListener('click', function() {
                    shareDropdown.classList.toggle('hidden');
                });
                
                // Close dropdown when clicking outside
                document.addEventListener('click', function(event) {
                    if (!btnShare.contains(event.target) && !shareDropdown.contains(event.target)) {
                        shareDropdown.classList.add('hidden');
                    }
                });
                
                // Share options
                document.getElementById('share-email')?.addEventListener('click', function() {
                    const subject = 'Cryptocurrency Payment Confirmation';
                    const body = `Hello,\n\nI want to share my cryptocurrency payment details:\n\nTransaction ID: ${transactionId}\nAmount: $<?php echo htmlspecialchars($amount); ?> USD\nStatus: <?php echo htmlspecialchars(ucfirst($status)); ?>\n\nThank you.`;
                    window.location.href = `mailto:?subject=${encodeURIComponent(subject)}&body=${encodeURIComponent(body)}`;
                });
                
                document.getElementById('share-whatsapp')?.addEventListener('click', function() {
                    const text = `Payment Confirmation: Transaction ID ${transactionId} - Amount $<?php echo htmlspecialchars($amount); ?> USD - Status: <?php echo htmlspecialchars(ucfirst($status)); ?>`;
                    window.open(`https://wa.me/?text=${encodeURIComponent(text)}`, '_blank');
                });
                
                document.getElementById('share-telegram')?.addEventListener('click', function() {
                    const text = `Payment Confirmation: Transaction ID ${transactionId} - Amount $<?php echo htmlspecialchars($amount); ?> USD - Status: <?php echo htmlspecialchars(ucfirst($status)); ?>`;
                    window.open(`https://t.me/share/url?url=${encodeURIComponent(window.location.href)}&text=${encodeURIComponent(text)}`, '_blank');
                });
                
                document.getElementById('share-copy')?.addEventListener('click', function() {
                    const tempInput = document.createElement('input');
                    document.body.appendChild(tempInput);
                    tempInput.value = window.location.href;
                    tempInput.select();
                    document.execCommand('copy');
                    document.body.removeChild(tempInput);
                    alert('Link copied to clipboard!');
                });
            }
            
            // PDF Download
            const btnDownloadReceipt = document.getElementById('btn-download-receipt');
            
            if (btnDownloadReceipt) {
                btnDownloadReceipt.addEventListener('click', function() {
                    // Generate PDF using jsPDF and html2canvas
                    const receiptContainer = document.getElementById('receipt-container');
                    receiptContainer.style.display = 'block';
                    
                    html2canvas(document.getElementById('receipt-content')).then(canvas => {
                        const imgData = canvas.toDataURL('image/png');
                        const pdf = new jspdf.jsPDF();
                        
                        // Add image to PDF
                        const imgWidth = 210;
                        const imgHeight = (canvas.height * imgWidth) / canvas.width;
                        pdf.addImage(imgData, 'PNG', 0, 0, imgWidth, imgHeight);
                        
                        // Save the PDF
                        pdf.save(`payment_receipt_${transactionId}.pdf`);
                        
                        // Hide receipt container again
                        receiptContainer.style.display = 'none';
                    });
                });
            }
            
            // Success modal button
            const successButton = document.getElementById('success-button');
            if (successButton) {
                successButton.addEventListener('click', function() {
                    window.location.href = 'dashboard.php?etid=<?php echo encryptUrlParam($transid); ?>';
                });
            }
            
            // Navigation buttons
            const btnBackSignal = document.getElementById('btn-back-signal');
            const btnNextCheckout = document.getElementById('btn-next-checkout');
            const btnViewDashboard = document.getElementById('btn-view-dashboard');
            
            if (btnBackSignal) {
                btnBackSignal.addEventListener('click', function() {
                    window.location.href = 'signalbuy.php';
                });
            }
            
            if (btnNextCheckout) {
                btnNextCheckout.addEventListener('click', function() {
                    if (!this.disabled) {
                        window.location.href = 'dashboard.php?etid=<?php echo encryptUrlParam($transid); ?>';
                    }
                });
            }
            
            if (btnViewDashboard) {
                btnViewDashboard.addEventListener('click', function() {
                    window.location.href = 'dashboard.php?etid=<?php echo encryptUrlParam($transid); ?>';
                });
            }
            
            // Show success animation if flag is set
            <?php if ($showSuccessAnimation): ?>
            const successModal = document.getElementById('success-modal');
            if (successModal) {
                successModal.classList.add('show');
                
                // Redirect after delay or on button click
                setTimeout(() => {
                    window.location.href = '<?php echo $redirectToPage; ?>';
                }, 5000);
            }
            <?php endif; ?>
        });
    </script>
</body>
</html>