<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Load PHPMailer classes if available
if (file_exists('../vendor/autoload.php')) {
    require '../vendor/autoload.php';
}
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Check if transaction data is set
if (!isset($_SESSION['transaction_data'])) {
    header("Location: usdt.php");
    exit();
}
$host = "localhost";
$user = "lrbpxbxy_userv";
$pass = "WHEagP2O9sOzG9gk"; // Replace with your actual database password
$dbname = "lrbpxbxy_dbv";


$transaction_data = $_SESSION['transaction_data'];

// Database 
$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    $_SESSION['error'] = "Database connection failed. Please try again later.";
    header("Location: usdt.php");
    exit();
}

// Check balance
$stmt = $conn->prepare("SELECT usdt FROM users WHERE id = ?");
$stmt->bind_param("i", $transaction_data['user_id']);
$stmt->execute();
$result = $stmt->get_result();
$user_data = $result->fetch_assoc();
$stmt->close();

if (!$user_data) {
    $_SESSION['error'] = "User not found.";
    header("Location: usdt.php");
    exit();
}

$current_balance = $user_data['usdt'];

// Debug: Log current values
error_log("Current Balance: " . $current_balance);
error_log("USDT Amount from Session: " . (isset($transaction_data['usdt']) ? $transaction_data['usdt'] : 'Not Set'));

// Validate that usdt is set and numeric
if (!isset($transaction_data['usdt']) || !is_numeric($transaction_data['usdt'])) {
    $_SESSION['error'] = "Invalid transaction amount.";
    header("Location: usdt.php");
    exit();
}

// Ensure both values are treated as strings for bcsub
$current_balance_str = (string)$current_balance;
$usdt_str = (string)$transaction_data['usdt'];

// Calculate new balance using bcsub
$new_balance = bcsub($current_balance_str, $usdt_str, 8);

if ($new_balance === false || $new_balance === null) {
    $_SESSION['error'] = "Error calculating new balance.";
    header("Location: usdt.php");
    exit();
}

if (bccomp($new_balance, '0', 8) < 0) {
    $_SESSION['error'] = "Insufficient balance. Transaction cannot be processed.";
    header("Location: usdt.php");
    exit();
}

// STEP 1: DEDUCT BALANCE FROM USER ACCOUNT
echo "<!-- Step 1: Deducting balance from user account -->\n";
$stmt = $conn->prepare("UPDATE users SET usdt = ? WHERE id = ?");
$stmt->bind_param("si", $new_balance, $transaction_data['user_id']);
if (!$stmt->execute()) {
    $_SESSION['error'] = "Failed to update balance.";
    $stmt->close();
    header("Location: usdt.php");
    exit();
}
$stmt->close();
echo "<!-- Balance deducted successfully. New balance: " . $new_balance . " -->\n";

// STEP 2: GENERATE TRANSACTION HASH
$transhash = hash('sha256', $transaction_data['email'] . microtime(true) . random_int(1000, 9999));
echo "<!-- Transaction hash generated: " . $transhash . " -->\n";

// STEP 3: INSERT TRANSACTION RECORD
echo "<!-- Step 3: Inserting transaction record -->\n";
$stmt = $conn->prepare("INSERT INTO crypto_withdrawal 
    (user_id, email, network, wallet, ipaddress, name, total_amount, fee, transhash) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");

if (!$stmt) {
    // Rollback the balance update since transaction insert failed
    $rollback_stmt = $conn->prepare("UPDATE users SET usdt = ? WHERE id = ?");
    $rollback_stmt->bind_param("si", $current_balance, $transaction_data['user_id']);
    $rollback_stmt->execute();
    $rollback_stmt->close();
    
    $_SESSION['error'] = "Failed to prepare statement: " . $conn->error;
    header("Location: usdt.php");
    exit();
}

$stmt->bind_param("issssssss",
    $transaction_data['user_id'],      // i - integer (1)
    $transaction_data['email'],        // s - string (2)
    $transaction_data['network'],      // s - string (3)
    $transaction_data['wallet'],       // s - string (4)
    $transaction_data['ipaddress'],    // s - string (5)
    $transaction_data['name'],         // s - string (6)
    $transaction_data['total_amount'], // s - string (7)
    $transaction_data['fee'],          // s - string (8)
    $transhash                         // s - string (9)
);

if (!$stmt->execute()) {
    // Rollback the balance update since transaction insert failed
    $rollback_stmt = $conn->prepare("UPDATE users SET usdt = ? WHERE id = ?");
    $rollback_stmt->bind_param("si", $current_balance, $transaction_data['user_id']);
    $rollback_stmt->execute();
    $rollback_stmt->close();
    
    $_SESSION['error'] = "Transaction failed: " . $stmt->error;
    error_log("SQL Error: " . $stmt->error);
    $stmt->close();
    header("Location: usdt.php");
    exit();
}
$stmt->close();
echo "<!-- Transaction record inserted successfully -->\n";

// STEP 4: ADD TRANSACTION HASH AND SUCCESS FLAG TO SESSION
// This ensures the success page has all the data it needs
$_SESSION['transaction_data']['transhash'] = $transhash;
$_SESSION['transaction_data']['transaction_status'] = 'completed';
$_SESSION['transaction_data']['processed_at'] = date('Y-m-d H:i:s');
$_SESSION['transaction_data']['new_balance'] = $new_balance;

// STEP 5: SEND CONFIRMATION EMAIL (AFTER SUCCESSFUL DEBIT AND INSERT)
echo "<!-- Step 5: Sending confirmation email -->\n";
// Fetch real-time USDT price (USDT is typically pegged to $1 USD)
$usdt_price = 1.00; // USDT is a stablecoin pegged to USD
$usd_amount = floatval($transaction_data['usdt']) * $usdt_price;
$usd_value = "$" . number_format($usd_amount, 2);

// Send email
if (class_exists('PHPMailer\PHPMailer\PHPMailer')) {
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'bitvros.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'noreply@bitvros.com';
        $mail->Password = 'Bitv@9034';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;

        $mail->setFrom('noreply@bitvros.com', 'bitvros.com Wallet');
        $mail->addAddress($transaction_data['email'], $transaction_data['name']);
        
        $mail->isHTML(true);
        $mail->Subject = 'Transaction Confirmation - bitvros.com Wallet';
        $mail->Body = "<html><body><p>Dear " . htmlspecialchars($transaction_data['name']) . ",</p>
            <p>Your USDT transaction was successful. Details:</p>
            <ul>
                <li><strong>Transaction ID:</strong> " . htmlspecialchars($transhash) . "</li>
                <li><strong>Network:</strong> " . htmlspecialchars($transaction_data['network']) . "</li>
                <li><strong>Wallet:</strong> " . htmlspecialchars($transaction_data['wallet']) . "</li>
                <li><strong>Amount:</strong> " . htmlspecialchars($transaction_data['usdt']) . " USDT</li>
                <li><strong>USD Equivalent:</strong> " . htmlspecialchars($usd_value) . "</li>
            </ul>
            <p>Thank you for using bitvros.com Wallet.</p>
            <p>&copy; " . date('Y') . " bitvros.com Wallet. All rights reserved.</p>
            </body></html>";

        $mail->AltBody = "Transaction Confirmation - bitvros.com Wallet\n\nDear " . $transaction_data['name'] . ",\n\nYour USDT transaction was successful. Details:\n\n- Transaction ID: " . $transhash . "\n- Network: " . $transaction_data['network'] . "\n- Wallet: " . $transaction_data['wallet'] . "\n- Amount: " . $transaction_data['usdt'] . " USDT\n- USD Equivalent: " . $usd_value . "\n\nThank you for using bitvros.com Wallet.";

        $mail->send();
        echo "<!-- Email sent successfully -->\n";
    } catch (Exception $e) {
        error_log("Email sending failed: " . $mail->ErrorInfo);
        echo "<!-- Email sending failed but transaction completed -->\n";
        // Don't exit here - transaction was successful even if email fails
    }
} else {
    error_log("PHPMailer class not available");
    echo "<!-- PHPMailer not available, email not sent -->\n";
}

// Close database connection
$conn->close();

// DON'T CLEAR SESSION DATA YET - Success page needs it
// The success page will clear it after displaying or via JavaScript

// Redirect to success page
header("Location: usdtsuccess.php");
exit();
?>