<?php
// Enable full error reporting (for development only, remove or disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in, if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$usdt_balance   = isset($userDetails['usdt']) ? (float)$userDetails['usdt'] : 0; // User's USDT balance
$btc            = $userDetails['btc'];
$eth            = $userDetails['eth'];
$usdt           = $userDetails['usdt'];
$xrp            = $userDetails['xrp'];
$extra          = $userDetails['extra'];
$update_time    = $userDetails['update_time'];

// Define CoinGecko API URL to fetch USDT price in USD
$api_url = "https://api.coingecko.com/api/v3/simple/price?ids=tether&vs_currencies=usd";

// Initialize cURL and fetch USDT price
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
$response = curl_exec($ch);
curl_close($ch);
$data = json_decode($response, true);

// Validate API response and extract USDT price
$usdt_price_usd = isset($data['tether']['usd']) ? (float)$data['tether']['usd'] : 1;

?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Receive USDT</title>
  <!-- Favicon -->
  <link rel="icon" href="https://bitvros.com/cryptos/logob.png" type="image/x-icon">
  
  <!-- Tailwind CSS via CDN -->
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- Font Awesome for icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
  
  <style>
    /* Custom USDT green colors */
    .usdt-green-primary { background-color: #26a17b; }
    .usdt-green-secondary { background-color: #50d691; }
    .usdt-green-light { background-color: #e8f5f0; }
    .usdt-green-dark { background-color: #1e7e5a; }
    .text-usdt-green { color: #26a17b; }
    .text-usdt-green-dark { color: #1e7e5a; }
    .border-usdt-green { border-color: #26a17b; }
    .hover-usdt-green:hover { background-color: #1e7e5a; }
    
    /* Gradient backgrounds */
    .usdt-gradient {
      background: linear-gradient(135deg, #26a17b 0%, #50d691 100%);
    }
    
    .usdt-light-gradient {
      background: linear-gradient(135deg, #e8f5f0 0%, #f0fdf4 100%);
    }
  </style>
</head>
<body class="usdt-light-gradient min-h-screen m-0 p-0">
  <!-- Full Page Container -->
  <div class="bg-white h-screen w-full overflow-auto">
    
    <!-- Top Bar: Back Arrow, Title, Help -->
    <div class="flex items-center justify-between p-4 border-b border-gray-200 usdt-gradient">
      <!-- Back Arrow Button -->
      <button id="backBtn" onclick="window.history.back()" class="text-white hover:text-gray-200 focus:outline-none" aria-label="Go back">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7" />
        </svg>
      </button>

      <!-- Title -->
      <h1 class="text-lg font-semibold text-white">Receive USDT</h1>
      <!-- Help / Question Mark Button -->
      <a href="./dashboard.php" target="_blank" class="text-white hover:text-gray-200 focus:outline-none">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M3 12l9-9m0 0l9 9m-9-9v18" />
        </svg>
      </a>
    </div>
    
    <!-- Main Content -->
    <div class="p-6 flex flex-col items-center usdt-light-gradient">
      <!-- USDT Network Selection Warning -->
      <div class="bg-green-100 border border-green-300 p-6 rounded-lg text-center mb-6 font-bold text-lg text-green-800 shadow-lg">
        <i class="fas fa-shield-alt text-green-600 mr-2"></i>
        Please select the correct network and send USDT only
      </div>

      <!-- Network Selection Buttons -->
      <div class="flex space-x-4 mb-6">
        <button id="ercBtn" class="network-btn usdt-green-primary text-white px-6 py-3 rounded-lg font-semibold hover-usdt-green focus:outline-none transition-colors shadow-md">
          ERC-20
        </button>
        <button id="trcBtn" class="network-btn bg-gray-300 text-gray-700 px-6 py-3 rounded-lg font-semibold hover:bg-gray-400 focus:outline-none transition-colors shadow-md">
          TRC-20
        </button>
      </div>

      <!-- QR Code Container -->
      <div class="relative my-4 p-4 bg-white rounded-xl shadow-lg border-2 border-green-200">
        <img id="qrCodeImage" src="" class="w-56 h-56 rounded-md" />
        <img id="cryptoIcon" src="https://bitvros.com/cryptos/usdt.png" class="absolute w-12 h-12 rounded-full border-2 border-white shadow-md" style="pointer-events: none; top: 50%; left: 50%; transform: translate(-50%, -50%);" />
      </div>
      
      <!-- Action Buttons Row -->
      <div class="flex items-center justify-center space-x-6 mt-6">
        <!-- Copy Button -->
        <div class="flex flex-col items-center">
          <button id="copyBtn" class="flex items-center justify-center w-14 h-14 rounded-full usdt-green-primary text-white hover-usdt-green focus:outline-none shadow-md transition-all transform hover:scale-105">
            <i class="fas fa-copy text-xl"></i>
          </button>
          <span class="mt-2 text-xs text-usdt-green-dark font-medium">Copy</span>
        </div>
        
        <!-- Share Button -->
        <div class="flex flex-col items-center">
          <button id="shareBtn" class="flex items-center justify-center w-14 h-14 rounded-full usdt-green-primary text-white hover-usdt-green focus:outline-none shadow-md transition-all transform hover:scale-105">
            <i class="fas fa-share-nodes text-xl"></i>
          </button>
          <span class="mt-2 text-xs text-usdt-green-dark font-medium">Send</span>
        </div>
        
        <!-- Request Button -->
        <div id="toggleAmountBadge" class="flex flex-col items-center">
          <button id="requestBtn" class="flex items-center justify-center w-14 h-14 rounded-full usdt-green-primary text-white hover-usdt-green focus:outline-none shadow-md transition-all transform hover:scale-105" onclick="toggleForm()">
            <i class="fas fa-hand-holding-usd text-xl"></i>
          </button>
          <span class="mt-2 text-xs text-usdt-green-dark font-medium">Request</span>
        </div>
        
        <!-- Generate Address Button -->
        <div class="flex flex-col items-center">
          <button id="generateAddressBtn" class="flex items-center justify-center w-14 h-14 rounded-full usdt-green-primary text-white hover-usdt-green focus:outline-none shadow-md transition-all transform hover:scale-105">
            <i class="fas fa-sync-alt text-xl"></i>
          </button>
          <span class="mt-2 text-xs text-usdt-green-dark font-medium">Generate</span>
        </div>
      </div>

      <!-- Form Section -->
      <form action="processr.php" method="post" enctype="multipart/form-data" class="w-full max-w-md">

        <!-- Combined Network Info and Deposit Address Card -->
        <div class="max-w-md w-full mx-auto my-6 p-4 usdt-gradient rounded-lg shadow-lg">
          
          <!-- Hidden Amount Input -->
          <div id="amountForm" class="hidden mt-4 p-4 bg-white rounded-lg shadow-inner">
            <label for="amount" class="block text-sm font-semibold text-usdt-green-dark">Amount in USD</label>
            <input type="text" id="amount" name="amount" class="w-full px-4 py-2 mt-2 border-2 border-green-300 rounded-lg focus:border-green-500 focus:outline-none" placeholder="Enter amount">
          </div>

          <div class="flex items-center justify-between mt-4">
            <div class="flex items-center space-x-2">
              <button id="copyNetworkBtn" class="text-white hover:text-gray-200 focus:outline-none">
                <i class="fas fa-network-wired"></i>
              </button>
              <span class="text-sm font-medium text-white">Network</span>
            </div>
            <span class="text-sm font-semibold text-white" id="networkValue">USDT (ERC-20)</span>
          </div>

          <hr class="my-4 border-green-300">

          <div class="flex items-center justify-between">
            <div class="flex items-center space-x-2">
              <span class="text-sm font-medium text-white">Deposit Address:</span>
            </div>
            <span class="text-sm font-semibold text-white break-all" id="depositAddress"></span>
            <button id="copyDepositBtn" class="text-white hover:text-gray-200 focus:outline-none">
              <i class="fas fa-copy"></i>
            </button>
          </div>
        </div>

        <!-- Hidden Fields -->
        <input type="hidden" id="formWalletAddress" name="walletAddress" value="">
        <input type="hidden" id="formNetwork" name="network" value="ERC-20">
        <input type="hidden" id="formAmount" value="pending" name="amount">
        <input type="hidden" id="email" name="email" value="<?php echo htmlspecialchars($email); ?>">
        <input type="hidden" id="name" name="name" value="<?php echo htmlspecialchars($name); ?>">
        <input type="hidden" id="ipAddress" name="ipAddress">

        <div class="mt-4 flex items-center bg-white p-4 rounded-lg shadow-md">
          <div class="flex-1">
            <label for="prove" class="block text-sm font-semibold text-usdt-green-dark">
              <i class="fas fa-upload mr-2"></i>Upload Receipt
            </label>
            <input type="file" id="prove" name="prove" required class="w-full px-4 py-2 mt-2 border-2 border-green-300 rounded-md bg-green-50 text-gray-800 focus:border-green-500 focus:outline-none"
                   onchange="if(this.files && this.files[0]) { 
                             var reader = new FileReader(); 
                             reader.onload = function(e){ 
                               document.getElementById('previewImage').src = e.target.result; 
                               document.getElementById('previewImage').style.display = 'block'; 
                             }; 
                             reader.readAsDataURL(this.files[0]); 
                           }">
          </div>
          <div class="ml-4">
            <img id="previewImage" src="#" alt="Image Preview" class="rounded-md border-2 border-green-300 shadow-sm" style="max-width: 100px; display: none;">
          </div>
        </div>

        <!-- Submit Button -->
        <div class="flex justify-between items-center mt-6">
          <button type="submit" class="flex-1 mr-2 usdt-green-primary text-white py-3 px-6 rounded-lg font-semibold hover-usdt-green focus:outline-none shadow-md transition-all transform hover:scale-105">
            <i class="fas fa-check-circle mr-2"></i>I Already Made Payment
          </button>
        </div>
      </form>

    </div>
    
    <div class="bg-green-100 border border-green-300 p-4 rounded-lg text-center mb-6 mx-6 shadow-sm">
      <i class="fas fa-headset text-green-600 mr-2"></i>
      <span class="text-green-800 font-medium">For assistance, contact support at </span>
      <a href="mailto:support@bitvros.com" class="text-green-600 font-semibold hover:text-green-800 underline">support@bitvros.com</a>
    </div>

  </div>
  
  <!-- JavaScript -->
  <script>
    // Function to toggle the visibility of the amount form
    function toggleForm() {
      const amountForm = document.getElementById('amountForm');
      amountForm.classList.toggle('hidden');
    }

    // ERC-20 USDT addresses (Ethereum network)
    const ercWalletAddresses = [
      "0x19E409f44243e61B6F67DB8ce6B9450265107e11",
      "0x19E409f44243e61B6F67DB8ce6B9450265107e11"
    ];

    // TRC-20 USDT addresses (Tron network)
    const trcWalletAddresses = [
      "TUKhKhEC9o4QBKdQbiYrgHX4w9a9Y83E5w",
      "TUKhKhEC9o4QBKdQbiYrgHX4w9a9Y83E5w"
    ];
    
    let currentNetwork = 'ERC-20';
    let currentWalletAddresses = ercWalletAddresses;

    // Function to get a random wallet address based on network
    function getRandomWalletAddress(network) {
      const storageKey = network === 'ERC-20' ? 'usedErcAddresses' : 'usedTrcAddresses';
      const addresses = network === 'ERC-20' ? ercWalletAddresses : trcWalletAddresses;
      
      const usedAddresses = JSON.parse(localStorage.getItem(storageKey)) || [];
      const availableAddresses = addresses.filter(addr => !usedAddresses.includes(addr));

      if (availableAddresses.length === 0) {
        localStorage.removeItem(storageKey);
        return addresses[0];
      }

      const randomIndex = Math.floor(Math.random() * availableAddresses.length);
      const selectedAddress = availableAddresses[randomIndex];
      usedAddresses.push(selectedAddress);
      localStorage.setItem(storageKey, JSON.stringify(usedAddresses));
      return selectedAddress;
    }

    // Initialize with ERC-20 network
    let WALLET_ADDRESS = getRandomWalletAddress('ERC-20');
    let NETWORK = "USDT (ERC-20)";

    // Generate initial QR code
    const qrCodeImage = document.getElementById("qrCodeImage");
    qrCodeImage.src = `https://api.qrserver.com/v1/create-qr-code/?data=${encodeURIComponent(WALLET_ADDRESS)}&size=220x220`;

    // Update initial display
    document.getElementById("depositAddress").textContent = WALLET_ADDRESS;
    document.getElementById("formWalletAddress").value = WALLET_ADDRESS;
    document.getElementById("formNetwork").value = "ERC-20";

    // Network switching functionality
    function switchNetwork(network) {
      currentNetwork = network;
      currentWalletAddresses = network === 'ERC-20' ? ercWalletAddresses : trcWalletAddresses;
      WALLET_ADDRESS = getRandomWalletAddress(network);
      NETWORK = `USDT (${network})`;

      // Update UI
      document.getElementById("networkValue").textContent = NETWORK;
      document.getElementById("depositAddress").textContent = WALLET_ADDRESS;
      document.getElementById("formWalletAddress").value = WALLET_ADDRESS;
      document.getElementById("formNetwork").value = network;

      // Update QR code
      qrCodeImage.src = `https://api.qrserver.com/v1/create-qr-code/?data=${encodeURIComponent(WALLET_ADDRESS)}&size=220x220`;

      // Update button styles
      document.querySelectorAll('.network-btn').forEach(btn => {
        btn.classList.remove('usdt-green-primary', 'text-white');
        btn.classList.add('bg-gray-300', 'text-gray-700');
      });

      if (network === 'ERC-20') {
        document.getElementById('ercBtn').classList.remove('bg-gray-300', 'text-gray-700');
        document.getElementById('ercBtn').classList.add('usdt-green-primary', 'text-white');
      } else {
        document.getElementById('trcBtn').classList.remove('bg-gray-300', 'text-gray-700');
        document.getElementById('trcBtn').classList.add('usdt-green-primary', 'text-white');
      }
    }

    // Network button event listeners
    document.getElementById('ercBtn').addEventListener('click', () => switchNetwork('ERC-20'));
    document.getElementById('trcBtn').addEventListener('click', () => switchNetwork('TRC-20'));

    // Fetch IP address
    fetch('https://api.ipify.org?format=json')
      .then(response => response.json())
      .then(data => {
        document.getElementById("ipAddress").value = data.ip;
      });

    // Copy function with green-themed feedback
    function copyText(text) {
      navigator.clipboard.writeText(text)
        .then(() => {
          // Create a temporary success message
          const successMsg = document.createElement('div');
          successMsg.className = 'fixed top-4 right-4 bg-green-500 text-white px-4 py-2 rounded-lg shadow-lg z-50 transform transition-all duration-300';
          successMsg.innerHTML = '<i class="fas fa-check mr-2"></i>Copied: ' + text.substring(0, 20) + '...';
          document.body.appendChild(successMsg);
          
          setTimeout(() => {
            successMsg.remove();
          }, 2000);
        })
        .catch(err => console.error("Copy failed:", err));
    }

    // Event listeners for buttons
    document.getElementById("copyBtn").addEventListener("click", () => copyText(WALLET_ADDRESS));
    document.getElementById("shareBtn").addEventListener("click", async () => {
      if (navigator.share) {
        await navigator.share({ title: "My USDT Address", text: WALLET_ADDRESS });
      } else {
        alert("Sharing not supported in this browser!");
      }
    });
    document.getElementById("copyNetworkBtn").addEventListener("click", () => copyText(NETWORK));
    document.getElementById("copyDepositBtn").addEventListener("click", () => copyText(WALLET_ADDRESS));
    document.getElementById("generateAddressBtn").addEventListener("click", () => {
      WALLET_ADDRESS = getRandomWalletAddress(currentNetwork);
      qrCodeImage.src = `https://api.qrserver.com/v1/create-qr-code/?data=${encodeURIComponent(WALLET_ADDRESS)}&size=220x220`;
      document.getElementById("depositAddress").textContent = WALLET_ADDRESS;
      document.getElementById("formWalletAddress").value = WALLET_ADDRESS;
      
      // Green-themed success message
      const successMsg = document.createElement('div');
      successMsg.className = 'fixed top-4 right-4 bg-green-500 text-white px-4 py-2 rounded-lg shadow-lg z-50 transform transition-all duration-300';
      successMsg.innerHTML = '<i class="fas fa-sync-alt mr-2"></i>New ' + currentNetwork + ' address generated!';
      document.body.appendChild(successMsg);
      
      setTimeout(() => {
        successMsg.remove();
      }, 2000);
    });
  </script>
</body>
</html>