<?php
// Enable full error reporting (for development only, remove or disable in production)
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in, if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);

if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id     = $userDetails['google_id'];
$name          = $userDetails['name'];
$email         = $userDetails['email'];
$created_at    = $userDetails['created_at'];
$picture       = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin           = $userDetails['pin'];
$status        = $userDetails['status'];
$country       = $userDetails['country'];
$phone         = $userDetails['phone'];
$balance       = $userDetails['balance'];
$btc           = $userDetails['btc'];
$eth           = $userDetails['eth'];
$usdt          = $userDetails['usdt'];
$xrp           = $userDetails['xrp'];
$extra         = $userDetails['extra'];
$update_time   = $userDetails['update_time'];

// Check KYC verification status
$kycVerified = false;
$kycPending = false;
$kycUnverified = true;
$kycStatus = 'unverified'; // Default status

try {
    $stmt = $conn->prepare("SELECT status FROM kyc_submissions WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($row = $result->fetch_assoc()) {
        $kycStatus = strtolower(trim($row['status']));
        
        switch ($kycStatus) {
            case 'verified':
            case 'approved':
                $kycVerified = true;
                $kycPending = false;
                $kycUnverified = false;
                break;
            case 'pending':
            case 'under_review':
            case 'processing':
                $kycVerified = false;
                $kycPending = true;
                $kycUnverified = false;
                break;
            case 'unverified':
            case 'rejected':
            case 'failed':
            default:
                $kycVerified = false;
                $kycPending = false;
                $kycUnverified = true;
                break;
        }
    }
    $stmt->close();
} catch (Exception $e) {
    // Handle database error silently or log it
    error_log("KYC check error: " . $e->getMessage());
}

// Define status-specific variables
if ($kycVerified) {
    $statusColor = 'green';
    $statusIcon = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />';
    $headerTitle = 'Verification Complete';
    $headerSubtitle = 'Your account is fully verified and ready to use';
    $mainTitle = 'Account Verified Successfully';
    $mainMessage = 'Your identity has been successfully verified and your account is fully activated.';
    $subMessage = 'You now have access to all platform features and benefits.';
    $statusBadge = 'Status: Verified';
} elseif ($kycPending) {
    $statusColor = 'yellow';
    $statusIcon = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />';
    $headerTitle = 'Verification Under Review';
    $headerSubtitle = 'Your documents are being reviewed by our team';
    $mainTitle = 'Verification In Progress';
    $mainMessage = 'Your verification documents have been submitted and are currently under review.';
    $subMessage = 'This process typically takes 24-48 hours. We\'ll notify you once it\'s complete.';
    $statusBadge = 'Status: Pending Review';
} else { // Unverified
    $statusColor = 'red';
    $statusIcon = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16c-.77.833.192 2.5 1.732 2.5z" />';
    $headerTitle = 'Secure Verification Portal';
    $headerSubtitle = 'Complete your verification to unlock full platform access';
    $mainTitle = 'Verification Required';
    $mainMessage = 'You haven\'t submitted your necessary documents to verify your identity yet.';
    $subMessage = 'Complete verification now to gain full access to our platform\'s features and benefits.';
    $statusBadge = 'Status: Unverified';
}
?>

<?php include './includes/header.php'; ?>

      <!-- Hidden Google Translate Element with Improved Styling -->
<style>
  /* Hide Google Translate widget and branding */
  .goog-te-banner-frame,
  .goog-te-balloon-frame,
  #goog-gt-tt,
  .goog-te-menu-value span,
  .VIpgJd-ZVi9od-l4eHX-hSRGPd,
  .VIpgJd-ZVi9od-aZ2wEe-wOHMyf,
  .VIpgJd-ZVi9od-aZ2wEe-OiiCO {
    display: none !important;
  }
  
  /* Hide the default Google Translate dropdown container */
  #google_translate_element {
    position: absolute;
    overflow: hidden;
    height: 0;
    visibility: hidden;
    opacity: 0;
  }
  
  /* Remove Google frame affecting site layout */
  body {
    top: 0 !important;
  }
  
  /* Fix for any shifted elements after translation */
  .skiptranslate,
  .goog-tooltip,
  .goog-tooltip:hover {
    display: none !important;
  }

  /* Custom language indicator styles, if you want to show it */
  .language-indicator {
    position: fixed;
    bottom: 20px;
    right: 20px;
    background: rgba(255, 255, 255, 0.9);
    padding: 8px 15px;
    border-radius: 50px;
    font-size: 12px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    z-index: 9999;
    opacity: 0.8;
    transition: opacity 0.3s;
    display: none; /* Hidden by default */
  }
  
  .language-indicator:hover {
    opacity: 1;
  }
</style>

<!-- Hidden Google Translate element -->
<div id="google_translate_element"></div>

<!-- Optional: Language indicator (uncomment to enable) -->
<!-- <div class="language-indicator">Translated to: <span id="current-language">English</span></div> -->

<script type="text/javascript">
  // Improved Google Translate implementation
  class SmartTranslator {
    constructor(options = {}) {
      this.options = {
        pageLanguage: 'en',
        autoDisplay: false,
        excludedCountries: ['IN', 'GH', 'LK'],
        cookieName: 'preferred_language',
        cookieExpiry: 30, // days
        debug: false,
        ...options
      };
      
      this.countryLangMap = {
        'US': 'en', 'CA': 'en', 'GB': 'en', 'AU': 'en', 'NZ': 'en', 'IE': 'en',
        'FR': 'fr', 'BE': 'nl', 'NL': 'nl', 'DE': 'de', 'AT': 'de', 'CH': 'de',
        'IT': 'it', 'ES': 'es', 'PT': 'pt', 'BR': 'pt', 'MX': 'es', 'AR': 'es',
        'CL': 'es', 'CO': 'es', 'PE': 'es', 'VE': 'es', 'EC': 'es', 'RU': 'ru',
        'PL': 'pl', 'CZ': 'cs', 'SK': 'sk', 'HU': 'hu', 'RO': 'ro', 'BG': 'bg',
        'GR': 'el', 'TR': 'tr', 'IL': 'he', 'SA': 'ar', 'AE': 'ar', 'EG': 'ar',
        'IN': 'hi', 'PK': 'ur', 'BD': 'bn', 'LK': 'si', 'NP': 'ne', 'ID': 'id',
        'MY': 'ms', 'PH': 'fil', 'TH': 'th', 'VN': 'vi', 'KR': 'ko', 'JP': 'ja',
        'CN': 'zh-CN', 'TW': 'zh-TW', 'HK': 'zh-TW', 'SG': 'en', 'FI': 'fi',
        'SE': 'sv', 'NO': 'no', 'DK': 'da', 'IS': 'is', 'EE': 'et', 'LV': 'lv',
        'LT': 'lt'
      };
      
      this.languageNames = {
        'en': 'English', 'fr': 'Français', 'es': 'Español', 'de': 'Deutsch',
        'it': 'Italiano', 'pt': 'Português', 'ru': 'Русский', 'ja': 'Japanese',
        'zh-CN': 'Chinese (Simplified)', 'zh-TW': 'Chinese (Traditional)',
        'ko': 'Korean', 'ar': 'Arabic', 'hi': 'Hindi', 'nl': 'Dutch'
        // Add more as needed
      };
      
      this.init();
    }
    
    init() {
      // Initialize after DOM is ready
      if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', () => this.setup());
      } else {
        this.setup();
      }
    }
    
    setup() {
      this.log('Initializing translator');
      
      // First check saved preference
      const savedLang = this.getCookie(this.options.cookieName);
      
      if (savedLang) {
        this.log(`Found saved language preference: ${savedLang}`);
        this.initTranslate(() => this.translateTo(savedLang));
      } else {
        // Otherwise detect based on location
        this.detectLanguage()
          .then(lang => {
            if (lang) {
              this.log(`Detected language: ${lang}`);
              this.initTranslate(() => this.translateTo(lang));
            } else {
              this.log('No translation needed');
              this.initTranslate(); // Just initialize without translating
            }
          })
          .catch(err => {
            this.log('Error detecting language:', err);
            this.initTranslate();
          });
      }
      
      // Remove Google's top bar effect after translation
      this.fixTopBarEffect();
    }
    
    initTranslate(callback) {
      // Create script element to load Google Translate
      const script = document.createElement('script');
      script.src = '//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit';
      script.async = true;
      
      // Define the callback function for Google Translate
      window.googleTranslateElementInit = () => {
        new google.translate.TranslateElement({
          pageLanguage: this.options.pageLanguage,
          autoDisplay: this.options.autoDisplay
        }, 'google_translate_element');
        
        if (callback) {
          // Give time for Google Translate to initialize
          setTimeout(callback, 1000);
        }
      };
      
      document.body.appendChild(script);
    }
    
    detectLanguage() {
      return fetch('https://ipapi.co/json/')
        .then(response => response.json())
        .then(data => {
          if (data && data.country) {
            if (this.options.excludedCountries.includes(data.country)) {
              return null; // Don't translate for excluded countries
            }
            return this.countryLangMap[data.country] || null;
          }
          return null;
        })
        .catch(error => {
          this.log('IP detection failed:', error);
          return null;
        });
    }
    
    translateTo(language) {
      if (!language) return;
      
      this.log(`Translating to: ${language}`);
      
      // Save preference
      this.setCookie(this.options.cookieName, language, this.options.cookieExpiry);
      
      let attempts = 0;
      const maxAttempts = 20;
      const intervalId = setInterval(() => {
        const comboBox = document.querySelector('.goog-te-combo');
        if (comboBox) {
          comboBox.value = language;
          comboBox.dispatchEvent(new Event('change'));
          clearInterval(intervalId);
          
          // Update language indicator if it exists
          const indicator = document.getElementById('current-language');
          if (indicator) {
            indicator.textContent = this.languageNames[language] || language;
            indicator.parentElement.style.display = 'block';
          }
        } else if (++attempts >= maxAttempts) {
          this.log('Failed to find translation dropdown');
          clearInterval(intervalId);
        }
      }, 500);
    }
    
    fixTopBarEffect() {
      // Monitor and fix Google's modification to the body tag
      const observer = new MutationObserver((mutations) => {
        mutations.forEach((mutation) => {
          if (mutation.target.nodeName === 'BODY' && 
              mutation.target.style.top && 
              mutation.target.style.top !== '0px') {
            mutation.target.style.top = '0px';
          }
        });
      });
      
      observer.observe(document.body, { 
        attributes: true, 
        attributeFilter: ['style'] 
      });
      
      // Additional fix for Google's top bar
      setInterval(() => {
        if (document.body.style.top !== '' && document.body.style.top !== '0px') {
          document.body.style.top = '0px';
        }
      }, 1000);
    }
    
    // Helper functions
    getCookie(name) {
      const match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
      return match ? match[2] : null;
    }
    
    setCookie(name, value, days) {
      let expires = '';
      if (days) {
        const date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        expires = '; expires=' + date.toUTCString();
      }
      document.cookie = name + '=' + value + expires + '; path=/; SameSite=Lax';
    }
    
    log(...args) {
      if (this.options.debug) {
        console.log('SmartTranslator:', ...args);
      }
    }
  }

  // Initialize the translator
  document.addEventListener('DOMContentLoaded', () => {
    new SmartTranslator({
      excludedCountries: ['IN', 'GH', 'LK'],
      debug: false // Set to true for debugging
    });
  });
</script>
      
<body onload="initialize()">
    
 <?php include './includes/nav.php'; ?>
    <div class="w-full min-h-screen flex flex-col">
        <!-- Header -->
        <div class="blue-gradient text-white px-6 py-4 text-center">
            <h1 class="text-2xl font-bold">
                <?php echo $headerTitle; ?>
            </h1>
            <p class="text-blue-100">
                <?php echo $headerSubtitle; ?>
            </p>
        </div>

        <!-- Main Content -->
        <div class="w-full flex p-6 flex-col h-full">
            <div class="mx-auto">
                <!-- Status Display -->
                <div class="bg-white rounded-lg p-8 text-center card-shadow">
                    <div class="flex flex-col justify-center items-center">
                        <div class="bg-<?php echo $statusColor; ?>-100 text-<?php echo $statusColor; ?>-600 p-5 rounded-full">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-14 w-14" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <?php echo $statusIcon; ?>
                            </svg>
                        </div>
                        <h3 class="text-<?php echo $statusColor; ?>-800 text-2xl font-bold my-5"><?php echo $mainTitle; ?></h3>
                        <p class="text-lg text-<?php echo $statusColor; ?>-700 mb-4"><?php echo $mainMessage; ?></p>
                        <p class="text-md text-<?php echo $statusColor; ?>-600 mb-6"><?php echo $subMessage; ?></p>
                        
                        <?php if ($kycVerified): ?>
                            <div class="flex items-center justify-center bg-green-100 text-green-800 font-semibold py-3 px-6 rounded-lg shadow-md">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                                </svg>
                                <?php echo $statusBadge; ?>
                            </div>
                        <?php elseif ($kycPending): ?>
                            <div class="flex items-center justify-center bg-yellow-100 text-yellow-800 font-semibold py-3 px-6 rounded-lg shadow-md">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd" />
                                </svg>
                                <?php echo $statusBadge; ?>
                            </div>
                        <?php else: ?>
                            <div class="mb-4">
                                <div class="flex items-center justify-center bg-red-100 text-red-800 font-semibold py-3 px-6 rounded-lg shadow-md mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                    </svg>
                                    <?php echo $statusBadge; ?>
                                </div>
                                
                                <a href="verification.php">
                                    <button class="flex items-center bg-blue-400 text-white font-semibold py-2 px-4 rounded-lg shadow-md hover:bg-blue-500 active:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-400 focus:ring-opacity-50 transition-all duration-300">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M4 4a2 2 0 012-2h4.586A2 2 0 0112 2.586L15.414 6A2 2 0 0116 7.414V16a2 2 0 01-2 2H6a2 2 0 01-2-2V4z" clip-rule="evenodd" />
                                        </svg>
                                        Click here to complete your KYC
                                    </button>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <div class="mx-auto text-blue-900 max-w-6xl">
                <div class="grid gap-6 xs:grid-cols-1 md:grid-cols-3">
                    <!-- Left Column -->
                    <div class="xs:col-span-1 md:col-span-2">
                        <div class="bg-blue-50 p-6 rounded-lg card-shadow mb-6">
                            <h2 class="text-2xl font-bold text-blue-800 mb-4">
                                <?php 
                                if ($kycVerified) {
                                    echo 'Your Account Benefits';
                                } elseif ($kycPending) {
                                    echo 'What Happens Next?';
                                } else {
                                    echo 'Why Verification Matters';
                                }
                                ?>
                            </h2>
                            
                            <?php if ($kycVerified): ?>
                                <p class="text-lg leading-relaxed">
                                    Congratulations! Your account is fully verified and you now have access to all our platform features including:
                                </p>
                                <ul class="mt-4 text-lg leading-relaxed space-y-2">
                                    <li class="flex items-center">
                                        <svg class="w-5 h-5 text-green-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                        </svg>
                                        Full trading capabilities with maximum limits
                                    </li>
                                    <li class="flex items-center">
                                        <svg class="w-5 h-5 text-green-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                        </svg>
                                        Access to all premium features
                                    </li>
                                    <li class="flex items-center">
                                        <svg class="w-5 h-5 text-green-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                        </svg>
                                        Enhanced security and account protection
                                    </li>
                                    <li class="flex items-center">
                                        <svg class="w-5 h-5 text-green-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                        </svg>
                                        Priority customer support
                                    </li>
                                </ul>
                            <?php elseif ($kycPending): ?>
                                <p class="text-lg leading-relaxed">
                                    Your verification documents have been successfully submitted and are currently being reviewed by our compliance team. Here's what you can expect:
                                </p>
                                <ul class="mt-4 text-lg leading-relaxed space-y-2">
                                    <li class="flex items-center">
                                        <svg class="w-5 h-5 text-yellow-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"></path>
                                        </svg>
                                        <span><strong>Review Process:</strong> 24-48 hours typically</span>
                                    </li>
                                    <li class="flex items-center">
                                        <svg class="w-5 h-5 text-yellow-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z" clip-rule="evenodd"></path>
                                            <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"></path>
                                        </svg>
                                        <span><strong>Email Updates:</strong> We'll notify you of any status changes</span>
                                    </li>
                                    <li class="flex items-center">
                                        <svg class="w-5 h-5 text-yellow-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M18 3a1 1 0 00-1.447-.894L8.763 6H5a3 3 0 000 6h.28l1.771 5.316A1 1 0 008 18h1a1 1 0 001-1v-4.382l6.553 3.276A1 1 0 0018 15V3z" clip-rule="evenodd"></path>
                                        </svg>
                                        <span><strong>No Action Required:</strong> Just wait for our response</span>
                                    </li>
                                </ul>
                                <p class="text-lg leading-relaxed mt-4">
                                    <span class="font-bold text-yellow-700">Please be patient</span> - we're working to verify your information as quickly as possible while maintaining the highest security standards.
                                </p>
                            <?php else: ?>
                                <p class="text-lg leading-relaxed">
                                    To ensure the security of our platform and comply with international regulations, all participants must complete identity verification (KYC/AML). This helps prevent fraud, money laundering, and other prohibited activities.
                                </p>
                                <p class="text-lg leading-relaxed mt-4">
                                    Our verification process is <span class="font-bold text-blue-700">fast, secure, and straightforward</span> - typically taking less than 5 minutes to complete.
                                </p>
                                <div class="mt-4 p-4 bg-red-50 border-l-4 border-red-400 rounded">
                                    <p class="text-red-700 font-medium">
                                        <strong>Important:</strong> Your account has limited functionality until verification is complete. Start the process now to unlock all features.
                                    </p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Right Column -->
                    <div class="bg-blue-50 rounded-lg p-6 card-shadow">
                        <h4 class="mb-4 text-xl font-bold text-blue-800 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                            </svg>
                            Verification Levels
                        </h4>
                        <ul class="space-y-4">
                            <li>
                                <div class="bg-white rounded-lg p-5 card-shadow <?php echo $kycVerified ? 'border-l-4 border-green-500' : ($kycPending ? 'border-l-4 border-yellow-500' : 'border-l-4 border-red-500'); ?>">
                                    <div class="flex items-center justify-between">
                                        <h3 class="font-bold text-blue-800">1. Verified</h3>
                                        <span class="px-3 py-1 rounded-full text-sm
                                            <?php 
                                            if ($kycVerified) {
                                                echo 'bg-green-100 text-green-600';
                                            } elseif ($kycPending) {
                                                echo 'bg-yellow-100 text-yellow-600';
                                            } else {
                                                echo 'bg-red-100 text-red-600';
                                            }
                                            ?>">
                                            <?php 
                                            if ($kycVerified) {
                                                echo 'Active';
                                            } elseif ($kycPending) {
                                                echo 'Pending';
                                            } else {
                                                echo 'Required';
                                            }
                                            ?>
                                        </span>
                                    </div>
                                    <p class="mt-2 text-blue-700">Basic account access and limited trading capabilities</p>
                                    <div class="flex items-center mt-2
                                        <?php 
                                        if ($kycVerified) {
                                            echo 'text-green-600';
                                        } elseif ($kycPending) {
                                            echo 'text-yellow-600';
                                        } else {
                                            echo 'text-red-600';
                                        }
                                        ?>">
                                        <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                            <?php if ($kycVerified): ?>
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                            <?php elseif ($kycPending): ?>
                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd" />
                                            <?php else: ?>
                                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                            <?php endif; ?>
                                        </svg>
                                        <span class="text-sm font-medium">
                                            <?php 
                                            if ($kycVerified) {
                                                echo 'Completed';
                                            } elseif ($kycPending) {
                                                echo 'Under Review';
                                            } else {
                                                echo 'Not Started';
                                            }
                                            ?>
                                        </span>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="bg-white rounded-lg p-5 card-shadow">
                                    <div class="flex items-center justify-between">
                                        <h3 class="font-bold text-blue-800">2. Verified Plus</h3>
                                        <span class="bg-gray-100 text-gray-600 px-3 py-1 rounded-full text-sm">Standard</span>
                                    </div>
                                    <p class="mt-2 text-blue-700">Enhanced trading limits and additional features</p>
                                </div>
                            </li>
                            <li>
                                <div class="bg-white rounded-lg p-5 card-shadow">
                                    <div class="flex items-center justify-between">
                                        <h3 class="font-bold text-blue-800">3. Verified Pro</h3>
                                        <span class="bg-gray-100 text-gray-600 px-3 py-1 rounded-full text-sm">Premium</span>
                                    </div>
                                    <p class="mt-2 text-blue-700">Maximum limits and access to all platform features</p>
                                </div>
                            </li>
                        </ul>
                        <div class="mt-6 rounded-lg p-4 border-l-4 
                            <?php 
                            if ($kycVerified) {
                                echo 'bg-green-100 border-green-500';
                            } elseif ($kycPending) {
                                echo 'bg-yellow-100 border-yellow-500';
                            } else {
                                echo 'bg-red-100 border-red-500';
                            }
                            ?>">
                            <p class="font-medium
                                <?php 
                                if ($kycVerified) {
                                    echo 'text-green-700';
                                } elseif ($kycPending) {
                                    echo 'text-yellow-700';
                                } else {
                                    echo 'text-red-700';
                                }
                                ?>">
                                <?php 
                                if ($kycVerified) {
                                    echo 'Your verification is complete and your account is fully activated.';
                                } elseif ($kycPending) {
                                    echo 'Your verification is being processed. We\'ll update you within 24-48 hours.';
                                } else {
                                    echo 'Completing verification is a one-time process that ensures long-term access to our platform.';
                                }
                                ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // JavaScript for handling dark mode toggle
        const toggleDarkMode = () => {
            document.documentElement.classList.toggle('dark');
            localStorage.setItem('darkMode', document.documentElement.classList.contains('dark'));
            
            // Update button text
            const darkModeButton = document.getElementById('darkModeToggle');
            if (document.documentElement.classList.contains('dark')) {
                darkModeButton.textContent = 'Switch to Light Mode';
                document.body.style.background = 'linear-gradient(135deg, #1E3A8A, #1E40AF)';
            } else {
                darkModeButton.textContent = 'Switch to Dark Mode';
                document.body.style.background = 'linear-gradient(135deg, #EFF6FF, #DBEAFE)';
            }
        };

        // Check for dark mode preference
        if (localStorage.getItem('darkMode') === 'true') {
            document.documentElement.classList.add('dark');
            document.body.style.background = 'linear-gradient(135deg, #1E3A8A, #1E40AF)';
        }

        // Add a button to toggle dark mode
        const darkModeButton = document.createElement('button');
        darkModeButton.id = 'darkModeToggle';
        darkModeButton.textContent = document.documentElement.classList.contains('dark') ? 'Switch to Light Mode' : 'Switch to Dark Mode';
        darkModeButton.className = 'fixed bottom-4 right-4 p-3 bg-blue-600 hover:bg-blue-700 text-white rounded-lg shadow-lg transition-all duration-300';
        darkModeButton.onclick = toggleDarkMode;
        document.body.appendChild(darkModeButton);
    </script>
    
     <?php include './includes/footer.php'; ?>

</body>
</html>