<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if transaction data is set
if (!isset($_SESSION['transaction_data'])) {
    header("Location: xrps.php");
    exit();
}

$transaction_data = $_SESSION['transaction_data'];

// Database connection
$host = "localhost";
$user = "lrbpxbxy_userv";
$pass = "WHEagP2O9sOzG9gk"; // Replace with your actual database password
$dbname = "lrbpxbxy_dbv";

$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    $_SESSION['error'] = "Database connection failed. Please try again later.";
    header("Location: xrps.php");
    exit();
}

// Check balance
$stmt = $conn->prepare("SELECT xrp FROM users WHERE id = ?");
$stmt->bind_param("i", $transaction_data['user_id']);
$stmt->execute();
$stmt->bind_result($current_balance);
$stmt->fetch();
$stmt->close();

if ($current_balance === null) {
    $_SESSION['error'] = "User not found.";
    header("Location: xrps.php");
    exit();
}

// Debug: Log current values
error_log("Current Balance: " . $current_balance);
error_log("XRP Amount from Session: " . (isset($transaction_data['xrp']) ? $transaction_data['xrp'] : 'Not Set'));

// Validate that xrp is set and numeric
if (!isset($transaction_data['xrp']) || !is_numeric($transaction_data['xrp'])) {
    $_SESSION['error'] = "Invalid transaction amount.";
    header("Location: xrps.php");
    exit();
}

// Ensure both values are treated as strings for bcsub
$current_balance_str = (string)$current_balance;
$xrp_str     = (string)$transaction_data['xrp'];

// Calculate new balance using bcsub
$new_balance = bcsub($current_balance_str, $xrp_str, 8);

if ($new_balance === false || $new_balance === null) {
    $_SESSION['error'] = "Error calculating new balance.";
    header("Location: xrps.php");
    exit();
}

if (bccomp($new_balance, '0', 8) < 0) {
    $_SESSION['error'] = "Insufficient balance. Transaction cannot be processed.";
    header("Location: xrps.php");
    exit();
}

// Deduct balance
$stmt = $conn->prepare("UPDATE users SET xrp = ? WHERE id = ?");
$stmt->bind_param("si", $new_balance, $transaction_data['user_id']);
$stmt->execute();
$stmt->close();

// Generate transaction hash
$transhash = hash('sha256', $transaction_data['email'] . microtime(true) . random_int(1000, 9999));

// Insert transaction
$stmt = $conn->prepare("INSERT INTO crypto_withdrawal
    (user_id, email, network, wallet, xrp, ipaddress, name, total_amount, fee, transhash)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("isssdssdds",
    $transaction_data['user_id'],
    $transaction_data['email'],
    $transaction_data['network'],
    $transaction_data['wallet'],
    $transaction_data['xrp'], // xrp here remains as recorded
    $transaction_data['ipaddress'],
    $transaction_data['name'],
    $transaction_data['total_amount'], // This could be different if it includes fees
    $transaction_data['fee'],
    $transhash
);

if (!$stmt->execute()) {
    $_SESSION['error'] = "Transaction failed. Please try again.";
    header("Location: xrps.php");
    exit();
}
$stmt->close();

// Fetch real-time XRP price (replace with actual API call if needed)
$xrp_price = 0.5; // Example XRP price in USD, replace with actual API call
$usd_amount = $transaction_data['xrp'] * $xrp_price;
$usd_value = "$" . number_format($usd_amount, 2);

// Send email
require '../vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$mail = new PHPMailer(true);
try {
    $mail->isSMTP();
    $mail->Host = 'bitvros.com';
    $mail->SMTPAuth = true;
    $mail->Username = 'noreply@bitvros.com';
    $mail->Password = 'Bitv@9034';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port = 587;

    $mail->setFrom('noreply@bitvros.com', 'bitvros.com Wallet');
    $mail->addAddress($transaction_data['email'], $transaction_data['name']);
    
    $mail->isHTML(true);
    $mail->Subject = 'Transaction Confirmation - bitvros.com Wallet';
    $mail->Body = "<html><body><p>Dear " . htmlspecialchars($transaction_data['name']) . ",</p>
        <p>Your transaction was successful. Details:</p>
        <ul>
            <li><strong>Transaction ID:</strong> " . $transhash . "</li>
            <li><strong>Network:</strong> " . htmlspecialchars($transaction_data['network']) . "</li>
            <li><strong>Wallet:</strong> " . htmlspecialchars($transaction_data['wallet']) . "</li>
            <li><strong>Amount:</strong> " . $transaction_data['xrp'] . " XRP</li>
            <li><strong>USD Equivalent:</strong> " . $usd_value . "</li>
        </ul>
        <p>Thank you for using bitvros.com Wallet.</p>
        <p>&copy; " . date('Y') . " bitvros.com Wallet. All rights reserved.</p>
        </body></html>";

    $mail->AltBody = "Transaction Confirmation - bitvros.com Wallet\n\nDear " . $transaction_data['name'] . ",\n\nYour transaction was successful. Details:\n\n- Transaction ID: " . $transhash . "\n- Network: " . $transaction_data['network'] . "\n- Wallet: " . $transaction_data['wallet'] . "\n- Amount: " . $transaction_data['xrp'] . " XRP\n- USD Equivalent: " . $usd_value . "\n\nThank you for using bitvros.com Wallet.";

    $mail->send();
} catch (Exception $e) {
    $_SESSION['error'] = "Email could not be sent: " . $mail->ErrorInfo;
    header("Location: xrps.php");
    exit();
}

// Redirect to success page
header("Location: xrpsucces.php");
exit();
?>