<?php
session_start();

// Check if the user is logged in
if (!isset($_SESSION['user_email'])) {
    die("Error: User is not logged in. Please log in first.");
}

$email = $_SESSION['user_email'];

// Database connection
$servername = "localhost";
$username = "lrbpxbxy_userv";
$password = "WHEagP2O9sOzG9gk";
$dbname = "lrbpxbxy_dbv";
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Function to log errors (optional)
function logError($message) {
    error_log($message . "\n", 3, "error_log.txt"); // Log errors to a file
}

// Function to check user status and redirect if necessary
function checkUserStatus($conn, $email) {
    try {
        $stmt = $conn->prepare("SELECT status FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->bind_result($status);
        $stmt->fetch();
        $stmt->close();
        
        // Check if user is on hold
        if ($status === 'hold') {
            return './user/hold.php';
        }
        
        // Default redirect to dashboard
        return './user/dashboard.php';
        
    } catch (Exception $e) {
        logError("Status check error: " . $e->getMessage());
        return './user/dashboard.php'; // Default on error
    }
}

// Handle form submission via AJAX
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['pin'])) {
    $input_pin = trim($_POST['pin']);
    
    // Validate pin length
    if (strlen($input_pin) !== 4 || !is_numeric($input_pin)) {
        echo json_encode(["success" => false, "error" => "PIN must be exactly 4 digits."]);
        exit();
    }
    
    // Retrieve the user's stored PIN
    try {
        $stmt = $conn->prepare("SELECT pin FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->bind_result($stored_pin);
        $stmt->fetch();
        $stmt->close();
        
        if ($stored_pin && $input_pin === $stored_pin) {
            $_SESSION['authenticated'] = true;
            
            // Check user status and determine redirect
            $redirect_url = checkUserStatus($conn, $email);
            
            echo json_encode(["success" => true, "redirect" => $redirect_url]);
        } else {
            echo json_encode(["success" => false, "error" => "Incorrect PIN. Please try again."]);
        }
    } catch (Exception $e) {
        // Log error and display generic message
        logError("Database error: " . $e->getMessage());
        echo json_encode(["success" => false, "error" => "An error occurred. Please try again later."]);
    }
    exit();
}

// Close database connection
$conn->close();
?>
      <!-- Hidden Google Translate Element with Improved Styling -->
<style>
  /* Hide Google Translate widget and branding */
  .goog-te-banner-frame,
  .goog-te-balloon-frame,
  #goog-gt-tt,
  .goog-te-menu-value span,
  .VIpgJd-ZVi9od-l4eHX-hSRGPd,
  .VIpgJd-ZVi9od-aZ2wEe-wOHMyf,
  .VIpgJd-ZVi9od-aZ2wEe-OiiCO {
    display: none !important;
  }
  
  /* Hide the default Google Translate dropdown container */
  #google_translate_element {
    position: absolute;
    overflow: hidden;
    height: 0;
    visibility: hidden;
    opacity: 0;
  }
  
  /* Remove Google frame affecting site layout */
  body {
    top: 0 !important;
  }
  
  /* Fix for any shifted elements after translation */
  .skiptranslate,
  .goog-tooltip,
  .goog-tooltip:hover {
    display: none !important;
  }

  /* Custom language indicator styles, if you want to show it */
  .language-indicator {
    position: fixed;
    bottom: 20px;
    right: 20px;
    background: rgba(255, 255, 255, 0.9);
    padding: 8px 15px;
    border-radius: 50px;
    font-size: 12px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    z-index: 9999;
    opacity: 0.8;
    transition: opacity 0.3s;
    display: none; /* Hidden by default */
  }
  
  .language-indicator:hover {
    opacity: 1;
  }
</style>

<!-- Hidden Google Translate element -->
<div id="google_translate_element"></div>

<!-- Optional: Language indicator (uncomment to enable) -->
<!-- <div class="language-indicator">Translated to: <span id="current-language">English</span></div> -->

<script type="text/javascript">
  // Improved Google Translate implementation
  class SmartTranslator {
    constructor(options = {}) {
      this.options = {
        pageLanguage: 'en',
        autoDisplay: false,
        excludedCountries: ['IN', 'GH', 'LK'],
        cookieName: 'preferred_language',
        cookieExpiry: 30, // days
        debug: false,
        ...options
      };
      
      this.countryLangMap = {
        'US': 'en', 'CA': 'en', 'GB': 'en', 'AU': 'en', 'NZ': 'en', 'IE': 'en',
        'FR': 'fr', 'BE': 'nl', 'NL': 'nl', 'DE': 'de', 'AT': 'de', 'CH': 'de',
        'IT': 'it', 'ES': 'es', 'PT': 'pt', 'BR': 'pt', 'MX': 'es', 'AR': 'es',
        'CL': 'es', 'CO': 'es', 'PE': 'es', 'VE': 'es', 'EC': 'es', 'RU': 'ru',
        'PL': 'pl', 'CZ': 'cs', 'SK': 'sk', 'HU': 'hu', 'RO': 'ro', 'BG': 'bg',
        'GR': 'el', 'TR': 'tr', 'IL': 'he', 'SA': 'ar', 'AE': 'ar', 'EG': 'ar',
        'IN': 'hi', 'PK': 'ur', 'BD': 'bn', 'LK': 'si', 'NP': 'ne', 'ID': 'id',
        'MY': 'ms', 'PH': 'fil', 'TH': 'th', 'VN': 'vi', 'KR': 'ko', 'JP': 'ja',
        'CN': 'zh-CN', 'TW': 'zh-TW', 'HK': 'zh-TW', 'SG': 'en', 'FI': 'fi',
        'SE': 'sv', 'NO': 'no', 'DK': 'da', 'IS': 'is', 'EE': 'et', 'LV': 'lv',
        'LT': 'lt'
      };
      
      this.languageNames = {
        'en': 'English', 'fr': 'Français', 'es': 'Español', 'de': 'Deutsch',
        'it': 'Italiano', 'pt': 'Português', 'ru': 'Русский', 'ja': 'Japanese',
        'zh-CN': 'Chinese (Simplified)', 'zh-TW': 'Chinese (Traditional)',
        'ko': 'Korean', 'ar': 'Arabic', 'hi': 'Hindi', 'nl': 'Dutch'
        // Add more as needed
      };
      
      this.init();
    }
    
    init() {
      // Initialize after DOM is ready
      if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', () => this.setup());
      } else {
        this.setup();
      }
    }
    
    setup() {
      this.log('Initializing translator');
      
      // First check saved preference
      const savedLang = this.getCookie(this.options.cookieName);
      
      if (savedLang) {
        this.log(`Found saved language preference: ${savedLang}`);
        this.initTranslate(() => this.translateTo(savedLang));
      } else {
        // Otherwise detect based on location
        this.detectLanguage()
          .then(lang => {
            if (lang) {
              this.log(`Detected language: ${lang}`);
              this.initTranslate(() => this.translateTo(lang));
            } else {
              this.log('No translation needed');
              this.initTranslate(); // Just initialize without translating
            }
          })
          .catch(err => {
            this.log('Error detecting language:', err);
            this.initTranslate();
          });
      }
      
      // Remove Google's top bar effect after translation
      this.fixTopBarEffect();
    }
    
    initTranslate(callback) {
      // Create script element to load Google Translate
      const script = document.createElement('script');
      script.src = '//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit';
      script.async = true;
      
      // Define the callback function for Google Translate
      window.googleTranslateElementInit = () => {
        new google.translate.TranslateElement({
          pageLanguage: this.options.pageLanguage,
          autoDisplay: this.options.autoDisplay
        }, 'google_translate_element');
        
        if (callback) {
          // Give time for Google Translate to initialize
          setTimeout(callback, 1000);
        }
      };
      
      document.body.appendChild(script);
    }
    
    detectLanguage() {
      return fetch('https://ipapi.co/json/')
        .then(response => response.json())
        .then(data => {
          if (data && data.country) {
            if (this.options.excludedCountries.includes(data.country)) {
              return null; // Don't translate for excluded countries
            }
            return this.countryLangMap[data.country] || null;
          }
          return null;
        })
        .catch(error => {
          this.log('IP detection failed:', error);
          return null;
        });
    }
    
    translateTo(language) {
      if (!language) return;
      
      this.log(`Translating to: ${language}`);
      
      // Save preference
      this.setCookie(this.options.cookieName, language, this.options.cookieExpiry);
      
      let attempts = 0;
      const maxAttempts = 20;
      const intervalId = setInterval(() => {
        const comboBox = document.querySelector('.goog-te-combo');
        if (comboBox) {
          comboBox.value = language;
          comboBox.dispatchEvent(new Event('change'));
          clearInterval(intervalId);
          
          // Update language indicator if it exists
          const indicator = document.getElementById('current-language');
          if (indicator) {
            indicator.textContent = this.languageNames[language] || language;
            indicator.parentElement.style.display = 'block';
          }
        } else if (++attempts >= maxAttempts) {
          this.log('Failed to find translation dropdown');
          clearInterval(intervalId);
        }
      }, 500);
    }
    
    fixTopBarEffect() {
      // Monitor and fix Google's modification to the body tag
      const observer = new MutationObserver((mutations) => {
        mutations.forEach((mutation) => {
          if (mutation.target.nodeName === 'BODY' && 
              mutation.target.style.top && 
              mutation.target.style.top !== '0px') {
            mutation.target.style.top = '0px';
          }
        });
      });
      
      observer.observe(document.body, { 
        attributes: true, 
        attributeFilter: ['style'] 
      });
      
      // Additional fix for Google's top bar
      setInterval(() => {
        if (document.body.style.top !== '' && document.body.style.top !== '0px') {
          document.body.style.top = '0px';
        }
      }, 1000);
    }
    
    // Helper functions
    getCookie(name) {
      const match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
      return match ? match[2] : null;
    }
    
    setCookie(name, value, days) {
      let expires = '';
      if (days) {
        const date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        expires = '; expires=' + date.toUTCString();
      }
      document.cookie = name + '=' + value + expires + '; path=/; SameSite=Lax';
    }
    
    log(...args) {
      if (this.options.debug) {
        console.log('SmartTranslator:', ...args);
      }
    }
  }

  // Initialize the translator
  document.addEventListener('DOMContentLoaded', () => {
    new SmartTranslator({
      excludedCountries: ['IN', 'GH', 'LK'],
      debug: false // Set to true for debugging
    });
  });
</script>
      
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Secure PIN Verification</title>
  
  <!-- Favicon -->
  <link rel="icon" href="https://bitvros.com/session/favicon.png" type="image/x-icon">
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    /* Neumorphic Styles with Whitish Grey and Blue Accents */
    body {
      background: #f5f7fa;
    }
    .neumorphic-card {
      background: #f5f7fa;
      border-radius: 15px;
      box-shadow: 8px 8px 16px #cfd7e2,
                  -8px -8px 16px #ffffff;
    }
    .neumorphic-input {
      background: #f5f7fa;
      border: none;
      border-radius: 10px;
      box-shadow: inset 4px 4px 8px #cfd7e2,
                  inset -4px -4px 8px #ffffff;
      padding: 1rem;
      font-size: 1.25rem;
      text-align: center;
      outline: none;
      color: #3d4863;
    }
    .neumorphic-keypad-button {
      background: #f5f7fa;
      border: none;
      border-radius: 50%;
      box-shadow: 4px 4px 8px #cfd7e2,
                  -4px -4px 8px #ffffff;
      padding: 1rem;
      font-size: 1.25rem;
      cursor: pointer;
      transition: all 0.2s ease-in-out;
      color: #3d4863;
    }
    .neumorphic-keypad-button:active {
      box-shadow: inset 4px 4px 8px #cfd7e2,
                  inset -4px -4px 8px #ffffff;
    }
    .neumorphic-delete-button {
      background: #f5f7fa;
      border: none;
      border-radius: 50%;
      box-shadow: 4px 4px 8px #cfd7e2,
                  -4px -4px 8px #ffffff;
      padding: 1rem;
      font-size: 1.25rem;
      color: #3d4863;
      cursor: pointer;
      transition: all 0.2s ease-in-out;
    }
    .neumorphic-delete-button:active {
      box-shadow: inset 4px 4px 8px #cfd7e2,
                  inset -4px -4px 8px #ffffff;
    }
    .neumorphic-submit {
      background: #f5f7fa;
      border: none;
      border-radius: 20px;
      box-shadow: 4px 4px 8px #cfd7e2,
                  -4px -4px 8px #ffffff;
      padding: 1rem;
      font-size: 1.25rem;
      width: 100%;
      transition: all 0.2s ease-in-out;
      color: #3d4863;
      cursor: pointer;
    }
    .neumorphic-submit:active {
      box-shadow: inset 4px 4px 8px #cfd7e2,
                  inset -4px -4px 8px #ffffff;
    }
  </style>
</head>
<body class="min-h-screen flex items-center justify-center p-4">
  <div class="form-content neumorphic-card p-8 max-w-md w-full">
     
     
    

<script type="text/javascript">
  function googleTranslateElementInit() {
    new google.translate.TranslateElement({ pageLanguage: 'en' }, 'google_translate_element');
  }

  const countryLangMap = {
    'US': 'en', 'CA': 'en', 'GB': 'en', 'AU': 'en', 'NZ': 'en', 'IE': 'en',
    'FR': 'fr', 'BE': 'nl', 'NL': 'nl', 'DE': 'de', 'AT': 'de', 'CH': 'de',
    'IT': 'it', 'ES': 'es', 'PT': 'pt', 'BR': 'pt', 'MX': 'es', 'AR': 'es',
    'CL': 'es', 'CO': 'es', 'PE': 'es', 'VE': 'es', 'EC': 'es', 'RU': 'ru',
    'PL': 'pl', 'CZ': 'cs', 'SK': 'sk', 'HU': 'hu', 'RO': 'ro', 'BG': 'bg',
    'GR': 'el', 'TR': 'tr', 'IL': 'he', 'SA': 'ar', 'AE': 'ar', 'EG': 'ar',
    'IN': 'hi', 'PK': 'ur', 'BD': 'bn', 'LK': 'si', 'NP': 'ne', 'ID': 'id',
    'MY': 'ms', 'PH': 'fil', 'TH': 'th', 'VN': 'vi', 'KR': 'ko', 'JP': 'ja',
    'CN': 'zh-CN', 'TW': 'zh-TW', 'HK': 'zh-TW', 'SG': 'en', 'FI': 'fi',
    'SE': 'sv', 'NO': 'no', 'DK': 'da', 'IS': 'is', 'EE': 'et', 'LV': 'lv',
    'LT': 'lt'
  };

  function getLanguageFromIP() {
    return fetch('https://ipapi.co/json/')
      .then(response => response.json())
      .then(data => {
        if (data && data.country) {
          return countryLangMap[data.country] || 'en';
        }
        return 'en';
      })
      .catch(error => {
        console.error('Language detection failed:', error);
        return 'en';
      });
  }

  function translatePageTo(language) {
    let attempts = 0;
    const intervalId = setInterval(() => {
      const combo = document.querySelector('.goog-te-combo');
      if (combo) {
        combo.value = language;
        combo.dispatchEvent(new Event('change'));
        clearInterval(intervalId);
      }
      attempts++;
      if (attempts > 20) clearInterval(intervalId);
    }, 500);
  }

  document.addEventListener("DOMContentLoaded", function () {
    getLanguageFromIP().then(function(lang) {
      setTimeout(function() {
        translatePageTo(lang);
      }, 2000);
    });
  });
</script>

<script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

<!-- CSS for floating Google Translate widget on the bottom-left and hiding the logo -->
<style>
  .floating-translate {
    position: fixed;
    bottom: 20px;
    left: 20px; /* Positioned to the left-hand side */
    z-index: 9999;
    background-color: #8a2be2; /* Optional: purple background */
    padding: 10px; /* Optional: internal spacing */
    border-radius: 8px; /* Optional: rounded corners */
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.25); /* Optional: subtle shadow */
  }

  /* Hide the default Google Translate logo */
  .goog-te-gadget img {
    display: none;
  }
</style>

    <div class="flex items-center mb-6">
      <img src="<?= htmlspecialchars($_SESSION['user_picture'] ?? 'default-avatar.png'); ?>" class="w-16 h-16 rounded-full object-cover" alt="avatar">
      <div class="ml-4">
        <p class="text-lg font-medium text-gray-700"><?= htmlspecialchars($_SESSION['user_name'] ?? 'User') ?></p>
        <p class="text-sm text-gray-600"><?= htmlspecialchars($_SESSION['user_email'] ?? 'user@example.com') ?></p>
      </div>
    </div>
    <div class="text-center mb-6">
      <h3 class="text-2xl font-semibold mb-2 text-gray-700">Welcome</h3>
      <p class="text-gray-600">Please enter your PIN</p>
    </div>
    <form id="pin-form" class="text-left">
      <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
      <div class="mb-4">
        <label for="pin-input" class="block text-lg font-medium text-gray-700">PIN CODE</label>
        <div class="flex items-center space-x-2 mt-2">
          <input id="pin-input" name="pin" type="password" class="neumorphic-input w-full" placeholder="****" maxlength="4" readonly>
        </div>
      </div>
      <div id="container" class="grid grid-cols-3 gap-4 mb-6"></div>
      <p id="error-message" class="text-red-600 text-center mb-4 hidden"></p>
      <div class="text-center">
        <button type="submit" id="submit-btn" class="neumorphic-submit" disabled>Submit</button>
      </div>
    </form>
  </div>
  <script>
    const pinInput = document.getElementById("pin-input");
    const container = document.getElementById("container");
    const errorMessage = document.getElementById("error-message");
    const form = document.getElementById("pin-form");
    const submitBtn = document.getElementById("submit-btn");
    
    function updateSubmitState() {
      submitBtn.disabled = pinInput.value.length !== 4;
    }
    
    function shuffleButtons() {
      container.innerHTML = '';
      let numbers = [...Array(10).keys()].sort(() => Math.random() - 0.5);
      
      numbers.forEach(num => {
        const btn = document.createElement("button");
        btn.className = 'neumorphic-keypad-button';
        btn.innerText = num;
        btn.onclick = (e) => {
          e.preventDefault();
          if (pinInput.value.length < 4) {
            pinInput.value += num;
            updateSubmitState();
          }
        };
        container.appendChild(btn);
      });
      
      const deleteButton = document.createElement("button");
      deleteButton.className = 'neumorphic-delete-button';
      deleteButton.innerText = "X";
      deleteButton.onclick = (e) => {
        e.preventDefault();
        pinInput.value = pinInput.value.slice(0, -1);
        updateSubmitState();
      };
      container.appendChild(deleteButton);
    }
    
    shuffleButtons();
    
    form.addEventListener("submit", async (event) => {
      event.preventDefault();
      if (pinInput.value.length !== 4) {
        errorMessage.innerText = "Please enter a 4-digit PIN.";
        errorMessage.classList.remove("hidden");
        return;
      }
      submitBtn.disabled = true;
      const formData = new FormData(form);
      try {
        const response = await fetch("", { method: "POST", body: formData });
        const data = await response.json();
        if (data.success) {
          window.location.href = data.redirect;
        } else {
          errorMessage.innerText = data.error;
          errorMessage.classList.remove("hidden");
          pinInput.value = "";
          shuffleButtons();
          updateSubmitState();
        }
      } catch (error) {
        errorMessage.innerText = "An error occurred. Please try again.";
        errorMessage.classList.remove("hidden");
      }
      submitBtn.disabled = false;
    });
  </script>
</body>
</html>
