<?php
session_start();

// Include database connection
require_once 'db.php';  // Ensure this file connects to your database correctly

// Step 1: Get the code from the URL
$code = isset($_GET['code']) ? $_GET['code'] : null;

if ($code) {
    // Step 2: Set your client details here
    $client_id = '337036502177-00m95p509iim6gvt67rvn17p936rkdci.apps.googleusercontent.com';
    $client_secret = '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';
    $redirect_uri = 'https://primemarketspro.com/session/auth/callback.php'; // Redirect URI from Google Developer Console

    // Step 3: Exchange the authorization code for an access token
    $token_url = 'https://oauth2.googleapis.com/token';
    $token_data = [
        'code' => $code,
        'client_id' => $client_id,
        'client_secret' => $client_secret,
        'redirect_uri' => $redirect_uri,
        'grant_type' => 'authorization_code'
    ];

    // Step 4: Make POST request to get the access token
    $token_options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($token_data)
        ]
    ];
    $token_context  = stream_context_create($token_options);
    $response = file_get_contents($token_url, false, $token_context);
    $json_response = json_decode($response);

    if (isset($json_response->access_token)) {
        // Step 5: Use the access token to get user info
        $access_token = $json_response->access_token;
        $user_info_url = 'https://www.googleapis.com/oauth2/v3/userinfo?access_token=' . $access_token;

        // Fetch user data
        $user_info = file_get_contents($user_info_url);
        $user_data = json_decode($user_info);

        // Step 6: Get the User's IP Address & Determine Country
        $user_ip = $_SERVER['REMOTE_ADDR'];
        $country = 'Unknown'; // Default value

        if (!empty($user_ip) && $user_ip !== '127.0.0.1') { // Ignore local IPs
            $ip_api_url = "http://ip-api.com/json/{$user_ip}?fields=status,country";
            $ip_response = @file_get_contents($ip_api_url);

            if ($ip_response) {
                $ip_data = json_decode($ip_response, true);
                if ($ip_data['status'] === 'success' && !empty($ip_data['country'])) {
                    $country = $ip_data['country'];
                }
            }
        }

        // Step 7: Check if user exists in your database
        $stmt = $conn->prepare("SELECT * FROM users WHERE google_id = ?");
        $stmt->bind_param("s", $user_data->sub);
        $stmt->execute();
        $result = $stmt->get_result();
        $user = $result->fetch_assoc();

        if ($user) {
            // Update user's country and status if they already exist
            $updateStmt = $conn->prepare("UPDATE users SET country = ?, status = ? WHERE google_id = ?");
            $status = 'active';
            $updateStmt->bind_param("sss", $country, $status, $user_data->sub);
            $updateStmt->execute();

            $_SESSION['user'] = $user;
            header('Location: dashboard.php');
            exit();
        } else {
            // Default values for required fields
            $default_pin = ''; 
            $default_phone = ''; // Avoid NULL error
            $default_balance = '00';

            // Step 8: If user doesn't exist, register them with country and status
            $stmt = $conn->prepare("INSERT INTO users (google_id, name, email, country, status, pin, phone, balance) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            $google_id = $user_data->sub;
            $name = $user_data->name;
            $email = $user_data->email;
            $status = 'active';
            $stmt->bind_param("ssssssss", $google_id, $name, $email, $country, $status, $default_pin, $default_phone, $default_balance);
            $stmt->execute();

            // Fetch the newly created user
            $userId = $conn->insert_id;
            $stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
            $stmt->bind_param("i", $userId);
            $stmt->execute();
            $result = $stmt->get_result();
            $newUser = $result->fetch_assoc();

            // Log the new user in
            $_SESSION['user'] = $newUser;
            header('Location: dashboard.php');
            exit();
        }
    } else {
        exit('Error retrieving access token');
    }
} else {
    exit('No code received');
}
?>
