<?php
session_start(); // Start the session

// Ensure user is logged in
if (!isset($_SESSION['user_email'])) {
    die("Error: User is not logged in. Please log in first.");
}

// Database connection
$servername = "localhost";
$username = "wptlgmnb_userp";
$password = "Qliox4ITygj6Vh4V";
$dbname = "wptlgmnb_dbp";

$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Import PHPMailer classes using Composer's autoload
require __DIR__ . '/vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Fetch user information (assuming the table has 'name' and 'mtccode' columns)
$user_email = $_SESSION['user_email'];
$stmt = $conn->prepare("SELECT name, mtccode FROM users WHERE email = ?");
$stmt->bind_param("s", $user_email);
$stmt->execute();
$result = $stmt->get_result();
if ($row = $result->fetch_assoc()) {
    $name = trim($row['name']);
    $mtccode = trim($row['mtccode']);
} else {
    $name = "User";
    $mtccode = "";
}
$stmt->close();

// Helper function to display a Tailwind toast
function showTailwindToast($message, $color = 'red') {
    // $color can be 'red', 'green', etc. to indicate error or success
    echo "
    <div 
        id='toast' 
        class='fixed top-5 right-5 bg-$color-500 text-white px-4 py-3 rounded shadow transition-opacity duration-300'
        style='z-index:9999;'
    >
        $message
    </div>
    <script>
        // Automatically remove the toast after 3 seconds
        setTimeout(function() {
            var toast = document.getElementById('toast');
            if (toast) {
                toast.style.opacity = '0';
                setTimeout(function() {
                    toast.remove();
                }, 300);
            }
        }, 3000);
    </script>
    ";
}

// Validate email address before sending email
if (!filter_var($user_email, FILTER_VALIDATE_EMAIL)) {
    // If email is invalid, show a Tailwind toast
    showTailwindToast('Invalid email address', 'red');
} else {
    // Send welcome email on every login
    $mail = new PHPMailer(true);
    try {
        // Turn off verbose debug output so errors don’t appear on the page
        $mail->SMTPDebug  = 0;
        
        // SMTP server settings
        $mail->isSMTP();
        $mail->Host       = 'mail.primemarketspro.com'; // SMTP server (adjust as needed)
        $mail->SMTPAuth   = true;
        $mail->Username   = 'noreply@primemarketspro.com'; // SMTP username
        $mail->Password   = 'Coinlu@504'; // SMTP password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port       = 587;
        
        // Recipients
        $mail->setFrom('noreply@primemarketspro.com', 'Primemarketspro Platform');
        $mail->addAddress($user_email);
        
        // Email content settings: HTML email with plain text alternative
        $mail->isHTML(true);
        $mail->Subject = 'Welcome to Primemarketspro Platform';
        
        // Construct the HTML body in a card/table format
        $htmlBody = '
        <html>
        <head>
            <meta charset="UTF-8">
            <title>Welcome to Primemarketspro Platform</title>
        </head>
        <body style="margin:0; padding:0; background-color:#f4f4f4;">
            <table align="center" border="0" cellpadding="0" cellspacing="0" width="600" style="border-collapse:collapse; background-color:#ffffff; box-shadow:0 2px 3px rgba(0,0,0,0.1);">
                <tr>
                    <td align="center" style="padding: 40px 0 30px 0;">
                        <img src="https://primemarketspro.com/session/favicon.png" alt="Primemarketspro Logo" width="200" style="display: block;" />
                    </td>
                </tr>
                <tr>
                    <td style="padding: 40px 30px 40px 30px; font-family: Arial, sans-serif; font-size: 16px; line-height: 24px;">
                        <p>Dear ' . htmlspecialchars($name) . ',</p>
                        <p>Welcome to our platform! We are excited to have you onboard.</p>
                        <p>Your registered email is: ' . htmlspecialchars($user_email) . '</p>
                        <p>If you did not sign up for this account, please report immediately to <a href="mailto:support@primemarketspro.com">support@primemarketspro.com</a>.</p>
                        <p>Best regards,<br/>The Primemarketspro Team</p>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 20px 30px 20px 30px; background-color:#eeeeee; text-align:center; font-family: Arial, sans-serif; font-size: 12px;">
                        <p>This email was sent to you because you signed up on the Primemarketspro platform.</p>
                        <p>If you wish to unsubscribe, please click <a href="mailto:unsubscribe@primemarketspro.com">here</a>.</p>
                    </td>
                </tr>
            </table>
        </body>
        </html>
        ';
        
        $mail->Body    = $htmlBody;
        $mail->AltBody = "Dear $name,\n\nWelcome to our platform! We are excited to have you onboard.\nYour registered email is: $user_email.\n\nIf you did not sign up for this account, please report to support@primemarketspro.com.\n\nBest regards,\nThe Primemarketspro Team";
        
        // Additional headers to improve deliverability (anti-spam best practices)
        $mail->addCustomHeader('X-Mailer', 'PHP/' . phpversion());
        $mail->addCustomHeader('List-Unsubscribe', '<mailto:unsubscribe@primemarketspro.com>');
        // Let PHPMailer generate a compliant MessageID automatically
        
        $mail->send();
        
    } catch (Exception $e) {
        // Check if the error indicates an invalid recipient
        if (strpos($mail->ErrorInfo, '550-5.1.1') !== false) {
            showTailwindToast('Invalid email address', 'red');
        } else {
            // Log the error, but don’t display it in detail on the page
            error_log('PHPMailer error (welcome email): ' . $mail->ErrorInfo);
            // Show a generic error toast
            showTailwindToast('Set your PIN to enhance the security of your wallet.', 'green');
        }
    }
}

// Function to log errors (optional)
function logError($message) {
    error_log($message . "\n", 3, "error_log.txt");
}

// Debug: log the retrieved MTC code
logError("Retrieved MTC code: " . $mtccode);

// Process PIN submission if available
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['pin'])) {
    $pin = $_POST['pin'];
    $email = $_SESSION['user_email']; // Get logged-in user email

    // Validate PIN format (must be exactly 4 digits)
    if (!preg_match('/^\d{4}$/', $pin)) {
        $error = "PIN must be exactly 4 digits.";
    } else {
        // Save PIN to the database
        $stmt = $conn->prepare("UPDATE users SET pin = ? WHERE email = ?");
        $stmt->bind_param("ss", $pin, $email);
        
        if ($stmt->execute()) {
            $_SESSION['stored_pin'] = $pin; // Save PIN in session
            
            // Redirect to verify PIN page
            header("Location: verify_pin.php");
            exit();
        } else {
            logError("Database error: " . $stmt->error);
            $error = "Error: Unable to save PIN. Please try again.";
        }
        $stmt->close();
    }
}
$conn->close();
?>


<?php session_start(); ?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">

  <meta content="Join MarketChain Educative Club by creating your account." property="og:description">
  <meta content="https://primemarketspro.com/session/logob.png" property="og:image">
  <meta property="og:type" content="website">
  <meta content="summary_large_image" name="twitter:card">

  <!-- ✅ Favicon & Touch Icons -->
  <link rel="icon" href="https://primemarketspro.com/session/favicon.png" type="image/svg+xml">
  <link rel="shortcut icon" href="https://primemarketspro.com/session/favicon.png" type="image/svg+xml">
  <link rel="apple-touch-icon" href="https://primemarketspro.com/session/favicon.png">

  <!-- ✅ Optional PNG/ICO Fallbacks for older browsers -->
  <link rel="icon" href="https://primemarketspro.com/favicon.png" type="image/png">
  <link rel="icon" href="https://primemarketspro.com/favicon.ico" sizes="any">

  <title>Crypto Quiz & PIN Setup</title>

  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>

  <!-- Include SweetAlert2 Library -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <!-- Include AnimateJS Library -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/3.2.1/anime.min.js"></script>

  <!-- Tailwind Config -->
  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: {
            primary: '#8A2BE2', // Purple
            secondary: '#9932CC', // Dark Orchid
            accent: '#BA55D3', // Medium Orchid
            danger: '#FF0000',
            success: '#4CAF50'
          }
        }
      }
    };
  </script>

  <!-- Custom Styles -->
  <style>
    body {
      background: #FFFFFF;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    .pin-display {
      transition: all 0.3s ease;
    }
    .pin-display:focus {
      transform: scale(1.05);
    }
    .pin-btn {
      transition: all 0.2s ease;
    }
    .pin-btn:active {
      transform: scale(0.95);
    }
    .form-container {
      background: #FFFFFF;
      box-shadow: 0 8px 32px rgba(138, 43, 226, 0.2);
    }
    .glow-effect {
      box-shadow: 0 0 15px rgba(138, 43, 226, 0.5);
    }
    .option-btn {
      transition: all 0.2s ease;
    }
    .option-btn:hover {
      transform: translateX(5px);
    }
    .option-btn.selected {
      border-color: #8A2BE2;
      background-color: rgba(138, 43, 226, 0.1);
    }
    .option-btn.correct {
      border-color: #4CAF50;
      background-color: rgba(76, 175, 80, 0.2);
    }
    .option-btn.incorrect {
      border-color: #FF0000;
      background-color: rgba(255, 0, 0, 0.2);
    }
    #auto-translate {
      position: fixed;
      top: 20px;
      right: 20px;
      z-index: 9999;
    }
    .progress-bar {
      height: 6px;
      background: #E6E6FA;
      border-radius: 3px;
      overflow: hidden;
    }
    .progress-value {
      height: 100%;
      background: #8A2BE2;
      border-radius: 3px;
      transition: width 0.3s ease;
    }
  </style>
</head>





<script type="text/javascript">
  function googleTranslateElementInit() {
    new google.translate.TranslateElement({ pageLanguage: 'en' }, 'google_translate_element');
  }

  const countryLangMap = {
    'US': 'en', 'CA': 'en', 'GB': 'en', 'AU': 'en', 'NZ': 'en', 'IE': 'en',
    'FR': 'fr', 'BE': 'nl', 'NL': 'nl', 'DE': 'de', 'AT': 'de', 'CH': 'de',
    'IT': 'it', 'ES': 'es', 'PT': 'pt', 'BR': 'pt', 'MX': 'es', 'AR': 'es',
    'CL': 'es', 'CO': 'es', 'PE': 'es', 'VE': 'es', 'EC': 'es', 'RU': 'ru',
    'PL': 'pl', 'CZ': 'cs', 'SK': 'sk', 'HU': 'hu', 'RO': 'ro', 'BG': 'bg',
    'GR': 'el', 'TR': 'tr', 'IL': 'he', 'SA': 'ar', 'AE': 'ar', 'EG': 'ar',
    'IN': 'hi', 'PK': 'ur', 'BD': 'bn', 'LK': 'si', 'NP': 'ne', 'ID': 'id',
    'MY': 'ms', 'PH': 'fil', 'TH': 'th', 'VN': 'vi', 'KR': 'ko', 'JP': 'ja',
    'CN': 'zh-CN', 'TW': 'zh-TW', 'HK': 'zh-TW', 'SG': 'en', 'FI': 'fi',
    'SE': 'sv', 'NO': 'no', 'DK': 'da', 'IS': 'is', 'EE': 'et', 'LV': 'lv',
    'LT': 'lt'
  };

  function getLanguageFromIP() {
    return fetch('https://ipapi.co/json/')
      .then(response => response.json())
      .then(data => {
        if (data && data.country) {
          return countryLangMap[data.country] || 'en';
        }
        return 'en';
      })
      .catch(error => {
        console.error('Language detection failed:', error);
        return 'en';
      });
  }

  function translatePageTo(language) {
    let attempts = 0;
    const intervalId = setInterval(() => {
      const combo = document.querySelector('.goog-te-combo');
      if (combo) {
        combo.value = language;
        combo.dispatchEvent(new Event('change'));
        clearInterval(intervalId);
      }
      attempts++;
      if (attempts > 20) clearInterval(intervalId);
    }, 500);
  }

  document.addEventListener("DOMContentLoaded", function () {
    getLanguageFromIP().then(function(lang) {
      setTimeout(function() {
        translatePageTo(lang);
      }, 2000);
    });
  });
</script>

<script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
<body class="min-h-screen flex items-center justify-center p-4 select-none text-gray-800">
  <!-- Background Pattern -->
  <div class="fixed inset-0 z-0 opacity-10">
    <div class="absolute inset-0" style="background-image: radial-gradient(circle at 25px 25px, #8A2BE2 2%, transparent 0%), radial-gradient(circle at 75px 75px, #9932CC 2%, transparent 0%); background-size: 100px 100px;"></div>
  </div>

  <!-- User Info -->
  <div class="absolute top-4 left-4 flex items-center space-x-3 z-10 bg-white bg-opacity-90 p-2 rounded-lg shadow-md">
    <img src="<?= htmlspecialchars(!empty($_SESSION['picture']) ? $_SESSION['picture'] : 'https://primemarketspro.com/session/favicon.png'); ?>" alt="User Image" class="w-10 h-10 rounded-full border-2 border-purple-600">
    <span class="text-lg font-semibold text-purple-800">
      Welcome! <?= htmlspecialchars($_SESSION['user_name'] ?? 'User'); ?>
    </span>
    <!-- Auto Translation Indicator -->
    <div id="auto-translate" class="bg-white bg-opacity-90 p-2 rounded-lg flex items-center space-x-2 shadow-md">
      <div class="w-2 h-2 rounded-full bg-purple-500"></div>
      <span class="text-sm font-medium text-purple-800">Auto-translating for your region</span>
    </div>
  </div>

  <!-- Quiz Container -->
  <div id="quiz-container" class="form-container rounded-2xl p-8 max-w-md w-full z-10 relative border-2 border-purple-200">
    <div class="relative z-10">
      <h2 class="text-3xl font-bold text-center mb-6 text-purple-800">Quick Crypto Quiz</h2>
      
      <!-- Progress Bar -->
      <div class="progress-bar mb-6">
        <div class="progress-value" style="width: 0%"></div>
      </div>
      
      <!-- Quiz questions will be injected here -->
      <div id="quiz-questions-container"></div>
      
      <!-- Quiz Navigation Buttons -->
      <div class="flex justify-between mt-8">
        <button id="skip-quiz" class="px-6 py-3 bg-gray-200 text-purple-800 rounded-xl hover:bg-gray-300 transition duration-200 border border-purple-300">Skip Quiz</button>
        <button id="next-question" class="px-6 py-3 bg-purple-600 text-white rounded-xl hover:bg-purple-700 transition duration-200 disabled:opacity-50 disabled:cursor-not-allowed" disabled>Next</button>
      </div>
    </div>
  </div>

  <!-- PIN Container (Initially Hidden) -->
  <div id="pin-container" class="form-container rounded-2xl p-8 max-w-md w-full z-10 relative hidden border-2 border-purple-200">
    <div class="relative z-10">
      <h2 class="text-3xl font-bold text-center mb-8 text-purple-800">Set Your PIN</h2>

      <!-- Error Message: Shown only once using a session flash -->
      <?php if (isset($_SESSION['error'])): ?>
        <p class="text-center text-xl font-semibold text-red-500 mb-4"><?= $_SESSION['error']; ?></p>
        <?php unset($_SESSION['error']); ?>
      <?php endif; ?>

      <!-- PIN Form -->
      <form method="POST" action="" class="text-left">
        <label class="block text-lg font-medium text-purple-800 mb-2">Enter a 4-digit PIN:</label>
        <div class="flex justify-center mt-2">
          <div class="flex space-x-4" id="pin-displays-container">
            <input type="text" class="pin-display w-14 h-14 border-2 border-purple-300 rounded-lg text-center text-2xl bg-white text-purple-800" maxlength="1" readonly>
            <input type="text" class="pin-display w-14 h-14 border-2 border-purple-300 rounded-lg text-center text-2xl bg-white text-purple-800" maxlength="1" readonly>
            <input type="text" class="pin-display w-14 h-14 border-2 border-purple-300 rounded-lg text-center text-2xl bg-white text-purple-800" maxlength="1" readonly>
            <input type="text" class="pin-display w-14 h-14 border-2 border-purple-300 rounded-lg text-center text-2xl bg-white text-purple-800" maxlength="1" readonly>
          </div>
          <input id="pin-input" name="pin" type="hidden" required>
        </div>

        <!-- Numeric Keypad -->
        <div class="grid grid-cols-3 gap-4 mt-10" id="keypad">
          <?php for ($i = 1; $i <= 9; $i++): ?>
            <button type="button" class="pin-btn bg-purple-100 text-purple-800 p-4 rounded-xl text-2xl font-bold border-2 border-purple-300 hover:bg-purple-200 hover:border-purple-500 transition duration-200"><?= $i ?></button>
          <?php endfor; ?>
          <div></div> <!-- Empty space -->
          <button type="button" class="pin-btn bg-purple-100 text-purple-800 p-4 rounded-xl text-2xl font-bold border-2 border-purple-300 hover:bg-purple-200 hover:border-purple-500 transition duration-200">0</button>
          <button type="button" id="delete-btn" class="bg-purple-100 text-red-500 p-4 rounded-xl text-2xl font-bold border-2 border-purple-300 hover:bg-purple-200 hover:border-red-500 transition duration-200">⌫</button>
        </div>

        <button type="submit" id="submit-btn" class="mt-8 px-6 py-3 bg-purple-600 text-white rounded-xl w-full hover:bg-purple-700 transition duration-200 focus:ring-4 focus:ring-purple-300 disabled:opacity-50 disabled:cursor-not-allowed font-bold text-lg" disabled>Set PIN</button>
      </form>
    </div>
  </div>

  <!-- Quiz and PIN Scripts -->
  <script>
    document.addEventListener("DOMContentLoaded", function () {
      // Language detection based on IP address (placeholder)
      let userLanguage = navigator.language || navigator.userLanguage;
      document.getElementById('auto-translate').querySelector('span').textContent =
        `Auto-translating to ${userLanguage.split('-')[0].toUpperCase()}`;
      
      // Define 30 quiz questions
      const allQuestions = [
        {
          question: "What is Bitcoin?",
          options: [
            { text: "Digital currency", correct: true },
            { text: "Physical gold coin", correct: false },
            { text: "Bank account type", correct: false }
          ]
        },
        {
          question: "What is forex trading?",
          options: [
            { text: "Stock trading", correct: false },
            { text: "Currency exchange", correct: true },
            { text: "Real estate investing", correct: false }
          ]
        },
        {
          question: "What is a crypto wallet?",
          options: [
            { text: "Physical wallet for coins", correct: false },
            { text: "Bank account", correct: false },
            { text: "Digital storage for crypto", correct: true }
          ]
        },
        {
          question: "Which term describes a decentralized digital asset?",
          options: [
            { text: "Centralized token", correct: false },
            { text: "Cryptocurrency", correct: true },
            { text: "Traditional currency", correct: false }
          ]
        },
        {
          question: "Which technology powers most cryptocurrencies?",
          options: [
            { text: "Cloud computing", correct: false },
            { text: "Blockchain", correct: true },
            { text: "Artificial intelligence", correct: false }
          ]
        },
        {
          question: "What does ICO stand for?",
          options: [
            { text: "Initial Coin Offering", correct: true },
            { text: "International Crypto Organization", correct: false },
            { text: "Instant Currency Operation", correct: false }
          ]
        },
        {
          question: "Which one is a popular crypto exchange?",
          options: [
            { text: "Binance", correct: true },
            { text: "Etsy", correct: false },
            { text: "Walmart", correct: false }
          ]
        },
        {
          question: "What does DeFi stand for?",
          options: [
            { text: "Decentralized Finance", correct: true },
            { text: "Defined Finance", correct: false },
            { text: "Digital Foreign Exchange", correct: false }
          ]
        },
        {
          question: "Which coin is known as 'digital gold'?",
          options: [
            { text: "Ethereum", correct: false },
            { text: "Bitcoin", correct: true },
            { text: "Ripple", correct: false }
          ]
        },
        {
          question: "Which technology ensures secure transactions in crypto?",
          options: [
            { text: "Encryption", correct: false },
            { text: "Blockchain", correct: true },
            { text: "Big Data", correct: false }
          ]
        },
        {
          question: "What is a smart contract?",
          options: [
            { text: "Self-executing contract with terms in code", correct: true },
            { text: "Traditional legal contract", correct: false },
            { text: "Service agreement", correct: false }
          ]
        },
        {
          question: "Which crypto is primarily used for smart contracts?",
          options: [
            { text: "Dogecoin", correct: false },
            { text: "Ethereum", correct: true },
            { text: "Litecoin", correct: false }
          ]
        },
        {
          question: "What does NFT stand for?",
          options: [
            { text: "Non-Fungible Token", correct: true },
            { text: "New Financial Transaction", correct: false },
            { text: "National Forex Trade", correct: false }
          ]
        },
        {
          question: "Which crypto market metric indicates market sentiment?",
          options: [
            { text: "Volume", correct: false },
            { text: "Volatility", correct: true },
            { text: "Liquidity", correct: false }
          ]
        },
        {
          question: "What is a blockchain fork?",
          options: [
            { text: "A split in a blockchain network", correct: true },
            { text: "A type of crypto wallet", correct: false },
            { text: "A smart contract update", correct: false }
          ]
        },
        {
          question: "Which element is essential for transaction verification in Bitcoin?",
          options: [
            { text: "Miner", correct: true },
            { text: "Investor", correct: false },
            { text: "Broker", correct: false }
          ]
        },
        {
          question: "What is staking in crypto?",
          options: [
            { text: "Investing in stocks", correct: false },
            { text: "Holding cryptocurrencies to support network operations", correct: true },
            { text: "Day trading", correct: false }
          ]
        },
        {
          question: "Which term describes a digital ledger?",
          options: [
            { text: "Blockchain", correct: true },
            { text: "Distributed database", correct: false },
            { text: "Central bank ledger", correct: false }
          ]
        },
        {
          question: "What is liquidity in crypto markets?",
          options: [
            { text: "Ease of trading an asset", correct: true },
            { text: "Crypto mining process", correct: false },
            { text: "Blockchain speed", correct: false }
          ]
        },
        {
          question: "Which crypto is known for its privacy features?",
          options: [
            { text: "Monero", correct: true },
            { text: "Bitcoin", correct: false },
            { text: "Ethereum", correct: false }
          ]
        },
        {
          question: "What does halving refer to in Bitcoin?",
          options: [
            { text: "Reducing mining rewards by half", correct: true },
            { text: "Splitting a Bitcoin in two", correct: false },
            { text: "A type of encryption", correct: false }
          ]
        },
        {
          question: "Which protocol is used for secure data transfer?",
          options: [
            { text: "HTTP", correct: false },
            { text: "HTTPS", correct: true },
            { text: "FTP", correct: false }
          ]
        },
        {
          question: "Which one is considered a layer-2 solution?",
          options: [
            { text: "Lightning Network", correct: true },
            { text: "Bitcoin blockchain", correct: false },
            { text: "Ethereum smart contracts", correct: false }
          ]
        },
        {
          question: "What is the main purpose of a decentralized exchange (DEX)?",
          options: [
            { text: "Centralized trading", correct: false },
            { text: "Peer-to-peer trading without a middleman", correct: true },
            { text: "Banking services", correct: false }
          ]
        },
        {
          question: "What is yield farming?",
          options: [
            { text: "Growing digital crops", correct: false },
            { text: "Earning rewards by lending cryptocurrencies", correct: true },
            { text: "Mining cryptocurrencies", correct: false }
          ]
        },
        {
          question: "Which currency is used as the fuel for transactions on the Ethereum network?",
          options: [
            { text: "Ether (ETH)", correct: true },
            { text: "Bitcoin (BTC)", correct: false },
            { text: "Ripple (XRP)", correct: false }
          ]
        },
        {
          question: "What does the term 'HODL' mean in crypto culture?",
          options: [
            { text: "Hold On for Dear Life", correct: true },
            { text: "High On Digital Liquidity", correct: false },
            { text: "Hot Of Day Limit", correct: false }
          ]
        },
        {
          question: "Which process validates and adds transactions to the blockchain?",
          options: [
            { text: "Mining", correct: true },
            { text: "Farming", correct: false },
            { text: "Trading", correct: false }
          ]
        }
      ];
      
      // Shuffle and select 3 random questions for the session
      function shuffleArray(array) {
        for (let i = array.length - 1; i > 0; i--) {
          const j = Math.floor(Math.random() * (i + 1));
          [array[i], array[j]] = [array[j], array[i]];
        }
        return array;
      }
      
      const selectedQuestions = shuffleArray([...allQuestions]).slice(0, 3);
      
      // Dynamically generate HTML for the selected questions
      const quizContainerEl = document.getElementById("quiz-questions-container");
      selectedQuestions.forEach((q, index) => {
        const questionDiv = document.createElement("div");
        questionDiv.classList.add("question-section");
        if(index !== 0) {
          questionDiv.classList.add("hidden");
        }
        questionDiv.id = `question-${index+1}`;
        
        // Create question title
        const questionTitle = document.createElement("h3");
        questionTitle.classList.add("text-xl", "font-semibold", "mb-4", "text-purple-800");
        questionTitle.textContent = `${index+1}. ${q.question}`;
        questionDiv.appendChild(questionTitle);
        
        // Create options container
        const optionsContainer = document.createElement("div");
        optionsContainer.classList.add("space-y-3");
        
        q.options.forEach(option => {
          const optionBtn = document.createElement("button");
          optionBtn.type = "button";
          optionBtn.classList.add("option-btn", "w-full", "text-left", "p-4", "bg-purple-50", "rounded-lg", "border", "border-purple-300", "hover:border-purple-500", "text-purple-800");
          optionBtn.textContent = option.text;
          optionBtn.setAttribute("data-value", option.text);
          if(option.correct) {
            optionBtn.setAttribute("data-correct", "true");
          }
          optionsContainer.appendChild(optionBtn);
        });
        
        questionDiv.appendChild(optionsContainer);
        quizContainerEl.appendChild(questionDiv);
      });
      
      // Quiz Variables
      const quizContainer = document.getElementById('quiz-container');
      const pinContainer = document.getElementById('pin-container');
      const questions = document.querySelectorAll('.question-section');
      const nextButton = document.getElementById('next-question');
      const skipButton = document.getElementById('skip-quiz');
      const progressBar = document.querySelector('.progress-value');
      let currentQuestion = 0;
      let answers = [];
      let correctAnswers = 0;

      // Animate quiz container appearance
      anime({
        targets: '#quiz-container',
        opacity: [0, 1],
        translateY: [20, 0],
        easing: 'easeOutExpo',
        duration: 1000
      });

      // Option button click handlers
      document.querySelectorAll('.option-btn').forEach(button => {
        button.addEventListener('click', function() {
          // Deselect all options in the current question
          const currentQuestionEl = questions[currentQuestion];
          currentQuestionEl.querySelectorAll('.option-btn').forEach(btn => {
            btn.classList.remove('selected');
          });
          
          // Mark this button as selected
          this.classList.add('selected');
          
          // Enable next button
          nextButton.disabled = false;
          
          // Animate next button
          anime({
            targets: nextButton,
            scale: [1, 1.05, 1],
            duration: 600,
            easing: 'easeOutElastic(1, .8)'
          });
        });
      });

      // Next button click handler
      nextButton.addEventListener('click', function() {
        const selectedOption = questions[currentQuestion].querySelector('.option-btn.selected');
        const allOptions = questions[currentQuestion].querySelectorAll('.option-btn');
        const correctOption = questions[currentQuestion].querySelector('.option-btn[data-correct="true"]');
        
        if (selectedOption) {
          answers.push(selectedOption.getAttribute('data-value'));
          
          if (selectedOption.getAttribute('data-correct') === 'true') {
            correctAnswers++;
            selectedOption.classList.add('correct');
          } else {
            selectedOption.classList.add('incorrect');
            correctOption.classList.add('correct');
          }
          
          allOptions.forEach(opt => {
            opt.disabled = true;
            opt.style.pointerEvents = 'none';
          });
          
          setTimeout(function() {
            moveToNextQuestion();
          }, 1000);
          
          nextButton.disabled = true;
        }
      });

      // Function to move to next question or finish the quiz
      function moveToNextQuestion() {
        anime({
          targets: questions[currentQuestion],
          opacity: [1, 0],
          translateX: [0, -50],
          easing: 'easeOutExpo',
          duration: 300,
          complete: function() {
            questions[currentQuestion].classList.add('hidden');
            currentQuestion++;
            progressBar.style.width = `${(currentQuestion / questions.length) * 100}%`;
            
            if (currentQuestion < questions.length) {
              questions[currentQuestion].classList.remove('hidden');
              anime({
                targets: questions[currentQuestion],
                opacity: [0, 1],
                translateX: [50, 0],
                easing: 'easeOutExpo',
                duration: 300
              });
              nextButton.disabled = true;
            } else {
              finishQuiz();
            }
          }
        });
      }

      // Skip Quiz button handler
      skipButton.addEventListener('click', function() {
        anime({
          targets: quizContainer,
          opacity: [1, 0],
          translateY: [0, -20],
          easing: 'easeOutExpo',
          duration: 500,
          complete: function() {
            quizContainer.classList.add('hidden');
            showPinSetup();
          }
        });
      });

      // Function to finish quiz and show PIN setup with a success message
      function finishQuiz() {
        anime({
          targets: quizContainer,
          opacity: [1, 0],
          translateY: [0, -20],
          easing: 'easeOutExpo',
          duration: 500,
          complete: function () {
            quizContainer.classList.add('hidden');
            Swal.fire({
              title: 'Quiz Completed!',
              text: `Your score: ${correctAnswers}/${questions.length}\nSet your PIN to enhance the security of your wallet.`,
              icon: 'success',
              background: '#FFFFFF',
              color: '#8A2BE2',
              confirmButtonColor: '#8A2BE2',
              confirmButtonText: '<span style="color: #FFFFFF">Continue</span>',
              timer: 2000,
              timerProgressBar: true,
              showConfirmButton: false
            }).then(() => {
              showPinSetup();
            });
          }
        });
      }

      // Function to display the PIN setup container
      function showPinSetup() {
        pinContainer.classList.remove('hidden');
        anime({
          targets: pinContainer,
          opacity: [0, 1],
          translateY: [20, 0],
          easing: 'easeOutExpo',
          duration: 1000
        });
        initializePinSetup();
      }

      // PIN Setup Functionality
      function initializePinSetup() {
        const pinInput = document.getElementById("pin-input");
        const pinDisplays = document.querySelectorAll(".pin-display");
        const buttons = document.querySelectorAll(".pin-btn");
        const deleteBtn = document.getElementById("delete-btn");
        const submitBtn = document.getElementById("submit-btn");
        let pinCode = "";
        let verifiedMTC = true;

        anime({
          targets: '#pin-displays-container .pin-display',
          scale: [0.8, 1],
          opacity: [0, 1],
          delay: anime.stagger(100, {start: 300}),
          easing: 'easeOutExpo',
          duration: 800
        });

        anime({
          targets: '#keypad button',
          scale: [0.8, 1],
          opacity: [0, 1],
          delay: anime.stagger(50, {grid: [3, 4], from: 'center', start: 600}),
          easing: 'easeOutExpo',
          duration: 800
        });

        function updatePinDisplay() {
          pinInput.value = pinCode;
          pinDisplays.forEach((display, index) => {
            if (index < pinCode.length) {
              display.value = "•";
              display.classList.add('border-purple-600', 'glow-effect');
              anime({
                targets: display,
                scale: [1.1, 1],
                duration: 200,
                easing: 'easeOutExpo'
              });
            } else {
              display.value = "";
              display.classList.remove('border-purple-600', 'glow-effect');
            }
          });
          if (pinCode.length === 4 && verifiedMTC) {
            submitBtn.disabled = false;
            anime({
              targets: submitBtn,
              scale: [1, 1.05, 1],
              duration: 600,
              easing: 'easeOutElastic(1, .8)'
            });
          } else {
            submitBtn.disabled = true;
          }
        }

        deleteBtn.addEventListener("click", function() {
          if (pinCode.length > 0) {
            const lastFilledDisplay = pinDisplays[pinCode.length - 1];
            anime({
              targets: lastFilledDisplay,
              scale: [1, 0.9],
              opacity: [1, 0.5, 1],
              duration: 300,
              easing: 'easeOutExpo',
              complete: function() {
                pinCode = pinCode.slice(0, -1);
                updatePinDisplay();
              }
            });
          }
        });

        buttons.forEach(button => {
          button.addEventListener("click", function () {
            if (pinCode.length < 4) {
              const digit = this.textContent.trim();
              anime({
                targets: this,
                scale: [1, 0.9, 1],
                duration: 300,
                easing: 'easeOutExpo'
              });
              if (/^\d$/.test(digit)) {
                pinCode += digit;
                updatePinDisplay();
              }
            }
          });
          
          let lastTap = 0;
          button.addEventListener("touchend", function (event) {
            const currentTime = new Date().getTime();
            const tapLength = currentTime - lastTap;
            if (tapLength < 300 && tapLength > 0) {
              event.preventDefault();
            }
            lastTap = currentTime;
          });
        });

        submitBtn.addEventListener("mouseenter", function() {
          if (!this.disabled) {
            anime({
              targets: this,
              scale: 1.03,
              duration: 300,
              easing: 'easeOutExpo'
            });
          }
        });
        
        submitBtn.addEventListener("mouseleave", function() {
          anime({
            targets: this,
            scale: 1,
            duration: 300,
            easing: 'easeOutExpo'
          });
        });
      }
    });
  </script>
  
  
</body>
</html>