<?php
session_start(); // Start the session at the top of the script

// Database connection details (update with your actual credentials)
$host = 'localhost'; 
$username = 'wptlgmnb_userp'; 
$password = 'Qliox4ITygj6Vh4V'; 
$database = 'wptlgmnb_dbp';

// Create the database connection
$conn = new mysqli($host, $username, $password, $database);

// Check if the connection is successful
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Function to check if the user is logged in
function isLoggedIn() {
    return isset($_SESSION['user_email']) && !empty($_SESSION['user_email']);
}

// Function to set the user's email in the session
function setSessionEmail($userEmail) {
    $_SESSION['user_email'] = $userEmail;
}

// Function to get the user's email from the session
function getSessionEmail() {
    if (isLoggedIn()) {
        return $_SESSION['user_email'];
    } else {
        return null;
    }
}

// Function to fetch user details based on session email
function getUserDetails($conn) {
    $userEmail = getSessionEmail();
    
    if ($userEmail) {
        $query = "SELECT google_id, name, email, created_at, picture, email_verified, pin, status, country, phone, balance,percent, btc, eth, usdt, xrp, doge, ada, pepe, sol, bnb, extra, bonus,profit,plan,msgstatus,message,mtccode,update_time 
                  FROM users WHERE email = ?";
        $stmt = $conn->prepare($query);
        
        // Check if prepare was successful
        if ($stmt === false) {
            die('Prepare failed: ' . $conn->error);
        }
        
        $stmt->bind_param('s', $userEmail); // Bind email parameter to query
        $stmt->execute();
        $stmt->store_result();
        
        if ($stmt->num_rows > 0) {
            $stmt->bind_result($google_id, $name, $email, $created_at, $picture, $email_verified, $pin, $status, $country, $phone, $balance,$percent, $btc, $eth, $usdt, $xrp, $doge, $ada, $pepe, $sol, $bnb, $extra,$bonus,$profit, $plan,$msgstatus,$message,$mtccode,$update_time);
            $stmt->fetch();
            return [
                'google_id'      => $google_id,
                'name'           => $name,
                'email'          => $email,
                'extra'          => $extra,
                'created_at'     => $created_at,
                'picture'        => $picture,
                'email_verified' => $email_verified,
                'pin'            => $pin,
                'status'         => $status,
                'country'        => $country,
                'phone'          => $phone,
                'balance'        => $balance,
                'percent'        => $percent,
                'btc'            => $btc,
                'eth'            => $eth,
                'usdt'           => $usdt,
                'xrp'            => $xrp,
                'doge'           => $doge,
                'ada'            => $ada,
                'pepe'           => $pepe,
                'sol'            => $sol,
                'bnb'            => $bnb,
                'extra'          => $extra,
                'bonus'          => $bonus,
                'plan'          => $plan,
                'message'       => $message,
                'msgstatus'     => $msgstatus,
                'profit'          => $profit,
                'mtccode'          => $mtccode,
                'update_time'    => $update_time
            ];
        } else {
            return null; // No user found with the given email
        }
    } else {
        return null; // No email in session
    }
}

// Function to log out and destroy the session
function logout() {
    session_unset(); // Unset all session variables
    session_destroy(); // Destroy the session
    header('Location: login.php'); // Redirect to login page after logging out
    exit();
}
?>
