<?php
// header.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require 'config.php';

// Fetch all tables from your database
$tables = [];
try {
    $stmt = $conn->query("SHOW TABLES");
    while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
        $tables[] = $row[0];
    }
} catch (PDOException $e) {
    // In production, log errors instead of displaying
    $tables = [];
}

// Map table names to friendly nav labels
$navNames = [
    'admins'         => 'Manage Admins',
    'blogs'          => 'Manage Blogs',
    'kyc_submissions'=> 'Manage KYC',
    'password_resets'=> 'Manage Password Resets',
    'payments'       => 'Manage Payments',
    'trade'          => 'Manage Trade',
    'crypto_stakes'   => 'Manage Sessions',
    'transactions'   => 'Manage Transactions',
    'crypto_withdrawal'    => 'Manage Withdrawals',
    'users'          => 'Manage Users',
    'wallets'        => 'Manage Wallet'
];

// Fetch record counts for each table
$tableCounts = [];
foreach ($tables as $table) {
    try {
        $stmt = $conn->query("SELECT COUNT(*) as count FROM `$table`");
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $tableCounts[$table] = $result['count'];
    } catch (PDOException $e) {
        $tableCounts[$table] = 'N/A';
    }
}

// Set a static last updated time for demo purposes
$lastUpdated = "13:15";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= isset($pageTitle) ? $pageTitle : "Admin Panel" ?></title>
  <!-- Favicon -->
  <link rel="icon" type="image/x-icon" href="favicon.ico">
  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <!-- SweetAlert2 -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <style>
    /* Preloader styles */
    #preloader {
      background: #fff;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      z-index: 9999;
      display: flex;
      align-items: center;
      justify-content: center;
      transition: opacity 0.5s ease;
    }
    #preloader.hidden {
      opacity: 0;
      pointer-events: none;
    }
    /* Mobile nav dropdown transition */
    #mobile-nav {
      transform-origin: top;
      transition: transform 0.3s ease;
    }
    .hidden-scale {
      transform: scaleY(0);
    }
    .visible-scale {
      transform: scaleY(1);
    }
  </style>
</head>
<body class="bg-gray-100">
  <!-- Preloader -->
  <div id="preloader">
    <div class="animate-spin rounded-full h-16 w-16 border-t-4 border-blue-500"></div>
  </div>

  <!-- Header -->
  <header class="bg-gradient-to-r from-indigo-600 to-purple-600 text-white shadow-lg">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
      <div class="flex items-center justify-between h-16">
        <!-- Logo and Title -->
        <div class="flex items-center">
          <img src="data:image/svg+xml;charset=UTF-8,%3Csvg%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%20viewBox%3D%220%200%20448%20512%22%3E%3C!--!Font%20Awesome%20Free%206.7.2%20by%20%40fontawesome%20-%20https%3A//fontawesome.com%20License%20-%20https%3A//fontawesome.com/license/free%20Copyright%202025%20Fonticons%2C%20Inc.--%3E%3Cpath%20fill%3D%22%23ffffff%22%20d%3D%22M96%20128a128%20128%200%201%200%20256%200A128%20128%200%201%200%2096%20128zm94.5%20200.2l18.6%2031L175.8%20483.1l-36-146.9c-2-8.1-9.8-13.4-17.9-11.3C51.9%20342.4%200%20405.8%200%20481.3c0%2017%2013.8%2030.7%2030.7%2030.7l131.7%200c0%200%200%200%20.1%200l5.5%200%20112%200%205.5%200c0%200%200%200%20.1%200l131.7%200c17%200%2030.7-13.8%2030.7-30.7c0-75.5-51.9-138.9-121.9-156.4c-8.1-2-15.9%203.3-17.9%2011.3l-36%20146.9L238.9%20359.2l18.6-31c6.4-10.7-1.3-24.2-13.7-24.2L224%20304l-19.7%200c-12.4%200-20.1%2013.6-13.7%2024.2z%22/%3E%3C/svg%3E" alt="Logo" class="h-12 w-12">

          <span class="text-xl font-bold tracking-tight">Admin Dashboard</span>
        </div>
        <!-- Desktop Navigation -->
        <nav class="hidden md:flex space-x-4">
          <a href="index.php" class="px-3 py-2 rounded-md text-sm font-medium hover:bg-indigo-500 transition-colors">
            <i class="fas fa-home mr-2"></i>Dashboard
          </a>
          <a href="change_password.php" class="px-3 py-2 rounded-md text-sm font-medium hover:bg-indigo-500 transition-colors">
            <i class="fas fa-key mr-2"></i>Change Password
          </a>
          <a href="logout.php" class="px-3 py-2 rounded-md text-sm font-medium hover:bg-indigo-500 transition-colors">
            <i class="fas fa-sign-out-alt mr-2"></i>Logout
          </a>
          <!-- Dropdown for Manage Tables -->
          <div class="relative group">
            <button class="px-3 py-2 rounded-md text-sm font-medium hover:bg-indigo-500 transition-colors flex items-center">
              <i class="fas fa-table mr-2"></i>Manage Tables <i class="fas fa-chevron-down ml-1"></i>
            </button>
            <!-- Dropdown Menu -->
            <div class="absolute right-0 mt-2 w-80 bg-white text-gray-800 rounded-md shadow-lg z-10 hidden group-hover:block">
              <div class="p-4 space-y-2">
                <?php
                // Loop through our defined navNames for tables
                foreach ($navNames as $tableKey => $friendlyName) {
                  // Only display if table exists
                  if (in_array($tableKey, $tables)) {
                    $count = isset($tableCounts[$tableKey]) ? $tableCounts[$tableKey] : 'N/A';
                    echo '<div class="border-b pb-2">';
                    echo '<div class="flex items-center justify-between">';
                    echo '<span class="font-semibold">' . $friendlyName . '</span>';
                    echo '<span class="text-xs text-gray-500">Last updated: ' . $lastUpdated . '</span>';
                    echo '</div>';
                    echo '<div class="flex items-center justify-between mt-1">';
                    echo '<span class="text-sm text-gray-600">' . $count . ' records</span>';
                    echo '<a href="manage.php?table=' . $tableKey . '" class="text-indigo-600 hover:text-indigo-800 text-sm font-medium">';
                    echo '<i class="fas fa-external-link-alt mr-1"></i>Manage Table';
                    echo '</a>';
                    echo '</div>';
                    echo '</div>';
                  }
                }
                ?>
              </div>
            </div>
          </div>
        </nav>
        <!-- Mobile Menu Button -->
        <button id="mobile-menu-toggle" class="md:hidden p-2 rounded-md hover:bg-indigo-500 focus:outline-none focus:ring-2 focus:ring-white">
          <i id="menu-icon" class="fas fa-bars text-2xl"></i>
        </button>
      </div>
    </div>
    <!-- Mobile Navigation Dropdown -->
    <nav id="mobile-nav" class="hidden-scale hidden md:hidden bg-gradient-to-r from-indigo-600 to-purple-600 px-4 pb-4">
      <a href="index.php" class="block px-3 py-2 rounded-md text-base font-medium hover:bg-indigo-500">
        <i class="fas fa-home mr-2"></i>Dashboard
      </a>
      <a href="change_password.php" class="block px-3 py-2 rounded-md text-base font-medium hover:bg-indigo-500">
        <i class="fas fa-key mr-2"></i>Change Password
      </a>
      <a href="logout.php" class="block px-3 py-2 rounded-md text-base font-medium hover:bg-indigo-500">
        <i class="fas fa-sign-out-alt mr-2"></i>Logout
      </a>
      <!-- Mobile Dropdown for Manage Tables -->
      <div class="mt-2 border-t border-indigo-400 pt-2">
        <span class="block text-base font-medium mb-2"><i class="fas fa-table mr-2"></i>Manage Tables</span>
        <?php
          foreach ($navNames as $tableKey => $friendlyName) {
            if (in_array($tableKey, $tables)) {
              $count = isset($tableCounts[$tableKey]) ? $tableCounts[$tableKey] : 'N/A';
              echo '<div class="mb-2">';
              echo '<div class="flex items-center justify-between text-sm text-gray-200">';
              echo '<span>' . $friendlyName . '</span>';
              echo '<span>Last updated: ' . $lastUpdated . '</span>';
              echo '</div>';
              echo '<div class="flex items-center justify-between text-xs text-gray-300 mt-1">';
              echo '<span>' . $count . ' records</span>';
              echo '<a href="manage.php?table=' . $tableKey . '" class="text-indigo-200 hover:text-indigo-100">';
              echo '<i class="fas fa-external-link-alt mr-1"></i>Manage Table';
              echo '</a>';
              echo '</div>';
              echo '</div>';
            }
          }
        ?>
      </div>
    </nav>
  </header>

  <script>
    // Preloader fade-out
    window.addEventListener('load', function() {
      const preloader = document.getElementById('preloader');
      preloader.classList.add('hidden');
      setTimeout(() => { preloader.style.display = 'none'; }, 500);
    });

    // Mobile menu toggle functionality
    document.addEventListener('DOMContentLoaded', () => {
      const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
      const mobileNav = document.getElementById('mobile-nav');
      const menuIcon = document.getElementById('menu-icon');

      mobileMenuToggle.addEventListener('click', (e) => {
        e.stopPropagation();
        if (mobileNav.classList.contains('hidden-scale')) {
          mobileNav.classList.remove('hidden-scale');
          mobileNav.classList.add('visible-scale');
          mobileNav.classList.remove('hidden');
          menuIcon.classList.remove('fa-bars');
          menuIcon.classList.add('fa-times');
          mobileMenuToggle.setAttribute('aria-expanded', 'true');
        } else {
          mobileNav.classList.remove('visible-scale');
          mobileNav.classList.add('hidden-scale');
          menuIcon.classList.remove('fa-times');
          menuIcon.classList.add('fa-bars');
          mobileMenuToggle.setAttribute('aria-expanded', 'false');
          setTimeout(() => {
            if (mobileNav.classList.contains('hidden-scale')) {
              mobileNav.classList.add('hidden');
            }
          }, 300);
        }
      });

      // Close mobile nav when clicking outside
      document.addEventListener('click', (e) => {
        if (!mobileNav.contains(e.target) && !mobileMenuToggle.contains(e.target)) {
          if (!mobileNav.classList.contains('hidden-scale')) {
            mobileNav.classList.remove('visible-scale');
            mobileNav.classList.add('hidden-scale');
            menuIcon.classList.remove('fa-times');
            menuIcon.classList.add('fa-bars');
            mobileMenuToggle.setAttribute('aria-expanded', 'false');
            setTimeout(() => {
              if (mobileNav.classList.contains('hidden-scale')) {
                mobileNav.classList.add('hidden');
              }
            }, 300);
          }
        }
      });
    });
  </script>
