<?php
session_start();
if (!isset($_SESSION['transaction_data'])) {
    header("Location: dashboard.php");
    exit();
}

$transaction_data = $_SESSION['transaction_data'];

// Determine coin-specific values based on network and set the processor file accordingly
$coin_id = '';
$icon_url = '';
$networkName = '';
$networkFullName = '';
$processorFile = '';

if ($transaction_data['network'] === 'btc') {
    $coin_id = 'bitcoin';
    $icon_url = "https://primemarketspro.com/cryptos/bitcoin.png";
    $networkName = 'BTC';
    $networkFullName = 'Bitcoin';
    $processorFile = "btcprocessor.php";
} elseif ($transaction_data['network'] === 'eth') {
    $coin_id = 'ethereum';
    $icon_url = "https://primemarketspro.com/cryptos/eth.png";
    $networkName = 'ETH';
    $networkFullName = 'Ethereum';
    $processorFile = "ethprocessor.php";
} elseif ($transaction_data['network'] === 'usdt') {
    $coin_id = 'tether'; // CoinGecko's id for Tether
    $icon_url = "https://primemarketspro.com/cryptos/usdt.png";
    $networkName = 'USDT';
    $networkFullName = 'Tether';
    $processorFile = "usdtprocessor.php";
} elseif ($transaction_data['network'] === 'xrp') {
    $coin_id = 'ripple'; // CoinGecko's id for XRP is "ripple"
    $icon_url = "https://primemarketspro.com/cryptos/xrp.png";
    $networkName = 'XRP';
    $networkFullName = 'Ripple';
    $processorFile = "xrpprocessor.php";
} elseif ($transaction_data['network'] === 'sol' || $transaction_data['network'] === 'solana') {
    // Updated condition: now handles both "sol" and "solana"
    $coin_id = 'solana';
    $icon_url = "https://primemarketspro.com/cryptos/sol.png";
    $networkName = 'SOL';
    $networkFullName = 'Solana';
    $processorFile = "processsoln.php";
} elseif ($transaction_data['network'] === 'bnb') {
    $coin_id = 'binancecoin';
    $icon_url = "https://primemarketspro.com/cryptos/bnb.png";
    $networkName = 'BNB';
    $networkFullName = 'Binance Coin';
    $processorFile = "bnbprocessor.php";
} elseif ($transaction_data['network'] === 'pepe') {
    $coin_id = 'pepe';
    $icon_url = "https://primemarketspro.com/cryptos/pepe.png";
    $networkName = 'PEPE';
    $networkFullName = 'Pepe Coin';
    $processorFile = "pepeprocessor.php";
} elseif ($transaction_data['network'] === 'doge') {
    $coin_id = 'dogecoin';
    $icon_url = "https://primemarketspro.com/cryptos/doge.png";
    $networkName = 'DOGE';
    $networkFullName = 'Dogecoin';
    $processorFile = "dogeprocessor.php";
} else {
    // Default to Ethereum if network is not recognized
    $coin_id = 'ethereum';
    $icon_url = "https://primemarketspro.com/cryptos/eth.png";
    $networkName = 'ETH';
    $networkFullName = 'Ethereum';
    $processorFile = "ethprocessor.php";
}

// Fetch conversion rate from CoinGecko API (in USD per coin)
$api_url = "https://api.coingecko.com/api/v3/simple/price?ids=" . urlencode($coin_id) . "&vs_currencies=usd";
$api_response = file_get_contents($api_url);
if ($api_response !== false) {
    $price_data = json_decode($api_response, true);
    if (isset($price_data[$coin_id]['usd'])) {
        $conversion_rate = floatval($price_data[$coin_id]['usd']);
    } else {
        $conversion_rate = 0;
    }
} else {
    $conversion_rate = 0;
}

// Assume session data has a key 'total_amount' representing the USD amount
// and 'fee' representing the fee in USD
$total_usd = isset($transaction_data['total_amount']) ? floatval($transaction_data['total_amount']) : 0;
$usd_fee = isset($transaction_data['fee']) ? floatval($transaction_data['fee']) : 0;

// Convert USD amounts to coin amounts using the conversion rate (USD per coin)
$coin_amount = $conversion_rate > 0 ? $total_usd / $conversion_rate : 0;
$fee_coin = $conversion_rate > 0 ? $usd_fee / $conversion_rate : 0;

// Calculate total coin amount (coin amount + fee) and its USD equivalent
$total_coin = $coin_amount + $fee_coin;
$total_usd_calculated = $total_coin * $conversion_rate;
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Swipe to Confirm</title>
  
   <!-- Favicon -->
  <link rel="icon" href="https://primemarketspro.com/session/favicon.png" type="image/x-icon">
  
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <!-- Tailwind CSS CDN -->
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    /* Base styles and resets */
    html, body {
      height: 100%;
      margin: 0;
      padding: 0;
      -webkit-user-select: none;
         -ms-user-select: none;
             user-select: none;
    }
    body {
      background-color: #ffffff;
    }
    /* Container to center the content and limit its width */
    .container {
      width: 100%;
      max-width: 420px;
      margin: 0 auto;
      position: relative;
      height: 100%;
    }
    /* Header styling for the back and notification icons */
    .header {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      padding: 0.5rem;
      display: flex;
      justify-content: space-between;
      align-items: center;
      z-index: 10;
    }
    /* Coin details section styling */
    #btcDetails {
      display: flex;
      flex-direction: column;
      align-items: center;
      width: 100%;
      padding: 0 1rem;
    }
    /* Horizontal Swipe Track styling */
    .swipe-track {
      position: relative;
      width: 300px;
      height: 80px;
      background: linear-gradient(to right, #881ff9, #93c5fd);
      border-radius: 40px;
      display: flex;
      align-items: center;
      padding: 2px;
      margin: 1.5rem auto; /* Center the slider track */
    }
    /* Horizontal Swipe Button styling */
    .swipe-button {
      position: absolute;
      left: 2px;  /* Start on the left */
      width: 56px;
      height: 56px;
      background-color: #881ff9;
      border-radius: 50%;
      display: flex;
      justify-content: center;
      align-items: center;
      cursor: pointer;
      touch-action: none;
      transition: left 0.3s ease-in-out, opacity 0.3s ease-in-out;
      opacity: 1;
    }
    /* Fade out effect for the swipe button upon confirmation */
    .swipe-button.fade-out {
      opacity: 0;
    }
  </style>
</head>
<body>
  <div class="container">
    <!-- Header with Back and Notifications Icons -->
    <div class="header">
      <button onclick="goBack()" class="text-blue-500 hover:text-blue-700">
        <!-- Back Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
        </svg>
      </button>
      <button onclick="openNotifications()" class="text-blue-500 hover:text-blue-700">
        <!-- Bell Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C8.67 6.165 8 7.388 8 8.75v5.408c0 .621-.226 1.213-.63 1.656L6 17h5m4 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
        </svg>
      </button>
    </div>

    <!-- Main Content: Offset by header -->
    <div class="h-full flex flex-col justify-center items-center mt-8">
      <!-- Form Start -->
      <form id="confirmationForm" action="<?= htmlspecialchars($processorFile) ?>" method="POST">
        <!-- Transaction Details Section -->
        <div id="btcDetails">
          <!-- Header with Icon and Title -->
          <div class="mt-6 mb-2 flex flex-col items-center">
            <!-- Updated Icon Section -->
             <div class="w-16 h-16 bg-blue-600 bg-opacity-10 rounded-full flex items-center justify-center mx-auto mb-4">
              <img src="<?= htmlspecialchars($icon_url) ?>" alt="<?= htmlspecialchars($networkFullName) ?>" class="w-8 h-8">
            </div>
            <h1 class="text-lg font-bold">Confirm Send <?= htmlspecialchars($networkName) ?></h1>
          </div>
          <!-- Display Amount and Conversion Rate -->
          <div class="text-center mb-6">
            <p class="text-2xl font-bold text-gray-800"><?= number_format($coin_amount, 6) ?> <?= htmlspecialchars($networkName) ?></p>
            <p class="text-gray-700 text-sm">1 <?= htmlspecialchars($networkName) ?> ≈ $<?= number_format($conversion_rate, 2) ?></p>
          </div>
          <!-- Transaction Details Card -->
          <div class="bg-white w-full max-w-sm shadow rounded-lg p-4 mb-6">
            <!-- Hidden Inputs -->
            <input type="hidden" name="amount_usd" value="<?= number_format($total_usd, 2, '.', '') ?>">
            <input type="hidden" name="amount_coin" value="<?= htmlspecialchars($coin_amount) ?>">
            <input type="hidden" name="conversion_rate" value="<?= htmlspecialchars($conversion_rate) ?>">
            <input type="hidden" name="fee_coin" value="<?= htmlspecialchars($fee_coin) ?>">
            <input type="hidden" name="recipient" value="<?= htmlspecialchars($transaction_data['wallet']) ?>">
  
            <!-- Amount Row -->
            <div class="flex justify-between items-center mb-3">
              <div class="flex items-center text-gray-800 font-bold space-x-2">
                <svg class="w-5 h-5 text-gray-800" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M12 1C5.925 1 1 5.925 1 12c0 6.074 4.925 11 11 11 6.074 0 11-4.926 11-11 0-6.075-4.926-11-11-11zm0 20C6.486 21 2 16.514 2 11.999 2 7.485 6.486 3 12 3s10 4.485 10 8.999C22 16.514 17.514 21 12 21z"></path>
                </svg>
                <span>Amount</span>
              </div>
              <span class="font-bold text-gray-800">$<?= number_format($total_usd, 2) ?></span>
            </div>
            <!-- Fee Row -->
            <div class="flex justify-between items-center mb-3">
              <div class="flex items-center text-gray-800 font-bold space-x-2">
                <svg class="w-5 h-5 text-gray-800" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M12 1a9 9 0 019 9c0 7.732-9 13-9 13S3 17.732 3 10a9 9 0 019-9zm0 12a3 3 0 100-6 3 3 0 000 6z" />
                </svg>
                <span>Fee</span>
              </div>
              <span class="font-bold text-gray-800"><?= number_format($fee_coin, 8) ?> <?= htmlspecialchars($networkName) ?></span>
            </div>
            <!-- You Get Row -->
            <div class="flex justify-between items-center mb-3">
              <div class="flex items-center text-gray-800 font-bold space-x-2">
                <svg class="w-5 h-5 text-gray-800" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M12 2C6.489 2 2 6.489 2 12s4.489 10 10 10c5.512 0 10-4.489 10-10S17.512 2 12 2zm4 11h-3v5h-2v-5H8v-2h3V6h2v5h3v2z"/>
                </svg>
                <span>You Get</span>
              </div>
              <span class="font-bold text-gray-800"><?= number_format($coin_amount, 6) ?> <?= htmlspecialchars($networkName) ?></span>
            </div>
            <!-- Pay With Row -->
            <div class="flex justify-between items-center">
              <div class="flex items-center text-gray-800 font-bold space-x-2">
                <svg class="w-5 h-5 text-gray-800" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M19 7H5C3.346 7 2 8.346 2 10v4c0 1.654 1.346 3 3 3h14c1.654 0 3-1.346 3-3v-4c0-1.654-1.346-3-3-3zm1 7c0 .551-.449 1-1 1H5c-.551 0-1-.449-1-1v-2h16v2zM7 13h2v1H7z" />
                </svg>
                <span><?= htmlspecialchars($networkFullName) ?></span>
              </div>
              <!-- Updated Wallet Address -->
              <span class="font-semibold text-blue-600 break-all"><?= htmlspecialchars($transaction_data['wallet']) ?></span>
            </div>
          </div>
          <!-- Instruction Label for swipe action -->
          <div id="swipeLabel" class="text-center">
            <p class="text-lg font-bold text-gray-800">Swipe to confirm</p>
            <p class="text-xs text-gray-600">By confirming, you agree to the  terms.</p>
          </div>
        </div>
        <!-- Horizontal Swipe Track and Button -->
        <div id="swipeTrack" class="swipe-track">
          <div id="swipeButton" class="swipe-button">
            <!-- Hidden Submit Button inside the Swipe Button -->
            <button type="submit" style="all: unset; display: flex; justify-content: center; align-items: center;">
              <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                <path d="M20 12l-7-7v4H4v6h9v4l7-7z" />
              </svg>
            </button>
          </div>
        </div>
      </form>
      <!-- Form End -->
    </div>
  </div>

  <script>
    // Dummy functions for header buttons
    function goBack() {
      window.history.back();
    }
    function openNotifications() {
      alert("Notifications not implemented.");
    }
    
    // Retrieve DOM elements
    const swipeButton = document.getElementById('swipeButton');
    const swipeTrack  = document.getElementById('swipeTrack');
    const confirmationForm = document.getElementById('confirmationForm');

    // Variables to track dragging state
    let isDragging = false;
    let startX = 0;
    let initialLeft = 0;

    function getMinLeft() {
      return 2;
    }
    function getMaxLeft() {
      return swipeTrack.clientWidth - swipeButton.clientWidth - 2;
    }

    swipeButton.addEventListener('touchstart', function(e) {
      isDragging = true;
      startX = e.touches[0].clientX;
      initialLeft = parseInt(window.getComputedStyle(swipeButton).left);
      swipeButton.style.transition = 'none';
    });
    swipeButton.addEventListener('touchmove', function(e) {
      if (!isDragging) return;
      const touchX = e.touches[0].clientX;
      const deltaX = touchX - startX;
      let newLeft = initialLeft + deltaX;
      const minLeft = getMinLeft();
      const maxLeft = getMaxLeft();
      if (newLeft < minLeft) newLeft = minLeft;
      if (newLeft > maxLeft) newLeft = maxLeft;
      swipeButton.style.left = newLeft + 'px';
      e.preventDefault();
    }, { passive: false });
    swipeButton.addEventListener('touchend', function() {
      finishDrag();
      isDragging = false;
    });
    swipeButton.addEventListener('mousedown', function(e) {
      isDragging = true;
      startX = e.clientX;
      initialLeft = parseInt(window.getComputedStyle(swipeButton).left);
      swipeButton.style.transition = 'none';
      e.preventDefault();
    });
    document.addEventListener('mousemove', function(e) {
      if (!isDragging) return;
      const deltaX = e.clientX - startX;
      let newLeft = initialLeft + deltaX;
      const minLeft = getMinLeft();
      const maxLeft = getMaxLeft();
      if (newLeft < minLeft) newLeft = minLeft;
      if (newLeft > maxLeft) newLeft = maxLeft;
      swipeButton.style.left = newLeft + 'px';
      e.preventDefault();
    });
    document.addEventListener('mouseup', function() {
      finishDrag();
      isDragging = false;
    });
    function finishDrag() {
      const maxLeft = getMaxLeft();
      const minLeft = getMinLeft();
      const currentLeft = parseInt(window.getComputedStyle(swipeButton).left);
      if (currentLeft >= maxLeft) {
        confirmationForm.submit();
        swipeButton.classList.add('fade-out');
        setTimeout(() => {
          swipeButton.classList.remove('fade-out');
          swipeButton.style.transition = 'left 0.3s ease';
          swipeButton.style.left = minLeft + 'px';
        }, 300);
      } else {
        swipeButton.style.transition = 'left 0.3s ease';
        swipeButton.style.left = minLeft + 'px';
      }
    }
  </script>
</body>
</html>
