<?php
// Enable error reporting for debugging (keep commented out in production)
// Disable all error reporting
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(0);


/**
 * Existing function remains unchanged.
 */
function getCountryCode($countryName) {
    // Your existing logic here...
    return ''; // placeholder
}

// Full list of countries for the country map
$allCountries = [
  ["name" => "Afghanistan", "code" => "af", "dial_code" => "+93"],
    ["name" => "Albania", "code" => "al", "dial_code" => "+355"],
    ["name" => "Algeria", "code" => "dz", "dial_code" => "+213"],
    ["name" => "Andorra", "code" => "ad", "dial_code" => "+376"],
    ["name" => "Angola", "code" => "ao", "dial_code" => "+244"],
    ["name" => "Antigua and Barbuda", "code" => "ag", "dial_code" => "+1-268"],
    ["name" => "Argentina", "code" => "ar", "dial_code" => "+54"],
    ["name" => "Armenia", "code" => "am", "dial_code" => "+374"],
    ["name" => "Australia", "code" => "au", "dial_code" => "+61"],
    ["name" => "Austria", "code" => "at", "dial_code" => "+43"],
    ["name" => "Azerbaijan", "code" => "az", "dial_code" => "+994"],
    ["name" => "Bahamas", "code" => "bs", "dial_code" => "+1-242"],
    ["name" => "Bahrain", "code" => "bh", "dial_code" => "+973"],
    ["name" => "Bangladesh", "code" => "bd", "dial_code" => "+880"],
    ["name" => "Barbados", "code" => "bb", "dial_code" => "+1-246"],
    ["name" => "Belarus", "code" => "by", "dial_code" => "+375"],
    ["name" => "Belgium", "code" => "be", "dial_code" => "+32"],
    ["name" => "Belize", "code" => "bz", "dial_code" => "+501"],
    ["name" => "Benin", "code" => "bj", "dial_code" => "+229"],
    ["name" => "Bhutan", "code" => "bt", "dial_code" => "+975"],
    ["name" => "Bolivia", "code" => "bo", "dial_code" => "+591"],
    ["name" => "Bosnia and Herzegovina", "code" => "ba", "dial_code" => "+387"],
    ["name" => "Botswana", "code" => "bw", "dial_code" => "+267"],
    ["name" => "Brazil", "code" => "br", "dial_code" => "+55"],
    ["name" => "Brunei", "code" => "bn", "dial_code" => "+673"],
    ["name" => "Bulgaria", "code" => "bg", "dial_code" => "+359"],
    ["name" => "Burkina Faso", "code" => "bf", "dial_code" => "+226"],
    ["name" => "Burundi", "code" => "bi", "dial_code" => "+257"],
    ["name" => "Cabo Verde", "code" => "cv", "dial_code" => "+238"],
    ["name" => "Cambodia", "code" => "kh", "dial_code" => "+855"],
    ["name" => "Cameroon", "code" => "cm", "dial_code" => "+237"],
    ["name" => "Canada", "code" => "ca", "dial_code" => "+1"],
    ["name" => "Central African Republic", "code" => "cf", "dial_code" => "+236"],
    ["name" => "Chad", "code" => "td", "dial_code" => "+235"],
    ["name" => "Chile", "code" => "cl", "dial_code" => "+56"],
    ["name" => "China", "code" => "cn", "dial_code" => "+86"],
    ["name" => "Colombia", "code" => "co", "dial_code" => "+57"],
    ["name" => "Comoros", "code" => "km", "dial_code" => "+269"],
    ["name" => "Congo (Congo-Brazzaville)", "code" => "cg", "dial_code" => "+242"],
    ["name" => "Costa Rica", "code" => "cr", "dial_code" => "+506"],
    ["name" => "Croatia", "code" => "hr", "dial_code" => "+385"],
    ["name" => "Cuba", "code" => "cu", "dial_code" => "+53"],
    ["name" => "Cyprus", "code" => "cy", "dial_code" => "+357"],
    ["name" => "Czechia (Czech Republic)", "code" => "cz", "dial_code" => "+420"],
    ["name" => "Democratic Republic of the Congo", "code" => "cd", "dial_code" => "+243"],
    ["name" => "Denmark", "code" => "dk", "dial_code" => "+45"],
    ["name" => "Djibouti", "code" => "dj", "dial_code" => "+253"],
    ["name" => "Dominica", "code" => "dm", "dial_code" => "+1-767"],
    ["name" => "Dominican Republic", "code" => "do", "dial_code" => "+1-809"],
    ["name" => "Ecuador", "code" => "ec", "dial_code" => "+593"],
    ["name" => "Egypt", "code" => "eg", "dial_code" => "+20"],
    ["name" => "El Salvador", "code" => "sv", "dial_code" => "+503"],
    ["name" => "Equatorial Guinea", "code" => "gq", "dial_code" => "+240"],
    ["name" => "Eritrea", "code" => "er", "dial_code" => "+291"],
    ["name" => "Estonia", "code" => "ee", "dial_code" => "+372"],
    ["name" => "Eswatini", "code" => "sz", "dial_code" => "+268"],
    ["name" => "Ethiopia", "code" => "et", "dial_code" => "+251"],
    ["name" => "Fiji", "code" => "fj", "dial_code" => "+679"],
    ["name" => "Finland", "code" => "fi", "dial_code" => "+358"],
    ["name" => "France", "code" => "fr", "dial_code" => "+33"],
    ["name" => "Gabon", "code" => "ga", "dial_code" => "+241"],
    ["name" => "Gambia", "code" => "gm", "dial_code" => "+220"],
    ["name" => "Georgia", "code" => "ge", "dial_code" => "+995"],
    ["name" => "Germany", "code" => "de", "dial_code" => "+49"],
    ["name" => "Ghana", "code" => "gh", "dial_code" => "+233"],
    ["name" => "Greece", "code" => "gr", "dial_code" => "+30"],
    ["name" => "Grenada", "code" => "gd", "dial_code" => "+1-473"],
    ["name" => "Guatemala", "code" => "gt", "dial_code" => "+502"],
    ["name" => "Guinea", "code" => "gn", "dial_code" => "+224"],
    ["name" => "Guinea-Bissau", "code" => "gw", "dial_code" => "+245"],
    ["name" => "Guyana", "code" => "gy", "dial_code" => "+592"],
    ["name" => "Haiti", "code" => "ht", "dial_code" => "+509"],
    ["name" => "Holy See", "code" => "va", "dial_code" => "+379"],
    ["name" => "Honduras", "code" => "hn", "dial_code" => "+504"],
    ["name" => "Hungary", "code" => "hu", "dial_code" => "+36"],
    ["name" => "Iceland", "code" => "is", "dial_code" => "+354"],
    ["name" => "India", "code" => "in", "dial_code" => "+91"],
    ["name" => "Indonesia", "code" => "id", "dial_code" => "+62"],
    ["name" => "Iran", "code" => "ir", "dial_code" => "+98"],
    ["name" => "Iraq", "code" => "iq", "dial_code" => "+964"],
    ["name" => "Ireland", "code" => "ie", "dial_code" => "+353"],
    ["name" => "Israel", "code" => "il", "dial_code" => "+972"],
    ["name" => "Italy", "code" => "it", "dial_code" => "+39"],
    ["name" => "Jamaica", "code" => "jm", "dial_code" => "+1-876"],
    ["name" => "Japan", "code" => "jp", "dial_code" => "+81"],
    ["name" => "Jordan", "code" => "jo", "dial_code" => "+962"],
    ["name" => "Kazakhstan", "code" => "kz", "dial_code" => "+7"],
    ["name" => "Kenya", "code" => "ke", "dial_code" => "+254"],
    ["name" => "Kiribati", "code" => "ki", "dial_code" => "+686"],
    ["name" => "Kuwait", "code" => "kw", "dial_code" => "+965"],
    ["name" => "Kyrgyzstan", "code" => "kg", "dial_code" => "+996"],
    ["name" => "Laos", "code" => "la", "dial_code" => "+856"],
    ["name" => "Latvia", "code" => "lv", "dial_code" => "+371"],
    ["name" => "Lebanon", "code" => "lb", "dial_code" => "+961"],
    ["name" => "Lesotho", "code" => "ls", "dial_code" => "+266"],
    ["name" => "Liberia", "code" => "lr", "dial_code" => "+231"],
    ["name" => "Libya", "code" => "ly", "dial_code" => "+218"],
    ["name" => "Liechtenstein", "code" => "li", "dial_code" => "+423"],
    ["name" => "Lithuania", "code" => "lt", "dial_code" => "+370"],
    ["name" => "Luxembourg", "code" => "lu", "dial_code" => "+352"],
    ["name" => "Madagascar", "code" => "mg", "dial_code" => "+261"],
    ["name" => "Malawi", "code" => "mw", "dial_code" => "+265"],
    ["name" => "Malaysia", "code" => "my", "dial_code" => "+60"],
    ["name" => "Maldives", "code" => "mv", "dial_code" => "+960"],
    ["name" => "Mali", "code" => "ml", "dial_code" => "+223"],
    ["name" => "Malta", "code" => "mt", "dial_code" => "+356"],
    ["name" => "Marshall Islands", "code" => "mh", "dial_code" => "+692"],
    ["name" => "Mauritania", "code" => "mr", "dial_code" => "+222"],
    ["name" => "Mauritius", "code" => "mu", "dial_code" => "+230"],
    ["name" => "Mexico", "code" => "mx", "dial_code" => "+52"],
    ["name" => "Micronesia", "code" => "fm", "dial_code" => "+691"],
    ["name" => "Moldova", "code" => "md", "dial_code" => "+373"],
    ["name" => "Monaco", "code" => "mc", "dial_code" => "+377"],
    ["name" => "Mongolia", "code" => "mn", "dial_code" => "+976"],
    ["name" => "Montenegro", "code" => "me", "dial_code" => "+382"],
    ["name" => "Morocco", "code" => "ma", "dial_code" => "+212"],
    ["name" => "Mozambique", "code" => "mz", "dial_code" => "+258"],
    ["name" => "Myanmar", "code" => "mm", "dial_code" => "+95"],
    ["name" => "Namibia", "code" => "na", "dial_code" => "+264"],
    ["name" => "Nauru", "code" => "nr", "dial_code" => "+674"],
    ["name" => "Nepal", "code" => "np", "dial_code" => "+977"],
    ["name" => "Netherlands", "code" => "nl", "dial_code" => "+31"],
    ["name" => "New Zealand", "code" => "nz", "dial_code" => "+64"],
    ["name" => "Nicaragua", "code" => "ni", "dial_code" => "+505"],
    ["name" => "Niger", "code" => "ne", "dial_code" => "+227"],
    ["name" => "Nigeria", "code" => "ng", "dial_code" => "+234"],
    ["name" => "North Korea", "code" => "kp", "dial_code" => "+850"],
    ["name" => "North Macedonia", "code" => "mk", "dial_code" => "+389"],
    ["name" => "Norway", "code" => "no", "dial_code" => "+47"],
    ["name" => "Oman", "code" => "om", "dial_code" => "+968"],
    ["name" => "Pakistan", "code" => "pk", "dial_code" => "+92"],
    ["name" => "Palau", "code" => "pw", "dial_code" => "+680"],
    ["name" => "Palestine", "code" => "ps", "dial_code" => "+970"],
    ["name" => "Panama", "code" => "pa", "dial_code" => "+507"],
    ["name" => "Papua New Guinea", "code" => "pg", "dial_code" => "+675"],
    ["name" => "Paraguay", "code" => "py", "dial_code" => "+595"],
    ["name" => "Peru", "code" => "pe", "dial_code" => "+51"],
    ["name" => "Philippines", "code" => "ph", "dial_code" => "+63"],
    ["name" => "Poland", "code" => "pl", "dial_code" => "+48"],
    ["name" => "Portugal", "code" => "pt", "dial_code" => "+351"],
    ["name" => "Qatar", "code" => "qa", "dial_code" => "+974"],
    ["name" => "Romania", "code" => "ro", "dial_code" => "+40"],
    ["name" => "Russia", "code" => "ru", "dial_code" => "+7"],
    ["name" => "Rwanda", "code" => "rw", "dial_code" => "+250"],
    ["name" => "Saint Kitts and Nevis", "code" => "kn", "dial_code" => "+1-869"],
    ["name" => "Saint Lucia", "code" => "lc", "dial_code" => "+1-758"],
    ["name" => "Saint Vincent and the Grenadines", "code" => "vc", "dial_code" => "+1-784"],
    ["name" => "Samoa", "code" => "ws", "dial_code" => "+685"],
    ["name" => "San Marino", "code" => "sm", "dial_code" => "+378"],
    ["name" => "Sao Tome and Principe", "code" => "st", "dial_code" => "+239"],
    ["name" => "Saudi Arabia", "code" => "sa", "dial_code" => "+966"],
    ["name" => "Senegal", "code" => "sn", "dial_code" => "+221"],
    ["name" => "Serbia", "code" => "rs", "dial_code" => "+381"],
    ["name" => "Seychelles", "code" => "sc", "dial_code" => "+248"],
    ["name" => "Sierra Leone", "code" => "sl", "dial_code" => "+232"],
    ["name" => "Singapore", "code" => "sg", "dial_code" => "+65"],
    ["name" => "Slovakia", "code" => "sk", "dial_code" => "+421"],
    ["name" => "Slovenia", "code" => "si", "dial_code" => "+386"],
    ["name" => "Solomon Islands", "code" => "sb", "dial_code" => "+677"],
    ["name" => "Somalia", "code" => "so", "dial_code" => "+252"],
    ["name" => "South Africa", "code" => "za", "dial_code" => "+27"],
    ["name" => "South Korea", "code" => "kr", "dial_code" => "+82"],
    ["name" => "South Sudan", "code" => "ss", "dial_code" => "+211"],
    ["name" => "Spain", "code" => "es", "dial_code" => "+34"],
    ["name" => "Sri Lanka", "code" => "lk", "dial_code" => "+94"],
    ["name" => "Sudan", "code" => "sd", "dial_code" => "+249"],
    ["name" => "Suriname", "code" => "sr", "dial_code" => "+597"],
    ["name" => "Sweden", "code" => "se", "dial_code" => "+46"],
    ["name" => "Switzerland", "code" => "ch", "dial_code" => "+41"],
    ["name" => "Syria", "code" => "sy", "dial_code" => "+963"],
    ["name" => "Taiwan", "code" => "tw", "dial_code" => "+886"],
    ["name" => "Tajikistan", "code" => "tj", "dial_code" => "+992"],
    ["name" => "Tanzania", "code" => "tz", "dial_code" => "+255"],
    ["name" => "Thailand", "code" => "th", "dial_code" => "+66"],
    ["name" => "Timor-Leste", "code" => "tl", "dial_code" => "+670"],
    ["name" => "Togo", "code" => "tg", "dial_code" => "+228"],
    ["name" => "Tonga", "code" => "to", "dial_code" => "+676"],
    ["name" => "Trinidad and Tobago", "code" => "tt", "dial_code" => "+1-868"],
    ["name" => "Tunisia", "code" => "tn", "dial_code" => "+216"],
    ["name" => "Turkey", "code" => "tr", "dial_code" => "+90"],
    ["name" => "Turkmenistan", "code" => "tm", "dial_code" => "+993"],
    ["name" => "Tuvalu", "code" => "tv", "dial_code" => "+688"],
    ["name" => "Uganda", "code" => "ug", "dial_code" => "+256"],
    ["name" => "Ukraine", "code" => "ua", "dial_code" => "+380"],
    ["name" => "United Arab Emirates", "code" => "ae", "dial_code" => "+971"],
    ["name" => "United Kingdom", "code" => "gb", "dial_code" => "+44"],
    ["name" => "United States of America", "code" => "us", "dial_code" => "+1"],
    ["name" => "Uruguay", "code" => "uy", "dial_code" => "+598"],
    ["name" => "Uzbekistan", "code" => "uz", "dial_code" => "+998"],
    ["name" => "Vanuatu", "code" => "vu", "dial_code" => "+678"],
    ["name" => "Venezuela", "code" => "ve", "dial_code" => "+58"],
    ["name" => "Vietnam", "code" => "vn", "dial_code" => "+84"],
    ["name" => "Yemen", "code" => "ye", "dial_code" => "+967"],
    ["name" => "Zambia", "code" => "zm", "dial_code" => "+260"],
    ["name" => "Zimbabwe", "code" => "zw", "dial_code" => "+263"]
];

require 'db.php';
include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in, if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('Pending or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$balance        = $userDetails['balance'];
$btc            = $userDetails['btc'];
$eth            = $userDetails['eth'];
$usdt           = $userDetails['usdt'];
$xrp            = $userDetails['xrp'];
$doge           = $userDetails['doge'];
$ada            = $userDetails['ada'];
$pepe           = $userDetails['pepe'];
$sol            = $userDetails['sol'];
$bnb            = $userDetails['bnb'];
$message        = $userDetails['message'];
$extra          = $userDetails['extra'];
$msgstatus      = $userDetails['msgstatus'];
$bonus          = $userDetails['bonus'];
$profit         = $userDetails['profit'];
$update_time    = $userDetails['update_time'];

// Check if country or phone is empty/null
$showProfileAlert = empty($country) || $country === null || empty($phone) || $phone === null;

// Fetch country statistics from the database
try {
    $query = "SELECT country, COUNT(*) AS customers
              FROM users 
              GROUP BY country
              ORDER BY customers DESC";
              
    $result = mysqli_query($conn, $query);
    
    if (!$result) {
        throw new Exception("Query failed: " . mysqli_error($conn));
    }
    
    $dbCountries = [];
    $total_customers = 0;
    
    // Build associative array of country counts using country name as key
    while ($row = mysqli_fetch_assoc($result)) {
        $dbCountries[$row['country']] = $row['customers'];
        $total_customers += $row['customers'];
    }
    
    // Merge full list of countries with DB data
    $countriesMap = [];
    foreach ($allCountries as $item) {
        $custCount = isset($dbCountries[$item['name']]) ? $dbCountries[$item['name']] : 0;
        $percentage = ($total_customers > 0) ? round(($custCount / $total_customers) * 100, 2) : 0;
        $item['customers'] = $custCount;
        $item['percentage'] = $percentage;
        $countriesMap[] = $item;
    }
    
    // Prepare JSON for client-side use if needed
    $jsonCountries = json_encode($countriesMap);
    
} catch (Exception $e) {
    die("Database error: " . $e->getMessage());
}

// Process form submission for profile update inline
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update_profile'])) {
    $newDialCode = $_POST['country'];
    $newPhone = $_POST['full_phone']; // Full phone with dial code
    
    // Validate inputs
    if (empty($newDialCode) || empty($newPhone)) {
        $updateError = "Both country and phone number are required.";
    } else {
        // Map the dial code to the country name using the full countries list
        $newCountry = $newDialCode; // default fallback
        foreach ($allCountries as $c) {
            if ($c['dial_code'] === $newDialCode) {
                $newCountry = $c['name'];
                break;
            }
        }
        
        // Update user profile in the database using mysqli
        $updateQuery = "UPDATE users 
                        SET country = ?, phone = ? 
                        WHERE google_id = ?";
        $stmt = mysqli_prepare($conn, $updateQuery);
        
        if ($stmt) {
            mysqli_stmt_bind_param($stmt, "sss", $newCountry, $newPhone, $google_id);
            
            if (mysqli_stmt_execute($stmt)) {
                // Instead of redirecting, update inline variables and set a success message
                $updateMessage = "Profile updated successfully.";
                $country = $newCountry;
                $phone = $newPhone;
            } else {
                $updateError = "Failed to update profile: " . mysqli_stmt_error($stmt);
            }
            
            mysqli_stmt_close($stmt);
        } else {
            $updateError = "Failed to prepare statement: " . mysqli_error($conn);
        }
    }
}
?>





<?php include './includes/header.php'; ?>



<body onload="initialize()">
    
     <?php include './includes/nav.php'; ?>

 <?php include './includes/dashnav.php'; ?>


    
    
    
<div style=" padding: 4px; margin-top: 65px;">




<?php
if (isset($_SESSION['success_alert'])) {
    echo '<div id="sessionAlert" class="bg-green-100 text-green-800 border border-green-400 p-4 rounded shadow text-center">';
    echo $_SESSION['success_alert'];
    echo '</div>';
    unset($_SESSION['success_alert']);
}
?>
<script>
    // After 3 seconds, fade out the alert smoothly over 1 second
    setTimeout(function(){
        var alertEl = document.getElementById("sessionAlert");
        if(alertEl){
            alertEl.classList.add("transition-opacity", "duration-1000", "opacity-0");
            // Remove the element from the DOM after the fade-out transition completes
            setTimeout(function(){
                alertEl.remove();
            }, 1000);
        }
    }, 3000);
</script>



 
 
 <?php
// Retrieve the user email from session
$user_email = getSessionEmail();
if (!$user_email) {
    echo '<div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded relative" role="alert">
            <strong class="font-bold">Not Logged In</strong>
            <span class="block sm:inline"> Please log in to access your dashboard.</span>
          </div>';
    exit;
}

// Fetch user details (msgstatus, extra)
$query = "SELECT msgstatus, message FROM users WHERE email = :email";
$stmt = $conn->prepare($query);
$stmt->bindParam(':email', $user_email, PDO::PARAM_STR);
$stmt->execute();
$user = $stmt->fetch(PDO::FETCH_ASSOC);
$show_modal = false;
$popup_message = '';

if ($user) {
    $msgstatus = strtolower(trim($user['msgstatus'] ?? ''));
    $message = trim($user['message'] ?? '');
    
    // Show popup only if msgstatus is "yes"
    if ($msgstatus === 'yes') {
        $show_modal = true;
        $popup_message = $message; // Fetching 'message' value from the database
    }
}

// Display appropriate SweetAlert based on verification status
if (isset($_SESSION['kyc_status'])) {
    $status = $_SESSION['kyc_status'];
    
    // Clear the session variable after using it
    unset($_SESSION['kyc_status']);
}
?>



<!-- JavaScript to show SweetAlert -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    var showModal = <?php echo json_encode($show_modal); ?>;
    var popupMessage = <?php echo json_encode($popup_message); ?>;
    
    if (showModal) {
        Swal.fire({
            title: 'NOTICE!',
            html: popupMessage,
            icon: 'warning',
            confirmButtonText: 'OK',
            background: '#343a40',
            backdrop: 'rgba(0, 0, 0, 0.7)',
            customClass: {
                title: 'swal-dark-title',
                htmlContainer: 'swal-dark-content',
                confirmButton: 'swal-dark-button',
                popup: 'swal-dark-popup'
            }
        });
    }
});
</script>

<!-- Custom styles for dark SweetAlert -->



<?php


// Check if KYC submission was successful
if (isset($_SESSION['kyc_success']) && $_SESSION['kyc_success']) {
    $transhash = $_SESSION['transhash'];
    // Clear the session variable
    unset($_SESSION['kyc_success']);
    unset($_SESSION['transhash']);
}
?>



    <?php if (isset($transhash)): ?>
    <script>
        // Show SweetAlert notification
        Swal.fire({
            icon: 'success',
            title: 'KYC Submitted Successfully!',
            text: 'Your transaction hash is: <?php echo $transhash; ?>',
            confirmButtonText: 'OK'
        });
    </script>
    <?php endif; ?>





<!DOCTYPE html>
<html lang="en" x-data="tradeSet()">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Primemarketspro - Digital Payments Made Easy</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#3B82F6',
                        accent: '#8B5CF6',
                    },
                    animation: {
                        'fade-in': 'fadeIn 0.6s ease-out',
                        'slide-up': 'slideUp 0.8s ease-out',
                        'bounce-slow': 'bounce 2s infinite',
                        'pulse': 'pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite',
                    },
                    keyframes: {
                        fadeIn: {
                            '0%': { opacity: '0', transform: 'translateY(10px)' },
                            '100%': { opacity: '1', transform: 'translateY(0)' }
                        },
                        slideUp: {
                            '0%': { opacity: '0', transform: 'translateY(30px)' },
                            '100%': { opacity: '1', transform: 'translateY(0)' }
                        }
                    }
                }
            }
        }
    </script>
</head>

<body class="bg-gray-50">
    <div class="w-full max-w-6xl mx-auto">
        <!-- Desktop/Tablet Grid Layout -->
        <div class="md:grid md:grid-cols-12 md:gap-8 md:p-8 md:min-h-screen">
            
            <!-- Left Sidebar - Desktop Only -->
            <div class="hidden lg:block lg:col-span-3 space-y-6">
              
                <!-- Brand -->
                <div class="bg-white rounded-3xl p-6 shadow-xl">
                    <h1 class="text-2xl font-bold bg-gradient-to-r from-primary to-accent bg-clip-text text-transparent">Primemarketspro</h1>
                    <p class="text-gray-500 mt-2">Digital Payments Made Easy</p>
                </div>
                
                    <script>
                        tailwind.config = {
                            theme: {
                                extend: {
                                    colors: {
                                        primary: '#3B82F6'
                                    }
                                }
                            }
                        }
                    </script>
                    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
               
                    <nav class="bg-white rounded-3xl p-6 shadow-xl max-w-md mx-auto">
                        <div class="space-y-3" id="navContainer">
                            <div class="text-center text-gray-500 py-8">
                                <i class="fas fa-spinner fa-spin text-2xl mb-2"></i>
                                <p>Loading market data...</p>
                            </div>
                        </div>
                    </nav>
                
                    <script>
                        let activeNav = '';
                        let marketData = [];
                
                        // Market items configuration - 8 assets total
                        const marketItems = [
                            // Crypto (3 assets)
                            {
                                id: 'bitcoin',
                                name: 'crypto',
                                label: 'Bitcoin',
                                icon: 'fab fa-bitcoin',
                                color: '#F7931A'
                            },
                            {
                                id: 'ethereum',
                                name: 'crypto',
                                label: 'Ethereum',
                                icon: 'fab fa-ethereum',
                                color: '#627EEA'
                            },
                            {
                                id: 'binancecoin',
                                name: 'crypto',
                                label: 'BNB',
                                icon: 'fas fa-coins',
                                color: '#F3BA2F'
                            },
                            // Forex (3 assets - using major stablecoins as forex proxies)
                            {
                                id: 'tether',
                                name: 'forex',
                                label: 'USD/T',
                                icon: 'fas fa-dollar-sign',
                                color: '#26A17B'
                            },
                            {
                                id: 'usd-coin',
                                name: 'forex',
                                label: 'USD/C',
                                icon: 'fas fa-euro-sign',
                                color: '#2775CA'
                            },
                            {
                                id: 'dai',
                                name: 'forex',
                                label: 'DAI',
                                icon: 'fas fa-yen-sign',
                                color: '#F5AC37'
                            },
                            // Stock (2 assets - using stock-like crypto tokens)
                            {
                                id: 'chainlink',
                                name: 'stock',
                                label: 'LINK',
                                icon: 'fas fa-chart-line',
                                color: '#375BD2'
                            },
                            {
                                id: 'solana',
                                name: 'stock',
                                label: 'SOL',
                                icon: 'fas fa-building',
                                color: '#9945FF'
                            }
                        ];
                
                        async function fetchMarketData() {
                            try {
                                const coinIds = marketItems.map(item => item.id).join(',');
                                const response = await fetch(`https://api.coingecko.com/api/v3/simple/price?ids=${coinIds}&vs_currencies=usd&include_24hr_change=true`);
                                
                                if (!response.ok) {
                                    throw new Error('Failed to fetch data');
                                }
                                
                                const data = await response.json();
                                
                                marketData = marketItems.map(item => ({
                                    ...item,
                                    price: data[item.id]?.usd || 0,
                                    change: data[item.id]?.usd_24h_change || 0
                                }));
                                
                                renderNavigation();
                                
                            } catch (error) {
                                console.error('Error fetching market data:', error);
                                document.getElementById('navContainer').innerHTML = `
                                    <div class="text-center text-red-500 py-8">
                                        <i class="fas fa-exclamation-triangle text-2xl mb-2"></i>
                                        <p>Failed to load market data</p>
                                        <button onclick="fetchMarketData()" class="mt-2 px-4 py-2 bg-blue-500 text-white rounded-lg hover:bg-blue-600 transition-colors">
                                            Retry
                                        </button>
                                    </div>
                                `;
                            }
                        }
                
                        function renderNavigation() {
                            const container = document.getElementById('navContainer');
                            
                            container.innerHTML = `
                                <div class="mb-4 text-center">
                                    <h2 class="text-lg font-bold text-gray-800 mb-2">Live Market Data</h2>
                                    <div class="text-xs text-gray-500">
                                        Last updated: ${new Date().toLocaleTimeString()}
                                    </div>
                                </div>
                                ${marketData.map(item => {
                                    const isActive = activeNav === item.name;
                                    const priceColor = item.change >= 0 ? 'text-green-500' : 'text-red-500';
                                    const changeSymbol = item.change >= 0 ? '+' : '';
                                    
                                    return `
                                        <button onclick="setActiveNav('${item.name}')"
                                            class="w-full flex items-center justify-between px-4 py-3 rounded-xl transition-all duration-200 font-medium ${
                                                isActive 
                                                    ? 'bg-primary text-white shadow-lg transform scale-105' 
                                                    : 'text-gray-600 hover:bg-gray-50 hover:shadow-md border border-gray-100'
                                            }">
                                            <div class="flex items-center space-x-3">
                                                <div class="w-8 h-8 rounded-full flex items-center justify-center ${
                                                    isActive ? 'bg-white bg-opacity-20' : 'bg-gray-100'
                                                }">
                                                    <i class="${item.icon} text-sm" style="color: ${isActive ? 'white' : item.color}"></i>
                                                </div>
                                                <div class="text-left">
                                                    <div class="font-semibold">${item.label}</div>
                                                    <div class="text-xs opacity-75 capitalize">${item.name}</div>
                                                </div>
                                            </div>
                                            <div class="text-right">
                                                <div class="font-bold ${isActive ? 'text-white' : 'text-gray-900'}">
                                                    ${item.price.toLocaleString(undefined, {
                                                        minimumFractionDigits: 2,
                                                        maximumFractionDigits: item.price < 1 ? 6 : 2
                                                    })}
                                                </div>
                                                <div class="text-xs ${isActive ? 'text-gray-200' : priceColor} font-medium">
                                                    ${changeSymbol}${item.change.toFixed(2)}%
                                                </div>
                                            </div>
                                        </button>
                                    `;
                                }).join('')}
                            `;
                        }
                
                        function setActiveNav(navName) {
                            activeNav = activeNav === navName ? '' : navName;
                            renderNavigation();
                        }
                
                        // Auto-refresh data every 30 seconds
                        function startAutoRefresh() {
                            setInterval(fetchMarketData, 30000);
                        }
                
                        // Initialize
                        fetchMarketData().then(() => {
                            startAutoRefresh();
                        });
                    </script>
               
               
                  <!-- Quick Send Contacts -->
               
            </div>

            <!-- Main Content Area -->
<div class="md:col-span-9 lg:col-span-6 p-4 md:p-0 space-y-6 md:space-y-8 pb-24 md:pb-8">

                <!-- Header -->
                <header class="flex justify-between items-center animate-fade-in">
                    <div class="flex items-center space-x-3 md:space-x-4">
                        <div class="relative">
                            <img src="https://images.unsplash.com/photo-1494790108755-2616b612b5bc?w=80&h=80&fit=crop&crop=face" 
                                alt="User avatar" 
                                class="rounded-full w-12 h-12 md:w-16 md:h-16 border-2 border-white shadow-lg">
                            <div class="absolute -bottom-1 -right-1 w-4 h-4 md:w-5 md:h-5 bg-green-500 rounded-full border-2 border-white"></div>
                        </div>
                        <div>
                            <p class="font-bold text-xl md:text-2xl bg-gradient-to-r from-primary to-accent bg-clip-text text-transparent">Hi, Cherry</p>
                            <p class="text-sm md:text-base text-gray-500">Welcome back! Let's make payments</p>
                        </div>
                    </div>
                    <div class="relative">
                        <button @click="showNotifications = !showNotifications" 
                            class="relative p-3 md:p-4 rounded-full bg-white shadow-lg hover:shadow-xl transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-primary" 
                            aria-label="Notifications">
                            <i class="fas fa-bell w-6 h-6 md:w-7 md:h-7 text-primary animate-bounce-slow"></i>
                            <span class="absolute -top-1 -right-1 w-5 h-5 md:w-6 md:h-6 bg-red-500 text-white text-xs md:text-sm rounded-full flex items-center justify-center font-bold">3</span>
                        </button>
                        
                        <!-- Notifications Dropdown -->
                        <div x-show="showNotifications" 
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 scale-95"
                            x-transition:enter-end="opacity-100 scale-100"
                            x-transition:leave="transition ease-in duration-150"
                            x-transition:leave-start="opacity-100 scale-100"
                            x-transition:leave-end="opacity-0 scale-95"
                            @click.away="showNotifications = false"
                            class="absolute right-0 mt-2 w-80 bg-white rounded-2xl shadow-2xl border border-gray-200 z-50">
                            <div class="p-4">
                                <h3 class="font-bold text-lg mb-3">Notifications</h3>
                                <div class="space-y-3">
                                    <template x-for="notification in notifications" :key="notification.id">
                                        <div class="flex items-start space-x-3 p-3 rounded-lg hover:bg-gray-50 transition-colors">
                                            <div :class="notification.color" class="w-2 h-2 rounded-full mt-2"></div>
                                            <div class="flex-1">
                                                <p class="font-medium text-sm" x-text="notification.title"></p>
                                                <p class="text-xs text-gray-500" x-text="notification.message"></p>
                                                <p class="text-xs text-gray-400 mt-1" x-text="notification.time"></p>
                                            </div>
                                        </div>
                                    </template>
                                </div>
                            </div>
                        </div>
                    </div>
                </header>

                <!-- Balance Card -->
                <div class="relative gradient-bg rounded-3xl p-6 md:p-8 overflow-hidden shadow-2xl animate-slide-up">
                    <!-- Background Pattern -->
                    <div class="absolute inset-0 opacity-10">
                        <svg class="w-full h-full" viewBox="0 0 100 100">
                            <circle cx="20" cy="20" r="2" fill="white" class="animate-pulse"></circle>
                            <circle cx="80" cy="30" r="1.5" fill="white" class="animate-pulse" style="animation-delay: 0.5s"></circle>
                            <circle cx="60" cy="70" r="1" fill="white" class="animate-pulse" style="animation-delay: 1s"></circle>
                            <circle cx="30" cy="80" r="2.5" fill="white" class="animate-pulse" style="animation-delay: 1.5s"></circle>
                        </svg>
                    </div>
                    
                    <!-- Skeleton Loader -->
                    <div x-show="loading" class="animate-pulse">
                        <div class="h-4 md:h-5 bg-white/20 rounded w-32 md:w-40 mb-3"></div>
                        <div class="h-8 md:h-10 bg-white/20 rounded w-24 md:w-32 mb-4"></div>
                        <div class="h-10 md:h-12 bg-white/20 rounded w-28 md:w-36 ml-auto"></div>
                    </div>
                    
                    <!-- Actual Content -->
                    <div x-show="!loading" class="relative z-10">
                        <div class="flex justify-between items-start mb-4 md:mb-6">
                            <div>
                                <p class="text-white/80 text-sm md:text-base mb-1 md:mb-2">Available Balance</p>
                                <div class="flex items-center space-x-3 md:space-x-4">
                                    <p class="text-white text-2xl md:text-4xl font-bold tracking-wider" x-text="masked ? '••••••' : balance">$2,456.78</p>
                                    <button @click="toggleBalance()" 
                                        class="text-white/80 hover:text-white transition-colors focus:outline-none" 
                                        :aria-label="masked ? 'Show Balance' : 'Hide Balance'">
                                        <i :class="masked ? 'fas fa-eye' : 'fas fa-eye-slash'" class="w-5 h-5 md:w-6 md:h-6"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="flex items-center space-x-1 text-white/80 text-xs md:text-sm mb-1 md:mb-2">
                                    <i class="fas fa-sync-alt w-3 h-3 md:w-4 md:h-4"></i>
                                    <span>Last updated now</span>
                                </div>
                                <button @click="addMoney()" 
                                    class="bg-white/20 backdrop-blur-sm text-white px-6 py-3 md:px-8 md:py-4 rounded-full text-sm md:text-base font-semibold hover:bg-white/30 transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-white/50 hover:scale-105 shadow-lg">
                                    <span class="flex items-center space-x-2">
                                        <i class="fas fa-plus w-4 h-4 md:w-5 md:h-5"></i>
                                        <span>Add Money</span>
                                    </span>
                                </button>
                            </div>
                        </div>
                        
                        <!-- Quick Stats -->
                        <div class="flex justify-between items-center pt-4 md:pt-6 border-t border-white/20">
                            <div class="text-center">
                                <p class="text-white/80 text-xs md:text-sm">This Month</p>
                                <p class="text-white font-semibold text-sm md:text-base">+$1,234</p>
                            </div>
                            <div class="text-center">
                                <p class="text-white/80 text-xs md:text-sm">Total Spent</p>
                                <p class="text-white font-semibold text-sm md:text-base">$892</p>
                            </div>
                            <div class="text-center">
                                <p class="text-white/80 text-xs md:text-sm">Savings</p>
                                <p class="text-white font-semibold text-sm md:text-base">$342</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Promo Carousel -->
                <div class="overflow-x-auto scrollbar-hide">
                    <div class="flex gap-4 md:gap-6 pb-2">
                        <template x-for="(promo, i) in promos" :key="i">
                            <div class="min-w-[280px] md:min-w-[320px] bg-gradient-to-r from-yellow-400 to-orange-500 rounded-2xl p-4 md:p-6 text-white shadow-lg hover:shadow-xl transition-all duration-300 hover:scale-105 cursor-pointer">
                                <div class="flex items-center justify-between mb-2 md:mb-3">
                                    <div>
                                        <i class="fas fa-star w-8 h-8 md:w-10 md:h-10"></i>
                                    </div>
                                    <span class="text-xs md:text-sm bg-white/20 px-2 py-1 rounded-full">Limited</span>
                                </div>
                                <p class="text-sm md:text-base font-medium mb-3 md:mb-4" x-text="promo.text"></p>
                                <button @click="handlePromo(promo)" 
                                    class="inline-flex items-center space-x-1 font-semibold text-sm md:text-base bg-white/20 px-3 py-2 md:px-4 md:py-2 rounded-full hover:bg-white/30 transition-colors">
                                    <span x-text="promo.cta"></span>
                                    <i class="fas fa-arrow-right w-4 h-4 md:w-5 md:h-5"></i>
                                </button>
                            </div>
                        </template>
                    </div>
                </div>

                <!-- Services Grid -->
                <section class="w-full">
                    <div class="flex justify-between items-center mb-6 px-4">
                        <h2 class="text-xl md:text-2xl font-bold text-gray-900">Services</h2>
                        <button class="text-blue-600 text-sm md:text-base font-semibold hover:underline">More</button>
                    </div>
                    
                    <div class="services-grid px-4">
                        <div class="grid grid-cols-4 sm:grid-cols-6 md:grid-cols-8 lg:grid-cols-10 gap-4 md:gap-6">
                            <template x-for="service in services" :key="service.name">
                                <button @click="handleService(service.name)" 
                                    class="group flex flex-col items-center text-center py-3 hover:scale-110 transition-all duration-300">
                                    <div :class="service.gradient" 
                                        class="w-12 h-12 md:w-14 md:h-14 rounded-2xl flex items-center justify-center mb-2 shadow-lg group-hover:shadow-xl transition-all duration-300">
                                        <i :class="service.icon" class="text-white text-lg md:text-xl"></i>
                                    </div>
                                    <p class="text-xs md:text-sm font-medium text-gray-700 group-hover:text-blue-600 transition-colors" 
                                        x-text="service.name"></p>
                                </button>
                            </template>
                        </div>
                    </div>
                </section>

          
              

              

            </div>

            <!-- Right Sidebar - Desktop Only -->
            <div class="hidden lg:block lg:col-span-3 space-y-6">
                <!-- Quick Actions -->
                <div class="bg-white rounded-3xl p-6 shadow-xl">
                    <h3 class="font-bold text-lg mb-4">Quick Actions</h3>
                    <div class="space-y-3">
                        <template x-for="action in quickActions" :key="action.name">
                            <button @click="handleQuickAction(action.name)" 
                                class="w-full flex items-center space-x-3 p-3 rounded-xl hover:bg-gray-100 transition-colors text-left">
                                <div :class="action.color" class="w-10 h-10 rounded-xl flex items-center justify-center">
                                    <i :class="action.icon" class="text-white"></i>
                                </div>
                                <span class="font-medium" x-text="action.name"></span>
                            </button>
                        </template>
                    </div>
                </div>

                <!-- Spending Analytics -->
                <div class="bg-white rounded-3xl p-6 shadow-xl">
                    <h3 class="font-bold text-lg mb-4">This Month</h3>
                    <div class="space-y-4">
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">Income</span>
                            <span class="font-bold text-green-600">+$3,420</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">Expenses</span>
                            <span class="font-bold text-red-600">-$1,892</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">Savings</span>
                            <span class="font-bold text-blue-600">$1,528</span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2 mt-4">
                            <div class="bg-gradient-to-r from-green-400 to-blue-500 h-2 rounded-full" style="width: 65%"></div>
                        </div>
                        <p class="text-xs text-gray-500 text-center">65% of savings goal reached</p>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- Mobile Bottom Navigation -->
    <nav class="lg:hidden fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 px-4 py-2 z-40">
        <div class="flex justify-around items-center">
            <template x-for="nav in mobileNavItems" :key="nav.name">
                <button @click="activeNav = nav.name" 
                    :class="activeNav === nav.name ? 'text-primary' : 'text-gray-400'" 
                    class="flex flex-col items-center space-y-1 p-2 transition-colors">
                    <i :class="nav.icon" class="text-xl"></i>
                    <span class="text-xs font-medium" x-text="nav.label"></span>
                </button>
            </template>
        </div>
    </nav>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>

   
            
           
    
        </section>

        <!-- Market Cards Section -->
        <div style="position: relative; overflow: hidden;">
            <div style="display: flex; overflow-x: auto; scroll-snap-type: x mandatory; scrollbar-width: none; -ms-overflow-style: none; padding: 0 5px; gap: 16px; scroll-behavior: smooth;">
                <!-- Cryptocurrency Card -->
                <div style="flex: 0 0 clamp(280px, 90vw, 350px); scroll-snap-align: start; background: #ffffff; border-radius: 16px; padding: 20px; box-shadow: 0 4px 12px rgba(139, 92, 246, 0.08); border: 1px solid #f3f4f6; transition: all 0.3s ease; min-height: 300px;" onmouseover="this.style.transform='translateY(-4px)'; this.style.boxShadow='0 8px 25px rgba(139, 92, 246, 0.15)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 12px rgba(139, 92, 246, 0.08)'">
                    <div style="border-radius: 12px; padding: 16px; margin-bottom: 16px; background: linear-gradient(135deg, #8b5cf6, #7c3aed);">
                        <h3 style="font-size: 20px; font-weight: 800; color: white; margin: 0 0 4px 0;">Cryptocurrency</h3>
                        <p style="color: rgba(255,255,255,0.8); font-size: 12px; font-weight: 500; margin: 0;">Digital Assets & Tokens</p>
                    </div>
                    
                    <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 8px;">
                        <div onclick="showAssetChart('BTC', 'Bitcoin', '#F7931A', 65432.50, 2.45)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 10px; background: #f97316; box-shadow: 0 2px 8px rgba(249,115,22,0.3);">
                                <span style="font-size: 10px;">₿</span>
                            </div>
                            <span style="color: #374151; font-size: 10px; font-weight: 600;">BTC</span>
                        </div>
                        
                        <div onclick="showAssetChart('ETH', 'Ethereum', '#627EEA', 3245.80, 1.85)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #3b82f6; box-shadow: 0 2px 8px rgba(59,130,246,0.3);">
                                <span>Ξ</span>
                            </div>
                            <span style="color: #374151; font-size: 10px; font-weight: 600;">ETH</span>
                        </div>
                        
                        <div onclick="showAssetChart('BNB', 'Binance Coin', '#F3BA2F', 425.60, -0.75)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 7px; background: #eab308; box-shadow: 0 2px 8px rgba(234,179,8,0.3);">
                                <span>BNB</span>
                            </div>
                            <span style="color: #374151; font-size: 10px; font-weight: 600;">BNB</span>
                        </div>
                        
                        <div onclick="showAssetChart('ADA', 'Cardano', '#0033AD', 0.485, 3.22)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 7px; background: #1e40af; box-shadow: 0 2px 8px rgba(30,64,175,0.3);">
                                <span>ADA</span>
                            </div>
                            <span style="color: #374151; font-size: 10px; font-weight: 600;">ADA</span>
                        </div>
                        
                        <div onclick="showAssetChart('SOL', 'Solana', '#9945FF', 98.45, 5.67)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 7px; background: #8b5cf6; box-shadow: 0 2px 8px rgba(139,92,246,0.3);">
                                <span>SOL</span>
                            </div>
                            <span style="color: #374151; font-size: 10px; font-weight: 600;">SOL</span>
                        </div>
                        
                        <div onclick="showAssetChart('DOT', 'Polkadot', '#E6007A', 7.85, -1.45)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 7px; background: #ec4899; box-shadow: 0 2px 8px rgba(236,72,153,0.3);">
                                <span>DOT</span>
                            </div>
                            <span style="color: #374151; font-size: 10px; font-weight: 600;">DOT</span>
                        </div>
                        
                        <div onclick="showAssetChart('LINK', 'Chainlink', '#375BD2', 15.25, 2.18)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 6px; background: #1d4ed8; box-shadow: 0 2px 8px rgba(29,78,216,0.3);">
                                <span>LINK</span>
                            </div>
                            <span style="color: #374151; font-size: 10px; font-weight: 600;">LINK</span>
                        </div>
                        
                        <div onclick="showAssetChart('LTC', 'Litecoin', '#BFBBBB', 85.40, 0.95)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 7px; background: #9ca3af; box-shadow: 0 2px 8px rgba(156,163,175,0.3);">
                                <span>LTC</span>
                            </div>
                            <span style="color: #374151; font-size: 10px; font-weight: 600;">LTC</span>
                        </div>
                    </div>
                </div>

                <!-- Forex Card -->
                <div style="flex: 0 0 clamp(280px, 90vw, 350px); scroll-snap-align: start; background: #ffffff; border-radius: 16px; padding: 20px; box-shadow: 0 4px 12px rgba(139, 92, 246, 0.08); border: 1px solid #f3f4f6; transition: all 0.3s ease; min-height: 300px;" onmouseover="this.style.transform='translateY(-4px)'; this.style.boxShadow='0 8px 25px rgba(139, 92, 246, 0.15)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 12px rgba(139, 92, 246, 0.08)'">
                    <div style="border-radius: 12px; padding: 16px; margin-bottom: 16px; background: linear-gradient(135deg, #7c3aed, #6d28d9);">
                        <h3 style="font-size: 20px; font-weight: 800; color: white; margin: 0 0 4px 0;">Forex</h3>
                        <p style="color: rgba(255,255,255,0.8); font-size: 12px; font-weight: 500; margin: 0;">Currency Trading Pairs</p>
                    </div>
                    
                    <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 8px;">
                        <div onclick="showAssetChart('EURUSD', 'EUR/USD', '#1E40AF', 1.0845, -0.12)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #3b82f6; box-shadow: 0 2px 8px rgba(59,130,246,0.3);">
                                <span>€/$</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">EUR/USD</span>
                        </div>
                        
                        <div onclick="showAssetChart('GBPUSD', 'GBP/USD', '#C41E3A', 1.2685, 0.45)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #dc2626; box-shadow: 0 2px 8px rgba(220,38,38,0.3);">
                                <span>£/$</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">GBP/USD</span>
                        </div>
                        
                        <div onclick="showAssetChart('USDJPY', 'USD/JPY', '#BC002D', 149.85, 0.78)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #b91c1c; box-shadow: 0 2px 8px rgba(185,28,28,0.3);">
                                <span>$/¥</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">USD/JPY</span>
                        </div>
                        
                        <div onclick="showAssetChart('USDCHF', 'USD/CHF', '#FF0000', 0.8945, -0.25)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 7px; background: #ef4444; box-shadow: 0 2px 8px rgba(239,68,68,0.3);">
                                <span>CHF</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">USD/CHF</span>
                        </div>
                        
                        <div onclick="showAssetChart('AUDUSD', 'AUD/USD', '#0066CC', 0.6785, 1.15)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #3b82f6; box-shadow: 0 2px 8px rgba(59,130,246,0.3);">
                                <span>A/$</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">AUD/USD</span>
                        </div>
                        
                        <div onclick="showAssetChart('USDCAD', 'USD/CAD', '#FF0000', 1.3545, -0.35)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #ef4444; box-shadow: 0 2px 8px rgba(239,68,68,0.3);">
                                <span>C/$</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">USD/CAD</span>
                        </div>
                        
                        <div onclick="showAssetChart('NZDUSD', 'NZD/USD', '#0066CC', 0.6125, 0.85)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #3b82f6; box-shadow: 0 2px 8px rgba(59,130,246,0.3);">
                                <span>N/$</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">NZD/USD</span>
                        </div>
                        
                        <div onclick="showAssetChart('EURGBP', 'EUR/GBP', '#6366F1', 0.8575, -0.18)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #6366f1; box-shadow: 0 2px 8px rgba(99,102,241,0.3);">
                                <span>€/£</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">EUR/GBP</span>
                        </div>
                    </div>
                </div>

                <!-- Stocks Card -->
                <div style="flex: 0 0 clamp(280px, 90vw, 350px); scroll-snap-align: start; background: #ffffff; border-radius: 16px; padding: 20px; box-shadow: 0 4px 12px rgba(139, 92, 246, 0.08); border: 1px solid #f3f4

f6; transition: all 0.3s ease; min-height: 300px;" onmouseover="this.style.transform='translateY(-4px)'; this.style.boxShadow='0 8px 25px rgba(139, 92, 246, 0.15)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 12px rgba(139, 92, 246, 0.08)'">
                    <div style="border-radius: 12px; padding: 16px; margin-bottom: 16px; background: linear-gradient(135deg, #6d28d9, #5b21b6);">
                        <h3 style="font-size: 20px; font-weight: 800; color: white; margin: 0 0 4px 0;">Stocks</h3>
                        <p style="color: rgba(255,255,255,0.8); font-size: 12px; font-weight: 500; margin: 0;">Global Stock Markets</p>
                    </div>
                    
                    <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 8px;">
                        <div onclick="showAssetChart('AAPL', 'Apple Inc.', '#1D4ED8', 185.45, 1.25)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #1d4ed8; box-shadow: 0 2px 8px rgba(29,78,216,0.3);">
                                <span>🍎</span>
                            </div>
                            <span style="color: #374151; font-size: 10px; font-weight: 600;">AAPL</span>
                        </div>
                        
                        <div onclick="showAssetChart('GOOGL', 'Alphabet Inc.', '#EA4335', 142.30, 0.85)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #dc2626; box-shadow: 0 2px 8px rgba(220,38,38,0.3);">
                                <span>G</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">GOOGL</span>
                        </div>
                        
                        <div onclick="showAssetChart('MSFT', 'Microsoft Corp.', '#00BCF2', 415.20, -0.45)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #0ea5e9; box-shadow: 0 2px 8px rgba(14,165,233,0.3);">
                                <span>MS</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">MSFT</span>
                        </div>
                        
                        <div onclick="showAssetChart('AMZN', 'Amazon.com Inc.', '#FF9900', 155.85, 2.15)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #f97316; box-shadow: 0 2px 8px rgba(249,115,22,0.3);">
                                <span>A</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">AMZN</span>
                        </div>
                        
                        <div onclick="showAssetChart('TSLA', 'Tesla Inc.', '#CC0000', 245.60, 3.85)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #dc2626; box-shadow: 0 2px 8px rgba(220,38,38,0.3);">
                                <span>T</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">TSLA</span>
                        </div>
                        
                        <div onclick="showAssetChart('META', 'Meta Platforms', '#1877F2', 325.40, 1.75)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #3b82f6; box-shadow: 0 2px 8px rgba(59,130,246,0.3);">
                                <span>M</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">META</span>
                        </div>
                        
                        <div onclick="showAssetChart('NVDA', 'NVIDIA Corp.', '#76B900', 485.25, 4.25)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #65a30d; box-shadow: 0 2px 8px rgba(101,163,13,0.3);">
                                <span>N</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">NVDA</span>
                        </div>
                        
                        <div onclick="showAssetChart('NFLX', 'Netflix Inc.', '#E50914', 445.80, -1.15)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #dc2626; box-shadow: 0 2px 8px rgba(220,38,38,0.3);">
                                <span>N</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">NFLX</span>
                        </div>
                    </div>
                </div>

                <!-- Commodities Card -->
                <div style="flex: 0 0 clamp(280px, 90vw, 350px); scroll-snap-align: start; background: #ffffff; border-radius: 16px; padding: 20px; box-shadow: 0 4px 12px rgba(139, 92, 246, 0.08); border: 1px solid #f3f4f6; transition: all 0.3s ease; min-height: 300px;" onmouseover="this.style.transform='translateY(-4px)'; this.style.boxShadow='0 8px 25px rgba(139, 92, 246, 0.15)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 12px rgba(139, 92, 246, 0.08)'">
                    <div style="border-radius: 12px; padding: 16px; margin-bottom: 16px; background: linear-gradient(135deg, #5b21b6, #4c1d95);">
                        <h3 style="font-size: 20px; font-weight: 800; color: white; margin: 0 0 4px 0;">Commodities</h3>
                        <p style="color: rgba(255,255,255,0.8); font-size: 12px; font-weight: 500; margin: 0;">Raw Materials & Energy</p>
                    </div>
                    
                    <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 8px;">
                        <div onclick="showAssetChart('XAUUSD', 'Gold', '#FFD700', 2045.50, 0.65)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #eab308; box-shadow: 0 2px 8px rgba(234,179,8,0.3);">
                                <span>Au</span>
                            </div>
                            <span style="color: #374151; font-size: 10px; font-weight: 600;">GOLD</span>
                        </div>
                        
                        <div onclick="showAssetChart('XAGUSD', 'Silver', '#C0C0C0', 24.85, -0.35)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #9ca3af; box-shadow: 0 2px 8px rgba(156,163,175,0.3);">
                                <span>Ag</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">SILVER</span>
                        </div>
                        
                        <div onclick="showAssetChart('WTIUSD', 'Crude Oil', '#000000', 78.45, 1.85)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #1f2937; box-shadow: 0 2px 8px rgba(31,41,55,0.3);">
                                <span>OIL</span>
                            </div>
                            <span style="color: #374151; font-size: 10px; font-weight: 600;">OIL</span>
                        </div>
                        
                        <div onclick="showAssetChart('NATGAS', 'Natural Gas', '#4169E1', 2.85, -2.15)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #3b82f6; box-shadow: 0 2px 8px rgba(59,130,246,0.3);">
                                <span>GAS</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">NAT GAS</span>
                        </div>
                        
                        <div onclick="showAssetChart('COPPER', 'Copper', '#B87333', 3.85, 0.95)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #a16207; box-shadow: 0 2px 8px rgba(161,98,7,0.3);">
                                <span>Cu</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">COPPER</span>
                        </div>
                        
                        <div onclick="showAssetChart('PLATINUM', 'Platinum', '#E5E4E2', 985.50, -0.45)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 8px; background: #6b7280; box-shadow: 0 2px 8px rgba(107,114,128,0.3);">
                                <span>Pt</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">PLAT</span>
                        </div>
                        
                        <div onclick="showAssetChart('CORN', 'Corn', '#DAA520', 485.25, 1.55)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 7px; background: #d97706; box-shadow: 0 2px 8px rgba(217,119,6,0.3);">
                                <span>CORN</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">CORN</span>
                        </div>
                        
                        <div onclick="showAssetChart('WHEAT', 'Wheat', '#D2691E', 625.80, -1.25)" style="background: #f9fafb; border: 1px solid #f3f4f6; border-radius: 12px; padding: 12px 8px; cursor: pointer; display: flex; flex-direction: column; align-items: center; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(139, 92, 246, 0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <div style="width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 6px; color: white; font-weight: bold; font-size: 6px; background: #c2410c; box-shadow: 0 2px 8px rgba(194,65,12,0.3);">
                                <span>WHEAT</span>
                            </div>
                            <span style="color: #374151; font-size: 8px; font-weight: 600;">WHEAT</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Chart Modal -->
        <div id="chartModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); z-index: 1000; padding: 20px; box-sizing: border-box;" onclick="closeChart()">
            <div style="background: white; border-radius: 16px; max-width: 800px; margin: 0 auto; position: relative; max-height: 90vh; overflow-y: auto;" onclick="event.stopPropagation()">
                <div style="padding: 20px; border-bottom: 1px solid #f3f4f6; display: flex; justify-content: space-between; align-items: center;">
                    <div>
                        <h3 id="chartTitle" style="font-size: 24px; font-weight: 800; color: #1f2937; margin: 0;"></h3>
                        <div style="display: flex; align-items: center; gap: 12px; margin-top: 8px;">
                            <span id="chartPrice" style="font-size: 28px; font-weight: 700; color: #1f2937;"></span>
                            <span id="chartChange" style="font-size: 16px; font-weight: 600; padding: 4px 8px; border-radius: 6px;"></span>
                        </div>
                    </div>
                    <button onclick="closeChart()" style="background: none; border: none; font-size: 24px; color: #6b7280; cursor: pointer; padding: 8px;" onmouseover="this.style.color='#374151'" onmouseout="this.style.color='#6b7280'">×</button>
                </div>
                <div style="padding: 20px;">
                    <canvas id="priceChart" width="400" height="200"></canvas>
                    <div style="display: flex; gap: 12px; margin-top: 20px; flex-wrap: wrap;">
                        <button onclick="buyAsset()" style="background: linear-gradient(135deg, #10b981, #059669); color: white; border: none; padding: 12px 24px; border-radius: 8px; font-weight: 600; cursor: pointer; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(16, 185, 129, 0.3)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            Buy
                        </button>
                        <button onclick="sellAsset()" style="background: linear-gradient(135deg, #ef4444, #dc2626); color: white; border: none; padding: 12px 24px; border-radius: 8px; font-weight: 600; cursor: pointer; transition: all 0.3s ease;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 15px rgba(239, 68, 68, 0.3)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            Sell
                        </button>
                        <button onclick="addToWatchlist()" style="background: #f3f4f6; color: #374151; border: none; padding: 12px 24px; border-radius: 8px; font-weight: 600; cursor: pointer; transition: all 0.3s ease;" onmouseover="this.style.background='#e5e7eb'" onmouseout="this.style.background='#f3f4f6'">
                            Add to Watchlist
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>


    

    <script>
        let currentChart = null;
        
        function transfer(type) {
            alert(`${type} feature coming soon!`);
        }
        
        function viewAll() {
            alert('View All transfers feature coming soon!');
        }
        
        function showAssetChart(symbol, name, color, price, change) {
            document.getElementById('chartTitle').textContent = `${name} (${symbol})`;
            document.getElementById('chartPrice').textContent = `$${price.toFixed(2)}`;
            
            const changeElement = document.getElementById('chartChange');
            changeElement.textContent = `${change >= 0 ? '+' : ''}${change.toFixed(2)}%`;
            changeElement.style.background = change >= 0 ? '#dcfce7' : '#fef2f2';
            changeElement.style.color = change >= 0 ? '#166534' : '#dc2626';
            
            document.getElementById('chartModal').style.display = 'flex';
            
            // Generate sample chart data
            const ctx = document.getElementById('priceChart').getContext('2d');
            
            if (currentChart) {
                currentChart.destroy();
            }
            
            const labels = [];
            const data = [];
            const basePrice = price;
            
            for (let i = 30; i >= 0; i--) {
                labels.push(`${i}d ago`);
                data.push(basePrice * (1 + (Math.random() - 0.5) * 0.1));
            }
            
            currentChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: labels,
                    datasets: [{
                        label: symbol,
                        data: data,
                        borderColor: color,
                        backgroundColor: color + '20',
                        borderWidth: 3,
                        fill: true,
                        tension: 0.4
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: false,
                            grid: {
                                color: '#f3f4f6'
                            }
                        },
                        x: {
                            grid: {
                                color: '#f3f4f6'
                            }
                        }
                    }
                }
            });
        }
        
        function closeChart() {
            document.getElementById('chartModal').style.display = 'none';
            if (currentChart) {
                currentChart.destroy();
                currentChart = null;
            }
        }
        
        function buyAsset() {
            alert('Buy order feature coming soon!');
        }
        
        function sellAsset
        </script>
      
      
      
    
    
    
   
<?php
// Function to fetch and cache cryptocurrency data
function getCryptoData($crypto_id, $cache_file) {
    $cache_duration = 300; // 5 minutes cache
    
    // Use cached data if available and not expired
    if (file_exists($cache_file) && (time() - filemtime($cache_file)) < $cache_duration) {
        return json_decode(file_get_contents($cache_file), true);
    } else {
        // Fetch fresh data from API
        $api_url = "https://api.coingecko.com/api/v3/simple/price?ids={$crypto_id}&vs_currencies=usd&include_24hr_change=true";
        $response = @file_get_contents($api_url);
        
        if ($response !== false) {
            $data = json_decode($response, true);
            if (!empty($data) && isset($data[$crypto_id]['usd'])) {
                // Cache the successful response
                file_put_contents($cache_file, json_encode($data));
                return $data;
            }
        }
        
        // If API call fails, use cached data if available
        if (file_exists($cache_file)) {
            return json_decode(file_get_contents($cache_file), true);
        } else {
            // Create a fallback if no cache exists
            $fallback = [];
            $fallback[$crypto_id]['usd'] = 0;
            $fallback[$crypto_id]['usd_24h_change'] = 0;
            return $fallback;
        }
    }
}

// ==================== Bitcoin Card ====================
$btc_data = getCryptoData('bitcoin', 'btc_price_cache.json');
$btc_price_usd = isset($btc_data['bitcoin']['usd']) ? (float)$btc_data['bitcoin']['usd'] : 0;
$btc_change = isset($btc_data['bitcoin']['usd_24h_change']) ? (float)$btc_data['bitcoin']['usd_24h_change'] : 0;
$btc_amount = ($btc_price_usd > 0) ? $btc / $btc_price_usd : 0;
$btc_change_formatted = number_format($btc_change, 2);
$btc_change_color = ($btc_change >= 0) ? "text-green-500" : "text-red-500";
?>

<a href="detailedbtc.php">
   <div class="neumorphic-card p-4 flex items-center justify-between" id="btcCard">
    <div class="shimmer-effect"></div>
    <div class="flex items-center relative z-10">
      <img src="https://afdkryptostam.com/cryptos/bitcoin.png" alt="Bitcoin" class="w-10 h-10 mr-4">
      <div>
        <p class="font-bold" style="color: #3d4863;">Bitcoin (BTC)</p>
        <p class="text-gray-900 text-sm">
          <?php echo number_format($btc_amount, 6) . ' BTC'; ?>
        </p>
      </div>
    </div>
    <div class="text-right relative z-10">
      <p class="font-semibold" id="btcPrice">$<?php echo number_format($btc_price_usd, 2); ?></p>
      <p class="<?php echo $btc_change_color; ?> text-sm" id="btcChange">
        <?php echo ($btc_change >= 0 ? '+' : '') . $btc_change_formatted . '%'; ?>
      </p>
    </div>
   </div>
</a>

<?php
// ==================== Ethereum Card ====================
$eth_data = getCryptoData('ethereum', 'eth_price_cache.json');
$eth_price_usd = isset($eth_data['ethereum']['usd']) ? (float)$eth_data['ethereum']['usd'] : 0;
$eth_change = isset($eth_data['ethereum']['usd_24h_change']) ? (float)$eth_data['ethereum']['usd_24h_change'] : 0;
$eth_amount = ($eth_price_usd > 0) ? $eth / $eth_price_usd : 0;
$eth_change_formatted = number_format($eth_change, 2);
$eth_change_color = ($eth_change >= 0) ? "text-green-500" : "text-red-500";
?>

<a href="detailedeth.php">
  <div class="neumorphic-card p-4 flex items-center justify-between" id="ethereumCard">
    <div class="shimmer-effect"></div>
    <div class="flex items-center relative z-10">
      <img src="https://coin-images.coingecko.com/coins/images/279/large/ethereum.png?1696501628" alt="Ethereum" class="w-10 h-10 mr-4">
      <div>
        <p class="font-bold" style="color: #3d4863;">Ethereum (ETH)</p>
        <p class="text-gray-900 text-sm">
          <?php echo number_format($eth_amount, 6) . ' ETH'; ?>
        </p>
      </div>
    </div>
    <div class="text-right relative z-10">
      <p class="font-semibold" id="ethPrice">$<?php echo number_format($eth_price_usd, 2); ?></p>
      <p class="<?php echo $eth_change_color; ?> text-sm" id="ethChange">
        <?php echo ($eth_change >= 0 ? '+' : '') . $eth_change_formatted . '%'; ?>
      </p>
    </div>
  </div>
</a>

<?php
// ==================== Tether Card ====================
$usdt_data = getCryptoData('tether', 'usdt_price_cache.json');
$usdt_price_usd = isset($usdt_data['tether']['usd']) ? (float)$usdt_data['tether']['usd'] : 1; // Default to 1 for stablecoins
$usdt_change = isset($usdt_data['tether']['usd_24h_change']) ? (float)$usdt_data['tether']['usd_24h_change'] : 0;
$usdt_amount = ($usdt_price_usd > 0) ? $usdt / $usdt_price_usd : 0;
$usdt_change_formatted = number_format($usdt_change, 2);
$usdt_change_color = ($usdt_change >= 0) ? "text-green-500" : "text-red-500";
?>

<a href="detailedusdt.php">
  <div class="neumorphic-card p-4 flex items-center justify-between" id="usdtCard">
    <div class="shimmer-effect"></div>
    <div class="flex items-center relative z-10">
      <img src="https://coin-images.coingecko.com/coins/images/325/large/Tether.png?1696501661" alt="Tether" class="w-10 h-10 mr-4">
      <div>
        <p class="font-bold" style="color: #3d4863;">Tether (USDT)</p>
        <p class="text-gray-900 text-sm">
          <?php echo number_format($usdt_amount, 6) . ' USDT'; ?>
        </p>
      </div>
    </div>
    <div class="text-right relative z-10">
      <p class="font-semibold" id="usdtPrice">$<?php echo number_format($usdt_price_usd, 4); ?></p>
      <p class="<?php echo $usdt_change_color; ?> text-sm" id="usdtChange">
        <?php echo ($usdt_change >= 0 ? '+' : '') . $usdt_change_formatted . '%'; ?>
      </p>
    </div>
  </div>
</a>


<?php
// ==================== XRP Card ====================
$xrp_data = getCryptoData('ripple', 'xrp_price_cache.json');
$xrp_price_usd = isset($xrp_data['ripple']['usd']) ? (float)$xrp_data['ripple']['usd'] : 0;
$xrp_change = isset($xrp_data['ripple']['usd_24h_change']) ? (float)$xrp_data['ripple']['usd_24h_change'] : 0;
$xrp_amount = ($xrp_price_usd > 0) ? $xrp / $xrp_price_usd : 0;
$xrp_change_formatted = number_format($xrp_change, 2);
$xrp_change_color = ($xrp_change >= 0) ? "text-green-500" : "text-red-500";
?>

<a href="detailxrp.php">
  <div class="neumorphic-card p-4 flex items-center justify-between" id="xrpCard">
    <div class="shimmer-effect"></div>
    <div class="flex items-center relative z-10">
      <img src="https://primemarketspro.com/cryptos/xrp.png" alt="XRP" class="w-10 h-10 mr-4">
      <div>
        <p class="font-bold" style="color: #3d4863;">XRP (XRP)</p>
        <p class="text-gray-900 text-sm">
          <?php echo number_format($xrp_amount, 6) . ' XRP'; ?>
        </p>
      </div>
    </div>
    <div class="text-right relative z-10">
      <p class="font-semibold" id="xrpPrice">$<?php echo number_format($xrp_price_usd, 4); ?></p>
      <p class="<?php echo $xrp_change_color; ?> text-sm" id="xrpChange">
        <?php echo ($xrp_change >= 0 ? '+' : '') . $xrp_change_formatted . '%'; ?>
      </p>
    </div>
  </div>
</a>

<?php
// ==================== SOL Card ====================
$sol_data = getCryptoData('solana', 'sol_price_cache.json');
$sol_price_usd = isset($sol_data['solana']['usd']) ? (float)$sol_data['solana']['usd'] : 0;
$sol_change = isset($sol_data['solana']['usd_24h_change']) ? (float)$sol_data['solana']['usd_24h_change'] : 0;
$sol_amount = ($sol_price_usd > 0) ? $sol / $sol_price_usd : 0;
$sol_change_formatted = number_format($sol_change, 2);
$sol_change_color = ($sol_change >= 0) ? "text-green-500" : "text-red-500";
?>

<a href="detailedsol.php">
  <div class="neumorphic-card p-4 flex items-center justify-between" id="solCard">
    <div class="shimmer-effect"></div>
    <div class="flex items-center relative z-10">
      <img src="https://primemarketspro.com/cryptos/sol.png" alt="SOL" class="w-10 h-10 mr-4">
      <div>
        <p class="font-bold" style="color: #3d4863;">SOL (SOL)</p>
        <p class="text-gray-900 text-sm">
          <?php echo number_format($sol_amount, 6) . ' SOL'; ?>
        </p>
      </div>
    </div>
    <div class="text-right relative z-10">
      <p class="font-semibold" id="solPrice">$<?php echo number_format($sol_price_usd, 4); ?></p>
      <p class="<?php echo $sol_change_color; ?> text-sm" id="solChange">
        <?php echo ($sol_change >= 0 ? '+' : '') . $sol_change_formatted . '%'; ?>
      </p>
    </div>
  </div>
</a>

<?php
// ==================== ADA Card ====================
$ada_data = getCryptoData('cardano', 'ada_price_cache.json');
$ada_price_usd = isset($ada_data['cardano']['usd']) ? (float)$ada_data['cardano']['usd'] : 0;
$ada_change = isset($ada_data['cardano']['usd_24h_change']) ? (float)$ada_data['cardano']['usd_24h_change'] : 0;
$ada_amount = ($ada_price_usd > 0) ? $ada / $ada_price_usd : 0;
$ada_change_formatted = number_format($ada_change, 2);
$ada_change_color = ($ada_change >= 0) ? "text-green-500" : "text-red-500";
?>

<a href="detailada.php">
  <div class="neumorphic-card p-4 flex items-center justify-between" id="adaCard">
    <div class="shimmer-effect"></div>
    <div class="flex items-center relative z-10">
      <img src="https://primemarketspro.com/cryptos/ada.png" alt="ADA" class="w-10 h-10 mr-4">
      <div>
        <p class="font-bold" style="color: #3d4863;">ADA (ADA)</p>
        <p class="text-gray-900 text-sm">
          <?php echo number_format($ada_amount, 6) . ' ADA'; ?>
        </p>
      </div>
    </div>
    <div class="text-right relative z-10">
      <p class="font-semibold" id="adaPrice">$<?php echo number_format($ada_price_usd, 4); ?></p>
      <p class="<?php echo $ada_change_color; ?> text-sm" id="adaChange">
        <?php echo ($ada_change >= 0 ? '+' : '') . $ada_change_formatted . '%'; ?>
      </p>
    </div>
  </div>
</a>

<?php
// ==================== BNB Card ====================
$bnb_data = getCryptoData('binancecoin', 'bnb_price_cache.json');
$bnb_price_usd = isset($bnb_data['binancecoin']['usd']) ? (float)$bnb_data['binancecoin']['usd'] : 0;
$bnb_change = isset($bnb_data['binancecoin']['usd_24h_change']) ? (float)$bnb_data['binancecoin']['usd_24h_change'] : 0;
$bnb_amount = ($bnb_price_usd > 0) ? $bnb / $bnb_price_usd : 0;
$bnb_change_formatted = number_format($bnb_change, 2);
$bnb_change_color = ($bnb_change >= 0) ? "text-green-500" : "text-red-500";
?>

<a href="detailbnb.php">
  <div class="neumorphic-card p-4 flex items-center justify-between" id="bnbCard">
    <div class="shimmer-effect"></div>
    <div class="flex items-center relative z-10">
      <img src="https://primemarketspro.com/cryptos/bnb.png" alt="BNB" class="w-10 h-10 mr-4">
      <div>
        <p class="font-bold" style="color: #3d4863;">BNB (BNB)</p>
        <p class="text-gray-900 text-sm">
          <?php echo number_format($bnb_amount, 6) . ' BNB'; ?>
        </p>
      </div>
    </div>
    <div class="text-right relative z-10">
      <p class="font-semibold" id="bnbPrice">$<?php echo number_format($bnb_price_usd, 2); ?></p>
      <p class="<?php echo $bnb_change_color; ?> text-sm" id="bnbChange">
        <?php echo ($bnb_change >= 0 ? '+' : '') . $bnb_change_formatted . '%'; ?>
      </p>
    </div>
  </div>
</a>

<?php
// ==================== Dogecoin Card ====================
$doge_data = getCryptoData('dogecoin', 'doge_price_cache.json');
$doge_price_usd = isset($doge_data['dogecoin']['usd']) ? (float)$doge_data['dogecoin']['usd'] : 0;
$doge_change = isset($doge_data['dogecoin']['usd_24h_change']) ? (float)$doge_data['dogecoin']['usd_24h_change'] : 0;
$doge_amount = ($doge_price_usd > 0) ? $doge / $doge_price_usd : 0;
$doge_change_formatted = number_format($doge_change, 2);
$doge_change_color = ($doge_change >= 0) ? "text-green-500" : "text-red-500";
?>

<a href="detailedoge.php">
  <div class="neumorphic-card p-4 flex items-center justify-between" id="dogeCard">
    <div class="shimmer-effect"></div>
    <div class="flex items-center relative z-10">
      <img src="https://primemarketspro.com/cryptos/doge.png" alt="Dogecoin" class="w-10 h-10 mr-4">
      <div>
        <p class="font-bold" style="color: #3d4863;">Dogecoin (DOGE)</p>
        <p class="text-gray-900 text-sm">
          <?php echo number_format($doge_amount, 6) . ' DOGE'; ?>
        </p>
      </div>
    </div>
    <div class="text-right relative z-10">
      <p class="font-semibold" id="dogePrice">$<?php echo number_format($doge_price_usd, 2); ?></p>
      <p class="<?php echo $doge_change_color; ?> text-sm" id="dogeChange">
        <?php echo ($doge_change >= 0 ? '+' : '') . $doge_change_formatted . '%'; ?>
      </p>
    </div>
  </div>
</a>

<?php
// ==================== Pepe Card ====================
$pepe_data = getCryptoData('pepe', 'pepe_price_cache.json');
$pepe_price_usd = isset($pepe_data['pepe']['usd']) ? (float)$pepe_data['pepe']['usd'] : 0;
$pepe_change = isset($pepe_data['pepe']['usd_24h_change']) ? (float)$pepe_data['pepe']['usd_24h_change'] : 0;
$pepe_amount = ($pepe_price_usd > 0) ? $pepe / $pepe_price_usd : 0;
$pepe_change_formatted = number_format($pepe_change, 2);
$pepe_change_color = ($pepe_change >= 0) ? "text-green-500" : "text-red-500";
?>

<a href="detailedpepe.php">
  <div class="neumorphic-card p-4 flex items-center justify-between" id="pepeCard">
    <div class="shimmer-effect"></div>
    <div class="flex items-center relative z-10">
      <!-- Replace the src below with the correct Pepe logo URL if needed -->
      <img src="https://primemarketspro.com/cryptos/pepe.png" alt="Pepe" class="w-10 h-10 mr-4">
      <div>
        <p class="font-bold" style="color: #3d4863;">Pepe (PEPE)</p>
        <p class="text-gray-900 text-sm">
          <?php echo number_format($pepe_amount, 6) . ' PEPE'; ?>
        </p>
      </div>
    </div>
    <div class="text-right relative z-10">
      <p class="font-semibold" id="pepePrice">$<?php echo number_format($pepe_price_usd, 2); ?></p>
      <p class="<?php echo $pepe_change_color; ?> text-sm" id="pepeChange">
        <?php echo ($pepe_change >= 0 ? '+' : '') . $pepe_change_formatted . '%'; ?>
      </p>
    </div>
  </div>
</a>

</div>
</section>



<!--<div style=" padding: 4px; margin-top: 65px;">-->


<?php
require('db.php'); // This file sets up the PDO connection in $conn and includes your session functions
// Retrieve the user email from session using your helper function
$user_email = getSessionEmail();
if (!$user_email) {
    echo '<div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded relative" role="alert">
            <strong class="font-bold">Not Logged In</strong>
            <span class="block sm:inline"> Please log in to access your dashboard.</span>
          </div>';
    exit;
}
// Prepare the query using PDO with a named parameter
$query = "SELECT * FROM kyc_submissions WHERE email = :email";
$stmt = $conn->prepare($query);
// Bind the email parameter using bindParam
$stmt->bindParam(':email', $user_email, PDO::PARAM_STR);
// Execute the query
$stmt->execute();
// Fetch the user data as an associative array
$user = $stmt->fetch(PDO::FETCH_ASSOC);
if ($user) {
    if ($user['status'] == 'verified') {
        $statusMessage = '<div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
  <div class="flex items-center">
    <script src="https://cdn.lordicon.com/lordicon.js"></script>
    <lord-icon
      src="https://cdn.lordicon.com/stxfyhky.json"
      trigger="loop"
      delay="2000"
      colors="primary:#ffffff,secondary:#28a745"
      style="width:50px;height:50px">
    </lord-icon>
    <div class="ml-3">
      <p>
        Your account status is currently high.
        <span class="inline-flex items-center ml-2">
          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="w-5 h-5">
            <circle cx="12" cy="12" r="12" fill="#1877F2"/>
            <path d="M10.1 16.2l-3.7-3.7 1.4-1.4 2.3 2.3 5.3-5.3 1.4 1.4L10.1 16.2z" fill="#fff"/>
          </svg>
        </span>
        Contact Support if you encounter any issues.
      </p>
    </div>
  </div>
</div>
';
    } else {
        $statusMessage = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                            <div class="flex items-center">
                              <script src="https://cdn.lordicon.com/lordicon.js"></script>
                              <lord-icon
                                  src="https://cdn.lordicon.com/stxfyhky.json"
                                  trigger="loop"
                                  delay="2000"
                                  colors="primary:#ffffff,secondary:#ee6d66"
                                  style="width:50px;height:50px">
                              </lord-icon>
                              <div class="ml-3">
                                <p>Account is currently Unverified</p>
                              </div>
                            </div>
                          </div>';
    }
    echo $statusMessage;
} else {
    echo '<div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded relative" role="alert">
            <strong class="font-bold">Pending</strong>
            <span class="block sm:inline"> Please proceed with your KYC .</span>
          </div>';
}
?>




<div class="container mx-auto px-4 py-8">
  <div id="imageSlider" class="relative overflow-hidden group">
    <!-- Slider Track -->
    <div class="slider-track flex overflow-x-auto scroll-smooth pb-6 snap-x snap-mandatory gap-4">
      <?php
      $sql = "SELECT id, title, content, image_url FROM blogs ORDER BY created_at DESC"; // Fetch all posts
      $stmt = $conn->query($sql);

      // Fetch all blog posts as an associative array
      $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

      if (count($rows) > 0) {
          foreach ($rows as $row) {
              $id = $row['id'];
              $title = $row['title'];
              $content = $row['content'];
              $image_url = $row['image_url'];

              // Limit content to the first 5 words
              $content_words = explode(' ', $content);
              if (count($content_words) > 5) {
                  $content = implode(' ', array_slice($content_words, 0, 5)) . '...';
              }
      ?>
          <a href="blog_detail.php?id=<?php echo $id; ?>" class="block" style="text-decoration: none;">
              <div class="slider-card" style="
                  background: #f8f9fa; /* Lighter background */
                  border-radius: 10px; 
                  box-shadow: 2px 2px 8px rgba(0, 0, 0, 0.1);
                  display: flex;
                  flex-direction: column; /* Stack image & content */
                  width: 320px; /* More user-friendly size */
                  overflow: hidden;
                  transition: transform 0.3s ease;
              ">
                  <!-- Image -->
                  <div class="card-image" style="
                      width: 100%;
                      height: 180px; /* Reduce height for better layout */
                      background-image: url('./uploads/<?php echo $image_url; ?>');
                      background-size: cover; 
                      background-position: center; 
                      border-top-left-radius: 10px; 
                      border-top-right-radius: 10px;">
                  </div>

                  <!-- Content -->
                  <div class="card-content" style="
                      padding: 12px;
                      text-align: left; 
                      display: flex;
                      flex-direction: column;
                      justify-content: center;
                  ">
                      <h3 style="
                          font-size: 16px; /* Reduce size slightly */
                          font-weight: bold; 
                          color: #3d4863; 
                          margin-bottom: 5px;
                          line-height: 1.4;
                          white-space: normal;
                          word-wrap: break-word;
                          overflow-wrap: break-word;
                      ">
                          <?php echo nl2br(htmlspecialchars($title)); ?>
                      </h3>

                      <p style="
                          font-size: 14px;
                          color: #555;
                          line-height: 1.5;
                          margin-top: 5px;
                      ">
                          <?php echo nl2br(htmlspecialchars($content)); ?>
                      </p>
                  </div>
              </div>
          </a>
      <?php
          }
      } else {
          echo "<p style='text-align: center; font-size: 16px; color: #555;'>No blog posts found.</p>";
      }

      // Close the PDO connection by setting it to null
      $conn = null;
      ?>
    </div>
  </div>
</div>


<!-- Navigation Buttons -->
<button class="nav-button absolute left-4 top-1/2 -translate-y-1/2 opacity-0 group-hover:opacity-100" id="prevButton">
  &larr;
</button>
<button class="nav-button absolute right-4 top-1/2 -translate-y-1/2 opacity-0 group-hover:opacity-100" id="nextButton">
  &rarr;
</button>

<script>
// Get the slider track
const sliderTrack = document.querySelector('.slider-track');

// The number of pixels to scroll per button click
const scrollSpeed = 300;

// Start auto-scrolling if needed (optional)
let autoScroll;
function startAutoScroll() {
    autoScroll = setInterval(() => {
        if (sliderTrack.scrollLeft + sliderTrack.clientWidth >= sliderTrack.scrollWidth) {
            sliderTrack.scrollTo({ left: 0, behavior: 'instant' }); // Instantly reset to the start
        } else {
            sliderTrack.scrollLeft += scrollSpeed;
        }
    }, 50); // Adjust interval for smoothness
}

// Pause auto-scroll on hover (optional feature)
sliderTrack.addEventListener('mouseover', () => clearInterval(autoScroll));
sliderTrack.addEventListener('mouseleave', startAutoScroll);

// Manual Navigation (Left and Right buttons)
const prevBtn = document.getElementById('prevButton');
const nextBtn = document.getElementById('nextButton');

// Scroll right on clicking the "next" button
nextBtn.addEventListener('click', () => {
    sliderTrack.scrollBy({ left: scrollSpeed, behavior: 'smooth' });
});

// Scroll left on clicking the "prev" button
prevBtn.addEventListener('click', () => {
    sliderTrack.scrollBy({ left: -scrollSpeed, behavior: 'smooth' });
});
</script>








<script src="https://cdn.tailwindcss.com"></script>


<div class="container mx-auto px-4 py-12">
  <h1 class="text-2xl font-bold mb-6">Today's Top Movers</h1>
  
  <!-- Skeleton Loader -->
  <div id="skeletonLoader" class="flex gap-6 overflow-x-auto pb-6 snap-x snap-mandatory">
    <!-- Skeleton Card Template -->
    <!-- Repeat Skeleton Card as Needed -->
    <!-- Here, we'll create 5 skeleton cards -->
    <div class="crypto-card flex-shrink-0 w-full sm:w-96 bg-white rounded-xl p-4 shadow-md snap-center animate-pulse">
      <div class="flex items-center gap-3 mb-4">
        <div class="w-10 h-10 bg-gray-300 rounded-full shimmer"></div>
        <div class="flex-1 space-y-2 py-1">
          <div class="h-4 bg-gray-300 rounded w-24 shimmer"></div>
          <div class="h-3 bg-gray-300 rounded w-16 shimmer"></div>
        </div>
      </div>
      <div class="space-y-2 mb-4">
        <div class="h-6 bg-gray-300 rounded w-32 shimmer"></div>
        <div class="h-4 bg-gray-300 rounded w-20 shimmer"></div>
      </div>
      <div class="h-8 bg-gray-300 rounded shimmer"></div>
    </div>
    <!-- Duplicate the skeleton card to fill the loader -->
    <div class="crypto-card flex-shrink-0 w-full sm:w-96 bg-white rounded-xl p-4 shadow-md snap-center animate-pulse">
      <!-- ...same content as above... -->
    </div>
    <div class="crypto-card flex-shrink-0 w-full sm:w-96 bg-white rounded-xl p-4 shadow-md snap-center animate-pulse">
      <!-- ...same content as above... -->
    </div>
    <div class="crypto-card flex-shrink-0 w-full sm:w-96 bg-white rounded-xl p-4 shadow-md snap-center animate-pulse">
      <!-- ...same content as above... -->
    </div>
    <div class="crypto-card flex-shrink-0 w-full sm:w-96 bg-white rounded-xl p-4 shadow-md snap-center animate-pulse">
      <!-- ...same content as above... -->
    </div>
  </div>

  <!-- Slider Container -->
  <div id="sliderContainer" class="relative overflow-hidden group hidden">
    <!-- Slider Track -->
    <div id="sliderTrack" class="flex gap-6 overflow-x-auto scroll-smooth pb-6 snap-x snap-mandatory">
      <!-- Crypto cards will be injected here -->
    </div>

    <!-- Navigation Buttons -->
    <button id="prevBtn" class="absolute left-0 top-1/2 -translate-y-1/2 bg-white p-3 rounded-full shadow-lg opacity-0 group-hover:opacity-100 transition-opacity" aria-label="Previous Slide">
      &larr;
    </button>
    <button id="nextBtn" class="absolute right-0 top-1/2 -translate-y-1/2 bg-white p-3 rounded-full shadow-lg opacity-0 group-hover:opacity-100 transition-opacity" aria-label="Next Slide">
      &rarr;
    </button>
  </div>
</div>

<script>
  // Load crypto data from CoinGecko and initialize the slider
  async function loadCryptoData() {
    try {
      // Corrected API URL with a valid order parameter and added price_change_percentage parameter
      const response = await fetch(
        'https://api.coingecko.com/api/v3/coins/markets?vs_currency=usd&order=market_cap_desc&per_page=10&page=1&sparkline=true&price_change_percentage=24h'
      );
      const coins = await response.json();

      // Ensure we received an array
      if (!Array.isArray(coins)) {
        throw new Error('Invalid response format');
      }

      // Manually sort coins by 24h price change percentage (top movers first)
      coins.sort((a, b) => {
        // Use price_change_percentage_24h_in_currency if available, fallback to price_change_percentage_24h
        const changeA = a.price_change_percentage_24h_in_currency || a.price_change_percentage_24h || 0;
        const changeB = b.price_change_percentage_24h_in_currency || b.price_change_percentage_24h || 0;
        return changeB - changeA;
      });

      const sliderTrack = document.getElementById('sliderTrack');
      const skeletonLoader = document.getElementById('skeletonLoader');
      const sliderContainer = document.getElementById('sliderContainer');

      // Inject crypto cards into the slider track
      coins.forEach(coin => {
        const card = createCryptoCard(coin);
        sliderTrack.innerHTML += card;
      });

      // Hide the skeleton loader and show the slider container
      skeletonLoader.classList.add('hidden');
      sliderContainer.classList.remove('hidden');

      // Initialize slider controls and auto-scroll
      initSlider();
    } catch (error) {
      console.error('Error loading crypto data:', error);
    }
  }

  // Create a crypto card from a coin object
  function createCryptoCard(coin) {
    // Prefer price_change_percentage_24h_in_currency if available
    const priceChange = coin.price_change_percentage_24h_in_currency || coin.price_change_percentage_24h || 0;
    const changeColor = priceChange >= 0 ? 'text-green-500' : 'text-red-500';
    const sparkline = generateSparkline(coin.sparkline_in_7d.price);

    return `
      <div class="crypto-card flex-shrink-0 w-full sm:w-96 bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow snap-center">
        <div class="flex items-center gap-3 mb-4">
          <img src="${coin.image}" alt="${coin.name}" class="w-10 h-10 rounded-full">
          <div>
            <h3 class="font-bold text-gray-900">${coin.symbol.toUpperCase()}/USD</h3>
            <p class="text-sm text-gray-700">${coin.name}</p>
          </div>
        </div>
        
        <div class="mb-4">
          <p class="text-2xl font-bold text-gray-900">$${coin.current_price.toLocaleString()}</p>
          <p class="${changeColor} text-sm">${priceChange.toFixed(2)}%</p>
        </div>
        
        <div class="h-8"> 
          ${sparkline}
        </div>
      </div>
    `;
  }

  // Generate a sparkline SVG from an array of prices
  function generateSparkline(prices) {
    const svgWidth = 210;
    const svgHeight = 30;
    const maxPrice = Math.max(...prices);
    const minPrice = Math.min(...prices);
    const normalized = prices.map(p => ((p - minPrice) / (maxPrice - minPrice)) * svgHeight);
    
    const points = normalized.map((value, index) => {
      const x = (index / (prices.length - 1)) * svgWidth;
      const y = svgHeight - value;
      return `${x},${y}`;
    }).join(' ');

    return `
      <svg viewBox="0 0 ${svgWidth} ${svgHeight}" class="w-full h-full">
        <polyline 
          points="${points}"
          fill="none" 
          stroke="${prices[0] <= prices[prices.length - 1] ? '#16a34a' : '#dc2626'}"
          stroke-width="2"
          stroke-linecap="round"
        />
      </svg>
    `;
  }

  // Initialize slider controls and auto-scroll functionality
  function initSlider() {
    const sliderTrack = document.getElementById('sliderTrack');
    const prevBtn = document.getElementById('prevBtn');
    const nextBtn = document.getElementById('nextBtn');
    
    let scrollPosition = 0;

    // Calculate the width of a crypto card (including its right margin)
    function getCardWidth() {
      const card = document.querySelector('.crypto-card');
      const cardStyle = getComputedStyle(card);
      const marginRight = parseInt(cardStyle.marginRight) || 0;
      return card.offsetWidth + marginRight;
    }

    // Next button event
    nextBtn.addEventListener('click', () => {
      const cardWidth = getCardWidth();
      scrollPosition += cardWidth;
      if (scrollPosition >= sliderTrack.scrollWidth) {
        scrollPosition = 0;
      }
      sliderTrack.scrollTo({
        left: scrollPosition,
        behavior: 'smooth'
      });
    });

    // Previous button event
    prevBtn.addEventListener('click', () => {
      const cardWidth = getCardWidth();
      scrollPosition -= cardWidth;
      if (scrollPosition < 0) {
        scrollPosition = sliderTrack.scrollWidth - sliderTrack.clientWidth;
      }
      sliderTrack.scrollTo({
        left: scrollPosition,
        behavior: 'smooth'
      });
    });

    // Auto-scroll functionality: scrolls every 3 seconds
    setInterval(() => {
      const cardWidth = getCardWidth();
      if (scrollPosition + cardWidth >= sliderTrack.scrollWidth) {
        scrollPosition = 0;
      } else {
        scrollPosition += cardWidth;
      }
      sliderTrack.scrollTo({
        left: scrollPosition,
        behavior: 'smooth'
      });
    }, 3000);
  }

  // Load data when the page loads
  window.addEventListener('load', loadCryptoData);
</script>








<!-- Stake Section -->
<section id="stakeSection" style="padding-top: 2rem;">
  
  

  <div class="container mx-auto">
  <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
    
    <!-- Enhanced Crypto Converter Widget -->
    <div class="bg-white shadow rounded-lg p-6">
      <h2 class="text-2xl font-bold mb-4">Crypto Converter</h2>
      <form id="converterForm" class="space-y-4">
        <div>
          <label for="fromCurrency" class="block text-sm font-medium text-gray-700">From</label>
          <div class="relative">
            <select id="fromCurrency" name="fromCurrency" class="mt-1 block w-full border border-gray-300 rounded-lg shadow-sm p-2 pl-10">
              <!-- Will be populated by JavaScript -->
            </select>
            <div id="fromCurrencyIcon" class="absolute left-3 top-3 w-6 h-6"></div>
          </div>
        </div>
        <div>
          <label for="toCurrency" class="block text-sm font-medium text-gray-700">To</label>
          <div class="relative">
            <select id="toCurrency" name="toCurrency" class="mt-1 block w-full border border-gray-300 rounded-lg shadow-sm p-2 pl-10">
              <!-- Will be populated by JavaScript -->
            </select>
            <div id="toCurrencyIcon" class="absolute left-3 top-3 w-6 h-6"></div>
          </div>
        </div>
        <div>
          <label for="amount" class="block text-sm font-medium text-gray-700">Amount</label>
          <input
            type="number"
            id="amount"
            name="amount"
            placeholder="Enter amount"
            class="mt-1 block w-full border border-gray-300 rounded-lg shadow-sm p-2"
            step="any"
          />
        </div>
      </form>
      <div id="result" class="mt-4 p-4 bg-gray-50 rounded-lg text-gray-800"></div>
      <div id="lastUpdated" class="mt-2 text-xs text-gray-500 text-right"></div>
    </div>
    


 
 <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- (Optional) Include your CSS framework styles -->


<!-- Display update messages if present -->
<?php if (isset($updateMessage)): ?>
    <div class="alert alert-success"><?php echo $updateMessage; ?></div>
<?php endif; ?>
<?php if (isset($updateError)): ?>
    <div class="alert alert-danger"><?php echo $updateError; ?></div>
<?php endif; ?>

<!-- Rest of your page content -->

<script>
document.addEventListener('DOMContentLoaded', function() {
  <?php if ($showProfileAlert): ?>
    Swal.fire({
      title: 'Complete Your Profile',
      html: `<form id="profileForm">
                <div class="form-group" style="text-align:left; margin-bottom:10px;">
                  <label for="country">Country:</label>
                  <select name="country" id="country" class="form-control" required>
                    <option value="">Select Country</option>
                    <?php foreach ($allCountries as $option): ?>
                      <option value="<?php echo $option['dial_code']; ?>">
                        <?php echo $option['name']; ?>
                      </option>
                    <?php endforeach; ?>
                  </select>
                </div>
                <div class="form-group" style="text-align:left; margin-bottom:10px;">
                  <label for="phone">Phone Number:</label>
                  <input type="tel" name="full_phone" id="phone" class="form-control" placeholder="Enter phone number" required/>
                </div>
              </form>`,
      showCancelButton: false,
      confirmButtonText: 'Update Profile',
      preConfirm: () => {
        const country = document.getElementById('country').value;
        const phone = document.getElementById('phone').value;
        if (!country || !phone) {
          Swal.showValidationMessage('Both country and phone number are required.');
          return false;
        }
        return { country: country, full_phone: phone };
      }
    }).then((result) => {
      if (result.isConfirmed) {
        // Create FormData and include a flag for profile update
        const formData = new FormData();
        formData.append('update_profile', '1');
        formData.append('country', result.value.country);
        formData.append('full_phone', result.value.full_phone);
        
        // Send the data via AJAX (fetch API)
        fetch(window.location.href, {
            method: 'POST',
            body: formData
        })
        .then(response => response.text())
        .then(data => {
            Swal.fire({
              icon: 'success',
              title: 'Profile updated successfully',
              timer: 1500,
              showConfirmButton: false
            });
            // Optionally, update parts of the page with new data here.
        })
        .catch(error => {
            Swal.fire({
              icon: 'error',
              title: 'Update failed',
              text: error
            });
        });
      }
    });
  <?php endif; ?>
});
</script>







 
 
 
 
 
 
 
 
 
 
 <div class="bg-white shadow rounded-lg p-6 w-full max-w-md">
    <h2 class="text-2xl font-bold mb-4 text-center">Crypto Buy/Sell</h2>
    <form id="tradeForm" action="tradeprocess.php" method="POST" class="space-y-4">
      <!-- Transaction Type -->
      <div>
        <label for="transactionType" class="block text-sm font-medium text-gray-700">Transaction Type</label>
        <select id="transactionType" name="transactionType" class="mt-1 block w-full border border-gray-300 rounded-lg shadow-sm p-2" required>
          <option value="" disabled selected>Select Type</option>
          <!-- Using inline style for option text colors (supported in some browsers) -->
          <option value="buy" style="color: green;">Buy</option>
          <option value="sell" style="color: red;">Sell</option>
        </select>
      </div>
      <!-- Currency Dropdown (populated dynamically with up to 30 coins) -->
      <div>
        <label for="transactionCurrency" class="block text-sm font-medium text-gray-700">Currency</label>
        <select id="transactionCurrency" name="transactionCurrency" class="mt-1 block w-full border border-gray-300 rounded-lg shadow-sm p-2" required>
          <option value="" disabled selected>Loading coins...</option>
        </select>
      </div>
      <!-- USD Amount Input -->
      <div>
        <label for="transactionAmount" class="block text-sm font-medium text-gray-700">Amount (USD)</label>
        <input type="number" id="transactionAmount" name="transactionAmount" placeholder="Enter amount in USD" min="0.01" step="0.01" required class="mt-1 block w-full border border-gray-300 rounded-lg shadow-sm p-2">
      </div>
      <!-- Converted Coin Amount (read-only) -->
      <div>
        <label for="convertedAmount" class="block text-sm font-medium text-gray-700">
          Converted Amount (<span id="selectedSymbol">COIN</span>)
        </label>
        <input type="number" id="convertedAmount" name="convertedAmount" placeholder="Coin amount" readonly class="mt-1 block w-full border border-gray-300 rounded-lg shadow-sm p-2">
      </div>
      <button type="submit" class="w-full bg-blue-600 text-white py-2 rounded-lg hover:bg-blue-700 transition">
        Submit Order
      </button>
    </form>
  </div>

  <script>
    // Global object to store coin prices (keyed by coin id)
    let coinPrices = {};

    // Fetch up to 30 coins from CoinGecko's API
    async function fetchCoins() {
      try {
        const url = 'https://api.coingecko.com/api/v3/coins/markets?' + new URLSearchParams({
          vs_currency: 'usd',
          order: 'market_cap_desc',
          per_page: 30,
          page: 1,
          sparkline: false
        });
        const response = await fetch(url);
        const coins = await response.json();
        populateCoinDropdown(coins);
      } catch (error) {
        console.error('Error fetching coins:', error);
        const select = document.getElementById('transactionCurrency');
        select.innerHTML = '<option value="">Error loading coins</option>';
      }
    }

    // Populate the currency dropdown with fetched coins
    function populateCoinDropdown(coins) {
      const select = document.getElementById('transactionCurrency');
      select.innerHTML = '<option value="" disabled selected>Select Currency</option>';
      coins.forEach(coin => {
        // Save coin price for conversion
        coinPrices[coin.id] = coin.current_price;
        const option = document.createElement('option');
        option.value = coin.id;
        option.textContent = `${coin.name} (${coin.symbol.toUpperCase()})`;
        select.appendChild(option);
      });
    }

    // Convert USD to coin amount based on selected coin's current price
    function convertUsdToCoin() {
      const usdAmount = parseFloat(document.getElementById('transactionAmount').value) || 0;
      const coinId = document.getElementById('transactionCurrency').value;
      if (!coinId || !coinPrices[coinId]) {
        document.getElementById('convertedAmount').value = '';
        document.getElementById('selectedSymbol').textContent = 'COIN';
        return;
      }
      const price = coinPrices[coinId]; // USD per coin
      const coinAmount = usdAmount / price;
      document.getElementById('convertedAmount').value = coinAmount.toFixed(8);
      // Update symbol in label
      const selectedOption = document.getElementById('transactionCurrency').selectedOptions[0];
      if (selectedOption) {
        const match = selectedOption.textContent.match(/\(([^)]+)\)/);
        if (match && match[1]) {
          document.getElementById('selectedSymbol').textContent = match[1].toUpperCase();
        }
      }
    }

    // Event listeners for real-time conversion
    document.getElementById('transactionAmount').addEventListener('input', convertUsdToCoin);
    document.getElementById('transactionCurrency').addEventListener('change', convertUsdToCoin);

    // Fetch coins on page load
    window.onload = fetchCoins;
  </script>


    
    
    
    

  <div class="order-book-container">
    <div class="order-book-header">Order Book</div>
    <table class="order-book-table">
      <thead>
        <tr>
          <th>Price(BTC)</th>
          <th>Amount(ETH)</th>
          <th>Total(ETH)</th>
        </tr>
      </thead>
      <tbody id="sell-orders">
        <!-- Sell orders will be populated here -->
      </tbody>
    </table>
    
    <div class="order-book-divider">
      <span class="last-price">Last Price: <span id="last-price">0.020367</span></span>
      <span>
        <span id="usd-price">USD 148.65</span>
        <span id="price-change" class="price-change negative">-0.51%</span>
      </span>
    </div>
    
    <table class="order-book-table">
      <tbody id="buy-orders">
        <!-- Buy orders will be populated here -->
      </tbody>
    </table>
  </div>


<script>
  // Sample data
  const sellOrders = [
    { price: 0.022572, amount: 1.253415, total: 15.27648, depth: 75 },
    { price: 0.020371, amount: 1.205415, total: 15.25648, depth: 65 },
    { price: 0.023572, amount: 1.645415, total: 15.23648, depth: 85 },
    { price: 0.032378, amount: 1.206715, total: 15.25348, depth: 40 },
    { price: 0.022573, amount: 1.262415, total: 15.19648, depth: 55 }
  ];
  
  const buyOrders = [
    { price: 0.158373, amount: 1.209515, total: 15.23248, depth: 30 },
    { price: 0.020851, amount: 1.206245, total: 15.25458, depth: 45 },
    { price: 0.025375, amount: 1.205715, total: 15.65648, depth: 65 },
    { price: 0.020252, amount: 1.205485, total: 15.24548, depth: 50 },
    { price: 0.020373, amount: 1.205415, total: 15.25648, depth: 40 }
  ];
  
  // Format number to 6 decimal places if needed
  function formatNumber(num) {
    if (num < 0.0001) {
      return num.toFixed(6);
    } else if (num < 1) {
      return num.toFixed(5);
    } else {
      return num.toFixed(2);
    }
  }
  
  // Utility to flash‐highlight a cell when updated
  function flashCell(cell) {
    cell.classList.add('cell-update');
    setTimeout(() => cell.classList.remove('cell-update'), 400);
  }
  
  // Populate sell orders
  const sellOrdersEl = document.getElementById('sell-orders');
  sellOrders.forEach(order => {
    const row = document.createElement('tr');
    row.className = 'sell-row';
    row.innerHTML = `
      <td>${formatNumber(order.price)}</td>
      <td>${formatNumber(order.amount)}</td>
      <td>
        ${formatNumber(order.total)}
        <div class="order-depth sell-depth" style="width: ${order.depth}%"></div>
      </td>
    `;
    sellOrdersEl.appendChild(row);
  });
  
  // Populate buy orders
  const buyOrdersEl = document.getElementById('buy-orders');
  buyOrders.forEach(order => {
    const row = document.createElement('tr');
    row.className = 'buy-row';
    row.innerHTML = `
      <td>${formatNumber(order.price)}</td>
      <td>${formatNumber(order.amount)}</td>
      <td>
        ${formatNumber(order.total)}
        <div class="order-depth buy-depth" style="width: ${order.depth}%"></div>
      </td>
    `;
    buyOrdersEl.appendChild(row);
  });
  
  // Example API connection (simulated)
  function connectToOrderBookAPI() {
    console.log("Connecting to order book API...");
    // In a real implementation, connect to WebSocket here.
    // e.g.: const socket = new WebSocket('wss://api.exchange.com/orderbook');
    
    // Speed up updates to every 500ms
    setInterval(updateRandomOrder, 500);
  }
  
  function updateRandomOrder() {
    const isSell = Math.random() > 0.5;
    const orders = isSell ? sellOrders : buyOrders;
    const index = Math.floor(Math.random() * orders.length);
    
    // Slight variation
    orders[index].price  *= (1 + (Math.random() * 0.02 - 0.01));
    orders[index].amount *= (1 + (Math.random() * 0.04 - 0.02));
    orders[index].total   = orders[index].price * orders[index].amount * 10;
    
    // Update DOM
    const targetEl = isSell ? sellOrdersEl : buyOrdersEl;
    const row      = targetEl.querySelectorAll('tr')[index];
    const cells    = row.querySelectorAll('td');
    
    // Price cell
    cells[0].textContent = formatNumber(orders[index].price);
    flashCell(cells[0]);
    // Amount cell
    cells[1].textContent = formatNumber(orders[index].amount);
    flashCell(cells[1]);
    // Total cell & depth bar
    cells[2].childNodes[0].nodeValue = formatNumber(orders[index].total);
    const depthBar = row.querySelector('.order-depth');
    depthBar.style.width = orders[index].depth + '%';
    flashCell(cells[2]);
    
    // Occasionally update last price
    if (Math.random() > 0.7) {
      const lastPriceEl  = document.getElementById('last-price');
      const oldPrice     = parseFloat(lastPriceEl.textContent);
      const newPrice     = formatNumber(orders[index].price);
      lastPriceEl.textContent = newPrice;
      flashCell(lastPriceEl);
  
      const priceChangeEl = document.getElementById('price-change');
      const changePercent = ((newPrice - oldPrice) / oldPrice * 100).toFixed(2);
      priceChangeEl.textContent = `${changePercent}%`;
      priceChangeEl.className = `price-change ${changePercent >= 0 ? 'positive' : 'negative'}`;
    }
  }
  
  // Initialize
  connectToOrderBookAPI();
</script>

 
  
  
    
    
    
    
   



    <!-- TradingView Widget BEGIN -->
    <div class="tradingview-widget-container">
        <div class="tradingview-widget-container__widget"></div>
        <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-advanced-chart.js" async>
        {
        "autosize": true,
        "symbol": "BINANCE:BTCUSDT",
        "timezone": "Etc/UTC",
        "theme": "light",
        "style": "1",
        "locale": "en",
        "backgroundColor": "rgba(255, 255, 255, 1)",
        "gridColor": "rgba(255, 255, 255, 0.06)",
        "withdateranges": true,
        "range": "YTD",
        "hide_side_toolbar": false,
        "allow_symbol_change": true,
        "save_image": false,
        "calendar": false,
        "hide_volume": true,
        "support_host": "https://www.tradingview.com"
        }
        </script>
    </div>
    <!-- TradingView Widget END -->

    
    
    
    
  </div>
</div>


</section>

<!-- JavaScript for Enhanced Crypto Converter -->
<script>
  // List of top cryptocurrencies to include
  const topCoins = [
    'usd', 'bitcoin', 'ethereum', 'tether', 'binancecoin', 'solana', 'ripple', 'cardano',
    'avalanche-2', 'polkadot', 'dogecoin', 'tron', 'chainlink', 'polygon', 'shiba-inu',
    'litecoin', 'dai', 'uniswap', 'bitcoin-cash', 'stellar', 'monero', 'ethereum-classic', 
    'filecoin', 'cosmos', 'hedera-hashgraph', 'vechain', 'algorand', 'internet-computer',
    'flow', 'apecoin', 'eos', 'decentraland', 'the-sandbox', 'axie-infinity', 'aave', 
    'maker', 'compound', 'pancakeswap-token', 'near', 'fantom', 'frax', 'quant',
    'neo', 'bitcoin-sv', 'elrond-erd-2', 'chiliz', 'dash', 'kucoin-shares', 'nexo',
    'zcash', 'iota', 'theta-token', 'havven', 'decred', 'harmony', 'thorchain', 'waves',
    'basic-attention-token', 'enjincoin', 'gala', 'holo', 'amp-token', 'ecash', 'gnosis'
  ];

  // Coin display names (short names for display)
  const coinDisplayNames = {
    'usd': 'USD',
    'bitcoin': 'BTC',
    'ethereum': 'ETH',
    'tether': 'USDT',
    'binancecoin': 'BNB',
    'solana': 'SOL',
    'ripple': 'XRP',
    'cardano': 'ADA',
    'avalanche-2': 'AVAX',
    'polkadot': 'DOT',
    'dogecoin': 'DOGE',
    'tron': 'TRX',
    'chainlink': 'LINK',
    'polygon': 'MATIC',
    'shiba-inu': 'SHIB',
    'litecoin': 'LTC',
    'dai': 'DAI',
    'uniswap': 'UNI',
    'bitcoin-cash': 'BCH',
    'stellar': 'XLM',
    'monero': 'XMR',
    'ethereum-classic': 'ETC',
    'filecoin': 'FIL',
    'cosmos': 'ATOM',
    'hedera-hashgraph': 'HBAR',
    'vechain': 'VET',
    'algorand': 'ALGO',
    'internet-computer': 'ICP',
    'flow': 'FLOW',
    'apecoin': 'APE',
    'eos': 'EOS',
    'decentraland': 'MANA',
    'the-sandbox': 'SAND',
    'axie-infinity': 'AXS',
    'aave': 'AAVE',
    'maker': 'MKR',
    'compound': 'COMP',
    'pancakeswap-token': 'CAKE',
    'near': 'NEAR',
    'fantom': 'FTM',
    'frax': 'FRAX',
    'quant': 'QNT',
    'neo': 'NEO',
    'bitcoin-sv': 'BSV',
    'elrond-erd-2': 'EGLD',
    'chiliz': 'CHZ',
    'dash': 'DASH',
    'kucoin-shares': 'KCS',
    'nexo': 'NEXO',
    'zcash': 'ZEC',
    'iota': 'MIOTA',
    'theta-token': 'THETA',
    'havven': 'SNX',
    'decred': 'DCR',
    'harmony': 'ONE',
    'thorchain': 'RUNE',
    'waves': 'WAVES',
    'basic-attention-token': 'BAT',
    'enjincoin': 'ENJ',
    'gala': 'GALA',
    'holo': 'HOT',
    'amp-token': 'AMP',
    'ecash': 'XEC',
    'gnosis': 'GNO'
  };

  // Cache for cryptocurrency prices and information
  let cryptoCache = {
    timestamp: 0,
    data: {}
  };

  // Initialize the app when the document is loaded
  document.addEventListener('DOMContentLoaded', async function() {
    try {
      // Load cryptocurrency data
      await loadCryptoData();
      
      // Populate currency selectors
      populateCurrencySelectors();
      
      // Set default values
      document.getElementById('fromCurrency').value = 'usd';
      document.getElementById('toCurrency').value = 'bitcoin';
      
      // Update currency icons
      updateCurrencyIcon('fromCurrency', 'fromCurrencyIcon');
      updateCurrencyIcon('toCurrency', 'toCurrencyIcon');
      
      // Add change event listeners for currency selectors
      document.getElementById('fromCurrency').addEventListener('change', function() {
        updateCurrencyIcon('fromCurrency', 'fromCurrencyIcon');
        convertCurrency();
      });
      
      document.getElementById('toCurrency').addEventListener('change', function() {
        updateCurrencyIcon('toCurrency', 'toCurrencyIcon');
        convertCurrency();
      });
      
      // Add input event listener for real-time conversion
      document.getElementById('amount').addEventListener('input', convertCurrency);
      
      // Populate transaction currency selector
      populateTransactionCurrencySelector();
    } catch (error) {
      console.error('Error initializing app:', error);
      document.getElementById('result').innerHTML = '<p class="text-red-500">Error loading cryptocurrency data. Please refresh the page.</p>';
    }
  });

  // Function to load cryptocurrency data from CoinGecko API
  async function loadCryptoData() {
    const currentTime = Date.now();
    
    // If cache is valid (less than 1 minute old), use cached data
    if (currentTime - cryptoCache.timestamp < 60000 && Object.keys(cryptoCache.data).length > 0) {
      return cryptoCache.data;
    }
    
    try {
      // Build the query string with all coins
      const idsParam = topCoins.filter(coin => coin !== 'usd').join(',');
      const url = `https://api.coingecko.com/api/v3/coins/markets?vs_currency=usd&ids=${idsParam}&order=market_cap_desc&per_page=100&page=1&sparkline=false&price_change_percentage=24h`;
      
      const response = await fetch(url);
      const data = await response.json();
      
      // Process and cache the data
      const processedData = {};
      data.forEach(coin => {
        processedData[coin.id] = {
          id: coin.id,
          symbol: coin.symbol.toUpperCase(),
          name: coin.name,
          image: coin.image,
          price: coin.current_price,
          price_change_24h: coin.price_change_percentage_24h
        };
      });
      
      // Add USD manually
      processedData['usd'] = {
        id: 'usd',
        symbol: 'USD',
        name: 'US Dollar',
        image: 'https://media.istockphoto.com/id/1160777145/vector/us-circle-flag-icon-waving-american-symbol-vector-illustration.jpg?s=612x612&w=0&k=20&c=it5YEg0mYlnJDF-aQ98srEwTRC4fb0RQwTW9yJ0SCsc=',
        price: 1,
        price_change_24h: 0
      };
      
      // Update cache
      cryptoCache = {
        timestamp: currentTime,
        data: processedData
      };
      
      // Update last updated timestamp display
      const date = new Date();
      document.getElementById('lastUpdated').textContent = `Last updated: ${date.toLocaleTimeString()}`;
      
      return processedData;
    } catch (error) {
      console.error('Error fetching cryptocurrency data:', error);
      throw error;
    }
  }

  // Function to populate currency selectors
  function populateCurrencySelectors() {
    const fromSelect = document.getElementById('fromCurrency');
    const toSelect = document.getElementById('toCurrency');
    
    // Clear existing options
    fromSelect.innerHTML = '';
    toSelect.innerHTML = '';
    
    // Create and append options
    topCoins.forEach(coinId => {
      const coinData = cryptoCache.data[coinId];
      if (coinData) {
        const option = document.createElement('option');
        option.value = coinId;
        const displayName = coinDisplayNames[coinId] || coinData.symbol;
        option.textContent = `${displayName} - ${coinData.name}`;
        
        // Add option to both selectors
        fromSelect.appendChild(option.cloneNode(true));
        toSelect.appendChild(option);
      }
    });
  }

  // Function to populate transaction currency selector
  function populateTransactionCurrencySelector() {
    const transactionCurrencySelect = document.getElementById('transactionCurrency');
    
    // Clear existing options
    transactionCurrencySelect.innerHTML = '';
    
    // Create and append options
    topCoins.forEach(coinId => {
      const coinData = cryptoCache.data[coinId];
      if (coinData) {
        const option = document.createElement('option');
        option.value = coinId;
        const displayName = coinDisplayNames[coinId] || coinData.symbol;
        option.textContent = `${displayName} - ${coinData.name}`;
        transactionCurrencySelect.appendChild(option);
      }
    });
  }

  // Function to update currency icon
  function updateCurrencyIcon(selectId, iconId) {
    const select = document.getElementById(selectId);
    const iconContainer = document.getElementById(iconId);
    const selectedCurrency = select.value;
    
    // Clear existing icon
    iconContainer.innerHTML = '';
    
    // Get coin data
    const coinData = cryptoCache.data[selectedCurrency];
    
    if (coinData && coinData.image) {
      // Create and append icon image
      const icon = document.createElement('img');
      icon.src = coinData.image;
      icon.alt = coinData.name;
      icon.className = 'w-6 h-6';
      iconContainer.appendChild(icon);
    }
  }

  // Function to convert currency in real-time
  function convertCurrency() {
    const fromCurrency = document.getElementById('fromCurrency').value;
    const toCurrency = document.getElementById('toCurrency').value;
    const amount = parseFloat(document.getElementById('amount').value);
    
    if (isNaN(amount) || amount <= 0) {
      document.getElementById('result').innerHTML = '<p class="text-red-500">Please enter a valid amount.</p>';
      return;
    }
    
    const fromPrice = cryptoCache.data[fromCurrency].price;
    const toPrice = cryptoCache.data[toCurrency].price;
    
    const convertedAmount = (amount * fromPrice) / toPrice;
    
    document.getElementById('result').innerHTML = `
      <p class="text-lg font-semibold">${amount.toFixed(4)} ${cryptoCache.data[fromCurrency].symbol} = ${convertedAmount.toFixed(4)} ${cryptoCache.data[toCurrency].symbol}</p>
    `;
  }
</script>


    
    
    
    

   



    
    
    <!-- Market Chart -->
<section class="card p-6 mb-6">
  <h3 class="text-xl font-semibold mb-4">Market Overview</h3>
  <canvas id="marketChart" class="w-full" style="height: 200px; max-height: 200px;"></canvas>
</section>
<!-- Make sure to include the Chart.js library -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
  // Fetch Market Chart Data
  function fetchMarketChartData() {
    const ctx = document.getElementById('marketChart').getContext('2d');
    const labels = [];
    const dataPoints = [];
    
    fetch('https://api.coingecko.com/api/v3/coins/bitcoin/market_chart?vs_currency=usd&days=7')
      .then((response) => response.json())
      .then((data) => {
        data.prices.forEach((pricePoint) => {
          const date = new Date(pricePoint[0]);
          labels.push(`${date.getMonth() + 1}/${date.getDate()}`);
          dataPoints.push(pricePoint[1]);
        });
        
        new Chart(ctx, {
          type: 'line',
          data: {
            labels: labels,
            datasets: [{
              label: 'Bitcoin Price',
              data: dataPoints,
              borderColor: '#8b63f1',
              backgroundColor: 'rgba(99, 102, 241, 0.1)',
              borderWidth: 2,
              pointRadius: 0,
              tension: 0.4, // Smooth the line
              fill: true
            }]
          },
          options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
              y: { beginAtZero: false, display: false },
              x: { display: false }
            },
            plugins: {
              legend: { display: false },
              tooltip: { intersect: false }
            }
          }
        });
      })
      .catch((error) => {
        console.error('Error fetching market chart data:', error);
      });
  }

  // Call the function to fetch and render the market chart
  fetchMarketChartData();
</script>

    
    
    
    








<?php

// Ensure the user is logged in
if (!isset($_SESSION['user_email'])) {
    echo "<p>User is not logged in or email is not set in session.</p>";
    exit();
}
$userEmail = $_SESSION['user_email'];

// Database connection details
$servername = "localhost";
$username = "wptlgmnb_userp";
$password = "Qliox4ITygj6Vh4V";
$dbname = "wptlgmnb_dbp";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Fetch the latest 10 transactions from payments and crypto_withdrawal tables
$sql = "
    (SELECT id, wallet_address AS wallet, network, amount AS total_amount, email, name, created_at, transhash, status, 'payment' AS source 
    FROM payments WHERE email = '$userEmail')
    UNION ALL
    (SELECT id, wallet, network, total_amount, email, name, created_at, transhash, status, 'transaction' AS source 
    FROM crypto_withdrawal WHERE email = '$userEmail')
    ORDER BY created_at DESC LIMIT 10
";
$result = $conn->query($sql);

// Handle API rate limits by caching crypto prices
$cacheFile = 'crypto_prices.json';
$cacheDuration = 300; // 5 minutes
$cryptoPrices = [];

// Define the coins we need to track
$coinsToTrack = [
    'Bitcoin' => 'bitcoin',
    'Ethereum' => 'ethereum',
    'TRC20' => 'tether',
    'xrp' => 'ripple',
    'ERC20' => 'ethereum',
    'Dogecoin' => 'dogecoin',
    'Solana' => 'solana',
    'BNB' => 'binancecoin',
    'Pepe' => 'pepe'
];

// Cache management
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheDuration) {
    $cryptoPrices = json_decode(file_get_contents($cacheFile), true);
} else {
    $coinIds = implode(',', array_values(array_unique($coinsToTrack)));
    $apiUrl = "https://api.coingecko.com/api/v3/simple/price?ids={$coinIds}&vs_currencies=usd";
    $response = @file_get_contents($apiUrl);
    
    if ($response) {
        $cryptoPrices = json_decode($response, true);
        file_put_contents($cacheFile, $response);
    } else {
        $cryptoPrices = file_exists($cacheFile) ? json_decode(file_get_contents($cacheFile), true) : [];
    }
}

// Network logos
$networkLogos = [
    'Bitcoin' => 'https://primemarketspro.com/cryptos/bitcoin.png',
    'Ethereum' => 'https://primemarketspro.com/cryptos/eth.png',
    'TRC20' => 'https://primemarketspro.com/cryptos/usdt.png',
    'xrp' => 'https://primemarketspro.com/cryptos/xrp.png',
    'ERC20' => 'https://primemarketspro.com/cryptos/eth.png',
    'dogecoin' => 'https://primemarketspro.com/cryptos/doge.png',
    'solana' => 'https://primemarketspro.com/cryptos/sol.png',
    'bnb' => 'https://primemarketspro.com/cryptos/bnb.png',
    'pepe' => 'https://primemarketspro.com/cryptos/pepe.png'
];

// Network currency symbols
$networkSymbols = [
    'Bitcoin' => 'BTC',
    'Ethereum' => 'ETH',
    'TRC20' => 'USDT',
    'xrp' => 'XRP',
    'ERC20' => 'ETH',
    'Dogecoin' => 'DOGE',
    'Solana' => 'SOL',
    'BNB' => 'BNB',
    'Pepe' => 'PEPE'
];

// Check if there are results
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $transactionId = $row['id'];
        $wallet = htmlspecialchars($row['wallet']);
        $usdAmount = $row['total_amount'];
        $transhash = substr($row['transhash'], 0, 6) . '*****' . substr($row['transhash'], -5);
        $status = ucfirst($row['status']);
        $created_at = date('M d, Y', strtotime($row['created_at']));
        $source = $row['source'];
        $networkName = $row['network'];
        
        // Get crypto symbol
        $cryptoSymbol = $networkSymbols[$networkName] ?? strtoupper($networkName);
        
        // Determine arrow direction and color
        if ($source == 'payment') {
            $arrow = '↓';
            $arrowColor = 'green';
            $statusLabel = 'Received';
        } else {
            $arrow = '↑';
            $arrowColor = 'red';
            $statusLabel = 'Sent';
        }

        // Get logo URL
        $logoUrl = $networkLogos[$networkName] ?? $networkLogos['Bitcoin'];

        // Convert USD Amount to Crypto if price data is available
        $cryptoAmount = null;
        $coinGeckoId = $coinsToTrack[$networkName] ?? null;
        
        if ($coinGeckoId && isset($cryptoPrices[$coinGeckoId]['usd']) && is_numeric($usdAmount)) {
            $price = $cryptoPrices[$coinGeckoId]['usd'];
            if ($price > 0) {
                $cryptoAmount = $usdAmount / $price;
            }
        }

        // Format amounts
        $formattedUsdAmount = number_format($usdAmount, 2);
        $formattedCryptoAmount = $cryptoAmount !== null ? number_format($cryptoAmount, 8) : 'N/A';
        ?>

        <!-- Transaction Card -->
        <a href="detailed.php?id=<?php echo $transactionId; ?>" class="neumorphic-card p-4 flex flex-col items-start justify-between bg-white shadow-lg rounded-lg">
            <div class="flex items-center justify-between w-full relative z-10">
                <div class="flex items-center">
                    <img src="<?php echo $logoUrl; ?>" alt="<?php echo $networkName; ?>" class="w-8 h-8 mr-4 rounded-full">
                    <div>
                        <p class="font-bold text-lg" style="color: #3d4863;"><?php echo $networkName; ?></p>
                        <p class="text-gray-900 text-sm">
                            <?php 
                            if ($usdAmount == '0.00' || $usdAmount == '0') {
                                echo 'Unconfirmed';
                            } else {
                                echo '$' . $formattedUsdAmount;
                                if ($cryptoAmount !== null) {
                                    echo ' (' . $formattedCryptoAmount . ' ' . $cryptoSymbol . ')';
                                }
                            }
                            ?>
                        </p>
                    </div>
                </div>

                <!-- Transaction Status -->
                <div class="flex flex-col items-end text-right">
                    <p class="font-semibold" style="color: <?php echo $arrowColor; ?>">
                        <?php echo $arrow; ?> <?php echo $statusLabel; ?>
                    </p>
                    <p class="text-sm text-gray-500"><?php echo $created_at; ?></p>
                    <p class="text-sm text-gray-500"><?php echo $transhash; ?></p>
                </div>
            </div>
        </a>

        <?php
    }
} else {
    echo "<p>No recent transactions found.</p>";
}

$conn->close();
?>






<!-- See More Button -->
<div class="text-center mt-3">
    <a href="history.php" class="neumorphic-card p-3 bg-blue-500 text-white font-bold rounded-md hover:bg-blue-600">
        See More Transactions
    </a>
</div>


<div style=" margin-top: 16px;">



 <section class="container mx-auto p-6 w-full md:w-auto">
  <div class="grid grid-cols-1 md:grid-cols-3 gap-6 w-full">
    <!-- Customer Demographics Card -->
    <div class="col-span-2 bg-white rounded-lg shadow-md p-6 w-full">
      <div class="flex justify-between items-center mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Customer Demographics</h2>
      </div>
      <p class="text-sm text-gray-600 mb-4">Number of customers by country</p>

      <!-- Leaflet Map -->
      <div id="world-map" class="w-full bg-gray-100 mb-4 rounded"></div>

      <!-- Country Demographics List -->
      <div id="country-demographics" class="space-y-3 w-full">
        <!-- Content will be populated by JavaScript -->
      </div>
    </div>
    
    <!-- Quick Stats Card (partial code) -->
    <div class="bg-white rounded-lg shadow-md p-6 w-full">
      <h2 class="text-lg font-semibold text-gray-800 mb-4">Quick Stats</h2>
      <div class="mb-4">
        <div class="text-sm text-gray-600">Total Customers</div>
        <!-- Notice the id="counter" instead of static number -->
        <div id="counter" class="text-2xl font-bold text-gray-800">0</div>
      </div>
      <div class="mb-4">
        <div class="text-sm text-gray-600">New Customers</div>
        <div class="text-2xl font-bold text-green-600">+483</div>
      </div>
      <div>
        <div class="text-sm text-gray-600">Churn Rate</div>
        <div class="text-2xl font-bold text-red-600">57%</div>
      </div>
    </div>
  </div>
</section>

<!-- Place this script at the end of the body -->
<script>
  // This function animates a number from 'start' to 'end' over 'duration' milliseconds.
  function animateCounter(id, start, end, duration) {
    const element = document.getElementById(id);
    let startTimestamp = null;
    const range = end - start;
    
    function step(timestamp) {
      if (!startTimestamp) startTimestamp = timestamp;
      const progress = timestamp - startTimestamp;
      
      // Calculate the current value using a linear easing function.
      const current = Math.floor(start + (range * (progress / duration)));
      
      // Update the element innerText. (Using toLocaleString() for comma formatting)
      element.innerText = current.toLocaleString();
      
      if (progress < duration) {
        window.requestAnimationFrame(step);
      } else {
        // Ensure the final value is set
        element.innerText = end.toLocaleString();
      }
    }
    
    window.requestAnimationFrame(step);
  }
  
  // When the DOM is fully loaded, start the counter animation.
  document.addEventListener("DOMContentLoaded", function() {
    animateCounter("counter", 1, 378002, 2000); // Animate from 1 to 378,002 in 2000ms (2 seconds)
  });
</script>

 <script>
    // Retrieve country data passed from PHP.
    const customerData = <?php echo $jsonCountries; ?>;

    // Predefined coordinates for some countries (expand as needed).
    const countryCoordinates = {
      'us': [37.0902, -95.7129],
      'au': [-25.2744, 133.7751],
      'af': [33.9391, 67.7100],
      // Add more as needed.
    };

    // Filter out countries with 0 customers or invalid data.
    const filteredData = customerData.filter(country => {
      const customerCount = parseInt(country.customers, 10);
      if (!country.code || customerCount === 0 || isNaN(customerCount)) {
        console.warn("Excluding country:", country.name, "with customers:", country.customers);
        return false;
      }
      return true;
    });

    // Create and populate country demographics rows.
    function createCountryDemographics() {
      const container = document.getElementById('country-demographics');

      filteredData.forEach(country => {
        console.info("[INFO] Processing:", country);

        // Row container.
        const rowDiv = document.createElement('div');
        rowDiv.className = 'flex items-center country-row p-2 rounded';

        // Left section: flag and country name.
        const flagDiv = document.createElement('div');
        flagDiv.className = 'flex items-center mr-4 w-1/3';
        const flagElement = createFlagElement(country.code);
        flagDiv.appendChild(flagElement);
        const countryNameSpan = document.createElement('span');
        countryNameSpan.className = 'font-medium text-gray-700 ml-2';
        countryNameSpan.textContent = country.name;
        flagDiv.appendChild(countryNameSpan);

        // Middle section: progress bar using the normal percentage.
        const progressDiv = document.createElement('div');
        progressDiv.className = 'flex-grow mx-2';
        const progressBarBg = document.createElement('div');
        progressBarBg.className = 'bg-gray-200 rounded-full h-2';
        const progressBarFill = document.createElement('div');
        progressBarFill.className = 'bg-blue-600 h-2 rounded-full';
        progressBarFill.style.width = `${country.percentage}%`;
        progressBarBg.appendChild(progressBarFill);
        progressDiv.appendChild(progressBarBg);

        // Right section: show customer count multiplied by 100.
        const statsDiv = document.createElement('div');
        statsDiv.className = 'w-1/3 flex justify-end';
        const scaledCount = parseInt(country.customers, 10) * 100;
        statsDiv.innerHTML = `<span class="text-gray-700 font-medium">${scaledCount.toLocaleString()} Customers</span>`;

        // Assemble the row.
        rowDiv.appendChild(flagDiv);
        rowDiv.appendChild(progressDiv);
        rowDiv.appendChild(statsDiv);
        container.appendChild(rowDiv);
      });
    }

    // Create a flag element using flag-icon-css with round styling.
    function createFlagElement(countryCode) {
      const flagSpan = document.createElement('span');
      flagSpan.className = `flag-icon flag-icon-${countryCode} flag-icon-round`;
      flagSpan.style.fontSize = '32px';
      console.info(`Created flag element for ${countryCode}:`, flagSpan);
      return flagSpan;
    }

    // Initialize the Leaflet map.
    const map = L.map('world-map').setView([20, 0], 2);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
      attribution: '© OpenStreetMap contributors'
    }).addTo(map);

    // Add markers for each country.
    filteredData.forEach(country => {
      const coords = country.code in countryCoordinates ? countryCoordinates[country.code] : [0, 0];
      console.info("[INFO] Adding marker for:", country.name, "at coordinates:", coords);

      const marker = L.marker(coords).addTo(map);
      marker.bindPopup(`
        <div class="text-center">
          <span class="flag-icon flag-icon-${country.code} flag-icon-round" style="font-size: 2rem; display:inline-block; margin-bottom:8px;"></span>
          <br>
          <strong>${country.name}</strong><br>
          Customers: ${ (parseInt(country.customers, 10) * 100).toLocaleString() }
        </div>
      `);
    });

    // Build the country demographics list.
    createCountryDemographics();
  </script>
    
    



<!-- News Section -->
<section class="mb-12">
  <h3 class="text-xl font-semibold mb-4">Latest News</h3>
  <div>



    <!-- TradingView Widget BEGIN -->
    <div class="tradingview-widget-container" style="width: 100%; height: 550px;">
      <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-timeline.js" async>
      {
        "feedMode": "all_symbols",
        "isTransparent": true,
        "displayMode": "regular",
        "width": "100%",
        "height": 550,
        "colorTheme": "light",
        "locale": "en"
      }
      </script>
    </div>
    <!-- TradingView Widget END -->

  </div>
</section>
  </div>
  


<?php include './includes/footer.php'; ?>




  
  
  
  
</body>
</html>
