<?php
// Enable full error reporting (for development only, remove or disable in production)
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in, if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);

if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$balance        = $userDetails['balance'];
$btc            = $userDetails['btc'];
$eth            = $userDetails['eth'];
$usdt           = $userDetails['usdt'];
$xrp            = $userDetails['xrp'];
$extra          = $userDetails['extra'];
$update_time    = $userDetails['update_time'];
?>

<?php
// Start a session if not already started
session_start();

// Ensure the user is logged in
if (!isset($_SESSION['user_email'])) {
    header("Location: login.php");
    exit();
}
$userEmail = $_SESSION['user_email'];

// Check if transaction ID is provided
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: dashboard.php");
    exit();
}

$transactionId = intval($_GET['id']);

// Database connection details
$servername = "localhost";
$username = "wptlgmnb_userp";
$password = "Qliox4ITygj6Vh4V";
$dbname = "wptlgmnb_dbp";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Fetch transaction details using a UNION query.
// ORDER BY (source = 'transaction') DESC ensures that if a withdrawal record exists,
// it will be preferred over a payment record if both exist with the same ID.
$sql = "
    (SELECT id, wallet_address AS wallet, network, amount AS total_amount, email, name, created_at, transhash, status, NULL AS confirmation, 'payment' AS source 
    FROM payments WHERE id = $transactionId AND email = '$userEmail')
    UNION ALL
    (SELECT id, wallet, network, total_amount, email, name, created_at, transhash, status, confirmation, 'transaction' AS source 
    FROM crypto_withdrawal WHERE id = $transactionId AND email = '$userEmail')
    ORDER BY (source = 'transaction') DESC
    LIMIT 1
";
$result = $conn->query($sql);

// Standardized network logos array
$networkLogos = [
    'Bitcoin'   => 'https://primemarketspro.com/cryptos/bitcoin.png',
    'Ethereum'  => 'https://primemarketspro.com/cryptos/eth.png',
    'TRC20'     => 'https://primemarketspro.com/cryptos/usdt.png',
    'XRP'       => 'https://primemarketspro.com/cryptos/xrp.png',
    'ERC20'     => 'https://primemarketspro.com/cryptos/eth.png',
    'Dogecoin'  => 'https://primemarketspro.com/cryptos/doge.png',
    'Solana'    => 'https://primemarketspro.com/cryptos/sol.png',
    'BNB'       => 'https://primemarketspro.com/cryptos/bnb.png',
    'Pepe'      => 'https://primemarketspro.com/cryptos/pepe.png'
];

// Standardized network currency symbols array
$networkSymbols = [
    'Bitcoin'   => 'BTC',
    'Ethereum'  => 'ETH',
    'TRC20'     => 'USDT',
    'XRP'       => 'XRP',
    'ERC20'     => 'ETH',
    'Dogecoin'  => 'DOGE',
    'Solana'    => 'SOL',
    'BNB'       => 'BNB',
    'Pepe'      => 'PEPE'
];

// Helper function for case-insensitive lookup for logos
function getNetworkLogo($network, $logos) {
    foreach ($logos as $key => $url) {
        if (strcasecmp($key, $network) === 0) {
            return $url;
        }
    }
    return $logos['Bitcoin'];
}

// Helper function for case-insensitive lookup for symbols
function getNetworkSymbol($network, $symbols) {
    foreach ($symbols as $key => $symbol) {
        if (strcasecmp($key, $network) === 0) {
            return $symbol;
        }
    }
    return strtoupper($network);
}

// Handle API rate limits by caching crypto prices
$cacheFile = 'crypto_prices.json';
$cacheDuration = 300; // 5 minutes in seconds
$cryptoPrices = [];

// Standardized coins to track array with CoinGecko IDs
$coinsToTrack = [
    'Bitcoin'   => 'bitcoin',
    'Ethereum'  => 'ethereum',
    'TRC20'     => 'tether',
    'XRP'       => 'ripple',
    'ERC20'     => 'ethereum',
    'Dogecoin'  => 'dogecoin',
    'Solana'    => 'solana',
    'BNB'       => 'binancecoin',
    'Pepe'      => 'pepe'
];

if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheDuration) {
    // Use cached data
    $cryptoPrices = json_decode(file_get_contents($cacheFile), true);
} else {
    // Get list of coin IDs to fetch
    $coinIds = implode(',', array_values(array_unique($coinsToTrack)));
    
    // Fetch fresh data from CoinGecko API
    $apiUrl = "https://api.coingecko.com/api/v3/simple/price?ids={$coinIds}&vs_currencies=usd";
    $response = @file_get_contents($apiUrl);
    
    if ($response) {
        $cryptoPrices = json_decode($response, true);
        // Cache the new data
        file_put_contents($cacheFile, $response);
    } else {
        // If API call fails, use empty array or try to load cached data even if old
        $cryptoPrices = file_exists($cacheFile) ? json_decode(file_get_contents($cacheFile), true) : [];
    }
}

// Check if transaction exists and belongs to the user
if ($result->num_rows == 0) {
    header("Location: dashboard.php");
    exit();
}

$transaction = $result->fetch_assoc();
$wallet = htmlspecialchars($transaction['wallet']);

// Get the network from the transaction
$network = $transaction['network'];

// Normalize the network value using canonical mapping.
// This mapping ensures any form like "sol", "SOL", or "solana" becomes "Solana" and similarly for BNB.
$canonicalNetworks = [
    'bitcoin'      => 'Bitcoin',
    'btc'          => 'Bitcoin',
    'ethereum'     => 'Ethereum',
    'eth'          => 'Ethereum',
    'trc20'        => 'TRC20',
    'xrp'          => 'XRP',
    'erc20'        => 'ERC20',
    'doge'         => 'Dogecoin',
    'dogecoin'     => 'Dogecoin',
    'sol'          => 'Solana',
    'solana'       => 'Solana',
    'bnb'          => 'BNB',
    'binancecoin'  => 'BNB',
    'pepe'         => 'Pepe'
];
$networkLower = strtolower($network);
if (isset($canonicalNetworks[$networkLower])) {
    $network = $canonicalNetworks[$networkLower];
}

$amount       = $transaction['total_amount'];
$created_at   = date('M d, Y h:i:s A', strtotime($transaction['created_at']));
$transhash    = $transaction['transhash'];
$status       = ucfirst($transaction['status']);
$source       = $transaction['source'];
$name         = htmlspecialchars($transaction['name']);
$confirmation = $transaction['confirmation'];

// Get crypto symbol using helper function (now using the normalized $network)
$cryptoSymbol = getNetworkSymbol($network, $networkSymbols);

// Determine transaction type
$transactionType = ($source == 'payment') ? 'Received' : 'Sent';
$arrowSymbol     = ($source == 'payment') ? '<i class="fas fa-arrow-down text-green-600"></i>' : '<i class="fas fa-arrow-up text-red-600"></i>';

// Get logo URL using helper function
$logoUrl = getNetworkLogo($network, $networkLogos);

// Convert USD Amount to Crypto if we have price data
$cryptoAmount = null;
$coinGeckoId = null;
foreach ($coinsToTrack as $key => $id) {
    if (strcasecmp($key, $network) === 0) {
        $coinGeckoId = $id;
        break;
    }
}
if ($coinGeckoId && isset($cryptoPrices[$coinGeckoId]['usd']) && is_numeric($amount)) {
    $price = $cryptoPrices[$coinGeckoId]['usd'];
    if ($price > 0) { // Avoid division by zero
        $cryptoAmount = $amount / $price;
    }
}

// Format amounts
$formattedUsdAmount    = number_format($amount, 5);
$formattedCryptoAmount = $cryptoAmount !== null ? number_format($cryptoAmount, 8) : 'N/A';

// Get blockchain explorer link based on network
$explorerLink = '#';
switch (strtolower($network)) {
    case 'bitcoin':
        $explorerLink = "./blockchain_details.php?hash=" . $transhash;
        break;
    case 'ethereum':
    case 'erc20':
        $explorerLink = "./blockchain_details.php?hash=" . $transhash;
        break;
    case 'trc20':
        $explorerLink = "./blockchain_details.php?hash=" . $transhash;
        break;
    case 'xrp':
        $explorerLink = "./blockchain_details.php?hash=" . $transhash;
        break;
    default:
        $explorerLink = "./blockchain_details.php?hash=" . $transhash;
        break;
}

// Calculate the timestamp for block info
$timestamp = strtotime($transaction['created_at']);
$daysAgo   = floor((time() - $timestamp) / (60 * 60 * 24));

// Close the database connection
$conn->close();
?>

<?php include './includes/header.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transaction Details</title>
    <!-- Font Awesome CDN for icons and spinner -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-yHfZG0pYNe4YCLdLUa71rjgjJ59dF8gF2KIC6R9y9iXETbdF+8EBM8IqjCUlkt8i+gIG2OMAcgN+9fW80KkO1w==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- Tailwind CSS -->
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <!-- Alpine.js -->
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <style>
        /* Custom CSS for spinner and preventing horizontal scrolling */
        body {
            overflow-x: hidden;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .spinner {
            width: 16px;
            height: 16px;
            animation: spin 1s linear infinite;
            fill: #007bff; /* Blue color */
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Header -->
    <?php include './includes/nav.php'; ?>
    <!-- Main Content -->
    <main class="container mx-auto px-4 py-8">
        <!-- Transaction Header -->
        <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
            <div class="flex items-center justify-between mb-4">
                <h1 class="text-2xl font-semibold text-gray-800">Transaction Details</h1>
                <div class="flex space-x-2">
                    <a href="dashboard.php" class="bg-blue-100 text-blue-600 px-3 py-1 rounded-md hover:bg-blue-200">
                        <i class="fas fa-chevron-left mr-1"></i> Back
                    </a>
                </div>
            </div>
            <!-- Red alert notification button for crypto_withdrawal transactions -->
            <?php if ($source == 'transaction' && strtolower($status) !== 'confirmed'): ?>
            <div class="container mx-auto px-4 py-4">
                <button id="accelerateBtn" class="bg-red-600 text-white px-4 py-2 rounded-lg w-full">
                    Pending confirmation (<?php echo $confirmation; ?>/6) - Click here to accelerate
                </button>
                <!-- Hidden progress bar container -->
                <div id="progressContainer" class="flex justify-center my-4" style="display: none;">
                    <div class="relative">
                        <!-- Progress circle would be here if implemented -->
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <!-- Transaction Info -->
            <div class="space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="p-4 bg-gray-50 rounded-lg">
                        <label class="text-gray-500 text-sm">Transaction Hash</label>
                        <div class="flex items-center justify-between mt-1">
                            <span class="font-mono text-blue-600"><?php echo substr($transhash, 0, 20) . '...' . substr($transhash, -7); ?></span>
                            <button class="text-gray-400 hover:text-blue-600 copy-btn" data-text="<?php echo $transhash; ?>">
                                <i class="far fa-copy"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="p-4 bg-gray-50 rounded-lg">
                        <label class="text-gray-500 text-sm">Status</label>
                        <div class="flex items-center mt-1">
                            <?php if (empty($status)): ?>
                                <span class="text-gray-600 bg-gray-100 px-3 py-1 rounded-full text-sm flex items-center">
                                    <i class="fas fa-exclamation-circle mr-1"></i> Unconfirmed
                                </span>
                            <?php elseif (strtolower($status) === 'confirmed'): ?>
                                <span class="text-green-600 bg-green-100 px-3 py-1 rounded-full text-sm flex items-center">
                                    <i class="fas fa-check-circle mr-1"></i> Confirmed
                                </span>
                            <?php elseif (strtolower($status) === 'pending'): ?>
                                <span class="text-yellow-600 bg-yellow-100 px-3 py-1 rounded-full text-sm flex items-center">
                                    <i class="fas fa-clock mr-1"></i> Pending
                                </span>
                            <?php else: ?>
                                <span class="text-red-600 bg-red-100 px-3 py-1 rounded-full text-sm flex items-center">
                                    <i class="fas fa-times-circle mr-1"></i> <?php echo htmlspecialchars(ucfirst($status), ENT_QUOTES, 'UTF-8'); ?>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <!-- Transaction Details -->
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div class="p-4 bg-gray-50 rounded-lg">
                        <label class="text-gray-500 text-sm">From</label>
                        <script>
                            // Randomly select one wallet type to display
                            document.addEventListener("DOMContentLoaded", function() {
                                const choices = document.querySelectorAll('.choice');
                                const randomIndex = Math.floor(Math.random() * choices.length);
                                choices.forEach((element, index) => {
                                    if(index !== randomIndex) {
                                        element.style.display = 'none';
                                    }
                                });
                            });
                        </script>
                        <div class="flex items-center justify-between mt-1">
                            <span class="choice font-mono text-blue-600">DeFi Wallet</span>
                            <span class="choice font-mono text-blue-600">SegWit Wallet</span>
                            <span class="text-gray-400">
                                <i class="fas fa-wallet"></i>
                            </span>
                        </div>
                    </div>
                   
                    
                    
                    <?php if ($source == 'payment'): ?>
                        <!-- For received payment -->
                        <div class="p-4 bg-gray-50 rounded-lg">
                            <label class="text-gray-500 text-sm">To</label>
                            <div class="flex items-center justify-between mt-1">
                                <span class="font-mono text-blue-600"><?php echo substr($wallet, 0, 16) . '...' . substr($wallet, -4); ?></span>
                                <button class="text-gray-400 hover:text-blue-600 copy-btn" data-text="<?php echo $wallet; ?>">
                                    <i class="far fa-copy"></i>
                                </button>
                            </div>
                        </div>
                    <?php else: ?>
                        <!-- For sent transaction -->
       

<!-- Red arrow pointing RIGHT -->
<div class="flex items-center justify-center text-red-500">
    <i class="fas fa-arrow-right text-xl"></i>
</div>
               <!-- Green arrow pointing LEFT -->
<div class="flex items-center justify-center text-green-500">
    <i class="fas fa-arrow-left text-xl"></i>
</div>
                        <div class="p-4 bg-gray-50 rounded-lg">
                            <label class="text-gray-500 text-sm">To</label>
                            <div class="flex items-center justify-between mt-1">
                                <span class="font-mono text-blue-600"><?php echo substr($wallet, 0, 10) . '...' . substr($wallet, -4); ?></span>
                                <button class="text-gray-400 hover:text-blue-600 copy-btn" data-text="<?php echo $wallet; ?>">
                                    <i class="far fa-copy"></i>
                                </button>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <!-- Value and Fees -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="p-4 bg-gray-50 rounded-lg">
                        <label class="text-gray-500 text-sm">Value</label>
                        <div class="mt-1">
                            <span class="font-semibold">
                                <?php 
                                    if ($cryptoAmount !== null) {
                                        if ((float)$cryptoAmount == 0) {
                                            // If crypto conversion yields zero, show only the spinner
                                            echo '<svg class="spinner" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M304 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm0 416a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM48 304a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm464-48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM142.9 437A48 48 0 1 0 75 369.1 48 48 0 1 0 142.9 437zm0-294.2A48 48 0 1 0 75 75a48 48 0 1 0 67.9 67.9zM369.1 437A48 48 0 1 0 437 369.1 48 48 0 1 0 369.1 437z"/></svg>';
                                        } else {
                                            echo $formattedCryptoAmount . ' ' . $cryptoSymbol;
                                        }
                                    } else {
                                        echo 'Amount in USD '; 
                                    }
                                ?>
                            </span>
                            <span class="text-gray-500 ml-2">
                                (
                                <?php 
                                    if ((float)$formattedUsdAmount == 0) {
                                        echo '<svg class="spinner" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M304 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm0 416a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM48 304a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm464-48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM142.9 437A48 48 0 1 0 75 369.1 48 48 0 1 0 142.9 437zm0-294.2A48 48 0 1 0 75 75a48 48 0 1 0 67.9 67.9zM369.1 437A48 48 0 1 0 437 369.1 48 48 0 1 0 369.1 437z"/></svg>';
                                    } else {
                                        echo '$' . $formattedUsdAmount;
                                    }
                                ?>
                                )
                            </span>
                        </div>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-lg">
                        <label class="text-gray-500 text-sm">Transaction Type</label>
                        <div class="mt-1">
                            <span class="font-semibold"><?php echo $arrowSymbol; ?> <?php echo $transactionType; ?></span>
                            <span class="text-gray-500 ml-2">(<?php echo $cryptoAmount; ?> <?php echo $cryptoSymbol; ?> on <?php echo $network; ?> Network)</span>
                        </div>
                    </div>
                </div>
                <!-- Additional Info Cards -->
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div class="bg-white p-6 rounded-lg shadow-sm">
                        <h3 class="text-lg font-semibold mb-4">Transaction Info</h3>
                        <dl class="space-y-3">
                            <div>
                                <dt class="text-gray-500 text-sm">Date & Time</dt>
                                <dd><?php echo $created_at; ?></dd>
                            </div>
                            <div>
                                <dt class="text-gray-500 text-sm">Transaction ID</dt>
                                <dd class="font-mono text-blue-600">#<?php echo $transactionId; ?></dd>
                            </div>
                            <?php if (!empty($name)): ?>
                            <div>
                                <dt class="text-gray-500 text-sm">Description</dt>
                                <dd><?php echo $name; ?></dd>
                            </div>
                            <?php endif; ?>
                        </dl>
                    </div>
                    <div class="bg-white p-6 rounded-lg shadow-sm">
                        <h3 class="text-lg font-semibold mb-4">Blockchain Info</h3>
                        <dl class="space-y-3">
                            <div>
                                <dt class="text-gray-500 text-sm">Network</dt>
                                <dd><?php echo $network; ?></dd>
                            </div>
                            <div>
                                <dt class="text-gray-500 text-sm">Timestamp</dt>
                                <dd><?php echo $daysAgo; ?> days ago (<?php echo date('M d, Y h:i:s A', $timestamp); ?> UTC)</dd>
                            </div>
                            <div>
                                <dt class="text-gray-500 text-sm">Explorer</dt>
                                <dd><a href="<?php echo $explorerLink; ?>" target="_blank" class="text-blue-600 hover:underline">View on Explorer</a></dd>
                            </div>
                        </dl>
                    </div>
                    <div class="bg-white p-6 rounded-lg shadow-sm">
                        <h3 class="text-lg font-semibold mb-4">Token Information</h3>
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 rounded-full overflow-hidden">
                                <img src="<?php echo $logoUrl; ?>" alt="<?php echo $network; ?>" class="w-full h-full object-cover">
                            </div>
                            <div>
                                <div class="font-semibold"><?php echo $cryptoSymbol; ?></div>
                                <div class="text-sm text-gray-500"><?php echo $network; ?></div>
                            </div>
                        </div>
                        <div class="mt-4">
                            <button onclick="window.print()" class="w-full bg-blue-100 text-blue-600 px-4 py-2 rounded-md hover:bg-blue-200 flex items-center justify-center">
                                <i class="fas fa-print mr-2"></i> Print Receipt
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <script>
        // Clipboard functionality
        document.querySelectorAll('.copy-btn').forEach(button => {
            button.addEventListener('click', (e) => {
                const text = e.currentTarget.getAttribute('data-text');
                navigator.clipboard.writeText(text);
                // Visual feedback
                const originalIcon = e.currentTarget.innerHTML;
                e.currentTarget.innerHTML = '<i class="fas fa-check"></i>';
                e.currentTarget.classList.add('text-green-600');
                // Reset after 2 seconds
                setTimeout(() => {
                    e.currentTarget.innerHTML = originalIcon;
                    e.currentTarget.classList.remove('text-green-600');
                }, 2000);
            });
        });
        // SweetAlert and Progress Bar functionality for accelerating transaction fee
        var transactionStatus = "<?php echo strtolower($status); ?>";
        document.getElementById('accelerateBtn')?.addEventListener('click', function() {
            Swal.fire({
                title: 'Increase Network Fee',
                text: 'Are you sure you want to increase network fee?',
                icon: 'info',
                showCancelButton: true,
                confirmButtonText: 'Yes, increase fee',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Redirect to pay.php with the transaction ID in the URL
                    window.location.href = 'pay.php?id=<?php echo $transactionId; ?>';
                } else {
                    // On cancellation, show and update the round progress bar based on status
                    document.getElementById('progressContainer').style.display = 'flex';
                    function updateProgressBar(percentage, text) {
                        const circle = document.getElementById('progressCircle');
                        const circumference = 56.55;
                        const offset = circumference * (1 - (percentage / 100));
                        circle.style.strokeDashoffset = offset;
                        document.getElementById('progressText').textContent = text;
                    }
                    if (transactionStatus === 'pending') {
                        updateProgressBar(33, '1/3');
                    } else if (transactionStatus === 'confirming') {
                        updateProgressBar(16.67, '1/6');
                        setTimeout(function() {
                            updateProgressBar(66.67, '4/6');
                        }, 2000);
                    }
                }
            });
        });
    </script>
    
    <?php include './includes/footer.php'; ?>
</body>
</html>
