<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if transaction data is set
if (!isset($_SESSION['transaction_data'])) {
    header("Location: doges.php");
    exit();
}

$transaction_data = $_SESSION['transaction_data'];

// Use the DOGE amount from session, or default to 0 if not set
$doge = $transaction_data['doge'] ?? 0;

// Database connection settings
$host   = "localhost";
$user   = "wptlgmnb_userp";
$pass   = "Qliox4ITygj6Vh4V"; // Replace with your actual database password
$dbname = "wptlgmnb_dbp";

// Create connection
$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    $_SESSION['error'] = "Database connection failed. Please try again later.";
    header("Location: doges.php");
    exit();
}

// Check user Dogecoin balance
$stmt = $conn->prepare("SELECT doge FROM users WHERE id = ?");
$stmt->bind_param("i", $transaction_data['user_id']);
$stmt->execute();
$stmt->bind_result($current_balance);
$stmt->fetch();
$stmt->close();

if ($current_balance === null) {
    $_SESSION['error'] = "User not found.";
    header("Location: doges.php");
    exit();
}

// Log current values for debugging
error_log("Current Balance: " . $current_balance);
error_log("DOGE Amount from Session: " . $doge);

// Convert values to strings for bcsub calculation
$current_balance_str = (string)$current_balance;
$doge_str           = (string)$doge;

// Calculate new balance using bcsub with 8 decimals precision
$new_balance = bcsub($current_balance_str, $doge_str, 8);
if ($new_balance === false || $new_balance === null) {
    $_SESSION['error'] = "Error calculating new balance.";
    header("Location: doges.php");
    exit();
}

// Ensure sufficient balance exists
if (bccomp($new_balance, '0', 8) < 0) {
    $_SESSION['error'] = "Insufficient balance. Transaction cannot be processed.";
    header("Location: doges.php");
    exit();
}

// Deduct balance from the user's account
$stmt = $conn->prepare("UPDATE users SET doge = ? WHERE id = ?");
$stmt->bind_param("si", $new_balance, $transaction_data['user_id']);
$stmt->execute();
$stmt->close();

// Generate a unique transaction hash
$transhash = hash('sha256', $transaction_data['email'] . microtime(true) . random_int(1000, 9999));

// Insert the transaction record
// Note: We use the column 'btc' here because your table does not have a column named 'doge'.
// If you want a dedicated doge column, update your database schema accordingly.
$stmt = $conn->prepare("INSERT INTO crypto_withdrawal
    (user_id, email, network, wallet, btc, ipaddress, name, total_amount, fee, transhash)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("isssdssdds",
    $transaction_data['user_id'],
    $transaction_data['email'],
    $transaction_data['network'],
    $transaction_data['wallet'],
    $doge, // Doge amount stored in the 'btc' column
    $transaction_data['ipaddress'],
    $transaction_data['name'],
    $transaction_data['total_amount'], // This value may include fees
    $transaction_data['fee'],
    $transhash
);

if (!$stmt->execute()) {
    $_SESSION['error'] = "Transaction failed. Please try again.";
    header("Location: doges.php");
    exit();
}
$stmt->close();

// Example: Fetch real-time DOGE price (replace with an actual API call if available)
$doge_price = 0.07; // Example DOGE price in USD
$usd_amount = $doge * $doge_price;
$usd_value  = "$" . number_format($usd_amount, 2);

// Send email confirmation using PHPMailer
require '../vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$mail = new PHPMailer(true);
try {
    $mail->isSMTP();
    $mail->Host       = 'mail.primemarketspro.com';
    $mail->SMTPAuth   = true;
    $mail->Username   = 'noreply@primemarketspro.com';
    $mail->Password   = 'Trexn@504';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port       = 587;

    $mail->setFrom('noreply@primemarketspro.com', 'primemarketspro.com Wallet');
    $mail->addAddress($transaction_data['email'], $transaction_data['name']);
    
    $mail->isHTML(true);
    $mail->Subject = 'Transaction Confirmation - primemarketspro.com Wallet';
    $mail->Body    = "<html><body>
        <p>Dear " . htmlspecialchars($transaction_data['name']) . ",</p>
        <p>Your transaction was successful. Details:</p>
        <ul>
            <li><strong>Transaction ID:</strong> " . $transhash . "</li>
            <li><strong>Network:</strong> " . htmlspecialchars($transaction_data['network']) . "</li>
            <li><strong>Wallet:</strong> " . htmlspecialchars($transaction_data['wallet']) . "</li>
            <li><strong>Amount:</strong> " . $doge . " DOGE</li>
            <li><strong>USD Equivalent:</strong> " . $usd_value . "</li>
        </ul>
        <p>Thank you for using primemarketspro.com Wallet.</p>
        <p>&copy; " . date('Y') . " primemarketspro.com Wallet. All rights reserved.</p>
        </body></html>";

    $mail->AltBody = "Transaction Confirmation - primemarketspro.com Wallet\n\nDear " . $transaction_data['name'] . ",\n\nYour transaction was successful. Details:\n" .
                       "- Transaction ID: " . $transhash . "\n" .
                       "- Network: " . $transaction_data['network'] . "\n" .
                       "- Wallet: " . $transaction_data['wallet'] . "\n" .
                       "- Amount: " . $doge . " DOGE\n" .
                       "- USD Equivalent: " . $usd_value . "\n\n" .
                       "Thank you for using primemarketspro.com Wallet.";

    $mail->send();
} catch (Exception $e) {
    $_SESSION['error'] = "Email could not be sent: " . $mail->ErrorInfo;
    header("Location: doges.php");
    exit();
}

// Close the database connection
$conn->close();

// Redirect to success page
header("Location: successe.php");
exit();
?>
