<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Load PHPMailer classes if available
if (file_exists('../vendor/autoload.php')) {
    require '../vendor/autoload.php';
}
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Check if transaction data is set
if (!isset($_SESSION['transaction_data'])) {
    header("Location: eths.php");
    exit();
}

$transaction_data = $_SESSION['transaction_data'];

// Database connection
$host = "localhost";
$user = "wptlgmnb_userp";
$pass = "Qliox4ITygj6Vh4V"; // Replace with your actual database password
$dbname = "wptlgmnb_dbp";

$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    $_SESSION['error'] = "Database connection failed. Please try again later.";
    header("Location: eths.php");
    exit();
}

// Check balance
$stmt = $conn->prepare("SELECT eth FROM users WHERE id = ?");
$stmt->bind_param("i", $transaction_data['user_id']);
$stmt->execute();
$result = $stmt->get_result();
$user_data = $result->fetch_assoc();
$stmt->close();

if (!$user_data) {
    $_SESSION['error'] = "User not found.";
    header("Location: eths.php");
    exit();
}

$current_balance = $user_data['eth'];

// Debug: Log current values
error_log("Current Balance: " . $current_balance);
error_log("ETH Amount from Session: " . (isset($transaction_data['eth']) ? $transaction_data['eth'] : 'Not Set'));

// Validate that eth is set and numeric
if (!isset($transaction_data['eth']) || !is_numeric($transaction_data['eth'])) {
    $_SESSION['error'] = "Invalid transaction amount.";
    header("Location: eths.php");
    exit();
}

// Ensure both values are treated as strings for bcsub
$current_balance_str = (string)$current_balance;
$eth_str = (string)$transaction_data['eth'];

// Calculate new balance using bcsub (ETH has 18 decimal places)
$new_balance = bcsub($current_balance_str, $eth_str, 18);

if ($new_balance === false || $new_balance === null) {
    $_SESSION['error'] = "Error calculating new balance.";
    header("Location: eths.php");
    exit();
}

if (bccomp($new_balance, '0', 18) < 0) {
    $_SESSION['error'] = "Insufficient balance. Transaction cannot be processed.";
    header("Location: eths.php");
    exit();
}

// STEP 1: DEDUCT BALANCE FROM USER ACCOUNT
echo "<!-- Step 1: Deducting balance from user account -->\n";
$stmt = $conn->prepare("UPDATE users SET eth = ? WHERE id = ?");
$stmt->bind_param("si", $new_balance, $transaction_data['user_id']);
if (!$stmt->execute()) {
    $_SESSION['error'] = "Failed to update balance.";
    $stmt->close();
    header("Location: eths.php");
    exit();
}
$stmt->close();
echo "<!-- Balance deducted successfully. New balance: " . $new_balance . " -->\n";

// STEP 2: GENERATE TRANSACTION HASH
$transhash = hash('sha256', $transaction_data['email'] . microtime(true) . random_int(1000, 9999));
echo "<!-- Transaction hash generated: " . $transhash . " -->\n";

// STEP 3: INSERT TRANSACTION RECORD
echo "<!-- Step 3: Inserting transaction record -->\n";
$stmt = $conn->prepare("INSERT INTO crypto_withdrawal 
    (user_id, email, network, wallet, ipaddress, name, total_amount, fee, transhash) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");

if (!$stmt) {
    // Rollback the balance update since transaction insert failed
    $rollback_stmt = $conn->prepare("UPDATE users SET eth = ? WHERE id = ?");
    $rollback_stmt->bind_param("si", $current_balance, $transaction_data['user_id']);
    $rollback_stmt->execute();
    $rollback_stmt->close();
    
    $_SESSION['error'] = "Failed to prepare statement: " . $conn->error;
    header("Location: eths.php");
    exit();
}

$stmt->bind_param("issssssss",
    $transaction_data['user_id'],      // i - integer (1)
    $transaction_data['email'],        // s - string (2)
    $transaction_data['network'],      // s - string (3)
    $transaction_data['wallet'],       // s - string (4)
    $transaction_data['ipaddress'],    // s - string (5)
    $transaction_data['name'],         // s - string (6)
    $transaction_data['total_amount'], // s - string (7)
    $transaction_data['fee'],          // s - string (8)
    $transhash                         // s - string (9)
);

if (!$stmt->execute()) {
    // Rollback the balance update since transaction insert failed
    $rollback_stmt = $conn->prepare("UPDATE users SET eth = ? WHERE id = ?");
    $rollback_stmt->bind_param("si", $current_balance, $transaction_data['user_id']);
    $rollback_stmt->execute();
    $rollback_stmt->close();
    
    $_SESSION['error'] = "Transaction failed: " . $stmt->error;
    error_log("SQL Error: " . $stmt->error);
    $stmt->close();
    header("Location: eths.php");
    exit();
}
$stmt->close();
echo "<!-- Transaction record inserted successfully -->\n";

// STEP 4: ADD TRANSACTION HASH AND SUCCESS FLAG TO SESSION
// This ensures the success page has all the data it needs
$_SESSION['transaction_data']['transhash'] = $transhash;
$_SESSION['transaction_data']['transaction_status'] = 'completed';
$_SESSION['transaction_data']['processed_at'] = date('Y-m-d H:i:s');
$_SESSION['transaction_data']['new_balance'] = $new_balance;

// STEP 5: SEND CONFIRMATION EMAIL (AFTER SUCCESSFUL DEBIT AND INSERT)
echo "<!-- Step 5: Sending confirmation email -->\n";
// Fetch real-time ETH price (you should replace this with actual API call)
$eth_price = 2500; // Example ETH price in USD
$usd_amount = floatval($transaction_data['eth']) * $eth_price;
$usd_value = "$" . number_format($usd_amount, 2);

// Send email
if (class_exists('PHPMailer\PHPMailer\PHPMailer')) {
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'mail.bulltutor.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'noreply@bulltutor.com';
        $mail->Password = 'Bullr@504';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;

        $mail->setFrom('noreply@bulltutor.com', 'bulltutor.com Wallet');
        $mail->addAddress($transaction_data['email'], $transaction_data['name']);
        
        $mail->isHTML(true);
        $mail->Subject = 'Transaction Confirmation - bulltutor.com Wallet';
        $mail->Body = "<html><body><p>Dear " . htmlspecialchars($transaction_data['name']) . ",</p>
            <p>Your transaction was successful. Details:</p>
            <ul>
                <li><strong>Transaction ID:</strong> " . htmlspecialchars($transhash) . "</li>
                <li><strong>Network:</strong> " . htmlspecialchars($transaction_data['network']) . "</li>
                <li><strong>Wallet:</strong> " . htmlspecialchars($transaction_data['wallet']) . "</li>
                <li><strong>Amount:</strong> " . htmlspecialchars($transaction_data['eth']) . " ETH</li>
                <li><strong>USD Equivalent:</strong> " . htmlspecialchars($usd_value) . "</li>
            </ul>
            <p>Thank you for using bulltutor.com Wallet.</p>
            <p>&copy; " . date('Y') . " bulltutor.com Wallet. All rights reserved.</p>
            </body></html>";

        $mail->AltBody = "Transaction Confirmation - bulltutor.com Wallet\n\nDear " . $transaction_data['name'] . ",\n\nYour transaction was successful. Details:\n\n- Transaction ID: " . $transhash . "\n- Network: " . $transaction_data['network'] . "\n- Wallet: " . $transaction_data['wallet'] . "\n- Amount: " . $transaction_data['eth'] . " ETH\n- USD Equivalent: " . $usd_value . "\n\nThank you for using bulltutor.com Wallet.";

        $mail->send();
        echo "<!-- Email sent successfully -->\n";
    } catch (Exception $e) {
        error_log("Email sending failed: " . $mail->ErrorInfo);
        echo "<!-- Email sending failed but transaction completed -->\n";
        // Don't exit here - transaction was successful even if email fails
    }
} else {
    error_log("PHPMailer class not available");
    echo "<!-- PHPMailer not available, email not sent -->\n";
}

// Close database connection
$conn->close();

// DON'T CLEAR SESSION DATA YET - Success page needs it
// The success page will clear it after displaying or via JavaScript

// Redirect to success page
header("Location: ethsucces.php");
exit();
?>