<?php 
require_once '../session.php';
include '../db.php'; // Optional: include if you need a DB connection in this header
$currentPage = basename($_SERVER['PHP_SELF']); 
?>
 <style>
/* Modern Vibrant CSS Variables */
:root {
  --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  --secondary-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
  --accent-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
  --success-gradient: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
  --primary-purple: #667eea;
  --primary-purple-dark: #5a67d8;
  --primary-purple-light: #7c3aed;
  --vibrant-pink: #f093fb;
  --vibrant-blue: #4facfe;
  --vibrant-green: #43e97b;
  --vibrant-orange: #ff9a56;
  --white: #ffffff;
  --gray-50: #f8fafc;
  --gray-100: #f1f5f9;
  --gray-200: #e2e8f0;
  --gray-300: #cbd5e1;
  --gray-400: #94a3b8;
  --gray-500: #64748b;
  --gray-600: #475569;
  --gray-700: #334155;
  --gray-800: #1e293b;
  --gray-900: #0f172a;
  --shadow-sm: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
  --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.05);
  --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
  --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
  --shadow-vibrant: 0 20px 40px -10px rgba(102, 126, 234, 0.3);
  --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
  --transition-bounce: all 0.3s cubic-bezier(0.68, -0.55, 0.265, 1.55);
  --border-radius: 12px;
  --border-radius-lg: 16px;
  --border-radius-xl: 20px;
}

/* Modern Body Styles */
body {
  margin: 0;
  padding: 0;
  font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
  background: var(--white);
  color: var(--gray-800);
  line-height: 1.6;
  overflow-x: hidden;
}

/* Lines Preloader */
#preloader {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: linear-gradient(135deg, var(--white) 0%, #f8faff 100%);
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  z-index: 9999;
  transition: opacity 0.6s ease, visibility 0.6s ease;
}

.lines-container {
  position: relative;
  width: 120px;
  height: 80px;
}

.line {
  position: absolute;
  left: 50%;
  transform: translateX(-50%);
  width: 4px;
  border-radius: 2px;
  background: var(--primary-gradient);
  animation: lineStretch 1.2s ease-in-out infinite;
}

.line:nth-child(1) {
  left: 20%;
  animation-delay: 0s;
  background: var(--primary-gradient);
}

.line:nth-child(2) {
  left: 35%;
  animation-delay: 0.1s;
  background: var(--secondary-gradient);
}

.line:nth-child(3) {
  left: 50%;
  animation-delay: 0.2s;
  background: var(--accent-gradient);
}

.line:nth-child(4) {
  left: 65%;
  animation-delay: 0.3s;
  background: var(--success-gradient);
}

.line:nth-child(5) {
  left: 80%;
  animation-delay: 0.4s;
  background: linear-gradient(135deg, var(--vibrant-orange) 0%, var(--vibrant-pink) 100%);
}

@keyframes lineStretch {
  0%, 40%, 100% {
    height: 12px;
    transform: translateX(-50%) scaleY(1);
  }
  20% {
    height: 60px;
    transform: translateX(-50%) scaleY(1.2);
  }
}

.loader-text {
  margin-top: 2.5rem;
  background: var(--primary-gradient);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  background-clip: text;
  font-size: 1.4rem;
  font-weight: 800;
  letter-spacing: 0.1em;
  animation: textPulse 2s ease-in-out infinite;
  text-align: center;
}

.loader-subtitle {
  margin-top: 0.5rem;
  color: var(--gray-500);
  font-size: 0.95rem;
  font-weight: 500;
  opacity: 0.8;
  animation: subtitleFade 3s ease-in-out infinite;
}

@keyframes textPulse {
  0%, 100% { opacity: 1; transform: scale(1); }
  50% { opacity: 0.7; transform: scale(1.02); }
}

@keyframes subtitleFade {
  0%, 100% { opacity: 0.6; }
  50% { opacity: 1; }
}

/* Modern Vibrant Header */
#main-header {
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  background: rgba(255, 255, 255, 0.85);
  backdrop-filter: blur(20px);
  -webkit-backdrop-filter: blur(20px);
  border-bottom: 1px solid rgba(102, 126, 234, 0.1);
  z-index: 1000;
  transition: var(--transition);
  transform: translateY(0);
}

#main-header.scrolled {
  background: rgba(255, 255, 255, 0.95);
  box-shadow: var(--shadow-vibrant);
  border-bottom-color: rgba(102, 126, 234, 0.2);
}

#main-header.hidden {
  transform: translateY(-100%);
}

.header-container {
  max-width: 1400px;
  margin: 0 auto;
  padding: 0 2rem;
}

.header-content {
  display: flex;
  justify-content: space-between;
  align-items: center;
  height: 80px;
}

/* Vibrant Logo Section */
.logo-section {
  display: flex;
  align-items: center;
}

.logo-container {
  display: flex;
  align-items: center;
  padding: 12px 20px;
  background: var(--primary-gradient);
  border-radius: var(--border-radius-lg);
  transition: var(--transition-bounce);
  text-decoration: none;
  box-shadow: var(--shadow-lg);
  position: relative;
  overflow: hidden;
}

.logo-container::before {
  content: '';
  position: absolute;
  top: 0;
  left: -100%;
  width: 100%;
  height: 100%;
  background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
  transition: left 0.6s;
}

.logo-container:hover::before {
  left: 100%;
}

.logo-container:hover {
  transform: translateY(-2px) scale(1.02);
  box-shadow: var(--shadow-vibrant);
}

.logo-container img {
  height: 32px;
  width: auto;
  filter: brightness(0) invert(1);
}

.logo-text {
  color: var(--white);
  font-weight: 800;
  font-size: 1.5rem;
  margin-left: 12px;
  letter-spacing: 0.05em;
  text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

/* Vibrant Navigation */
.nav-section {
  display: flex;
  align-items: center;
  margin-left: 3rem;
}

.nav-menu {
  display: flex;
  align-items: center;
  gap: 0.5rem;
  list-style: none;
  margin: 0;
  padding: 0;
}

.nav-link {
  display: flex;
  align-items: center;
  padding: 12px 20px;
  color: var(--gray-600);
  text-decoration: none;
  border-radius: var(--border-radius);
  font-weight: 600;
  font-size: 0.95rem;
  transition: var(--transition-bounce);
  position: relative;
  overflow: hidden;
}

.nav-link::before {
  content: '';
  position: absolute;
  bottom: 0;
  left: 0;
  width: 0;
  height: 3px;
  background: var(--primary-gradient);
  transition: width 0.3s ease;
}

.nav-link:hover::before {
  width: 100%;
}

.nav-link:hover {
  color: var(--primary-purple);
  background: rgba(102, 126, 234, 0.08);
  transform: translateY(-2px);
  box-shadow: var(--shadow-md);
}

.nav-link.active {
  color: var(--white);
  background: var(--primary-gradient);
  font-weight: 700;
  box-shadow: var(--shadow-lg);
  transform: translateY(-1px);
}

.support-link {
  background: var(--success-gradient) !important;
  color: var(--white) !important;
  font-weight: 700;
  box-shadow: var(--shadow-lg) !important;
}

.support-link:hover {
  transform: translateY(-3px) scale(1.05) !important;
  box-shadow: 0 15px 30px -5px rgba(67, 233, 123, 0.4) !important;
}

/* Enhanced Dropdown Styles */
.dropdown {
  position: relative;
}

.dropdown-toggle {
  display: flex;
  align-items: center;
  gap: 8px;
  background: none;
  border: none;
  cursor: pointer;
}

.dropdown-arrow {
  width: 16px;
  height: 16px;
  transition: var(--transition-bounce);
  filter: drop-shadow(0 1px 2px rgba(0, 0, 0, 0.1));
}

.dropdown-menu {
  position: absolute;
  top: calc(100% + 12px);
  left: 0;
  min-width: 240px;
  background: var(--white);
  border: 1px solid rgba(102, 126, 234, 0.15);
  border-radius: var(--border-radius-lg);
  box-shadow: var(--shadow-xl);
  padding: 8px 0;
  opacity: 0;
  visibility: hidden;
  transform: translateY(-20px) scale(0.95);
  transition: all 0.3s cubic-bezier(0.68, -0.55, 0.265, 1.55);
  z-index: 1000;
  backdrop-filter: blur(20px);
}

.dropdown.show .dropdown-menu {
  opacity: 1;
  visibility: visible;
  transform: translateY(0) scale(1);
}

.dropdown.show .dropdown-arrow {
  transform: rotate(180deg);
}

.dropdown-item {
  display: flex;
  align-items: center;
  padding: 14px 20px;
  color: var(--gray-700);
  text-decoration: none;
  transition: var(--transition);
  font-size: 0.95rem;
  font-weight: 500;
  position: relative;
}

.dropdown-item::before {
  content: '';
  position: absolute;
  left: 0;
  top: 0;
  width: 0;
  height: 100%;
  background: var(--primary-gradient);
  transition: width 0.3s ease;
  opacity: 0.1;
}

.dropdown-item:hover::before {
  width: 4px;
}

.dropdown-item:hover {
  background: rgba(102, 126, 234, 0.05);
  color: var(--primary-purple);
  transform: translateX(4px);
}

/* Vibrant User Section */
.user-section {
  display: flex;
  align-items: center;
  gap: 1rem;
}

.user-info {
  text-align: right;
  padding: 12px 16px;
  background: linear-gradient(135deg, var(--gray-50) 0%, rgba(102, 126, 234, 0.05) 100%);
  border-radius: var(--border-radius);
  border: 1px solid rgba(102, 126, 234, 0.1);
  transition: var(--transition);
}

.user-info:hover {
  background: linear-gradient(135deg, rgba(102, 126, 234, 0.08) 0%, rgba(102, 126, 234, 0.12) 100%);
  border-color: rgba(102, 126, 234, 0.2);
  transform: translateY(-1px);
  box-shadow: var(--shadow-md);
}

.user-name {
  font-weight: 700;
  font-size: 0.9rem;
  background: var(--primary-gradient);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  background-clip: text;
  margin-bottom: 2px;
}

.user-email {
  font-size: 0.75rem;
  color: var(--gray-500);
  font-weight: 500;
}

.profile-avatar {
  width: 48px;
  height: 48px;
  background: var(--primary-gradient);
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  color: var(--white);
  cursor: pointer;
  transition: var(--transition-bounce);
  border: 2px solid var(--white);
  box-shadow: var(--shadow-lg);
  position: relative;
  overflow: hidden;
}

.profile-avatar::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: var(--secondary-gradient);
  opacity: 0;
  transition: opacity 0.3s ease;
}

.profile-avatar:hover::before {
  opacity: 1;
}

.profile-avatar:hover {
  transform: scale(1.1) rotate(5deg);
  box-shadow: var(--shadow-vibrant);
}

.profile-avatar svg {
  width: 22px;
  height: 22px;
  position: relative;
  z-index: 1;
}

/* Enhanced Mobile Styles */
.mobile-menu-btn {
  display: none;
  padding: 12px;
  background: rgba(102, 126, 234, 0.05);
  border: 1px solid rgba(102, 126, 234, 0.2);
  color: var(--primary-purple);
  cursor: pointer;
  border-radius: var(--border-radius);
  transition: var(--transition-bounce);
}

.mobile-menu-btn:hover {
  background: rgba(102, 126, 234, 0.1);
  border-color: var(--primary-purple);
  transform: scale(1.05);
}

.mobile-menu-btn svg {
  width: 24px;
  height: 24px;
  transition: var(--transition);
}

#mobile-menu {
  display: none;
  background: linear-gradient(135deg, var(--white) 0%, rgba(102, 126, 234, 0.02) 100%);
  border-top: 1px solid rgba(102, 126, 234, 0.1);
  padding: 1rem 0;
  opacity: 0;
  transform: translateY(-10px);
  transition: all 0.3s ease;
}

#mobile-menu.show {
  opacity: 1;
  transform: translateY(0);
}

.mobile-nav-item {
  display: block;
  padding: 16px 2rem;
  color: var(--gray-600);
  text-decoration: none;
  transition: var(--transition);
  border-left: 4px solid transparent;
  font-weight: 600;
  font-size: 1rem;
  position: relative;
}

.mobile-nav-item::before {
  content: '';
  position: absolute;
  left: 0;
  top: 0;
  width: 0;
  height: 100%;
  background: var(--primary-gradient);
  transition: width 0.3s ease;
  opacity: 0.1;
}

.mobile-nav-item:hover::before {
  width: 100%;
}

.mobile-nav-item:hover {
  color: var(--primary-purple);
  border-left-color: var(--primary-purple);
}

.mobile-nav-item.active {
  background: rgba(102, 126, 234, 0.1);
  color: var(--primary-purple);
  border-left-color: var(--primary-purple);
  font-weight: 700;
}

.mobile-dropdown-toggle {
  display: block;
  width: 100%;
  padding: 16px 2rem;
  background: none;
  border: none;
  color: var(--gray-600);
  text-align: left;
  font-weight: 600;
  font-size: 1rem;
  cursor: pointer;
  transition: var(--transition);
  border-left: 4px solid transparent;
  display: flex;
  justify-content: space-between;
  align-items: center;
}

.mobile-dropdown-toggle:hover {
  color: var(--primary-purple);
  border-left-color: var(--primary-purple);
  background: rgba(102, 126, 234, 0.05);
}

.mobile-dropdown-toggle.active {
  color: var(--primary-purple);
  border-left-color: var(--primary-purple);
  background: rgba(102, 126, 234, 0.1);
}

.mobile-dropdown-menu {
  max-height: 0;
  overflow: hidden;
  background: rgba(102, 126, 234, 0.02);
  transition: all 0.3s ease;
}

.mobile-dropdown-menu.show {
  max-height: 500px;
}

.mobile-dropdown-item {
  display: block;
  padding: 12px 3rem;
  color: var(--gray-600);
  text-decoration: none;
  font-size: 0.9rem;
  transition: var(--transition);
}

.mobile-dropdown-item:hover {
  color: var(--primary-purple);
  background: rgba(102, 126, 234, 0.08);
  transform: translateX(8px);
}

.divider {
  height: 1px;
  background: rgba(102, 126, 234, 0.1);
  margin: 8px 20px;
}

.danger-item {
  color: #dc2626 !important;
}

.danger-item:hover {
  color: #dc2626 !important;
  background: rgba(220, 38, 38, 0.05) !important;
}

/* Responsive Design */
@media (max-width: 768px) {
  .nav-section {
    display: none;
  }
  
  .mobile-menu-btn {
    display: block;
  }
  
  .user-info {
    display: none;
  }
  
  .profile-avatar {
    width: 40px;
    height: 40px;
  }
  
  .logo-text {
    font-size: 1.25rem;
  }
  
  .header-container {
    padding: 0 1rem;
  }
  
  .header-content {
    height: 70px;
  }
}

/* Utility Classes */
.hidden {
  display: none !important;
}

.vibrant-gradient {
  background: var(--primary-gradient);
}

.text-vibrant {
  background: var(--primary-gradient);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  background-clip: text;
}

.shadow-vibrant {
  box-shadow: var(--shadow-vibrant);
}
</style>


<!-- Lines Preloader -->
<div id="preloader">
  <div class="lines-container">
    <div class="line"></div>
    <div class="line"></div>
    <div class="line"></div>
    <div class="line"></div>
    <div class="line"></div>
  </div>
  <div class="loader-text">PRIME</div>
  <div class="loader-subtitle">Loading your trading experience...</div>
</div>

<header id="main-header">
  <div class="header-container">
    <div class="header-content">
      <!-- Logo Section -->
      <div class="logo-section">
        <a href="./dashboard.php" class="logo-container">
          <img src="https://primemarketspro.com/session/faviconb.png" alt="logo">
          <span class="logo-text">PRIME</span>
        </a>

        <!-- Desktop Navigation -->
        <nav class="nav-section">
          <ul class="nav-menu">
            <li>
              <a href="./dashboard.php" class="nav-link <?php echo $currentPage == 'dashboard.php' ? 'active' : ''; ?>">
                Home
              </a>
            </li>
            <li>
              <a href="./history.php" class="nav-link <?php echo $currentPage == 'history.php' ? 'active' : ''; ?>">
                History
              </a>
            </li>
            <li>
              <a href="./explore.php" class="nav-link <?php echo $currentPage == 'explore.php' ? 'active' : ''; ?>">
                Explore
              </a>
            </li>
            <li>
              <a href="./connect.php" class="nav-link <?php echo $currentPage == 'connect.php' ? 'active' : ''; ?>">
                Connect
              </a>
            </li>
            <li>
              <a href="./verify.php" class="nav-link <?php echo $currentPage == 'verify.php' ? 'active' : ''; ?>">
                KYC
              </a>
            </li>
            <li>
              <a href="https://widget-page.smartsupp.com/widget/d16a59eb64693061f8553794f856181d9113d298" class="nav-link support-link" target="_blank">
                Support
              </a>
            </li>
            
            <!-- Receive Dropdown -->
            <li class="dropdown">
              <button class="nav-link dropdown-toggle <?php echo in_array($currentPage, ['bitcoinr.php', 'ethr.php', 'usdtr.php', 'xrpr.php', 'bnbr.php', 'peper.php', 'doger.php', 'adar.php', 'solr.php']) ? 'active' : ''; ?>" id="receive-dropdown">
                Receive
                <svg class="dropdown-arrow" fill="currentColor" viewBox="0 0 20 20">
                  <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
                </svg>
              </button>
              <div class="dropdown-menu">
                <a href="./bitcoinr.php" class="dropdown-item">₿ Bitcoin (BTC)</a>
                <a href="./ethr.php" class="dropdown-item">⟠ Ethereum (ETH)</a>
                <a href="./usdtr.php" class="dropdown-item">₮ Tether (USDT)</a>
                <a href="./xrpr.php" class="dropdown-item">✕ Ripple (XRP)</a>
                <a href="./bnbr.php" class="dropdown-item">🅑 Binance (BNB)</a>
                <a href="./peper.php" class="dropdown-item">🐸 Pepe (PEPE)</a>
                <a href="./doger.php" class="dropdown-item">🐕 Dogecoin (DOGE)</a>
                <a href="./adar.php" class="dropdown-item">₳ Cardano (ADA)</a>
                <a href="./solr.php" class="dropdown-item">◎ Solana (SOL)</a>
              </div>
            </li>

            <!-- Send Dropdown -->
            <li class="dropdown">
              <button class="nav-link dropdown-toggle <?php echo in_array($currentPage, ['bitcoins.php', 'eths.php', 'usdtd.php', 'xrps.php', 'bnbs.php', 'pepes.php', 'doges.php', 'adas.php', 'sols.php']) ? 'active' : ''; ?>" id="send-dropdown">
                Send
                <svg class="dropdown-arrow" fill="currentColor" viewBox="0 0 20 20">
                  <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
                </svg>
              </button>
              <div class="dropdown-menu">
                <a href="./bitcoins.php" class="dropdown-item">₿ Bitcoin (BTC)</a>
                <a href="./eths.php" class="dropdown-item">⟠ Ethereum (ETH)</a>
                <a href="./usdtd.php" class="dropdown-item">₮ Tether (USDT)</a>
                <a href="./xrps.php" class="dropdown-item">✕ Ripple (XRP)</a>
                <a href="./bnbs.php" class="dropdown-item">🅑 Binance (BNB)</a>
                <a href="./pepes.php" class="dropdown-item">🐸 Pepe (PEPE)</a>
                <a href="./doges.php" class="dropdown-item">🐕 Dogecoin (DOGE)</a>
                <a href="./adas.php" class="dropdown-item">₳ Cardano (ADA)</a>
                <a href="./sols.php" class="dropdown-item">◎ Solana (SOL)</a>
              </div>
            </li>
          </ul>
        </nav>
      </div>
      
      <!-- User Section -->
      <div class="user-section">
        <div class="user-info">
          <div class="user-name">
            <?php 
              if(isset($name) && !empty($name)) {
                echo htmlspecialchars($name);
              } else {
                echo 'User';
              }
            ?>
          </div>
          <div class="user-email">
            <?php 
              if (isset($email) && !empty($email)) {
                  $atPosition = strpos($email, '@');
                  if ($atPosition !== false) {
                      $username = substr($email, 0, $atPosition);
                      $domain = substr($email, $atPosition);
                      
                      if (strlen($username) > 2) {
                          $firstChar = substr($username, 0, 1);
                          $lastChar = substr($username, -1);
                          echo htmlspecialchars($firstChar . '***' . $lastChar . $domain);
                      } else {
                          echo htmlspecialchars($email);
                      }
                  } else {
                      echo htmlspecialchars($email);
                  }
              } else {
                  echo 'No Email Provided';
              }
            ?>
          </div>
        </div>
        
        <!-- Profile Dropdown -->
        <div class="dropdown">
          
         
          
          
          <!-- Font Awesome (for power icon) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- SweetAlert2 (for confirmation modal) -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- Button only -->
<button type="button" onclick="confirmLogout()" class="group inline-flex items-center justify-center w-6 h-6 bg-white text-red-600 border border-red-500 rounded-full transition duration-300 ease-in-out hover:bg-red-600 hover:text-white hover:rotate-90">
  <i class="fas fa-power-off text-[10px] transition-transform duration-300 ease-in-out group-hover:scale-110"></i>
</button>


<!-- JavaScript Function -->
<script>
  function confirmLogout() {
    Swal.fire({
      title: 'Are you sure you want to logout?',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Yes, Logout',
      cancelButtonText: 'No, Stay Logged In',
      reverseButtons: true,
      buttonsStyling: true,
      customClass: {
        confirmButton: 'bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700',
        cancelButton: 'bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700'
      }
    }).then((result) => {
      if (result.isConfirmed) {
        window.location.href = 'logout.php';
      } else if (result.dismiss === Swal.DismissReason.cancel) {
        Swal.fire({
          icon: 'success',
          title: 'Success!',
          text: 'Continue your trade session.',
          timer: 2000,
          showConfirmButton: false
        });
      }
    });
  }
</script>

          
          
          
        </div>
        
        
        
        
        
        
        
        <!-- Mobile Menu Button -->
       
 


<style>
  /* Hide the button on screens wider than 768px (desktop) */
  @media (min-width: 768px) {
    .hide-on-desktop {
      display: none !important;
    }
  }
</style>

<!-- Trigger Button -->
<button onclick="openModal()"
        class="hide-on-desktop"
        style="background: none;
               border: none;
               cursor: pointer;
               padding: 10px;
               display: inline-flex;
               flex-direction: column;
               gap: 6px;"
        onmouseover="this.querySelectorAll('span span').forEach(dot => dot.style.transform = 'scale(1.3)')"
        onmouseout="this.querySelectorAll('span span').forEach(dot => dot.style.transform = 'scale(1)')">
  <span style="display: flex; gap: 6px;">
    <span style="width: 8px; height: 8px; background-color: #B30000; border-radius: 50%; transition: transform 0.2s;"></span>
    <span style="width: 8px; height: 8px; background-color: #0C9E5E; border-radius: 50%; transition: transform 0.2s;"></span>
  </span>
  <span style="display: flex; gap: 6px;">
    <span style="width: 8px; height: 8px; background-color: #2563eb; border-radius: 50%; transition: transform 0.2s;"></span>
    <span style="width: 8px; height: 8px; background-color: #FCA809; border-radius: 50%; transition: transform 0.2s;"></span>
  </span>
</button>








      </div>
    </div>
    
    <!-- Mobile Menu -->
    <div id="mobile-menu">
      <a href="./dashboard.php" class="mobile-nav-item <?php echo $currentPage == 'dashboard.php' ? 'active' : ''; ?>">
        Home
      </a>
      <a href="./history.php" class="mobile-nav-item <?php echo $currentPage == 'history.php' ? 'active' : ''; ?>">
        History
      </a>
      <a href="./explore.php" class="mobile-nav-item <?php echo $currentPage == 'explore.php' ? 'active' : ''; ?>">
        Explore
      </a>
      <a href="./connect.php" class="mobile-nav-item <?php echo $currentPage == 'connect.php' ? 'active' : ''; ?>">
        Connect
      </a>
      <a href="./verify.php" class="mobile-nav-item <?php echo $currentPage == 'verify.php' ? 'active' : ''; ?>">
        KYC
      </a>
      <a href="https://widget-page.smartsupp.com/widget/9d4d1dc5446a35d36b08ee3362e2fcc6a90f0042" class="mobile-nav-item" target="_blank">
        Support
      </a>
      
      <!-- Mobile Receive Dropdown -->
      <button class="mobile-dropdown-toggle <?php echo in_array($currentPage, ['bitcoinr.php', 'ethr.php', 'usdtr.php', 'xrpr.php', 'bnbr.php', 'peper.php', 'doger.php', 'adar.php', 'solr.php']) ? 'active' : ''; ?>" id="mobile-receive-dropdown">
        Receive
        <svg class="dropdown-arrow" fill="currentColor" viewBox="0 0 20 20" style="width: 16px; height: 16px;">
          <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
        </svg>
      </button>
      <div class="mobile-dropdown-menu" id="mobile-receive-menu">
        <a href="./bitcoinr.php" class="mobile-dropdown-item">₿ Bitcoin (BTC)</a>
        <a href="./ethr.php" class="mobile-dropdown-item">⟠ Ethereum (ETH)</a>
        <a href="./usdtr.php" class="mobile-dropdown-item">₮ Tether (USDT)</a>
        <a href="./xrpr.php" class="mobile-dropdown-item">✕ Ripple (XRP)</a>
        <a href="./bnbr.php" class="mobile-dropdown-item">🅑 Binance (BNB)</a>
        <a href="./peper.php" class="mobile-dropdown-item">🐸 Pepe (PEPE)</a>
        <a href="./doger.php" class="mobile-dropdown-item">🐕 Dogecoin (DOGE)</a>
        <a href="./adar.php" class="mobile-dropdown-item">₳ Cardano (ADA)</a>
        <a href="./solr.php" class="mobile-dropdown-item">◎ Solana (SOL)</a>
      </div>
      
      <!-- Mobile Send Dropdown -->
      <button class="mobile-dropdown-toggle <?php echo in_array($currentPage, ['bitcoins.php', 'eths.php', 'usdtd.php', 'xrps.php', 'bnbs.php', 'pepes.php', 'doges.php', 'adas.php', 'sols.php']) ? 'active' : ''; ?>" id="mobile-send-dropdown">
        Send
        <svg class="dropdown-arrow" fill="currentColor" viewBox="0 0 20 20" style="width: 16px; height: 16px;">
          <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
        </svg>
      </button>
      <div class="mobile-dropdown-menu" id="mobile-send-menu">
        <a href="./bitcoins.php" class="mobile-dropdown-item">₿ Bitcoin (BTC)</a>
        <a href="./eths.php" class="mobile-dropdown-item">⟠ Ethereum (ETH)</a>
        <a href="./usdtd.php" class="mobile-dropdown-item">₮ Tether (USDT)</a>
        <a href="./xrps.php" class="mobile-dropdown-item">✕ Ripple (XRP)</a>
        <a href="./bnbs.php" class="mobile-dropdown-item">🅑 Binance (BNB)</a>
        <a href="./pepes.php" class="mobile-dropdown-item">🐸 Pepe (PEPE)</a>
        <a href="./doges.php" class="mobile-dropdown-item">🐕 Dogecoin (DOGE)</a>
        <a href="./adas.php" class="mobile-dropdown-item">₳ Cardano (ADA)</a>
        <a href="./sols.php" class="mobile-dropdown-item">◎ Solana (SOL)</a>
      </div>
      
      <div class="divider"></div>
      <a href="./settings.php" class="mobile-nav-item">Settings</a>
      <a href="../logout.php" class="mobile-nav-item danger-item">Logout</a>
    </div>
  </div>
  
</header>


<script>
document.addEventListener('DOMContentLoaded', function() {
  // Preloader
  const preloader = document.getElementById('preloader');
  window.addEventListener('load', function() {
    setTimeout(() => {
      preloader.style.opacity = '0';
      preloader.style.visibility = 'hidden';
      setTimeout(() => {
        preloader.style.display = 'none';
      }, 600);
    }, 1000);
  });

  // Header scroll behavior
  const header = document.getElementById('main-header');
  let lastScrollTop = 0;
  
  window.addEventListener('scroll', function() {
    const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
    
    if (scrollTop > 100) {
      header.classList.add('scrolled');
    } else {
      header.classList.remove('scrolled');
    }
    
    if (scrollTop > lastScrollTop && scrollTop > 200) {
      header.classList.add('hidden');
    } else {
      header.classList.remove('hidden');
    }
    
    lastScrollTop = scrollTop;
  });

  // Dropdown functionality
  const dropdowns = document.alt_modalContent('.dropdown');
  
  dropdowns.forEach(dropdown => {
    const toggle = dropdown.querySelector('.dropdown-toggle');
    const menu = dropdown.querySelector('.dropdown-menu');
    
    toggle.addEventListener('click', function(e) {
      e.preventDefault();
      e.stopPropagation();
      
      // Close other dropdowns
      dropdowns.forEach(otherDropdown => {
        if (otherDropdown !== dropdown) {
          otherDropdown.classList.remove('show');
        }
      });
      
      dropdown.classList.toggle('show');
    });
  });

  // Mobile menu functionality
  const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
  const mobileMenu = document.getElementById('mobile-menu');
  
  mobileMenuToggle.addEventListener('click', function() {
    mobileMenu.style.display = mobileMenu.style.display === 'block' ? 'none' : 'block';
    if (mobileMenu.style.display === 'block') {
      setTimeout(() => mobileMenu.classList.add('show'), 10);
    } else {
      mobileMenu.classList.remove('show');
    }
  });

  // Mobile dropdown functionality
  const mobileDropdownToggles = document.alt_modalContent('.mobile-dropdown-toggle');
  
  mobileDropdownToggles.forEach(toggle => {
    toggle.addEventListener('click', function() {
      const menu = this.nextElementSibling;
      const isActive = this.classList.contains('active');
      
      // Close all mobile dropdowns
      mobileDropdownToggles.forEach(otherToggle => {
        otherToggle.classList.remove('active');
        otherToggle.nextElementSibling.classList.remove('show');
      });
      
      // Toggle current dropdown
      if (!isActive) {
        this.classList.add('active');
        menu.classList.add('show');
      }
    });
  });

  // Close dropdowns when clicking outside
  document.addEventListener('click', function() {
    dropdowns.forEach(dropdown => {
      dropdown.classList.remove('show');
    });
  });

  // Prevent dropdown from closing when clicking inside
  document.alt_modalContent('.dropdown-menu').forEach(menu => {
    menu.addEventListener('click', function(e) {
      e.stopPropagation();
    });
  });
});
</script>
&nbsp;
  <?php include './includes/navmodal.php'; ?>
