 <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- Services Section -->
    <section style="width: 100%;">
      <div
        style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem; padding: 0 0.75rem;">

      

      <div style="padding: 0 0.75rem;">
        <div
          style="display: grid; grid-template-columns: repeat(auto-fit, minmax(70px, 1fr)); gap: 0.75rem; justify-items: center;"
          id="servicesGrid">
          <!-- Main services will be populated by JavaScript -->
        </div>
      </div>
    </section>

    <!-- Modal -->
    <div id="modal"
      style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.5); z-index: 1000; align-items: center; justify-content: center;">
      <div
        style="background: white; border-radius: 0.75rem; padding: 1.5rem; max-width: 90%; max-height: 85%; overflow-y: auto; position: relative; box-shadow: 0 20px 40px -12px rgba(0, 0, 0, 0.25); width: 100%; max-width: 600px;">
       
       <!-- Clock Container Positioned to the Top Right -->

<div style="display: flex; justify-content: flex-end;">
  <div style="font-family: monospace; font-size: 10px; color: #333; line-height: 1; margin-bottom: 1rem; text-align: right;">
    <span id="datetimeClock"></span><br>
    <span id="timezone" style="font-size: 9px; color: #888;"></span>
  </div>
  <!-- Include Font Awesome (if not already included) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />

<br>
<!-- Right-aligned nav with clickable dashboard link -->
<div style="
  font-family: monospace;
  font-size: 11px;
  color: #333;
  line-height: 1.4;
  margin-bottom: 1rem;
  text-align: right;
  padding-right: 12px;
  text-transform: uppercase;
  letter-spacing: 0.6px;
  word-spacing: 2px;
  display: flex;
  justify-content: flex-end;
  align-items: center;
  gap: 6px;
">

  <!-- Icons and labels -->


  <!-- Clickable link to dashboard -->
  <a href="dashboard.php" style="text-decoration: none; color: #1e3a8a; font-weight: bold;"><i class="fas fa-wallet" title="Wallet"></i>
   Home
  </a>
</div>

</div>


<script>
  function pad(n) {
    return n < 10 ? '0' + n : n;
  }

  function updateDateTimeClock() {
    const now = new Date();
    const year = now.getFullYear();
    const month = pad(now.getMonth() + 1);
    const day = pad(now.getDate());
    const hours = pad(now.getHours());
    const minutes = pad(now.getMinutes());
    const seconds = pad(now.getSeconds());
    const formattedDateTime = `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
    document.getElementById('datetimeClock').textContent = formattedDateTime;
  }

  function setTimezoneLabel(timezone) {
    const displayZone = timezone ? timezone : Intl.DateTimeFormat().resolvedOptions().timeZone;
    document.getElementById('timezone').textContent = `Zone: ${displayZone}`;
  }

  async function detectTimezoneFromIP() {
    try {
      // You can use ipapi.co, ip-api.com, or ipinfo.io (free tier usually limits number of calls)
      const res = await fetch('https://ipapi.co/json/');
      const data = await res.json();
      if (data && data.timezone) {
        setTimezoneLabel(data.timezone);
      } else {
        setTimezoneLabel(); // fallback to browser
      }
    } catch (e) {
      console.warn('IP-based timezone fetch failed:', e);
      setTimezoneLabel(); // fallback
    }
  }

  detectTimezoneFromIP();          // Fetch timezone via IP
  updateDateTimeClock();           // Show initial time
  setInterval(updateDateTimeClock, 1000); // Tick every second
</script>


        <div id="modalContent">
          <!-- Categories will be populated by JavaScript -->
        </div>
      </div>
    </div>

    <script>
      // Compact service definitions with smaller icons and text
      const primaryServices = [
        
        
      ];

      const serviceCategories = {
        'Assets': [
          { name: 'Bitcoin (BTC)',    icon: 'fab fa-bitcoin',          gradient: 'linear-gradient(135deg, #f7931a, #ff9900)', file: 'detailedbtc.php' },
            { name: 'Ethereum (ETH)',   icon: 'fab fa-ethereum',         gradient: 'linear-gradient(135deg, #3c3c3d, #8c8c8c)', file: 'detailedeth.php' },
            { name: 'Tether (USDT)',    icon: 'fas fa-dollar-sign',      gradient: 'linear-gradient(135deg, #26a17b, #13aa52)', file: 'detailedusdt.php' },
            { name: 'Ripple (XRP)',     icon: 'fas fa-times-circle',     gradient: 'linear-gradient(135deg, #006097, #00aae4)', file: 'detailxrp.php' },
            { name: 'Binance (BNB)',    icon: 'fas fa-coins',            gradient: 'linear-gradient(135deg, #f3ba2f, #f0b90b)', file: 'detailbnb.php' },
            { name: 'Pepe (PEPE)',      icon: 'fas fa-frog',             gradient: 'linear-gradient(135deg, #3bb143, #2ecc71)', file: 'detailedpeper.php' },
            { name: 'Dogecoin (DOGE)',  icon: 'fas fa-dog',              gradient: 'linear-gradient(135deg, #c2a633, #d4af37)', file: 'detailedoge.php' },
            { name: 'Cardano (ADA)',    icon: 'fas fa-circle',           gradient: 'linear-gradient(135deg, #0033ad, #0047ff)', file: 'detailada.php' },
            { name: 'Solana (SOL)',     icon: 'fas fa-sun',              gradient: 'linear-gradient(135deg, #00ffa3, #dc1fff)', file: 'detailedsol.php' }

        ],
        
      
         
 'Payments': [
         
            { name: 'Crypto Withdraw', icon: 'fab fa-bitcoin', gradient: 'linear-gradient(135deg, #eab308, #ea580c)', file: './crypto.php' },
           {
  name: 'Bank Withdraw',
  icon: 'fas fa-university',
  gradient: 'linear-gradient(135deg, #3b82f6, #1e40af)', // blue gradient background
  file: './raying/index.php'
}
        ],
        'Trading': [
         
           { name: 'Crypto Trading', icon: 'fab fa-bitcoin', gradient: 'linear-gradient(135deg, #eab308, #ea580c)', file: 'market.php' },
          { name: 'Copy Trader', icon: 'fas fa-copy', gradient: 'linear-gradient(135deg, #9333ea, #ec4899)', file: 'copytrade.php' },
          { name: 'Signal', icon: 'fas fa-signal', gradient: 'linear-gradient(135deg, #06b6d4, #3b82f6)', file: 'signalbuy.php' },
          { name: 'Plan', icon: 'fas fa-chart-line', gradient: 'linear-gradient(135deg, #f97316, #dc2626)', file: 'plans.php' },
          { name: 'Analytics', icon: 'fas fa-chart-bar', gradient: 'linear-gradient(135deg, #0891b2, #0e7490)', file: 'analytic.php' }
        ],
        'Account': [
          { name: 'KYC', icon: 'fas fa-id-card', gradient: 'linear-gradient(135deg, #eab308, #f97316)', file: 'verify.php' },
          { name: 'Settings', icon: 'fas fa-cog', gradient: 'linear-gradient(135deg, #6b7280, #4b5563)', file: 'settings.php' },
          { name: 'History', icon: 'fas fa-history', gradient: 'linear-gradient(135deg, #8b5cf6, #3b82f6)', file: 'history.php' },
          { name: 'Explore', icon: 'fas fa-compass', gradient: 'linear-gradient(135deg, #14b8a6, #10b981)', file: 'explore.php' }
        ],
        
      };

      function createServiceButton(service, isModal = false) {
        const button = document.createElement('a');
        button.href = service.file;

        // Smaller, more compact sizes
        const iconSize = isModal ? '2.5rem' : '2.25rem';
        const fontSize = isModal ? '0.75rem' : '0.65rem';
        const iconFontSize = isModal ? '1.1rem' : '1rem';
        const buttonWidth = isModal ? '85px' : '70px';

        button.style.cssText = `
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
            padding: 0.5rem 0.25rem;
            background: none;
            border: none;
            cursor: pointer;
            transition: all 0.25s ease;
            border-radius: 0.5rem;
            width: ${buttonWidth};
            text-decoration: none;
        `;

        const iconDiv = document.createElement('div');
        iconDiv.style.cssText = `
            width: ${iconSize};
            height: ${iconSize};
            border-radius: 0.75rem;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 0.375rem;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.12);
            background: ${service.gradient};
            transition: all 0.25s ease;
        `;

        const icon = document.createElement('i');
        icon.className = service.icon;
        icon.style.cssText = `
            color: white;
            font-size: ${iconFontSize};
        `;

        const text = document.createElement('p');
        text.style.cssText = `
            font-size: ${fontSize};
            font-weight: 500;
            color: #374151;
            margin: 0;
            transition: color 0.25s ease;
            line-height: 1.1;
            text-align: center;
        `;
        text.textContent = service.name;

        // Subtle hover effects
        button.onmouseenter = function () {
          this.style.transform = 'translateY(-1px) scale(1.02)';
          iconDiv.style.boxShadow = '0 4px 12px rgba(0, 0, 0, 0.18)';
          text.style.color = '#2563eb';
        };

        button.onmouseleave = function () {
          this.style.transform = 'translateY(0) scale(1)';
          iconDiv.style.boxShadow = '0 2px 8px rgba(0, 0, 0, 0.12)';
          text.style.color = '#374151';
        };

        iconDiv.appendChild(icon);
        button.appendChild(iconDiv);
        button.appendChild(text);

        return button;
      }

      function populateMainServices() {
        const grid = document.getElementById('servicesGrid');
        grid.innerHTML = '';
        primaryServices.forEach(service => {
          grid.appendChild(createServiceButton(service, false));
        });
      }

      function populateModalServices() {
        const modalContent = document.getElementById('modalContent');
        modalContent.innerHTML = '';

        Object.entries(serviceCategories).forEach(([categoryName, services]) => {
          const categorySection = document.createElement('div');
          categorySection.style.cssText = 'margin-bottom: 1.25rem;';

          const categoryTitle = document.createElement('h4');
          categoryTitle.style.cssText = `
                font-size: 0.95rem;
                font-weight: 600;
                color: #111827;
                margin: 0 0 0.75rem 0;
                padding-bottom: 0.25rem;
                border-bottom: 1px solid #e5e7eb;
            `;
          categoryTitle.textContent = categoryName;

          const categoryGrid = document.createElement('div');
          categoryGrid.style.cssText = `
                display: grid;
                grid-template-columns: repeat(auto-fill, minmax(80px, 1fr));
                gap: 0.75rem;
                justify-items: center;
            `;

          services.forEach(service => {
            categoryGrid.appendChild(createServiceButton(service, true));
          });

          categorySection.appendChild(categoryTitle);
          categorySection.appendChild(categoryGrid);
          modalContent.appendChild(categorySection);
        });
      }

      function openModal() {
        document.getElementById('modal').style.display = 'flex';
        document.body.style.overflow = 'hidden';
      }

      function closeModal() {
        document.getElementById('modal').style.display = 'none';
        document.body.style.overflow = 'auto';
      }

      // Modal close handlers
      document.getElementById('modal').onclick = function (e) {
        if (e.target === this) closeModal();
      };

      document.addEventListener('keydown', function (e) {
        if (e.key === 'Escape') closeModal();
      });

      // Initialize services
      if (typeof populateServices === 'undefined') {
        // Only initialize if not already done
        populateMainServices();
        populateModalServices();
        window.populateServices = true;
      }
    </script>