<?php
// Enable error reporting for debugging (remove these in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

/**
 * Returns the country code for a given country name.
 *
 * @param mixed $countryName The country name or code.
 * @return string The two-letter country code in lowercase, or an empty string.
 */
function getCountryCode($countryName) {
    $codes = [
        'Afghanistan'                    => 'af',
        'Albania'                        => 'al',
        'Algeria'                        => 'dz',
        'Andorra'                        => 'ad',
        'Angola'                         => 'ao',
        'Antigua and Barbuda'            => 'ag',
        'Argentina'                      => 'ar',
        'Armenia'                        => 'am',
        'Australia'                      => 'au',
        'Austria'                        => 'at',
        'Azerbaijan'                     => 'az',
        'Bahamas'                        => 'bs',
        'Bahrain'                        => 'bh',
        'Bangladesh'                     => 'bd',
        'Barbados'                       => 'bb',
        'Belarus'                        => 'by',
        'Belgium'                        => 'be',
        'Belize'                         => 'bz',
        'Benin'                          => 'bj',
        'Bhutan'                         => 'bt',
        'Bolivia'                        => 'bo',
        'Bosnia and Herzegovina'         => 'ba',
        'Botswana'                       => 'bw',
        'Brazil'                         => 'br',
        'Brunei'                         => 'bn',
        'Bulgaria'                       => 'bg',
        'Burkina Faso'                   => 'bf',
        'Burundi'                        => 'bi',
        'Cabo Verde'                     => 'cv',
        'Cambodia'                       => 'kh',
        'Cameroon'                       => 'cm',
        'Canada'                         => 'ca',
        'Central African Republic'       => 'cf',
        'Chad'                           => 'td',
        'Chile'                          => 'cl',
        'China'                          => 'cn',
        'Colombia'                       => 'co',
        'Comoros'                        => 'km',
        'Congo (Congo-Brazzaville)'       => 'cg',
        'Costa Rica'                     => 'cr',
        'Croatia'                        => 'hr',
        'Cuba'                           => 'cu',
        'Cyprus'                         => 'cy',
        'Czechia (Czech Republic)'       => 'cz',
        'Democratic Republic of the Congo'=> 'cd',
        'Denmark'                        => 'dk',
        'Djibouti'                       => 'dj',
        'Dominica'                       => 'dm',
        'Dominican Republic'             => 'do',
        'Ecuador'                        => 'ec',
        'Egypt'                          => 'eg',
        'El Salvador'                    => 'sv',
        'Equatorial Guinea'              => 'gq',
        'Eritrea'                        => 'er',
        'Estonia'                        => 'ee',
        'Eswatini'                       => 'sz',
        'Ethiopia'                       => 'et',
        'Fiji'                           => 'fj',
        'Finland'                        => 'fi',
        'France'                         => 'fr',
        'Gabon'                          => 'ga',
        'Gambia'                         => 'gm',
        'Georgia'                        => 'ge',
        'Germany'                        => 'de',
        'Ghana'                          => 'gh',
        'Greece'                         => 'gr',
        'Grenada'                        => 'gd',
        'Guatemala'                      => 'gt',
        'Guinea'                         => 'gn',
        'Guinea-Bissau'                  => 'gw',
        'Guyana'                         => 'gy',
        'Haiti'                          => 'ht',
        'Holy See'                       => 'va',
        'Honduras'                       => 'hn',
        'Hungary'                        => 'hu',
        'Iceland'                        => 'is',
        'India'                          => 'in',
        'Indonesia'                      => 'id',
        'Iran'                           => 'ir',
        'Iraq'                           => 'iq',
        'Ireland'                        => 'ie',
        'Israel'                         => 'il',
        'Italy'                          => 'it',
        'Jamaica'                        => 'jm',
        'Japan'                          => 'jp',
        'Jordan'                         => 'jo',
        'Kazakhstan'                     => 'kz',
        'Kenya'                          => 'ke',
        'Kiribati'                       => 'ki',
        'Kuwait'                         => 'kw',
        'Kyrgyzstan'                     => 'kg',
        'Laos'                           => 'la',
        'Latvia'                         => 'lv',
        'Lebanon'                        => 'lb',
        'Lesotho'                        => 'ls',
        'Liberia'                        => 'lr',
        'Libya'                          => 'ly',
        'Liechtenstein'                  => 'li',
        'Lithuania'                      => 'lt',
        'Luxembourg'                     => 'lu',
        'Madagascar'                     => 'mg',
        'Malawi'                         => 'mw',
        'Malaysia'                       => 'my',
        'Maldives'                       => 'mv',
        'Mali'                           => 'ml',
        'Malta'                          => 'mt',
        'Marshall Islands'               => 'mh',
        'Mauritania'                     => 'mr',
        'Mauritius'                      => 'mu',
        'Mexico'                         => 'mx',
        'Micronesia'                     => 'fm',
        'Moldova'                        => 'md',
        'Monaco'                         => 'mc',
        'Mongolia'                       => 'mn',
        'Montenegro'                     => 'me',
        'Morocco'                        => 'ma',
        'Mozambique'                     => 'mz',
        'Myanmar (formerly Burma)'       => 'mm',
        'Namibia'                        => 'na',
        'Nauru'                          => 'nr',
        'Nepal'                          => 'np',
        'Netherlands'                    => 'nl',
        'New Zealand'                    => 'nz',
        'Nicaragua'                      => 'ni',
        'Niger'                          => 'ne',
        'Nigeria'                        => 'ng',
        'North Korea'                    => 'kp',
        'North Macedonia'                => 'mk',
        'Norway'                         => 'no',
        'Oman'                           => 'om',
        'Pakistan'                       => 'pk',
        'Palau'                          => 'pw',
        'Palestine State'                => 'ps',
        'Panama'                         => 'pa',
        'Papua New Guinea'               => 'pg',
        'Paraguay'                       => 'py',
        'Peru'                           => 'pe',
        'Philippines'                    => 'ph',
        'Poland'                         => 'pl',
        'Portugal'                       => 'pt',
        'Qatar'                          => 'qa',
        'Romania'                        => 'ro',
        'Russia'                         => 'ru',
        'Rwanda'                         => 'rw',
        'Saint Kitts and Nevis'          => 'kn',
        'Saint Lucia'                    => 'lc',
        'Saint Vincent and the Grenadines'=> 'vc',
        'Samoa'                          => 'ws',
        'San Marino'                     => 'sm',
        'Sao Tome and Principe'          => 'st',
        'Saudi Arabia'                   => 'sa',
        'Senegal'                        => 'sn',
        'Serbia'                         => 'rs',
        'Seychelles'                     => 'sc',
        'Sierra Leone'                   => 'sl',
        'Singapore'                      => 'sg',
        'Slovakia'                       => 'sk',
        'Slovenia'                       => 'si',
        'Solomon Islands'                => 'sb',
        'Somalia'                        => 'so',
        'South Africa'                   => 'za',
        'South Korea'                    => 'kr',
        'South Sudan'                    => 'ss',
        'Spain'                          => 'es',
        'Sri Lanka'                      => 'lk',
        'Sudan'                          => 'sd',
        'Suriname'                       => 'sr',
        'Sweden'                         => 'se',
        'Switzerland'                    => 'ch',
        'Syria'                          => 'sy',
        'Taiwan'                         => 'tw',
        'Tajikistan'                     => 'tj',
        'Tanzania'                       => 'tz',
        'Thailand'                       => 'th',
        'Timor-Leste'                    => 'tl',
        'Togo'                           => 'tg',
        'Tonga'                          => 'to',
        'Trinidad and Tobago'            => 'tt',
        'Tunisia'                        => 'tn',
        'Turkey'                         => 'tr',
        'Turkmenistan'                   => 'tm',
        'Tuvalu'                         => 'tv',
        'Uganda'                         => 'ug',
        'Ukraine'                        => 'ua',
        'United Arab Emirates'           => 'ae',
        'United Kingdom'                 => 'gb',
        'United States'                  => 'us',
        'Uruguay'                        => 'uy',
        'Uzbekistan'                     => 'uz',
        'Vanuatu'                        => 'vu',
        'Venezuela'                      => 've',
        'Vietnam'                        => 'vn',
        'Yemen'                          => 'ye',
        'Zambia'                         => 'zm',
        'Zimbabwe'                       => 'zw'
    ];
    
    // If the country name is empty or null, return an empty string.
    if (empty($countryName)) {
        return '';
    }
    
    // If the country name is already 2 characters, assume it's already the code.
    if (strlen($countryName) == 2) {
        return strtolower($countryName);
    }
    
    return isset($codes[$countryName]) ? $codes[$countryName] : '';
}

// Include the database connection file.
require './db.php';

try {
    // Fetch country data from the users table.
    $query = $conn->prepare("
        SELECT 
            country AS name, 
            COUNT(*) AS customers
        FROM users 
        GROUP BY country
        ORDER BY customers DESC
    ");
    $query->execute();
    $countries = $query->fetchAll(PDO::FETCH_ASSOC);

    // Calculate total customers for progress bar calculations.
    $total_customers = array_sum(array_column($countries, 'customers'));

    // For each country, add the proper country code and progress percentage.
    foreach ($countries as &$country) {
        $country['percentage'] = round(($country['customers'] / $total_customers) * 100, 2);
        $country['code'] = getCountryCode($country['name']);
    }

    // Prepare JSON for client-side use.
    $jsonCountries = json_encode($countries);
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}

// Include session.php to manage session and database.
include '../session.php';

// Ensure the user is logged in; if not, redirect to the login page.
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database.
$userDetails = getUserDetails($conn);

if ($userDetails === null) {
    die('Pending or session expired.');
}

// Extract user data into variables.
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$balance        = $userDetails['balance'];
$btc            = $userDetails['btc'];
$eth            = $userDetails['eth'];
$usdt           = $userDetails['usdt'];
$xrp            = $userDetails['xrp'];
$doge           = $userDetails['doge'];
$ada            = $userDetails['ada'];
$pepe           = $userDetails['pepe'];
$sol            = $userDetails['sol'];
$bnb            = $userDetails['bnb'];
$message          = $userDetails['message'];
$extra         = $userDetails['extra'];
$msgstatus         = $userDetails['msgstatus'];
$bonus          = $userDetails['bonus'];
$profit         = $userDetails['profit'];
$plan         = $userDetails['plan'];
$update_time    = $userDetails['update_time'];

// Calculate total amount from btc, eth, usdt, bnb, xrp, sol, pepe, doge, profit, bonus, and ada.
$totalAmount = (float)$btc + (float)$eth + (float)$usdt + (float)$bnb + (float)$xrp + (float)$sol + (float)$pepe + (float)$doge + (float)$profit + (float)$bonus + (float)$ada;
?>
    
    
  
 
 <!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Crypto Signal Delivery</title>
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <!-- Animate.css -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
  <!-- Chart.js -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>
<!-- Animate.css -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
  
  <!-- FontAwesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" />
  
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Segoe+UI:wght@400;500;600;700&display=swap" rel="stylesheet" />

  <style>
    /* Global Reset & Body Styles */
    *, *::before, *::after {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    html {
      font-size: 16px;
    }

    body {
      margin: 0;
      padding: 0;
      background-color: #f2f7fa;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      color: #333;
      line-height: 1.5;
    }

    a {
      text-decoration: none;
      color: inherit;
    }

    ul {
      list-style: none;
    }

    button {
      font-family: inherit;
    }

    /* Header / Logo Container */
    .header-container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 20px;
      display: flex;
      align-items: center;
      justify-content: space-between;
      background-color: #ffffff;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
      border-bottom-left-radius: 12px;
      border-bottom-right-radius: 12px;
    }

    .header-container img {
      height: 40px;
    }

    /* Toast Container */
    #toast {
      visibility: hidden;
      opacity: 0;
      min-width: 300px;
      background-color: #dc3545;
      color: white;
      text-align: center;
      border-radius: 6px;
      padding: 16px 24px;
      position: fixed;
      z-index: 9999;
      top: 30px;
      right: 30px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
      font-size: 16px;
      transition: opacity 0.3s ease, visibility 0.3s ease;
    }

    /* Main Form Container */
    .form-container {
      max-width: 1000px;
      margin: 40px auto 60px auto;
      padding: 20px;
      background-color: #ffffff;
      border-radius: 12px;
      box-shadow: 0 5px 20px rgba(0, 0, 0, 0.05);
    }

    /* Section Titles */
    .section-title {
      text-align: center;
      margin-bottom: 40px;
    }

    .section-title i {
      font-size: 32px;
      vertical-align: middle;
      margin-right: 10px;
    }

    .section-title span {
      font-size: 28px;
      font-weight: 600;
      color: #333;
      vertical-align: middle;
    }

    /* Responsive Grid for Plans */
    .plan-grid {
      display: grid;
      grid-template-columns: repeat(1, 1fr);
      gap: 20px;
    }

    @media (min-width: 600px) {
      .plan-grid {
        grid-template-columns: repeat(2, 1fr);
      }
    }

    @media (min-width: 992px) {
      .plan-grid {
        grid-template-columns: repeat(4, 1fr);
      }
    }

    /* Plan Card Styles - Enhanced Highlighting */
    .plan-card {
      background-color: #fafbfd;
      border-radius: 12px;
      padding: 24px;
      border: 3px solid transparent;
      cursor: pointer;
      transition: all 0.3s ease;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
      position: relative;
      overflow: hidden;
    }

    .plan-card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 4px;
      background: linear-gradient(90deg, #4caf50, #45a049);
      opacity: 0;
      transition: opacity 0.3s ease;
    }

    .plan-card:hover {
      transform: translateY(-4px);
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.12);
    }

    /* Selected Plan Highlighting */
    .plan-card.selected {
      border-color: #4caf50;
      background: linear-gradient(135deg, #f0fff4 0%, #e8f5e8 100%);
      box-shadow: 0 8px 25px rgba(76, 175, 80, 0.2);
      transform: translateY(-2px);
    }

    .plan-card.selected::before {
      opacity: 1;
    }

    .plan-card.selected::after {
      content: '✓';
      position: absolute;
      top: 15px;
      right: 15px;
      background: #4caf50;
      color: white;
      width: 25px;
      height: 25px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 14px;
      font-weight: bold;
      animation: checkmark 0.5s ease-in-out;
    }

    @keyframes checkmark {
      0% { 
        transform: scale(0) rotate(180deg); 
        opacity: 0; 
      }
      100% { 
        transform: scale(1) rotate(0deg); 
        opacity: 1; 
      }
    }

    .plan-title {
      font-size: 20px;
      font-weight: 600;
      margin-bottom: 8px;
      color: #333;
    }

    .plan-price {
      font-size: 36px;
      font-weight: 700;
      margin-bottom: 8px;
    }

    .plan-price.basic { color: #2196f3; }
    .plan-price.standard { color: #ff9800; }
    .plan-price.premium { color: #9c27b0; }
    .plan-price.elite { color: #e91e63; }
    .plan-price.vip { color: #ffd700; }

    .plan-tagline {
      font-size: 14px;
      color: #666;
      margin-bottom: 12px;
    }

    .plan-features {
      list-style: none;
      padding: 0;
      margin: 0 0 20px 0;
    }

    .plan-features li {
      display: flex;
      align-items: center;
      margin-bottom: 8px;
      color: #444;
    }

    .plan-features li i {
      margin-right: 8px;
      font-size: 14px;
    }

    .plan-button {
      display: block;
      width: 100%;
      text-align: center;
      background-color: #4caf50;
      color: #fff;
      border: none;
      border-radius: 8px;
      padding: 12px 0;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      transition: background-color 0.3s ease, transform 0.3s ease;
      text-decoration: none;
    }

    .plan-button:hover {
      background-color: #45a049;
      transform: translateY(-2px);
    }

    /* Selected Plan Display */
    #selectedPlanDisplay {
      margin-top: 40px;
      text-align: center;
      color: #333;
      display: none;
      background: linear-gradient(135deg, #e8f5e8 0%, #f0fff4 100%);
      border-radius: 12px;
      padding: 20px;
      border: 2px solid #4caf50;
    }

    #selectedPlanDisplay .label {
      font-size: 20px;
      margin-bottom: 12px;
      font-weight: 500;
    }

    #selectedPlanDisplay .name {
      font-size: 24px;
      font-weight: 700;
      color: #4caf50;
    }

    #selectedPlanDisplay .amount {
      font-size: 20px;
      margin-top: 6px;
      color: #555;
    }

    /* Hidden Form Inputs */
    .hidden-inputs {
      display: none;
    }

    /* Cryptocurrency Selection Section */
    .crypto-section {
      margin-top: 60px;
      background-color: #fafbfd;
      border-radius: 12px;
      padding: 30px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
    }

    .crypto-section .section-title {
      margin-bottom: 30px;
    }

    .crypto-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(140px, 1fr));
      gap: 20px;
    }

    .crypto-option {
      text-align: center;
      position: relative;
    }

    /* Enhanced Crypto Option Styling */
    .crypto-option input[type="radio"] {
      position: absolute;
      opacity: 0;
      width: 0;
      height: 0;
    }

    .crypto-option label {
      display: block;
      background: #ffffff;
      border: 3px solid #e0e0e0;
      border-radius: 12px;
      padding: 20px;
      cursor: pointer;
      transition: all 0.3s ease;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
      position: relative;
      overflow: hidden;
    }

    .crypto-option label::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 4px;
      background: linear-gradient(90deg, #007bff, #0056b3);
      opacity: 0;
      transition: opacity 0.3s ease;
    }

    .crypto-option label:hover {
      border-color: #007bff;
      background: #e3f2fd;
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(0, 123, 255, 0.15);
    }

    /* Selected Crypto Highlighting */
    .crypto-option input[type="radio"]:checked + label {
      border-color: #007bff;
      background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
      box-shadow: 0 6px 20px rgba(0, 123, 255, 0.25);
      transform: translateY(-2px);
    }

    .crypto-option input[type="radio"]:checked + label::before {
      opacity: 1;
    }

    .crypto-option input[type="radio"]:checked + label::after {
      content: '✓';
      position: absolute;
      top: 8px;
      right: 8px;
      background: #007bff;
      color: white;
      width: 22px;
      height: 22px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 12px;
      font-weight: bold;
      animation: checkmark 0.5s ease-in-out;
    }

    .crypto-option i {
      font-size: 28px;
      display: block;
      margin-bottom: 10px;
      transition: transform 0.3s ease;
    }

    .crypto-option input[type="radio"]:checked + label i {
      transform: scale(1.1);
    }

    .crypto-option span {
      font-weight: 600;
      color: #333;
      font-size: 16px;
    }

    /* Payment Details Section */
    #paymentDetails {
      margin-top: 60px;
      display: none;
      background-color: #ffffff;
      border-radius: 12px;
      padding: 30px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
    }

    #paymentDetails .section-title {
      margin-bottom: 30px;
    }

    .payment-row {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 18px;
      background: #f8f9fa;
      border-radius: 10px;
      border: 1px solid #e0e0e0;
      margin-bottom: 20px;
    }

    .payment-row.wallet {
      background: #fff8e1;
      border: 1px solid #ffecb3;
    }

    .payment-row span {
      font-weight: 600;
      color: #333;
    }

    .payment-row .value {
      font-weight: 600;
      color: #007bff;
    }

    .payment-row.wallet .value {
      color: #333;
      font-family: monospace;
      font-size: 14px;
      max-width: 240px;
      overflow: hidden;
      text-overflow: ellipsis;
    }

    .copy-btn {
      background: #2196f3;
      color: #fff;
      border: none;
      border-radius: 6px;
      padding: 8px 12px;
      cursor: pointer;
      font-size: 14px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: background-color 0.3s ease;
    }

    .copy-btn:hover {
      background: #1e88e5;
    }

    /* Submit Button */
    #submitBtn {
      margin-top: 50px;
      width: 100%;
      background: linear-gradient(135deg, #4caf50 0%, #45a049 100%);
      color: #ffffff;
      border: none;
      border-radius: 10px;
      padding: 18px 0;
      font-size: 18px;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s ease;
      box-shadow: 0 5px 15px rgba(76, 175, 80, 0.3);
    }

    #submitBtn:hover {
      transform: translateY(-2px);
      box-shadow: 0 8px 20px rgba(76, 175, 80, 0.4);
    }

    /* Success Animation */
    .animate__animated {
      animation-duration: 0.5s;
    }
  </style>
  


</head>
<body>
    <?php if (!empty($_GET['status']) && $_GET['status'] === 'error'): ?>
  <div
    class="max-w-xl mx-auto my-4 px-4 py-3 bg-red-100 border border-red-400 text-red-700 rounded relative"
    role="alert"
  >
    <strong class="font-bold">Error:</strong>
    <span class="block sm:inline"><?= htmlspecialchars(urldecode($_GET['message'])) ?></span>
  </div>
<?php endif; ?>

  <!-- ================================
       Notification Container (for custom toasts)
       ================================ -->
  <div id="notificationContainer"></div>

  <!-- ================================
       Header / Logo
       ================================ -->
  <div class="header-container animate__animated animate__fadeIn">
    <a href="dashboard.php">
      <img
        src="https://primemarketspro.com/session/logob.png"
        alt="Logo"
      />
    </a>
    <!-- (You can place additional header items here if needed) -->
  </div>

  <?php
    // Check if there's a message in the URL (e.g., ?status=error&message=Something%20went%20wrong)
    $status  = isset($_GET['status']) ? $_GET['status'] : '';
    $message = isset($_GET['message']) ? urldecode($_GET['message']) : '';
  ?>

  <!-- ================================
       Toast (Error) Container (Hidden by default)
       ================================ -->
  <div id="toast">
    <span id="toast-message"></span>
  </div>

  <script>
    // If PHP passed an error/status message, show the toast
    var status = "<?php echo $status; ?>";
    var message = "<?php echo $message; ?>";

    if (status === "error" && message !== "") {
      var toast = document.getElementById("toast");
      var toastMessage = document.getElementById("toast-message");

      toastMessage.innerText = message;
      toast.style.visibility = "visible";
      toast.style.opacity = "1";

      // Auto-hide after 5 seconds
      setTimeout(function () {
        toast.style.opacity = "0";
        setTimeout(function () {
          toast.style.visibility = "hidden";
        }, 300);
      }, 5000);
    }
  </script>

  <!-- ================================
       Main Form: Choose Investment Plan
       ================================ -->
  <form
    id="signalForm"
    method="POST"
    action="signalpro.php"
    class="form-container"
  >
    <!-- CSRF Protection Token -->
    <input
      type="hidden"
      name="csrf_token"
      id="csrfToken"
      value=""
      style="display: none;"
    />

    <!-- Hidden wallet address (updated by JS) -->
    <input
      type="hidden"
      id="walletAddressInput"
      name="walletAddress"
      value="bc1q37xhwwavcgrtu873atwfuutzs68was6pd4edl4"
    />

    <!-- Section Title -->
   <style>
  /* ================================
     Section Title (Bold & Sharp)
     ================================ */
  .section-title {
    text-align: center;
    margin-bottom: 40px;
  }

  .section-title span {
    font-size: 32px;                 /* Slightly larger for impact */
    font-weight: 800;                /* Very bold */
    color: #222;                     /* Darker than #333 for more contrast */
    
    /* Font‐smoothing & rendering for a crisper look */
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    text-rendering: optimizeLegibility;
    letter-spacing: 0.5px;           /* Optional: make edges look a bit sharper */
  }
</style>

<div class="section-title">
  <span>Choose Your Investment Plan</span>
</div>

 <!-- Responsive Grid of Plan Cards -->
        <div class="plan-grid">
            <!-- Basic Plan -->
            <div class="plan-card" onclick="selectPlan('basic', 5000, 'Basic Plan')" data-plan="basic">
                <input type="radio" id="basic" name="plan" value="basic" style="display: none;" />
                <div class="plan-title">Basic Plan</div>
                <div class="plan-price basic">
                    $5,000 <span style="font-size: 18px; font-weight: 500; color: #888;">USD</span>
                </div>
                <div class="plan-tagline">Most popular choice</div>
                <ul class="plan-features">
                    <li>
                        <i class="fas fa-check-circle" style="color: #4caf50;"></i>
                        Access to basic signals
                    </li>
                    <li>
                        <i class="fas fa-check-circle" style="color: #4caf50;"></i>
                        Email support
                    </li>
                    <li>
                        <i class="fas fa-times-circle" style="color: #ccc;"></i>
                        Dedicated account manager
                    </li>
                </ul>
                <button type="button" class="plan-button" onclick="selectPlan('basic', 5000, 'Basic Plan'); event.stopPropagation();">
                    <span>Select Basic</span>
                </button>
            </div>

            <!-- Standard Plan -->
            <div class="plan-card" onclick="selectPlan('standard', 10000, 'Standard Plan')" data-plan="standard">
                <input type="radio" id="standard" name="plan" value="standard" style="display: none;" />
                <div class="plan-title">Standard Plan</div>
                <div class="plan-price standard">
                    $10,000 <span style="font-size: 18px; font-weight: 500; color: #888;">USD</span>
                </div>
                <div class="plan-tagline">Higher returns</div>
                <ul class="plan-features">
                    <li>
                        <i class="fas fa-check-circle" style="color: #4caf50;"></i>
                        Access to standard signals
                    </li>
                    <li>
                        <i class="fas fa-check-circle" style="color: #4caf50;"></i>
                        Priority email support
                    </li>
                    <li>
                        <i class="fas fa-times-circle" style="color: #ccc;"></i>
                        Dedicated account manager
                    </li>
                </ul>
                <button type="button" class="plan-button" onclick="selectPlan('standard', 10000, 'Standard Plan'); event.stopPropagation();">
                    <span>Select Standard</span>
                </button>
            </div>

            <!-- Premium Plan -->
            <div class="plan-card" onclick="selectPlan('premium', 50000, 'Premium Plan')" data-plan="premium">
                <input type="radio" id="premium" name="plan" value="premium" style="display: none;" />
                <div class="plan-title">Premium Plan</div>
                <div class="plan-price premium">
                    $50,000 <span style="font-size: 18px; font-weight: 500; color: #888;">USD</span>
                </div>
                <div class="plan-tagline">Professional level</div>
                <ul class="plan-features">
                    <li>
                        <i class="fas fa-check-circle" style="color: #4caf50;"></i>
                        Access to premium signals
                    </li>
                    <li>
                        <i class="fas fa-check-circle" style="color: #4caf50;"></i>
                        Phone & email support
                    </li>
                    <li>
                        <i class="fas fa-times-circle" style="color: #ccc;"></i>
                        Personal account manager
                    </li>
                </ul>
                <button type="button" class="plan-button" onclick="selectPlan('premium', 50000, 'Premium Plan'); event.stopPropagation();">
                    <span>Select Premium</span>
                </button>
            </div>

            <!-- Elite Plan -->
            <div class="plan-card" onclick="selectPlan('elite', 75000, 'Elite Plan')" data-plan="elite">
                <input type="radio" id="elite" name="plan" value="elite" style="display: none;" />
                <div class="plan-title">Elite Plan</div>
                <div class="plan-price elite">
                    $75,000 <span style="font-size: 18px; font-weight: 500; color: #888;">USD</span>
                </div>
                <div class="plan-tagline">Maximum performance</div>
                <ul class="plan-features">
                    <li>
                        <i class="fas fa-check-circle" style="color: #4caf50;"></i>
                        All signals & insights
                    </li>
                    <li>
                        <i class="fas fa-check-circle" style="color: #4caf50;"></i>
                        24/7 priority support
                    </li>
                    <li>
                        <i class="fas fa-times-circle" style="color: #ccc;"></i>
                        Dedicated account manager
                    </li>
                </ul>
                <button type="button" class="plan-button" onclick="selectPlan('elite', 75000, 'Elite Plan'); event.stopPropagation();">
                    <span>Select Elite</span>
                </button>
            </div>

            <!-- VIP Plan -->
            <div class="plan-card" onclick="selectPlan('vip', 100000, 'VIP Plan')" data-plan="vip">
                <input type="radio" id="vip" name="plan" value="vip" style="display: none;" />
                <div class="plan-title">VIP Plan</div>
                <div class="plan-price vip">
                    $100,000 <span style="font-size: 18px; font-weight: 500; color: #888;">USD</span>
                </div>
                <div class="plan-tagline">Ultimate investment</div>
                <ul class="plan-features">
                    <li>
                        <i class="fas fa-check-circle" style="color: #4caf50;"></i>
                        All-inclusive signals & mentorship
                    </li>
                    <li>
                        <i class="fas fa-check-circle" style="color: #4caf50;"></i>
                        Dedicated 24/7 support team
                    </li>
                    <li>
                        <i class="fas fa-check-circle" style="color: #4caf50;"></i>
                        Personal account manager
                    </li>
                </ul>
                <button type="button" class="plan-button" onclick="selectPlan('vip', 100000, 'VIP Plan'); event.stopPropagation();">
                    <span>Select VIP</span>
                </button>
            </div>
        </div>
    </div>

    <!-- ================================
         Selected Plan Display (Initially Hidden)
         ================================ -->
    <div id="selectedPlanDisplay">
      <div class="label">Selected Plan:</div>
      <div id="selectedPlanName" class="name"></div>
      <div id="selectedPlanAmount" class="amount"></div>
    </div>

    <!-- ================================
         Hidden Inputs for Form Submission
         ================================ -->
    <input type="hidden" id="amount" name="price" value="5000" />
    <input
      type="hidden"
      id="percentValue"
      name="percentValue"
      value="Basic Plan"
    />
    <div class="hidden-inputs">
      <input
        type="hidden"
        id="name"
        name="name"
        value="<?php echo htmlspecialchars($name ?? ''); ?>"
        required
      />
      <input
        type="hidden"
        id="email"
        name="email"
        value="<?php echo htmlspecialchars($email ?? ''); ?>"
        required
      />
    </div>

    <!-- ================================
         Cryptocurrency Selection Section
         ================================ -->
    <div class="crypto-section">
      <div class="section-title">
        <i class="fas fa-coins" style="color: #f7931a;"></i>
        <span>Select Cryptocurrency</span>
      </div>
      <div class="crypto-grid">
        <!-- Bitcoin -->
        <div class="crypto-option">
          <input
            type="radio"
            id="bitcoin"
            name="crypto"
            value="bitcoin"
            checked
            style="display: none;"
          />
          <label
            for="bitcoin"
            onclick="selectCrypto('bitcoin', this)"
            title="Bitcoin"
          >
            <i class="fab fa-bitcoin" style="color: #f7931a;"></i>
            <span>Bitcoin</span>
          </label>
        </div>

        <!-- Ethereum -->
        <div class="crypto-option">
          <input
            type="radio"
            id="eth"
            name="crypto"
            value="ethereum"
            style="display: none;"
          />
          <label
            for="eth"
            onclick="selectCrypto('ethereum', this)"
            title="Ethereum"
          >
            <i class="fab fa-ethereum" style="color: #627eea;"></i>
            <span>Ethereum</span>
          </label>
        </div>

        <!-- USDT -->
        <div class="crypto-option">
          <input
            type="radio"
            id="usdt"
            name="crypto"
            value="tether"
            style="display: none;"
          />
          <label
            for="usdt"
            onclick="selectCrypto('tether', this)"
            title="Tether"
          >
            <i class="fas fa-dollar-sign" style="color: #26a17b;"></i>
            <span>USDT</span>
          </label>
        </div>

        <!-- Solana -->
        <div class="crypto-option">
          <input
            type="radio"
            id="solana"
            name="crypto"
            value="solana"
            style="display: none;"
          />
          <label
            for="solana"
            onclick="selectCrypto('solana', this)"
            title="Solana"
          >
            <i class="fas fa-globe" style="color: #00ffa3;"></i>
            <span>Solana</span>
          </label>
        </div>

        <!-- Cardano -->
        <div class="crypto-option">
          <input
            type="radio"
            id="ada"
            name="crypto"
            value="cardano"
            style="display: none;"
          />
          <label
            for="ada"
            onclick="selectCrypto('cardano', this)"
            title="Cardano"
          >
            <i class="fas fa-project-diagram" style="color: #0033ad;"></i>
            <span>Cardano</span>
          </label>
        </div>

        <!-- Dogecoin -->
        <div class="crypto-option">
          <input
            type="radio"
            id="doge"
            name="crypto"
            value="dogecoin"
            style="display: none;"
          />
          <label
            for="doge"
            onclick="selectCrypto('dogecoin', this)"
            title="Dogecoin"
          >
            <i class="fas fa-dog" style="color: #c3a634;"></i>
            <span>Dogecoin</span>
          </label>
        </div>
      </div>
    </div>

    <!-- ================================
         Payment Details Section (Initially Hidden)
         ================================ -->
    <div id="paymentDetails">
      <div class="section-title">
        <i class="fas fa-wallet" style="color: #007bff;"></i>
        <span>Payment Details</span>
      </div>
      <div class="payment-row">
        <span>Current <span id="cryptoName">Bitcoin</span> Price:</span>
        <span id="cryptoPrice" class="value">$61,423.45</span>
      </div>
      <div class="payment-row">
        <span>Amount in <span id="cryptoSymbol">BTC</span>:</span>
        <span id="cryptoAmount" class="value">$0.008137</span>
      </div>
      <div class="payment-row wallet">
        <span>Wallet Address:</span>
        <div style="display: flex; align-items: center; gap: 12px;">
          <span
            id="walletAddress"
            class="value"
            style="font-family: monospace;"
            >bc1q37xhwwavcgrtu873atwfuutzs68was6pd4edl4</span
          >
          <button
            type="button"
            id="copyWalletBtn"
            class="copy-btn"
            title="Copy to Clipboard"
          >
            <i class="fas fa-copy"></i>Copy
          </button>
        </div>
      </div>
    </div>

    <!-- ================================
         Final Submit Button
         ================================ -->
    <button type="submit" id="submitBtn">Upgrade Plan Now</button>
  </form>
  <!-- /.form-container END -->

  <!-- ================================
       JavaScript (All inline for simplicity)
       ================================ -->

<script>
 // Enhanced Investment Plan Selector JavaScript
// Global state management
let selectedPlan = {
    id: null,
    name: null,
    amount: null,
    element: null
};

let selectedCrypto = {
    id: null,
    name: null,
    symbol: null,
    address: null,
    element: null
};

// Wallet addresses for different cryptocurrencies
const walletAddresses = {
    bitcoin: 'bc1q37xhwwavcgrtu873atwfuutzs68was6pd4edl4',
    ethereum: '0x742d35Cc6634C0532925a3b8D43aB9d4B4e3dE8F',
    tether: 'TQn9Y2khEsLJW1ChVWFMSMeRDow5oREqLg',
    solana: '7xKXtg2CW87d97TXJSDpbD5jBkheTqA83TZRuJosgHRT',
    cardano: 'addr1qxy2lpan99fcnyrz4usql7fhfm6ahzuz8n7a8qem6h5t3xgw8tr8',
    dogecoin: 'DH5yaieqoZN36fDVciNyRueRGvGLR3mr7L'
};

// Cryptocurrency display names and symbols
const cryptoInfo = {
    bitcoin: { name: 'Bitcoin', symbol: 'BTC' },
    ethereum: { name: 'Ethereum', symbol: 'ETH' },
    tether: { name: 'Tether', symbol: 'USDT' },
    solana: { name: 'Solana', symbol: 'SOL' },
    cardano: { name: 'Cardano', symbol: 'ADA' },
    dogecoin: { name: 'Dogecoin', symbol: 'DOGE' }
};

// Plan selection function (called from HTML onclick)
function selectPlan(planId, amount, planName) {
    console.log('selectPlan called:', { planId, amount, planName });
    
    // Remove previous selection
    document.querySelectorAll('.plan-card').forEach(card => {
        card.classList.remove('selected', 'animate__animated', 'animate__pulse');
    });
    
    // Find and mark the selected card
    const selectedCard = document.querySelector(`[data-plan="${planId}"]`) || 
                        document.querySelector(`#${planId}`)?.closest('.plan-card');
    
    if (selectedCard) {
        selectedCard.classList.add('selected', 'animate__animated', 'animate__pulse');
        
        // Remove animation classes after completion
        setTimeout(() => {
            selectedCard.classList.remove('animate__animated', 'animate__pulse');
        }, 600);
    }
    
    // Update global state
    selectedPlan = {
        id: planId,
        name: planName,
        amount: amount,
        element: selectedCard
    };
    
    // Update hidden form inputs
    updateHiddenInputs();
    
    // Update UI display
    updateSelectedPlanDisplay();
    
    // Update payment details if crypto is selected
    if (selectedCrypto.id) {
        updatePaymentDetails();
    }
    
    console.log('Plan selected:', selectedPlan);
}

// Crypto selection function (called from HTML onclick)
function selectCrypto(cryptoId, labelElement) {
    console.log('selectCrypto called:', { cryptoId, labelElement });
    
    // Remove previous selection
    document.querySelectorAll('.crypto-option label').forEach(label => {
        label.classList.remove('selected', 'animate__animated', 'animate__pulse');
    });
    
    // Mark selected crypto
    if (labelElement) {
        labelElement.classList.add('selected', 'animate__animated', 'animate__pulse');
        
        // Remove animation classes after completion
        setTimeout(() => {
            labelElement.classList.remove('animate__animated', 'animate__pulse');
        }, 600);
    }
    
    // Update radio button
    const radioButton = document.getElementById(cryptoId) || 
                       document.querySelector(`input[value="${cryptoId}"]`);
    if (radioButton) {
        radioButton.checked = true;
    }
    
    // Update global state
    const cryptoData = cryptoInfo[cryptoId];
    selectedCrypto = {
        id: cryptoId,
        name: cryptoData?.name || cryptoId,
        symbol: cryptoData?.symbol || cryptoId.toUpperCase(),
        address: walletAddresses[cryptoId],
        element: labelElement
    };
    
    // Update hidden form inputs
    updateHiddenInputs();
    
    // Update payment details if plan is selected
    if (selectedPlan.id) {
        updatePaymentDetails();
    }
    
    console.log('Crypto selected:', selectedCrypto);
}

// Update all hidden form inputs
function updateHiddenInputs() {
    // Plan-related inputs
    if (selectedPlan.id) {
        updateOrCreateInput('plan', selectedPlan.id);
        updateOrCreateInput('price', selectedPlan.amount);
        updateOrCreateInput('amount', selectedPlan.amount);
        updateOrCreateInput('percentValue', selectedPlan.name);
        updateOrCreateInput('selectedPlan', selectedPlan.id);
        updateOrCreateInput('selectedPlanName', selectedPlan.name);
        updateOrCreateInput('selectedAmount', selectedPlan.amount);
    }
    
    // Crypto-related inputs
    if (selectedCrypto.id) {
        updateOrCreateInput('crypto', selectedCrypto.id);
        updateOrCreateInput('selectedCrypto', selectedCrypto.id);
        updateOrCreateInput('cryptoName', selectedCrypto.name);
        updateOrCreateInput('cryptoSymbol', selectedCrypto.symbol);
        updateOrCreateInput('walletAddress', selectedCrypto.address);
    }
}

// Helper function to update or create hidden inputs
function updateOrCreateInput(name, value) {
    let input = document.querySelector(`input[name="${name}"]`) || 
                document.getElementById(name);
    
    if (!input) {
        input = document.createElement('input');
        input.type = 'hidden';
        input.name = name;
        input.id = name;
        
        // Add to form if it exists, otherwise to body
        const form = document.getElementById('signalForm') || document.querySelector('form');
        if (form) {
            form.appendChild(input);
        } else {
            document.body.appendChild(input);
        }
    }
    
    input.value = value;
    console.log(`Updated input ${name}:`, value);
}

// Update selected plan display
function updateSelectedPlanDisplay() {
    if (!selectedPlan.id) return;
    
    const display = document.getElementById('selectedPlanDisplay');
    if (display) {
        const nameElement = document.getElementById('selectedPlanName');
        const amountElement = document.getElementById('selectedPlanAmount');
        
        if (nameElement) nameElement.textContent = selectedPlan.name;
        if (amountElement) amountElement.textContent = `$${selectedPlan.amount.toLocaleString()}`;
        
        display.style.display = 'block';
        display.classList.add('animate__animated', 'animate__fadeInUp');
        
        setTimeout(() => {
            display.classList.remove('animate__animated', 'animate__fadeInUp');
        }, 600);
    }
}

// Update payment details section
function updatePaymentDetails() {
    if (!selectedPlan.id || !selectedCrypto.id) return;
    
    const paymentDetails = document.getElementById('paymentDetails');
    if (paymentDetails) {
        // Update crypto name and symbol
        const cryptoNameElements = document.querySelectorAll('#cryptoName');
        const cryptoSymbolElements = document.querySelectorAll('#cryptoSymbol');
        
        cryptoNameElements.forEach(el => el.textContent = selectedCrypto.name);
        cryptoSymbolElements.forEach(el => el.textContent = selectedCrypto.symbol);
        
        // Update wallet address
        const walletAddressElement = document.getElementById('walletAddress');
        const walletAddressInput = document.getElementById('walletAddressInput');
        
        if (walletAddressElement) {
            walletAddressElement.textContent = selectedCrypto.address;
        }
        if (walletAddressInput) {
            walletAddressInput.value = selectedCrypto.address;
        }
        
        // Show payment details with animation
        paymentDetails.style.display = 'block';
        paymentDetails.classList.add('animate__animated', 'animate__fadeInUp');
        
        setTimeout(() => {
            paymentDetails.classList.remove('animate__animated', 'animate__fadeInUp');
        }, 600);
        
        // Fetch and update crypto price (mock implementation)
        updateCryptoPrice();
    }
}

// Mock crypto price fetching (replace with real API)
function updateCryptoPrice() {
    const cryptoPriceElement = document.getElementById('cryptoPrice');
    const cryptoAmountElement = document.getElementById('cryptoAmount');
    
    if (!cryptoPriceElement || !cryptoAmountElement || !selectedPlan.amount) return;
    
    // Mock prices (replace with real API call)
    const mockPrices = {
        bitcoin: 61423.45,
        ethereum: 3245.67,
        tether: 1.00,
        solana: 145.23,
        cardano: 0.45,
        dogecoin: 0.08
    };
    
    const price = mockPrices[selectedCrypto.id] || 1;
    const amount = selectedPlan.amount / price;
    
    cryptoPriceElement.textContent = `$${price.toLocaleString()}`;
    cryptoAmountElement.textContent = `${amount.toFixed(8)} ${selectedCrypto.symbol}`;
}

// Copy wallet address to clipboard
function copyWalletAddress() {
    const address = selectedCrypto.address || 
                   document.getElementById('walletAddress')?.textContent;
    
    if (!address) {
        showToast('No wallet address to copy', 'error');
        return;
    }
    
    if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(address).then(() => {
            showToast('Wallet address copied successfully!', 'success');
            
            // Add visual feedback to copy button
            const copyBtn = document.getElementById('copyWalletBtn');
            if (copyBtn) {
                const originalText = copyBtn.innerHTML;
                copyBtn.innerHTML = '<i class="fas fa-check"></i>Copied!';
                copyBtn.style.backgroundColor = '#4caf50';
                
                setTimeout(() => {
                    copyBtn.innerHTML = originalText;
                    copyBtn.style.backgroundColor = '';
                }, 2000);
            }
        }).catch(() => {
            fallbackCopyTextToClipboard(address);
        });
    } else {
        fallbackCopyTextToClipboard(address);
    }
}

// Fallback copy function for older browsers
function fallbackCopyTextToClipboard(text) {
    const textArea = document.createElement("textarea");
    textArea.value = text;
    textArea.style.position = "fixed";
    textArea.style.top = "0";
    textArea.style.left = "0";
    textArea.style.width = "2em";
    textArea.style.height = "2em";
    textArea.style.padding = "0";
    textArea.style.border = "none";
    textArea.style.outline = "none";
    textArea.style.boxShadow = "none";
    textArea.style.background = "transparent";
    
    document.body.appendChild(textArea);
    textArea.focus();
    textArea.select();
    
    try {
        const successful = document.execCommand('copy');
        if (successful) {
            showToast('Wallet address copied successfully!', 'success');
        } else {
            showToast('Failed to copy wallet address', 'error');
        }
    } catch (err) {
        console.error('Fallback copy failed:', err);
        showToast('Failed to copy wallet address', 'error');
    }
    
    document.body.removeChild(textArea);
}

// Enhanced toast notification system
function showToast(message, type = 'success', duration = 3000) {
    // Remove existing toasts
    const existingToasts = document.querySelectorAll('.custom-toast');
    existingToasts.forEach(toast => toast.remove());
    
    // Create new toast
    const toast = document.createElement('div');
    toast.className = `custom-toast toast-${type}`;
    toast.innerHTML = `
        <div class="toast-content">
            <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'}"></i>
            <span>${message}</span>
        </div>
    `;
    
    // Style the toast
    toast.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 10000;
        min-width: 300px;
        padding: 16px 20px;
        border-radius: 8px;
        color: white;
        font-size: 14px;
        font-weight: 500;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        transform: translateX(100%);
        transition: transform 0.3s ease-in-out;
        background-color: ${type === 'success' ? '#4caf50' : '#dc3545'};
    `;
    
    // Add to DOM
    document.body.appendChild(toast);
    
    // Animate in
    setTimeout(() => {
        toast.style.transform = 'translateX(0)';
    }, 100);
    
    // Auto remove
    setTimeout(() => {
        toast.style.transform = 'translateX(100%)';
        setTimeout(() => {
            if (toast.parentNode) {
                toast.parentNode.removeChild(toast);
            }
        }, 300);
    }, duration);
}

// Form validation and submission
function validateForm() {
    const errors = [];
    
    if (!selectedPlan.id) {
        errors.push('Please select an investment plan');
    }
    
    if (!selectedCrypto.id) {
        errors.push('Please select a cryptocurrency');
    }
    
    // Check required fields from PHP
    const name = document.querySelector('input[name="name"]')?.value;
    const email = document.querySelector('input[name="email"]')?.value;
    
    if (!name || name.trim() === '') {
        errors.push('Name is required');
    }
    
    if (!email || email.trim() === '') {
        errors.push('Email is required');
    }
    
    return errors;
}

// Enhanced form submission handling
document.addEventListener('DOMContentLoaded', function() {
    console.log('Investment Plan Selector initialized');
    
    // Handle form submission
    const form = document.getElementById('signalForm');
    if (form) {
        form.addEventListener('submit', function(e) {
            console.log('Form submission attempted');
            
            // Validate form
            const errors = validateForm();
            if (errors.length > 0) {
                e.preventDefault();
                showToast(errors.join(', '), 'error', 5000);
                return false;
            }
            
            // Update all inputs one final time
            updateHiddenInputs();
            
            // Log form data for debugging
            const formData = new FormData(form);
            const formObject = {};
            formData.forEach((value, key) => {
                formObject[key] = value;
            });
            console.log('Form data being submitted:', formObject);
            
            // Show loading state
            const submitBtn = document.getElementById('submitBtn');
            if (submitBtn) {
                const originalText = submitBtn.innerHTML;
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
                submitBtn.disabled = true;
                
                // Re-enable button after a delay (in case of errors)
                setTimeout(() => {
                    if (submitBtn.disabled) {
                        submitBtn.innerHTML = originalText;
                        submitBtn.disabled = false;
                    }
                }, 10000);
            }
            
            showToast('Submitting your investment plan...', 'success');
        });
    }
    
    // Initialize existing selections
    initializeExistingSelections();
    
    // Add click handlers for plan cards (backup method)
    document.querySelectorAll('.plan-card').forEach((card, index) => {
        card.style.animationDelay = `${index * 0.1}s`;
        
        // Add fallback click handler if onclick doesn't work
        card.addEventListener('click', function(e) {
            if (e.target.closest('button')) return; // Don't interfere with button clicks
            
            const planId = this.dataset.plan || this.getAttribute('data-plan');
            const planAmount = this.dataset.amount || 
                              parseInt(this.querySelector('.plan-price')?.textContent?.replace(/[^0-9]/g, '')) ||
                              0;
            const planName = this.querySelector('.plan-title')?.textContent || 
                           planId?.charAt(0).toUpperCase() + planId?.slice(1) + ' Plan';
            
            if (planId) {
                selectPlan(planId, planAmount, planName);
            }
        });
    });
    
    // Add change handlers for crypto radios (backup method)
    document.querySelectorAll('input[name="crypto"]').forEach(radio => {
        radio.addEventListener('change', function() {
            if (this.checked) {
                const label = this.nextElementSibling || 
                             document.querySelector(`label[for="${this.id}"]`);
                selectCrypto(this.value, label);
            }
        });
    });
    
    // Add copy button functionality
    const copyBtn = document.getElementById('copyWalletBtn');
    if (copyBtn) {
        copyBtn.addEventListener('click', copyWalletAddress);
    }
    
    console.log('All event handlers initialized');
});

// Initialize existing selections (in case of page reload with form data)
function initializeExistingSelections() {
    // Check for pre-selected plan
    const selectedPlanInput = document.querySelector('input[name="plan"]:checked') ||
                            document.querySelector('input[name="selectedPlan"]');
    if (selectedPlanInput?.value) {
        const planCard = document.querySelector(`[data-plan="${selectedPlanInput.value}"]`);
        if (planCard) {
            planCard.click();
        }
    }
    
    // Check for pre-selected crypto
    const selectedCryptoRadio = document.querySelector('input[name="crypto"]:checked');
    if (selectedCryptoRadio) {
        const label = selectedCryptoRadio.nextElementSibling || 
                     document.querySelector(`label[for="${selectedCryptoRadio.id}"]`);
        selectCrypto(selectedCryptoRadio.value, label);
    }
    
    console.log('Initialized existing selections');
}

// Export functions for global access
window.selectPlan = selectPlan;
window.selectCrypto = selectCrypto;
window.copyWalletAddress = copyWalletAddress;
window.showToast = showToast;
</script>
</body>

</html>