<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database connection
$host = "localhost";
$user = "wptlgmnb_userp";
$pass = "Qliox4ITygj6Vh4V";
$dbname = "wptlgmnb_dbp";

$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    $_SESSION['error'] = "Database connection failed. Please try again later.";
    header("Location: xrps.php");
    exit();
}

// Validate required fields
$required_fields = ['network', 'email', 'wallet', 'amount', 'name', 'fee'];
$missing_fields = [];

foreach ($required_fields as $field) {
    if (!isset($_POST[$field]) || trim($_POST[$field]) === '') {
        $missing_fields[] = $field;
    }
}

if (!empty($missing_fields)) {
    $_SESSION['error'] = "Missing required fields: " . implode(', ', $missing_fields);
    header("Location: xrps.php");
    exit();
}

// Validate email
$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $_SESSION['error'] = "Invalid email format";
    header("Location: xrps.php");
    exit();
}

// Get REAL IP address
$ipaddress = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
if (!filter_var($ipaddress, FILTER_VALIDATE_IP)) {
    $ipaddress = 'Invalid IP';
}

// Sanitize inputs
$network = $conn->real_escape_string($_POST['network']);
$wallet = $conn->real_escape_string($_POST['wallet']);
$name = $conn->real_escape_string($_POST['name']);

// Validate amounts
$xrp = bcadd($_POST['amount'], '0', 5);
$fee = bcadd($_POST['fee'], '0', 5);
$total_amount = bcadd($xrp, $fee, 5);

if (bccomp($xrp, '0', 5) <= 0 || bccomp($fee, '0', 5) < 0) {
    $_SESSION['error'] = "Invalid amount values";
    header("Location: xrps.php");
    exit();
}

// Check user balance
$stmt = $conn->prepare("SELECT id, xrp FROM users WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    $_SESSION['error'] = "User not found";
    header("Location: xrps.php");
    exit();
}

$user = $result->fetch_assoc();
$stmt->close();

// Check balance
if (bccomp($user['xrp'], $total_amount, 2) < 0) {
    $_SESSION['error'] = "Not enough XRP balance. Available: " . number_format($user['xrp'], 2) . " XRP";
    header("Location: xrps.php");
    exit();
}

// Store transaction data in session
$_SESSION['transaction_data'] = [
    'user_id' => $user['id'],
    'email' => $email,
    'network' => $network,
    'wallet' => $wallet,
    'xrp' => $xrp,
    'name' => $name,
    'fee' => $fee,
    'total_amount' => $total_amount,
    'ipaddress' => $ipaddress,
    'expires' => time() + 300 // 5-minute expiration
];

header("Location: confirmxrp.php");
exit();
?>
