<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: application/json');

// Check if data is passed via GET
if (isset($_GET['transaction'])) {
    $transaction_data = json_decode($_GET['transaction'], true);

    if ($transaction_data) {
        echo json_encode([
            "success" => true,
            "message" => "Transaction successfully submitted!",
            "transaction" => $transaction_data
        ]);
    } else {
        echo json_encode([
            "error" => "Invalid transaction data.",
            "code" => 400
        ]);
    }
} else {
    echo json_encode([
        "error" => "No transaction data received.",
        "code" => 400
    ]);
}
?>
