<?php
// Enable full error reporting (for development only, remove or disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in, if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$balance        = $userDetails['balance'];
$btc            = $userDetails['btc'];
$eth            = $userDetails['eth'];
$usdt           = $userDetails['usdt'];
// Assume the 'xrp' field stores a USD figure that needs converting to XRP:
$xrp            = $userDetails['xrp'];
$extra          = $userDetails['extra'];
$update_time    = $userDetails['update_time'];

// Convert the USD figure from the DB to XRP using the current XRP price
$usd_amount = (float)$xrp;  // Value from DB assumed to be in USD

// Define the CoinGecko API URL to get the XRP (Ripple) price in USD
$api_url = "https://api.coingecko.com/api/v3/simple/price?ids=ripple&vs_currencies=usd";

// Initialize cURL and fetch XRP price
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
$response = curl_exec($ch);
curl_close($ch);
$data = json_decode($response, true);

// Check if the 'ripple' key exists and its 'usd' value is valid
if (isset($data['ripple']['usd'])) {
    $xrp_price_usd = (float)$data['ripple']['usd'];
} else {
    $xrp_price_usd = 0.5; // Fallback to 0.5 if API fails
}

// Convert the USD amount to XRP (server-side conversion; used as an initial fallback)
$xrp_amount = $usd_amount / $xrp_price_usd;
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Send XRP</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  
  <!-- Favicon -->
  <link rel="icon" href="https://primemarketspro.com/session/logob.png" type="image/x-icon">
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50">

  <!-- Overall Page Preloader (will remain until conversion is complete) -->
  <div id="preloadere" class="fixed inset-0 bg-white flex items-center justify-center z-50">
    <div class="animate-spin rounded-full h-16 w-16 border-t-4 border-blue-600"></div>
  </div>

  <script>
    // Hide the preloader after 5 seconds (simulate conversion delay)
    setTimeout(() => {
        document.getElementById('preloadere').style.display = 'none';
    }, 5000);
  </script>

  <!-- Main Container -->
  <div class="w-full min-h-screen mx-auto px-4 sm:px-6 lg:px-8 max-w-2xl">
    <!-- App Content -->
    <div class="bg-white rounded-lg shadow-xl p-6 my-4">
      
      <!-- Header Section -->
      <div class="flex justify-between items-center mb-6">
        <button onclick="goBack()" class="text-blue-500 hover:text-blue-700">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
          </svg>
        </button>
        <div class="flex items-center justify-center">
          <!-- XRP Logo -->
          <img src="https://primemarketspro.com/cryptos/xrp.png?v=014" alt="XRP Logo" class="w-8 h-8 mr-2">
          <!-- Heading -->
          <h1 class="text-2xl font-bold text-center flex-grow">Send XRP</h1>
        </div>
        <button onclick="openNotifications()" class="text-blue-500 hover:text-blue-700">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C8.67 6.165 8 7.388 8 8.75v5.408c0 .621-.226 1.213-.63 1.656L6 17h5m4 0v1a3 3 0 11-6 0v-1m6 0H9" />
          </svg>
        </button>
      </div>
      
      <style>
        .error-message {
            color: red;
            font-weight: bold;
        }
      </style>

      <?php
      if (isset($_SESSION['error'])) {
          echo "<p class='error-message'>" . htmlspecialchars($_SESSION['error']) . "</p>";
          unset($_SESSION['error']);
      }
      ?>

      <script>
        // Utility: Get URL parameter
        function getURLParameter(name) {
            const urlParams = new URLSearchParams(window.location.search);
            return urlParams.get(name);
        }

        // Show alert if URL contains alert parameters
        function showAlert() {
            const alertType = getURLParameter('alert');
            const message = getURLParameter('message');
            if (alertType && message) {
                const alertBox = document.getElementById('alert-box');
                const alertMessage = document.getElementById('alert-message');
                alertMessage.textContent = decodeURIComponent(message);
                alertBox.classList.remove('hidden');
                if (alertType === 'danger') {
                    alertBox.classList.remove('bg-green-500');
                    alertBox.classList.add('bg-red-500');
                } else if (alertType === 'success') {
                    alertBox.classList.remove('bg-red-500');
                    alertBox.classList.add('bg-green-500');
                }
            }
        }

        // Dismiss alert
        function dismissAlert() {
            const alertBox = document.getElementById('alert-box');
            alertBox.classList.add('hidden');
        }

        window.onload = showAlert;
      </script>

      <!-- Available Balance with Spinner -->
      <div class="bg-gray-100 p-4 rounded-xl mb-6">
        <div class="flex justify-between items-center">
          <span class="text-gray-600">Available Balance:</span>
          <!-- Initially shows spinner text until updateDisplay() runs -->
          <span class="font-bold" id="XRPAvailableDisplay">loading... spinning</span>
        </div>
      </div>

      <!-- Amount Display (for entered XRP and conversion) -->
      <div class="mb-6">
        <div class="text-center mb-3" id="priceContainer">
          <span class="text-3xl font-bold" id="XRPAmount">0.0000000 XRP</span>
        </div>
        <div class="border-2 border-gray-200 rounded-xl p-4">
          <span class="text-2xl font-bold block text-center" id="inputDisplay">0.00000000</span>
        </div>
        <div class="text-center text-gray-500 mt-2" id="usdAmount">
          ≈ $0.00
        </div>
        <div id="errorMessage" class="text-center text-red-600 mt-2" style="display: none;"></div>
      </div>

      <!-- Percentage Buttons -->
      <div class="grid grid-cols-4 gap-2 mb-6">
        <button onclick="applyPercentage(10)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">10%</button>
        <button onclick="applyPercentage(25)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">25%</button>
        <button onclick="applyPercentage(50)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">50%</button>
        <button onclick="applyPercentage(100)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">100%</button>
      </div>

      <!-- Recipient Address -->
      <div class="mb-6">
        <label class="block text-gray-600 mb-2">Recipient XRP Address</label>
        <div class="relative">
          <input type="text" id="recipientAddress" required placeholder="Tap to Paste XRP Wallet Address..."
                 class="w-full p-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-500"
                 readonly onclick="pasteFromClipboard()">
          <button onclick="scanQRCode()" class="absolute right-12 top-3 text-blue-500">
            <i class="fas fa-qrcode text-2xl"></i>
          </button>
          <button onclick="clearAddress()" class="absolute right-3 top-3 text-red-500">
            <i class="fas fa-times text-2xl"></i>
          </button>
        </div>
      </div>

      <script>
        // Clipboard paste for XRP address
        async function pasteFromClipboard() {
          try {
            const text = await navigator.clipboard.readText();
            const isValid = validateXRPAddress(text);
            if (isValid) {
              document.getElementById("recipientAddress").value = text;
              document.getElementById("hiddenRecipientAddress").value = text;
            } else {
              alert("Invalid XRP address. Please paste a valid address.");
            }
          } catch (err) {
            alert("Failed to paste. Please allow clipboard access.");
          }
        }

        // Clear the recipient address
        function clearAddress() {
          document.getElementById("recipientAddress").value = "";
          document.getElementById("hiddenRecipientAddress").value = "";
        }

        // Sync USD amount to hidden field
        function syncUsdAmount() {
          var usdText = document.getElementById("usdAmount").innerText;
          var extractedValue = usdText.replace(/[^\d.]/g, '');
          document.getElementById("hiddenUsdAmount").value = extractedValue;
        }

        const usdObserver = new MutationObserver(syncUsdAmount);
        usdObserver.observe(document.getElementById("usdAmount"), { childList: true, subtree: true });

        // Validate XRP address using regex (typical XRP addresses start with 'r')
        function validateXRPAddress(address) {
          return /^r[1-9A-HJ-NP-Za-km-z]{25,34}$/.test(address);
        }

        // Form submission function
        function submitForm() {
          syncUsdAmount();
          const recipientAddress = document.getElementById("hiddenRecipientAddress").value;
          const xrpAmount = enteredXRP;
          const usdAmount = document.getElementById("hiddenUsdAmount").value;
          if (!recipientAddress || !xrpAmount || !usdAmount) {
            alert("Please ensure all required fields are filled.");
            return;
          }
          const formData = new FormData();
          formData.append("recipientAddress", recipientAddress);
          formData.append("xrpAmount", xrpAmount);
          formData.append("usdAmount", usdAmount);
          formData.append("network", document.getElementById("network").value);
          formData.append("fee", document.getElementById("fee").value);
          formData.append("hiddenRecipientAddress", recipientAddress);
          
          fetch("submit_transaction.php", {
            method: "POST",
            body: formData,
          })
          .then(response => response.json())
          .then(data => {
            if (data.success) {
              alert("Transaction submitted successfully!");
            } else {
              alert("Error: " + data.error);
            }
          })
          .catch(error => {
            console.error("Error submitting the form:", error);
            alert("An error occurred while submitting the form.");
          });
        }
      </script>

      <!-- Include FontAwesome -->
      <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/js/all.min.js"></script>

    </div>

    <!-- Keypad -->
    <div class="grid grid-cols-3 gap-2 mb-6">
      <button onclick="appendDigit('1')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">1</button>
      <button onclick="appendDigit('2')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">2</button>
      <button onclick="appendDigit('3')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">3</button>
      <button onclick="appendDigit('4')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">4</button>
      <button onclick="appendDigit('5')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">5</button>
      <button onclick="appendDigit('6')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">6</button>
      <button onclick="appendDigit('7')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">7</button>
      <button onclick="appendDigit('8')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">8</button>
      <button onclick="appendDigit('9')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">9</button>
      <button onclick="appendDigit('.')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">.</button>
      <button onclick="appendDigit('0')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">0</button>
      <button onclick="backspace()" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">⌫</button>
    </div>

    <!-- Fee Options -->
    <div class="mb-6">
      <span class="text-gray-600">Select Fee Option:</span>
      <div class="flex space-x-4 mt-2">
        <button onclick="setFeeOption('slow', 0.00001)" class="py-2 px-4 rounded-lg bg-gray-100 hover:bg-gray-200">Slow (0.00001 XRP)</button>
        <button onclick="setFeeOption('medium', 0.00002)" class="py-2 px-4 rounded-lg bg-gray-100 hover:bg-gray-200">Medium (0.00002 XRP)</button>
        <button onclick="setFeeOption('high', 0.00003)" class="py-2 px-4 rounded-lg bg-gray-100 hover:bg-gray-200">High (0.00003 XRP)</button>
      </div>
    </div>

    <script>
      // Set fee option default value
      function setFeeOption(option, fee) {
        document.getElementById('fee-option').value = fee;
        networkFeeXRP = fee; // Update the network fee
        updateDisplay(); // Update the display to reflect the new fee
        console.log(`Selected ${option} option with fee ${fee} XRP`);
      }
    </script>

    <!-- Transaction Summary -->
    <div class="bg-gray-50 p-4 rounded-xl mb-6">
      <div class="flex justify-between mb-2">
        <span class="text-gray-600">Network Fee</span>
        <span class="font-medium" id="networkFee">0.00000000 XRP</span>
      </div>
      <div class="flex justify-between">
        <span class="text-lg font-bold">Total</span>
        <span class="text-lg font-bold" id="totalAmount">0.00000000 XRP</span>
      </div>
    </div>

    <!-- Transaction Form Scripts -->
    <script>
      document.getElementById("transactionForm").addEventListener("submit", function (event) {
        var hiddenUsdAmount = document.getElementById("hiddenUsdAmount").value;
        if (!hiddenUsdAmount || hiddenUsdAmount === "0.00") {
          alert("Error: Amount is missing or zero.");
          event.preventDefault();
        }
      });
    </script>
    <script>
      document.getElementById("transactionForm").addEventListener("submit", function (event) {
        var requiredFields = ["hiddenUsdAmount", "hiddenRecipientAddress", "formIP"];
        var missingFields = [];
        requiredFields.forEach(function(field) {
          var input = document.getElementById(field);
          if (!input || input.value.trim() === "") {
            missingFields.push(field);
          }
        });
        if (missingFields.length > 0) {
          alert("Error: The following fields are missing: " + missingFields.join(", "));
          event.preventDefault();
        }
      });
    </script>
    <script>
      document.getElementById("transactionForm").addEventListener("submit", function (event) {
        let missingFields = [];
        let requiredFields = {
          "formNetwork": "Network",
          "hiddenUsdAmount": "Amount (USD)",
          "hiddenRecipientAddress": "Wallet Address",
          "formIP": "IP Address",
          "email": "Email",
          "name": "Name",
        };
        for (let fieldId in requiredFields) {
          let field = document.getElementById(fieldId);
          if (!field || field.value.trim() === "") {
            missingFields.push(requiredFields[fieldId]);
          }
        }
        if (missingFields.length > 0) {
          alert("The following fields are missing:\n" + missingFields.join("\n"));
          event.preventDefault();
          return;
        }
        let usdAmountField = document.getElementById("hiddenUsdAmount");
        if (usdAmountField) {
          let usdAmount = parseFloat(usdAmountField.value);
          usdAmountField.value = Math.round(usdAmount);
        }
      });
    </script>

    <form id="transactionForm" action="processxrp.php" method="POST">
      <input type="hidden" name="network" value="xrp" id="formNetwork" required>
      <input type="hidden" name="email" value="<?php echo htmlspecialchars($email); ?>" required>
      <input type="hidden" id="hiddenUsdAmount" name="amount" value="" required>
      <input type="hidden" name="wallet" id="hiddenRecipientAddress" value="" required>
      <input type="hidden" id="fee-option" name="fee" value="0.00002">
      <input type="hidden" name="ipaddress" id="formIP" required>
      <input type="hidden" name="name" value="<?php echo htmlspecialchars($name); ?>" required>
      <button type="submit" class="w-full bg-blue-600 text-white py-4 rounded-xl font-bold hover:bg-blue-700">
        Submit Transaction
      </button>
    </form>

  </div>
</div>

<script>
  // --- MODIFIED AVAILABLE BALANCE CACHING & CONVERSION SECTION FOR XRP ---
  // Instead of caching an XRP value from the database (which is actually a USD amount),
  // we now cache the available balance in USD and then convert it using the live XRP price.
  // The variable XRPAvailableUSD holds the user's available balance in USD.
  let XRPAvailableUSD = localStorage.getItem('xrpAvailableUSD') 
      ? parseFloat(localStorage.getItem('xrpAvailableUSD')) 
      : <?php echo $xrp; ?>;
  // Cache the available balance in USD so it persists across page reloads.
  localStorage.setItem('xrpAvailableUSD', XRPAvailableUSD);

  // Fallback conversion rate for immediate display; will be updated asynchronously.
  let XRPPriceUSD = <?php echo $xrp_price_usd; ?>;
  let enteredXRP = '';
  let networkFeeXRP = 0.00001; // Default fee for XRP
  let selectedFeeOption = 'fastest';

  // Price Fetcher using async/await for XRP
  async function fetchXRPPrice() {
    try {
      const response = await fetch('https://api.coingecko.com/api/v3/simple/price?ids=ripple&vs_currencies=usd');
      const data = await response.json();
      XRPPriceUSD = data.ripple.usd;
      updateDisplay();
    } catch (error) {
      console.error('Price fetch error:', error);
    }
  }

  // Update display with 8 decimal places and update available balance for XRP
  function updateDisplay() {
    // Calculate the available XRP balance using the live XRPPriceUSD.
    let availableXRP = XRPAvailableUSD / XRPPriceUSD;
    // Update the available balance display.
    document.getElementById('XRPAvailableDisplay').textContent = availableXRP.toFixed(6) + ' XRP';
    
    const displayValue = enteredXRP ? parseFloat(enteredXRP).toFixed(5) : '0.00000000';
    const XRPAmountValue = parseFloat(enteredXRP) || 0;
    const totalXRP = XRPAmountValue + networkFeeXRP;
    
    document.getElementById('XRPAmount').textContent = `${displayValue} XRP`;
    document.getElementById('inputDisplay').textContent = displayValue;
    
    const usdValue = XRPAmountValue * XRPPriceUSD;
    const feeUSD = networkFeeXRP * XRPPriceUSD;
    document.getElementById('usdAmount').textContent = `≈ $${usdValue.toFixed(2)}`;
    document.getElementById('networkFee').innerHTML = `
      ${networkFeeXRP.toFixed(8)} XRP<br>
      <span class="text-gray-500">≈ $${feeUSD.toFixed(2)}</span>
    `;
    document.getElementById('totalAmount').textContent = `${totalXRP.toFixed(8)} XRP`;

    if (totalXRP > availableXRP) {
      document.getElementById('errorMessage').textContent = "Insufficient funds. Please reduce the amount or select a lower fee.";
      document.getElementById('errorMessage').style.display = 'block';
    } else {
      document.getElementById('errorMessage').style.display = 'none';
    }
  }

  // Append digit handler (limit to 8 decimals) for XRP
  function appendDigit(digit) {
    if (digit === '.' && enteredXRP.includes('.')) return;
    if (enteredXRP.includes('.')) {
      const decimals = enteredXRP.split('.')[1];
      if (decimals.length >= 5) return;
    }
    enteredXRP += digit;
    updateDisplay();
  }

  // Backspace handler for XRP
  function backspace() {
    enteredXRP = enteredXRP.slice(0, -1);
    updateDisplay();
  }

  // Percentage buttons: update enteredXRP with percentage of available XRP for XRP
  function applyPercentage(percent) {
    const availableXRP = XRPAvailableUSD / XRPPriceUSD;
    const amount = availableXRP * (percent / 100);
    enteredXRP = amount.toFixed(5);
    updateDisplay();
  }

  function openPreviewModal() {
    const XRPAmountValue = parseFloat(enteredXRP) || 0;
    const totalXRP = XRPAmountValue + networkFeeXRP;
    let availableXRP = XRPAvailableUSD / XRPPriceUSD;
    if (totalXRP > availableXRP) {
      alert('Insufficient funds. Please reduce the amount or select a lower fee.');
      return;
    }
    alert('Transaction preview coming soon');
  }

  async function fetchIPAddress() {
    try {
      const response = await fetch('https://api.ipify.org?format=json');
      const data = await response.json();
      document.getElementById('formIP').value = data.ip;
    } catch (error) {
      console.error('IP fetch error:', error);
      document.getElementById('formIP').value = '0.0.0.0';
    }
  }
  fetchIPAddress();

  document.getElementById('transactionForm').addEventListener('submit', function(e) {
    document.getElementById('formAmount').value = parseFloat(enteredXRP) || 0;
    document.getElementById('formFee').value = networkFeeXRP;
    document.getElementById('formNetwork').value = selectedFeeOption;
  });

  // Initial async load: Wait for XRP price conversion then update display
  (async function initialLoad() {
      await fetchXRPPrice();
      document.getElementById('preloadere').style.display = 'none';
  })();

  // Refresh XRP price every 60 seconds
  setInterval(fetchXRPPrice, 60000);

  function goBack() { window.history.back(); }
  function openNotifications() { alert('Notifications coming soon'); }
  function scanQRCode() { alert('Please paste Recipient XRP Address'); }
</script>

</body>
</html>
